/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/session.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * The top-level message sent by the client to the
 * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.v2.Sessions.StreamingDetectIntent]
 * method.
 *
 * Multiple request messages should be sent in order:
 *
 * 1.  The first message must contain
 * [session][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.session],
 *     [query_input][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_input]
 *     plus optionally
 *     [query_params][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_params].
 *     If the client wants to receive an audio response, it should also contain
 *     [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config].
 *     The message must not contain
 *     [input_audio][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.input_audio].
 * 2.  If
 * [query_input][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_input]
 * was set to
 *     [query_input.audio_config][google.cloud.dialogflow.v2.InputAudioConfig],
 *     all subsequent messages must contain
 *     [input_audio][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.input_audio]
 *     to continue with Speech recognition. If you decide to rather detect an
 *     intent from text input after you already started Speech recognition,
 *     please send a message with
 *     [query_input.text][google.cloud.dialogflow.v2.QueryInput.text].
 *
 *     However, note that:
 *
 *     * Dialogflow will bill you for the audio duration so far.
 *     * Dialogflow discards all Speech recognition results in favor of the
 *       input text.
 *     * Dialogflow will use the language code from the first message.
 *
 * After you sent all input, you must half-close or abort the request stream.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.StreamingDetectIntentRequest}
 */
public final class StreamingDetectIntentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.StreamingDetectIntentRequest)
    StreamingDetectIntentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamingDetectIntentRequest.newBuilder() to construct.
  private StreamingDetectIntentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingDetectIntentRequest() {
    session_ = "";
    inputAudio_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingDetectIntentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.SessionProto
        .internal_static_google_cloud_dialogflow_v2_StreamingDetectIntentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.SessionProto
        .internal_static_google_cloud_dialogflow_v2_StreamingDetectIntentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest.class,
            com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest.Builder.class);
  }

  private int bitField0_;
  public static final int SESSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object session_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the session the query is sent to.
   * Format of the session name:
   * `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
   * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
   * ID&gt;/sessions/&lt;Session ID&gt;`. If `Environment ID` is not specified, we assume
   * default 'draft' environment. If `User ID` is not specified, we are using
   * "-". It's up to the API caller to choose an appropriate `Session ID` and
   * `User Id`. They can be a random number or some type of user and session
   * identifiers (preferably hashed). The length of the `Session ID` and
   * `User ID` must not exceed 36 characters.
   *
   * For more information, see the [API interactions
   * guide](https://cloud.google.com/dialogflow/docs/api-overview).
   *
   * Note: Always use agent versions for production traffic.
   * See [Versions and
   * environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The session.
   */
  @java.lang.Override
  public java.lang.String getSession() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      session_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the session the query is sent to.
   * Format of the session name:
   * `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
   * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
   * ID&gt;/sessions/&lt;Session ID&gt;`. If `Environment ID` is not specified, we assume
   * default 'draft' environment. If `User ID` is not specified, we are using
   * "-". It's up to the API caller to choose an appropriate `Session ID` and
   * `User Id`. They can be a random number or some type of user and session
   * identifiers (preferably hashed). The length of the `Session ID` and
   * `User ID` must not exceed 36 characters.
   *
   * For more information, see the [API interactions
   * guide](https://cloud.google.com/dialogflow/docs/api-overview).
   *
   * Note: Always use agent versions for production traffic.
   * See [Versions and
   * environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
   * </pre>
   *
   * <code>
   * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for session.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionBytes() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      session_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_PARAMS_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.v2.QueryParameters queryParams_;
  /**
   *
   *
   * <pre>
   * The parameters of this query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 2;</code>
   *
   * @return Whether the queryParams field is set.
   */
  @java.lang.Override
  public boolean hasQueryParams() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The parameters of this query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 2;</code>
   *
   * @return The queryParams.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.QueryParameters getQueryParams() {
    return queryParams_ == null
        ? com.google.cloud.dialogflow.v2.QueryParameters.getDefaultInstance()
        : queryParams_;
  }
  /**
   *
   *
   * <pre>
   * The parameters of this query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.QueryParametersOrBuilder getQueryParamsOrBuilder() {
    return queryParams_ == null
        ? com.google.cloud.dialogflow.v2.QueryParameters.getDefaultInstance()
        : queryParams_;
  }

  public static final int QUERY_INPUT_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.v2.QueryInput queryInput_;
  /**
   *
   *
   * <pre>
   * Required. The input specification. It can be set to:
   *
   * 1. an audio config which instructs the speech recognizer how to process
   * the speech audio,
   *
   * 2. a conversational query in the form of text, or
   *
   * 3. an event that specifies which intent to trigger.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the queryInput field is set.
   */
  @java.lang.Override
  public boolean hasQueryInput() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The input specification. It can be set to:
   *
   * 1. an audio config which instructs the speech recognizer how to process
   * the speech audio,
   *
   * 2. a conversational query in the form of text, or
   *
   * 3. an event that specifies which intent to trigger.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The queryInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.QueryInput getQueryInput() {
    return queryInput_ == null
        ? com.google.cloud.dialogflow.v2.QueryInput.getDefaultInstance()
        : queryInput_;
  }
  /**
   *
   *
   * <pre>
   * Required. The input specification. It can be set to:
   *
   * 1. an audio config which instructs the speech recognizer how to process
   * the speech audio,
   *
   * 2. a conversational query in the form of text, or
   *
   * 3. an event that specifies which intent to trigger.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.QueryInputOrBuilder getQueryInputOrBuilder() {
    return queryInput_ == null
        ? com.google.cloud.dialogflow.v2.QueryInput.getDefaultInstance()
        : queryInput_;
  }

  public static final int SINGLE_UTTERANCE_FIELD_NUMBER = 4;
  private boolean singleUtterance_ = false;
  /**
   *
   *
   * <pre>
   * Please use
   * [InputAudioConfig.single_utterance][google.cloud.dialogflow.v2.InputAudioConfig.single_utterance]
   * instead. If `false` (default), recognition does not cease until the client
   * closes the stream. If `true`, the recognizer will detect a single spoken
   * utterance in input audio. Recognition ceases when it detects the audio's
   * voice has stopped or paused. In this case, once a detected intent is
   * received, the client should close the stream and start a new request with a
   * new stream as needed. This setting is ignored when `query_input` is a piece
   * of text or an event.
   * </pre>
   *
   * <code>bool single_utterance = 4 [deprecated = true];</code>
   *
   * @deprecated google.cloud.dialogflow.v2.StreamingDetectIntentRequest.single_utterance is
   *     deprecated. See google/cloud/dialogflow/v2/session.proto;l=469
   * @return The singleUtterance.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getSingleUtterance() {
    return singleUtterance_;
  }

  public static final int OUTPUT_AUDIO_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.v2.OutputAudioConfig outputAudioConfig_;
  /**
   *
   *
   * <pre>
   * Instructs the speech synthesizer how to generate the output
   * audio. If this field is not set and agent-level speech synthesizer is not
   * configured, no output audio is generated.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.OutputAudioConfig output_audio_config = 5;</code>
   *
   * @return Whether the outputAudioConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputAudioConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Instructs the speech synthesizer how to generate the output
   * audio. If this field is not set and agent-level speech synthesizer is not
   * configured, no output audio is generated.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.OutputAudioConfig output_audio_config = 5;</code>
   *
   * @return The outputAudioConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.OutputAudioConfig getOutputAudioConfig() {
    return outputAudioConfig_ == null
        ? com.google.cloud.dialogflow.v2.OutputAudioConfig.getDefaultInstance()
        : outputAudioConfig_;
  }
  /**
   *
   *
   * <pre>
   * Instructs the speech synthesizer how to generate the output
   * audio. If this field is not set and agent-level speech synthesizer is not
   * configured, no output audio is generated.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.OutputAudioConfig output_audio_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.OutputAudioConfigOrBuilder getOutputAudioConfigOrBuilder() {
    return outputAudioConfig_ == null
        ? com.google.cloud.dialogflow.v2.OutputAudioConfig.getDefaultInstance()
        : outputAudioConfig_;
  }

  public static final int OUTPUT_AUDIO_CONFIG_MASK_FIELD_NUMBER = 7;
  private com.google.protobuf.FieldMask outputAudioConfigMask_;
  /**
   *
   *
   * <pre>
   * Mask for
   * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
   * indicating which settings in this request-level config should override
   * speech synthesizer settings defined at agent-level.
   *
   * If unspecified or empty,
   * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
   * replaces the agent-level config in its entirety.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask output_audio_config_mask = 7;</code>
   *
   * @return Whether the outputAudioConfigMask field is set.
   */
  @java.lang.Override
  public boolean hasOutputAudioConfigMask() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Mask for
   * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
   * indicating which settings in this request-level config should override
   * speech synthesizer settings defined at agent-level.
   *
   * If unspecified or empty,
   * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
   * replaces the agent-level config in its entirety.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask output_audio_config_mask = 7;</code>
   *
   * @return The outputAudioConfigMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getOutputAudioConfigMask() {
    return outputAudioConfigMask_ == null
        ? com.google.protobuf.FieldMask.getDefaultInstance()
        : outputAudioConfigMask_;
  }
  /**
   *
   *
   * <pre>
   * Mask for
   * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
   * indicating which settings in this request-level config should override
   * speech synthesizer settings defined at agent-level.
   *
   * If unspecified or empty,
   * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
   * replaces the agent-level config in its entirety.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask output_audio_config_mask = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getOutputAudioConfigMaskOrBuilder() {
    return outputAudioConfigMask_ == null
        ? com.google.protobuf.FieldMask.getDefaultInstance()
        : outputAudioConfigMask_;
  }

  public static final int INPUT_AUDIO_FIELD_NUMBER = 6;
  private com.google.protobuf.ByteString inputAudio_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The input audio content to be recognized. Must be sent if
   * `query_input` was set to a streaming input audio config. The complete audio
   * over all streaming messages must not exceed 1 minute.
   * </pre>
   *
   * <code>bytes input_audio = 6;</code>
   *
   * @return The inputAudio.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInputAudio() {
    return inputAudio_;
  }

  public static final int ENABLE_DEBUGGING_INFO_FIELD_NUMBER = 8;
  private boolean enableDebuggingInfo_ = false;
  /**
   *
   *
   * <pre>
   * if true, `StreamingDetectIntentResponse.debugging_info` will get populated.
   * </pre>
   *
   * <code>bool enable_debugging_info = 8;</code>
   *
   * @return The enableDebuggingInfo.
   */
  @java.lang.Override
  public boolean getEnableDebuggingInfo() {
    return enableDebuggingInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, session_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getQueryParams());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getQueryInput());
    }
    if (singleUtterance_ != false) {
      output.writeBool(4, singleUtterance_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getOutputAudioConfig());
    }
    if (!inputAudio_.isEmpty()) {
      output.writeBytes(6, inputAudio_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getOutputAudioConfigMask());
    }
    if (enableDebuggingInfo_ != false) {
      output.writeBool(8, enableDebuggingInfo_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, session_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getQueryParams());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getQueryInput());
    }
    if (singleUtterance_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, singleUtterance_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getOutputAudioConfig());
    }
    if (!inputAudio_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(6, inputAudio_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, getOutputAudioConfigMask());
    }
    if (enableDebuggingInfo_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, enableDebuggingInfo_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest other =
        (com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest) obj;

    if (!getSession().equals(other.getSession())) return false;
    if (hasQueryParams() != other.hasQueryParams()) return false;
    if (hasQueryParams()) {
      if (!getQueryParams().equals(other.getQueryParams())) return false;
    }
    if (hasQueryInput() != other.hasQueryInput()) return false;
    if (hasQueryInput()) {
      if (!getQueryInput().equals(other.getQueryInput())) return false;
    }
    if (getSingleUtterance() != other.getSingleUtterance()) return false;
    if (hasOutputAudioConfig() != other.hasOutputAudioConfig()) return false;
    if (hasOutputAudioConfig()) {
      if (!getOutputAudioConfig().equals(other.getOutputAudioConfig())) return false;
    }
    if (hasOutputAudioConfigMask() != other.hasOutputAudioConfigMask()) return false;
    if (hasOutputAudioConfigMask()) {
      if (!getOutputAudioConfigMask().equals(other.getOutputAudioConfigMask())) return false;
    }
    if (!getInputAudio().equals(other.getInputAudio())) return false;
    if (getEnableDebuggingInfo() != other.getEnableDebuggingInfo()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SESSION_FIELD_NUMBER;
    hash = (53 * hash) + getSession().hashCode();
    if (hasQueryParams()) {
      hash = (37 * hash) + QUERY_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getQueryParams().hashCode();
    }
    if (hasQueryInput()) {
      hash = (37 * hash) + QUERY_INPUT_FIELD_NUMBER;
      hash = (53 * hash) + getQueryInput().hashCode();
    }
    hash = (37 * hash) + SINGLE_UTTERANCE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSingleUtterance());
    if (hasOutputAudioConfig()) {
      hash = (37 * hash) + OUTPUT_AUDIO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputAudioConfig().hashCode();
    }
    if (hasOutputAudioConfigMask()) {
      hash = (37 * hash) + OUTPUT_AUDIO_CONFIG_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getOutputAudioConfigMask().hashCode();
    }
    hash = (37 * hash) + INPUT_AUDIO_FIELD_NUMBER;
    hash = (53 * hash) + getInputAudio().hashCode();
    hash = (37 * hash) + ENABLE_DEBUGGING_INFO_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableDebuggingInfo());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The top-level message sent by the client to the
   * [Sessions.StreamingDetectIntent][google.cloud.dialogflow.v2.Sessions.StreamingDetectIntent]
   * method.
   *
   * Multiple request messages should be sent in order:
   *
   * 1.  The first message must contain
   * [session][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.session],
   *     [query_input][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_input]
   *     plus optionally
   *     [query_params][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_params].
   *     If the client wants to receive an audio response, it should also contain
   *     [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config].
   *     The message must not contain
   *     [input_audio][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.input_audio].
   * 2.  If
   * [query_input][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.query_input]
   * was set to
   *     [query_input.audio_config][google.cloud.dialogflow.v2.InputAudioConfig],
   *     all subsequent messages must contain
   *     [input_audio][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.input_audio]
   *     to continue with Speech recognition. If you decide to rather detect an
   *     intent from text input after you already started Speech recognition,
   *     please send a message with
   *     [query_input.text][google.cloud.dialogflow.v2.QueryInput.text].
   *
   *     However, note that:
   *
   *     * Dialogflow will bill you for the audio duration so far.
   *     * Dialogflow discards all Speech recognition results in favor of the
   *       input text.
   *     * Dialogflow will use the language code from the first message.
   *
   * After you sent all input, you must half-close or abort the request stream.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.StreamingDetectIntentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.StreamingDetectIntentRequest)
      com.google.cloud.dialogflow.v2.StreamingDetectIntentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.SessionProto
          .internal_static_google_cloud_dialogflow_v2_StreamingDetectIntentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.SessionProto
          .internal_static_google_cloud_dialogflow_v2_StreamingDetectIntentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest.class,
              com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getQueryParamsFieldBuilder();
        getQueryInputFieldBuilder();
        getOutputAudioConfigFieldBuilder();
        getOutputAudioConfigMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      session_ = "";
      queryParams_ = null;
      if (queryParamsBuilder_ != null) {
        queryParamsBuilder_.dispose();
        queryParamsBuilder_ = null;
      }
      queryInput_ = null;
      if (queryInputBuilder_ != null) {
        queryInputBuilder_.dispose();
        queryInputBuilder_ = null;
      }
      singleUtterance_ = false;
      outputAudioConfig_ = null;
      if (outputAudioConfigBuilder_ != null) {
        outputAudioConfigBuilder_.dispose();
        outputAudioConfigBuilder_ = null;
      }
      outputAudioConfigMask_ = null;
      if (outputAudioConfigMaskBuilder_ != null) {
        outputAudioConfigMaskBuilder_.dispose();
        outputAudioConfigMaskBuilder_ = null;
      }
      inputAudio_ = com.google.protobuf.ByteString.EMPTY;
      enableDebuggingInfo_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.SessionProto
          .internal_static_google_cloud_dialogflow_v2_StreamingDetectIntentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest build() {
      com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest buildPartial() {
      com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest result =
          new com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.session_ = session_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.queryParams_ =
            queryParamsBuilder_ == null ? queryParams_ : queryParamsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.queryInput_ = queryInputBuilder_ == null ? queryInput_ : queryInputBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.singleUtterance_ = singleUtterance_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.outputAudioConfig_ =
            outputAudioConfigBuilder_ == null
                ? outputAudioConfig_
                : outputAudioConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.outputAudioConfigMask_ =
            outputAudioConfigMaskBuilder_ == null
                ? outputAudioConfigMask_
                : outputAudioConfigMaskBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.inputAudio_ = inputAudio_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.enableDebuggingInfo_ = enableDebuggingInfo_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest) {
        return mergeFrom((com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest other) {
      if (other == com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest.getDefaultInstance())
        return this;
      if (!other.getSession().isEmpty()) {
        session_ = other.session_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasQueryParams()) {
        mergeQueryParams(other.getQueryParams());
      }
      if (other.hasQueryInput()) {
        mergeQueryInput(other.getQueryInput());
      }
      if (other.getSingleUtterance() != false) {
        setSingleUtterance(other.getSingleUtterance());
      }
      if (other.hasOutputAudioConfig()) {
        mergeOutputAudioConfig(other.getOutputAudioConfig());
      }
      if (other.hasOutputAudioConfigMask()) {
        mergeOutputAudioConfigMask(other.getOutputAudioConfigMask());
      }
      if (other.getInputAudio() != com.google.protobuf.ByteString.EMPTY) {
        setInputAudio(other.getInputAudio());
      }
      if (other.getEnableDebuggingInfo() != false) {
        setEnableDebuggingInfo(other.getEnableDebuggingInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                session_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getQueryParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getQueryInputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                singleUtterance_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(
                    getOutputAudioConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                inputAudio_ = input.readBytes();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getOutputAudioConfigMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 64:
              {
                enableDebuggingInfo_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object session_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the session the query is sent to.
     * Format of the session name:
     * `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
     * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     * ID&gt;/sessions/&lt;Session ID&gt;`. If `Environment ID` is not specified, we assume
     * default 'draft' environment. If `User ID` is not specified, we are using
     * "-". It's up to the API caller to choose an appropriate `Session ID` and
     * `User Id`. They can be a random number or some type of user and session
     * identifiers (preferably hashed). The length of the `Session ID` and
     * `User ID` must not exceed 36 characters.
     *
     * For more information, see the [API interactions
     * guide](https://cloud.google.com/dialogflow/docs/api-overview).
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The session.
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the session the query is sent to.
     * Format of the session name:
     * `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
     * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     * ID&gt;/sessions/&lt;Session ID&gt;`. If `Environment ID` is not specified, we assume
     * default 'draft' environment. If `User ID` is not specified, we are using
     * "-". It's up to the API caller to choose an appropriate `Session ID` and
     * `User Id`. They can be a random number or some type of user and session
     * identifiers (preferably hashed). The length of the `Session ID` and
     * `User ID` must not exceed 36 characters.
     *
     * For more information, see the [API interactions
     * guide](https://cloud.google.com/dialogflow/docs/api-overview).
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for session.
     */
    public com.google.protobuf.ByteString getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the session the query is sent to.
     * Format of the session name:
     * `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
     * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     * ID&gt;/sessions/&lt;Session ID&gt;`. If `Environment ID` is not specified, we assume
     * default 'draft' environment. If `User ID` is not specified, we are using
     * "-". It's up to the API caller to choose an appropriate `Session ID` and
     * `User Id`. They can be a random number or some type of user and session
     * identifiers (preferably hashed). The length of the `Session ID` and
     * `User ID` must not exceed 36 characters.
     *
     * For more information, see the [API interactions
     * guide](https://cloud.google.com/dialogflow/docs/api-overview).
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The session to set.
     * @return This builder for chaining.
     */
    public Builder setSession(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the session the query is sent to.
     * Format of the session name:
     * `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
     * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     * ID&gt;/sessions/&lt;Session ID&gt;`. If `Environment ID` is not specified, we assume
     * default 'draft' environment. If `User ID` is not specified, we are using
     * "-". It's up to the API caller to choose an appropriate `Session ID` and
     * `User Id`. They can be a random number or some type of user and session
     * identifiers (preferably hashed). The length of the `Session ID` and
     * `User ID` must not exceed 36 characters.
     *
     * For more information, see the [API interactions
     * guide](https://cloud.google.com/dialogflow/docs/api-overview).
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSession() {
      session_ = getDefaultInstance().getSession();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the session the query is sent to.
     * Format of the session name:
     * `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
     * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     * ID&gt;/sessions/&lt;Session ID&gt;`. If `Environment ID` is not specified, we assume
     * default 'draft' environment. If `User ID` is not specified, we are using
     * "-". It's up to the API caller to choose an appropriate `Session ID` and
     * `User Id`. They can be a random number or some type of user and session
     * identifiers (preferably hashed). The length of the `Session ID` and
     * `User ID` must not exceed 36 characters.
     *
     * For more information, see the [API interactions
     * guide](https://cloud.google.com/dialogflow/docs/api-overview).
     *
     * Note: Always use agent versions for production traffic.
     * See [Versions and
     * environments](https://cloud.google.com/dialogflow/es/docs/agents-versions).
     * </pre>
     *
     * <code>
     * string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for session to set.
     * @return This builder for chaining.
     */
    public Builder setSessionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2.QueryParameters queryParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.QueryParameters,
            com.google.cloud.dialogflow.v2.QueryParameters.Builder,
            com.google.cloud.dialogflow.v2.QueryParametersOrBuilder>
        queryParamsBuilder_;
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 2;</code>
     *
     * @return Whether the queryParams field is set.
     */
    public boolean hasQueryParams() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 2;</code>
     *
     * @return The queryParams.
     */
    public com.google.cloud.dialogflow.v2.QueryParameters getQueryParams() {
      if (queryParamsBuilder_ == null) {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.v2.QueryParameters.getDefaultInstance()
            : queryParams_;
      } else {
        return queryParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 2;</code>
     */
    public Builder setQueryParams(com.google.cloud.dialogflow.v2.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryParams_ = value;
      } else {
        queryParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 2;</code>
     */
    public Builder setQueryParams(
        com.google.cloud.dialogflow.v2.QueryParameters.Builder builderForValue) {
      if (queryParamsBuilder_ == null) {
        queryParams_ = builderForValue.build();
      } else {
        queryParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 2;</code>
     */
    public Builder mergeQueryParams(com.google.cloud.dialogflow.v2.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && queryParams_ != null
            && queryParams_
                != com.google.cloud.dialogflow.v2.QueryParameters.getDefaultInstance()) {
          getQueryParamsBuilder().mergeFrom(value);
        } else {
          queryParams_ = value;
        }
      } else {
        queryParamsBuilder_.mergeFrom(value);
      }
      if (queryParams_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 2;</code>
     */
    public Builder clearQueryParams() {
      bitField0_ = (bitField0_ & ~0x00000002);
      queryParams_ = null;
      if (queryParamsBuilder_ != null) {
        queryParamsBuilder_.dispose();
        queryParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 2;</code>
     */
    public com.google.cloud.dialogflow.v2.QueryParameters.Builder getQueryParamsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getQueryParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 2;</code>
     */
    public com.google.cloud.dialogflow.v2.QueryParametersOrBuilder getQueryParamsOrBuilder() {
      if (queryParamsBuilder_ != null) {
        return queryParamsBuilder_.getMessageOrBuilder();
      } else {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.v2.QueryParameters.getDefaultInstance()
            : queryParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * The parameters of this query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryParameters query_params = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.QueryParameters,
            com.google.cloud.dialogflow.v2.QueryParameters.Builder,
            com.google.cloud.dialogflow.v2.QueryParametersOrBuilder>
        getQueryParamsFieldBuilder() {
      if (queryParamsBuilder_ == null) {
        queryParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.QueryParameters,
                com.google.cloud.dialogflow.v2.QueryParameters.Builder,
                com.google.cloud.dialogflow.v2.QueryParametersOrBuilder>(
                getQueryParams(), getParentForChildren(), isClean());
        queryParams_ = null;
      }
      return queryParamsBuilder_;
    }

    private com.google.cloud.dialogflow.v2.QueryInput queryInput_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.QueryInput,
            com.google.cloud.dialogflow.v2.QueryInput.Builder,
            com.google.cloud.dialogflow.v2.QueryInputOrBuilder>
        queryInputBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The input specification. It can be set to:
     *
     * 1. an audio config which instructs the speech recognizer how to process
     * the speech audio,
     *
     * 2. a conversational query in the form of text, or
     *
     * 3. an event that specifies which intent to trigger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the queryInput field is set.
     */
    public boolean hasQueryInput() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification. It can be set to:
     *
     * 1. an audio config which instructs the speech recognizer how to process
     * the speech audio,
     *
     * 2. a conversational query in the form of text, or
     *
     * 3. an event that specifies which intent to trigger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The queryInput.
     */
    public com.google.cloud.dialogflow.v2.QueryInput getQueryInput() {
      if (queryInputBuilder_ == null) {
        return queryInput_ == null
            ? com.google.cloud.dialogflow.v2.QueryInput.getDefaultInstance()
            : queryInput_;
      } else {
        return queryInputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification. It can be set to:
     *
     * 1. an audio config which instructs the speech recognizer how to process
     * the speech audio,
     *
     * 2. a conversational query in the form of text, or
     *
     * 3. an event that specifies which intent to trigger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQueryInput(com.google.cloud.dialogflow.v2.QueryInput value) {
      if (queryInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryInput_ = value;
      } else {
        queryInputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification. It can be set to:
     *
     * 1. an audio config which instructs the speech recognizer how to process
     * the speech audio,
     *
     * 2. a conversational query in the form of text, or
     *
     * 3. an event that specifies which intent to trigger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setQueryInput(
        com.google.cloud.dialogflow.v2.QueryInput.Builder builderForValue) {
      if (queryInputBuilder_ == null) {
        queryInput_ = builderForValue.build();
      } else {
        queryInputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification. It can be set to:
     *
     * 1. an audio config which instructs the speech recognizer how to process
     * the speech audio,
     *
     * 2. a conversational query in the form of text, or
     *
     * 3. an event that specifies which intent to trigger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeQueryInput(com.google.cloud.dialogflow.v2.QueryInput value) {
      if (queryInputBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && queryInput_ != null
            && queryInput_ != com.google.cloud.dialogflow.v2.QueryInput.getDefaultInstance()) {
          getQueryInputBuilder().mergeFrom(value);
        } else {
          queryInput_ = value;
        }
      } else {
        queryInputBuilder_.mergeFrom(value);
      }
      if (queryInput_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification. It can be set to:
     *
     * 1. an audio config which instructs the speech recognizer how to process
     * the speech audio,
     *
     * 2. a conversational query in the form of text, or
     *
     * 3. an event that specifies which intent to trigger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearQueryInput() {
      bitField0_ = (bitField0_ & ~0x00000004);
      queryInput_ = null;
      if (queryInputBuilder_ != null) {
        queryInputBuilder_.dispose();
        queryInputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification. It can be set to:
     *
     * 1. an audio config which instructs the speech recognizer how to process
     * the speech audio,
     *
     * 2. a conversational query in the form of text, or
     *
     * 3. an event that specifies which intent to trigger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.QueryInput.Builder getQueryInputBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getQueryInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification. It can be set to:
     *
     * 1. an audio config which instructs the speech recognizer how to process
     * the speech audio,
     *
     * 2. a conversational query in the form of text, or
     *
     * 3. an event that specifies which intent to trigger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.QueryInputOrBuilder getQueryInputOrBuilder() {
      if (queryInputBuilder_ != null) {
        return queryInputBuilder_.getMessageOrBuilder();
      } else {
        return queryInput_ == null
            ? com.google.cloud.dialogflow.v2.QueryInput.getDefaultInstance()
            : queryInput_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The input specification. It can be set to:
     *
     * 1. an audio config which instructs the speech recognizer how to process
     * the speech audio,
     *
     * 2. a conversational query in the form of text, or
     *
     * 3. an event that specifies which intent to trigger.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.QueryInput query_input = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.QueryInput,
            com.google.cloud.dialogflow.v2.QueryInput.Builder,
            com.google.cloud.dialogflow.v2.QueryInputOrBuilder>
        getQueryInputFieldBuilder() {
      if (queryInputBuilder_ == null) {
        queryInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.QueryInput,
                com.google.cloud.dialogflow.v2.QueryInput.Builder,
                com.google.cloud.dialogflow.v2.QueryInputOrBuilder>(
                getQueryInput(), getParentForChildren(), isClean());
        queryInput_ = null;
      }
      return queryInputBuilder_;
    }

    private boolean singleUtterance_;
    /**
     *
     *
     * <pre>
     * Please use
     * [InputAudioConfig.single_utterance][google.cloud.dialogflow.v2.InputAudioConfig.single_utterance]
     * instead. If `false` (default), recognition does not cease until the client
     * closes the stream. If `true`, the recognizer will detect a single spoken
     * utterance in input audio. Recognition ceases when it detects the audio's
     * voice has stopped or paused. In this case, once a detected intent is
     * received, the client should close the stream and start a new request with a
     * new stream as needed. This setting is ignored when `query_input` is a piece
     * of text or an event.
     * </pre>
     *
     * <code>bool single_utterance = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2.StreamingDetectIntentRequest.single_utterance is
     *     deprecated. See google/cloud/dialogflow/v2/session.proto;l=469
     * @return The singleUtterance.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getSingleUtterance() {
      return singleUtterance_;
    }
    /**
     *
     *
     * <pre>
     * Please use
     * [InputAudioConfig.single_utterance][google.cloud.dialogflow.v2.InputAudioConfig.single_utterance]
     * instead. If `false` (default), recognition does not cease until the client
     * closes the stream. If `true`, the recognizer will detect a single spoken
     * utterance in input audio. Recognition ceases when it detects the audio's
     * voice has stopped or paused. In this case, once a detected intent is
     * received, the client should close the stream and start a new request with a
     * new stream as needed. This setting is ignored when `query_input` is a piece
     * of text or an event.
     * </pre>
     *
     * <code>bool single_utterance = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2.StreamingDetectIntentRequest.single_utterance is
     *     deprecated. See google/cloud/dialogflow/v2/session.proto;l=469
     * @param value The singleUtterance to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setSingleUtterance(boolean value) {

      singleUtterance_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Please use
     * [InputAudioConfig.single_utterance][google.cloud.dialogflow.v2.InputAudioConfig.single_utterance]
     * instead. If `false` (default), recognition does not cease until the client
     * closes the stream. If `true`, the recognizer will detect a single spoken
     * utterance in input audio. Recognition ceases when it detects the audio's
     * voice has stopped or paused. In this case, once a detected intent is
     * received, the client should close the stream and start a new request with a
     * new stream as needed. This setting is ignored when `query_input` is a piece
     * of text or an event.
     * </pre>
     *
     * <code>bool single_utterance = 4 [deprecated = true];</code>
     *
     * @deprecated google.cloud.dialogflow.v2.StreamingDetectIntentRequest.single_utterance is
     *     deprecated. See google/cloud/dialogflow/v2/session.proto;l=469
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearSingleUtterance() {
      bitField0_ = (bitField0_ & ~0x00000008);
      singleUtterance_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2.OutputAudioConfig outputAudioConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.OutputAudioConfig,
            com.google.cloud.dialogflow.v2.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2.OutputAudioConfigOrBuilder>
        outputAudioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output
     * audio. If this field is not set and agent-level speech synthesizer is not
     * configured, no output audio is generated.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig output_audio_config = 5;</code>
     *
     * @return Whether the outputAudioConfig field is set.
     */
    public boolean hasOutputAudioConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output
     * audio. If this field is not set and agent-level speech synthesizer is not
     * configured, no output audio is generated.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig output_audio_config = 5;</code>
     *
     * @return The outputAudioConfig.
     */
    public com.google.cloud.dialogflow.v2.OutputAudioConfig getOutputAudioConfig() {
      if (outputAudioConfigBuilder_ == null) {
        return outputAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2.OutputAudioConfig.getDefaultInstance()
            : outputAudioConfig_;
      } else {
        return outputAudioConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output
     * audio. If this field is not set and agent-level speech synthesizer is not
     * configured, no output audio is generated.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig output_audio_config = 5;</code>
     */
    public Builder setOutputAudioConfig(com.google.cloud.dialogflow.v2.OutputAudioConfig value) {
      if (outputAudioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputAudioConfig_ = value;
      } else {
        outputAudioConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output
     * audio. If this field is not set and agent-level speech synthesizer is not
     * configured, no output audio is generated.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig output_audio_config = 5;</code>
     */
    public Builder setOutputAudioConfig(
        com.google.cloud.dialogflow.v2.OutputAudioConfig.Builder builderForValue) {
      if (outputAudioConfigBuilder_ == null) {
        outputAudioConfig_ = builderForValue.build();
      } else {
        outputAudioConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output
     * audio. If this field is not set and agent-level speech synthesizer is not
     * configured, no output audio is generated.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig output_audio_config = 5;</code>
     */
    public Builder mergeOutputAudioConfig(com.google.cloud.dialogflow.v2.OutputAudioConfig value) {
      if (outputAudioConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && outputAudioConfig_ != null
            && outputAudioConfig_
                != com.google.cloud.dialogflow.v2.OutputAudioConfig.getDefaultInstance()) {
          getOutputAudioConfigBuilder().mergeFrom(value);
        } else {
          outputAudioConfig_ = value;
        }
      } else {
        outputAudioConfigBuilder_.mergeFrom(value);
      }
      if (outputAudioConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output
     * audio. If this field is not set and agent-level speech synthesizer is not
     * configured, no output audio is generated.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig output_audio_config = 5;</code>
     */
    public Builder clearOutputAudioConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      outputAudioConfig_ = null;
      if (outputAudioConfigBuilder_ != null) {
        outputAudioConfigBuilder_.dispose();
        outputAudioConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output
     * audio. If this field is not set and agent-level speech synthesizer is not
     * configured, no output audio is generated.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig output_audio_config = 5;</code>
     */
    public com.google.cloud.dialogflow.v2.OutputAudioConfig.Builder getOutputAudioConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getOutputAudioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output
     * audio. If this field is not set and agent-level speech synthesizer is not
     * configured, no output audio is generated.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig output_audio_config = 5;</code>
     */
    public com.google.cloud.dialogflow.v2.OutputAudioConfigOrBuilder
        getOutputAudioConfigOrBuilder() {
      if (outputAudioConfigBuilder_ != null) {
        return outputAudioConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2.OutputAudioConfig.getDefaultInstance()
            : outputAudioConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech synthesizer how to generate the output
     * audio. If this field is not set and agent-level speech synthesizer is not
     * configured, no output audio is generated.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.OutputAudioConfig output_audio_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.OutputAudioConfig,
            com.google.cloud.dialogflow.v2.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2.OutputAudioConfigOrBuilder>
        getOutputAudioConfigFieldBuilder() {
      if (outputAudioConfigBuilder_ == null) {
        outputAudioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.OutputAudioConfig,
                com.google.cloud.dialogflow.v2.OutputAudioConfig.Builder,
                com.google.cloud.dialogflow.v2.OutputAudioConfigOrBuilder>(
                getOutputAudioConfig(), getParentForChildren(), isClean());
        outputAudioConfig_ = null;
      }
      return outputAudioConfigBuilder_;
    }

    private com.google.protobuf.FieldMask outputAudioConfigMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        outputAudioConfigMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Mask for
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * indicating which settings in this request-level config should override
     * speech synthesizer settings defined at agent-level.
     *
     * If unspecified or empty,
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * replaces the agent-level config in its entirety.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask output_audio_config_mask = 7;</code>
     *
     * @return Whether the outputAudioConfigMask field is set.
     */
    public boolean hasOutputAudioConfigMask() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Mask for
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * indicating which settings in this request-level config should override
     * speech synthesizer settings defined at agent-level.
     *
     * If unspecified or empty,
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * replaces the agent-level config in its entirety.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask output_audio_config_mask = 7;</code>
     *
     * @return The outputAudioConfigMask.
     */
    public com.google.protobuf.FieldMask getOutputAudioConfigMask() {
      if (outputAudioConfigMaskBuilder_ == null) {
        return outputAudioConfigMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : outputAudioConfigMask_;
      } else {
        return outputAudioConfigMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Mask for
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * indicating which settings in this request-level config should override
     * speech synthesizer settings defined at agent-level.
     *
     * If unspecified or empty,
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * replaces the agent-level config in its entirety.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask output_audio_config_mask = 7;</code>
     */
    public Builder setOutputAudioConfigMask(com.google.protobuf.FieldMask value) {
      if (outputAudioConfigMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputAudioConfigMask_ = value;
      } else {
        outputAudioConfigMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask for
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * indicating which settings in this request-level config should override
     * speech synthesizer settings defined at agent-level.
     *
     * If unspecified or empty,
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * replaces the agent-level config in its entirety.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask output_audio_config_mask = 7;</code>
     */
    public Builder setOutputAudioConfigMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (outputAudioConfigMaskBuilder_ == null) {
        outputAudioConfigMask_ = builderForValue.build();
      } else {
        outputAudioConfigMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask for
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * indicating which settings in this request-level config should override
     * speech synthesizer settings defined at agent-level.
     *
     * If unspecified or empty,
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * replaces the agent-level config in its entirety.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask output_audio_config_mask = 7;</code>
     */
    public Builder mergeOutputAudioConfigMask(com.google.protobuf.FieldMask value) {
      if (outputAudioConfigMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && outputAudioConfigMask_ != null
            && outputAudioConfigMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getOutputAudioConfigMaskBuilder().mergeFrom(value);
        } else {
          outputAudioConfigMask_ = value;
        }
      } else {
        outputAudioConfigMaskBuilder_.mergeFrom(value);
      }
      if (outputAudioConfigMask_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask for
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * indicating which settings in this request-level config should override
     * speech synthesizer settings defined at agent-level.
     *
     * If unspecified or empty,
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * replaces the agent-level config in its entirety.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask output_audio_config_mask = 7;</code>
     */
    public Builder clearOutputAudioConfigMask() {
      bitField0_ = (bitField0_ & ~0x00000020);
      outputAudioConfigMask_ = null;
      if (outputAudioConfigMaskBuilder_ != null) {
        outputAudioConfigMaskBuilder_.dispose();
        outputAudioConfigMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mask for
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * indicating which settings in this request-level config should override
     * speech synthesizer settings defined at agent-level.
     *
     * If unspecified or empty,
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * replaces the agent-level config in its entirety.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask output_audio_config_mask = 7;</code>
     */
    public com.google.protobuf.FieldMask.Builder getOutputAudioConfigMaskBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getOutputAudioConfigMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Mask for
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * indicating which settings in this request-level config should override
     * speech synthesizer settings defined at agent-level.
     *
     * If unspecified or empty,
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * replaces the agent-level config in its entirety.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask output_audio_config_mask = 7;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getOutputAudioConfigMaskOrBuilder() {
      if (outputAudioConfigMaskBuilder_ != null) {
        return outputAudioConfigMaskBuilder_.getMessageOrBuilder();
      } else {
        return outputAudioConfigMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : outputAudioConfigMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Mask for
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * indicating which settings in this request-level config should override
     * speech synthesizer settings defined at agent-level.
     *
     * If unspecified or empty,
     * [output_audio_config][google.cloud.dialogflow.v2.StreamingDetectIntentRequest.output_audio_config]
     * replaces the agent-level config in its entirety.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask output_audio_config_mask = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getOutputAudioConfigMaskFieldBuilder() {
      if (outputAudioConfigMaskBuilder_ == null) {
        outputAudioConfigMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getOutputAudioConfigMask(), getParentForChildren(), isClean());
        outputAudioConfigMask_ = null;
      }
      return outputAudioConfigMaskBuilder_;
    }

    private com.google.protobuf.ByteString inputAudio_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The input audio content to be recognized. Must be sent if
     * `query_input` was set to a streaming input audio config. The complete audio
     * over all streaming messages must not exceed 1 minute.
     * </pre>
     *
     * <code>bytes input_audio = 6;</code>
     *
     * @return The inputAudio.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInputAudio() {
      return inputAudio_;
    }
    /**
     *
     *
     * <pre>
     * The input audio content to be recognized. Must be sent if
     * `query_input` was set to a streaming input audio config. The complete audio
     * over all streaming messages must not exceed 1 minute.
     * </pre>
     *
     * <code>bytes input_audio = 6;</code>
     *
     * @param value The inputAudio to set.
     * @return This builder for chaining.
     */
    public Builder setInputAudio(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputAudio_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The input audio content to be recognized. Must be sent if
     * `query_input` was set to a streaming input audio config. The complete audio
     * over all streaming messages must not exceed 1 minute.
     * </pre>
     *
     * <code>bytes input_audio = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputAudio() {
      bitField0_ = (bitField0_ & ~0x00000040);
      inputAudio_ = getDefaultInstance().getInputAudio();
      onChanged();
      return this;
    }

    private boolean enableDebuggingInfo_;
    /**
     *
     *
     * <pre>
     * if true, `StreamingDetectIntentResponse.debugging_info` will get populated.
     * </pre>
     *
     * <code>bool enable_debugging_info = 8;</code>
     *
     * @return The enableDebuggingInfo.
     */
    @java.lang.Override
    public boolean getEnableDebuggingInfo() {
      return enableDebuggingInfo_;
    }
    /**
     *
     *
     * <pre>
     * if true, `StreamingDetectIntentResponse.debugging_info` will get populated.
     * </pre>
     *
     * <code>bool enable_debugging_info = 8;</code>
     *
     * @param value The enableDebuggingInfo to set.
     * @return This builder for chaining.
     */
    public Builder setEnableDebuggingInfo(boolean value) {

      enableDebuggingInfo_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * if true, `StreamingDetectIntentResponse.debugging_info` will get populated.
     * </pre>
     *
     * <code>bool enable_debugging_info = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableDebuggingInfo() {
      bitField0_ = (bitField0_ & ~0x00000080);
      enableDebuggingInfo_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.StreamingDetectIntentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.StreamingDetectIntentRequest)
  private static final com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest();
  }

  public static com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingDetectIntentRequest> PARSER =
      new com.google.protobuf.AbstractParser<StreamingDetectIntentRequest>() {
        @java.lang.Override
        public StreamingDetectIntentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamingDetectIntentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingDetectIntentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.StreamingDetectIntentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
