/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ContextName
implements ResourceName {
    private static final PathTemplate PROJECT_SESSION_CONTEXT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/sessions/{session}/contexts/{context}");
    private static final PathTemplate PROJECT_ENVIRONMENT_USER_SESSION_CONTEXT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}");
    private static final PathTemplate PROJECT_LOCATION_SESSION_CONTEXT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agent/sessions/{session}/contexts/{context}");
    private static final PathTemplate PROJECT_LOCATION_ENVIRONMENT_USER_SESSION_CONTEXT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String session;
    private final String context;
    private final String environment;
    private final String user;
    private final String location;

    @Deprecated
    protected ContextName() {
        this.project = null;
        this.session = null;
        this.context = null;
        this.environment = null;
        this.user = null;
        this.location = null;
    }

    private ContextName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.context = (String)Preconditions.checkNotNull((Object)builder.getContext());
        this.environment = null;
        this.user = null;
        this.location = null;
        this.pathTemplate = PROJECT_SESSION_CONTEXT;
    }

    private ContextName(ProjectEnvironmentUserSessionContextBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.context = (String)Preconditions.checkNotNull((Object)builder.getContext());
        this.location = null;
        this.pathTemplate = PROJECT_ENVIRONMENT_USER_SESSION_CONTEXT;
    }

    private ContextName(ProjectLocationSessionContextBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.context = (String)Preconditions.checkNotNull((Object)builder.getContext());
        this.environment = null;
        this.user = null;
        this.pathTemplate = PROJECT_LOCATION_SESSION_CONTEXT;
    }

    private ContextName(ProjectLocationEnvironmentUserSessionContextBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.context = (String)Preconditions.checkNotNull((Object)builder.getContext());
        this.pathTemplate = PROJECT_LOCATION_ENVIRONMENT_USER_SESSION_CONTEXT;
    }

    public String getProject() {
        return this.project;
    }

    public String getSession() {
        return this.session;
    }

    public String getContext() {
        return this.context;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getUser() {
        return this.user;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectSessionContextBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectEnvironmentUserSessionContextBuilder newProjectEnvironmentUserSessionContextBuilder() {
        return new ProjectEnvironmentUserSessionContextBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationSessionContextBuilder newProjectLocationSessionContextBuilder() {
        return new ProjectLocationSessionContextBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationEnvironmentUserSessionContextBuilder newProjectLocationEnvironmentUserSessionContextBuilder() {
        return new ProjectLocationEnvironmentUserSessionContextBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ContextName of(String project, String session, String context) {
        return ContextName.newBuilder().setProject(project).setSession(session).setContext(context).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ContextName ofProjectSessionContextName(String project, String session, String context) {
        return ContextName.newBuilder().setProject(project).setSession(session).setContext(context).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ContextName ofProjectEnvironmentUserSessionContextName(String project, String environment, String user, String session, String context) {
        return ContextName.newProjectEnvironmentUserSessionContextBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).setContext(context).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ContextName ofProjectLocationSessionContextName(String project, String location, String session, String context) {
        return ContextName.newProjectLocationSessionContextBuilder().setProject(project).setLocation(location).setSession(session).setContext(context).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ContextName ofProjectLocationEnvironmentUserSessionContextName(String project, String location, String environment, String user, String session, String context) {
        return ContextName.newProjectLocationEnvironmentUserSessionContextBuilder().setProject(project).setLocation(location).setEnvironment(environment).setUser(user).setSession(session).setContext(context).build();
    }

    public static String format(String project, String session, String context) {
        return ContextName.newBuilder().setProject(project).setSession(session).setContext(context).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectSessionContextName(String project, String session, String context) {
        return ContextName.newBuilder().setProject(project).setSession(session).setContext(context).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectEnvironmentUserSessionContextName(String project, String environment, String user, String session, String context) {
        return ContextName.newProjectEnvironmentUserSessionContextBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).setContext(context).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationSessionContextName(String project, String location, String session, String context) {
        return ContextName.newProjectLocationSessionContextBuilder().setProject(project).setLocation(location).setSession(session).setContext(context).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationEnvironmentUserSessionContextName(String project, String location, String environment, String user, String session, String context) {
        return ContextName.newProjectLocationEnvironmentUserSessionContextBuilder().setProject(project).setLocation(location).setEnvironment(environment).setUser(user).setSession(session).setContext(context).build().toString();
    }

    public static ContextName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_SESSION_CONTEXT.matches(formattedString)) {
            Map matchMap = PROJECT_SESSION_CONTEXT.match(formattedString);
            return ContextName.ofProjectSessionContextName((String)matchMap.get("project"), (String)matchMap.get("session"), (String)matchMap.get("context"));
        }
        if (PROJECT_ENVIRONMENT_USER_SESSION_CONTEXT.matches(formattedString)) {
            Map matchMap = PROJECT_ENVIRONMENT_USER_SESSION_CONTEXT.match(formattedString);
            return ContextName.ofProjectEnvironmentUserSessionContextName((String)matchMap.get("project"), (String)matchMap.get("environment"), (String)matchMap.get("user"), (String)matchMap.get("session"), (String)matchMap.get("context"));
        }
        if (PROJECT_LOCATION_SESSION_CONTEXT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_SESSION_CONTEXT.match(formattedString);
            return ContextName.ofProjectLocationSessionContextName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("session"), (String)matchMap.get("context"));
        }
        if (PROJECT_LOCATION_ENVIRONMENT_USER_SESSION_CONTEXT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_ENVIRONMENT_USER_SESSION_CONTEXT.match(formattedString);
            return ContextName.ofProjectLocationEnvironmentUserSessionContextName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("environment"), (String)matchMap.get("user"), (String)matchMap.get("session"), (String)matchMap.get("context"));
        }
        throw new ValidationException("ContextName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ContextName> parseList(List<String> formattedStrings) {
        ArrayList<ContextName> list = new ArrayList<ContextName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ContextName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ContextName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ContextName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SESSION_CONTEXT.matches(formattedString) || PROJECT_ENVIRONMENT_USER_SESSION_CONTEXT.matches(formattedString) || PROJECT_LOCATION_SESSION_CONTEXT.matches(formattedString) || PROJECT_LOCATION_ENVIRONMENT_USER_SESSION_CONTEXT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ContextName contextName = this;
            synchronized (contextName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.session != null) {
                        fieldMapBuilder.put((Object)"session", (Object)this.session);
                    }
                    if (this.context != null) {
                        fieldMapBuilder.put((Object)"context", (Object)this.context);
                    }
                    if (this.environment != null) {
                        fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    }
                    if (this.user != null) {
                        fieldMapBuilder.put((Object)"user", (Object)this.user);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ContextName that = (ContextName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.session, that.session) && Objects.equals(this.context, that.context) && Objects.equals(this.environment, that.environment) && Objects.equals(this.user, that.user) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.session);
        h *= 1000003;
        h ^= Objects.hashCode(this.context);
        h *= 1000003;
        h ^= Objects.hashCode(this.environment);
        h *= 1000003;
        h ^= Objects.hashCode(this.user);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationEnvironmentUserSessionContextBuilder {
        private String project;
        private String location;
        private String environment;
        private String user;
        private String session;
        private String context;

        protected ProjectLocationEnvironmentUserSessionContextBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getUser() {
            return this.user;
        }

        public String getSession() {
            return this.session;
        }

        public String getContext() {
            return this.context;
        }

        public ProjectLocationEnvironmentUserSessionContextBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionContextBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionContextBuilder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionContextBuilder setUser(String user) {
            this.user = user;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionContextBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionContextBuilder setContext(String context) {
            this.context = context;
            return this;
        }

        public ContextName build() {
            return new ContextName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationSessionContextBuilder {
        private String project;
        private String location;
        private String session;
        private String context;

        protected ProjectLocationSessionContextBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSession() {
            return this.session;
        }

        public String getContext() {
            return this.context;
        }

        public ProjectLocationSessionContextBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationSessionContextBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationSessionContextBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public ProjectLocationSessionContextBuilder setContext(String context) {
            this.context = context;
            return this;
        }

        public ContextName build() {
            return new ContextName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectEnvironmentUserSessionContextBuilder {
        private String project;
        private String environment;
        private String user;
        private String session;
        private String context;

        protected ProjectEnvironmentUserSessionContextBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getUser() {
            return this.user;
        }

        public String getSession() {
            return this.session;
        }

        public String getContext() {
            return this.context;
        }

        public ProjectEnvironmentUserSessionContextBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectEnvironmentUserSessionContextBuilder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public ProjectEnvironmentUserSessionContextBuilder setUser(String user) {
            this.user = user;
            return this;
        }

        public ProjectEnvironmentUserSessionContextBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public ProjectEnvironmentUserSessionContextBuilder setContext(String context) {
            this.context = context;
            return this;
        }

        public ContextName build() {
            return new ContextName(this);
        }
    }

    public static class Builder {
        private String project;
        private String session;
        private String context;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSession() {
            return this.session;
        }

        public String getContext() {
            return this.context;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        public Builder setContext(String context) {
            this.context = context;
            return this;
        }

        private Builder(ContextName contextName) {
            Preconditions.checkArgument((boolean)Objects.equals(contextName.pathTemplate, PROJECT_SESSION_CONTEXT), (Object)"toBuilder is only supported when ContextName has the pattern of projects/{project}/agent/sessions/{session}/contexts/{context}");
            this.project = contextName.project;
            this.session = contextName.session;
            this.context = contextName.context;
        }

        public ContextName build() {
            return new ContextName(this);
        }
    }
}

