/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/conversation_profile.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * The request message for
 * [ConversationProfiles.SetSuggestionFeature][].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest}
 */
public final class SetSuggestionFeatureConfigRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest)
    SetSuggestionFeatureConfigRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SetSuggestionFeatureConfigRequest.newBuilder() to construct.
  private SetSuggestionFeatureConfigRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SetSuggestionFeatureConfigRequest() {
    conversationProfile_ = "";
    participantRole_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SetSuggestionFeatureConfigRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private SetSuggestionFeatureConfigRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              conversationProfile_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              participantRole_ = rawValue;
              break;
            }
          case 26:
            {
              com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig
                      .Builder
                  subBuilder = null;
              if (suggestionFeatureConfig_ != null) {
                subBuilder = suggestionFeatureConfig_.toBuilder();
              }
              suggestionFeatureConfig_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig
                          .SuggestionFeatureConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(suggestionFeatureConfig_);
                suggestionFeatureConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ConversationProfileProto
        .internal_static_google_cloud_dialogflow_v2_SetSuggestionFeatureConfigRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ConversationProfileProto
        .internal_static_google_cloud_dialogflow_v2_SetSuggestionFeatureConfigRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest.class,
            com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest.Builder.class);
  }

  public static final int CONVERSATION_PROFILE_FIELD_NUMBER = 1;
  private volatile java.lang.Object conversationProfile_;
  /**
   *
   *
   * <pre>
   * Required. The Conversation Profile to add or update the suggestion feature
   * config. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
   * </pre>
   *
   * <code>string conversation_profile = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The conversationProfile.
   */
  @java.lang.Override
  public java.lang.String getConversationProfile() {
    java.lang.Object ref = conversationProfile_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      conversationProfile_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Conversation Profile to add or update the suggestion feature
   * config. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
   * </pre>
   *
   * <code>string conversation_profile = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for conversationProfile.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConversationProfileBytes() {
    java.lang.Object ref = conversationProfile_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      conversationProfile_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARTICIPANT_ROLE_FIELD_NUMBER = 2;
  private int participantRole_;
  /**
   *
   *
   * <pre>
   * Required. The participant role to add or update the suggestion feature
   * config. Only HUMAN_AGENT or END_USER can be used.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.Participant.Role participant_role = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for participantRole.
   */
  @java.lang.Override
  public int getParticipantRoleValue() {
    return participantRole_;
  }
  /**
   *
   *
   * <pre>
   * Required. The participant role to add or update the suggestion feature
   * config. Only HUMAN_AGENT or END_USER can be used.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.Participant.Role participant_role = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The participantRole.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.Participant.Role getParticipantRole() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2.Participant.Role result =
        com.google.cloud.dialogflow.v2.Participant.Role.valueOf(participantRole_);
    return result == null ? com.google.cloud.dialogflow.v2.Participant.Role.UNRECOGNIZED : result;
  }

  public static final int SUGGESTION_FEATURE_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig
      suggestionFeatureConfig_;
  /**
   *
   *
   * <pre>
   * Required. The suggestion feature config to add or update.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig suggestion_feature_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the suggestionFeatureConfig field is set.
   */
  @java.lang.Override
  public boolean hasSuggestionFeatureConfig() {
    return suggestionFeatureConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The suggestion feature config to add or update.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig suggestion_feature_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The suggestionFeatureConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig
      getSuggestionFeatureConfig() {
    return suggestionFeatureConfig_ == null
        ? com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig
            .getDefaultInstance()
        : suggestionFeatureConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The suggestion feature config to add or update.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig suggestion_feature_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfigOrBuilder
      getSuggestionFeatureConfigOrBuilder() {
    return getSuggestionFeatureConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationProfile_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, conversationProfile_);
    }
    if (participantRole_
        != com.google.cloud.dialogflow.v2.Participant.Role.ROLE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, participantRole_);
    }
    if (suggestionFeatureConfig_ != null) {
      output.writeMessage(3, getSuggestionFeatureConfig());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationProfile_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, conversationProfile_);
    }
    if (participantRole_
        != com.google.cloud.dialogflow.v2.Participant.Role.ROLE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, participantRole_);
    }
    if (suggestionFeatureConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSuggestionFeatureConfig());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest other =
        (com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest) obj;

    if (!getConversationProfile().equals(other.getConversationProfile())) return false;
    if (participantRole_ != other.participantRole_) return false;
    if (hasSuggestionFeatureConfig() != other.hasSuggestionFeatureConfig()) return false;
    if (hasSuggestionFeatureConfig()) {
      if (!getSuggestionFeatureConfig().equals(other.getSuggestionFeatureConfig())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONVERSATION_PROFILE_FIELD_NUMBER;
    hash = (53 * hash) + getConversationProfile().hashCode();
    hash = (37 * hash) + PARTICIPANT_ROLE_FIELD_NUMBER;
    hash = (53 * hash) + participantRole_;
    if (hasSuggestionFeatureConfig()) {
      hash = (37 * hash) + SUGGESTION_FEATURE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSuggestionFeatureConfig().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for
   * [ConversationProfiles.SetSuggestionFeature][].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest)
      com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2_SetSuggestionFeatureConfigRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2_SetSuggestionFeatureConfigRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest.class,
              com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      conversationProfile_ = "";

      participantRole_ = 0;

      if (suggestionFeatureConfigBuilder_ == null) {
        suggestionFeatureConfig_ = null;
      } else {
        suggestionFeatureConfig_ = null;
        suggestionFeatureConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2_SetSuggestionFeatureConfigRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest build() {
      com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest buildPartial() {
      com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest result =
          new com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest(this);
      result.conversationProfile_ = conversationProfile_;
      result.participantRole_ = participantRole_;
      if (suggestionFeatureConfigBuilder_ == null) {
        result.suggestionFeatureConfig_ = suggestionFeatureConfig_;
      } else {
        result.suggestionFeatureConfig_ = suggestionFeatureConfigBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest) {
        return mergeFrom((com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest other) {
      if (other
          == com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest.getDefaultInstance())
        return this;
      if (!other.getConversationProfile().isEmpty()) {
        conversationProfile_ = other.conversationProfile_;
        onChanged();
      }
      if (other.participantRole_ != 0) {
        setParticipantRoleValue(other.getParticipantRoleValue());
      }
      if (other.hasSuggestionFeatureConfig()) {
        mergeSuggestionFeatureConfig(other.getSuggestionFeatureConfig());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object conversationProfile_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Conversation Profile to add or update the suggestion feature
     * config. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>string conversation_profile = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The conversationProfile.
     */
    public java.lang.String getConversationProfile() {
      java.lang.Object ref = conversationProfile_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversationProfile_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Conversation Profile to add or update the suggestion feature
     * config. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>string conversation_profile = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for conversationProfile.
     */
    public com.google.protobuf.ByteString getConversationProfileBytes() {
      java.lang.Object ref = conversationProfile_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversationProfile_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Conversation Profile to add or update the suggestion feature
     * config. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>string conversation_profile = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The conversationProfile to set.
     * @return This builder for chaining.
     */
    public Builder setConversationProfile(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      conversationProfile_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Conversation Profile to add or update the suggestion feature
     * config. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>string conversation_profile = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversationProfile() {

      conversationProfile_ = getDefaultInstance().getConversationProfile();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Conversation Profile to add or update the suggestion feature
     * config. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
     * </pre>
     *
     * <code>string conversation_profile = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for conversationProfile to set.
     * @return This builder for chaining.
     */
    public Builder setConversationProfileBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      conversationProfile_ = value;
      onChanged();
      return this;
    }

    private int participantRole_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The participant role to add or update the suggestion feature
     * config. Only HUMAN_AGENT or END_USER can be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Participant.Role participant_role = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for participantRole.
     */
    @java.lang.Override
    public int getParticipantRoleValue() {
      return participantRole_;
    }
    /**
     *
     *
     * <pre>
     * Required. The participant role to add or update the suggestion feature
     * config. Only HUMAN_AGENT or END_USER can be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Participant.Role participant_role = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for participantRole to set.
     * @return This builder for chaining.
     */
    public Builder setParticipantRoleValue(int value) {

      participantRole_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The participant role to add or update the suggestion feature
     * config. Only HUMAN_AGENT or END_USER can be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Participant.Role participant_role = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The participantRole.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Participant.Role getParticipantRole() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2.Participant.Role result =
          com.google.cloud.dialogflow.v2.Participant.Role.valueOf(participantRole_);
      return result == null ? com.google.cloud.dialogflow.v2.Participant.Role.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The participant role to add or update the suggestion feature
     * config. Only HUMAN_AGENT or END_USER can be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Participant.Role participant_role = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The participantRole to set.
     * @return This builder for chaining.
     */
    public Builder setParticipantRole(com.google.cloud.dialogflow.v2.Participant.Role value) {
      if (value == null) {
        throw new NullPointerException();
      }

      participantRole_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The participant role to add or update the suggestion feature
     * config. Only HUMAN_AGENT or END_USER can be used.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.Participant.Role participant_role = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParticipantRole() {

      participantRole_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig
        suggestionFeatureConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig,
            com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig
                .Builder,
            com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig
                .SuggestionFeatureConfigOrBuilder>
        suggestionFeatureConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The suggestion feature config to add or update.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig suggestion_feature_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the suggestionFeatureConfig field is set.
     */
    public boolean hasSuggestionFeatureConfig() {
      return suggestionFeatureConfigBuilder_ != null || suggestionFeatureConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The suggestion feature config to add or update.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig suggestion_feature_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The suggestionFeatureConfig.
     */
    public com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig
        getSuggestionFeatureConfig() {
      if (suggestionFeatureConfigBuilder_ == null) {
        return suggestionFeatureConfig_ == null
            ? com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig
                .getDefaultInstance()
            : suggestionFeatureConfig_;
      } else {
        return suggestionFeatureConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The suggestion feature config to add or update.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig suggestion_feature_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSuggestionFeatureConfig(
        com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig value) {
      if (suggestionFeatureConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestionFeatureConfig_ = value;
        onChanged();
      } else {
        suggestionFeatureConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The suggestion feature config to add or update.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig suggestion_feature_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSuggestionFeatureConfig(
        com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig.Builder
            builderForValue) {
      if (suggestionFeatureConfigBuilder_ == null) {
        suggestionFeatureConfig_ = builderForValue.build();
        onChanged();
      } else {
        suggestionFeatureConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The suggestion feature config to add or update.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig suggestion_feature_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeSuggestionFeatureConfig(
        com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig value) {
      if (suggestionFeatureConfigBuilder_ == null) {
        if (suggestionFeatureConfig_ != null) {
          suggestionFeatureConfig_ =
              com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig
                  .newBuilder(suggestionFeatureConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          suggestionFeatureConfig_ = value;
        }
        onChanged();
      } else {
        suggestionFeatureConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The suggestion feature config to add or update.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig suggestion_feature_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearSuggestionFeatureConfig() {
      if (suggestionFeatureConfigBuilder_ == null) {
        suggestionFeatureConfig_ = null;
        onChanged();
      } else {
        suggestionFeatureConfig_ = null;
        suggestionFeatureConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The suggestion feature config to add or update.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig suggestion_feature_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig.Builder
        getSuggestionFeatureConfigBuilder() {

      onChanged();
      return getSuggestionFeatureConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The suggestion feature config to add or update.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig suggestion_feature_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfigOrBuilder
        getSuggestionFeatureConfigOrBuilder() {
      if (suggestionFeatureConfigBuilder_ != null) {
        return suggestionFeatureConfigBuilder_.getMessageOrBuilder();
      } else {
        return suggestionFeatureConfig_ == null
            ? com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig
                .getDefaultInstance()
            : suggestionFeatureConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The suggestion feature config to add or update.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig suggestion_feature_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig,
            com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig
                .Builder,
            com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig
                .SuggestionFeatureConfigOrBuilder>
        getSuggestionFeatureConfigFieldBuilder() {
      if (suggestionFeatureConfigBuilder_ == null) {
        suggestionFeatureConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig,
                com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig.SuggestionFeatureConfig
                    .Builder,
                com.google.cloud.dialogflow.v2.HumanAgentAssistantConfig
                    .SuggestionFeatureConfigOrBuilder>(
                getSuggestionFeatureConfig(), getParentForChildren(), isClean());
        suggestionFeatureConfig_ = null;
      }
      return suggestionFeatureConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest)
  private static final com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest();
  }

  public static com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SetSuggestionFeatureConfigRequest> PARSER =
      new com.google.protobuf.AbstractParser<SetSuggestionFeatureConfigRequest>() {
        @java.lang.Override
        public SetSuggestionFeatureConfigRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new SetSuggestionFeatureConfigRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<SetSuggestionFeatureConfigRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SetSuggestionFeatureConfigRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SetSuggestionFeatureConfigRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
