/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/webhook.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * The request message for a webhook call.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.WebhookRequest}
 */
public final class WebhookRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.WebhookRequest)
    WebhookRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WebhookRequest.newBuilder() to construct.
  private WebhookRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WebhookRequest() {
    session_ = "";
    responseId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WebhookRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private WebhookRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              responseId_ = s;
              break;
            }
          case 18:
            {
              com.google.cloud.dialogflow.v2.QueryResult.Builder subBuilder = null;
              if (queryResult_ != null) {
                subBuilder = queryResult_.toBuilder();
              }
              queryResult_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.QueryResult.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(queryResult_);
                queryResult_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest.Builder subBuilder = null;
              if (originalDetectIntentRequest_ != null) {
                subBuilder = originalDetectIntentRequest_.toBuilder();
              }
              originalDetectIntentRequest_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(originalDetectIntentRequest_);
                originalDetectIntentRequest_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              session_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.WebhookProto
        .internal_static_google_cloud_dialogflow_v2_WebhookRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.WebhookProto
        .internal_static_google_cloud_dialogflow_v2_WebhookRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.WebhookRequest.class,
            com.google.cloud.dialogflow.v2.WebhookRequest.Builder.class);
  }

  public static final int SESSION_FIELD_NUMBER = 4;
  private volatile java.lang.Object session_;
  /**
   *
   *
   * <pre>
   * The unique identifier of detectIntent request session.
   * Can be used to identify end-user inside webhook implementation.
   * Format: `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
   * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
   * ID&gt;/sessions/&lt;Session ID&gt;`.
   * </pre>
   *
   * <code>string session = 4;</code>
   *
   * @return The session.
   */
  @java.lang.Override
  public java.lang.String getSession() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      session_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of detectIntent request session.
   * Can be used to identify end-user inside webhook implementation.
   * Format: `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
   * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
   * ID&gt;/sessions/&lt;Session ID&gt;`.
   * </pre>
   *
   * <code>string session = 4;</code>
   *
   * @return The bytes for session.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionBytes() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      session_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESPONSE_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object responseId_;
  /**
   *
   *
   * <pre>
   * The unique identifier of the response. Contains the same value as
   * `[Streaming]DetectIntentResponse.response_id`.
   * </pre>
   *
   * <code>string response_id = 1;</code>
   *
   * @return The responseId.
   */
  @java.lang.Override
  public java.lang.String getResponseId() {
    java.lang.Object ref = responseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      responseId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the response. Contains the same value as
   * `[Streaming]DetectIntentResponse.response_id`.
   * </pre>
   *
   * <code>string response_id = 1;</code>
   *
   * @return The bytes for responseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResponseIdBytes() {
    java.lang.Object ref = responseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      responseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_RESULT_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.v2.QueryResult queryResult_;
  /**
   *
   *
   * <pre>
   * The result of the conversational query or event processing. Contains the
   * same value as `[Streaming]DetectIntentResponse.query_result`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.QueryResult query_result = 2;</code>
   *
   * @return Whether the queryResult field is set.
   */
  @java.lang.Override
  public boolean hasQueryResult() {
    return queryResult_ != null;
  }
  /**
   *
   *
   * <pre>
   * The result of the conversational query or event processing. Contains the
   * same value as `[Streaming]DetectIntentResponse.query_result`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.QueryResult query_result = 2;</code>
   *
   * @return The queryResult.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.QueryResult getQueryResult() {
    return queryResult_ == null
        ? com.google.cloud.dialogflow.v2.QueryResult.getDefaultInstance()
        : queryResult_;
  }
  /**
   *
   *
   * <pre>
   * The result of the conversational query or event processing. Contains the
   * same value as `[Streaming]DetectIntentResponse.query_result`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.QueryResult query_result = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.QueryResultOrBuilder getQueryResultOrBuilder() {
    return getQueryResult();
  }

  public static final int ORIGINAL_DETECT_INTENT_REQUEST_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest originalDetectIntentRequest_;
  /**
   *
   *
   * <pre>
   * Optional. The contents of the original request that was passed to
   * `[Streaming]DetectIntent` call.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.OriginalDetectIntentRequest original_detect_intent_request = 3;
   * </code>
   *
   * @return Whether the originalDetectIntentRequest field is set.
   */
  @java.lang.Override
  public boolean hasOriginalDetectIntentRequest() {
    return originalDetectIntentRequest_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The contents of the original request that was passed to
   * `[Streaming]DetectIntent` call.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.OriginalDetectIntentRequest original_detect_intent_request = 3;
   * </code>
   *
   * @return The originalDetectIntentRequest.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest
      getOriginalDetectIntentRequest() {
    return originalDetectIntentRequest_ == null
        ? com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest.getDefaultInstance()
        : originalDetectIntentRequest_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The contents of the original request that was passed to
   * `[Streaming]DetectIntent` call.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.OriginalDetectIntentRequest original_detect_intent_request = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.OriginalDetectIntentRequestOrBuilder
      getOriginalDetectIntentRequestOrBuilder() {
    return getOriginalDetectIntentRequest();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, responseId_);
    }
    if (queryResult_ != null) {
      output.writeMessage(2, getQueryResult());
    }
    if (originalDetectIntentRequest_ != null) {
      output.writeMessage(3, getOriginalDetectIntentRequest());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, session_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, responseId_);
    }
    if (queryResult_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getQueryResult());
    }
    if (originalDetectIntentRequest_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, getOriginalDetectIntentRequest());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, session_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.WebhookRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.WebhookRequest other =
        (com.google.cloud.dialogflow.v2.WebhookRequest) obj;

    if (!getSession().equals(other.getSession())) return false;
    if (!getResponseId().equals(other.getResponseId())) return false;
    if (hasQueryResult() != other.hasQueryResult()) return false;
    if (hasQueryResult()) {
      if (!getQueryResult().equals(other.getQueryResult())) return false;
    }
    if (hasOriginalDetectIntentRequest() != other.hasOriginalDetectIntentRequest()) return false;
    if (hasOriginalDetectIntentRequest()) {
      if (!getOriginalDetectIntentRequest().equals(other.getOriginalDetectIntentRequest()))
        return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SESSION_FIELD_NUMBER;
    hash = (53 * hash) + getSession().hashCode();
    hash = (37 * hash) + RESPONSE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getResponseId().hashCode();
    if (hasQueryResult()) {
      hash = (37 * hash) + QUERY_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getQueryResult().hashCode();
    }
    if (hasOriginalDetectIntentRequest()) {
      hash = (37 * hash) + ORIGINAL_DETECT_INTENT_REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getOriginalDetectIntentRequest().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.WebhookRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.WebhookRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.WebhookRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.WebhookRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.WebhookRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.WebhookRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.WebhookRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.WebhookRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.WebhookRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.WebhookRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.WebhookRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.WebhookRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.WebhookRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for a webhook call.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.WebhookRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.WebhookRequest)
      com.google.cloud.dialogflow.v2.WebhookRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.WebhookProto
          .internal_static_google_cloud_dialogflow_v2_WebhookRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.WebhookProto
          .internal_static_google_cloud_dialogflow_v2_WebhookRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.WebhookRequest.class,
              com.google.cloud.dialogflow.v2.WebhookRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.WebhookRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      session_ = "";

      responseId_ = "";

      if (queryResultBuilder_ == null) {
        queryResult_ = null;
      } else {
        queryResult_ = null;
        queryResultBuilder_ = null;
      }
      if (originalDetectIntentRequestBuilder_ == null) {
        originalDetectIntentRequest_ = null;
      } else {
        originalDetectIntentRequest_ = null;
        originalDetectIntentRequestBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.WebhookProto
          .internal_static_google_cloud_dialogflow_v2_WebhookRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.WebhookRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.WebhookRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.WebhookRequest build() {
      com.google.cloud.dialogflow.v2.WebhookRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.WebhookRequest buildPartial() {
      com.google.cloud.dialogflow.v2.WebhookRequest result =
          new com.google.cloud.dialogflow.v2.WebhookRequest(this);
      result.session_ = session_;
      result.responseId_ = responseId_;
      if (queryResultBuilder_ == null) {
        result.queryResult_ = queryResult_;
      } else {
        result.queryResult_ = queryResultBuilder_.build();
      }
      if (originalDetectIntentRequestBuilder_ == null) {
        result.originalDetectIntentRequest_ = originalDetectIntentRequest_;
      } else {
        result.originalDetectIntentRequest_ = originalDetectIntentRequestBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.WebhookRequest) {
        return mergeFrom((com.google.cloud.dialogflow.v2.WebhookRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.WebhookRequest other) {
      if (other == com.google.cloud.dialogflow.v2.WebhookRequest.getDefaultInstance()) return this;
      if (!other.getSession().isEmpty()) {
        session_ = other.session_;
        onChanged();
      }
      if (!other.getResponseId().isEmpty()) {
        responseId_ = other.responseId_;
        onChanged();
      }
      if (other.hasQueryResult()) {
        mergeQueryResult(other.getQueryResult());
      }
      if (other.hasOriginalDetectIntentRequest()) {
        mergeOriginalDetectIntentRequest(other.getOriginalDetectIntentRequest());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2.WebhookRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.dialogflow.v2.WebhookRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object session_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of detectIntent request session.
     * Can be used to identify end-user inside webhook implementation.
     * Format: `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
     * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     * ID&gt;/sessions/&lt;Session ID&gt;`.
     * </pre>
     *
     * <code>string session = 4;</code>
     *
     * @return The session.
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of detectIntent request session.
     * Can be used to identify end-user inside webhook implementation.
     * Format: `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
     * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     * ID&gt;/sessions/&lt;Session ID&gt;`.
     * </pre>
     *
     * <code>string session = 4;</code>
     *
     * @return The bytes for session.
     */
    public com.google.protobuf.ByteString getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of detectIntent request session.
     * Can be used to identify end-user inside webhook implementation.
     * Format: `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
     * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     * ID&gt;/sessions/&lt;Session ID&gt;`.
     * </pre>
     *
     * <code>string session = 4;</code>
     *
     * @param value The session to set.
     * @return This builder for chaining.
     */
    public Builder setSession(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      session_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of detectIntent request session.
     * Can be used to identify end-user inside webhook implementation.
     * Format: `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
     * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     * ID&gt;/sessions/&lt;Session ID&gt;`.
     * </pre>
     *
     * <code>string session = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSession() {

      session_ = getDefaultInstance().getSession();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of detectIntent request session.
     * Can be used to identify end-user inside webhook implementation.
     * Format: `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;`, or
     * `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     * ID&gt;/sessions/&lt;Session ID&gt;`.
     * </pre>
     *
     * <code>string session = 4;</code>
     *
     * @param value The bytes for session to set.
     * @return This builder for chaining.
     */
    public Builder setSessionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      session_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object responseId_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. Contains the same value as
     * `[Streaming]DetectIntentResponse.response_id`.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @return The responseId.
     */
    public java.lang.String getResponseId() {
      java.lang.Object ref = responseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        responseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. Contains the same value as
     * `[Streaming]DetectIntentResponse.response_id`.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @return The bytes for responseId.
     */
    public com.google.protobuf.ByteString getResponseIdBytes() {
      java.lang.Object ref = responseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        responseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. Contains the same value as
     * `[Streaming]DetectIntentResponse.response_id`.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @param value The responseId to set.
     * @return This builder for chaining.
     */
    public Builder setResponseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      responseId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. Contains the same value as
     * `[Streaming]DetectIntentResponse.response_id`.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseId() {

      responseId_ = getDefaultInstance().getResponseId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. Contains the same value as
     * `[Streaming]DetectIntentResponse.response_id`.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @param value The bytes for responseId to set.
     * @return This builder for chaining.
     */
    public Builder setResponseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      responseId_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2.QueryResult queryResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.QueryResult,
            com.google.cloud.dialogflow.v2.QueryResult.Builder,
            com.google.cloud.dialogflow.v2.QueryResultOrBuilder>
        queryResultBuilder_;
    /**
     *
     *
     * <pre>
     * The result of the conversational query or event processing. Contains the
     * same value as `[Streaming]DetectIntentResponse.query_result`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryResult query_result = 2;</code>
     *
     * @return Whether the queryResult field is set.
     */
    public boolean hasQueryResult() {
      return queryResultBuilder_ != null || queryResult_ != null;
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query or event processing. Contains the
     * same value as `[Streaming]DetectIntentResponse.query_result`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryResult query_result = 2;</code>
     *
     * @return The queryResult.
     */
    public com.google.cloud.dialogflow.v2.QueryResult getQueryResult() {
      if (queryResultBuilder_ == null) {
        return queryResult_ == null
            ? com.google.cloud.dialogflow.v2.QueryResult.getDefaultInstance()
            : queryResult_;
      } else {
        return queryResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query or event processing. Contains the
     * same value as `[Streaming]DetectIntentResponse.query_result`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryResult query_result = 2;</code>
     */
    public Builder setQueryResult(com.google.cloud.dialogflow.v2.QueryResult value) {
      if (queryResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryResult_ = value;
        onChanged();
      } else {
        queryResultBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query or event processing. Contains the
     * same value as `[Streaming]DetectIntentResponse.query_result`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryResult query_result = 2;</code>
     */
    public Builder setQueryResult(
        com.google.cloud.dialogflow.v2.QueryResult.Builder builderForValue) {
      if (queryResultBuilder_ == null) {
        queryResult_ = builderForValue.build();
        onChanged();
      } else {
        queryResultBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query or event processing. Contains the
     * same value as `[Streaming]DetectIntentResponse.query_result`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryResult query_result = 2;</code>
     */
    public Builder mergeQueryResult(com.google.cloud.dialogflow.v2.QueryResult value) {
      if (queryResultBuilder_ == null) {
        if (queryResult_ != null) {
          queryResult_ =
              com.google.cloud.dialogflow.v2.QueryResult.newBuilder(queryResult_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryResult_ = value;
        }
        onChanged();
      } else {
        queryResultBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query or event processing. Contains the
     * same value as `[Streaming]DetectIntentResponse.query_result`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryResult query_result = 2;</code>
     */
    public Builder clearQueryResult() {
      if (queryResultBuilder_ == null) {
        queryResult_ = null;
        onChanged();
      } else {
        queryResult_ = null;
        queryResultBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query or event processing. Contains the
     * same value as `[Streaming]DetectIntentResponse.query_result`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryResult query_result = 2;</code>
     */
    public com.google.cloud.dialogflow.v2.QueryResult.Builder getQueryResultBuilder() {

      onChanged();
      return getQueryResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query or event processing. Contains the
     * same value as `[Streaming]DetectIntentResponse.query_result`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryResult query_result = 2;</code>
     */
    public com.google.cloud.dialogflow.v2.QueryResultOrBuilder getQueryResultOrBuilder() {
      if (queryResultBuilder_ != null) {
        return queryResultBuilder_.getMessageOrBuilder();
      } else {
        return queryResult_ == null
            ? com.google.cloud.dialogflow.v2.QueryResult.getDefaultInstance()
            : queryResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * The result of the conversational query or event processing. Contains the
     * same value as `[Streaming]DetectIntentResponse.query_result`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.QueryResult query_result = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.QueryResult,
            com.google.cloud.dialogflow.v2.QueryResult.Builder,
            com.google.cloud.dialogflow.v2.QueryResultOrBuilder>
        getQueryResultFieldBuilder() {
      if (queryResultBuilder_ == null) {
        queryResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.QueryResult,
                com.google.cloud.dialogflow.v2.QueryResult.Builder,
                com.google.cloud.dialogflow.v2.QueryResultOrBuilder>(
                getQueryResult(), getParentForChildren(), isClean());
        queryResult_ = null;
      }
      return queryResultBuilder_;
    }

    private com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest originalDetectIntentRequest_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest,
            com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest.Builder,
            com.google.cloud.dialogflow.v2.OriginalDetectIntentRequestOrBuilder>
        originalDetectIntentRequestBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The contents of the original request that was passed to
     * `[Streaming]DetectIntent` call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.OriginalDetectIntentRequest original_detect_intent_request = 3;
     * </code>
     *
     * @return Whether the originalDetectIntentRequest field is set.
     */
    public boolean hasOriginalDetectIntentRequest() {
      return originalDetectIntentRequestBuilder_ != null || originalDetectIntentRequest_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The contents of the original request that was passed to
     * `[Streaming]DetectIntent` call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.OriginalDetectIntentRequest original_detect_intent_request = 3;
     * </code>
     *
     * @return The originalDetectIntentRequest.
     */
    public com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest
        getOriginalDetectIntentRequest() {
      if (originalDetectIntentRequestBuilder_ == null) {
        return originalDetectIntentRequest_ == null
            ? com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest.getDefaultInstance()
            : originalDetectIntentRequest_;
      } else {
        return originalDetectIntentRequestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The contents of the original request that was passed to
     * `[Streaming]DetectIntent` call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.OriginalDetectIntentRequest original_detect_intent_request = 3;
     * </code>
     */
    public Builder setOriginalDetectIntentRequest(
        com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest value) {
      if (originalDetectIntentRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        originalDetectIntentRequest_ = value;
        onChanged();
      } else {
        originalDetectIntentRequestBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The contents of the original request that was passed to
     * `[Streaming]DetectIntent` call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.OriginalDetectIntentRequest original_detect_intent_request = 3;
     * </code>
     */
    public Builder setOriginalDetectIntentRequest(
        com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest.Builder builderForValue) {
      if (originalDetectIntentRequestBuilder_ == null) {
        originalDetectIntentRequest_ = builderForValue.build();
        onChanged();
      } else {
        originalDetectIntentRequestBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The contents of the original request that was passed to
     * `[Streaming]DetectIntent` call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.OriginalDetectIntentRequest original_detect_intent_request = 3;
     * </code>
     */
    public Builder mergeOriginalDetectIntentRequest(
        com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest value) {
      if (originalDetectIntentRequestBuilder_ == null) {
        if (originalDetectIntentRequest_ != null) {
          originalDetectIntentRequest_ =
              com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest.newBuilder(
                      originalDetectIntentRequest_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          originalDetectIntentRequest_ = value;
        }
        onChanged();
      } else {
        originalDetectIntentRequestBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The contents of the original request that was passed to
     * `[Streaming]DetectIntent` call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.OriginalDetectIntentRequest original_detect_intent_request = 3;
     * </code>
     */
    public Builder clearOriginalDetectIntentRequest() {
      if (originalDetectIntentRequestBuilder_ == null) {
        originalDetectIntentRequest_ = null;
        onChanged();
      } else {
        originalDetectIntentRequest_ = null;
        originalDetectIntentRequestBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The contents of the original request that was passed to
     * `[Streaming]DetectIntent` call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.OriginalDetectIntentRequest original_detect_intent_request = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest.Builder
        getOriginalDetectIntentRequestBuilder() {

      onChanged();
      return getOriginalDetectIntentRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The contents of the original request that was passed to
     * `[Streaming]DetectIntent` call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.OriginalDetectIntentRequest original_detect_intent_request = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.OriginalDetectIntentRequestOrBuilder
        getOriginalDetectIntentRequestOrBuilder() {
      if (originalDetectIntentRequestBuilder_ != null) {
        return originalDetectIntentRequestBuilder_.getMessageOrBuilder();
      } else {
        return originalDetectIntentRequest_ == null
            ? com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest.getDefaultInstance()
            : originalDetectIntentRequest_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The contents of the original request that was passed to
     * `[Streaming]DetectIntent` call.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.OriginalDetectIntentRequest original_detect_intent_request = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest,
            com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest.Builder,
            com.google.cloud.dialogflow.v2.OriginalDetectIntentRequestOrBuilder>
        getOriginalDetectIntentRequestFieldBuilder() {
      if (originalDetectIntentRequestBuilder_ == null) {
        originalDetectIntentRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest,
                com.google.cloud.dialogflow.v2.OriginalDetectIntentRequest.Builder,
                com.google.cloud.dialogflow.v2.OriginalDetectIntentRequestOrBuilder>(
                getOriginalDetectIntentRequest(), getParentForChildren(), isClean());
        originalDetectIntentRequest_ = null;
      }
      return originalDetectIntentRequestBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.WebhookRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.WebhookRequest)
  private static final com.google.cloud.dialogflow.v2.WebhookRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.WebhookRequest();
  }

  public static com.google.cloud.dialogflow.v2.WebhookRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WebhookRequest> PARSER =
      new com.google.protobuf.AbstractParser<WebhookRequest>() {
        @java.lang.Override
        public WebhookRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new WebhookRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<WebhookRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WebhookRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.WebhookRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
