/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/participant.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * The response message for
 * [Participants.SuggestSmartReplies][google.cloud.dialogflow.v2.Participants.SuggestSmartReplies].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.SuggestSmartRepliesResponse}
 */
public final class SuggestSmartRepliesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.SuggestSmartRepliesResponse)
    SuggestSmartRepliesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SuggestSmartRepliesResponse.newBuilder() to construct.
  private SuggestSmartRepliesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SuggestSmartRepliesResponse() {
    smartReplyAnswers_ = java.util.Collections.emptyList();
    latestMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SuggestSmartRepliesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2_SuggestSmartRepliesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2_SuggestSmartRepliesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.class,
            com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.Builder.class);
  }

  public static final int SMART_REPLY_ANSWERS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2.SmartReplyAnswer> smartReplyAnswers_;
  /**
   *
   *
   * <pre>
   * Output only. Multiple reply options provided by smart reply service. The
   * order is based on the rank of the model prediction.
   * The maximum number of the returned replies is set in SmartReplyConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2.SmartReplyAnswer>
      getSmartReplyAnswersList() {
    return smartReplyAnswers_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Multiple reply options provided by smart reply service. The
   * order is based on the rank of the model prediction.
   * The maximum number of the returned replies is set in SmartReplyConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2.SmartReplyAnswerOrBuilder>
      getSmartReplyAnswersOrBuilderList() {
    return smartReplyAnswers_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Multiple reply options provided by smart reply service. The
   * order is based on the rank of the model prediction.
   * The maximum number of the returned replies is set in SmartReplyConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getSmartReplyAnswersCount() {
    return smartReplyAnswers_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Multiple reply options provided by smart reply service. The
   * order is based on the rank of the model prediction.
   * The maximum number of the returned replies is set in SmartReplyConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SmartReplyAnswer getSmartReplyAnswers(int index) {
    return smartReplyAnswers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Multiple reply options provided by smart reply service. The
   * order is based on the rank of the model prediction.
   * The maximum number of the returned replies is set in SmartReplyConfig.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SmartReplyAnswerOrBuilder getSmartReplyAnswersOrBuilder(
      int index) {
    return smartReplyAnswers_.get(index);
  }

  public static final int LATEST_MESSAGE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object latestMessage_ = "";
  /**
   *
   *
   * <pre>
   * The name of the latest conversation message used to compile
   * suggestion for.
   *
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
   * </pre>
   *
   * <code>string latest_message = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The latestMessage.
   */
  @java.lang.Override
  public java.lang.String getLatestMessage() {
    java.lang.Object ref = latestMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      latestMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the latest conversation message used to compile
   * suggestion for.
   *
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
   * </pre>
   *
   * <code>string latest_message = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for latestMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLatestMessageBytes() {
    java.lang.Object ref = latestMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      latestMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTEXT_SIZE_FIELD_NUMBER = 3;
  private int contextSize_ = 0;
  /**
   *
   *
   * <pre>
   * Number of messages prior to and including
   * [latest_message][google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.latest_message]
   * to compile the suggestion. It may be smaller than the
   * [SuggestSmartRepliesRequest.context_size][google.cloud.dialogflow.v2.SuggestSmartRepliesRequest.context_size]
   * field in the request if there aren't that many messages in the
   * conversation.
   * </pre>
   *
   * <code>int32 context_size = 3;</code>
   *
   * @return The contextSize.
   */
  @java.lang.Override
  public int getContextSize() {
    return contextSize_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < smartReplyAnswers_.size(); i++) {
      output.writeMessage(1, smartReplyAnswers_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, latestMessage_);
    }
    if (contextSize_ != 0) {
      output.writeInt32(3, contextSize_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < smartReplyAnswers_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, smartReplyAnswers_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, latestMessage_);
    }
    if (contextSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, contextSize_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse other =
        (com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse) obj;

    if (!getSmartReplyAnswersList().equals(other.getSmartReplyAnswersList())) return false;
    if (!getLatestMessage().equals(other.getLatestMessage())) return false;
    if (getContextSize() != other.getContextSize()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getSmartReplyAnswersCount() > 0) {
      hash = (37 * hash) + SMART_REPLY_ANSWERS_FIELD_NUMBER;
      hash = (53 * hash) + getSmartReplyAnswersList().hashCode();
    }
    hash = (37 * hash) + LATEST_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getLatestMessage().hashCode();
    hash = (37 * hash) + CONTEXT_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getContextSize();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response message for
   * [Participants.SuggestSmartReplies][google.cloud.dialogflow.v2.Participants.SuggestSmartReplies].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.SuggestSmartRepliesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.SuggestSmartRepliesResponse)
      com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2_SuggestSmartRepliesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2_SuggestSmartRepliesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.class,
              com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (smartReplyAnswersBuilder_ == null) {
        smartReplyAnswers_ = java.util.Collections.emptyList();
      } else {
        smartReplyAnswers_ = null;
        smartReplyAnswersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      latestMessage_ = "";
      contextSize_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2_SuggestSmartRepliesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse build() {
      com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse buildPartial() {
      com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse result =
          new com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse result) {
      if (smartReplyAnswersBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          smartReplyAnswers_ = java.util.Collections.unmodifiableList(smartReplyAnswers_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.smartReplyAnswers_ = smartReplyAnswers_;
      } else {
        result.smartReplyAnswers_ = smartReplyAnswersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.latestMessage_ = latestMessage_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.contextSize_ = contextSize_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse) {
        return mergeFrom((com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse other) {
      if (other == com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.getDefaultInstance())
        return this;
      if (smartReplyAnswersBuilder_ == null) {
        if (!other.smartReplyAnswers_.isEmpty()) {
          if (smartReplyAnswers_.isEmpty()) {
            smartReplyAnswers_ = other.smartReplyAnswers_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSmartReplyAnswersIsMutable();
            smartReplyAnswers_.addAll(other.smartReplyAnswers_);
          }
          onChanged();
        }
      } else {
        if (!other.smartReplyAnswers_.isEmpty()) {
          if (smartReplyAnswersBuilder_.isEmpty()) {
            smartReplyAnswersBuilder_.dispose();
            smartReplyAnswersBuilder_ = null;
            smartReplyAnswers_ = other.smartReplyAnswers_;
            bitField0_ = (bitField0_ & ~0x00000001);
            smartReplyAnswersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSmartReplyAnswersFieldBuilder()
                    : null;
          } else {
            smartReplyAnswersBuilder_.addAllMessages(other.smartReplyAnswers_);
          }
        }
      }
      if (!other.getLatestMessage().isEmpty()) {
        latestMessage_ = other.latestMessage_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getContextSize() != 0) {
        setContextSize(other.getContextSize());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dialogflow.v2.SmartReplyAnswer m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.SmartReplyAnswer.parser(),
                        extensionRegistry);
                if (smartReplyAnswersBuilder_ == null) {
                  ensureSmartReplyAnswersIsMutable();
                  smartReplyAnswers_.add(m);
                } else {
                  smartReplyAnswersBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                latestMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                contextSize_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.dialogflow.v2.SmartReplyAnswer> smartReplyAnswers_ =
        java.util.Collections.emptyList();

    private void ensureSmartReplyAnswersIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        smartReplyAnswers_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2.SmartReplyAnswer>(
                smartReplyAnswers_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SmartReplyAnswer,
            com.google.cloud.dialogflow.v2.SmartReplyAnswer.Builder,
            com.google.cloud.dialogflow.v2.SmartReplyAnswerOrBuilder>
        smartReplyAnswersBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.SmartReplyAnswer>
        getSmartReplyAnswersList() {
      if (smartReplyAnswersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(smartReplyAnswers_);
      } else {
        return smartReplyAnswersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getSmartReplyAnswersCount() {
      if (smartReplyAnswersBuilder_ == null) {
        return smartReplyAnswers_.size();
      } else {
        return smartReplyAnswersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SmartReplyAnswer getSmartReplyAnswers(int index) {
      if (smartReplyAnswersBuilder_ == null) {
        return smartReplyAnswers_.get(index);
      } else {
        return smartReplyAnswersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSmartReplyAnswers(
        int index, com.google.cloud.dialogflow.v2.SmartReplyAnswer value) {
      if (smartReplyAnswersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSmartReplyAnswersIsMutable();
        smartReplyAnswers_.set(index, value);
        onChanged();
      } else {
        smartReplyAnswersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSmartReplyAnswers(
        int index, com.google.cloud.dialogflow.v2.SmartReplyAnswer.Builder builderForValue) {
      if (smartReplyAnswersBuilder_ == null) {
        ensureSmartReplyAnswersIsMutable();
        smartReplyAnswers_.set(index, builderForValue.build());
        onChanged();
      } else {
        smartReplyAnswersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSmartReplyAnswers(com.google.cloud.dialogflow.v2.SmartReplyAnswer value) {
      if (smartReplyAnswersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSmartReplyAnswersIsMutable();
        smartReplyAnswers_.add(value);
        onChanged();
      } else {
        smartReplyAnswersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSmartReplyAnswers(
        int index, com.google.cloud.dialogflow.v2.SmartReplyAnswer value) {
      if (smartReplyAnswersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSmartReplyAnswersIsMutable();
        smartReplyAnswers_.add(index, value);
        onChanged();
      } else {
        smartReplyAnswersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSmartReplyAnswers(
        com.google.cloud.dialogflow.v2.SmartReplyAnswer.Builder builderForValue) {
      if (smartReplyAnswersBuilder_ == null) {
        ensureSmartReplyAnswersIsMutable();
        smartReplyAnswers_.add(builderForValue.build());
        onChanged();
      } else {
        smartReplyAnswersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSmartReplyAnswers(
        int index, com.google.cloud.dialogflow.v2.SmartReplyAnswer.Builder builderForValue) {
      if (smartReplyAnswersBuilder_ == null) {
        ensureSmartReplyAnswersIsMutable();
        smartReplyAnswers_.add(index, builderForValue.build());
        onChanged();
      } else {
        smartReplyAnswersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllSmartReplyAnswers(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.SmartReplyAnswer> values) {
      if (smartReplyAnswersBuilder_ == null) {
        ensureSmartReplyAnswersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, smartReplyAnswers_);
        onChanged();
      } else {
        smartReplyAnswersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSmartReplyAnswers() {
      if (smartReplyAnswersBuilder_ == null) {
        smartReplyAnswers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        smartReplyAnswersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeSmartReplyAnswers(int index) {
      if (smartReplyAnswersBuilder_ == null) {
        ensureSmartReplyAnswersIsMutable();
        smartReplyAnswers_.remove(index);
        onChanged();
      } else {
        smartReplyAnswersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SmartReplyAnswer.Builder getSmartReplyAnswersBuilder(
        int index) {
      return getSmartReplyAnswersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SmartReplyAnswerOrBuilder getSmartReplyAnswersOrBuilder(
        int index) {
      if (smartReplyAnswersBuilder_ == null) {
        return smartReplyAnswers_.get(index);
      } else {
        return smartReplyAnswersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2.SmartReplyAnswerOrBuilder>
        getSmartReplyAnswersOrBuilderList() {
      if (smartReplyAnswersBuilder_ != null) {
        return smartReplyAnswersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(smartReplyAnswers_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SmartReplyAnswer.Builder addSmartReplyAnswersBuilder() {
      return getSmartReplyAnswersFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2.SmartReplyAnswer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SmartReplyAnswer.Builder addSmartReplyAnswersBuilder(
        int index) {
      return getSmartReplyAnswersFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.v2.SmartReplyAnswer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Multiple reply options provided by smart reply service. The
     * order is based on the rank of the model prediction.
     * The maximum number of the returned replies is set in SmartReplyConfig.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SmartReplyAnswer smart_reply_answers = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.SmartReplyAnswer.Builder>
        getSmartReplyAnswersBuilderList() {
      return getSmartReplyAnswersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SmartReplyAnswer,
            com.google.cloud.dialogflow.v2.SmartReplyAnswer.Builder,
            com.google.cloud.dialogflow.v2.SmartReplyAnswerOrBuilder>
        getSmartReplyAnswersFieldBuilder() {
      if (smartReplyAnswersBuilder_ == null) {
        smartReplyAnswersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.SmartReplyAnswer,
                com.google.cloud.dialogflow.v2.SmartReplyAnswer.Builder,
                com.google.cloud.dialogflow.v2.SmartReplyAnswerOrBuilder>(
                smartReplyAnswers_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        smartReplyAnswers_ = null;
      }
      return smartReplyAnswersBuilder_;
    }

    private java.lang.Object latestMessage_ = "";
    /**
     *
     *
     * <pre>
     * The name of the latest conversation message used to compile
     * suggestion for.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string latest_message = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The latestMessage.
     */
    public java.lang.String getLatestMessage() {
      java.lang.Object ref = latestMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        latestMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the latest conversation message used to compile
     * suggestion for.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string latest_message = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for latestMessage.
     */
    public com.google.protobuf.ByteString getLatestMessageBytes() {
      java.lang.Object ref = latestMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        latestMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the latest conversation message used to compile
     * suggestion for.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string latest_message = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The latestMessage to set.
     * @return This builder for chaining.
     */
    public Builder setLatestMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      latestMessage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the latest conversation message used to compile
     * suggestion for.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string latest_message = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLatestMessage() {
      latestMessage_ = getDefaultInstance().getLatestMessage();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the latest conversation message used to compile
     * suggestion for.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string latest_message = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for latestMessage to set.
     * @return This builder for chaining.
     */
    public Builder setLatestMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      latestMessage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int contextSize_;
    /**
     *
     *
     * <pre>
     * Number of messages prior to and including
     * [latest_message][google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.latest_message]
     * to compile the suggestion. It may be smaller than the
     * [SuggestSmartRepliesRequest.context_size][google.cloud.dialogflow.v2.SuggestSmartRepliesRequest.context_size]
     * field in the request if there aren't that many messages in the
     * conversation.
     * </pre>
     *
     * <code>int32 context_size = 3;</code>
     *
     * @return The contextSize.
     */
    @java.lang.Override
    public int getContextSize() {
      return contextSize_;
    }
    /**
     *
     *
     * <pre>
     * Number of messages prior to and including
     * [latest_message][google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.latest_message]
     * to compile the suggestion. It may be smaller than the
     * [SuggestSmartRepliesRequest.context_size][google.cloud.dialogflow.v2.SuggestSmartRepliesRequest.context_size]
     * field in the request if there aren't that many messages in the
     * conversation.
     * </pre>
     *
     * <code>int32 context_size = 3;</code>
     *
     * @param value The contextSize to set.
     * @return This builder for chaining.
     */
    public Builder setContextSize(int value) {

      contextSize_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of messages prior to and including
     * [latest_message][google.cloud.dialogflow.v2.SuggestSmartRepliesResponse.latest_message]
     * to compile the suggestion. It may be smaller than the
     * [SuggestSmartRepliesRequest.context_size][google.cloud.dialogflow.v2.SuggestSmartRepliesRequest.context_size]
     * field in the request if there aren't that many messages in the
     * conversation.
     * </pre>
     *
     * <code>int32 context_size = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContextSize() {
      bitField0_ = (bitField0_ & ~0x00000004);
      contextSize_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.SuggestSmartRepliesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.SuggestSmartRepliesResponse)
  private static final com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse();
  }

  public static com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SuggestSmartRepliesResponse> PARSER =
      new com.google.protobuf.AbstractParser<SuggestSmartRepliesResponse>() {
        @java.lang.Override
        public SuggestSmartRepliesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SuggestSmartRepliesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SuggestSmartRepliesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SuggestSmartRepliesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
