/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/conversation_profile.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Defines the Automated Agent to connect to a conversation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.AutomatedAgentConfig}
 */
public final class AutomatedAgentConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.AutomatedAgentConfig)
    AutomatedAgentConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AutomatedAgentConfig.newBuilder() to construct.
  private AutomatedAgentConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutomatedAgentConfig() {
    agent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutomatedAgentConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ConversationProfileProto
        .internal_static_google_cloud_dialogflow_v2_AutomatedAgentConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ConversationProfileProto
        .internal_static_google_cloud_dialogflow_v2_AutomatedAgentConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.AutomatedAgentConfig.class,
            com.google.cloud.dialogflow.v2.AutomatedAgentConfig.Builder.class);
  }

  private int bitField0_;
  public static final int AGENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object agent_ = "";
  /**
   *
   *
   * <pre>
   * Required. ID of the Dialogflow agent environment to use.
   *
   * This project needs to either be the same project as the conversation or you
   * need to grant `service-&lt;Conversation Project
   * Number&gt;&#64;gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API
   * Service Agent` role in this project.
   *
   * - For ES agents, use format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/agent/environments/&lt;Environment ID or '-'&gt;`. If environment is not
   * specified, the default `draft` environment is used. Refer to
   * [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2#google.cloud.dialogflow.v2.DetectIntentRequest)
   * for more details.
   *
   * - For CX agents, use format `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/agents/&lt;Agent ID&gt;/environments/&lt;Environment ID
   * or '-'&gt;`. If environment is not specified, the default `draft` environment
   * is used.
   * </pre>
   *
   * <code>
   * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The agent.
   */
  @java.lang.Override
  public java.lang.String getAgent() {
    java.lang.Object ref = agent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      agent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. ID of the Dialogflow agent environment to use.
   *
   * This project needs to either be the same project as the conversation or you
   * need to grant `service-&lt;Conversation Project
   * Number&gt;&#64;gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API
   * Service Agent` role in this project.
   *
   * - For ES agents, use format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/agent/environments/&lt;Environment ID or '-'&gt;`. If environment is not
   * specified, the default `draft` environment is used. Refer to
   * [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2#google.cloud.dialogflow.v2.DetectIntentRequest)
   * for more details.
   *
   * - For CX agents, use format `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/agents/&lt;Agent ID&gt;/environments/&lt;Environment ID
   * or '-'&gt;`. If environment is not specified, the default `draft` environment
   * is used.
   * </pre>
   *
   * <code>
   * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for agent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAgentBytes() {
    java.lang.Object ref = agent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      agent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SESSION_TTL_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration sessionTtl_;
  /**
   *
   *
   * <pre>
   * Optional. Configure lifetime of the Dialogflow session.
   * By default, a Dialogflow CX session remains active and its data is stored
   * for 30 minutes after the last request is sent for the session.
   * This value should be no longer than 1 day.
   * </pre>
   *
   * <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sessionTtl field is set.
   */
  @java.lang.Override
  public boolean hasSessionTtl() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Configure lifetime of the Dialogflow session.
   * By default, a Dialogflow CX session remains active and its data is stored
   * for 30 minutes after the last request is sent for the session.
   * This value should be no longer than 1 day.
   * </pre>
   *
   * <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sessionTtl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getSessionTtl() {
    return sessionTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : sessionTtl_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configure lifetime of the Dialogflow session.
   * By default, a Dialogflow CX session remains active and its data is stored
   * for 30 minutes after the last request is sent for the session.
   * This value should be no longer than 1 day.
   * </pre>
   *
   * <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getSessionTtlOrBuilder() {
    return sessionTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : sessionTtl_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, agent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getSessionTtl());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, agent_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSessionTtl());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.AutomatedAgentConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.AutomatedAgentConfig other =
        (com.google.cloud.dialogflow.v2.AutomatedAgentConfig) obj;

    if (!getAgent().equals(other.getAgent())) return false;
    if (hasSessionTtl() != other.hasSessionTtl()) return false;
    if (hasSessionTtl()) {
      if (!getSessionTtl().equals(other.getSessionTtl())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AGENT_FIELD_NUMBER;
    hash = (53 * hash) + getAgent().hashCode();
    if (hasSessionTtl()) {
      hash = (37 * hash) + SESSION_TTL_FIELD_NUMBER;
      hash = (53 * hash) + getSessionTtl().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.AutomatedAgentConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.AutomatedAgentConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AutomatedAgentConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.AutomatedAgentConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AutomatedAgentConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.AutomatedAgentConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AutomatedAgentConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.AutomatedAgentConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AutomatedAgentConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.AutomatedAgentConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.AutomatedAgentConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.AutomatedAgentConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.AutomatedAgentConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines the Automated Agent to connect to a conversation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.AutomatedAgentConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.AutomatedAgentConfig)
      com.google.cloud.dialogflow.v2.AutomatedAgentConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2_AutomatedAgentConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2_AutomatedAgentConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.AutomatedAgentConfig.class,
              com.google.cloud.dialogflow.v2.AutomatedAgentConfig.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.AutomatedAgentConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSessionTtlFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      agent_ = "";
      sessionTtl_ = null;
      if (sessionTtlBuilder_ != null) {
        sessionTtlBuilder_.dispose();
        sessionTtlBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2_AutomatedAgentConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.AutomatedAgentConfig getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.AutomatedAgentConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.AutomatedAgentConfig build() {
      com.google.cloud.dialogflow.v2.AutomatedAgentConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.AutomatedAgentConfig buildPartial() {
      com.google.cloud.dialogflow.v2.AutomatedAgentConfig result =
          new com.google.cloud.dialogflow.v2.AutomatedAgentConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2.AutomatedAgentConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.agent_ = agent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.sessionTtl_ = sessionTtlBuilder_ == null ? sessionTtl_ : sessionTtlBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.AutomatedAgentConfig) {
        return mergeFrom((com.google.cloud.dialogflow.v2.AutomatedAgentConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.AutomatedAgentConfig other) {
      if (other == com.google.cloud.dialogflow.v2.AutomatedAgentConfig.getDefaultInstance())
        return this;
      if (!other.getAgent().isEmpty()) {
        agent_ = other.agent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSessionTtl()) {
        mergeSessionTtl(other.getSessionTtl());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                agent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getSessionTtlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object agent_ = "";
    /**
     *
     *
     * <pre>
     * Required. ID of the Dialogflow agent environment to use.
     *
     * This project needs to either be the same project as the conversation or you
     * need to grant `service-&lt;Conversation Project
     * Number&gt;&#64;gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API
     * Service Agent` role in this project.
     *
     * - For ES agents, use format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agent/environments/&lt;Environment ID or '-'&gt;`. If environment is not
     * specified, the default `draft` environment is used. Refer to
     * [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2#google.cloud.dialogflow.v2.DetectIntentRequest)
     * for more details.
     *
     * - For CX agents, use format `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/environments/&lt;Environment ID
     * or '-'&gt;`. If environment is not specified, the default `draft` environment
     * is used.
     * </pre>
     *
     * <code>
     * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The agent.
     */
    public java.lang.String getAgent() {
      java.lang.Object ref = agent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the Dialogflow agent environment to use.
     *
     * This project needs to either be the same project as the conversation or you
     * need to grant `service-&lt;Conversation Project
     * Number&gt;&#64;gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API
     * Service Agent` role in this project.
     *
     * - For ES agents, use format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agent/environments/&lt;Environment ID or '-'&gt;`. If environment is not
     * specified, the default `draft` environment is used. Refer to
     * [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2#google.cloud.dialogflow.v2.DetectIntentRequest)
     * for more details.
     *
     * - For CX agents, use format `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/environments/&lt;Environment ID
     * or '-'&gt;`. If environment is not specified, the default `draft` environment
     * is used.
     * </pre>
     *
     * <code>
     * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for agent.
     */
    public com.google.protobuf.ByteString getAgentBytes() {
      java.lang.Object ref = agent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the Dialogflow agent environment to use.
     *
     * This project needs to either be the same project as the conversation or you
     * need to grant `service-&lt;Conversation Project
     * Number&gt;&#64;gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API
     * Service Agent` role in this project.
     *
     * - For ES agents, use format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agent/environments/&lt;Environment ID or '-'&gt;`. If environment is not
     * specified, the default `draft` environment is used. Refer to
     * [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2#google.cloud.dialogflow.v2.DetectIntentRequest)
     * for more details.
     *
     * - For CX agents, use format `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/environments/&lt;Environment ID
     * or '-'&gt;`. If environment is not specified, the default `draft` environment
     * is used.
     * </pre>
     *
     * <code>
     * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The agent to set.
     * @return This builder for chaining.
     */
    public Builder setAgent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      agent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the Dialogflow agent environment to use.
     *
     * This project needs to either be the same project as the conversation or you
     * need to grant `service-&lt;Conversation Project
     * Number&gt;&#64;gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API
     * Service Agent` role in this project.
     *
     * - For ES agents, use format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agent/environments/&lt;Environment ID or '-'&gt;`. If environment is not
     * specified, the default `draft` environment is used. Refer to
     * [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2#google.cloud.dialogflow.v2.DetectIntentRequest)
     * for more details.
     *
     * - For CX agents, use format `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/environments/&lt;Environment ID
     * or '-'&gt;`. If environment is not specified, the default `draft` environment
     * is used.
     * </pre>
     *
     * <code>
     * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgent() {
      agent_ = getDefaultInstance().getAgent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the Dialogflow agent environment to use.
     *
     * This project needs to either be the same project as the conversation or you
     * need to grant `service-&lt;Conversation Project
     * Number&gt;&#64;gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API
     * Service Agent` role in this project.
     *
     * - For ES agents, use format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agent/environments/&lt;Environment ID or '-'&gt;`. If environment is not
     * specified, the default `draft` environment is used. Refer to
     * [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2#google.cloud.dialogflow.v2.DetectIntentRequest)
     * for more details.
     *
     * - For CX agents, use format `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agents/&lt;Agent ID&gt;/environments/&lt;Environment ID
     * or '-'&gt;`. If environment is not specified, the default `draft` environment
     * is used.
     * </pre>
     *
     * <code>
     * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for agent to set.
     * @return This builder for chaining.
     */
    public Builder setAgentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      agent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration sessionTtl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        sessionTtlBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow CX session remains active and its data is stored
     * for 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sessionTtl field is set.
     */
    public boolean hasSessionTtl() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow CX session remains active and its data is stored
     * for 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sessionTtl.
     */
    public com.google.protobuf.Duration getSessionTtl() {
      if (sessionTtlBuilder_ == null) {
        return sessionTtl_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : sessionTtl_;
      } else {
        return sessionTtlBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow CX session remains active and its data is stored
     * for 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSessionTtl(com.google.protobuf.Duration value) {
      if (sessionTtlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sessionTtl_ = value;
      } else {
        sessionTtlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow CX session remains active and its data is stored
     * for 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSessionTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (sessionTtlBuilder_ == null) {
        sessionTtl_ = builderForValue.build();
      } else {
        sessionTtlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow CX session remains active and its data is stored
     * for 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSessionTtl(com.google.protobuf.Duration value) {
      if (sessionTtlBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && sessionTtl_ != null
            && sessionTtl_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getSessionTtlBuilder().mergeFrom(value);
        } else {
          sessionTtl_ = value;
        }
      } else {
        sessionTtlBuilder_.mergeFrom(value);
      }
      if (sessionTtl_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow CX session remains active and its data is stored
     * for 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSessionTtl() {
      bitField0_ = (bitField0_ & ~0x00000002);
      sessionTtl_ = null;
      if (sessionTtlBuilder_ != null) {
        sessionTtlBuilder_.dispose();
        sessionTtlBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow CX session remains active and its data is stored
     * for 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getSessionTtlBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSessionTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow CX session remains active and its data is stored
     * for 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getSessionTtlOrBuilder() {
      if (sessionTtlBuilder_ != null) {
        return sessionTtlBuilder_.getMessageOrBuilder();
      } else {
        return sessionTtl_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : sessionTtl_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow CX session remains active and its data is stored
     * for 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     * </pre>
     *
     * <code>.google.protobuf.Duration session_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getSessionTtlFieldBuilder() {
      if (sessionTtlBuilder_ == null) {
        sessionTtlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getSessionTtl(), getParentForChildren(), isClean());
        sessionTtl_ = null;
      }
      return sessionTtlBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.AutomatedAgentConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.AutomatedAgentConfig)
  private static final com.google.cloud.dialogflow.v2.AutomatedAgentConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.AutomatedAgentConfig();
  }

  public static com.google.cloud.dialogflow.v2.AutomatedAgentConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutomatedAgentConfig> PARSER =
      new com.google.protobuf.AbstractParser<AutomatedAgentConfig>() {
        @java.lang.Override
        public AutomatedAgentConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AutomatedAgentConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutomatedAgentConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.AutomatedAgentConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
