/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SessionName
implements ResourceName {
    private static final PathTemplate PROJECT_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/sessions/{session}");
    private static final PathTemplate PROJECT_ENVIRONMENT_USER_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}");
    private static final PathTemplate PROJECT_LOCATION_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agent/sessions/{session}");
    private static final PathTemplate PROJECT_LOCATION_ENVIRONMENT_USER_SESSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/agent/environments/{environment}/users/{user}/sessions/{session}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String session;
    private final String environment;
    private final String user;
    private final String location;

    @Deprecated
    protected SessionName() {
        this.project = null;
        this.session = null;
        this.environment = null;
        this.user = null;
        this.location = null;
    }

    private SessionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.environment = null;
        this.user = null;
        this.location = null;
        this.pathTemplate = PROJECT_SESSION;
    }

    private SessionName(ProjectEnvironmentUserSessionBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.location = null;
        this.pathTemplate = PROJECT_ENVIRONMENT_USER_SESSION;
    }

    private SessionName(ProjectLocationSessionBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.environment = null;
        this.user = null;
        this.pathTemplate = PROJECT_LOCATION_SESSION;
    }

    private SessionName(ProjectLocationEnvironmentUserSessionBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.pathTemplate = PROJECT_LOCATION_ENVIRONMENT_USER_SESSION;
    }

    public String getProject() {
        return this.project;
    }

    public String getSession() {
        return this.session;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getUser() {
        return this.user;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectSessionBuilder() {
        return new Builder();
    }

    public static ProjectEnvironmentUserSessionBuilder newProjectEnvironmentUserSessionBuilder() {
        return new ProjectEnvironmentUserSessionBuilder();
    }

    public static ProjectLocationSessionBuilder newProjectLocationSessionBuilder() {
        return new ProjectLocationSessionBuilder();
    }

    public static ProjectLocationEnvironmentUserSessionBuilder newProjectLocationEnvironmentUserSessionBuilder() {
        return new ProjectLocationEnvironmentUserSessionBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SessionName of(String project, String session) {
        return SessionName.newBuilder().setProject(project).setSession(session).build();
    }

    public static SessionName ofProjectSessionName(String project, String session) {
        return SessionName.newBuilder().setProject(project).setSession(session).build();
    }

    public static SessionName ofProjectEnvironmentUserSessionName(String project, String environment, String user, String session) {
        return SessionName.newProjectEnvironmentUserSessionBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).build();
    }

    public static SessionName ofProjectLocationSessionName(String project, String location, String session) {
        return SessionName.newProjectLocationSessionBuilder().setProject(project).setLocation(location).setSession(session).build();
    }

    public static SessionName ofProjectLocationEnvironmentUserSessionName(String project, String location, String environment, String user, String session) {
        return SessionName.newProjectLocationEnvironmentUserSessionBuilder().setProject(project).setLocation(location).setEnvironment(environment).setUser(user).setSession(session).build();
    }

    public static String format(String project, String session) {
        return SessionName.newBuilder().setProject(project).setSession(session).build().toString();
    }

    public static String formatProjectSessionName(String project, String session) {
        return SessionName.newBuilder().setProject(project).setSession(session).build().toString();
    }

    public static String formatProjectEnvironmentUserSessionName(String project, String environment, String user, String session) {
        return SessionName.newProjectEnvironmentUserSessionBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).build().toString();
    }

    public static String formatProjectLocationSessionName(String project, String location, String session) {
        return SessionName.newProjectLocationSessionBuilder().setProject(project).setLocation(location).setSession(session).build().toString();
    }

    public static String formatProjectLocationEnvironmentUserSessionName(String project, String location, String environment, String user, String session) {
        return SessionName.newProjectLocationEnvironmentUserSessionBuilder().setProject(project).setLocation(location).setEnvironment(environment).setUser(user).setSession(session).build().toString();
    }

    public static SessionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_SESSION.matches(formattedString)) {
            Map matchMap = PROJECT_SESSION.match(formattedString);
            return SessionName.ofProjectSessionName((String)matchMap.get("project"), (String)matchMap.get("session"));
        }
        if (PROJECT_ENVIRONMENT_USER_SESSION.matches(formattedString)) {
            Map matchMap = PROJECT_ENVIRONMENT_USER_SESSION.match(formattedString);
            return SessionName.ofProjectEnvironmentUserSessionName((String)matchMap.get("project"), (String)matchMap.get("environment"), (String)matchMap.get("user"), (String)matchMap.get("session"));
        }
        if (PROJECT_LOCATION_SESSION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_SESSION.match(formattedString);
            return SessionName.ofProjectLocationSessionName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("session"));
        }
        if (PROJECT_LOCATION_ENVIRONMENT_USER_SESSION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_ENVIRONMENT_USER_SESSION.match(formattedString);
            return SessionName.ofProjectLocationEnvironmentUserSessionName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("environment"), (String)matchMap.get("user"), (String)matchMap.get("session"));
        }
        throw new ValidationException("SessionName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SessionName> parseList(List<String> formattedStrings) {
        ArrayList<SessionName> list = new ArrayList<SessionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SessionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SessionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SessionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SESSION.matches(formattedString) || PROJECT_ENVIRONMENT_USER_SESSION.matches(formattedString) || PROJECT_LOCATION_SESSION.matches(formattedString) || PROJECT_LOCATION_ENVIRONMENT_USER_SESSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SessionName sessionName = this;
            synchronized (sessionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.session != null) {
                        fieldMapBuilder.put((Object)"session", (Object)this.session);
                    }
                    if (this.environment != null) {
                        fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    }
                    if (this.user != null) {
                        fieldMapBuilder.put((Object)"user", (Object)this.user);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SessionName that = (SessionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.session, that.session) && Objects.equals(this.environment, that.environment) && Objects.equals(this.user, that.user) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.session);
        h *= 1000003;
        h ^= Objects.hashCode(this.environment);
        h *= 1000003;
        h ^= Objects.hashCode(this.user);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationEnvironmentUserSessionBuilder {
        private String project;
        private String location;
        private String environment;
        private String user;
        private String session;

        protected ProjectLocationEnvironmentUserSessionBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getUser() {
            return this.user;
        }

        public String getSession() {
            return this.session;
        }

        public ProjectLocationEnvironmentUserSessionBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionBuilder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionBuilder setUser(String user) {
            this.user = user;
            return this;
        }

        public ProjectLocationEnvironmentUserSessionBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public SessionName build() {
            return new SessionName(this);
        }
    }

    public static class ProjectLocationSessionBuilder {
        private String project;
        private String location;
        private String session;

        protected ProjectLocationSessionBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSession() {
            return this.session;
        }

        public ProjectLocationSessionBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationSessionBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationSessionBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public SessionName build() {
            return new SessionName(this);
        }
    }

    public static class ProjectEnvironmentUserSessionBuilder {
        private String project;
        private String environment;
        private String user;
        private String session;

        protected ProjectEnvironmentUserSessionBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getUser() {
            return this.user;
        }

        public String getSession() {
            return this.session;
        }

        public ProjectEnvironmentUserSessionBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectEnvironmentUserSessionBuilder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public ProjectEnvironmentUserSessionBuilder setUser(String user) {
            this.user = user;
            return this;
        }

        public ProjectEnvironmentUserSessionBuilder setSession(String session) {
            this.session = session;
            return this;
        }

        public SessionName build() {
            return new SessionName(this);
        }
    }

    public static class Builder {
        private String project;
        private String session;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSession() {
            return this.session;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        private Builder(SessionName sessionName) {
            Preconditions.checkArgument((boolean)Objects.equals(sessionName.pathTemplate, PROJECT_SESSION), (Object)"toBuilder is only supported when SessionName has the pattern of projects/{project}/agent/sessions/{session}");
            this.project = sessionName.project;
            this.session = sessionName.session;
        }

        public SessionName build() {
            return new SessionName(this);
        }
    }
}

