/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversationModelEvaluationName
implements ResourceName {
    private static final PathTemplate PROJECT_CONVERSATION_MODEL_EVALUATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/conversationModels/{conversation_model}/evaluations/{evaluation}");
    private static final PathTemplate PROJECT_LOCATION_CONVERSATION_MODEL_EVALUATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversationModels/{conversation_model}/evaluations/{evaluation}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String conversationModel;
    private final String evaluation;
    private final String location;

    @Deprecated
    protected ConversationModelEvaluationName() {
        this.project = null;
        this.conversationModel = null;
        this.evaluation = null;
        this.location = null;
    }

    private ConversationModelEvaluationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.conversationModel = (String)Preconditions.checkNotNull((Object)builder.getConversationModel());
        this.evaluation = (String)Preconditions.checkNotNull((Object)builder.getEvaluation());
        this.location = null;
        this.pathTemplate = PROJECT_CONVERSATION_MODEL_EVALUATION;
    }

    private ConversationModelEvaluationName(ProjectLocationConversationModelEvaluationBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversationModel = (String)Preconditions.checkNotNull((Object)builder.getConversationModel());
        this.evaluation = (String)Preconditions.checkNotNull((Object)builder.getEvaluation());
        this.pathTemplate = PROJECT_LOCATION_CONVERSATION_MODEL_EVALUATION;
    }

    public String getProject() {
        return this.project;
    }

    public String getConversationModel() {
        return this.conversationModel;
    }

    public String getEvaluation() {
        return this.evaluation;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectConversationModelEvaluationBuilder() {
        return new Builder();
    }

    public static ProjectLocationConversationModelEvaluationBuilder newProjectLocationConversationModelEvaluationBuilder() {
        return new ProjectLocationConversationModelEvaluationBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversationModelEvaluationName of(String project, String conversationModel, String evaluation) {
        return ConversationModelEvaluationName.newBuilder().setProject(project).setConversationModel(conversationModel).setEvaluation(evaluation).build();
    }

    public static ConversationModelEvaluationName ofProjectConversationModelEvaluationName(String project, String conversationModel, String evaluation) {
        return ConversationModelEvaluationName.newBuilder().setProject(project).setConversationModel(conversationModel).setEvaluation(evaluation).build();
    }

    public static ConversationModelEvaluationName ofProjectLocationConversationModelEvaluationName(String project, String location, String conversationModel, String evaluation) {
        return ConversationModelEvaluationName.newProjectLocationConversationModelEvaluationBuilder().setProject(project).setLocation(location).setConversationModel(conversationModel).setEvaluation(evaluation).build();
    }

    public static String format(String project, String conversationModel, String evaluation) {
        return ConversationModelEvaluationName.newBuilder().setProject(project).setConversationModel(conversationModel).setEvaluation(evaluation).build().toString();
    }

    public static String formatProjectConversationModelEvaluationName(String project, String conversationModel, String evaluation) {
        return ConversationModelEvaluationName.newBuilder().setProject(project).setConversationModel(conversationModel).setEvaluation(evaluation).build().toString();
    }

    public static String formatProjectLocationConversationModelEvaluationName(String project, String location, String conversationModel, String evaluation) {
        return ConversationModelEvaluationName.newProjectLocationConversationModelEvaluationBuilder().setProject(project).setLocation(location).setConversationModel(conversationModel).setEvaluation(evaluation).build().toString();
    }

    public static ConversationModelEvaluationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_CONVERSATION_MODEL_EVALUATION.matches(formattedString)) {
            Map matchMap = PROJECT_CONVERSATION_MODEL_EVALUATION.match(formattedString);
            return ConversationModelEvaluationName.ofProjectConversationModelEvaluationName((String)matchMap.get("project"), (String)matchMap.get("conversation_model"), (String)matchMap.get("evaluation"));
        }
        if (PROJECT_LOCATION_CONVERSATION_MODEL_EVALUATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CONVERSATION_MODEL_EVALUATION.match(formattedString);
            return ConversationModelEvaluationName.ofProjectLocationConversationModelEvaluationName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversation_model"), (String)matchMap.get("evaluation"));
        }
        throw new ValidationException("ConversationModelEvaluationName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ConversationModelEvaluationName> parseList(List<String> formattedStrings) {
        ArrayList<ConversationModelEvaluationName> list = new ArrayList<ConversationModelEvaluationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversationModelEvaluationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversationModelEvaluationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversationModelEvaluationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_CONVERSATION_MODEL_EVALUATION.matches(formattedString) || PROJECT_LOCATION_CONVERSATION_MODEL_EVALUATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversationModelEvaluationName conversationModelEvaluationName = this;
            synchronized (conversationModelEvaluationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.conversationModel != null) {
                        fieldMapBuilder.put((Object)"conversation_model", (Object)this.conversationModel);
                    }
                    if (this.evaluation != null) {
                        fieldMapBuilder.put((Object)"evaluation", (Object)this.evaluation);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConversationModelEvaluationName that = (ConversationModelEvaluationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.conversationModel, that.conversationModel) && Objects.equals(this.evaluation, that.evaluation) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.conversationModel);
        h *= 1000003;
        h ^= Objects.hashCode(this.evaluation);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationConversationModelEvaluationBuilder {
        private String project;
        private String location;
        private String conversationModel;
        private String evaluation;

        protected ProjectLocationConversationModelEvaluationBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversationModel() {
            return this.conversationModel;
        }

        public String getEvaluation() {
            return this.evaluation;
        }

        public ProjectLocationConversationModelEvaluationBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationConversationModelEvaluationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationConversationModelEvaluationBuilder setConversationModel(String conversationModel) {
            this.conversationModel = conversationModel;
            return this;
        }

        public ProjectLocationConversationModelEvaluationBuilder setEvaluation(String evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        public ConversationModelEvaluationName build() {
            return new ConversationModelEvaluationName(this);
        }
    }

    public static class Builder {
        private String project;
        private String conversationModel;
        private String evaluation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getConversationModel() {
            return this.conversationModel;
        }

        public String getEvaluation() {
            return this.evaluation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setConversationModel(String conversationModel) {
            this.conversationModel = conversationModel;
            return this;
        }

        public Builder setEvaluation(String evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        private Builder(ConversationModelEvaluationName conversationModelEvaluationName) {
            Preconditions.checkArgument((boolean)Objects.equals(conversationModelEvaluationName.pathTemplate, PROJECT_CONVERSATION_MODEL_EVALUATION), (Object)"toBuilder is only supported when ConversationModelEvaluationName has the pattern of projects/{project}/conversationModels/{conversation_model}/evaluations/{evaluation}");
            this.project = conversationModelEvaluationName.project;
            this.conversationModel = conversationModelEvaluationName.conversationModel;
            this.evaluation = conversationModelEvaluationName.evaluation;
        }

        public ConversationModelEvaluationName build() {
            return new ConversationModelEvaluationName(this);
        }
    }
}

