/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/conversation_model.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Represents evaluation result of a conversation model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.ConversationModelEvaluation}
 */
public final class ConversationModelEvaluation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.ConversationModelEvaluation)
    ConversationModelEvaluationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConversationModelEvaluation.newBuilder() to construct.
  private ConversationModelEvaluation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConversationModelEvaluation() {
    name_ = "";
    displayName_ = "";
    rawHumanEvalTemplateCsv_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConversationModelEvaluation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ConversationModelProto
        .internal_static_google_cloud_dialogflow_v2_ConversationModelEvaluation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ConversationModelProto
        .internal_static_google_cloud_dialogflow_v2_ConversationModelEvaluation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.ConversationModelEvaluation.class,
            com.google.cloud.dialogflow.v2.ConversationModelEvaluation.Builder.class);
  }

  private int bitField0_;
  private int metricsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object metrics_;

  public enum MetricsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SMART_REPLY_METRICS(5),
    METRICS_NOT_SET(0);
    private final int value;

    private MetricsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetricsCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetricsCase forNumber(int value) {
      switch (value) {
        case 5:
          return SMART_REPLY_METRICS;
        case 0:
          return METRICS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetricsCase getMetricsCase() {
    return MetricsCase.forNumber(metricsCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the evaluation. Format:
   * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model
   * ID&gt;/evaluations/&lt;Evaluation ID&gt;`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the evaluation. Format:
   * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model
   * ID&gt;/evaluations/&lt;Evaluation ID&gt;`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The display name of the model evaluation. At most 64 bytes long.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The display name of the model evaluation. At most 64 bytes long.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVALUATION_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.dialogflow.v2.EvaluationConfig evaluationConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The configuration of the evaluation task.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.EvaluationConfig evaluation_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the evaluationConfig field is set.
   */
  @java.lang.Override
  public boolean hasEvaluationConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration of the evaluation task.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.EvaluationConfig evaluation_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The evaluationConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EvaluationConfig getEvaluationConfig() {
    return evaluationConfig_ == null
        ? com.google.cloud.dialogflow.v2.EvaluationConfig.getDefaultInstance()
        : evaluationConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The configuration of the evaluation task.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.EvaluationConfig evaluation_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EvaluationConfigOrBuilder getEvaluationConfigOrBuilder() {
    return evaluationConfig_ == null
        ? com.google.cloud.dialogflow.v2.EvaluationConfig.getDefaultInstance()
        : evaluationConfig_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Creation time of this model.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Creation time of this model.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Creation time of this model.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int SMART_REPLY_METRICS_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Output only. Only available when model is for smart reply.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SmartReplyMetrics smart_reply_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the smartReplyMetrics field is set.
   */
  @java.lang.Override
  public boolean hasSmartReplyMetrics() {
    return metricsCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Output only. Only available when model is for smart reply.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SmartReplyMetrics smart_reply_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The smartReplyMetrics.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SmartReplyMetrics getSmartReplyMetrics() {
    if (metricsCase_ == 5) {
      return (com.google.cloud.dialogflow.v2.SmartReplyMetrics) metrics_;
    }
    return com.google.cloud.dialogflow.v2.SmartReplyMetrics.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Only available when model is for smart reply.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SmartReplyMetrics smart_reply_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SmartReplyMetricsOrBuilder getSmartReplyMetricsOrBuilder() {
    if (metricsCase_ == 5) {
      return (com.google.cloud.dialogflow.v2.SmartReplyMetrics) metrics_;
    }
    return com.google.cloud.dialogflow.v2.SmartReplyMetrics.getDefaultInstance();
  }

  public static final int RAW_HUMAN_EVAL_TEMPLATE_CSV_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rawHumanEvalTemplateCsv_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Human eval template in csv format.
   * It tooks real-world conversations provided through input dataset, generates
   * example suggestions for customer to verify quality of the model.
   * For Smart Reply, the generated csv file contains columns of
   * Context, (Suggestions,Q1,Q2)*3, Actual reply.
   * Context contains at most 10 latest messages in the conversation prior to
   * the current suggestion.
   * Q1: "Would you send it as the next message of agent?"
   * Evaluated based on whether the suggest is appropriate to be sent by
   * agent in current context.
   * Q2: "Does the suggestion move the conversation closer to resolution?"
   * Evaluated based on whether the suggestion provide solutions, or answers
   * customer's question or collect information from customer to resolve the
   * customer's issue.
   * Actual reply column contains the actual agent reply sent in the context.
   * </pre>
   *
   * <code>string raw_human_eval_template_csv = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The rawHumanEvalTemplateCsv.
   */
  @java.lang.Override
  public java.lang.String getRawHumanEvalTemplateCsv() {
    java.lang.Object ref = rawHumanEvalTemplateCsv_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rawHumanEvalTemplateCsv_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Human eval template in csv format.
   * It tooks real-world conversations provided through input dataset, generates
   * example suggestions for customer to verify quality of the model.
   * For Smart Reply, the generated csv file contains columns of
   * Context, (Suggestions,Q1,Q2)*3, Actual reply.
   * Context contains at most 10 latest messages in the conversation prior to
   * the current suggestion.
   * Q1: "Would you send it as the next message of agent?"
   * Evaluated based on whether the suggest is appropriate to be sent by
   * agent in current context.
   * Q2: "Does the suggestion move the conversation closer to resolution?"
   * Evaluated based on whether the suggestion provide solutions, or answers
   * customer's question or collect information from customer to resolve the
   * customer's issue.
   * Actual reply column contains the actual agent reply sent in the context.
   * </pre>
   *
   * <code>string raw_human_eval_template_csv = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for rawHumanEvalTemplateCsv.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRawHumanEvalTemplateCsvBytes() {
    java.lang.Object ref = rawHumanEvalTemplateCsv_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rawHumanEvalTemplateCsv_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (metricsCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.dialogflow.v2.SmartReplyMetrics) metrics_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getEvaluationConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rawHumanEvalTemplateCsv_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, rawHumanEvalTemplateCsv_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (metricsCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.dialogflow.v2.SmartReplyMetrics) metrics_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getEvaluationConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rawHumanEvalTemplateCsv_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, rawHumanEvalTemplateCsv_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.ConversationModelEvaluation)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.ConversationModelEvaluation other =
        (com.google.cloud.dialogflow.v2.ConversationModelEvaluation) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasEvaluationConfig() != other.hasEvaluationConfig()) return false;
    if (hasEvaluationConfig()) {
      if (!getEvaluationConfig().equals(other.getEvaluationConfig())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getRawHumanEvalTemplateCsv().equals(other.getRawHumanEvalTemplateCsv())) return false;
    if (!getMetricsCase().equals(other.getMetricsCase())) return false;
    switch (metricsCase_) {
      case 5:
        if (!getSmartReplyMetrics().equals(other.getSmartReplyMetrics())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasEvaluationConfig()) {
      hash = (37 * hash) + EVALUATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEvaluationConfig().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + RAW_HUMAN_EVAL_TEMPLATE_CSV_FIELD_NUMBER;
    hash = (53 * hash) + getRawHumanEvalTemplateCsv().hashCode();
    switch (metricsCase_) {
      case 5:
        hash = (37 * hash) + SMART_REPLY_METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getSmartReplyMetrics().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.ConversationModelEvaluation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModelEvaluation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModelEvaluation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModelEvaluation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModelEvaluation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModelEvaluation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModelEvaluation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModelEvaluation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModelEvaluation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModelEvaluation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModelEvaluation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModelEvaluation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2.ConversationModelEvaluation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents evaluation result of a conversation model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.ConversationModelEvaluation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.ConversationModelEvaluation)
      com.google.cloud.dialogflow.v2.ConversationModelEvaluationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_ConversationModelEvaluation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_ConversationModelEvaluation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.ConversationModelEvaluation.class,
              com.google.cloud.dialogflow.v2.ConversationModelEvaluation.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.ConversationModelEvaluation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEvaluationConfigFieldBuilder();
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      evaluationConfig_ = null;
      if (evaluationConfigBuilder_ != null) {
        evaluationConfigBuilder_.dispose();
        evaluationConfigBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      if (smartReplyMetricsBuilder_ != null) {
        smartReplyMetricsBuilder_.clear();
      }
      rawHumanEvalTemplateCsv_ = "";
      metricsCase_ = 0;
      metrics_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_ConversationModelEvaluation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationModelEvaluation getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.ConversationModelEvaluation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationModelEvaluation build() {
      com.google.cloud.dialogflow.v2.ConversationModelEvaluation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationModelEvaluation buildPartial() {
      com.google.cloud.dialogflow.v2.ConversationModelEvaluation result =
          new com.google.cloud.dialogflow.v2.ConversationModelEvaluation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2.ConversationModelEvaluation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.evaluationConfig_ =
            evaluationConfigBuilder_ == null ? evaluationConfig_ : evaluationConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.rawHumanEvalTemplateCsv_ = rawHumanEvalTemplateCsv_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.v2.ConversationModelEvaluation result) {
      result.metricsCase_ = metricsCase_;
      result.metrics_ = this.metrics_;
      if (metricsCase_ == 5 && smartReplyMetricsBuilder_ != null) {
        result.metrics_ = smartReplyMetricsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.ConversationModelEvaluation) {
        return mergeFrom((com.google.cloud.dialogflow.v2.ConversationModelEvaluation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.ConversationModelEvaluation other) {
      if (other == com.google.cloud.dialogflow.v2.ConversationModelEvaluation.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasEvaluationConfig()) {
        mergeEvaluationConfig(other.getEvaluationConfig());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getRawHumanEvalTemplateCsv().isEmpty()) {
        rawHumanEvalTemplateCsv_ = other.rawHumanEvalTemplateCsv_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      switch (other.getMetricsCase()) {
        case SMART_REPLY_METRICS:
          {
            mergeSmartReplyMetrics(other.getSmartReplyMetrics());
            break;
          }
        case METRICS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(
                    getSmartReplyMetricsFieldBuilder().getBuilder(), extensionRegistry);
                metricsCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getEvaluationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 66:
              {
                rawHumanEvalTemplateCsv_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int metricsCase_ = 0;
    private java.lang.Object metrics_;

    public MetricsCase getMetricsCase() {
      return MetricsCase.forNumber(metricsCase_);
    }

    public Builder clearMetrics() {
      metricsCase_ = 0;
      metrics_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the evaluation. Format:
     * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model
     * ID&gt;/evaluations/&lt;Evaluation ID&gt;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the evaluation. Format:
     * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model
     * ID&gt;/evaluations/&lt;Evaluation ID&gt;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the evaluation. Format:
     * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model
     * ID&gt;/evaluations/&lt;Evaluation ID&gt;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the evaluation. Format:
     * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model
     * ID&gt;/evaluations/&lt;Evaluation ID&gt;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the evaluation. Format:
     * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model
     * ID&gt;/evaluations/&lt;Evaluation ID&gt;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The display name of the model evaluation. At most 64 bytes long.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The display name of the model evaluation. At most 64 bytes long.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The display name of the model evaluation. At most 64 bytes long.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The display name of the model evaluation. At most 64 bytes long.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The display name of the model evaluation. At most 64 bytes long.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2.EvaluationConfig evaluationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.EvaluationConfig,
            com.google.cloud.dialogflow.v2.EvaluationConfig.Builder,
            com.google.cloud.dialogflow.v2.EvaluationConfigOrBuilder>
        evaluationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The configuration of the evaluation task.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig evaluation_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the evaluationConfig field is set.
     */
    public boolean hasEvaluationConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration of the evaluation task.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig evaluation_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The evaluationConfig.
     */
    public com.google.cloud.dialogflow.v2.EvaluationConfig getEvaluationConfig() {
      if (evaluationConfigBuilder_ == null) {
        return evaluationConfig_ == null
            ? com.google.cloud.dialogflow.v2.EvaluationConfig.getDefaultInstance()
            : evaluationConfig_;
      } else {
        return evaluationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration of the evaluation task.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig evaluation_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEvaluationConfig(com.google.cloud.dialogflow.v2.EvaluationConfig value) {
      if (evaluationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationConfig_ = value;
      } else {
        evaluationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration of the evaluation task.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig evaluation_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEvaluationConfig(
        com.google.cloud.dialogflow.v2.EvaluationConfig.Builder builderForValue) {
      if (evaluationConfigBuilder_ == null) {
        evaluationConfig_ = builderForValue.build();
      } else {
        evaluationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration of the evaluation task.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig evaluation_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEvaluationConfig(com.google.cloud.dialogflow.v2.EvaluationConfig value) {
      if (evaluationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && evaluationConfig_ != null
            && evaluationConfig_
                != com.google.cloud.dialogflow.v2.EvaluationConfig.getDefaultInstance()) {
          getEvaluationConfigBuilder().mergeFrom(value);
        } else {
          evaluationConfig_ = value;
        }
      } else {
        evaluationConfigBuilder_.mergeFrom(value);
      }
      if (evaluationConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration of the evaluation task.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig evaluation_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEvaluationConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      evaluationConfig_ = null;
      if (evaluationConfigBuilder_ != null) {
        evaluationConfigBuilder_.dispose();
        evaluationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration of the evaluation task.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig evaluation_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.EvaluationConfig.Builder getEvaluationConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getEvaluationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration of the evaluation task.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig evaluation_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.EvaluationConfigOrBuilder getEvaluationConfigOrBuilder() {
      if (evaluationConfigBuilder_ != null) {
        return evaluationConfigBuilder_.getMessageOrBuilder();
      } else {
        return evaluationConfig_ == null
            ? com.google.cloud.dialogflow.v2.EvaluationConfig.getDefaultInstance()
            : evaluationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The configuration of the evaluation task.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig evaluation_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.EvaluationConfig,
            com.google.cloud.dialogflow.v2.EvaluationConfig.Builder,
            com.google.cloud.dialogflow.v2.EvaluationConfigOrBuilder>
        getEvaluationConfigFieldBuilder() {
      if (evaluationConfigBuilder_ == null) {
        evaluationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.EvaluationConfig,
                com.google.cloud.dialogflow.v2.EvaluationConfig.Builder,
                com.google.cloud.dialogflow.v2.EvaluationConfigOrBuilder>(
                getEvaluationConfig(), getParentForChildren(), isClean());
        evaluationConfig_ = null;
      }
      return evaluationConfigBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SmartReplyMetrics,
            com.google.cloud.dialogflow.v2.SmartReplyMetrics.Builder,
            com.google.cloud.dialogflow.v2.SmartReplyMetricsOrBuilder>
        smartReplyMetricsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Only available when model is for smart reply.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SmartReplyMetrics smart_reply_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the smartReplyMetrics field is set.
     */
    @java.lang.Override
    public boolean hasSmartReplyMetrics() {
      return metricsCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only available when model is for smart reply.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SmartReplyMetrics smart_reply_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The smartReplyMetrics.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SmartReplyMetrics getSmartReplyMetrics() {
      if (smartReplyMetricsBuilder_ == null) {
        if (metricsCase_ == 5) {
          return (com.google.cloud.dialogflow.v2.SmartReplyMetrics) metrics_;
        }
        return com.google.cloud.dialogflow.v2.SmartReplyMetrics.getDefaultInstance();
      } else {
        if (metricsCase_ == 5) {
          return smartReplyMetricsBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2.SmartReplyMetrics.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only available when model is for smart reply.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SmartReplyMetrics smart_reply_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSmartReplyMetrics(com.google.cloud.dialogflow.v2.SmartReplyMetrics value) {
      if (smartReplyMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
        onChanged();
      } else {
        smartReplyMetricsBuilder_.setMessage(value);
      }
      metricsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only available when model is for smart reply.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SmartReplyMetrics smart_reply_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSmartReplyMetrics(
        com.google.cloud.dialogflow.v2.SmartReplyMetrics.Builder builderForValue) {
      if (smartReplyMetricsBuilder_ == null) {
        metrics_ = builderForValue.build();
        onChanged();
      } else {
        smartReplyMetricsBuilder_.setMessage(builderForValue.build());
      }
      metricsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only available when model is for smart reply.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SmartReplyMetrics smart_reply_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSmartReplyMetrics(com.google.cloud.dialogflow.v2.SmartReplyMetrics value) {
      if (smartReplyMetricsBuilder_ == null) {
        if (metricsCase_ == 5
            && metrics_ != com.google.cloud.dialogflow.v2.SmartReplyMetrics.getDefaultInstance()) {
          metrics_ =
              com.google.cloud.dialogflow.v2.SmartReplyMetrics.newBuilder(
                      (com.google.cloud.dialogflow.v2.SmartReplyMetrics) metrics_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metrics_ = value;
        }
        onChanged();
      } else {
        if (metricsCase_ == 5) {
          smartReplyMetricsBuilder_.mergeFrom(value);
        } else {
          smartReplyMetricsBuilder_.setMessage(value);
        }
      }
      metricsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only available when model is for smart reply.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SmartReplyMetrics smart_reply_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSmartReplyMetrics() {
      if (smartReplyMetricsBuilder_ == null) {
        if (metricsCase_ == 5) {
          metricsCase_ = 0;
          metrics_ = null;
          onChanged();
        }
      } else {
        if (metricsCase_ == 5) {
          metricsCase_ = 0;
          metrics_ = null;
        }
        smartReplyMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Only available when model is for smart reply.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SmartReplyMetrics smart_reply_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SmartReplyMetrics.Builder getSmartReplyMetricsBuilder() {
      return getSmartReplyMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Only available when model is for smart reply.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SmartReplyMetrics smart_reply_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SmartReplyMetricsOrBuilder
        getSmartReplyMetricsOrBuilder() {
      if ((metricsCase_ == 5) && (smartReplyMetricsBuilder_ != null)) {
        return smartReplyMetricsBuilder_.getMessageOrBuilder();
      } else {
        if (metricsCase_ == 5) {
          return (com.google.cloud.dialogflow.v2.SmartReplyMetrics) metrics_;
        }
        return com.google.cloud.dialogflow.v2.SmartReplyMetrics.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Only available when model is for smart reply.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.SmartReplyMetrics smart_reply_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SmartReplyMetrics,
            com.google.cloud.dialogflow.v2.SmartReplyMetrics.Builder,
            com.google.cloud.dialogflow.v2.SmartReplyMetricsOrBuilder>
        getSmartReplyMetricsFieldBuilder() {
      if (smartReplyMetricsBuilder_ == null) {
        if (!(metricsCase_ == 5)) {
          metrics_ = com.google.cloud.dialogflow.v2.SmartReplyMetrics.getDefaultInstance();
        }
        smartReplyMetricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.SmartReplyMetrics,
                com.google.cloud.dialogflow.v2.SmartReplyMetrics.Builder,
                com.google.cloud.dialogflow.v2.SmartReplyMetricsOrBuilder>(
                (com.google.cloud.dialogflow.v2.SmartReplyMetrics) metrics_,
                getParentForChildren(),
                isClean());
        metrics_ = null;
      }
      metricsCase_ = 5;
      onChanged();
      return smartReplyMetricsBuilder_;
    }

    private java.lang.Object rawHumanEvalTemplateCsv_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Human eval template in csv format.
     * It tooks real-world conversations provided through input dataset, generates
     * example suggestions for customer to verify quality of the model.
     * For Smart Reply, the generated csv file contains columns of
     * Context, (Suggestions,Q1,Q2)*3, Actual reply.
     * Context contains at most 10 latest messages in the conversation prior to
     * the current suggestion.
     * Q1: "Would you send it as the next message of agent?"
     * Evaluated based on whether the suggest is appropriate to be sent by
     * agent in current context.
     * Q2: "Does the suggestion move the conversation closer to resolution?"
     * Evaluated based on whether the suggestion provide solutions, or answers
     * customer's question or collect information from customer to resolve the
     * customer's issue.
     * Actual reply column contains the actual agent reply sent in the context.
     * </pre>
     *
     * <code>string raw_human_eval_template_csv = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The rawHumanEvalTemplateCsv.
     */
    public java.lang.String getRawHumanEvalTemplateCsv() {
      java.lang.Object ref = rawHumanEvalTemplateCsv_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rawHumanEvalTemplateCsv_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Human eval template in csv format.
     * It tooks real-world conversations provided through input dataset, generates
     * example suggestions for customer to verify quality of the model.
     * For Smart Reply, the generated csv file contains columns of
     * Context, (Suggestions,Q1,Q2)*3, Actual reply.
     * Context contains at most 10 latest messages in the conversation prior to
     * the current suggestion.
     * Q1: "Would you send it as the next message of agent?"
     * Evaluated based on whether the suggest is appropriate to be sent by
     * agent in current context.
     * Q2: "Does the suggestion move the conversation closer to resolution?"
     * Evaluated based on whether the suggestion provide solutions, or answers
     * customer's question or collect information from customer to resolve the
     * customer's issue.
     * Actual reply column contains the actual agent reply sent in the context.
     * </pre>
     *
     * <code>string raw_human_eval_template_csv = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for rawHumanEvalTemplateCsv.
     */
    public com.google.protobuf.ByteString getRawHumanEvalTemplateCsvBytes() {
      java.lang.Object ref = rawHumanEvalTemplateCsv_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rawHumanEvalTemplateCsv_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Human eval template in csv format.
     * It tooks real-world conversations provided through input dataset, generates
     * example suggestions for customer to verify quality of the model.
     * For Smart Reply, the generated csv file contains columns of
     * Context, (Suggestions,Q1,Q2)*3, Actual reply.
     * Context contains at most 10 latest messages in the conversation prior to
     * the current suggestion.
     * Q1: "Would you send it as the next message of agent?"
     * Evaluated based on whether the suggest is appropriate to be sent by
     * agent in current context.
     * Q2: "Does the suggestion move the conversation closer to resolution?"
     * Evaluated based on whether the suggestion provide solutions, or answers
     * customer's question or collect information from customer to resolve the
     * customer's issue.
     * Actual reply column contains the actual agent reply sent in the context.
     * </pre>
     *
     * <code>string raw_human_eval_template_csv = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The rawHumanEvalTemplateCsv to set.
     * @return This builder for chaining.
     */
    public Builder setRawHumanEvalTemplateCsv(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rawHumanEvalTemplateCsv_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Human eval template in csv format.
     * It tooks real-world conversations provided through input dataset, generates
     * example suggestions for customer to verify quality of the model.
     * For Smart Reply, the generated csv file contains columns of
     * Context, (Suggestions,Q1,Q2)*3, Actual reply.
     * Context contains at most 10 latest messages in the conversation prior to
     * the current suggestion.
     * Q1: "Would you send it as the next message of agent?"
     * Evaluated based on whether the suggest is appropriate to be sent by
     * agent in current context.
     * Q2: "Does the suggestion move the conversation closer to resolution?"
     * Evaluated based on whether the suggestion provide solutions, or answers
     * customer's question or collect information from customer to resolve the
     * customer's issue.
     * Actual reply column contains the actual agent reply sent in the context.
     * </pre>
     *
     * <code>string raw_human_eval_template_csv = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRawHumanEvalTemplateCsv() {
      rawHumanEvalTemplateCsv_ = getDefaultInstance().getRawHumanEvalTemplateCsv();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Human eval template in csv format.
     * It tooks real-world conversations provided through input dataset, generates
     * example suggestions for customer to verify quality of the model.
     * For Smart Reply, the generated csv file contains columns of
     * Context, (Suggestions,Q1,Q2)*3, Actual reply.
     * Context contains at most 10 latest messages in the conversation prior to
     * the current suggestion.
     * Q1: "Would you send it as the next message of agent?"
     * Evaluated based on whether the suggest is appropriate to be sent by
     * agent in current context.
     * Q2: "Does the suggestion move the conversation closer to resolution?"
     * Evaluated based on whether the suggestion provide solutions, or answers
     * customer's question or collect information from customer to resolve the
     * customer's issue.
     * Actual reply column contains the actual agent reply sent in the context.
     * </pre>
     *
     * <code>string raw_human_eval_template_csv = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for rawHumanEvalTemplateCsv to set.
     * @return This builder for chaining.
     */
    public Builder setRawHumanEvalTemplateCsvBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rawHumanEvalTemplateCsv_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.ConversationModelEvaluation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.ConversationModelEvaluation)
  private static final com.google.cloud.dialogflow.v2.ConversationModelEvaluation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.ConversationModelEvaluation();
  }

  public static com.google.cloud.dialogflow.v2.ConversationModelEvaluation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConversationModelEvaluation> PARSER =
      new com.google.protobuf.AbstractParser<ConversationModelEvaluation>() {
        @java.lang.Override
        public ConversationModelEvaluation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConversationModelEvaluation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConversationModelEvaluation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ConversationModelEvaluation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
