/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/conversation.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2;

public interface SearchKnowledgeRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.SearchKnowledgeRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The parent resource contains the conversation profile
   * Format: 'projects/&lt;Project ID&gt;' or `projects/&lt;Project
   * ID&gt;/locations/&lt;Location ID&gt;`.
   * </pre>
   *
   * <code>string parent = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. The parent resource contains the conversation profile
   * Format: 'projects/&lt;Project ID&gt;' or `projects/&lt;Project
   * ID&gt;/locations/&lt;Location ID&gt;`.
   * </pre>
   *
   * <code>string parent = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. The natural language text query for knowledge search.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.TextInput query = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the query field is set.
   */
  boolean hasQuery();
  /**
   *
   *
   * <pre>
   * Required. The natural language text query for knowledge search.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.TextInput query = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The query.
   */
  com.google.cloud.dialogflow.v2.TextInput getQuery();
  /**
   *
   *
   * <pre>
   * Required. The natural language text query for knowledge search.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.TextInput query = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.dialogflow.v2.TextInputOrBuilder getQueryOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. The conversation profile used to configure the search.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
   * </pre>
   *
   * <code>
   * string conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The conversationProfile.
   */
  java.lang.String getConversationProfile();
  /**
   *
   *
   * <pre>
   * Required. The conversation profile used to configure the search.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversationProfiles/&lt;Conversation Profile ID&gt;`.
   * </pre>
   *
   * <code>
   * string conversation_profile = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for conversationProfile.
   */
  com.google.protobuf.ByteString getConversationProfileBytes();

  /**
   *
   *
   * <pre>
   * Required. The ID of the search session.
   * The session_id can be combined with Dialogflow V3 Agent ID retrieved from
   * conversation profile or on its own to identify a search session. The search
   * history of the same session will impact the search result. It's up to the
   * API caller to choose an appropriate `Session ID`. It can be a random number
   * or some type of session identifiers (preferably hashed). The length must
   * not exceed 36 characters.
   * </pre>
   *
   * <code>string session_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The sessionId.
   */
  java.lang.String getSessionId();
  /**
   *
   *
   * <pre>
   * Required. The ID of the search session.
   * The session_id can be combined with Dialogflow V3 Agent ID retrieved from
   * conversation profile or on its own to identify a search session. The search
   * history of the same session will impact the search result. It's up to the
   * API caller to choose an appropriate `Session ID`. It can be a random number
   * or some type of session identifiers (preferably hashed). The length must
   * not exceed 36 characters.
   * </pre>
   *
   * <code>string session_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for sessionId.
   */
  com.google.protobuf.ByteString getSessionIdBytes();

  /**
   *
   *
   * <pre>
   * Optional. The conversation (between human agent and end user) where the
   * search request is triggered. Format: `projects/&lt;Project
   * ID&gt;/locations/&lt;Location ID&gt;/conversations/&lt;Conversation ID&gt;`.
   * </pre>
   *
   * <code>
   * string conversation = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The conversation.
   */
  java.lang.String getConversation();
  /**
   *
   *
   * <pre>
   * Optional. The conversation (between human agent and end user) where the
   * search request is triggered. Format: `projects/&lt;Project
   * ID&gt;/locations/&lt;Location ID&gt;/conversations/&lt;Conversation ID&gt;`.
   * </pre>
   *
   * <code>
   * string conversation = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for conversation.
   */
  com.google.protobuf.ByteString getConversationBytes();

  /**
   *
   *
   * <pre>
   * Optional. The name of the latest conversation message when the request is
   * triggered.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
   * </pre>
   *
   * <code>
   * string latest_message = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The latestMessage.
   */
  java.lang.String getLatestMessage();
  /**
   *
   *
   * <pre>
   * Optional. The name of the latest conversation message when the request is
   * triggered.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
   * </pre>
   *
   * <code>
   * string latest_message = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for latestMessage.
   */
  com.google.protobuf.ByteString getLatestMessageBytes();

  /**
   *
   *
   * <pre>
   * Optional. The source of the query in the request.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SearchKnowledgeRequest.QuerySource query_source = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for querySource.
   */
  int getQuerySourceValue();
  /**
   *
   *
   * <pre>
   * Optional. The source of the query in the request.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SearchKnowledgeRequest.QuerySource query_source = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The querySource.
   */
  com.google.cloud.dialogflow.v2.SearchKnowledgeRequest.QuerySource getQuerySource();

  /**
   *
   *
   * <pre>
   * Optional. Information about the end-user to improve the relevance and
   * accuracy of generative answers.
   *
   * This will be interpreted and used by a language model, so, for good
   * results, the data should be self-descriptive, and in a simple structure.
   *
   * Example:
   *
   * ```json
   * {
   *   "subscription plan": "Business Premium Plus",
   *   "devices owned": [
   *     {"model": "Google Pixel 7"},
   *     {"model": "Google Pixel Tablet"}
   *   ]
   * }
   * ```
   * </pre>
   *
   * <code>.google.protobuf.Struct end_user_metadata = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the endUserMetadata field is set.
   */
  boolean hasEndUserMetadata();
  /**
   *
   *
   * <pre>
   * Optional. Information about the end-user to improve the relevance and
   * accuracy of generative answers.
   *
   * This will be interpreted and used by a language model, so, for good
   * results, the data should be self-descriptive, and in a simple structure.
   *
   * Example:
   *
   * ```json
   * {
   *   "subscription plan": "Business Premium Plus",
   *   "devices owned": [
   *     {"model": "Google Pixel 7"},
   *     {"model": "Google Pixel Tablet"}
   *   ]
   * }
   * ```
   * </pre>
   *
   * <code>.google.protobuf.Struct end_user_metadata = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The endUserMetadata.
   */
  com.google.protobuf.Struct getEndUserMetadata();
  /**
   *
   *
   * <pre>
   * Optional. Information about the end-user to improve the relevance and
   * accuracy of generative answers.
   *
   * This will be interpreted and used by a language model, so, for good
   * results, the data should be self-descriptive, and in a simple structure.
   *
   * Example:
   *
   * ```json
   * {
   *   "subscription plan": "Business Premium Plus",
   *   "devices owned": [
   *     {"model": "Google Pixel 7"},
   *     {"model": "Google Pixel Tablet"}
   *   ]
   * }
   * ```
   * </pre>
   *
   * <code>.google.protobuf.Struct end_user_metadata = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.StructOrBuilder getEndUserMetadataOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Configuration specific to search queries with data stores.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig search_config = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the searchConfig field is set.
   */
  boolean hasSearchConfig();
  /**
   *
   *
   * <pre>
   * Optional. Configuration specific to search queries with data stores.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig search_config = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The searchConfig.
   */
  com.google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig getSearchConfig();
  /**
   *
   *
   * <pre>
   * Optional. Configuration specific to search queries with data stores.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfig search_config = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.dialogflow.v2.SearchKnowledgeRequest.SearchConfigOrBuilder
      getSearchConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Whether to search the query exactly without query rewrite.
   * </pre>
   *
   * <code>bool exact_search = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The exactSearch.
   */
  boolean getExactSearch();
}
