/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/generator.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Summarization context that customer can configure.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.SummarizationContext}
 */
public final class SummarizationContext extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.SummarizationContext)
    SummarizationContextOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SummarizationContext.newBuilder() to construct.
  private SummarizationContext(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SummarizationContext() {
    summarizationSections_ = java.util.Collections.emptyList();
    fewShotExamples_ = java.util.Collections.emptyList();
    version_ = "";
    outputLanguageCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SummarizationContext();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.GeneratorProto
        .internal_static_google_cloud_dialogflow_v2_SummarizationContext_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.GeneratorProto
        .internal_static_google_cloud_dialogflow_v2_SummarizationContext_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.SummarizationContext.class,
            com.google.cloud.dialogflow.v2.SummarizationContext.Builder.class);
  }

  public static final int SUMMARIZATION_SECTIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2.SummarizationSection>
      summarizationSections_;
  /**
   *
   *
   * <pre>
   * Optional. List of sections. Note it contains both predefined section sand
   * customer defined sections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2.SummarizationSection>
      getSummarizationSectionsList() {
    return summarizationSections_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of sections. Note it contains both predefined section sand
   * customer defined sections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2.SummarizationSectionOrBuilder>
      getSummarizationSectionsOrBuilderList() {
    return summarizationSections_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of sections. Note it contains both predefined section sand
   * customer defined sections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getSummarizationSectionsCount() {
    return summarizationSections_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of sections. Note it contains both predefined section sand
   * customer defined sections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SummarizationSection getSummarizationSections(int index) {
    return summarizationSections_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of sections. Note it contains both predefined section sand
   * customer defined sections.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SummarizationSectionOrBuilder
      getSummarizationSectionsOrBuilder(int index) {
    return summarizationSections_.get(index);
  }

  public static final int FEW_SHOT_EXAMPLES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2.FewShotExample> fewShotExamples_;
  /**
   *
   *
   * <pre>
   * Optional. List of few shot examples.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2.FewShotExample> getFewShotExamplesList() {
    return fewShotExamples_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of few shot examples.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2.FewShotExampleOrBuilder>
      getFewShotExamplesOrBuilderList() {
    return fewShotExamples_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of few shot examples.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getFewShotExamplesCount() {
    return fewShotExamples_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of few shot examples.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.FewShotExample getFewShotExamples(int index) {
    return fewShotExamples_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of few shot examples.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.FewShotExampleOrBuilder getFewShotExamplesOrBuilder(
      int index) {
    return fewShotExamples_.get(index);
  }

  public static final int VERSION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object version_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Version of the feature. If not set, default to latest version.
   * Current candidates are ["1.0"].
   * </pre>
   *
   * <code>string version = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Version of the feature. If not set, default to latest version.
   * Current candidates are ["1.0"].
   * </pre>
   *
   * <code>string version = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OUTPUT_LANGUAGE_CODE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object outputLanguageCode_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The target language of the generated summary. The language code
   * for conversation will be used if this field is empty. Supported 2.0 and
   * later versions.
   * </pre>
   *
   * <code>string output_language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The outputLanguageCode.
   */
  @java.lang.Override
  public java.lang.String getOutputLanguageCode() {
    java.lang.Object ref = outputLanguageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      outputLanguageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The target language of the generated summary. The language code
   * for conversation will be used if this field is empty. Supported 2.0 and
   * later versions.
   * </pre>
   *
   * <code>string output_language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for outputLanguageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputLanguageCodeBytes() {
    java.lang.Object ref = outputLanguageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      outputLanguageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < summarizationSections_.size(); i++) {
      output.writeMessage(1, summarizationSections_.get(i));
    }
    for (int i = 0; i < fewShotExamples_.size(); i++) {
      output.writeMessage(2, fewShotExamples_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, version_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputLanguageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, outputLanguageCode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < summarizationSections_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, summarizationSections_.get(i));
    }
    for (int i = 0; i < fewShotExamples_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, fewShotExamples_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, version_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputLanguageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, outputLanguageCode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.SummarizationContext)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.SummarizationContext other =
        (com.google.cloud.dialogflow.v2.SummarizationContext) obj;

    if (!getSummarizationSectionsList().equals(other.getSummarizationSectionsList())) return false;
    if (!getFewShotExamplesList().equals(other.getFewShotExamplesList())) return false;
    if (!getVersion().equals(other.getVersion())) return false;
    if (!getOutputLanguageCode().equals(other.getOutputLanguageCode())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getSummarizationSectionsCount() > 0) {
      hash = (37 * hash) + SUMMARIZATION_SECTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSummarizationSectionsList().hashCode();
    }
    if (getFewShotExamplesCount() > 0) {
      hash = (37 * hash) + FEW_SHOT_EXAMPLES_FIELD_NUMBER;
      hash = (53 * hash) + getFewShotExamplesList().hashCode();
    }
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    hash = (37 * hash) + OUTPUT_LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getOutputLanguageCode().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.SummarizationContext parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.SummarizationContext parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SummarizationContext parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.SummarizationContext parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SummarizationContext parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.SummarizationContext parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SummarizationContext parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.SummarizationContext parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SummarizationContext parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.SummarizationContext parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.SummarizationContext parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.SummarizationContext parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.SummarizationContext prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Summarization context that customer can configure.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.SummarizationContext}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.SummarizationContext)
      com.google.cloud.dialogflow.v2.SummarizationContextOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.GeneratorProto
          .internal_static_google_cloud_dialogflow_v2_SummarizationContext_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.GeneratorProto
          .internal_static_google_cloud_dialogflow_v2_SummarizationContext_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.SummarizationContext.class,
              com.google.cloud.dialogflow.v2.SummarizationContext.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.SummarizationContext.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (summarizationSectionsBuilder_ == null) {
        summarizationSections_ = java.util.Collections.emptyList();
      } else {
        summarizationSections_ = null;
        summarizationSectionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (fewShotExamplesBuilder_ == null) {
        fewShotExamples_ = java.util.Collections.emptyList();
      } else {
        fewShotExamples_ = null;
        fewShotExamplesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      version_ = "";
      outputLanguageCode_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.GeneratorProto
          .internal_static_google_cloud_dialogflow_v2_SummarizationContext_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SummarizationContext getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.SummarizationContext.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SummarizationContext build() {
      com.google.cloud.dialogflow.v2.SummarizationContext result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SummarizationContext buildPartial() {
      com.google.cloud.dialogflow.v2.SummarizationContext result =
          new com.google.cloud.dialogflow.v2.SummarizationContext(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2.SummarizationContext result) {
      if (summarizationSectionsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          summarizationSections_ = java.util.Collections.unmodifiableList(summarizationSections_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.summarizationSections_ = summarizationSections_;
      } else {
        result.summarizationSections_ = summarizationSectionsBuilder_.build();
      }
      if (fewShotExamplesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          fewShotExamples_ = java.util.Collections.unmodifiableList(fewShotExamples_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.fewShotExamples_ = fewShotExamples_;
      } else {
        result.fewShotExamples_ = fewShotExamplesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2.SummarizationContext result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.outputLanguageCode_ = outputLanguageCode_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.SummarizationContext) {
        return mergeFrom((com.google.cloud.dialogflow.v2.SummarizationContext) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.SummarizationContext other) {
      if (other == com.google.cloud.dialogflow.v2.SummarizationContext.getDefaultInstance())
        return this;
      if (summarizationSectionsBuilder_ == null) {
        if (!other.summarizationSections_.isEmpty()) {
          if (summarizationSections_.isEmpty()) {
            summarizationSections_ = other.summarizationSections_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSummarizationSectionsIsMutable();
            summarizationSections_.addAll(other.summarizationSections_);
          }
          onChanged();
        }
      } else {
        if (!other.summarizationSections_.isEmpty()) {
          if (summarizationSectionsBuilder_.isEmpty()) {
            summarizationSectionsBuilder_.dispose();
            summarizationSectionsBuilder_ = null;
            summarizationSections_ = other.summarizationSections_;
            bitField0_ = (bitField0_ & ~0x00000001);
            summarizationSectionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSummarizationSectionsFieldBuilder()
                    : null;
          } else {
            summarizationSectionsBuilder_.addAllMessages(other.summarizationSections_);
          }
        }
      }
      if (fewShotExamplesBuilder_ == null) {
        if (!other.fewShotExamples_.isEmpty()) {
          if (fewShotExamples_.isEmpty()) {
            fewShotExamples_ = other.fewShotExamples_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureFewShotExamplesIsMutable();
            fewShotExamples_.addAll(other.fewShotExamples_);
          }
          onChanged();
        }
      } else {
        if (!other.fewShotExamples_.isEmpty()) {
          if (fewShotExamplesBuilder_.isEmpty()) {
            fewShotExamplesBuilder_.dispose();
            fewShotExamplesBuilder_ = null;
            fewShotExamples_ = other.fewShotExamples_;
            bitField0_ = (bitField0_ & ~0x00000002);
            fewShotExamplesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFewShotExamplesFieldBuilder()
                    : null;
          } else {
            fewShotExamplesBuilder_.addAllMessages(other.fewShotExamples_);
          }
        }
      }
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getOutputLanguageCode().isEmpty()) {
        outputLanguageCode_ = other.outputLanguageCode_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.dialogflow.v2.SummarizationSection m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.SummarizationSection.parser(),
                        extensionRegistry);
                if (summarizationSectionsBuilder_ == null) {
                  ensureSummarizationSectionsIsMutable();
                  summarizationSections_.add(m);
                } else {
                  summarizationSectionsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.dialogflow.v2.FewShotExample m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2.FewShotExample.parser(), extensionRegistry);
                if (fewShotExamplesBuilder_ == null) {
                  ensureFewShotExamplesIsMutable();
                  fewShotExamples_.add(m);
                } else {
                  fewShotExamplesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                version_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 50:
              {
                outputLanguageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.dialogflow.v2.SummarizationSection>
        summarizationSections_ = java.util.Collections.emptyList();

    private void ensureSummarizationSectionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        summarizationSections_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2.SummarizationSection>(
                summarizationSections_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SummarizationSection,
            com.google.cloud.dialogflow.v2.SummarizationSection.Builder,
            com.google.cloud.dialogflow.v2.SummarizationSectionOrBuilder>
        summarizationSectionsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.SummarizationSection>
        getSummarizationSectionsList() {
      if (summarizationSectionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(summarizationSections_);
      } else {
        return summarizationSectionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getSummarizationSectionsCount() {
      if (summarizationSectionsBuilder_ == null) {
        return summarizationSections_.size();
      } else {
        return summarizationSectionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SummarizationSection getSummarizationSections(int index) {
      if (summarizationSectionsBuilder_ == null) {
        return summarizationSections_.get(index);
      } else {
        return summarizationSectionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSummarizationSections(
        int index, com.google.cloud.dialogflow.v2.SummarizationSection value) {
      if (summarizationSectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSummarizationSectionsIsMutable();
        summarizationSections_.set(index, value);
        onChanged();
      } else {
        summarizationSectionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSummarizationSections(
        int index, com.google.cloud.dialogflow.v2.SummarizationSection.Builder builderForValue) {
      if (summarizationSectionsBuilder_ == null) {
        ensureSummarizationSectionsIsMutable();
        summarizationSections_.set(index, builderForValue.build());
        onChanged();
      } else {
        summarizationSectionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSummarizationSections(
        com.google.cloud.dialogflow.v2.SummarizationSection value) {
      if (summarizationSectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSummarizationSectionsIsMutable();
        summarizationSections_.add(value);
        onChanged();
      } else {
        summarizationSectionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSummarizationSections(
        int index, com.google.cloud.dialogflow.v2.SummarizationSection value) {
      if (summarizationSectionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSummarizationSectionsIsMutable();
        summarizationSections_.add(index, value);
        onChanged();
      } else {
        summarizationSectionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSummarizationSections(
        com.google.cloud.dialogflow.v2.SummarizationSection.Builder builderForValue) {
      if (summarizationSectionsBuilder_ == null) {
        ensureSummarizationSectionsIsMutable();
        summarizationSections_.add(builderForValue.build());
        onChanged();
      } else {
        summarizationSectionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addSummarizationSections(
        int index, com.google.cloud.dialogflow.v2.SummarizationSection.Builder builderForValue) {
      if (summarizationSectionsBuilder_ == null) {
        ensureSummarizationSectionsIsMutable();
        summarizationSections_.add(index, builderForValue.build());
        onChanged();
      } else {
        summarizationSectionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllSummarizationSections(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.SummarizationSection> values) {
      if (summarizationSectionsBuilder_ == null) {
        ensureSummarizationSectionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, summarizationSections_);
        onChanged();
      } else {
        summarizationSectionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSummarizationSections() {
      if (summarizationSectionsBuilder_ == null) {
        summarizationSections_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        summarizationSectionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeSummarizationSections(int index) {
      if (summarizationSectionsBuilder_ == null) {
        ensureSummarizationSectionsIsMutable();
        summarizationSections_.remove(index);
        onChanged();
      } else {
        summarizationSectionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SummarizationSection.Builder
        getSummarizationSectionsBuilder(int index) {
      return getSummarizationSectionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SummarizationSectionOrBuilder
        getSummarizationSectionsOrBuilder(int index) {
      if (summarizationSectionsBuilder_ == null) {
        return summarizationSections_.get(index);
      } else {
        return summarizationSectionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2.SummarizationSectionOrBuilder>
        getSummarizationSectionsOrBuilderList() {
      if (summarizationSectionsBuilder_ != null) {
        return summarizationSectionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(summarizationSections_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SummarizationSection.Builder
        addSummarizationSectionsBuilder() {
      return getSummarizationSectionsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2.SummarizationSection.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SummarizationSection.Builder
        addSummarizationSectionsBuilder(int index) {
      return getSummarizationSectionsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.v2.SummarizationSection.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of sections. Note it contains both predefined section sand
     * customer defined sections.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.SummarizationSection summarization_sections = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.SummarizationSection.Builder>
        getSummarizationSectionsBuilderList() {
      return getSummarizationSectionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SummarizationSection,
            com.google.cloud.dialogflow.v2.SummarizationSection.Builder,
            com.google.cloud.dialogflow.v2.SummarizationSectionOrBuilder>
        getSummarizationSectionsFieldBuilder() {
      if (summarizationSectionsBuilder_ == null) {
        summarizationSectionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.SummarizationSection,
                com.google.cloud.dialogflow.v2.SummarizationSection.Builder,
                com.google.cloud.dialogflow.v2.SummarizationSectionOrBuilder>(
                summarizationSections_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        summarizationSections_ = null;
      }
      return summarizationSectionsBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.v2.FewShotExample> fewShotExamples_ =
        java.util.Collections.emptyList();

    private void ensureFewShotExamplesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        fewShotExamples_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2.FewShotExample>(
                fewShotExamples_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.FewShotExample,
            com.google.cloud.dialogflow.v2.FewShotExample.Builder,
            com.google.cloud.dialogflow.v2.FewShotExampleOrBuilder>
        fewShotExamplesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.FewShotExample> getFewShotExamplesList() {
      if (fewShotExamplesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fewShotExamples_);
      } else {
        return fewShotExamplesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getFewShotExamplesCount() {
      if (fewShotExamplesBuilder_ == null) {
        return fewShotExamples_.size();
      } else {
        return fewShotExamplesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.FewShotExample getFewShotExamples(int index) {
      if (fewShotExamplesBuilder_ == null) {
        return fewShotExamples_.get(index);
      } else {
        return fewShotExamplesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFewShotExamples(
        int index, com.google.cloud.dialogflow.v2.FewShotExample value) {
      if (fewShotExamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFewShotExamplesIsMutable();
        fewShotExamples_.set(index, value);
        onChanged();
      } else {
        fewShotExamplesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFewShotExamples(
        int index, com.google.cloud.dialogflow.v2.FewShotExample.Builder builderForValue) {
      if (fewShotExamplesBuilder_ == null) {
        ensureFewShotExamplesIsMutable();
        fewShotExamples_.set(index, builderForValue.build());
        onChanged();
      } else {
        fewShotExamplesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFewShotExamples(com.google.cloud.dialogflow.v2.FewShotExample value) {
      if (fewShotExamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFewShotExamplesIsMutable();
        fewShotExamples_.add(value);
        onChanged();
      } else {
        fewShotExamplesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFewShotExamples(
        int index, com.google.cloud.dialogflow.v2.FewShotExample value) {
      if (fewShotExamplesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFewShotExamplesIsMutable();
        fewShotExamples_.add(index, value);
        onChanged();
      } else {
        fewShotExamplesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFewShotExamples(
        com.google.cloud.dialogflow.v2.FewShotExample.Builder builderForValue) {
      if (fewShotExamplesBuilder_ == null) {
        ensureFewShotExamplesIsMutable();
        fewShotExamples_.add(builderForValue.build());
        onChanged();
      } else {
        fewShotExamplesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFewShotExamples(
        int index, com.google.cloud.dialogflow.v2.FewShotExample.Builder builderForValue) {
      if (fewShotExamplesBuilder_ == null) {
        ensureFewShotExamplesIsMutable();
        fewShotExamples_.add(index, builderForValue.build());
        onChanged();
      } else {
        fewShotExamplesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllFewShotExamples(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.FewShotExample> values) {
      if (fewShotExamplesBuilder_ == null) {
        ensureFewShotExamplesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fewShotExamples_);
        onChanged();
      } else {
        fewShotExamplesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFewShotExamples() {
      if (fewShotExamplesBuilder_ == null) {
        fewShotExamples_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        fewShotExamplesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeFewShotExamples(int index) {
      if (fewShotExamplesBuilder_ == null) {
        ensureFewShotExamplesIsMutable();
        fewShotExamples_.remove(index);
        onChanged();
      } else {
        fewShotExamplesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.FewShotExample.Builder getFewShotExamplesBuilder(
        int index) {
      return getFewShotExamplesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.FewShotExampleOrBuilder getFewShotExamplesOrBuilder(
        int index) {
      if (fewShotExamplesBuilder_ == null) {
        return fewShotExamples_.get(index);
      } else {
        return fewShotExamplesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2.FewShotExampleOrBuilder>
        getFewShotExamplesOrBuilderList() {
      if (fewShotExamplesBuilder_ != null) {
        return fewShotExamplesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fewShotExamples_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.FewShotExample.Builder addFewShotExamplesBuilder() {
      return getFewShotExamplesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2.FewShotExample.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.FewShotExample.Builder addFewShotExamplesBuilder(
        int index) {
      return getFewShotExamplesFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.v2.FewShotExample.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of few shot examples.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.FewShotExample few_shot_examples = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.FewShotExample.Builder>
        getFewShotExamplesBuilderList() {
      return getFewShotExamplesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.FewShotExample,
            com.google.cloud.dialogflow.v2.FewShotExample.Builder,
            com.google.cloud.dialogflow.v2.FewShotExampleOrBuilder>
        getFewShotExamplesFieldBuilder() {
      if (fewShotExamplesBuilder_ == null) {
        fewShotExamplesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.FewShotExample,
                com.google.cloud.dialogflow.v2.FewShotExample.Builder,
                com.google.cloud.dialogflow.v2.FewShotExampleOrBuilder>(
                fewShotExamples_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        fewShotExamples_ = null;
      }
      return fewShotExamplesBuilder_;
    }

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Version of the feature. If not set, default to latest version.
     * Current candidates are ["1.0"].
     * </pre>
     *
     * <code>string version = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Version of the feature. If not set, default to latest version.
     * Current candidates are ["1.0"].
     * </pre>
     *
     * <code>string version = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Version of the feature. If not set, default to latest version.
     * Current candidates are ["1.0"].
     * </pre>
     *
     * <code>string version = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      version_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Version of the feature. If not set, default to latest version.
     * Current candidates are ["1.0"].
     * </pre>
     *
     * <code>string version = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = getDefaultInstance().getVersion();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Version of the feature. If not set, default to latest version.
     * Current candidates are ["1.0"].
     * </pre>
     *
     * <code>string version = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      version_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object outputLanguageCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The target language of the generated summary. The language code
     * for conversation will be used if this field is empty. Supported 2.0 and
     * later versions.
     * </pre>
     *
     * <code>string output_language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The outputLanguageCode.
     */
    public java.lang.String getOutputLanguageCode() {
      java.lang.Object ref = outputLanguageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputLanguageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The target language of the generated summary. The language code
     * for conversation will be used if this field is empty. Supported 2.0 and
     * later versions.
     * </pre>
     *
     * <code>string output_language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for outputLanguageCode.
     */
    public com.google.protobuf.ByteString getOutputLanguageCodeBytes() {
      java.lang.Object ref = outputLanguageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The target language of the generated summary. The language code
     * for conversation will be used if this field is empty. Supported 2.0 and
     * later versions.
     * </pre>
     *
     * <code>string output_language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The outputLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setOutputLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      outputLanguageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The target language of the generated summary. The language code
     * for conversation will be used if this field is empty. Supported 2.0 and
     * later versions.
     * </pre>
     *
     * <code>string output_language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputLanguageCode() {
      outputLanguageCode_ = getDefaultInstance().getOutputLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The target language of the generated summary. The language code
     * for conversation will be used if this field is empty. Supported 2.0 and
     * later versions.
     * </pre>
     *
     * <code>string output_language_code = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for outputLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setOutputLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      outputLanguageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.SummarizationContext)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.SummarizationContext)
  private static final com.google.cloud.dialogflow.v2.SummarizationContext DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.SummarizationContext();
  }

  public static com.google.cloud.dialogflow.v2.SummarizationContext getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SummarizationContext> PARSER =
      new com.google.protobuf.AbstractParser<SummarizationContext>() {
        @java.lang.Override
        public SummarizationContext parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SummarizationContext> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SummarizationContext> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SummarizationContext getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
