/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/generator.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Providing examples in the generator (i.e. building a few-shot generator)
 * helps convey the desired format of the LLM response.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.FewShotExample}
 */
public final class FewShotExample extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.FewShotExample)
    FewShotExampleOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FewShotExample.newBuilder() to construct.
  private FewShotExample(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FewShotExample() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FewShotExample();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.GeneratorProto
        .internal_static_google_cloud_dialogflow_v2_FewShotExample_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetExtraInfo();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.GeneratorProto
        .internal_static_google_cloud_dialogflow_v2_FewShotExample_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.FewShotExample.class,
            com.google.cloud.dialogflow.v2.FewShotExample.Builder.class);
  }

  private int bitField0_;
  private int instructionListCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object instructionList_;

  public enum InstructionListCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SUMMARIZATION_SECTION_LIST(6),
    INSTRUCTIONLIST_NOT_SET(0);
    private final int value;

    private InstructionListCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InstructionListCase valueOf(int value) {
      return forNumber(value);
    }

    public static InstructionListCase forNumber(int value) {
      switch (value) {
        case 6:
          return SUMMARIZATION_SECTION_LIST;
        case 0:
          return INSTRUCTIONLIST_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public InstructionListCase getInstructionListCase() {
    return InstructionListCase.forNumber(instructionListCase_);
  }

  public static final int CONVERSATION_CONTEXT_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.v2.ConversationContext conversationContext_;

  /**
   *
   *
   * <pre>
   * Optional. Conversation transcripts.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the conversationContext field is set.
   */
  @java.lang.Override
  public boolean hasConversationContext() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Conversation transcripts.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The conversationContext.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ConversationContext getConversationContext() {
    return conversationContext_ == null
        ? com.google.cloud.dialogflow.v2.ConversationContext.getDefaultInstance()
        : conversationContext_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Conversation transcripts.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ConversationContextOrBuilder
      getConversationContextOrBuilder() {
    return conversationContext_ == null
        ? com.google.cloud.dialogflow.v2.ConversationContext.getDefaultInstance()
        : conversationContext_;
  }

  public static final int EXTRA_INFO_FIELD_NUMBER = 4;

  private static final class ExtraInfoDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dialogflow.v2.GeneratorProto
                .internal_static_google_cloud_dialogflow_v2_FewShotExample_ExtraInfoEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> extraInfo_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetExtraInfo() {
    if (extraInfo_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ExtraInfoDefaultEntryHolder.defaultEntry);
    }
    return extraInfo_;
  }

  public int getExtraInfoCount() {
    return internalGetExtraInfo().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Key is the placeholder field name in input, value is the value of
   * the placeholder. E.g. instruction contains "&#64;price", and ingested data has
   * &lt;"price", "10"&gt;
   * </pre>
   *
   * <code>map&lt;string, string&gt; extra_info = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsExtraInfo(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetExtraInfo().getMap().containsKey(key);
  }

  /** Use {@link #getExtraInfoMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getExtraInfo() {
    return getExtraInfoMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Key is the placeholder field name in input, value is the value of
   * the placeholder. E.g. instruction contains "&#64;price", and ingested data has
   * &lt;"price", "10"&gt;
   * </pre>
   *
   * <code>map&lt;string, string&gt; extra_info = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getExtraInfoMap() {
    return internalGetExtraInfo().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. Key is the placeholder field name in input, value is the value of
   * the placeholder. E.g. instruction contains "&#64;price", and ingested data has
   * &lt;"price", "10"&gt;
   * </pre>
   *
   * <code>map&lt;string, string&gt; extra_info = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getExtraInfoOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetExtraInfo().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. Key is the placeholder field name in input, value is the value of
   * the placeholder. E.g. instruction contains "&#64;price", and ingested data has
   * &lt;"price", "10"&gt;
   * </pre>
   *
   * <code>map&lt;string, string&gt; extra_info = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getExtraInfoOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetExtraInfo().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SUMMARIZATION_SECTION_LIST_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Summarization sections.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.SummarizationSectionList summarization_section_list = 6;
   * </code>
   *
   * @return Whether the summarizationSectionList field is set.
   */
  @java.lang.Override
  public boolean hasSummarizationSectionList() {
    return instructionListCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Summarization sections.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.SummarizationSectionList summarization_section_list = 6;
   * </code>
   *
   * @return The summarizationSectionList.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SummarizationSectionList getSummarizationSectionList() {
    if (instructionListCase_ == 6) {
      return (com.google.cloud.dialogflow.v2.SummarizationSectionList) instructionList_;
    }
    return com.google.cloud.dialogflow.v2.SummarizationSectionList.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Summarization sections.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.SummarizationSectionList summarization_section_list = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SummarizationSectionListOrBuilder
      getSummarizationSectionListOrBuilder() {
    if (instructionListCase_ == 6) {
      return (com.google.cloud.dialogflow.v2.SummarizationSectionList) instructionList_;
    }
    return com.google.cloud.dialogflow.v2.SummarizationSectionList.getDefaultInstance();
  }

  public static final int OUTPUT_FIELD_NUMBER = 7;
  private com.google.cloud.dialogflow.v2.GeneratorSuggestion output_;

  /**
   *
   *
   * <pre>
   * Required. Example output of the model.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.GeneratorSuggestion output = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the output field is set.
   */
  @java.lang.Override
  public boolean hasOutput() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Example output of the model.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.GeneratorSuggestion output = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The output.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.GeneratorSuggestion getOutput() {
    return output_ == null
        ? com.google.cloud.dialogflow.v2.GeneratorSuggestion.getDefaultInstance()
        : output_;
  }

  /**
   *
   *
   * <pre>
   * Required. Example output of the model.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.GeneratorSuggestion output = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.GeneratorSuggestionOrBuilder getOutputOrBuilder() {
    return output_ == null
        ? com.google.cloud.dialogflow.v2.GeneratorSuggestion.getDefaultInstance()
        : output_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getConversationContext());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetExtraInfo(), ExtraInfoDefaultEntryHolder.defaultEntry, 4);
    if (instructionListCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.dialogflow.v2.SummarizationSectionList) instructionList_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getOutput());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getConversationContext());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetExtraInfo().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> extraInfo__ =
          ExtraInfoDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, extraInfo__);
    }
    if (instructionListCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.dialogflow.v2.SummarizationSectionList) instructionList_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getOutput());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.FewShotExample)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.FewShotExample other =
        (com.google.cloud.dialogflow.v2.FewShotExample) obj;

    if (hasConversationContext() != other.hasConversationContext()) return false;
    if (hasConversationContext()) {
      if (!getConversationContext().equals(other.getConversationContext())) return false;
    }
    if (!internalGetExtraInfo().equals(other.internalGetExtraInfo())) return false;
    if (hasOutput() != other.hasOutput()) return false;
    if (hasOutput()) {
      if (!getOutput().equals(other.getOutput())) return false;
    }
    if (!getInstructionListCase().equals(other.getInstructionListCase())) return false;
    switch (instructionListCase_) {
      case 6:
        if (!getSummarizationSectionList().equals(other.getSummarizationSectionList()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasConversationContext()) {
      hash = (37 * hash) + CONVERSATION_CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getConversationContext().hashCode();
    }
    if (!internalGetExtraInfo().getMap().isEmpty()) {
      hash = (37 * hash) + EXTRA_INFO_FIELD_NUMBER;
      hash = (53 * hash) + internalGetExtraInfo().hashCode();
    }
    if (hasOutput()) {
      hash = (37 * hash) + OUTPUT_FIELD_NUMBER;
      hash = (53 * hash) + getOutput().hashCode();
    }
    switch (instructionListCase_) {
      case 6:
        hash = (37 * hash) + SUMMARIZATION_SECTION_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getSummarizationSectionList().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.FewShotExample parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.FewShotExample parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.FewShotExample parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.FewShotExample parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.FewShotExample parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.FewShotExample parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.FewShotExample parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.FewShotExample parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.FewShotExample parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.FewShotExample parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.FewShotExample parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.FewShotExample parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.FewShotExample prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Providing examples in the generator (i.e. building a few-shot generator)
   * helps convey the desired format of the LLM response.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.FewShotExample}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.FewShotExample)
      com.google.cloud.dialogflow.v2.FewShotExampleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.GeneratorProto
          .internal_static_google_cloud_dialogflow_v2_FewShotExample_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetExtraInfo();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableExtraInfo();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.GeneratorProto
          .internal_static_google_cloud_dialogflow_v2_FewShotExample_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.FewShotExample.class,
              com.google.cloud.dialogflow.v2.FewShotExample.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.FewShotExample.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConversationContextFieldBuilder();
        getOutputFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      conversationContext_ = null;
      if (conversationContextBuilder_ != null) {
        conversationContextBuilder_.dispose();
        conversationContextBuilder_ = null;
      }
      internalGetMutableExtraInfo().clear();
      if (summarizationSectionListBuilder_ != null) {
        summarizationSectionListBuilder_.clear();
      }
      output_ = null;
      if (outputBuilder_ != null) {
        outputBuilder_.dispose();
        outputBuilder_ = null;
      }
      instructionListCase_ = 0;
      instructionList_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.GeneratorProto
          .internal_static_google_cloud_dialogflow_v2_FewShotExample_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.FewShotExample getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.FewShotExample.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.FewShotExample build() {
      com.google.cloud.dialogflow.v2.FewShotExample result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.FewShotExample buildPartial() {
      com.google.cloud.dialogflow.v2.FewShotExample result =
          new com.google.cloud.dialogflow.v2.FewShotExample(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2.FewShotExample result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.conversationContext_ =
            conversationContextBuilder_ == null
                ? conversationContext_
                : conversationContextBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.extraInfo_ = internalGetExtraInfo();
        result.extraInfo_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.output_ = outputBuilder_ == null ? output_ : outputBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.v2.FewShotExample result) {
      result.instructionListCase_ = instructionListCase_;
      result.instructionList_ = this.instructionList_;
      if (instructionListCase_ == 6 && summarizationSectionListBuilder_ != null) {
        result.instructionList_ = summarizationSectionListBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.FewShotExample) {
        return mergeFrom((com.google.cloud.dialogflow.v2.FewShotExample) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.FewShotExample other) {
      if (other == com.google.cloud.dialogflow.v2.FewShotExample.getDefaultInstance()) return this;
      if (other.hasConversationContext()) {
        mergeConversationContext(other.getConversationContext());
      }
      internalGetMutableExtraInfo().mergeFrom(other.internalGetExtraInfo());
      bitField0_ |= 0x00000002;
      if (other.hasOutput()) {
        mergeOutput(other.getOutput());
      }
      switch (other.getInstructionListCase()) {
        case SUMMARIZATION_SECTION_LIST:
          {
            mergeSummarizationSectionList(other.getSummarizationSectionList());
            break;
          }
        case INSTRUCTIONLIST_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26:
              {
                input.readMessage(
                    getConversationContextFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> extraInfo__ =
                    input.readMessage(
                        ExtraInfoDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableExtraInfo()
                    .getMutableMap()
                    .put(extraInfo__.getKey(), extraInfo__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(
                    getSummarizationSectionListFieldBuilder().getBuilder(), extensionRegistry);
                instructionListCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getOutputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int instructionListCase_ = 0;
    private java.lang.Object instructionList_;

    public InstructionListCase getInstructionListCase() {
      return InstructionListCase.forNumber(instructionListCase_);
    }

    public Builder clearInstructionList() {
      instructionListCase_ = 0;
      instructionList_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.cloud.dialogflow.v2.ConversationContext conversationContext_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.ConversationContext,
            com.google.cloud.dialogflow.v2.ConversationContext.Builder,
            com.google.cloud.dialogflow.v2.ConversationContextOrBuilder>
        conversationContextBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the conversationContext field is set.
     */
    public boolean hasConversationContext() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The conversationContext.
     */
    public com.google.cloud.dialogflow.v2.ConversationContext getConversationContext() {
      if (conversationContextBuilder_ == null) {
        return conversationContext_ == null
            ? com.google.cloud.dialogflow.v2.ConversationContext.getDefaultInstance()
            : conversationContext_;
      } else {
        return conversationContextBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConversationContext(
        com.google.cloud.dialogflow.v2.ConversationContext value) {
      if (conversationContextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        conversationContext_ = value;
      } else {
        conversationContextBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConversationContext(
        com.google.cloud.dialogflow.v2.ConversationContext.Builder builderForValue) {
      if (conversationContextBuilder_ == null) {
        conversationContext_ = builderForValue.build();
      } else {
        conversationContextBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeConversationContext(
        com.google.cloud.dialogflow.v2.ConversationContext value) {
      if (conversationContextBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && conversationContext_ != null
            && conversationContext_
                != com.google.cloud.dialogflow.v2.ConversationContext.getDefaultInstance()) {
          getConversationContextBuilder().mergeFrom(value);
        } else {
          conversationContext_ = value;
        }
      } else {
        conversationContextBuilder_.mergeFrom(value);
      }
      if (conversationContext_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearConversationContext() {
      bitField0_ = (bitField0_ & ~0x00000001);
      conversationContext_ = null;
      if (conversationContextBuilder_ != null) {
        conversationContextBuilder_.dispose();
        conversationContextBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.ConversationContext.Builder
        getConversationContextBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getConversationContextFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.ConversationContextOrBuilder
        getConversationContextOrBuilder() {
      if (conversationContextBuilder_ != null) {
        return conversationContextBuilder_.getMessageOrBuilder();
      } else {
        return conversationContext_ == null
            ? com.google.cloud.dialogflow.v2.ConversationContext.getDefaultInstance()
            : conversationContext_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.ConversationContext,
            com.google.cloud.dialogflow.v2.ConversationContext.Builder,
            com.google.cloud.dialogflow.v2.ConversationContextOrBuilder>
        getConversationContextFieldBuilder() {
      if (conversationContextBuilder_ == null) {
        conversationContextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.ConversationContext,
                com.google.cloud.dialogflow.v2.ConversationContext.Builder,
                com.google.cloud.dialogflow.v2.ConversationContextOrBuilder>(
                getConversationContext(), getParentForChildren(), isClean());
        conversationContext_ = null;
      }
      return conversationContextBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> extraInfo_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetExtraInfo() {
      if (extraInfo_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ExtraInfoDefaultEntryHolder.defaultEntry);
      }
      return extraInfo_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableExtraInfo() {
      if (extraInfo_ == null) {
        extraInfo_ =
            com.google.protobuf.MapField.newMapField(ExtraInfoDefaultEntryHolder.defaultEntry);
      }
      if (!extraInfo_.isMutable()) {
        extraInfo_ = extraInfo_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return extraInfo_;
    }

    public int getExtraInfoCount() {
      return internalGetExtraInfo().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Key is the placeholder field name in input, value is the value of
     * the placeholder. E.g. instruction contains "&#64;price", and ingested data has
     * &lt;"price", "10"&gt;
     * </pre>
     *
     * <code>map&lt;string, string&gt; extra_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsExtraInfo(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetExtraInfo().getMap().containsKey(key);
    }

    /** Use {@link #getExtraInfoMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getExtraInfo() {
      return getExtraInfoMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Key is the placeholder field name in input, value is the value of
     * the placeholder. E.g. instruction contains "&#64;price", and ingested data has
     * &lt;"price", "10"&gt;
     * </pre>
     *
     * <code>map&lt;string, string&gt; extra_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getExtraInfoMap() {
      return internalGetExtraInfo().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Key is the placeholder field name in input, value is the value of
     * the placeholder. E.g. instruction contains "&#64;price", and ingested data has
     * &lt;"price", "10"&gt;
     * </pre>
     *
     * <code>map&lt;string, string&gt; extra_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getExtraInfoOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetExtraInfo().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Key is the placeholder field name in input, value is the value of
     * the placeholder. E.g. instruction contains "&#64;price", and ingested data has
     * &lt;"price", "10"&gt;
     * </pre>
     *
     * <code>map&lt;string, string&gt; extra_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getExtraInfoOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetExtraInfo().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearExtraInfo() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableExtraInfo().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Key is the placeholder field name in input, value is the value of
     * the placeholder. E.g. instruction contains "&#64;price", and ingested data has
     * &lt;"price", "10"&gt;
     * </pre>
     *
     * <code>map&lt;string, string&gt; extra_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeExtraInfo(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableExtraInfo().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableExtraInfo() {
      bitField0_ |= 0x00000002;
      return internalGetMutableExtraInfo().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Key is the placeholder field name in input, value is the value of
     * the placeholder. E.g. instruction contains "&#64;price", and ingested data has
     * &lt;"price", "10"&gt;
     * </pre>
     *
     * <code>map&lt;string, string&gt; extra_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putExtraInfo(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableExtraInfo().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Key is the placeholder field name in input, value is the value of
     * the placeholder. E.g. instruction contains "&#64;price", and ingested data has
     * &lt;"price", "10"&gt;
     * </pre>
     *
     * <code>map&lt;string, string&gt; extra_info = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllExtraInfo(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableExtraInfo().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SummarizationSectionList,
            com.google.cloud.dialogflow.v2.SummarizationSectionList.Builder,
            com.google.cloud.dialogflow.v2.SummarizationSectionListOrBuilder>
        summarizationSectionListBuilder_;

    /**
     *
     *
     * <pre>
     * Summarization sections.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SummarizationSectionList summarization_section_list = 6;
     * </code>
     *
     * @return Whether the summarizationSectionList field is set.
     */
    @java.lang.Override
    public boolean hasSummarizationSectionList() {
      return instructionListCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Summarization sections.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SummarizationSectionList summarization_section_list = 6;
     * </code>
     *
     * @return The summarizationSectionList.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SummarizationSectionList getSummarizationSectionList() {
      if (summarizationSectionListBuilder_ == null) {
        if (instructionListCase_ == 6) {
          return (com.google.cloud.dialogflow.v2.SummarizationSectionList) instructionList_;
        }
        return com.google.cloud.dialogflow.v2.SummarizationSectionList.getDefaultInstance();
      } else {
        if (instructionListCase_ == 6) {
          return summarizationSectionListBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2.SummarizationSectionList.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Summarization sections.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SummarizationSectionList summarization_section_list = 6;
     * </code>
     */
    public Builder setSummarizationSectionList(
        com.google.cloud.dialogflow.v2.SummarizationSectionList value) {
      if (summarizationSectionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instructionList_ = value;
        onChanged();
      } else {
        summarizationSectionListBuilder_.setMessage(value);
      }
      instructionListCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Summarization sections.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SummarizationSectionList summarization_section_list = 6;
     * </code>
     */
    public Builder setSummarizationSectionList(
        com.google.cloud.dialogflow.v2.SummarizationSectionList.Builder builderForValue) {
      if (summarizationSectionListBuilder_ == null) {
        instructionList_ = builderForValue.build();
        onChanged();
      } else {
        summarizationSectionListBuilder_.setMessage(builderForValue.build());
      }
      instructionListCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Summarization sections.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SummarizationSectionList summarization_section_list = 6;
     * </code>
     */
    public Builder mergeSummarizationSectionList(
        com.google.cloud.dialogflow.v2.SummarizationSectionList value) {
      if (summarizationSectionListBuilder_ == null) {
        if (instructionListCase_ == 6
            && instructionList_
                != com.google.cloud.dialogflow.v2.SummarizationSectionList.getDefaultInstance()) {
          instructionList_ =
              com.google.cloud.dialogflow.v2.SummarizationSectionList.newBuilder(
                      (com.google.cloud.dialogflow.v2.SummarizationSectionList) instructionList_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          instructionList_ = value;
        }
        onChanged();
      } else {
        if (instructionListCase_ == 6) {
          summarizationSectionListBuilder_.mergeFrom(value);
        } else {
          summarizationSectionListBuilder_.setMessage(value);
        }
      }
      instructionListCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Summarization sections.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SummarizationSectionList summarization_section_list = 6;
     * </code>
     */
    public Builder clearSummarizationSectionList() {
      if (summarizationSectionListBuilder_ == null) {
        if (instructionListCase_ == 6) {
          instructionListCase_ = 0;
          instructionList_ = null;
          onChanged();
        }
      } else {
        if (instructionListCase_ == 6) {
          instructionListCase_ = 0;
          instructionList_ = null;
        }
        summarizationSectionListBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Summarization sections.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SummarizationSectionList summarization_section_list = 6;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SummarizationSectionList.Builder
        getSummarizationSectionListBuilder() {
      return getSummarizationSectionListFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Summarization sections.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SummarizationSectionList summarization_section_list = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SummarizationSectionListOrBuilder
        getSummarizationSectionListOrBuilder() {
      if ((instructionListCase_ == 6) && (summarizationSectionListBuilder_ != null)) {
        return summarizationSectionListBuilder_.getMessageOrBuilder();
      } else {
        if (instructionListCase_ == 6) {
          return (com.google.cloud.dialogflow.v2.SummarizationSectionList) instructionList_;
        }
        return com.google.cloud.dialogflow.v2.SummarizationSectionList.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Summarization sections.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SummarizationSectionList summarization_section_list = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SummarizationSectionList,
            com.google.cloud.dialogflow.v2.SummarizationSectionList.Builder,
            com.google.cloud.dialogflow.v2.SummarizationSectionListOrBuilder>
        getSummarizationSectionListFieldBuilder() {
      if (summarizationSectionListBuilder_ == null) {
        if (!(instructionListCase_ == 6)) {
          instructionList_ =
              com.google.cloud.dialogflow.v2.SummarizationSectionList.getDefaultInstance();
        }
        summarizationSectionListBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.SummarizationSectionList,
                com.google.cloud.dialogflow.v2.SummarizationSectionList.Builder,
                com.google.cloud.dialogflow.v2.SummarizationSectionListOrBuilder>(
                (com.google.cloud.dialogflow.v2.SummarizationSectionList) instructionList_,
                getParentForChildren(),
                isClean());
        instructionList_ = null;
      }
      instructionListCase_ = 6;
      onChanged();
      return summarizationSectionListBuilder_;
    }

    private com.google.cloud.dialogflow.v2.GeneratorSuggestion output_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.GeneratorSuggestion,
            com.google.cloud.dialogflow.v2.GeneratorSuggestion.Builder,
            com.google.cloud.dialogflow.v2.GeneratorSuggestionOrBuilder>
        outputBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Example output of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GeneratorSuggestion output = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the output field is set.
     */
    public boolean hasOutput() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Example output of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GeneratorSuggestion output = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The output.
     */
    public com.google.cloud.dialogflow.v2.GeneratorSuggestion getOutput() {
      if (outputBuilder_ == null) {
        return output_ == null
            ? com.google.cloud.dialogflow.v2.GeneratorSuggestion.getDefaultInstance()
            : output_;
      } else {
        return outputBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Example output of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GeneratorSuggestion output = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutput(com.google.cloud.dialogflow.v2.GeneratorSuggestion value) {
      if (outputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        output_ = value;
      } else {
        outputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Example output of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GeneratorSuggestion output = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutput(
        com.google.cloud.dialogflow.v2.GeneratorSuggestion.Builder builderForValue) {
      if (outputBuilder_ == null) {
        output_ = builderForValue.build();
      } else {
        outputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Example output of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GeneratorSuggestion output = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeOutput(com.google.cloud.dialogflow.v2.GeneratorSuggestion value) {
      if (outputBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && output_ != null
            && output_ != com.google.cloud.dialogflow.v2.GeneratorSuggestion.getDefaultInstance()) {
          getOutputBuilder().mergeFrom(value);
        } else {
          output_ = value;
        }
      } else {
        outputBuilder_.mergeFrom(value);
      }
      if (output_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Example output of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GeneratorSuggestion output = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOutput() {
      bitField0_ = (bitField0_ & ~0x00000008);
      output_ = null;
      if (outputBuilder_ != null) {
        outputBuilder_.dispose();
        outputBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Example output of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GeneratorSuggestion output = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.GeneratorSuggestion.Builder getOutputBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getOutputFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Example output of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GeneratorSuggestion output = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.GeneratorSuggestionOrBuilder getOutputOrBuilder() {
      if (outputBuilder_ != null) {
        return outputBuilder_.getMessageOrBuilder();
      } else {
        return output_ == null
            ? com.google.cloud.dialogflow.v2.GeneratorSuggestion.getDefaultInstance()
            : output_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Example output of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.GeneratorSuggestion output = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.GeneratorSuggestion,
            com.google.cloud.dialogflow.v2.GeneratorSuggestion.Builder,
            com.google.cloud.dialogflow.v2.GeneratorSuggestionOrBuilder>
        getOutputFieldBuilder() {
      if (outputBuilder_ == null) {
        outputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.GeneratorSuggestion,
                com.google.cloud.dialogflow.v2.GeneratorSuggestion.Builder,
                com.google.cloud.dialogflow.v2.GeneratorSuggestionOrBuilder>(
                getOutput(), getParentForChildren(), isClean());
        output_ = null;
      }
      return outputBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.FewShotExample)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.FewShotExample)
  private static final com.google.cloud.dialogflow.v2.FewShotExample DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.FewShotExample();
  }

  public static com.google.cloud.dialogflow.v2.FewShotExample getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FewShotExample> PARSER =
      new com.google.protobuf.AbstractParser<FewShotExample>() {
        @java.lang.Override
        public FewShotExample parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FewShotExample> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FewShotExample> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.FewShotExample getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
