/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/conversation_model.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * The configuration for model evaluation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.EvaluationConfig}
 */
public final class EvaluationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.EvaluationConfig)
    EvaluationConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EvaluationConfig.newBuilder() to construct.
  private EvaluationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EvaluationConfig() {
    datasets_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EvaluationConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private EvaluationConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 18:
            {
              com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.Builder subBuilder =
                  null;
              if (modelSpecificConfigCase_ == 2) {
                subBuilder =
                    ((com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
                            modelSpecificConfig_)
                        .toBuilder();
              }
              modelSpecificConfig_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
                        modelSpecificConfig_);
                modelSpecificConfig_ = subBuilder.buildPartial();
              }
              modelSpecificConfigCase_ = 2;
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                datasets_ = new java.util.ArrayList<com.google.cloud.dialogflow.v2.InputDataset>();
                mutable_bitField0_ |= 0x00000001;
              }
              datasets_.add(
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.InputDataset.parser(), extensionRegistry));
              break;
            }
          case 34:
            {
              com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.Builder
                  subBuilder = null;
              if (modelSpecificConfigCase_ == 4) {
                subBuilder =
                    ((com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
                            modelSpecificConfig_)
                        .toBuilder();
              }
              modelSpecificConfig_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
                        modelSpecificConfig_);
                modelSpecificConfig_ = subBuilder.buildPartial();
              }
              modelSpecificConfigCase_ = 4;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        datasets_ = java.util.Collections.unmodifiableList(datasets_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ConversationModelProto
        .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ConversationModelProto
        .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.EvaluationConfig.class,
            com.google.cloud.dialogflow.v2.EvaluationConfig.Builder.class);
  }

  public interface SmartReplyConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The allowlist document resource name.
     * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
     * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart reply model.
     * </pre>
     *
     * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The allowlistDocument.
     */
    java.lang.String getAllowlistDocument();
    /**
     *
     *
     * <pre>
     * The allowlist document resource name.
     * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
     * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart reply model.
     * </pre>
     *
     * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for allowlistDocument.
     */
    com.google.protobuf.ByteString getAllowlistDocumentBytes();

    /**
     *
     *
     * <pre>
     * Required. The model to be evaluated can return multiple results with confidence
     * score on each query. These results will be sorted by the descending order
     * of the scores and we only keep the first max_result_count results as the
     * final results to evaluate.
     * </pre>
     *
     * <code>int32 max_result_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The maxResultCount.
     */
    int getMaxResultCount();
  }
  /**
   *
   *
   * <pre>
   * Smart reply specific configuration for evaluation job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig}
   */
  public static final class SmartReplyConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
      SmartReplyConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SmartReplyConfig.newBuilder() to construct.
    private SmartReplyConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SmartReplyConfig() {
      allowlistDocument_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SmartReplyConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private SmartReplyConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                allowlistDocument_ = s;
                break;
              }
            case 16:
              {
                maxResultCount_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_SmartReplyConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_SmartReplyConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.class,
              com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.Builder.class);
    }

    public static final int ALLOWLIST_DOCUMENT_FIELD_NUMBER = 1;
    private volatile java.lang.Object allowlistDocument_;
    /**
     *
     *
     * <pre>
     * The allowlist document resource name.
     * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
     * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart reply model.
     * </pre>
     *
     * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The allowlistDocument.
     */
    @java.lang.Override
    public java.lang.String getAllowlistDocument() {
      java.lang.Object ref = allowlistDocument_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        allowlistDocument_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The allowlist document resource name.
     * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
     * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart reply model.
     * </pre>
     *
     * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for allowlistDocument.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAllowlistDocumentBytes() {
      java.lang.Object ref = allowlistDocument_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        allowlistDocument_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MAX_RESULT_COUNT_FIELD_NUMBER = 2;
    private int maxResultCount_;
    /**
     *
     *
     * <pre>
     * Required. The model to be evaluated can return multiple results with confidence
     * score on each query. These results will be sorted by the descending order
     * of the scores and we only keep the first max_result_count results as the
     * final results to evaluate.
     * </pre>
     *
     * <code>int32 max_result_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The maxResultCount.
     */
    @java.lang.Override
    public int getMaxResultCount() {
      return maxResultCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(allowlistDocument_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, allowlistDocument_);
      }
      if (maxResultCount_ != 0) {
        output.writeInt32(2, maxResultCount_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(allowlistDocument_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, allowlistDocument_);
      }
      if (maxResultCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxResultCount_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig other =
          (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig) obj;

      if (!getAllowlistDocument().equals(other.getAllowlistDocument())) return false;
      if (getMaxResultCount() != other.getMaxResultCount()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ALLOWLIST_DOCUMENT_FIELD_NUMBER;
      hash = (53 * hash) + getAllowlistDocument().hashCode();
      hash = (37 * hash) + MAX_RESULT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMaxResultCount();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Smart reply specific configuration for evaluation job.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.ConversationModelProto
            .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_SmartReplyConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.ConversationModelProto
            .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_SmartReplyConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.class,
                com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        allowlistDocument_ = "";

        maxResultCount_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2.ConversationModelProto
            .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_SmartReplyConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig build() {
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig buildPartial() {
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig result =
            new com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig(this);
        result.allowlistDocument_ = allowlistDocument_;
        result.maxResultCount_ = maxResultCount_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig other) {
        if (other
            == com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
                .getDefaultInstance()) return this;
        if (!other.getAllowlistDocument().isEmpty()) {
          allowlistDocument_ = other.allowlistDocument_;
          onChanged();
        }
        if (other.getMaxResultCount() != 0) {
          setMaxResultCount(other.getMaxResultCount());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object allowlistDocument_ = "";
      /**
       *
       *
       * <pre>
       * The allowlist document resource name.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart reply model.
       * </pre>
       *
       * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The allowlistDocument.
       */
      public java.lang.String getAllowlistDocument() {
        java.lang.Object ref = allowlistDocument_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          allowlistDocument_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The allowlist document resource name.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart reply model.
       * </pre>
       *
       * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for allowlistDocument.
       */
      public com.google.protobuf.ByteString getAllowlistDocumentBytes() {
        java.lang.Object ref = allowlistDocument_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          allowlistDocument_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The allowlist document resource name.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart reply model.
       * </pre>
       *
       * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The allowlistDocument to set.
       * @return This builder for chaining.
       */
      public Builder setAllowlistDocument(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        allowlistDocument_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The allowlist document resource name.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart reply model.
       * </pre>
       *
       * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowlistDocument() {

        allowlistDocument_ = getDefaultInstance().getAllowlistDocument();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The allowlist document resource name.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart reply model.
       * </pre>
       *
       * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for allowlistDocument to set.
       * @return This builder for chaining.
       */
      public Builder setAllowlistDocumentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        allowlistDocument_ = value;
        onChanged();
        return this;
      }

      private int maxResultCount_;
      /**
       *
       *
       * <pre>
       * Required. The model to be evaluated can return multiple results with confidence
       * score on each query. These results will be sorted by the descending order
       * of the scores and we only keep the first max_result_count results as the
       * final results to evaluate.
       * </pre>
       *
       * <code>int32 max_result_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxResultCount.
       */
      @java.lang.Override
      public int getMaxResultCount() {
        return maxResultCount_;
      }
      /**
       *
       *
       * <pre>
       * Required. The model to be evaluated can return multiple results with confidence
       * score on each query. These results will be sorted by the descending order
       * of the scores and we only keep the first max_result_count results as the
       * final results to evaluate.
       * </pre>
       *
       * <code>int32 max_result_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The maxResultCount to set.
       * @return This builder for chaining.
       */
      public Builder setMaxResultCount(int value) {

        maxResultCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The model to be evaluated can return multiple results with confidence
       * score on each query. These results will be sorted by the descending order
       * of the scores and we only keep the first max_result_count results as the
       * final results to evaluate.
       * </pre>
       *
       * <code>int32 max_result_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxResultCount() {

        maxResultCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
    private static final com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig();
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SmartReplyConfig> PARSER =
        new com.google.protobuf.AbstractParser<SmartReplyConfig>() {
          @java.lang.Override
          public SmartReplyConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new SmartReplyConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<SmartReplyConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SmartReplyConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SmartComposeConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The allowlist document resource name.
     * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
     * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart compose model.
     * </pre>
     *
     * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The allowlistDocument.
     */
    java.lang.String getAllowlistDocument();
    /**
     *
     *
     * <pre>
     * The allowlist document resource name.
     * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
     * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart compose model.
     * </pre>
     *
     * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for allowlistDocument.
     */
    com.google.protobuf.ByteString getAllowlistDocumentBytes();

    /**
     *
     *
     * <pre>
     * Required. The model to be evaluated can return multiple results with confidence
     * score on each query. These results will be sorted by the descending order
     * of the scores and we only keep the first max_result_count results as the
     * final results to evaluate.
     * </pre>
     *
     * <code>int32 max_result_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The maxResultCount.
     */
    int getMaxResultCount();
  }
  /**
   *
   *
   * <pre>
   * Smart compose specific configuration for evaluation job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig}
   */
  public static final class SmartComposeConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
      SmartComposeConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SmartComposeConfig.newBuilder() to construct.
    private SmartComposeConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SmartComposeConfig() {
      allowlistDocument_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SmartComposeConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private SmartComposeConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                allowlistDocument_ = s;
                break;
              }
            case 16:
              {
                maxResultCount_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_SmartComposeConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_SmartComposeConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.class,
              com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.Builder.class);
    }

    public static final int ALLOWLIST_DOCUMENT_FIELD_NUMBER = 1;
    private volatile java.lang.Object allowlistDocument_;
    /**
     *
     *
     * <pre>
     * The allowlist document resource name.
     * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
     * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart compose model.
     * </pre>
     *
     * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The allowlistDocument.
     */
    @java.lang.Override
    public java.lang.String getAllowlistDocument() {
      java.lang.Object ref = allowlistDocument_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        allowlistDocument_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The allowlist document resource name.
     * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
     * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart compose model.
     * </pre>
     *
     * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for allowlistDocument.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAllowlistDocumentBytes() {
      java.lang.Object ref = allowlistDocument_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        allowlistDocument_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MAX_RESULT_COUNT_FIELD_NUMBER = 2;
    private int maxResultCount_;
    /**
     *
     *
     * <pre>
     * Required. The model to be evaluated can return multiple results with confidence
     * score on each query. These results will be sorted by the descending order
     * of the scores and we only keep the first max_result_count results as the
     * final results to evaluate.
     * </pre>
     *
     * <code>int32 max_result_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The maxResultCount.
     */
    @java.lang.Override
    public int getMaxResultCount() {
      return maxResultCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(allowlistDocument_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, allowlistDocument_);
      }
      if (maxResultCount_ != 0) {
        output.writeInt32(2, maxResultCount_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(allowlistDocument_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, allowlistDocument_);
      }
      if (maxResultCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, maxResultCount_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig other =
          (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig) obj;

      if (!getAllowlistDocument().equals(other.getAllowlistDocument())) return false;
      if (getMaxResultCount() != other.getMaxResultCount()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ALLOWLIST_DOCUMENT_FIELD_NUMBER;
      hash = (53 * hash) + getAllowlistDocument().hashCode();
      hash = (37 * hash) + MAX_RESULT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getMaxResultCount();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Smart compose specific configuration for evaluation job.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.ConversationModelProto
            .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_SmartComposeConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.ConversationModelProto
            .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_SmartComposeConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.class,
                com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        allowlistDocument_ = "";

        maxResultCount_ = 0;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2.ConversationModelProto
            .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_SmartComposeConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig build() {
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig buildPartial() {
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig result =
            new com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig(this);
        result.allowlistDocument_ = allowlistDocument_;
        result.maxResultCount_ = maxResultCount_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig other) {
        if (other
            == com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
                .getDefaultInstance()) return this;
        if (!other.getAllowlistDocument().isEmpty()) {
          allowlistDocument_ = other.allowlistDocument_;
          onChanged();
        }
        if (other.getMaxResultCount() != 0) {
          setMaxResultCount(other.getMaxResultCount());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object allowlistDocument_ = "";
      /**
       *
       *
       * <pre>
       * The allowlist document resource name.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart compose model.
       * </pre>
       *
       * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The allowlistDocument.
       */
      public java.lang.String getAllowlistDocument() {
        java.lang.Object ref = allowlistDocument_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          allowlistDocument_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The allowlist document resource name.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart compose model.
       * </pre>
       *
       * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for allowlistDocument.
       */
      public com.google.protobuf.ByteString getAllowlistDocumentBytes() {
        java.lang.Object ref = allowlistDocument_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          allowlistDocument_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The allowlist document resource name.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart compose model.
       * </pre>
       *
       * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The allowlistDocument to set.
       * @return This builder for chaining.
       */
      public Builder setAllowlistDocument(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        allowlistDocument_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The allowlist document resource name.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart compose model.
       * </pre>
       *
       * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowlistDocument() {

        allowlistDocument_ = getDefaultInstance().getAllowlistDocument();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The allowlist document resource name.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`. Only used for smart compose model.
       * </pre>
       *
       * <code>string allowlist_document = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for allowlistDocument to set.
       * @return This builder for chaining.
       */
      public Builder setAllowlistDocumentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        allowlistDocument_ = value;
        onChanged();
        return this;
      }

      private int maxResultCount_;
      /**
       *
       *
       * <pre>
       * Required. The model to be evaluated can return multiple results with confidence
       * score on each query. These results will be sorted by the descending order
       * of the scores and we only keep the first max_result_count results as the
       * final results to evaluate.
       * </pre>
       *
       * <code>int32 max_result_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxResultCount.
       */
      @java.lang.Override
      public int getMaxResultCount() {
        return maxResultCount_;
      }
      /**
       *
       *
       * <pre>
       * Required. The model to be evaluated can return multiple results with confidence
       * score on each query. These results will be sorted by the descending order
       * of the scores and we only keep the first max_result_count results as the
       * final results to evaluate.
       * </pre>
       *
       * <code>int32 max_result_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The maxResultCount to set.
       * @return This builder for chaining.
       */
      public Builder setMaxResultCount(int value) {

        maxResultCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The model to be evaluated can return multiple results with confidence
       * score on each query. These results will be sorted by the descending order
       * of the scores and we only keep the first max_result_count results as the
       * final results to evaluate.
       * </pre>
       *
       * <code>int32 max_result_count = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxResultCount() {

        maxResultCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
    private static final com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig();
    }

    public static com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SmartComposeConfig> PARSER =
        new com.google.protobuf.AbstractParser<SmartComposeConfig>() {
          @java.lang.Override
          public SmartComposeConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new SmartComposeConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<SmartComposeConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SmartComposeConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int modelSpecificConfigCase_ = 0;
  private java.lang.Object modelSpecificConfig_;

  public enum ModelSpecificConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SMART_REPLY_CONFIG(2),
    SMART_COMPOSE_CONFIG(4),
    MODELSPECIFICCONFIG_NOT_SET(0);
    private final int value;

    private ModelSpecificConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModelSpecificConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static ModelSpecificConfigCase forNumber(int value) {
      switch (value) {
        case 2:
          return SMART_REPLY_CONFIG;
        case 4:
          return SMART_COMPOSE_CONFIG;
        case 0:
          return MODELSPECIFICCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ModelSpecificConfigCase getModelSpecificConfigCase() {
    return ModelSpecificConfigCase.forNumber(modelSpecificConfigCase_);
  }

  public static final int DATASETS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.dialogflow.v2.InputDataset> datasets_;
  /**
   *
   *
   * <pre>
   * Required. Datasets used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2.InputDataset> getDatasetsList() {
    return datasets_;
  }
  /**
   *
   *
   * <pre>
   * Required. Datasets used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2.InputDatasetOrBuilder>
      getDatasetsOrBuilderList() {
    return datasets_;
  }
  /**
   *
   *
   * <pre>
   * Required. Datasets used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getDatasetsCount() {
    return datasets_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Datasets used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.InputDataset getDatasets(int index) {
    return datasets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Datasets used for evaluation.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.InputDatasetOrBuilder getDatasetsOrBuilder(int index) {
    return datasets_.get(index);
  }

  public static final int SMART_REPLY_CONFIG_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Configuration for smart reply model evalution.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig smart_reply_config = 2;
   * </code>
   *
   * @return Whether the smartReplyConfig field is set.
   */
  @java.lang.Override
  public boolean hasSmartReplyConfig() {
    return modelSpecificConfigCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Configuration for smart reply model evalution.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig smart_reply_config = 2;
   * </code>
   *
   * @return The smartReplyConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig getSmartReplyConfig() {
    if (modelSpecificConfigCase_ == 2) {
      return (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
          modelSpecificConfig_;
    }
    return com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for smart reply model evalution.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig smart_reply_config = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfigOrBuilder
      getSmartReplyConfigOrBuilder() {
    if (modelSpecificConfigCase_ == 2) {
      return (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
          modelSpecificConfig_;
    }
    return com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.getDefaultInstance();
  }

  public static final int SMART_COMPOSE_CONFIG_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Configuration for smart compose model evalution.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig smart_compose_config = 4;
   * </code>
   *
   * @return Whether the smartComposeConfig field is set.
   */
  @java.lang.Override
  public boolean hasSmartComposeConfig() {
    return modelSpecificConfigCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Configuration for smart compose model evalution.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig smart_compose_config = 4;
   * </code>
   *
   * @return The smartComposeConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
      getSmartComposeConfig() {
    if (modelSpecificConfigCase_ == 4) {
      return (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
          modelSpecificConfig_;
    }
    return com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for smart compose model evalution.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig smart_compose_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfigOrBuilder
      getSmartComposeConfigOrBuilder() {
    if (modelSpecificConfigCase_ == 4) {
      return (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
          modelSpecificConfig_;
    }
    return com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (modelSpecificConfigCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig) modelSpecificConfig_);
    }
    for (int i = 0; i < datasets_.size(); i++) {
      output.writeMessage(3, datasets_.get(i));
    }
    if (modelSpecificConfigCase_ == 4) {
      output.writeMessage(
          4,
          (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
              modelSpecificConfig_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (modelSpecificConfigCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
                  modelSpecificConfig_);
    }
    for (int i = 0; i < datasets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, datasets_.get(i));
    }
    if (modelSpecificConfigCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
                  modelSpecificConfig_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.EvaluationConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.EvaluationConfig other =
        (com.google.cloud.dialogflow.v2.EvaluationConfig) obj;

    if (!getDatasetsList().equals(other.getDatasetsList())) return false;
    if (!getModelSpecificConfigCase().equals(other.getModelSpecificConfigCase())) return false;
    switch (modelSpecificConfigCase_) {
      case 2:
        if (!getSmartReplyConfig().equals(other.getSmartReplyConfig())) return false;
        break;
      case 4:
        if (!getSmartComposeConfig().equals(other.getSmartComposeConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getDatasetsCount() > 0) {
      hash = (37 * hash) + DATASETS_FIELD_NUMBER;
      hash = (53 * hash) + getDatasetsList().hashCode();
    }
    switch (modelSpecificConfigCase_) {
      case 2:
        hash = (37 * hash) + SMART_REPLY_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getSmartReplyConfig().hashCode();
        break;
      case 4:
        hash = (37 * hash) + SMART_COMPOSE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getSmartComposeConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.EvaluationConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.EvaluationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.EvaluationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.EvaluationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.EvaluationConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.EvaluationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.EvaluationConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.EvaluationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.EvaluationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.EvaluationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.EvaluationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.EvaluationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.EvaluationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration for model evaluation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.EvaluationConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.EvaluationConfig)
      com.google.cloud.dialogflow.v2.EvaluationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.EvaluationConfig.class,
              com.google.cloud.dialogflow.v2.EvaluationConfig.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.EvaluationConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDatasetsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (datasetsBuilder_ == null) {
        datasets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        datasetsBuilder_.clear();
      }
      modelSpecificConfigCase_ = 0;
      modelSpecificConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_EvaluationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EvaluationConfig getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.EvaluationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EvaluationConfig build() {
      com.google.cloud.dialogflow.v2.EvaluationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EvaluationConfig buildPartial() {
      com.google.cloud.dialogflow.v2.EvaluationConfig result =
          new com.google.cloud.dialogflow.v2.EvaluationConfig(this);
      int from_bitField0_ = bitField0_;
      if (datasetsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          datasets_ = java.util.Collections.unmodifiableList(datasets_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.datasets_ = datasets_;
      } else {
        result.datasets_ = datasetsBuilder_.build();
      }
      if (modelSpecificConfigCase_ == 2) {
        if (smartReplyConfigBuilder_ == null) {
          result.modelSpecificConfig_ = modelSpecificConfig_;
        } else {
          result.modelSpecificConfig_ = smartReplyConfigBuilder_.build();
        }
      }
      if (modelSpecificConfigCase_ == 4) {
        if (smartComposeConfigBuilder_ == null) {
          result.modelSpecificConfig_ = modelSpecificConfig_;
        } else {
          result.modelSpecificConfig_ = smartComposeConfigBuilder_.build();
        }
      }
      result.modelSpecificConfigCase_ = modelSpecificConfigCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.EvaluationConfig) {
        return mergeFrom((com.google.cloud.dialogflow.v2.EvaluationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.EvaluationConfig other) {
      if (other == com.google.cloud.dialogflow.v2.EvaluationConfig.getDefaultInstance())
        return this;
      if (datasetsBuilder_ == null) {
        if (!other.datasets_.isEmpty()) {
          if (datasets_.isEmpty()) {
            datasets_ = other.datasets_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDatasetsIsMutable();
            datasets_.addAll(other.datasets_);
          }
          onChanged();
        }
      } else {
        if (!other.datasets_.isEmpty()) {
          if (datasetsBuilder_.isEmpty()) {
            datasetsBuilder_.dispose();
            datasetsBuilder_ = null;
            datasets_ = other.datasets_;
            bitField0_ = (bitField0_ & ~0x00000001);
            datasetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDatasetsFieldBuilder()
                    : null;
          } else {
            datasetsBuilder_.addAllMessages(other.datasets_);
          }
        }
      }
      switch (other.getModelSpecificConfigCase()) {
        case SMART_REPLY_CONFIG:
          {
            mergeSmartReplyConfig(other.getSmartReplyConfig());
            break;
          }
        case SMART_COMPOSE_CONFIG:
          {
            mergeSmartComposeConfig(other.getSmartComposeConfig());
            break;
          }
        case MODELSPECIFICCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2.EvaluationConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.dialogflow.v2.EvaluationConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int modelSpecificConfigCase_ = 0;
    private java.lang.Object modelSpecificConfig_;

    public ModelSpecificConfigCase getModelSpecificConfigCase() {
      return ModelSpecificConfigCase.forNumber(modelSpecificConfigCase_);
    }

    public Builder clearModelSpecificConfig() {
      modelSpecificConfigCase_ = 0;
      modelSpecificConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.dialogflow.v2.InputDataset> datasets_ =
        java.util.Collections.emptyList();

    private void ensureDatasetsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        datasets_ = new java.util.ArrayList<com.google.cloud.dialogflow.v2.InputDataset>(datasets_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.InputDataset,
            com.google.cloud.dialogflow.v2.InputDataset.Builder,
            com.google.cloud.dialogflow.v2.InputDatasetOrBuilder>
        datasetsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.InputDataset> getDatasetsList() {
      if (datasetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(datasets_);
      } else {
        return datasetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getDatasetsCount() {
      if (datasetsBuilder_ == null) {
        return datasets_.size();
      } else {
        return datasetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.InputDataset getDatasets(int index) {
      if (datasetsBuilder_ == null) {
        return datasets_.get(index);
      } else {
        return datasetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDatasets(int index, com.google.cloud.dialogflow.v2.InputDataset value) {
      if (datasetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDatasetsIsMutable();
        datasets_.set(index, value);
        onChanged();
      } else {
        datasetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDatasets(
        int index, com.google.cloud.dialogflow.v2.InputDataset.Builder builderForValue) {
      if (datasetsBuilder_ == null) {
        ensureDatasetsIsMutable();
        datasets_.set(index, builderForValue.build());
        onChanged();
      } else {
        datasetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDatasets(com.google.cloud.dialogflow.v2.InputDataset value) {
      if (datasetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDatasetsIsMutable();
        datasets_.add(value);
        onChanged();
      } else {
        datasetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDatasets(int index, com.google.cloud.dialogflow.v2.InputDataset value) {
      if (datasetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDatasetsIsMutable();
        datasets_.add(index, value);
        onChanged();
      } else {
        datasetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDatasets(
        com.google.cloud.dialogflow.v2.InputDataset.Builder builderForValue) {
      if (datasetsBuilder_ == null) {
        ensureDatasetsIsMutable();
        datasets_.add(builderForValue.build());
        onChanged();
      } else {
        datasetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDatasets(
        int index, com.google.cloud.dialogflow.v2.InputDataset.Builder builderForValue) {
      if (datasetsBuilder_ == null) {
        ensureDatasetsIsMutable();
        datasets_.add(index, builderForValue.build());
        onChanged();
      } else {
        datasetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllDatasets(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.InputDataset> values) {
      if (datasetsBuilder_ == null) {
        ensureDatasetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, datasets_);
        onChanged();
      } else {
        datasetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDatasets() {
      if (datasetsBuilder_ == null) {
        datasets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        datasetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeDatasets(int index) {
      if (datasetsBuilder_ == null) {
        ensureDatasetsIsMutable();
        datasets_.remove(index);
        onChanged();
      } else {
        datasetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.InputDataset.Builder getDatasetsBuilder(int index) {
      return getDatasetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.InputDatasetOrBuilder getDatasetsOrBuilder(int index) {
      if (datasetsBuilder_ == null) {
        return datasets_.get(index);
      } else {
        return datasetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2.InputDatasetOrBuilder>
        getDatasetsOrBuilderList() {
      if (datasetsBuilder_ != null) {
        return datasetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(datasets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.InputDataset.Builder addDatasetsBuilder() {
      return getDatasetsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2.InputDataset.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.InputDataset.Builder addDatasetsBuilder(int index) {
      return getDatasetsFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.v2.InputDataset.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used for evaluation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.InputDataset.Builder>
        getDatasetsBuilderList() {
      return getDatasetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.InputDataset,
            com.google.cloud.dialogflow.v2.InputDataset.Builder,
            com.google.cloud.dialogflow.v2.InputDatasetOrBuilder>
        getDatasetsFieldBuilder() {
      if (datasetsBuilder_ == null) {
        datasetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.InputDataset,
                com.google.cloud.dialogflow.v2.InputDataset.Builder,
                com.google.cloud.dialogflow.v2.InputDatasetOrBuilder>(
                datasets_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        datasets_ = null;
      }
      return datasetsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig,
            com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.Builder,
            com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfigOrBuilder>
        smartReplyConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for smart reply model evalution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig smart_reply_config = 2;
     * </code>
     *
     * @return Whether the smartReplyConfig field is set.
     */
    @java.lang.Override
    public boolean hasSmartReplyConfig() {
      return modelSpecificConfigCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart reply model evalution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig smart_reply_config = 2;
     * </code>
     *
     * @return The smartReplyConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig getSmartReplyConfig() {
      if (smartReplyConfigBuilder_ == null) {
        if (modelSpecificConfigCase_ == 2) {
          return (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
              modelSpecificConfig_;
        }
        return com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
            .getDefaultInstance();
      } else {
        if (modelSpecificConfigCase_ == 2) {
          return smartReplyConfigBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart reply model evalution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig smart_reply_config = 2;
     * </code>
     */
    public Builder setSmartReplyConfig(
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig value) {
      if (smartReplyConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelSpecificConfig_ = value;
        onChanged();
      } else {
        smartReplyConfigBuilder_.setMessage(value);
      }
      modelSpecificConfigCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart reply model evalution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig smart_reply_config = 2;
     * </code>
     */
    public Builder setSmartReplyConfig(
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.Builder builderForValue) {
      if (smartReplyConfigBuilder_ == null) {
        modelSpecificConfig_ = builderForValue.build();
        onChanged();
      } else {
        smartReplyConfigBuilder_.setMessage(builderForValue.build());
      }
      modelSpecificConfigCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart reply model evalution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig smart_reply_config = 2;
     * </code>
     */
    public Builder mergeSmartReplyConfig(
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig value) {
      if (smartReplyConfigBuilder_ == null) {
        if (modelSpecificConfigCase_ == 2
            && modelSpecificConfig_
                != com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
                    .getDefaultInstance()) {
          modelSpecificConfig_ =
              com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.newBuilder(
                      (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
                          modelSpecificConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelSpecificConfig_ = value;
        }
        onChanged();
      } else {
        if (modelSpecificConfigCase_ == 2) {
          smartReplyConfigBuilder_.mergeFrom(value);
        } else {
          smartReplyConfigBuilder_.setMessage(value);
        }
      }
      modelSpecificConfigCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart reply model evalution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig smart_reply_config = 2;
     * </code>
     */
    public Builder clearSmartReplyConfig() {
      if (smartReplyConfigBuilder_ == null) {
        if (modelSpecificConfigCase_ == 2) {
          modelSpecificConfigCase_ = 0;
          modelSpecificConfig_ = null;
          onChanged();
        }
      } else {
        if (modelSpecificConfigCase_ == 2) {
          modelSpecificConfigCase_ = 0;
          modelSpecificConfig_ = null;
        }
        smartReplyConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart reply model evalution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig smart_reply_config = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.Builder
        getSmartReplyConfigBuilder() {
      return getSmartReplyConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart reply model evalution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig smart_reply_config = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfigOrBuilder
        getSmartReplyConfigOrBuilder() {
      if ((modelSpecificConfigCase_ == 2) && (smartReplyConfigBuilder_ != null)) {
        return smartReplyConfigBuilder_.getMessageOrBuilder();
      } else {
        if (modelSpecificConfigCase_ == 2) {
          return (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
              modelSpecificConfig_;
        }
        return com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart reply model evalution.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig smart_reply_config = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig,
            com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.Builder,
            com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfigOrBuilder>
        getSmartReplyConfigFieldBuilder() {
      if (smartReplyConfigBuilder_ == null) {
        if (!(modelSpecificConfigCase_ == 2)) {
          modelSpecificConfig_ =
              com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.getDefaultInstance();
        }
        smartReplyConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig,
                com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig.Builder,
                com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfigOrBuilder>(
                (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartReplyConfig)
                    modelSpecificConfig_,
                getParentForChildren(),
                isClean());
        modelSpecificConfig_ = null;
      }
      modelSpecificConfigCase_ = 2;
      onChanged();
      ;
      return smartReplyConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig,
            com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.Builder,
            com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfigOrBuilder>
        smartComposeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for smart compose model evalution.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig smart_compose_config = 4;
     * </code>
     *
     * @return Whether the smartComposeConfig field is set.
     */
    @java.lang.Override
    public boolean hasSmartComposeConfig() {
      return modelSpecificConfigCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart compose model evalution.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig smart_compose_config = 4;
     * </code>
     *
     * @return The smartComposeConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
        getSmartComposeConfig() {
      if (smartComposeConfigBuilder_ == null) {
        if (modelSpecificConfigCase_ == 4) {
          return (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
              modelSpecificConfig_;
        }
        return com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
            .getDefaultInstance();
      } else {
        if (modelSpecificConfigCase_ == 4) {
          return smartComposeConfigBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart compose model evalution.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig smart_compose_config = 4;
     * </code>
     */
    public Builder setSmartComposeConfig(
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig value) {
      if (smartComposeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelSpecificConfig_ = value;
        onChanged();
      } else {
        smartComposeConfigBuilder_.setMessage(value);
      }
      modelSpecificConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart compose model evalution.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig smart_compose_config = 4;
     * </code>
     */
    public Builder setSmartComposeConfig(
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.Builder
            builderForValue) {
      if (smartComposeConfigBuilder_ == null) {
        modelSpecificConfig_ = builderForValue.build();
        onChanged();
      } else {
        smartComposeConfigBuilder_.setMessage(builderForValue.build());
      }
      modelSpecificConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart compose model evalution.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig smart_compose_config = 4;
     * </code>
     */
    public Builder mergeSmartComposeConfig(
        com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig value) {
      if (smartComposeConfigBuilder_ == null) {
        if (modelSpecificConfigCase_ == 4
            && modelSpecificConfig_
                != com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
                    .getDefaultInstance()) {
          modelSpecificConfig_ =
              com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.newBuilder(
                      (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
                          modelSpecificConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelSpecificConfig_ = value;
        }
        onChanged();
      } else {
        if (modelSpecificConfigCase_ == 4) {
          smartComposeConfigBuilder_.mergeFrom(value);
        } else {
          smartComposeConfigBuilder_.setMessage(value);
        }
      }
      modelSpecificConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart compose model evalution.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig smart_compose_config = 4;
     * </code>
     */
    public Builder clearSmartComposeConfig() {
      if (smartComposeConfigBuilder_ == null) {
        if (modelSpecificConfigCase_ == 4) {
          modelSpecificConfigCase_ = 0;
          modelSpecificConfig_ = null;
          onChanged();
        }
      } else {
        if (modelSpecificConfigCase_ == 4) {
          modelSpecificConfigCase_ = 0;
          modelSpecificConfig_ = null;
        }
        smartComposeConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart compose model evalution.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig smart_compose_config = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.Builder
        getSmartComposeConfigBuilder() {
      return getSmartComposeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart compose model evalution.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig smart_compose_config = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfigOrBuilder
        getSmartComposeConfigOrBuilder() {
      if ((modelSpecificConfigCase_ == 4) && (smartComposeConfigBuilder_ != null)) {
        return smartComposeConfigBuilder_.getMessageOrBuilder();
      } else {
        if (modelSpecificConfigCase_ == 4) {
          return (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
              modelSpecificConfig_;
        }
        return com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for smart compose model evalution.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig smart_compose_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig,
            com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.Builder,
            com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfigOrBuilder>
        getSmartComposeConfigFieldBuilder() {
      if (smartComposeConfigBuilder_ == null) {
        if (!(modelSpecificConfigCase_ == 4)) {
          modelSpecificConfig_ =
              com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig
                  .getDefaultInstance();
        }
        smartComposeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig,
                com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig.Builder,
                com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfigOrBuilder>(
                (com.google.cloud.dialogflow.v2.EvaluationConfig.SmartComposeConfig)
                    modelSpecificConfig_,
                getParentForChildren(),
                isClean());
        modelSpecificConfig_ = null;
      }
      modelSpecificConfigCase_ = 4;
      onChanged();
      ;
      return smartComposeConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.EvaluationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.EvaluationConfig)
  private static final com.google.cloud.dialogflow.v2.EvaluationConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.EvaluationConfig();
  }

  public static com.google.cloud.dialogflow.v2.EvaluationConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EvaluationConfig> PARSER =
      new com.google.protobuf.AbstractParser<EvaluationConfig>() {
        @java.lang.Override
        public EvaluationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new EvaluationConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<EvaluationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EvaluationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EvaluationConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
