/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/conversation_event.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Represents a notification sent to Pub/Sub subscribers for conversation
 * lifecycle events.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.ConversationEvent}
 */
public final class ConversationEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.ConversationEvent)
    ConversationEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConversationEvent.newBuilder() to construct.
  private ConversationEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConversationEvent() {
    conversation_ = "";
    type_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConversationEvent();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ConversationEvent(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              conversation_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
          case 26:
            {
              com.google.rpc.Status.Builder subBuilder = null;
              if (errorStatus_ != null) {
                subBuilder = errorStatus_.toBuilder();
              }
              errorStatus_ = input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(errorStatus_);
                errorStatus_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.cloud.dialogflow.v2.Message.Builder subBuilder = null;
              if (payloadCase_ == 4) {
                subBuilder = ((com.google.cloud.dialogflow.v2.Message) payload_).toBuilder();
              }
              payload_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.Message.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.dialogflow.v2.Message) payload_);
                payload_ = subBuilder.buildPartial();
              }
              payloadCase_ = 4;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ConversationEventProto
        .internal_static_google_cloud_dialogflow_v2_ConversationEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ConversationEventProto
        .internal_static_google_cloud_dialogflow_v2_ConversationEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.ConversationEvent.class,
            com.google.cloud.dialogflow.v2.ConversationEvent.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enumeration of the types of events available.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2.ConversationEvent.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Type not set.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A new conversation has been opened. This is fired when a telephone call
     * is answered, or a conversation is created via the API.
     * </pre>
     *
     * <code>CONVERSATION_STARTED = 1;</code>
     */
    CONVERSATION_STARTED(1),
    /**
     *
     *
     * <pre>
     * An existing conversation has closed. This is fired when a telephone call
     * is terminated, or a conversation is closed via the API.
     * </pre>
     *
     * <code>CONVERSATION_FINISHED = 2;</code>
     */
    CONVERSATION_FINISHED(2),
    /**
     *
     *
     * <pre>
     * An existing conversation has received notification from Dialogflow that
     * human intervention is required.
     * </pre>
     *
     * <code>HUMAN_INTERVENTION_NEEDED = 3;</code>
     */
    HUMAN_INTERVENTION_NEEDED(3),
    /**
     *
     *
     * <pre>
     * An existing conversation has received a new message, either from API or
     * telephony. It is configured in
     * [ConversationProfile.new_message_event_notification_config][google.cloud.dialogflow.v2.ConversationProfile.new_message_event_notification_config]
     * </pre>
     *
     * <code>NEW_MESSAGE = 5;</code>
     */
    NEW_MESSAGE(5),
    /**
     *
     *
     * <pre>
     * Unrecoverable error during a telephone call.
     * In general non-recoverable errors only occur if something was
     * misconfigured in the ConversationProfile corresponding to the call. After
     * a non-recoverable error, Dialogflow may stop responding.
     * We don't fire this event:
     * * in an API call because we can directly return the error, or,
     * * when we can recover from an error.
     * </pre>
     *
     * <code>UNRECOVERABLE_ERROR = 4;</code>
     */
    UNRECOVERABLE_ERROR(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Type not set.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A new conversation has been opened. This is fired when a telephone call
     * is answered, or a conversation is created via the API.
     * </pre>
     *
     * <code>CONVERSATION_STARTED = 1;</code>
     */
    public static final int CONVERSATION_STARTED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * An existing conversation has closed. This is fired when a telephone call
     * is terminated, or a conversation is closed via the API.
     * </pre>
     *
     * <code>CONVERSATION_FINISHED = 2;</code>
     */
    public static final int CONVERSATION_FINISHED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * An existing conversation has received notification from Dialogflow that
     * human intervention is required.
     * </pre>
     *
     * <code>HUMAN_INTERVENTION_NEEDED = 3;</code>
     */
    public static final int HUMAN_INTERVENTION_NEEDED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * An existing conversation has received a new message, either from API or
     * telephony. It is configured in
     * [ConversationProfile.new_message_event_notification_config][google.cloud.dialogflow.v2.ConversationProfile.new_message_event_notification_config]
     * </pre>
     *
     * <code>NEW_MESSAGE = 5;</code>
     */
    public static final int NEW_MESSAGE_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Unrecoverable error during a telephone call.
     * In general non-recoverable errors only occur if something was
     * misconfigured in the ConversationProfile corresponding to the call. After
     * a non-recoverable error, Dialogflow may stop responding.
     * We don't fire this event:
     * * in an API call because we can directly return the error, or,
     * * when we can recover from an error.
     * </pre>
     *
     * <code>UNRECOVERABLE_ERROR = 4;</code>
     */
    public static final int UNRECOVERABLE_ERROR_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return CONVERSATION_STARTED;
        case 2:
          return CONVERSATION_FINISHED;
        case 3:
          return HUMAN_INTERVENTION_NEEDED;
        case 5:
          return NEW_MESSAGE;
        case 4:
          return UNRECOVERABLE_ERROR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationEvent.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.ConversationEvent.Type)
  }

  private int payloadCase_ = 0;
  private java.lang.Object payload_;

  public enum PayloadCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NEW_MESSAGE_PAYLOAD(4),
    PAYLOAD_NOT_SET(0);
    private final int value;

    private PayloadCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PayloadCase valueOf(int value) {
      return forNumber(value);
    }

    public static PayloadCase forNumber(int value) {
      switch (value) {
        case 4:
          return NEW_MESSAGE_PAYLOAD;
        case 0:
          return PAYLOAD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PayloadCase getPayloadCase() {
    return PayloadCase.forNumber(payloadCase_);
  }

  public static final int CONVERSATION_FIELD_NUMBER = 1;
  private volatile java.lang.Object conversation_;
  /**
   *
   *
   * <pre>
   * The unique identifier of the conversation this notification
   * refers to.
   * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
   * </pre>
   *
   * <code>string conversation = 1;</code>
   *
   * @return The conversation.
   */
  @java.lang.Override
  public java.lang.String getConversation() {
    java.lang.Object ref = conversation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      conversation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the conversation this notification
   * refers to.
   * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
   * </pre>
   *
   * <code>string conversation = 1;</code>
   *
   * @return The bytes for conversation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConversationBytes() {
    java.lang.Object ref = conversation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      conversation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_;
  /**
   *
   *
   * <pre>
   * The type of the event that this notification refers to.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.ConversationEvent.Type type = 2;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * The type of the event that this notification refers to.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.ConversationEvent.Type type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ConversationEvent.Type getType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2.ConversationEvent.Type result =
        com.google.cloud.dialogflow.v2.ConversationEvent.Type.valueOf(type_);
    return result == null
        ? com.google.cloud.dialogflow.v2.ConversationEvent.Type.UNRECOGNIZED
        : result;
  }

  public static final int ERROR_STATUS_FIELD_NUMBER = 3;
  private com.google.rpc.Status errorStatus_;
  /**
   *
   *
   * <pre>
   * More detailed information about an error. Only set for type
   * UNRECOVERABLE_ERROR_IN_PHONE_CALL.
   * </pre>
   *
   * <code>.google.rpc.Status error_status = 3;</code>
   *
   * @return Whether the errorStatus field is set.
   */
  @java.lang.Override
  public boolean hasErrorStatus() {
    return errorStatus_ != null;
  }
  /**
   *
   *
   * <pre>
   * More detailed information about an error. Only set for type
   * UNRECOVERABLE_ERROR_IN_PHONE_CALL.
   * </pre>
   *
   * <code>.google.rpc.Status error_status = 3;</code>
   *
   * @return The errorStatus.
   */
  @java.lang.Override
  public com.google.rpc.Status getErrorStatus() {
    return errorStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : errorStatus_;
  }
  /**
   *
   *
   * <pre>
   * More detailed information about an error. Only set for type
   * UNRECOVERABLE_ERROR_IN_PHONE_CALL.
   * </pre>
   *
   * <code>.google.rpc.Status error_status = 3;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorStatusOrBuilder() {
    return getErrorStatus();
  }

  public static final int NEW_MESSAGE_PAYLOAD_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Payload of NEW_MESSAGE event.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.Message new_message_payload = 4;</code>
   *
   * @return Whether the newMessagePayload field is set.
   */
  @java.lang.Override
  public boolean hasNewMessagePayload() {
    return payloadCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Payload of NEW_MESSAGE event.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.Message new_message_payload = 4;</code>
   *
   * @return The newMessagePayload.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.Message getNewMessagePayload() {
    if (payloadCase_ == 4) {
      return (com.google.cloud.dialogflow.v2.Message) payload_;
    }
    return com.google.cloud.dialogflow.v2.Message.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Payload of NEW_MESSAGE event.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.Message new_message_payload = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.MessageOrBuilder getNewMessagePayloadOrBuilder() {
    if (payloadCase_ == 4) {
      return (com.google.cloud.dialogflow.v2.Message) payload_;
    }
    return com.google.cloud.dialogflow.v2.Message.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, conversation_);
    }
    if (type_
        != com.google.cloud.dialogflow.v2.ConversationEvent.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, type_);
    }
    if (errorStatus_ != null) {
      output.writeMessage(3, getErrorStatus());
    }
    if (payloadCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.dialogflow.v2.Message) payload_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, conversation_);
    }
    if (type_
        != com.google.cloud.dialogflow.v2.ConversationEvent.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    if (errorStatus_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getErrorStatus());
    }
    if (payloadCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.dialogflow.v2.Message) payload_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.ConversationEvent)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.ConversationEvent other =
        (com.google.cloud.dialogflow.v2.ConversationEvent) obj;

    if (!getConversation().equals(other.getConversation())) return false;
    if (type_ != other.type_) return false;
    if (hasErrorStatus() != other.hasErrorStatus()) return false;
    if (hasErrorStatus()) {
      if (!getErrorStatus().equals(other.getErrorStatus())) return false;
    }
    if (!getPayloadCase().equals(other.getPayloadCase())) return false;
    switch (payloadCase_) {
      case 4:
        if (!getNewMessagePayload().equals(other.getNewMessagePayload())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONVERSATION_FIELD_NUMBER;
    hash = (53 * hash) + getConversation().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (hasErrorStatus()) {
      hash = (37 * hash) + ERROR_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorStatus().hashCode();
    }
    switch (payloadCase_) {
      case 4:
        hash = (37 * hash) + NEW_MESSAGE_PAYLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getNewMessagePayload().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.ConversationEvent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ConversationEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ConversationEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ConversationEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationEvent parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ConversationEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ConversationEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ConversationEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.ConversationEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a notification sent to Pub/Sub subscribers for conversation
   * lifecycle events.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.ConversationEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.ConversationEvent)
      com.google.cloud.dialogflow.v2.ConversationEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationEventProto
          .internal_static_google_cloud_dialogflow_v2_ConversationEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationEventProto
          .internal_static_google_cloud_dialogflow_v2_ConversationEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.ConversationEvent.class,
              com.google.cloud.dialogflow.v2.ConversationEvent.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.ConversationEvent.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      conversation_ = "";

      type_ = 0;

      if (errorStatusBuilder_ == null) {
        errorStatus_ = null;
      } else {
        errorStatus_ = null;
        errorStatusBuilder_ = null;
      }
      payloadCase_ = 0;
      payload_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ConversationEventProto
          .internal_static_google_cloud_dialogflow_v2_ConversationEvent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationEvent getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.ConversationEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationEvent build() {
      com.google.cloud.dialogflow.v2.ConversationEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationEvent buildPartial() {
      com.google.cloud.dialogflow.v2.ConversationEvent result =
          new com.google.cloud.dialogflow.v2.ConversationEvent(this);
      result.conversation_ = conversation_;
      result.type_ = type_;
      if (errorStatusBuilder_ == null) {
        result.errorStatus_ = errorStatus_;
      } else {
        result.errorStatus_ = errorStatusBuilder_.build();
      }
      if (payloadCase_ == 4) {
        if (newMessagePayloadBuilder_ == null) {
          result.payload_ = payload_;
        } else {
          result.payload_ = newMessagePayloadBuilder_.build();
        }
      }
      result.payloadCase_ = payloadCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.ConversationEvent) {
        return mergeFrom((com.google.cloud.dialogflow.v2.ConversationEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.ConversationEvent other) {
      if (other == com.google.cloud.dialogflow.v2.ConversationEvent.getDefaultInstance())
        return this;
      if (!other.getConversation().isEmpty()) {
        conversation_ = other.conversation_;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.hasErrorStatus()) {
        mergeErrorStatus(other.getErrorStatus());
      }
      switch (other.getPayloadCase()) {
        case NEW_MESSAGE_PAYLOAD:
          {
            mergeNewMessagePayload(other.getNewMessagePayload());
            break;
          }
        case PAYLOAD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2.ConversationEvent parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.dialogflow.v2.ConversationEvent) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int payloadCase_ = 0;
    private java.lang.Object payload_;

    public PayloadCase getPayloadCase() {
      return PayloadCase.forNumber(payloadCase_);
    }

    public Builder clearPayload() {
      payloadCase_ = 0;
      payload_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object conversation_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the conversation this notification
     * refers to.
     * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>string conversation = 1;</code>
     *
     * @return The conversation.
     */
    public java.lang.String getConversation() {
      java.lang.Object ref = conversation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the conversation this notification
     * refers to.
     * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>string conversation = 1;</code>
     *
     * @return The bytes for conversation.
     */
    public com.google.protobuf.ByteString getConversationBytes() {
      java.lang.Object ref = conversation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the conversation this notification
     * refers to.
     * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>string conversation = 1;</code>
     *
     * @param value The conversation to set.
     * @return This builder for chaining.
     */
    public Builder setConversation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      conversation_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the conversation this notification
     * refers to.
     * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>string conversation = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversation() {

      conversation_ = getDefaultInstance().getConversation();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the conversation this notification
     * refers to.
     * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>string conversation = 1;</code>
     *
     * @param value The bytes for conversation to set.
     * @return This builder for chaining.
     */
    public Builder setConversationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      conversation_ = value;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the event that this notification refers to.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.ConversationEvent.Type type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of the event that this notification refers to.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.ConversationEvent.Type type = 2;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {

      type_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the event that this notification refers to.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.ConversationEvent.Type type = 2;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationEvent.Type getType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2.ConversationEvent.Type result =
          com.google.cloud.dialogflow.v2.ConversationEvent.Type.valueOf(type_);
      return result == null
          ? com.google.cloud.dialogflow.v2.ConversationEvent.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the event that this notification refers to.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.ConversationEvent.Type type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.dialogflow.v2.ConversationEvent.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }

      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the event that this notification refers to.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.ConversationEvent.Type type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {

      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.rpc.Status errorStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorStatusBuilder_;
    /**
     *
     *
     * <pre>
     * More detailed information about an error. Only set for type
     * UNRECOVERABLE_ERROR_IN_PHONE_CALL.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     *
     * @return Whether the errorStatus field is set.
     */
    public boolean hasErrorStatus() {
      return errorStatusBuilder_ != null || errorStatus_ != null;
    }
    /**
     *
     *
     * <pre>
     * More detailed information about an error. Only set for type
     * UNRECOVERABLE_ERROR_IN_PHONE_CALL.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     *
     * @return The errorStatus.
     */
    public com.google.rpc.Status getErrorStatus() {
      if (errorStatusBuilder_ == null) {
        return errorStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : errorStatus_;
      } else {
        return errorStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * More detailed information about an error. Only set for type
     * UNRECOVERABLE_ERROR_IN_PHONE_CALL.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     */
    public Builder setErrorStatus(com.google.rpc.Status value) {
      if (errorStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorStatus_ = value;
        onChanged();
      } else {
        errorStatusBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * More detailed information about an error. Only set for type
     * UNRECOVERABLE_ERROR_IN_PHONE_CALL.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     */
    public Builder setErrorStatus(com.google.rpc.Status.Builder builderForValue) {
      if (errorStatusBuilder_ == null) {
        errorStatus_ = builderForValue.build();
        onChanged();
      } else {
        errorStatusBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * More detailed information about an error. Only set for type
     * UNRECOVERABLE_ERROR_IN_PHONE_CALL.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     */
    public Builder mergeErrorStatus(com.google.rpc.Status value) {
      if (errorStatusBuilder_ == null) {
        if (errorStatus_ != null) {
          errorStatus_ =
              com.google.rpc.Status.newBuilder(errorStatus_).mergeFrom(value).buildPartial();
        } else {
          errorStatus_ = value;
        }
        onChanged();
      } else {
        errorStatusBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * More detailed information about an error. Only set for type
     * UNRECOVERABLE_ERROR_IN_PHONE_CALL.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     */
    public Builder clearErrorStatus() {
      if (errorStatusBuilder_ == null) {
        errorStatus_ = null;
        onChanged();
      } else {
        errorStatus_ = null;
        errorStatusBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * More detailed information about an error. Only set for type
     * UNRECOVERABLE_ERROR_IN_PHONE_CALL.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     */
    public com.google.rpc.Status.Builder getErrorStatusBuilder() {

      onChanged();
      return getErrorStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * More detailed information about an error. Only set for type
     * UNRECOVERABLE_ERROR_IN_PHONE_CALL.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorStatusOrBuilder() {
      if (errorStatusBuilder_ != null) {
        return errorStatusBuilder_.getMessageOrBuilder();
      } else {
        return errorStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : errorStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * More detailed information about an error. Only set for type
     * UNRECOVERABLE_ERROR_IN_PHONE_CALL.
     * </pre>
     *
     * <code>.google.rpc.Status error_status = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorStatusFieldBuilder() {
      if (errorStatusBuilder_ == null) {
        errorStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                getErrorStatus(), getParentForChildren(), isClean());
        errorStatus_ = null;
      }
      return errorStatusBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.Message,
            com.google.cloud.dialogflow.v2.Message.Builder,
            com.google.cloud.dialogflow.v2.MessageOrBuilder>
        newMessagePayloadBuilder_;
    /**
     *
     *
     * <pre>
     * Payload of NEW_MESSAGE event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Message new_message_payload = 4;</code>
     *
     * @return Whether the newMessagePayload field is set.
     */
    @java.lang.Override
    public boolean hasNewMessagePayload() {
      return payloadCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Payload of NEW_MESSAGE event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Message new_message_payload = 4;</code>
     *
     * @return The newMessagePayload.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Message getNewMessagePayload() {
      if (newMessagePayloadBuilder_ == null) {
        if (payloadCase_ == 4) {
          return (com.google.cloud.dialogflow.v2.Message) payload_;
        }
        return com.google.cloud.dialogflow.v2.Message.getDefaultInstance();
      } else {
        if (payloadCase_ == 4) {
          return newMessagePayloadBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2.Message.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Payload of NEW_MESSAGE event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Message new_message_payload = 4;</code>
     */
    public Builder setNewMessagePayload(com.google.cloud.dialogflow.v2.Message value) {
      if (newMessagePayloadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        newMessagePayloadBuilder_.setMessage(value);
      }
      payloadCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Payload of NEW_MESSAGE event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Message new_message_payload = 4;</code>
     */
    public Builder setNewMessagePayload(
        com.google.cloud.dialogflow.v2.Message.Builder builderForValue) {
      if (newMessagePayloadBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        newMessagePayloadBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Payload of NEW_MESSAGE event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Message new_message_payload = 4;</code>
     */
    public Builder mergeNewMessagePayload(com.google.cloud.dialogflow.v2.Message value) {
      if (newMessagePayloadBuilder_ == null) {
        if (payloadCase_ == 4
            && payload_ != com.google.cloud.dialogflow.v2.Message.getDefaultInstance()) {
          payload_ =
              com.google.cloud.dialogflow.v2.Message.newBuilder(
                      (com.google.cloud.dialogflow.v2.Message) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 4) {
          newMessagePayloadBuilder_.mergeFrom(value);
        } else {
          newMessagePayloadBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Payload of NEW_MESSAGE event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Message new_message_payload = 4;</code>
     */
    public Builder clearNewMessagePayload() {
      if (newMessagePayloadBuilder_ == null) {
        if (payloadCase_ == 4) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 4) {
          payloadCase_ = 0;
          payload_ = null;
        }
        newMessagePayloadBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Payload of NEW_MESSAGE event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Message new_message_payload = 4;</code>
     */
    public com.google.cloud.dialogflow.v2.Message.Builder getNewMessagePayloadBuilder() {
      return getNewMessagePayloadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Payload of NEW_MESSAGE event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Message new_message_payload = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.MessageOrBuilder getNewMessagePayloadOrBuilder() {
      if ((payloadCase_ == 4) && (newMessagePayloadBuilder_ != null)) {
        return newMessagePayloadBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 4) {
          return (com.google.cloud.dialogflow.v2.Message) payload_;
        }
        return com.google.cloud.dialogflow.v2.Message.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Payload of NEW_MESSAGE event.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Message new_message_payload = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.Message,
            com.google.cloud.dialogflow.v2.Message.Builder,
            com.google.cloud.dialogflow.v2.MessageOrBuilder>
        getNewMessagePayloadFieldBuilder() {
      if (newMessagePayloadBuilder_ == null) {
        if (!(payloadCase_ == 4)) {
          payload_ = com.google.cloud.dialogflow.v2.Message.getDefaultInstance();
        }
        newMessagePayloadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Message,
                com.google.cloud.dialogflow.v2.Message.Builder,
                com.google.cloud.dialogflow.v2.MessageOrBuilder>(
                (com.google.cloud.dialogflow.v2.Message) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 4;
      onChanged();
      ;
      return newMessagePayloadBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.ConversationEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.ConversationEvent)
  private static final com.google.cloud.dialogflow.v2.ConversationEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.ConversationEvent();
  }

  public static com.google.cloud.dialogflow.v2.ConversationEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConversationEvent> PARSER =
      new com.google.protobuf.AbstractParser<ConversationEvent>() {
        @java.lang.Override
        public ConversationEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ConversationEvent(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ConversationEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConversationEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ConversationEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
