/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/document.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * The template used for importing documents.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.ImportDocumentTemplate}
 */
public final class ImportDocumentTemplate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.ImportDocumentTemplate)
    ImportDocumentTemplateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportDocumentTemplate.newBuilder() to construct.
  private ImportDocumentTemplate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportDocumentTemplate() {
    mimeType_ = "";
    knowledgeTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportDocumentTemplate();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ImportDocumentTemplate(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              mimeType_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                knowledgeTypes_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000001;
              }
              knowledgeTypes_.add(rawValue);
              break;
            }
          case 18:
            {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while (input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  knowledgeTypes_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000001;
                }
                knowledgeTypes_.add(rawValue);
              }
              input.popLimit(oldLimit);
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                metadata_ =
                    com.google.protobuf.MapField.newMapField(
                        MetadataDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000002;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
                  input.readMessage(
                      MetadataDefaultEntryHolder.defaultEntry.getParserForType(),
                      extensionRegistry);
              metadata_.getMutableMap().put(metadata__.getKey(), metadata__.getValue());
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        knowledgeTypes_ = java.util.Collections.unmodifiableList(knowledgeTypes_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.DocumentProto
        .internal_static_google_cloud_dialogflow_v2_ImportDocumentTemplate_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetMetadata();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.DocumentProto
        .internal_static_google_cloud_dialogflow_v2_ImportDocumentTemplate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.ImportDocumentTemplate.class,
            com.google.cloud.dialogflow.v2.ImportDocumentTemplate.Builder.class);
  }

  public static final int MIME_TYPE_FIELD_NUMBER = 1;
  private volatile java.lang.Object mimeType_;
  /**
   *
   *
   * <pre>
   * Required. The MIME type of the document.
   * </pre>
   *
   * <code>string mime_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The mimeType.
   */
  @java.lang.Override
  public java.lang.String getMimeType() {
    java.lang.Object ref = mimeType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mimeType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The MIME type of the document.
   * </pre>
   *
   * <code>string mime_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for mimeType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMimeTypeBytes() {
    java.lang.Object ref = mimeType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      mimeType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KNOWLEDGE_TYPES_FIELD_NUMBER = 2;
  private java.util.List<java.lang.Integer> knowledgeTypes_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.dialogflow.v2.Document.KnowledgeType>
      knowledgeTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.dialogflow.v2.Document.KnowledgeType>() {
            public com.google.cloud.dialogflow.v2.Document.KnowledgeType convert(
                java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.cloud.dialogflow.v2.Document.KnowledgeType result =
                  com.google.cloud.dialogflow.v2.Document.KnowledgeType.valueOf(from);
              return result == null
                  ? com.google.cloud.dialogflow.v2.Document.KnowledgeType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Required. The knowledge type of document content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the knowledgeTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2.Document.KnowledgeType>
      getKnowledgeTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.dialogflow.v2.Document.KnowledgeType>(
        knowledgeTypes_, knowledgeTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * Required. The knowledge type of document content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The count of knowledgeTypes.
   */
  @java.lang.Override
  public int getKnowledgeTypesCount() {
    return knowledgeTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The knowledge type of document content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The knowledgeTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.Document.KnowledgeType getKnowledgeTypes(int index) {
    return knowledgeTypes_converter_.convert(knowledgeTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Required. The knowledge type of document content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for knowledgeTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getKnowledgeTypesValueList() {
    return knowledgeTypes_;
  }
  /**
   *
   *
   * <pre>
   * Required. The knowledge type of document content.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of knowledgeTypes at the given index.
   */
  @java.lang.Override
  public int getKnowledgeTypesValue(int index) {
    return knowledgeTypes_.get(index);
  }

  private int knowledgeTypesMemoizedSerializedSize;

  public static final int METADATA_FIELD_NUMBER = 3;

  private static final class MetadataDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dialogflow.v2.DocumentProto
                .internal_static_google_cloud_dialogflow_v2_ImportDocumentTemplate_MetadataEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
    if (metadata_ == null) {
      return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
    }
    return metadata_;
  }

  public int getMetadataCount() {
    return internalGetMetadata().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Metadata for the document. The metadata supports arbitrary
   * key-value pairs. Suggested use cases include storing a document's title,
   * an external URL distinct from the document's content_uri, etc.
   * The max size of a `key` or a `value` of the metadata is 1024 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 3;</code>
   */
  @java.lang.Override
  public boolean containsMetadata(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMetadata().getMap().containsKey(key);
  }
  /** Use {@link #getMetadataMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
    return getMetadataMap();
  }
  /**
   *
   *
   * <pre>
   * Metadata for the document. The metadata supports arbitrary
   * key-value pairs. Suggested use cases include storing a document's title,
   * an external URL distinct from the document's content_uri, etc.
   * The max size of a `key` or a `value` of the metadata is 1024 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
    return internalGetMetadata().getMap();
  }
  /**
   *
   *
   * <pre>
   * Metadata for the document. The metadata supports arbitrary
   * key-value pairs. Suggested use cases include storing a document's title,
   * an external URL distinct from the document's content_uri, etc.
   * The max size of a `key` or a `value` of the metadata is 1024 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getMetadataOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Metadata for the document. The metadata supports arbitrary
   * key-value pairs. Suggested use cases include storing a document's title,
   * an external URL distinct from the document's content_uri, etc.
   * The max size of a `key` or a `value` of the metadata is 1024 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 3;</code>
   */
  @java.lang.Override
  public java.lang.String getMetadataOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mimeType_);
    }
    if (getKnowledgeTypesList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(knowledgeTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < knowledgeTypes_.size(); i++) {
      output.writeEnumNoTag(knowledgeTypes_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, 3);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mimeType_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < knowledgeTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(knowledgeTypes_.get(i));
      }
      size += dataSize;
      if (!getKnowledgeTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      knowledgeTypesMemoizedSerializedSize = dataSize;
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetMetadata().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
          MetadataDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, metadata__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.ImportDocumentTemplate)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.ImportDocumentTemplate other =
        (com.google.cloud.dialogflow.v2.ImportDocumentTemplate) obj;

    if (!getMimeType().equals(other.getMimeType())) return false;
    if (!knowledgeTypes_.equals(other.knowledgeTypes_)) return false;
    if (!internalGetMetadata().equals(other.internalGetMetadata())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MIME_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getMimeType().hashCode();
    if (getKnowledgeTypesCount() > 0) {
      hash = (37 * hash) + KNOWLEDGE_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + knowledgeTypes_.hashCode();
    }
    if (!internalGetMetadata().getMap().isEmpty()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMetadata().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentTemplate parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentTemplate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentTemplate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentTemplate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentTemplate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentTemplate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentTemplate parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentTemplate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentTemplate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentTemplate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentTemplate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentTemplate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2.ImportDocumentTemplate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The template used for importing documents.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.ImportDocumentTemplate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.ImportDocumentTemplate)
      com.google.cloud.dialogflow.v2.ImportDocumentTemplateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.DocumentProto
          .internal_static_google_cloud_dialogflow_v2_ImportDocumentTemplate_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.DocumentProto
          .internal_static_google_cloud_dialogflow_v2_ImportDocumentTemplate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.ImportDocumentTemplate.class,
              com.google.cloud.dialogflow.v2.ImportDocumentTemplate.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.ImportDocumentTemplate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      mimeType_ = "";

      knowledgeTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableMetadata().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.DocumentProto
          .internal_static_google_cloud_dialogflow_v2_ImportDocumentTemplate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ImportDocumentTemplate getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.ImportDocumentTemplate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ImportDocumentTemplate build() {
      com.google.cloud.dialogflow.v2.ImportDocumentTemplate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ImportDocumentTemplate buildPartial() {
      com.google.cloud.dialogflow.v2.ImportDocumentTemplate result =
          new com.google.cloud.dialogflow.v2.ImportDocumentTemplate(this);
      int from_bitField0_ = bitField0_;
      result.mimeType_ = mimeType_;
      if (((bitField0_ & 0x00000001) != 0)) {
        knowledgeTypes_ = java.util.Collections.unmodifiableList(knowledgeTypes_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.knowledgeTypes_ = knowledgeTypes_;
      result.metadata_ = internalGetMetadata();
      result.metadata_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.ImportDocumentTemplate) {
        return mergeFrom((com.google.cloud.dialogflow.v2.ImportDocumentTemplate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.ImportDocumentTemplate other) {
      if (other == com.google.cloud.dialogflow.v2.ImportDocumentTemplate.getDefaultInstance())
        return this;
      if (!other.getMimeType().isEmpty()) {
        mimeType_ = other.mimeType_;
        onChanged();
      }
      if (!other.knowledgeTypes_.isEmpty()) {
        if (knowledgeTypes_.isEmpty()) {
          knowledgeTypes_ = other.knowledgeTypes_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureKnowledgeTypesIsMutable();
          knowledgeTypes_.addAll(other.knowledgeTypes_);
        }
        onChanged();
      }
      internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2.ImportDocumentTemplate parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.dialogflow.v2.ImportDocumentTemplate) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object mimeType_ = "";
    /**
     *
     *
     * <pre>
     * Required. The MIME type of the document.
     * </pre>
     *
     * <code>string mime_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The mimeType.
     */
    public java.lang.String getMimeType() {
      java.lang.Object ref = mimeType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mimeType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The MIME type of the document.
     * </pre>
     *
     * <code>string mime_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for mimeType.
     */
    public com.google.protobuf.ByteString getMimeTypeBytes() {
      java.lang.Object ref = mimeType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mimeType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The MIME type of the document.
     * </pre>
     *
     * <code>string mime_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The mimeType to set.
     * @return This builder for chaining.
     */
    public Builder setMimeType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      mimeType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The MIME type of the document.
     * </pre>
     *
     * <code>string mime_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMimeType() {

      mimeType_ = getDefaultInstance().getMimeType();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The MIME type of the document.
     * </pre>
     *
     * <code>string mime_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for mimeType to set.
     * @return This builder for chaining.
     */
    public Builder setMimeTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      mimeType_ = value;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> knowledgeTypes_ = java.util.Collections.emptyList();

    private void ensureKnowledgeTypesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        knowledgeTypes_ = new java.util.ArrayList<java.lang.Integer>(knowledgeTypes_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge type of document content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return A list containing the knowledgeTypes.
     */
    public java.util.List<com.google.cloud.dialogflow.v2.Document.KnowledgeType>
        getKnowledgeTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.dialogflow.v2.Document.KnowledgeType>(
          knowledgeTypes_, knowledgeTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge type of document content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The count of knowledgeTypes.
     */
    public int getKnowledgeTypesCount() {
      return knowledgeTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge type of document content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The knowledgeTypes at the given index.
     */
    public com.google.cloud.dialogflow.v2.Document.KnowledgeType getKnowledgeTypes(int index) {
      return knowledgeTypes_converter_.convert(knowledgeTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge type of document content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The knowledgeTypes to set.
     * @return This builder for chaining.
     */
    public Builder setKnowledgeTypes(
        int index, com.google.cloud.dialogflow.v2.Document.KnowledgeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureKnowledgeTypesIsMutable();
      knowledgeTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge type of document content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The knowledgeTypes to add.
     * @return This builder for chaining.
     */
    public Builder addKnowledgeTypes(com.google.cloud.dialogflow.v2.Document.KnowledgeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureKnowledgeTypesIsMutable();
      knowledgeTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge type of document content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param values The knowledgeTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllKnowledgeTypes(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.Document.KnowledgeType>
            values) {
      ensureKnowledgeTypesIsMutable();
      for (com.google.cloud.dialogflow.v2.Document.KnowledgeType value : values) {
        knowledgeTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge type of document content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKnowledgeTypes() {
      knowledgeTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge type of document content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for knowledgeTypes.
     */
    public java.util.List<java.lang.Integer> getKnowledgeTypesValueList() {
      return java.util.Collections.unmodifiableList(knowledgeTypes_);
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge type of document content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of knowledgeTypes at the given index.
     */
    public int getKnowledgeTypesValue(int index) {
      return knowledgeTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge type of document content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of knowledgeTypes at the given index.
     * @return This builder for chaining.
     */
    public Builder setKnowledgeTypesValue(int index, int value) {
      ensureKnowledgeTypesIsMutable();
      knowledgeTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge type of document content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for knowledgeTypes to add.
     * @return This builder for chaining.
     */
    public Builder addKnowledgeTypesValue(int value) {
      ensureKnowledgeTypesIsMutable();
      knowledgeTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge type of document content.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.Document.KnowledgeType knowledge_types = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param values The enum numeric values on the wire for knowledgeTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllKnowledgeTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureKnowledgeTypesIsMutable();
      for (int value : values) {
        knowledgeTypes_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
      if (metadata_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      return metadata_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableMetadata() {
      onChanged();
      ;
      if (metadata_ == null) {
        metadata_ =
            com.google.protobuf.MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      if (!metadata_.isMutable()) {
        metadata_ = metadata_.copy();
      }
      return metadata_;
    }

    public int getMetadataCount() {
      return internalGetMetadata().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Metadata for the document. The metadata supports arbitrary
     * key-value pairs. Suggested use cases include storing a document's title,
     * an external URL distinct from the document's content_uri, etc.
     * The max size of a `key` or a `value` of the metadata is 1024 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    @java.lang.Override
    public boolean containsMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetadata().getMap().containsKey(key);
    }
    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
      return getMetadataMap();
    }
    /**
     *
     *
     * <pre>
     * Metadata for the document. The metadata supports arbitrary
     * key-value pairs. Suggested use cases include storing a document's title,
     * an external URL distinct from the document's content_uri, etc.
     * The max size of a `key` or a `value` of the metadata is 1024 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
      return internalGetMetadata().getMap();
    }
    /**
     *
     *
     * <pre>
     * Metadata for the document. The metadata supports arbitrary
     * key-value pairs. Suggested use cases include storing a document's title,
     * an external URL distinct from the document's content_uri, etc.
     * The max size of a `key` or a `value` of the metadata is 1024 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getMetadataOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the document. The metadata supports arbitrary
     * key-value pairs. Suggested use cases include storing a document's title,
     * an external URL distinct from the document's content_uri, etc.
     * The max size of a `key` or a `value` of the metadata is 1024 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    @java.lang.Override
    public java.lang.String getMetadataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMetadata() {
      internalGetMutableMetadata().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the document. The metadata supports arbitrary
     * key-value pairs. Suggested use cases include storing a document's title,
     * an external URL distinct from the document's content_uri, etc.
     * The max size of a `key` or a `value` of the metadata is 1024 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    public Builder removeMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMetadata().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableMetadata() {
      return internalGetMutableMetadata().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Metadata for the document. The metadata supports arbitrary
     * key-value pairs. Suggested use cases include storing a document's title,
     * an external URL distinct from the document's content_uri, etc.
     * The max size of a `key` or a `value` of the metadata is 1024 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    public Builder putMetadata(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableMetadata().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the document. The metadata supports arbitrary
     * key-value pairs. Suggested use cases include storing a document's title,
     * an external URL distinct from the document's content_uri, etc.
     * The max size of a `key` or a `value` of the metadata is 1024 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 3;</code>
     */
    public Builder putAllMetadata(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableMetadata().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.ImportDocumentTemplate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.ImportDocumentTemplate)
  private static final com.google.cloud.dialogflow.v2.ImportDocumentTemplate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.ImportDocumentTemplate();
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentTemplate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportDocumentTemplate> PARSER =
      new com.google.protobuf.AbstractParser<ImportDocumentTemplate>() {
        @java.lang.Override
        public ImportDocumentTemplate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ImportDocumentTemplate(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ImportDocumentTemplate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportDocumentTemplate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ImportDocumentTemplate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
