/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/conversation.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * The request message for
 * [Conversations.GenerateStatelessSuggestion][google.cloud.dialogflow.v2.Conversations.GenerateStatelessSuggestion].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest}
 */
public final class GenerateStatelessSuggestionRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest)
    GenerateStatelessSuggestionRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GenerateStatelessSuggestionRequest.newBuilder() to construct.
  private GenerateStatelessSuggestionRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateStatelessSuggestionRequest() {
    parent_ = "";
    triggerEvents_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateStatelessSuggestionRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ConversationProto
        .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSuggestionRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetContextReferences();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ConversationProto
        .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSuggestionRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.class,
            com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.Builder.class);
  }

  private int bitField0_;
  private int generatorResourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object generatorResource_;

  public enum GeneratorResourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GENERATOR(2),
    GENERATOR_NAME(3),
    GENERATORRESOURCE_NOT_SET(0);
    private final int value;

    private GeneratorResourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static GeneratorResourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static GeneratorResourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return GENERATOR;
        case 3:
          return GENERATOR_NAME;
        case 0:
          return GENERATORRESOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public GeneratorResourceCase getGeneratorResourceCase() {
    return GeneratorResourceCase.forNumber(generatorResourceCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The parent resource to charge for the Suggestion's generation.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The parent resource to charge for the Suggestion's generation.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GENERATOR_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Uncreated generator. It should be a complete generator that includes all
   * information about the generator.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.Generator generator = 2;</code>
   *
   * @return Whether the generator field is set.
   */
  @java.lang.Override
  public boolean hasGenerator() {
    return generatorResourceCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Uncreated generator. It should be a complete generator that includes all
   * information about the generator.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.Generator generator = 2;</code>
   *
   * @return The generator.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.Generator getGenerator() {
    if (generatorResourceCase_ == 2) {
      return (com.google.cloud.dialogflow.v2.Generator) generatorResource_;
    }
    return com.google.cloud.dialogflow.v2.Generator.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Uncreated generator. It should be a complete generator that includes all
   * information about the generator.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.Generator generator = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.GeneratorOrBuilder getGeneratorOrBuilder() {
    if (generatorResourceCase_ == 2) {
      return (com.google.cloud.dialogflow.v2.Generator) generatorResource_;
    }
    return com.google.cloud.dialogflow.v2.Generator.getDefaultInstance();
  }

  public static final int GENERATOR_NAME_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * The resource name of the existing created generator. Format:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
   * </pre>
   *
   * <code>string generator_name = 3;</code>
   *
   * @return Whether the generatorName field is set.
   */
  public boolean hasGeneratorName() {
    return generatorResourceCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * The resource name of the existing created generator. Format:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
   * </pre>
   *
   * <code>string generator_name = 3;</code>
   *
   * @return The generatorName.
   */
  public java.lang.String getGeneratorName() {
    java.lang.Object ref = "";
    if (generatorResourceCase_ == 3) {
      ref = generatorResource_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (generatorResourceCase_ == 3) {
        generatorResource_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The resource name of the existing created generator. Format:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
   * </pre>
   *
   * <code>string generator_name = 3;</code>
   *
   * @return The bytes for generatorName.
   */
  public com.google.protobuf.ByteString getGeneratorNameBytes() {
    java.lang.Object ref = "";
    if (generatorResourceCase_ == 3) {
      ref = generatorResource_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (generatorResourceCase_ == 3) {
        generatorResource_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTEXT_REFERENCES_FIELD_NUMBER = 4;

  private static final class ContextReferencesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
                    newDefaultInstance(
                        com.google.cloud.dialogflow.v2.ConversationProto
                            .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSuggestionRequest_ContextReferencesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.dialogflow.v2.Conversation.ContextReference
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
      contextReferences_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
      internalGetContextReferences() {
    if (contextReferences_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ContextReferencesDefaultEntryHolder.defaultEntry);
    }
    return contextReferences_;
  }

  public int getContextReferencesCount() {
    return internalGetContextReferences().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. A section of ingested context information. The key is the name of
   * the context reference and the value contains the contents of the context
   * reference. The key is used to incorporate ingested context references to
   * enhance the generator.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.dialogflow.v2.Conversation.ContextReference&gt; context_references = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsContextReferences(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetContextReferences().getMap().containsKey(key);
  }

  /** Use {@link #getContextReferencesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
      getContextReferences() {
    return getContextReferencesMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. A section of ingested context information. The key is the name of
   * the context reference and the value contains the contents of the context
   * reference. The key is used to incorporate ingested context references to
   * enhance the generator.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.dialogflow.v2.Conversation.ContextReference&gt; context_references = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
      getContextReferencesMap() {
    return internalGetContextReferences().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. A section of ingested context information. The key is the name of
   * the context reference and the value contains the contents of the context
   * reference. The key is used to incorporate ingested context references to
   * enhance the generator.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.dialogflow.v2.Conversation.ContextReference&gt; context_references = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.dialogflow.v2.Conversation.ContextReference
      getContextReferencesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.dialogflow.v2.Conversation.ContextReference defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
        map = internalGetContextReferences().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. A section of ingested context information. The key is the name of
   * the context reference and the value contains the contents of the context
   * reference. The key is used to incorporate ingested context references to
   * enhance the generator.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.dialogflow.v2.Conversation.ContextReference&gt; context_references = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.Conversation.ContextReference getContextReferencesOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
        map = internalGetContextReferences().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CONVERSATION_CONTEXT_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.v2.ConversationContext conversationContext_;

  /**
   *
   *
   * <pre>
   * Optional. Context of the conversation, including transcripts.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the conversationContext field is set.
   */
  @java.lang.Override
  public boolean hasConversationContext() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Context of the conversation, including transcripts.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The conversationContext.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ConversationContext getConversationContext() {
    return conversationContext_ == null
        ? com.google.cloud.dialogflow.v2.ConversationContext.getDefaultInstance()
        : conversationContext_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Context of the conversation, including transcripts.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ConversationContextOrBuilder
      getConversationContextOrBuilder() {
    return conversationContext_ == null
        ? com.google.cloud.dialogflow.v2.ConversationContext.getDefaultInstance()
        : conversationContext_;
  }

  public static final int TRIGGER_EVENTS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> triggerEvents_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.dialogflow.v2.TriggerEvent>
      triggerEvents_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.dialogflow.v2.TriggerEvent>() {
            public com.google.cloud.dialogflow.v2.TriggerEvent convert(java.lang.Integer from) {
              com.google.cloud.dialogflow.v2.TriggerEvent result =
                  com.google.cloud.dialogflow.v2.TriggerEvent.forNumber(from);
              return result == null
                  ? com.google.cloud.dialogflow.v2.TriggerEvent.UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * Optional. A list of trigger events. Generator will be triggered only if
   * it's trigger event is included here.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the triggerEvents.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2.TriggerEvent> getTriggerEventsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.dialogflow.v2.TriggerEvent>(
        triggerEvents_, triggerEvents_converter_);
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of trigger events. Generator will be triggered only if
   * it's trigger event is included here.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of triggerEvents.
   */
  @java.lang.Override
  public int getTriggerEventsCount() {
    return triggerEvents_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of trigger events. Generator will be triggered only if
   * it's trigger event is included here.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The triggerEvents at the given index.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.TriggerEvent getTriggerEvents(int index) {
    return triggerEvents_converter_.convert(triggerEvents_.get(index));
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of trigger events. Generator will be triggered only if
   * it's trigger event is included here.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for triggerEvents.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getTriggerEventsValueList() {
    return triggerEvents_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of trigger events. Generator will be triggered only if
   * it's trigger event is included here.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of triggerEvents at the given index.
   */
  @java.lang.Override
  public int getTriggerEventsValue(int index) {
    return triggerEvents_.get(index);
  }

  private int triggerEventsMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (generatorResourceCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.dialogflow.v2.Generator) generatorResource_);
    }
    if (generatorResourceCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, generatorResource_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetContextReferences(),
        ContextReferencesDefaultEntryHolder.defaultEntry,
        4);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getConversationContext());
    }
    if (getTriggerEventsList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(triggerEventsMemoizedSerializedSize);
    }
    for (int i = 0; i < triggerEvents_.size(); i++) {
      output.writeEnumNoTag(triggerEvents_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (generatorResourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dialogflow.v2.Generator) generatorResource_);
    }
    if (generatorResourceCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, generatorResource_);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
        entry : internalGetContextReferences().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
          contextReferences__ =
              ContextReferencesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, contextReferences__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getConversationContext());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < triggerEvents_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(triggerEvents_.get(i));
      }
      size += dataSize;
      if (!getTriggerEventsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      triggerEventsMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest other =
        (com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!internalGetContextReferences().equals(other.internalGetContextReferences())) return false;
    if (hasConversationContext() != other.hasConversationContext()) return false;
    if (hasConversationContext()) {
      if (!getConversationContext().equals(other.getConversationContext())) return false;
    }
    if (!triggerEvents_.equals(other.triggerEvents_)) return false;
    if (!getGeneratorResourceCase().equals(other.getGeneratorResourceCase())) return false;
    switch (generatorResourceCase_) {
      case 2:
        if (!getGenerator().equals(other.getGenerator())) return false;
        break;
      case 3:
        if (!getGeneratorName().equals(other.getGeneratorName())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (!internalGetContextReferences().getMap().isEmpty()) {
      hash = (37 * hash) + CONTEXT_REFERENCES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetContextReferences().hashCode();
    }
    if (hasConversationContext()) {
      hash = (37 * hash) + CONVERSATION_CONTEXT_FIELD_NUMBER;
      hash = (53 * hash) + getConversationContext().hashCode();
    }
    if (getTriggerEventsCount() > 0) {
      hash = (37 * hash) + TRIGGER_EVENTS_FIELD_NUMBER;
      hash = (53 * hash) + triggerEvents_.hashCode();
    }
    switch (generatorResourceCase_) {
      case 2:
        hash = (37 * hash) + GENERATOR_FIELD_NUMBER;
        hash = (53 * hash) + getGenerator().hashCode();
        break;
      case 3:
        hash = (37 * hash) + GENERATOR_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getGeneratorName().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The request message for
   * [Conversations.GenerateStatelessSuggestion][google.cloud.dialogflow.v2.Conversations.GenerateStatelessSuggestion].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest)
      com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationProto
          .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSuggestionRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetContextReferences();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableContextReferences();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationProto
          .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSuggestionRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.class,
              com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConversationContextFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (generatorBuilder_ != null) {
        generatorBuilder_.clear();
      }
      internalGetMutableContextReferences().clear();
      conversationContext_ = null;
      if (conversationContextBuilder_ != null) {
        conversationContextBuilder_.dispose();
        conversationContextBuilder_ = null;
      }
      triggerEvents_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      generatorResourceCase_ = 0;
      generatorResource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ConversationProto
          .internal_static_google_cloud_dialogflow_v2_GenerateStatelessSuggestionRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest build() {
      com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest buildPartial() {
      com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest result =
          new com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest result) {
      if (((bitField0_ & 0x00000020) != 0)) {
        triggerEvents_ = java.util.Collections.unmodifiableList(triggerEvents_);
        bitField0_ = (bitField0_ & ~0x00000020);
      }
      result.triggerEvents_ = triggerEvents_;
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.contextReferences_ =
            internalGetContextReferences().build(ContextReferencesDefaultEntryHolder.defaultEntry);
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.conversationContext_ =
            conversationContextBuilder_ == null
                ? conversationContext_
                : conversationContextBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest result) {
      result.generatorResourceCase_ = generatorResourceCase_;
      result.generatorResource_ = this.generatorResource_;
      if (generatorResourceCase_ == 2 && generatorBuilder_ != null) {
        result.generatorResource_ = generatorBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest) {
        return mergeFrom((com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest other) {
      if (other
          == com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableContextReferences().mergeFrom(other.internalGetContextReferences());
      bitField0_ |= 0x00000008;
      if (other.hasConversationContext()) {
        mergeConversationContext(other.getConversationContext());
      }
      if (!other.triggerEvents_.isEmpty()) {
        if (triggerEvents_.isEmpty()) {
          triggerEvents_ = other.triggerEvents_;
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          ensureTriggerEventsIsMutable();
          triggerEvents_.addAll(other.triggerEvents_);
        }
        onChanged();
      }
      switch (other.getGeneratorResourceCase()) {
        case GENERATOR:
          {
            mergeGenerator(other.getGenerator());
            break;
          }
        case GENERATOR_NAME:
          {
            generatorResourceCase_ = 3;
            generatorResource_ = other.generatorResource_;
            onChanged();
            break;
          }
        case GENERATORRESOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getGeneratorFieldBuilder().getBuilder(), extensionRegistry);
                generatorResourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                generatorResourceCase_ = 3;
                generatorResource_ = s;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.dialogflow.v2.Conversation.ContextReference>
                    contextReferences__ =
                        input.readMessage(
                            ContextReferencesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableContextReferences()
                    .ensureBuilderMap()
                    .put(contextReferences__.getKey(), contextReferences__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getConversationContextFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                int tmpRaw = input.readEnum();
                ensureTriggerEventsIsMutable();
                triggerEvents_.add(tmpRaw);
                break;
              } // case 48
            case 50:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureTriggerEventsIsMutable();
                  triggerEvents_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int generatorResourceCase_ = 0;
    private java.lang.Object generatorResource_;

    public GeneratorResourceCase getGeneratorResourceCase() {
      return GeneratorResourceCase.forNumber(generatorResourceCase_);
    }

    public Builder clearGeneratorResource() {
      generatorResourceCase_ = 0;
      generatorResource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The parent resource to charge for the Suggestion's generation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The parent resource to charge for the Suggestion's generation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The parent resource to charge for the Suggestion's generation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The parent resource to charge for the Suggestion's generation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The parent resource to charge for the Suggestion's generation.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.Generator,
            com.google.cloud.dialogflow.v2.Generator.Builder,
            com.google.cloud.dialogflow.v2.GeneratorOrBuilder>
        generatorBuilder_;

    /**
     *
     *
     * <pre>
     * Uncreated generator. It should be a complete generator that includes all
     * information about the generator.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Generator generator = 2;</code>
     *
     * @return Whether the generator field is set.
     */
    @java.lang.Override
    public boolean hasGenerator() {
      return generatorResourceCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Uncreated generator. It should be a complete generator that includes all
     * information about the generator.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Generator generator = 2;</code>
     *
     * @return The generator.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Generator getGenerator() {
      if (generatorBuilder_ == null) {
        if (generatorResourceCase_ == 2) {
          return (com.google.cloud.dialogflow.v2.Generator) generatorResource_;
        }
        return com.google.cloud.dialogflow.v2.Generator.getDefaultInstance();
      } else {
        if (generatorResourceCase_ == 2) {
          return generatorBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2.Generator.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Uncreated generator. It should be a complete generator that includes all
     * information about the generator.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Generator generator = 2;</code>
     */
    public Builder setGenerator(com.google.cloud.dialogflow.v2.Generator value) {
      if (generatorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        generatorResource_ = value;
        onChanged();
      } else {
        generatorBuilder_.setMessage(value);
      }
      generatorResourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Uncreated generator. It should be a complete generator that includes all
     * information about the generator.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Generator generator = 2;</code>
     */
    public Builder setGenerator(com.google.cloud.dialogflow.v2.Generator.Builder builderForValue) {
      if (generatorBuilder_ == null) {
        generatorResource_ = builderForValue.build();
        onChanged();
      } else {
        generatorBuilder_.setMessage(builderForValue.build());
      }
      generatorResourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Uncreated generator. It should be a complete generator that includes all
     * information about the generator.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Generator generator = 2;</code>
     */
    public Builder mergeGenerator(com.google.cloud.dialogflow.v2.Generator value) {
      if (generatorBuilder_ == null) {
        if (generatorResourceCase_ == 2
            && generatorResource_
                != com.google.cloud.dialogflow.v2.Generator.getDefaultInstance()) {
          generatorResource_ =
              com.google.cloud.dialogflow.v2.Generator.newBuilder(
                      (com.google.cloud.dialogflow.v2.Generator) generatorResource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          generatorResource_ = value;
        }
        onChanged();
      } else {
        if (generatorResourceCase_ == 2) {
          generatorBuilder_.mergeFrom(value);
        } else {
          generatorBuilder_.setMessage(value);
        }
      }
      generatorResourceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Uncreated generator. It should be a complete generator that includes all
     * information about the generator.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Generator generator = 2;</code>
     */
    public Builder clearGenerator() {
      if (generatorBuilder_ == null) {
        if (generatorResourceCase_ == 2) {
          generatorResourceCase_ = 0;
          generatorResource_ = null;
          onChanged();
        }
      } else {
        if (generatorResourceCase_ == 2) {
          generatorResourceCase_ = 0;
          generatorResource_ = null;
        }
        generatorBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Uncreated generator. It should be a complete generator that includes all
     * information about the generator.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Generator generator = 2;</code>
     */
    public com.google.cloud.dialogflow.v2.Generator.Builder getGeneratorBuilder() {
      return getGeneratorFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Uncreated generator. It should be a complete generator that includes all
     * information about the generator.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Generator generator = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.GeneratorOrBuilder getGeneratorOrBuilder() {
      if ((generatorResourceCase_ == 2) && (generatorBuilder_ != null)) {
        return generatorBuilder_.getMessageOrBuilder();
      } else {
        if (generatorResourceCase_ == 2) {
          return (com.google.cloud.dialogflow.v2.Generator) generatorResource_;
        }
        return com.google.cloud.dialogflow.v2.Generator.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Uncreated generator. It should be a complete generator that includes all
     * information about the generator.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.Generator generator = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.Generator,
            com.google.cloud.dialogflow.v2.Generator.Builder,
            com.google.cloud.dialogflow.v2.GeneratorOrBuilder>
        getGeneratorFieldBuilder() {
      if (generatorBuilder_ == null) {
        if (!(generatorResourceCase_ == 2)) {
          generatorResource_ = com.google.cloud.dialogflow.v2.Generator.getDefaultInstance();
        }
        generatorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.Generator,
                com.google.cloud.dialogflow.v2.Generator.Builder,
                com.google.cloud.dialogflow.v2.GeneratorOrBuilder>(
                (com.google.cloud.dialogflow.v2.Generator) generatorResource_,
                getParentForChildren(),
                isClean());
        generatorResource_ = null;
      }
      generatorResourceCase_ = 2;
      onChanged();
      return generatorBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the existing created generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>string generator_name = 3;</code>
     *
     * @return Whether the generatorName field is set.
     */
    @java.lang.Override
    public boolean hasGeneratorName() {
      return generatorResourceCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the existing created generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>string generator_name = 3;</code>
     *
     * @return The generatorName.
     */
    @java.lang.Override
    public java.lang.String getGeneratorName() {
      java.lang.Object ref = "";
      if (generatorResourceCase_ == 3) {
        ref = generatorResource_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (generatorResourceCase_ == 3) {
          generatorResource_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the existing created generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>string generator_name = 3;</code>
     *
     * @return The bytes for generatorName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGeneratorNameBytes() {
      java.lang.Object ref = "";
      if (generatorResourceCase_ == 3) {
        ref = generatorResource_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (generatorResourceCase_ == 3) {
          generatorResource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The resource name of the existing created generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>string generator_name = 3;</code>
     *
     * @param value The generatorName to set.
     * @return This builder for chaining.
     */
    public Builder setGeneratorName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      generatorResourceCase_ = 3;
      generatorResource_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the existing created generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>string generator_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGeneratorName() {
      if (generatorResourceCase_ == 3) {
        generatorResourceCase_ = 0;
        generatorResource_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The resource name of the existing created generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>string generator_name = 3;</code>
     *
     * @param value The bytes for generatorName to set.
     * @return This builder for chaining.
     */
    public Builder setGeneratorNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      generatorResourceCase_ = 3;
      generatorResource_ = value;
      onChanged();
      return this;
    }

    private static final class ContextReferencesConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.dialogflow.v2.Conversation.ContextReferenceOrBuilder,
            com.google.cloud.dialogflow.v2.Conversation.ContextReference> {
      @java.lang.Override
      public com.google.cloud.dialogflow.v2.Conversation.ContextReference build(
          com.google.cloud.dialogflow.v2.Conversation.ContextReferenceOrBuilder val) {
        if (val instanceof com.google.cloud.dialogflow.v2.Conversation.ContextReference) {
          return (com.google.cloud.dialogflow.v2.Conversation.ContextReference) val;
        }
        return ((com.google.cloud.dialogflow.v2.Conversation.ContextReference.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
          defaultEntry() {
        return ContextReferencesDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final ContextReferencesConverter contextReferencesConverter =
        new ContextReferencesConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.dialogflow.v2.Conversation.ContextReferenceOrBuilder,
            com.google.cloud.dialogflow.v2.Conversation.ContextReference,
            com.google.cloud.dialogflow.v2.Conversation.ContextReference.Builder>
        contextReferences_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.dialogflow.v2.Conversation.ContextReferenceOrBuilder,
            com.google.cloud.dialogflow.v2.Conversation.ContextReference,
            com.google.cloud.dialogflow.v2.Conversation.ContextReference.Builder>
        internalGetContextReferences() {
      if (contextReferences_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(contextReferencesConverter);
      }
      return contextReferences_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.dialogflow.v2.Conversation.ContextReferenceOrBuilder,
            com.google.cloud.dialogflow.v2.Conversation.ContextReference,
            com.google.cloud.dialogflow.v2.Conversation.ContextReference.Builder>
        internalGetMutableContextReferences() {
      if (contextReferences_ == null) {
        contextReferences_ = new com.google.protobuf.MapFieldBuilder<>(contextReferencesConverter);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return contextReferences_;
    }

    public int getContextReferencesCount() {
      return internalGetContextReferences().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. A section of ingested context information. The key is the name of
     * the context reference and the value contains the contents of the context
     * reference. The key is used to incorporate ingested context references to
     * enhance the generator.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2.Conversation.ContextReference&gt; context_references = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsContextReferences(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetContextReferences().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getContextReferencesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
        getContextReferences() {
      return getContextReferencesMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. A section of ingested context information. The key is the name of
     * the context reference and the value contains the contents of the context
     * reference. The key is used to incorporate ingested context references to
     * enhance the generator.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2.Conversation.ContextReference&gt; context_references = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
        getContextReferencesMap() {
      return internalGetContextReferences().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. A section of ingested context information. The key is the name of
     * the context reference and the value contains the contents of the context
     * reference. The key is used to incorporate ingested context references to
     * enhance the generator.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2.Conversation.ContextReference&gt; context_references = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.dialogflow.v2.Conversation.ContextReference
        getContextReferencesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.dialogflow.v2.Conversation.ContextReference defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.dialogflow.v2.Conversation.ContextReferenceOrBuilder>
          map = internalGetMutableContextReferences().ensureBuilderMap();
      return map.containsKey(key) ? contextReferencesConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. A section of ingested context information. The key is the name of
     * the context reference and the value contains the contents of the context
     * reference. The key is used to incorporate ingested context references to
     * enhance the generator.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2.Conversation.ContextReference&gt; context_references = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.Conversation.ContextReference getContextReferencesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.dialogflow.v2.Conversation.ContextReferenceOrBuilder>
          map = internalGetMutableContextReferences().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return contextReferencesConverter.build(map.get(key));
    }

    public Builder clearContextReferences() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableContextReferences().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A section of ingested context information. The key is the name of
     * the context reference and the value contains the contents of the context
     * reference. The key is used to incorporate ingested context references to
     * enhance the generator.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2.Conversation.ContextReference&gt; context_references = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeContextReferences(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableContextReferences().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
        getMutableContextReferences() {
      bitField0_ |= 0x00000008;
      return internalGetMutableContextReferences().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. A section of ingested context information. The key is the name of
     * the context reference and the value contains the contents of the context
     * reference. The key is used to incorporate ingested context references to
     * enhance the generator.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2.Conversation.ContextReference&gt; context_references = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putContextReferences(
        java.lang.String key, com.google.cloud.dialogflow.v2.Conversation.ContextReference value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableContextReferences().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A section of ingested context information. The key is the name of
     * the context reference and the value contains the contents of the context
     * reference. The key is used to incorporate ingested context references to
     * enhance the generator.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2.Conversation.ContextReference&gt; context_references = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllContextReferences(
        java.util.Map<
                java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.dialogflow.v2.Conversation.ContextReference>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableContextReferences().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A section of ingested context information. The key is the name of
     * the context reference and the value contains the contents of the context
     * reference. The key is used to incorporate ingested context references to
     * enhance the generator.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2.Conversation.ContextReference&gt; context_references = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.Conversation.ContextReference.Builder
        putContextReferencesBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.dialogflow.v2.Conversation.ContextReferenceOrBuilder>
          builderMap = internalGetMutableContextReferences().ensureBuilderMap();
      com.google.cloud.dialogflow.v2.Conversation.ContextReferenceOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.dialogflow.v2.Conversation.ContextReference.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.dialogflow.v2.Conversation.ContextReference) {
        entry = ((com.google.cloud.dialogflow.v2.Conversation.ContextReference) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.dialogflow.v2.Conversation.ContextReference.Builder) entry;
    }

    private com.google.cloud.dialogflow.v2.ConversationContext conversationContext_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.ConversationContext,
            com.google.cloud.dialogflow.v2.ConversationContext.Builder,
            com.google.cloud.dialogflow.v2.ConversationContextOrBuilder>
        conversationContextBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Context of the conversation, including transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the conversationContext field is set.
     */
    public boolean hasConversationContext() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Context of the conversation, including transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The conversationContext.
     */
    public com.google.cloud.dialogflow.v2.ConversationContext getConversationContext() {
      if (conversationContextBuilder_ == null) {
        return conversationContext_ == null
            ? com.google.cloud.dialogflow.v2.ConversationContext.getDefaultInstance()
            : conversationContext_;
      } else {
        return conversationContextBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Context of the conversation, including transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConversationContext(
        com.google.cloud.dialogflow.v2.ConversationContext value) {
      if (conversationContextBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        conversationContext_ = value;
      } else {
        conversationContextBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Context of the conversation, including transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setConversationContext(
        com.google.cloud.dialogflow.v2.ConversationContext.Builder builderForValue) {
      if (conversationContextBuilder_ == null) {
        conversationContext_ = builderForValue.build();
      } else {
        conversationContextBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Context of the conversation, including transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeConversationContext(
        com.google.cloud.dialogflow.v2.ConversationContext value) {
      if (conversationContextBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && conversationContext_ != null
            && conversationContext_
                != com.google.cloud.dialogflow.v2.ConversationContext.getDefaultInstance()) {
          getConversationContextBuilder().mergeFrom(value);
        } else {
          conversationContext_ = value;
        }
      } else {
        conversationContextBuilder_.mergeFrom(value);
      }
      if (conversationContext_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Context of the conversation, including transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearConversationContext() {
      bitField0_ = (bitField0_ & ~0x00000010);
      conversationContext_ = null;
      if (conversationContextBuilder_ != null) {
        conversationContextBuilder_.dispose();
        conversationContextBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Context of the conversation, including transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.ConversationContext.Builder
        getConversationContextBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getConversationContextFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Context of the conversation, including transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.ConversationContextOrBuilder
        getConversationContextOrBuilder() {
      if (conversationContextBuilder_ != null) {
        return conversationContextBuilder_.getMessageOrBuilder();
      } else {
        return conversationContext_ == null
            ? com.google.cloud.dialogflow.v2.ConversationContext.getDefaultInstance()
            : conversationContext_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Context of the conversation, including transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationContext conversation_context = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.ConversationContext,
            com.google.cloud.dialogflow.v2.ConversationContext.Builder,
            com.google.cloud.dialogflow.v2.ConversationContextOrBuilder>
        getConversationContextFieldBuilder() {
      if (conversationContextBuilder_ == null) {
        conversationContextBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.ConversationContext,
                com.google.cloud.dialogflow.v2.ConversationContext.Builder,
                com.google.cloud.dialogflow.v2.ConversationContextOrBuilder>(
                getConversationContext(), getParentForChildren(), isClean());
        conversationContext_ = null;
      }
      return conversationContextBuilder_;
    }

    private java.util.List<java.lang.Integer> triggerEvents_ = java.util.Collections.emptyList();

    private void ensureTriggerEventsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        triggerEvents_ = new java.util.ArrayList<java.lang.Integer>(triggerEvents_);
        bitField0_ |= 0x00000020;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Generator will be triggered only if
     * it's trigger event is included here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the triggerEvents.
     */
    public java.util.List<com.google.cloud.dialogflow.v2.TriggerEvent> getTriggerEventsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.dialogflow.v2.TriggerEvent>(
          triggerEvents_, triggerEvents_converter_);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Generator will be triggered only if
     * it's trigger event is included here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of triggerEvents.
     */
    public int getTriggerEventsCount() {
      return triggerEvents_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Generator will be triggered only if
     * it's trigger event is included here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The triggerEvents at the given index.
     */
    public com.google.cloud.dialogflow.v2.TriggerEvent getTriggerEvents(int index) {
      return triggerEvents_converter_.convert(triggerEvents_.get(index));
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Generator will be triggered only if
     * it's trigger event is included here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The triggerEvents to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerEvents(int index, com.google.cloud.dialogflow.v2.TriggerEvent value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTriggerEventsIsMutable();
      triggerEvents_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Generator will be triggered only if
     * it's trigger event is included here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The triggerEvents to add.
     * @return This builder for chaining.
     */
    public Builder addTriggerEvents(com.google.cloud.dialogflow.v2.TriggerEvent value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTriggerEventsIsMutable();
      triggerEvents_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Generator will be triggered only if
     * it's trigger event is included here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The triggerEvents to add.
     * @return This builder for chaining.
     */
    public Builder addAllTriggerEvents(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.TriggerEvent> values) {
      ensureTriggerEventsIsMutable();
      for (com.google.cloud.dialogflow.v2.TriggerEvent value : values) {
        triggerEvents_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Generator will be triggered only if
     * it's trigger event is included here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTriggerEvents() {
      triggerEvents_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Generator will be triggered only if
     * it's trigger event is included here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for triggerEvents.
     */
    public java.util.List<java.lang.Integer> getTriggerEventsValueList() {
      return java.util.Collections.unmodifiableList(triggerEvents_);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Generator will be triggered only if
     * it's trigger event is included here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of triggerEvents at the given index.
     */
    public int getTriggerEventsValue(int index) {
      return triggerEvents_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Generator will be triggered only if
     * it's trigger event is included here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for triggerEvents to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerEventsValue(int index, int value) {
      ensureTriggerEventsIsMutable();
      triggerEvents_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Generator will be triggered only if
     * it's trigger event is included here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for triggerEvents to add.
     * @return This builder for chaining.
     */
    public Builder addTriggerEventsValue(int value) {
      ensureTriggerEventsIsMutable();
      triggerEvents_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of trigger events. Generator will be triggered only if
     * it's trigger event is included here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.TriggerEvent trigger_events = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for triggerEvents to add.
     * @return This builder for chaining.
     */
    public Builder addAllTriggerEventsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureTriggerEventsIsMutable();
      for (int value : values) {
        triggerEvents_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest)
  private static final com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest();
  }

  public static com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateStatelessSuggestionRequest> PARSER =
      new com.google.protobuf.AbstractParser<GenerateStatelessSuggestionRequest>() {
        @java.lang.Override
        public GenerateStatelessSuggestionRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateStatelessSuggestionRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateStatelessSuggestionRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.GenerateStatelessSuggestionRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
