/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/conversation_model.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Represents a conversation model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.ConversationModel}
 */
public final class ConversationModel extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.ConversationModel)
    ConversationModelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConversationModel.newBuilder() to construct.
  private ConversationModel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConversationModel() {
    name_ = "";
    displayName_ = "";
    datasets_ = java.util.Collections.emptyList();
    state_ = 0;
    languageCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConversationModel();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ConversationModel(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 26:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                datasets_ = new java.util.ArrayList<com.google.cloud.dialogflow.v2.InputDataset>();
                mutable_bitField0_ |= 0x00000001;
              }
              datasets_.add(
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.InputDataset.parser(), extensionRegistry));
              break;
            }
          case 56:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 66:
            {
              com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.Builder subBuilder =
                  null;
              if (modelMetadataCase_ == 8) {
                subBuilder =
                    ((com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata) modelMetadata_)
                        .toBuilder();
              }
              modelMetadata_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata) modelMetadata_);
                modelMetadata_ = subBuilder.buildPartial();
              }
              modelMetadataCase_ = 8;
              break;
            }
          case 74:
            {
              com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.Builder subBuilder = null;
              if (modelMetadataCase_ == 9) {
                subBuilder =
                    ((com.google.cloud.dialogflow.v2.SmartReplyModelMetadata) modelMetadata_)
                        .toBuilder();
              }
              modelMetadata_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.dialogflow.v2.SmartReplyModelMetadata) modelMetadata_);
                modelMetadata_ = subBuilder.buildPartial();
              }
              modelMetadataCase_ = 9;
              break;
            }
          case 154:
            {
              java.lang.String s = input.readStringRequireUtf8();

              languageCode_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        datasets_ = java.util.Collections.unmodifiableList(datasets_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.ConversationModelProto
        .internal_static_google_cloud_dialogflow_v2_ConversationModel_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.ConversationModelProto
        .internal_static_google_cloud_dialogflow_v2_ConversationModel_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.ConversationModel.class,
            com.google.cloud.dialogflow.v2.ConversationModel.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of the model.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2.ConversationModel.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Should not be used, an un-set enum has this value by default.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Model being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * Model is not deployed but ready to deploy.
     * </pre>
     *
     * <code>UNDEPLOYED = 2;</code>
     */
    UNDEPLOYED(2),
    /**
     *
     *
     * <pre>
     * Model is deploying.
     * </pre>
     *
     * <code>DEPLOYING = 3;</code>
     */
    DEPLOYING(3),
    /**
     *
     *
     * <pre>
     * Model is deployed and ready to use.
     * </pre>
     *
     * <code>DEPLOYED = 4;</code>
     */
    DEPLOYED(4),
    /**
     *
     *
     * <pre>
     * Model is undeploying.
     * </pre>
     *
     * <code>UNDEPLOYING = 5;</code>
     */
    UNDEPLOYING(5),
    /**
     *
     *
     * <pre>
     * Model is deleting.
     * </pre>
     *
     * <code>DELETING = 6;</code>
     */
    DELETING(6),
    /**
     *
     *
     * <pre>
     * Model is in error state. Not ready to deploy and use.
     * </pre>
     *
     * <code>FAILED = 7;</code>
     */
    FAILED(7),
    /**
     *
     *
     * <pre>
     * Model is being created but the training has not started,
     * The model may remain in this state until there is enough capacity to
     * start training.
     * </pre>
     *
     * <code>PENDING = 8;</code>
     */
    PENDING(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Should not be used, an un-set enum has this value by default.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Model being created.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Model is not deployed but ready to deploy.
     * </pre>
     *
     * <code>UNDEPLOYED = 2;</code>
     */
    public static final int UNDEPLOYED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Model is deploying.
     * </pre>
     *
     * <code>DEPLOYING = 3;</code>
     */
    public static final int DEPLOYING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Model is deployed and ready to use.
     * </pre>
     *
     * <code>DEPLOYED = 4;</code>
     */
    public static final int DEPLOYED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Model is undeploying.
     * </pre>
     *
     * <code>UNDEPLOYING = 5;</code>
     */
    public static final int UNDEPLOYING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Model is deleting.
     * </pre>
     *
     * <code>DELETING = 6;</code>
     */
    public static final int DELETING_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Model is in error state. Not ready to deploy and use.
     * </pre>
     *
     * <code>FAILED = 7;</code>
     */
    public static final int FAILED_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Model is being created but the training has not started,
     * The model may remain in this state until there is enough capacity to
     * start training.
     * </pre>
     *
     * <code>PENDING = 8;</code>
     */
    public static final int PENDING_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return UNDEPLOYED;
        case 3:
          return DEPLOYING;
        case 4:
          return DEPLOYED;
        case 5:
          return UNDEPLOYING;
        case 6:
          return DELETING;
        case 7:
          return FAILED;
        case 8:
          return PENDING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationModel.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.ConversationModel.State)
  }

  /**
   *
   *
   * <pre>
   * Model type.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2.ConversationModel.ModelType}
   */
  public enum ModelType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * ModelType unspecified.
     * </pre>
     *
     * <code>MODEL_TYPE_UNSPECIFIED = 0;</code>
     */
    MODEL_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * ModelType smart reply dual encoder model.
     * </pre>
     *
     * <code>SMART_REPLY_DUAL_ENCODER_MODEL = 2;</code>
     */
    SMART_REPLY_DUAL_ENCODER_MODEL(2),
    /**
     *
     *
     * <pre>
     * ModelType smart reply bert model.
     * </pre>
     *
     * <code>SMART_REPLY_BERT_MODEL = 6;</code>
     */
    SMART_REPLY_BERT_MODEL(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * ModelType unspecified.
     * </pre>
     *
     * <code>MODEL_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int MODEL_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * ModelType smart reply dual encoder model.
     * </pre>
     *
     * <code>SMART_REPLY_DUAL_ENCODER_MODEL = 2;</code>
     */
    public static final int SMART_REPLY_DUAL_ENCODER_MODEL_VALUE = 2;
    /**
     *
     *
     * <pre>
     * ModelType smart reply bert model.
     * </pre>
     *
     * <code>SMART_REPLY_BERT_MODEL = 6;</code>
     */
    public static final int SMART_REPLY_BERT_MODEL_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModelType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ModelType forNumber(int value) {
      switch (value) {
        case 0:
          return MODEL_TYPE_UNSPECIFIED;
        case 2:
          return SMART_REPLY_DUAL_ENCODER_MODEL;
        case 6:
          return SMART_REPLY_BERT_MODEL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ModelType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ModelType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ModelType>() {
          public ModelType findValueByNumber(int number) {
            return ModelType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationModel.getDescriptor().getEnumTypes().get(1);
    }

    private static final ModelType[] VALUES = values();

    public static ModelType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ModelType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.ConversationModel.ModelType)
  }

  private int modelMetadataCase_ = 0;
  private java.lang.Object modelMetadata_;

  public enum ModelMetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ARTICLE_SUGGESTION_MODEL_METADATA(8),
    SMART_REPLY_MODEL_METADATA(9),
    MODELMETADATA_NOT_SET(0);
    private final int value;

    private ModelMetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModelMetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static ModelMetadataCase forNumber(int value) {
      switch (value) {
        case 8:
          return ARTICLE_SUGGESTION_MODEL_METADATA;
        case 9:
          return SMART_REPLY_MODEL_METADATA;
        case 0:
          return MODELMETADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ModelMetadataCase getModelMetadataCase() {
    return ModelMetadataCase.forNumber(modelMetadataCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * ConversationModel resource name. Format:
   * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model ID&gt;`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * ConversationModel resource name. Format:
   * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model ID&gt;`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The display name of the model. At most 64 bytes long.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the model. At most 64 bytes long.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Creation time of this model.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Creation time of this model.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Creation time of this model.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  public static final int DATASETS_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.dialogflow.v2.InputDataset> datasets_;
  /**
   *
   *
   * <pre>
   * Required. Datasets used to create model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2.InputDataset> getDatasetsList() {
    return datasets_;
  }
  /**
   *
   *
   * <pre>
   * Required. Datasets used to create model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2.InputDatasetOrBuilder>
      getDatasetsOrBuilderList() {
    return datasets_;
  }
  /**
   *
   *
   * <pre>
   * Required. Datasets used to create model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getDatasetsCount() {
    return datasets_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Datasets used to create model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.InputDataset getDatasets(int index) {
    return datasets_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Datasets used to create model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.InputDatasetOrBuilder getDatasetsOrBuilder(int index) {
    return datasets_.get(index);
  }

  public static final int STATE_FIELD_NUMBER = 7;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. State of the model. A model can only serve prediction requests
   * after it gets deployed.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ConversationModel.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the model. A model can only serve prediction requests
   * after it gets deployed.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ConversationModel.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ConversationModel.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2.ConversationModel.State result =
        com.google.cloud.dialogflow.v2.ConversationModel.State.valueOf(state_);
    return result == null
        ? com.google.cloud.dialogflow.v2.ConversationModel.State.UNRECOGNIZED
        : result;
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 19;
  private volatile java.lang.Object languageCode_;
  /**
   *
   *
   * <pre>
   * Language code for the conversation model. If not specified, the language
   * is en-US. Language at ConversationModel should be set for all non en-us
   * languages.
   * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
   * language tag. Example: "en-US".
   * </pre>
   *
   * <code>string language_code = 19;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Language code for the conversation model. If not specified, the language
   * is en-US. Language at ConversationModel should be set for all non en-us
   * languages.
   * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
   * language tag. Example: "en-US".
   * </pre>
   *
   * <code>string language_code = 19;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ARTICLE_SUGGESTION_MODEL_METADATA_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Metadata for article suggestion models.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata article_suggestion_model_metadata = 8;
   * </code>
   *
   * @return Whether the articleSuggestionModelMetadata field is set.
   */
  @java.lang.Override
  public boolean hasArticleSuggestionModelMetadata() {
    return modelMetadataCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Metadata for article suggestion models.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata article_suggestion_model_metadata = 8;
   * </code>
   *
   * @return The articleSuggestionModelMetadata.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata
      getArticleSuggestionModelMetadata() {
    if (modelMetadataCase_ == 8) {
      return (com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata) modelMetadata_;
    }
    return com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for article suggestion models.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata article_suggestion_model_metadata = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadataOrBuilder
      getArticleSuggestionModelMetadataOrBuilder() {
    if (modelMetadataCase_ == 8) {
      return (com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata) modelMetadata_;
    }
    return com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.getDefaultInstance();
  }

  public static final int SMART_REPLY_MODEL_METADATA_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Metadata for smart reply models.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.SmartReplyModelMetadata smart_reply_model_metadata = 9;
   * </code>
   *
   * @return Whether the smartReplyModelMetadata field is set.
   */
  @java.lang.Override
  public boolean hasSmartReplyModelMetadata() {
    return modelMetadataCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Metadata for smart reply models.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.SmartReplyModelMetadata smart_reply_model_metadata = 9;
   * </code>
   *
   * @return The smartReplyModelMetadata.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SmartReplyModelMetadata getSmartReplyModelMetadata() {
    if (modelMetadataCase_ == 9) {
      return (com.google.cloud.dialogflow.v2.SmartReplyModelMetadata) modelMetadata_;
    }
    return com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for smart reply models.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.SmartReplyModelMetadata smart_reply_model_metadata = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.SmartReplyModelMetadataOrBuilder
      getSmartReplyModelMetadataOrBuilder() {
    if (modelMetadataCase_ == 9) {
      return (com.google.cloud.dialogflow.v2.SmartReplyModelMetadata) modelMetadata_;
    }
    return com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    for (int i = 0; i < datasets_.size(); i++) {
      output.writeMessage(4, datasets_.get(i));
    }
    if (state_
        != com.google.cloud.dialogflow.v2.ConversationModel.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, state_);
    }
    if (modelMetadataCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.dialogflow.v2.SmartReplyModelMetadata) modelMetadata_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, languageCode_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    for (int i = 0; i < datasets_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, datasets_.get(i));
    }
    if (state_
        != com.google.cloud.dialogflow.v2.ConversationModel.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, state_);
    }
    if (modelMetadataCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata) modelMetadata_);
    }
    if (modelMetadataCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.dialogflow.v2.SmartReplyModelMetadata) modelMetadata_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, languageCode_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.ConversationModel)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.ConversationModel other =
        (com.google.cloud.dialogflow.v2.ConversationModel) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getDatasetsList().equals(other.getDatasetsList())) return false;
    if (state_ != other.state_) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getModelMetadataCase().equals(other.getModelMetadataCase())) return false;
    switch (modelMetadataCase_) {
      case 8:
        if (!getArticleSuggestionModelMetadata().equals(other.getArticleSuggestionModelMetadata()))
          return false;
        break;
      case 9:
        if (!getSmartReplyModelMetadata().equals(other.getSmartReplyModelMetadata())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (getDatasetsCount() > 0) {
      hash = (37 * hash) + DATASETS_FIELD_NUMBER;
      hash = (53 * hash) + getDatasetsList().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    switch (modelMetadataCase_) {
      case 8:
        hash = (37 * hash) + ARTICLE_SUGGESTION_MODEL_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getArticleSuggestionModelMetadata().hashCode();
        break;
      case 9:
        hash = (37 * hash) + SMART_REPLY_MODEL_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getSmartReplyModelMetadata().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.ConversationModel parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModel parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModel parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModel parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModel parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModel parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModel parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModel parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModel parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModel parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModel parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ConversationModel parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.ConversationModel prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a conversation model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.ConversationModel}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.ConversationModel)
      com.google.cloud.dialogflow.v2.ConversationModelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_ConversationModel_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_ConversationModel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.ConversationModel.class,
              com.google.cloud.dialogflow.v2.ConversationModel.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.ConversationModel.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDatasetsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      if (datasetsBuilder_ == null) {
        datasets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        datasetsBuilder_.clear();
      }
      state_ = 0;

      languageCode_ = "";

      modelMetadataCase_ = 0;
      modelMetadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.ConversationModelProto
          .internal_static_google_cloud_dialogflow_v2_ConversationModel_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationModel getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.ConversationModel.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationModel build() {
      com.google.cloud.dialogflow.v2.ConversationModel result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationModel buildPartial() {
      com.google.cloud.dialogflow.v2.ConversationModel result =
          new com.google.cloud.dialogflow.v2.ConversationModel(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      if (datasetsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          datasets_ = java.util.Collections.unmodifiableList(datasets_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.datasets_ = datasets_;
      } else {
        result.datasets_ = datasetsBuilder_.build();
      }
      result.state_ = state_;
      result.languageCode_ = languageCode_;
      if (modelMetadataCase_ == 8) {
        if (articleSuggestionModelMetadataBuilder_ == null) {
          result.modelMetadata_ = modelMetadata_;
        } else {
          result.modelMetadata_ = articleSuggestionModelMetadataBuilder_.build();
        }
      }
      if (modelMetadataCase_ == 9) {
        if (smartReplyModelMetadataBuilder_ == null) {
          result.modelMetadata_ = modelMetadata_;
        } else {
          result.modelMetadata_ = smartReplyModelMetadataBuilder_.build();
        }
      }
      result.modelMetadataCase_ = modelMetadataCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.ConversationModel) {
        return mergeFrom((com.google.cloud.dialogflow.v2.ConversationModel) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.ConversationModel other) {
      if (other == com.google.cloud.dialogflow.v2.ConversationModel.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (datasetsBuilder_ == null) {
        if (!other.datasets_.isEmpty()) {
          if (datasets_.isEmpty()) {
            datasets_ = other.datasets_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureDatasetsIsMutable();
            datasets_.addAll(other.datasets_);
          }
          onChanged();
        }
      } else {
        if (!other.datasets_.isEmpty()) {
          if (datasetsBuilder_.isEmpty()) {
            datasetsBuilder_.dispose();
            datasetsBuilder_ = null;
            datasets_ = other.datasets_;
            bitField0_ = (bitField0_ & ~0x00000001);
            datasetsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDatasetsFieldBuilder()
                    : null;
          } else {
            datasetsBuilder_.addAllMessages(other.datasets_);
          }
        }
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        onChanged();
      }
      switch (other.getModelMetadataCase()) {
        case ARTICLE_SUGGESTION_MODEL_METADATA:
          {
            mergeArticleSuggestionModelMetadata(other.getArticleSuggestionModelMetadata());
            break;
          }
        case SMART_REPLY_MODEL_METADATA:
          {
            mergeSmartReplyModelMetadata(other.getSmartReplyModelMetadata());
            break;
          }
        case MODELMETADATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2.ConversationModel parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.dialogflow.v2.ConversationModel) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int modelMetadataCase_ = 0;
    private java.lang.Object modelMetadata_;

    public ModelMetadataCase getModelMetadataCase() {
      return ModelMetadataCase.forNumber(modelMetadataCase_);
    }

    public Builder clearModelMetadata() {
      modelMetadataCase_ = 0;
      modelMetadata_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * ConversationModel resource name. Format:
     * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model ID&gt;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ConversationModel resource name. Format:
     * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model ID&gt;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ConversationModel resource name. Format:
     * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model ID&gt;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ConversationModel resource name. Format:
     * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model ID&gt;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ConversationModel resource name. Format:
     * `projects/&lt;Project ID&gt;/conversationModels/&lt;Conversation Model ID&gt;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the model. At most 64 bytes long.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the model. At most 64 bytes long.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the model. At most 64 bytes long.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the model. At most 64 bytes long.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the model. At most 64 bytes long.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of this model.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.v2.InputDataset> datasets_ =
        java.util.Collections.emptyList();

    private void ensureDatasetsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        datasets_ = new java.util.ArrayList<com.google.cloud.dialogflow.v2.InputDataset>(datasets_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.InputDataset,
            com.google.cloud.dialogflow.v2.InputDataset.Builder,
            com.google.cloud.dialogflow.v2.InputDatasetOrBuilder>
        datasetsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.InputDataset> getDatasetsList() {
      if (datasetsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(datasets_);
      } else {
        return datasetsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getDatasetsCount() {
      if (datasetsBuilder_ == null) {
        return datasets_.size();
      } else {
        return datasetsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.InputDataset getDatasets(int index) {
      if (datasetsBuilder_ == null) {
        return datasets_.get(index);
      } else {
        return datasetsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDatasets(int index, com.google.cloud.dialogflow.v2.InputDataset value) {
      if (datasetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDatasetsIsMutable();
        datasets_.set(index, value);
        onChanged();
      } else {
        datasetsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDatasets(
        int index, com.google.cloud.dialogflow.v2.InputDataset.Builder builderForValue) {
      if (datasetsBuilder_ == null) {
        ensureDatasetsIsMutable();
        datasets_.set(index, builderForValue.build());
        onChanged();
      } else {
        datasetsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDatasets(com.google.cloud.dialogflow.v2.InputDataset value) {
      if (datasetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDatasetsIsMutable();
        datasets_.add(value);
        onChanged();
      } else {
        datasetsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDatasets(int index, com.google.cloud.dialogflow.v2.InputDataset value) {
      if (datasetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDatasetsIsMutable();
        datasets_.add(index, value);
        onChanged();
      } else {
        datasetsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDatasets(
        com.google.cloud.dialogflow.v2.InputDataset.Builder builderForValue) {
      if (datasetsBuilder_ == null) {
        ensureDatasetsIsMutable();
        datasets_.add(builderForValue.build());
        onChanged();
      } else {
        datasetsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addDatasets(
        int index, com.google.cloud.dialogflow.v2.InputDataset.Builder builderForValue) {
      if (datasetsBuilder_ == null) {
        ensureDatasetsIsMutable();
        datasets_.add(index, builderForValue.build());
        onChanged();
      } else {
        datasetsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllDatasets(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.InputDataset> values) {
      if (datasetsBuilder_ == null) {
        ensureDatasetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, datasets_);
        onChanged();
      } else {
        datasetsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDatasets() {
      if (datasetsBuilder_ == null) {
        datasets_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        datasetsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeDatasets(int index) {
      if (datasetsBuilder_ == null) {
        ensureDatasetsIsMutable();
        datasets_.remove(index);
        onChanged();
      } else {
        datasetsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.InputDataset.Builder getDatasetsBuilder(int index) {
      return getDatasetsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.InputDatasetOrBuilder getDatasetsOrBuilder(int index) {
      if (datasetsBuilder_ == null) {
        return datasets_.get(index);
      } else {
        return datasetsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2.InputDatasetOrBuilder>
        getDatasetsOrBuilderList() {
      if (datasetsBuilder_ != null) {
        return datasetsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(datasets_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.InputDataset.Builder addDatasetsBuilder() {
      return getDatasetsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2.InputDataset.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.InputDataset.Builder addDatasetsBuilder(int index) {
      return getDatasetsFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.v2.InputDataset.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Datasets used to create model.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.InputDataset datasets = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.InputDataset.Builder>
        getDatasetsBuilderList() {
      return getDatasetsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.InputDataset,
            com.google.cloud.dialogflow.v2.InputDataset.Builder,
            com.google.cloud.dialogflow.v2.InputDatasetOrBuilder>
        getDatasetsFieldBuilder() {
      if (datasetsBuilder_ == null) {
        datasetsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.InputDataset,
                com.google.cloud.dialogflow.v2.InputDataset.Builder,
                com.google.cloud.dialogflow.v2.InputDatasetOrBuilder>(
                datasets_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        datasets_ = null;
      }
      return datasetsBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the model. A model can only serve prediction requests
     * after it gets deployed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationModel.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the model. A model can only serve prediction requests
     * after it gets deployed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationModel.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the model. A model can only serve prediction requests
     * after it gets deployed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationModel.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ConversationModel.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2.ConversationModel.State result =
          com.google.cloud.dialogflow.v2.ConversationModel.State.valueOf(state_);
      return result == null
          ? com.google.cloud.dialogflow.v2.ConversationModel.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the model. A model can only serve prediction requests
     * after it gets deployed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationModel.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.dialogflow.v2.ConversationModel.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the model. A model can only serve prediction requests
     * after it gets deployed.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ConversationModel.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Language code for the conversation model. If not specified, the language
     * is en-US. Language at ConversationModel should be set for all non en-us
     * languages.
     * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag. Example: "en-US".
     * </pre>
     *
     * <code>string language_code = 19;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language code for the conversation model. If not specified, the language
     * is en-US. Language at ConversationModel should be set for all non en-us
     * languages.
     * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag. Example: "en-US".
     * </pre>
     *
     * <code>string language_code = 19;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language code for the conversation model. If not specified, the language
     * is en-US. Language at ConversationModel should be set for all non en-us
     * languages.
     * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag. Example: "en-US".
     * </pre>
     *
     * <code>string language_code = 19;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      languageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language code for the conversation model. If not specified, the language
     * is en-US. Language at ConversationModel should be set for all non en-us
     * languages.
     * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag. Example: "en-US".
     * </pre>
     *
     * <code>string language_code = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {

      languageCode_ = getDefaultInstance().getLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language code for the conversation model. If not specified, the language
     * is en-US. Language at ConversationModel should be set for all non en-us
     * languages.
     * This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
     * language tag. Example: "en-US".
     * </pre>
     *
     * <code>string language_code = 19;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      languageCode_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata,
            com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.Builder,
            com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadataOrBuilder>
        articleSuggestionModelMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for article suggestion models.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata article_suggestion_model_metadata = 8;
     * </code>
     *
     * @return Whether the articleSuggestionModelMetadata field is set.
     */
    @java.lang.Override
    public boolean hasArticleSuggestionModelMetadata() {
      return modelMetadataCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Metadata for article suggestion models.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata article_suggestion_model_metadata = 8;
     * </code>
     *
     * @return The articleSuggestionModelMetadata.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata
        getArticleSuggestionModelMetadata() {
      if (articleSuggestionModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 8) {
          return (com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata) modelMetadata_;
        }
        return com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.getDefaultInstance();
      } else {
        if (modelMetadataCase_ == 8) {
          return articleSuggestionModelMetadataBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for article suggestion models.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata article_suggestion_model_metadata = 8;
     * </code>
     */
    public Builder setArticleSuggestionModelMetadata(
        com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata value) {
      if (articleSuggestionModelMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMetadata_ = value;
        onChanged();
      } else {
        articleSuggestionModelMetadataBuilder_.setMessage(value);
      }
      modelMetadataCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for article suggestion models.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata article_suggestion_model_metadata = 8;
     * </code>
     */
    public Builder setArticleSuggestionModelMetadata(
        com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.Builder builderForValue) {
      if (articleSuggestionModelMetadataBuilder_ == null) {
        modelMetadata_ = builderForValue.build();
        onChanged();
      } else {
        articleSuggestionModelMetadataBuilder_.setMessage(builderForValue.build());
      }
      modelMetadataCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for article suggestion models.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata article_suggestion_model_metadata = 8;
     * </code>
     */
    public Builder mergeArticleSuggestionModelMetadata(
        com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata value) {
      if (articleSuggestionModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 8
            && modelMetadata_
                != com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata
                    .getDefaultInstance()) {
          modelMetadata_ =
              com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.newBuilder(
                      (com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata)
                          modelMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelMetadata_ = value;
        }
        onChanged();
      } else {
        if (modelMetadataCase_ == 8) {
          articleSuggestionModelMetadataBuilder_.mergeFrom(value);
        } else {
          articleSuggestionModelMetadataBuilder_.setMessage(value);
        }
      }
      modelMetadataCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for article suggestion models.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata article_suggestion_model_metadata = 8;
     * </code>
     */
    public Builder clearArticleSuggestionModelMetadata() {
      if (articleSuggestionModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 8) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
          onChanged();
        }
      } else {
        if (modelMetadataCase_ == 8) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
        }
        articleSuggestionModelMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for article suggestion models.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata article_suggestion_model_metadata = 8;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.Builder
        getArticleSuggestionModelMetadataBuilder() {
      return getArticleSuggestionModelMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for article suggestion models.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata article_suggestion_model_metadata = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadataOrBuilder
        getArticleSuggestionModelMetadataOrBuilder() {
      if ((modelMetadataCase_ == 8) && (articleSuggestionModelMetadataBuilder_ != null)) {
        return articleSuggestionModelMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (modelMetadataCase_ == 8) {
          return (com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata) modelMetadata_;
        }
        return com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for article suggestion models.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata article_suggestion_model_metadata = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata,
            com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.Builder,
            com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadataOrBuilder>
        getArticleSuggestionModelMetadataFieldBuilder() {
      if (articleSuggestionModelMetadataBuilder_ == null) {
        if (!(modelMetadataCase_ == 8)) {
          modelMetadata_ =
              com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.getDefaultInstance();
        }
        articleSuggestionModelMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata,
                com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata.Builder,
                com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadataOrBuilder>(
                (com.google.cloud.dialogflow.v2.ArticleSuggestionModelMetadata) modelMetadata_,
                getParentForChildren(),
                isClean());
        modelMetadata_ = null;
      }
      modelMetadataCase_ = 8;
      onChanged();
      ;
      return articleSuggestionModelMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SmartReplyModelMetadata,
            com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.Builder,
            com.google.cloud.dialogflow.v2.SmartReplyModelMetadataOrBuilder>
        smartReplyModelMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for smart reply models.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SmartReplyModelMetadata smart_reply_model_metadata = 9;
     * </code>
     *
     * @return Whether the smartReplyModelMetadata field is set.
     */
    @java.lang.Override
    public boolean hasSmartReplyModelMetadata() {
      return modelMetadataCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Metadata for smart reply models.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SmartReplyModelMetadata smart_reply_model_metadata = 9;
     * </code>
     *
     * @return The smartReplyModelMetadata.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SmartReplyModelMetadata getSmartReplyModelMetadata() {
      if (smartReplyModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 9) {
          return (com.google.cloud.dialogflow.v2.SmartReplyModelMetadata) modelMetadata_;
        }
        return com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.getDefaultInstance();
      } else {
        if (modelMetadataCase_ == 9) {
          return smartReplyModelMetadataBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for smart reply models.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SmartReplyModelMetadata smart_reply_model_metadata = 9;
     * </code>
     */
    public Builder setSmartReplyModelMetadata(
        com.google.cloud.dialogflow.v2.SmartReplyModelMetadata value) {
      if (smartReplyModelMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMetadata_ = value;
        onChanged();
      } else {
        smartReplyModelMetadataBuilder_.setMessage(value);
      }
      modelMetadataCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for smart reply models.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SmartReplyModelMetadata smart_reply_model_metadata = 9;
     * </code>
     */
    public Builder setSmartReplyModelMetadata(
        com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.Builder builderForValue) {
      if (smartReplyModelMetadataBuilder_ == null) {
        modelMetadata_ = builderForValue.build();
        onChanged();
      } else {
        smartReplyModelMetadataBuilder_.setMessage(builderForValue.build());
      }
      modelMetadataCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for smart reply models.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SmartReplyModelMetadata smart_reply_model_metadata = 9;
     * </code>
     */
    public Builder mergeSmartReplyModelMetadata(
        com.google.cloud.dialogflow.v2.SmartReplyModelMetadata value) {
      if (smartReplyModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 9
            && modelMetadata_
                != com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.getDefaultInstance()) {
          modelMetadata_ =
              com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.newBuilder(
                      (com.google.cloud.dialogflow.v2.SmartReplyModelMetadata) modelMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelMetadata_ = value;
        }
        onChanged();
      } else {
        if (modelMetadataCase_ == 9) {
          smartReplyModelMetadataBuilder_.mergeFrom(value);
        } else {
          smartReplyModelMetadataBuilder_.setMessage(value);
        }
      }
      modelMetadataCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for smart reply models.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SmartReplyModelMetadata smart_reply_model_metadata = 9;
     * </code>
     */
    public Builder clearSmartReplyModelMetadata() {
      if (smartReplyModelMetadataBuilder_ == null) {
        if (modelMetadataCase_ == 9) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
          onChanged();
        }
      } else {
        if (modelMetadataCase_ == 9) {
          modelMetadataCase_ = 0;
          modelMetadata_ = null;
        }
        smartReplyModelMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for smart reply models.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SmartReplyModelMetadata smart_reply_model_metadata = 9;
     * </code>
     */
    public com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.Builder
        getSmartReplyModelMetadataBuilder() {
      return getSmartReplyModelMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for smart reply models.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SmartReplyModelMetadata smart_reply_model_metadata = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.SmartReplyModelMetadataOrBuilder
        getSmartReplyModelMetadataOrBuilder() {
      if ((modelMetadataCase_ == 9) && (smartReplyModelMetadataBuilder_ != null)) {
        return smartReplyModelMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (modelMetadataCase_ == 9) {
          return (com.google.cloud.dialogflow.v2.SmartReplyModelMetadata) modelMetadata_;
        }
        return com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for smart reply models.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.SmartReplyModelMetadata smart_reply_model_metadata = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.SmartReplyModelMetadata,
            com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.Builder,
            com.google.cloud.dialogflow.v2.SmartReplyModelMetadataOrBuilder>
        getSmartReplyModelMetadataFieldBuilder() {
      if (smartReplyModelMetadataBuilder_ == null) {
        if (!(modelMetadataCase_ == 9)) {
          modelMetadata_ =
              com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.getDefaultInstance();
        }
        smartReplyModelMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.SmartReplyModelMetadata,
                com.google.cloud.dialogflow.v2.SmartReplyModelMetadata.Builder,
                com.google.cloud.dialogflow.v2.SmartReplyModelMetadataOrBuilder>(
                (com.google.cloud.dialogflow.v2.SmartReplyModelMetadata) modelMetadata_,
                getParentForChildren(),
                isClean());
        modelMetadata_ = null;
      }
      modelMetadataCase_ = 9;
      onChanged();
      ;
      return smartReplyModelMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.ConversationModel)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.ConversationModel)
  private static final com.google.cloud.dialogflow.v2.ConversationModel DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.ConversationModel();
  }

  public static com.google.cloud.dialogflow.v2.ConversationModel getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConversationModel> PARSER =
      new com.google.protobuf.AbstractParser<ConversationModel>() {
        @java.lang.Override
        public ConversationModel parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ConversationModel(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ConversationModel> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConversationModel> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ConversationModel getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
