/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/entity_type.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Each intent parameter has a type, called the entity type, which dictates
 * exactly how data from an end-user expression is extracted.
 * Dialogflow provides predefined system entities that can match many common
 * types of data. For example, there are system entities for matching dates,
 * times, colors, email addresses, and so on. You can also create your own
 * custom entities for matching custom data. For example, you could define a
 * vegetable entity that can match the types of vegetables available for
 * purchase with a grocery store agent.
 * For more information, see the
 * [Entity guide](https://cloud.google.com/dialogflow/docs/entities-overview).
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.EntityType}
 */
public final class EntityType extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.EntityType)
    EntityTypeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EntityType.newBuilder() to construct.
  private EntityType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EntityType() {
    name_ = "";
    displayName_ = "";
    kind_ = 0;
    autoExpansionMode_ = 0;
    entities_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EntityType();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private EntityType(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              kind_ = rawValue;
              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              autoExpansionMode_ = rawValue;
              break;
            }
          case 50:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                entities_ =
                    new java.util.ArrayList<com.google.cloud.dialogflow.v2.EntityType.Entity>();
                mutable_bitField0_ |= 0x00000001;
              }
              entities_.add(
                  input.readMessage(
                      com.google.cloud.dialogflow.v2.EntityType.Entity.parser(),
                      extensionRegistry));
              break;
            }
          case 56:
            {
              enableFuzzyExtraction_ = input.readBool();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        entities_ = java.util.Collections.unmodifiableList(entities_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.EntityTypeProto
        .internal_static_google_cloud_dialogflow_v2_EntityType_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.EntityTypeProto
        .internal_static_google_cloud_dialogflow_v2_EntityType_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.EntityType.class,
            com.google.cloud.dialogflow.v2.EntityType.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents kinds of entities.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2.EntityType.Kind}
   */
  public enum Kind implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. This value should be never used.
     * </pre>
     *
     * <code>KIND_UNSPECIFIED = 0;</code>
     */
    KIND_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Map entity types allow mapping of a group of synonyms to a reference
     * value.
     * </pre>
     *
     * <code>KIND_MAP = 1;</code>
     */
    KIND_MAP(1),
    /**
     *
     *
     * <pre>
     * List entity types contain a set of entries that do not map to reference
     * values. However, list entity types can contain references to other entity
     * types (with or without aliases).
     * </pre>
     *
     * <code>KIND_LIST = 2;</code>
     */
    KIND_LIST(2),
    /**
     *
     *
     * <pre>
     * Regexp entity types allow to specify regular expressions in entries
     * values.
     * </pre>
     *
     * <code>KIND_REGEXP = 3;</code>
     */
    KIND_REGEXP(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. This value should be never used.
     * </pre>
     *
     * <code>KIND_UNSPECIFIED = 0;</code>
     */
    public static final int KIND_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Map entity types allow mapping of a group of synonyms to a reference
     * value.
     * </pre>
     *
     * <code>KIND_MAP = 1;</code>
     */
    public static final int KIND_MAP_VALUE = 1;
    /**
     *
     *
     * <pre>
     * List entity types contain a set of entries that do not map to reference
     * values. However, list entity types can contain references to other entity
     * types (with or without aliases).
     * </pre>
     *
     * <code>KIND_LIST = 2;</code>
     */
    public static final int KIND_LIST_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Regexp entity types allow to specify regular expressions in entries
     * values.
     * </pre>
     *
     * <code>KIND_REGEXP = 3;</code>
     */
    public static final int KIND_REGEXP_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Kind valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Kind forNumber(int value) {
      switch (value) {
        case 0:
          return KIND_UNSPECIFIED;
        case 1:
          return KIND_MAP;
        case 2:
          return KIND_LIST;
        case 3:
          return KIND_REGEXP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Kind> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Kind> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Kind>() {
          public Kind findValueByNumber(int number) {
            return Kind.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.EntityType.getDescriptor().getEnumTypes().get(0);
    }

    private static final Kind[] VALUES = values();

    public static Kind valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Kind(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.EntityType.Kind)
  }

  /**
   *
   *
   * <pre>
   * Represents different entity type expansion modes. Automated expansion
   * allows an agent to recognize values that have not been explicitly listed in
   * the entity (for example, new kinds of shopping list items).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2.EntityType.AutoExpansionMode}
   */
  public enum AutoExpansionMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Auto expansion disabled for the entity.
     * </pre>
     *
     * <code>AUTO_EXPANSION_MODE_UNSPECIFIED = 0;</code>
     */
    AUTO_EXPANSION_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Allows an agent to recognize values that have not been explicitly
     * listed in the entity.
     * </pre>
     *
     * <code>AUTO_EXPANSION_MODE_DEFAULT = 1;</code>
     */
    AUTO_EXPANSION_MODE_DEFAULT(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Auto expansion disabled for the entity.
     * </pre>
     *
     * <code>AUTO_EXPANSION_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int AUTO_EXPANSION_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Allows an agent to recognize values that have not been explicitly
     * listed in the entity.
     * </pre>
     *
     * <code>AUTO_EXPANSION_MODE_DEFAULT = 1;</code>
     */
    public static final int AUTO_EXPANSION_MODE_DEFAULT_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AutoExpansionMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AutoExpansionMode forNumber(int value) {
      switch (value) {
        case 0:
          return AUTO_EXPANSION_MODE_UNSPECIFIED;
        case 1:
          return AUTO_EXPANSION_MODE_DEFAULT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AutoExpansionMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AutoExpansionMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AutoExpansionMode>() {
              public AutoExpansionMode findValueByNumber(int number) {
                return AutoExpansionMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.EntityType.getDescriptor().getEnumTypes().get(1);
    }

    private static final AutoExpansionMode[] VALUES = values();

    public static AutoExpansionMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AutoExpansionMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2.EntityType.AutoExpansionMode)
  }

  public interface EntityOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2.EntityType.Entity)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The primary value associated with this entity entry.
     * For example, if the entity type is *vegetable*, the value could be
     * *scallions*.
     * For `KIND_MAP` entity types:
     * *   A reference value to be used in place of synonyms.
     * For `KIND_LIST` entity types:
     * *   A string that can contain references to other entity types (with or
     *     without aliases).
     * </pre>
     *
     * <code>string value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The value.
     */
    java.lang.String getValue();
    /**
     *
     *
     * <pre>
     * Required. The primary value associated with this entity entry.
     * For example, if the entity type is *vegetable*, the value could be
     * *scallions*.
     * For `KIND_MAP` entity types:
     * *   A reference value to be used in place of synonyms.
     * For `KIND_LIST` entity types:
     * *   A string that can contain references to other entity types (with or
     *     without aliases).
     * </pre>
     *
     * <code>string value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString getValueBytes();

    /**
     *
     *
     * <pre>
     * Required. A collection of value synonyms. For example, if the entity type
     * is *vegetable*, and `value` is *scallions*, a synonym could be *green
     * onions*.
     * For `KIND_LIST` entity types:
     * *   This collection must contain exactly one synonym equal to `value`.
     * </pre>
     *
     * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the synonyms.
     */
    java.util.List<java.lang.String> getSynonymsList();
    /**
     *
     *
     * <pre>
     * Required. A collection of value synonyms. For example, if the entity type
     * is *vegetable*, and `value` is *scallions*, a synonym could be *green
     * onions*.
     * For `KIND_LIST` entity types:
     * *   This collection must contain exactly one synonym equal to `value`.
     * </pre>
     *
     * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of synonyms.
     */
    int getSynonymsCount();
    /**
     *
     *
     * <pre>
     * Required. A collection of value synonyms. For example, if the entity type
     * is *vegetable*, and `value` is *scallions*, a synonym could be *green
     * onions*.
     * For `KIND_LIST` entity types:
     * *   This collection must contain exactly one synonym equal to `value`.
     * </pre>
     *
     * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The synonyms at the given index.
     */
    java.lang.String getSynonyms(int index);
    /**
     *
     *
     * <pre>
     * Required. A collection of value synonyms. For example, if the entity type
     * is *vegetable*, and `value` is *scallions*, a synonym could be *green
     * onions*.
     * For `KIND_LIST` entity types:
     * *   This collection must contain exactly one synonym equal to `value`.
     * </pre>
     *
     * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the synonyms at the given index.
     */
    com.google.protobuf.ByteString getSynonymsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * An **entity entry** for an associated entity type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.EntityType.Entity}
   */
  public static final class Entity extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.EntityType.Entity)
      EntityOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Entity.newBuilder() to construct.
    private Entity(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Entity() {
      value_ = "";
      synonyms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Entity();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Entity(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                value_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  synonyms_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000001;
                }
                synonyms_.add(s);
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          synonyms_ = synonyms_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.EntityTypeProto
          .internal_static_google_cloud_dialogflow_v2_EntityType_Entity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.EntityTypeProto
          .internal_static_google_cloud_dialogflow_v2_EntityType_Entity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.EntityType.Entity.class,
              com.google.cloud.dialogflow.v2.EntityType.Entity.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    private volatile java.lang.Object value_;
    /**
     *
     *
     * <pre>
     * Required. The primary value associated with this entity entry.
     * For example, if the entity type is *vegetable*, the value could be
     * *scallions*.
     * For `KIND_MAP` entity types:
     * *   A reference value to be used in place of synonyms.
     * For `KIND_LIST` entity types:
     * *   A string that can contain references to other entity types (with or
     *     without aliases).
     * </pre>
     *
     * <code>string value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The primary value associated with this entity entry.
     * For example, if the entity type is *vegetable*, the value could be
     * *scallions*.
     * For `KIND_MAP` entity types:
     * *   A reference value to be used in place of synonyms.
     * For `KIND_LIST` entity types:
     * *   A string that can contain references to other entity types (with or
     *     without aliases).
     * </pre>
     *
     * <code>string value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SYNONYMS_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList synonyms_;
    /**
     *
     *
     * <pre>
     * Required. A collection of value synonyms. For example, if the entity type
     * is *vegetable*, and `value` is *scallions*, a synonym could be *green
     * onions*.
     * For `KIND_LIST` entity types:
     * *   This collection must contain exactly one synonym equal to `value`.
     * </pre>
     *
     * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the synonyms.
     */
    public com.google.protobuf.ProtocolStringList getSynonymsList() {
      return synonyms_;
    }
    /**
     *
     *
     * <pre>
     * Required. A collection of value synonyms. For example, if the entity type
     * is *vegetable*, and `value` is *scallions*, a synonym could be *green
     * onions*.
     * For `KIND_LIST` entity types:
     * *   This collection must contain exactly one synonym equal to `value`.
     * </pre>
     *
     * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of synonyms.
     */
    public int getSynonymsCount() {
      return synonyms_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. A collection of value synonyms. For example, if the entity type
     * is *vegetable*, and `value` is *scallions*, a synonym could be *green
     * onions*.
     * For `KIND_LIST` entity types:
     * *   This collection must contain exactly one synonym equal to `value`.
     * </pre>
     *
     * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The synonyms at the given index.
     */
    public java.lang.String getSynonyms(int index) {
      return synonyms_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. A collection of value synonyms. For example, if the entity type
     * is *vegetable*, and `value` is *scallions*, a synonym could be *green
     * onions*.
     * For `KIND_LIST` entity types:
     * *   This collection must contain exactly one synonym equal to `value`.
     * </pre>
     *
     * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the synonyms at the given index.
     */
    public com.google.protobuf.ByteString getSynonymsBytes(int index) {
      return synonyms_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, value_);
      }
      for (int i = 0; i < synonyms_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, synonyms_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, value_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < synonyms_.size(); i++) {
          dataSize += computeStringSizeNoTag(synonyms_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getSynonymsList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.v2.EntityType.Entity)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2.EntityType.Entity other =
          (com.google.cloud.dialogflow.v2.EntityType.Entity) obj;

      if (!getValue().equals(other.getValue())) return false;
      if (!getSynonymsList().equals(other.getSynonymsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      if (getSynonymsCount() > 0) {
        hash = (37 * hash) + SYNONYMS_FIELD_NUMBER;
        hash = (53 * hash) + getSynonymsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2.EntityType.Entity parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.EntityType.Entity parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EntityType.Entity parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.EntityType.Entity parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EntityType.Entity parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2.EntityType.Entity parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EntityType.Entity parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.EntityType.Entity parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EntityType.Entity parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.EntityType.Entity parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2.EntityType.Entity parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2.EntityType.Entity parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.dialogflow.v2.EntityType.Entity prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An **entity entry** for an associated entity type.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2.EntityType.Entity}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.EntityType.Entity)
        com.google.cloud.dialogflow.v2.EntityType.EntityOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2.EntityTypeProto
            .internal_static_google_cloud_dialogflow_v2_EntityType_Entity_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2.EntityTypeProto
            .internal_static_google_cloud_dialogflow_v2_EntityType_Entity_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2.EntityType.Entity.class,
                com.google.cloud.dialogflow.v2.EntityType.Entity.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.v2.EntityType.Entity.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        value_ = "";

        synonyms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2.EntityTypeProto
            .internal_static_google_cloud_dialogflow_v2_EntityType_Entity_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.EntityType.Entity getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2.EntityType.Entity.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.EntityType.Entity build() {
        com.google.cloud.dialogflow.v2.EntityType.Entity result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2.EntityType.Entity buildPartial() {
        com.google.cloud.dialogflow.v2.EntityType.Entity result =
            new com.google.cloud.dialogflow.v2.EntityType.Entity(this);
        int from_bitField0_ = bitField0_;
        result.value_ = value_;
        if (((bitField0_ & 0x00000001) != 0)) {
          synonyms_ = synonyms_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.synonyms_ = synonyms_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.v2.EntityType.Entity) {
          return mergeFrom((com.google.cloud.dialogflow.v2.EntityType.Entity) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.v2.EntityType.Entity other) {
        if (other == com.google.cloud.dialogflow.v2.EntityType.Entity.getDefaultInstance())
          return this;
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          onChanged();
        }
        if (!other.synonyms_.isEmpty()) {
          if (synonyms_.isEmpty()) {
            synonyms_ = other.synonyms_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSynonymsIsMutable();
            synonyms_.addAll(other.synonyms_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.dialogflow.v2.EntityType.Entity parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.dialogflow.v2.EntityType.Entity) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object value_ = "";
      /**
       *
       *
       * <pre>
       * Required. The primary value associated with this entity entry.
       * For example, if the entity type is *vegetable*, the value could be
       * *scallions*.
       * For `KIND_MAP` entity types:
       * *   A reference value to be used in place of synonyms.
       * For `KIND_LIST` entity types:
       * *   A string that can contain references to other entity types (with or
       *     without aliases).
       * </pre>
       *
       * <code>string value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The primary value associated with this entity entry.
       * For example, if the entity type is *vegetable*, the value could be
       * *scallions*.
       * For `KIND_MAP` entity types:
       * *   A reference value to be used in place of synonyms.
       * For `KIND_LIST` entity types:
       * *   A string that can contain references to other entity types (with or
       *     without aliases).
       * </pre>
       *
       * <code>string value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The primary value associated with this entity entry.
       * For example, if the entity type is *vegetable*, the value could be
       * *scallions*.
       * For `KIND_MAP` entity types:
       * *   A reference value to be used in place of synonyms.
       * For `KIND_LIST` entity types:
       * *   A string that can contain references to other entity types (with or
       *     without aliases).
       * </pre>
       *
       * <code>string value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The primary value associated with this entity entry.
       * For example, if the entity type is *vegetable*, the value could be
       * *scallions*.
       * For `KIND_MAP` entity types:
       * *   A reference value to be used in place of synonyms.
       * For `KIND_LIST` entity types:
       * *   A string that can contain references to other entity types (with or
       *     without aliases).
       * </pre>
       *
       * <code>string value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {

        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The primary value associated with this entity entry.
       * For example, if the entity type is *vegetable*, the value could be
       * *scallions*.
       * For `KIND_MAP` entity types:
       * *   A reference value to be used in place of synonyms.
       * For `KIND_LIST` entity types:
       * *   A string that can contain references to other entity types (with or
       *     without aliases).
       * </pre>
       *
       * <code>string value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        value_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList synonyms_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureSynonymsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          synonyms_ = new com.google.protobuf.LazyStringArrayList(synonyms_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of value synonyms. For example, if the entity type
       * is *vegetable*, and `value` is *scallions*, a synonym could be *green
       * onions*.
       * For `KIND_LIST` entity types:
       * *   This collection must contain exactly one synonym equal to `value`.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the synonyms.
       */
      public com.google.protobuf.ProtocolStringList getSynonymsList() {
        return synonyms_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of value synonyms. For example, if the entity type
       * is *vegetable*, and `value` is *scallions*, a synonym could be *green
       * onions*.
       * For `KIND_LIST` entity types:
       * *   This collection must contain exactly one synonym equal to `value`.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of synonyms.
       */
      public int getSynonymsCount() {
        return synonyms_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of value synonyms. For example, if the entity type
       * is *vegetable*, and `value` is *scallions*, a synonym could be *green
       * onions*.
       * For `KIND_LIST` entity types:
       * *   This collection must contain exactly one synonym equal to `value`.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The synonyms at the given index.
       */
      public java.lang.String getSynonyms(int index) {
        return synonyms_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of value synonyms. For example, if the entity type
       * is *vegetable*, and `value` is *scallions*, a synonym could be *green
       * onions*.
       * For `KIND_LIST` entity types:
       * *   This collection must contain exactly one synonym equal to `value`.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the synonyms at the given index.
       */
      public com.google.protobuf.ByteString getSynonymsBytes(int index) {
        return synonyms_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of value synonyms. For example, if the entity type
       * is *vegetable*, and `value` is *scallions*, a synonym could be *green
       * onions*.
       * For `KIND_LIST` entity types:
       * *   This collection must contain exactly one synonym equal to `value`.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index to set the value at.
       * @param value The synonyms to set.
       * @return This builder for chaining.
       */
      public Builder setSynonyms(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSynonymsIsMutable();
        synonyms_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of value synonyms. For example, if the entity type
       * is *vegetable*, and `value` is *scallions*, a synonym could be *green
       * onions*.
       * For `KIND_LIST` entity types:
       * *   This collection must contain exactly one synonym equal to `value`.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The synonyms to add.
       * @return This builder for chaining.
       */
      public Builder addSynonyms(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSynonymsIsMutable();
        synonyms_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of value synonyms. For example, if the entity type
       * is *vegetable*, and `value` is *scallions*, a synonym could be *green
       * onions*.
       * For `KIND_LIST` entity types:
       * *   This collection must contain exactly one synonym equal to `value`.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param values The synonyms to add.
       * @return This builder for chaining.
       */
      public Builder addAllSynonyms(java.lang.Iterable<java.lang.String> values) {
        ensureSynonymsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, synonyms_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of value synonyms. For example, if the entity type
       * is *vegetable*, and `value` is *scallions*, a synonym could be *green
       * onions*.
       * For `KIND_LIST` entity types:
       * *   This collection must contain exactly one synonym equal to `value`.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSynonyms() {
        synonyms_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. A collection of value synonyms. For example, if the entity type
       * is *vegetable*, and `value` is *scallions*, a synonym could be *green
       * onions*.
       * For `KIND_LIST` entity types:
       * *   This collection must contain exactly one synonym equal to `value`.
       * </pre>
       *
       * <code>repeated string synonyms = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes of the synonyms to add.
       * @return This builder for chaining.
       */
      public Builder addSynonymsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureSynonymsIsMutable();
        synonyms_.add(value);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.EntityType.Entity)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.EntityType.Entity)
    private static final com.google.cloud.dialogflow.v2.EntityType.Entity DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.EntityType.Entity();
    }

    public static com.google.cloud.dialogflow.v2.EntityType.Entity getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Entity> PARSER =
        new com.google.protobuf.AbstractParser<Entity>() {
          @java.lang.Override
          public Entity parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Entity(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Entity> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Entity> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EntityType.Entity getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The unique identifier of the entity type.
   * Required for [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2.EntityTypes.UpdateEntityType] and
   * [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2.EntityTypes.BatchUpdateEntityTypes] methods.
   * Format: `projects/&lt;Project ID&gt;/agent/entityTypes/&lt;Entity Type ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the entity type.
   * Required for [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2.EntityTypes.UpdateEntityType] and
   * [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2.EntityTypes.BatchUpdateEntityTypes] methods.
   * Format: `projects/&lt;Project ID&gt;/agent/entityTypes/&lt;Entity Type ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. The name of the entity type.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the entity type.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KIND_FIELD_NUMBER = 3;
  private int kind_;
  /**
   *
   *
   * <pre>
   * Required. Indicates the kind of entity type.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.EntityType.Kind kind = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for kind.
   */
  @java.lang.Override
  public int getKindValue() {
    return kind_;
  }
  /**
   *
   *
   * <pre>
   * Required. Indicates the kind of entity type.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.EntityType.Kind kind = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EntityType.Kind getKind() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2.EntityType.Kind result =
        com.google.cloud.dialogflow.v2.EntityType.Kind.valueOf(kind_);
    return result == null ? com.google.cloud.dialogflow.v2.EntityType.Kind.UNRECOGNIZED : result;
  }

  public static final int AUTO_EXPANSION_MODE_FIELD_NUMBER = 4;
  private int autoExpansionMode_;
  /**
   *
   *
   * <pre>
   * Optional. Indicates whether the entity type can be automatically
   * expanded.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.EntityType.AutoExpansionMode auto_expansion_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for autoExpansionMode.
   */
  @java.lang.Override
  public int getAutoExpansionModeValue() {
    return autoExpansionMode_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Indicates whether the entity type can be automatically
   * expanded.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.EntityType.AutoExpansionMode auto_expansion_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The autoExpansionMode.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EntityType.AutoExpansionMode getAutoExpansionMode() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2.EntityType.AutoExpansionMode result =
        com.google.cloud.dialogflow.v2.EntityType.AutoExpansionMode.valueOf(autoExpansionMode_);
    return result == null
        ? com.google.cloud.dialogflow.v2.EntityType.AutoExpansionMode.UNRECOGNIZED
        : result;
  }

  public static final int ENTITIES_FIELD_NUMBER = 6;
  private java.util.List<com.google.cloud.dialogflow.v2.EntityType.Entity> entities_;
  /**
   *
   *
   * <pre>
   * Optional. The collection of entity entries associated with the entity type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2.EntityType.Entity> getEntitiesList() {
    return entities_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The collection of entity entries associated with the entity type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2.EntityType.EntityOrBuilder>
      getEntitiesOrBuilderList() {
    return entities_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The collection of entity entries associated with the entity type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getEntitiesCount() {
    return entities_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The collection of entity entries associated with the entity type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EntityType.Entity getEntities(int index) {
    return entities_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The collection of entity entries associated with the entity type.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EntityType.EntityOrBuilder getEntitiesOrBuilder(int index) {
    return entities_.get(index);
  }

  public static final int ENABLE_FUZZY_EXTRACTION_FIELD_NUMBER = 7;
  private boolean enableFuzzyExtraction_;
  /**
   *
   *
   * <pre>
   * Optional. Enables fuzzy entity extraction during classification.
   * </pre>
   *
   * <code>bool enable_fuzzy_extraction = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableFuzzyExtraction.
   */
  @java.lang.Override
  public boolean getEnableFuzzyExtraction() {
    return enableFuzzyExtraction_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (kind_ != com.google.cloud.dialogflow.v2.EntityType.Kind.KIND_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, kind_);
    }
    if (autoExpansionMode_
        != com.google.cloud.dialogflow.v2.EntityType.AutoExpansionMode
            .AUTO_EXPANSION_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, autoExpansionMode_);
    }
    for (int i = 0; i < entities_.size(); i++) {
      output.writeMessage(6, entities_.get(i));
    }
    if (enableFuzzyExtraction_ != false) {
      output.writeBool(7, enableFuzzyExtraction_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (kind_ != com.google.cloud.dialogflow.v2.EntityType.Kind.KIND_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, kind_);
    }
    if (autoExpansionMode_
        != com.google.cloud.dialogflow.v2.EntityType.AutoExpansionMode
            .AUTO_EXPANSION_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, autoExpansionMode_);
    }
    for (int i = 0; i < entities_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, entities_.get(i));
    }
    if (enableFuzzyExtraction_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, enableFuzzyExtraction_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.EntityType)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.EntityType other =
        (com.google.cloud.dialogflow.v2.EntityType) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (kind_ != other.kind_) return false;
    if (autoExpansionMode_ != other.autoExpansionMode_) return false;
    if (!getEntitiesList().equals(other.getEntitiesList())) return false;
    if (getEnableFuzzyExtraction() != other.getEnableFuzzyExtraction()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + KIND_FIELD_NUMBER;
    hash = (53 * hash) + kind_;
    hash = (37 * hash) + AUTO_EXPANSION_MODE_FIELD_NUMBER;
    hash = (53 * hash) + autoExpansionMode_;
    if (getEntitiesCount() > 0) {
      hash = (37 * hash) + ENTITIES_FIELD_NUMBER;
      hash = (53 * hash) + getEntitiesList().hashCode();
    }
    hash = (37 * hash) + ENABLE_FUZZY_EXTRACTION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableFuzzyExtraction());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.EntityType parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.EntityType parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.EntityType parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.EntityType parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.EntityType parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.EntityType parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.EntityType parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.EntityType parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.EntityType parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.EntityType parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.EntityType parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.EntityType parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2.EntityType prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Each intent parameter has a type, called the entity type, which dictates
   * exactly how data from an end-user expression is extracted.
   * Dialogflow provides predefined system entities that can match many common
   * types of data. For example, there are system entities for matching dates,
   * times, colors, email addresses, and so on. You can also create your own
   * custom entities for matching custom data. For example, you could define a
   * vegetable entity that can match the types of vegetables available for
   * purchase with a grocery store agent.
   * For more information, see the
   * [Entity guide](https://cloud.google.com/dialogflow/docs/entities-overview).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.EntityType}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.EntityType)
      com.google.cloud.dialogflow.v2.EntityTypeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.EntityTypeProto
          .internal_static_google_cloud_dialogflow_v2_EntityType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.EntityTypeProto
          .internal_static_google_cloud_dialogflow_v2_EntityType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.EntityType.class,
              com.google.cloud.dialogflow.v2.EntityType.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.EntityType.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEntitiesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      kind_ = 0;

      autoExpansionMode_ = 0;

      if (entitiesBuilder_ == null) {
        entities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        entitiesBuilder_.clear();
      }
      enableFuzzyExtraction_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.EntityTypeProto
          .internal_static_google_cloud_dialogflow_v2_EntityType_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EntityType getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.EntityType.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EntityType build() {
      com.google.cloud.dialogflow.v2.EntityType result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EntityType buildPartial() {
      com.google.cloud.dialogflow.v2.EntityType result =
          new com.google.cloud.dialogflow.v2.EntityType(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.kind_ = kind_;
      result.autoExpansionMode_ = autoExpansionMode_;
      if (entitiesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          entities_ = java.util.Collections.unmodifiableList(entities_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.entities_ = entities_;
      } else {
        result.entities_ = entitiesBuilder_.build();
      }
      result.enableFuzzyExtraction_ = enableFuzzyExtraction_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.EntityType) {
        return mergeFrom((com.google.cloud.dialogflow.v2.EntityType) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.EntityType other) {
      if (other == com.google.cloud.dialogflow.v2.EntityType.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.kind_ != 0) {
        setKindValue(other.getKindValue());
      }
      if (other.autoExpansionMode_ != 0) {
        setAutoExpansionModeValue(other.getAutoExpansionModeValue());
      }
      if (entitiesBuilder_ == null) {
        if (!other.entities_.isEmpty()) {
          if (entities_.isEmpty()) {
            entities_ = other.entities_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureEntitiesIsMutable();
            entities_.addAll(other.entities_);
          }
          onChanged();
        }
      } else {
        if (!other.entities_.isEmpty()) {
          if (entitiesBuilder_.isEmpty()) {
            entitiesBuilder_.dispose();
            entitiesBuilder_ = null;
            entities_ = other.entities_;
            bitField0_ = (bitField0_ & ~0x00000001);
            entitiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEntitiesFieldBuilder()
                    : null;
          } else {
            entitiesBuilder_.addAllMessages(other.entities_);
          }
        }
      }
      if (other.getEnableFuzzyExtraction() != false) {
        setEnableFuzzyExtraction(other.getEnableFuzzyExtraction());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2.EntityType parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.dialogflow.v2.EntityType) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the entity type.
     * Required for [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2.EntityTypes.UpdateEntityType] and
     * [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2.EntityTypes.BatchUpdateEntityTypes] methods.
     * Format: `projects/&lt;Project ID&gt;/agent/entityTypes/&lt;Entity Type ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the entity type.
     * Required for [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2.EntityTypes.UpdateEntityType] and
     * [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2.EntityTypes.BatchUpdateEntityTypes] methods.
     * Format: `projects/&lt;Project ID&gt;/agent/entityTypes/&lt;Entity Type ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the entity type.
     * Required for [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2.EntityTypes.UpdateEntityType] and
     * [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2.EntityTypes.BatchUpdateEntityTypes] methods.
     * Format: `projects/&lt;Project ID&gt;/agent/entityTypes/&lt;Entity Type ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the entity type.
     * Required for [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2.EntityTypes.UpdateEntityType] and
     * [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2.EntityTypes.BatchUpdateEntityTypes] methods.
     * Format: `projects/&lt;Project ID&gt;/agent/entityTypes/&lt;Entity Type ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the entity type.
     * Required for [EntityTypes.UpdateEntityType][google.cloud.dialogflow.v2.EntityTypes.UpdateEntityType] and
     * [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2.EntityTypes.BatchUpdateEntityTypes] methods.
     * Format: `projects/&lt;Project ID&gt;/agent/entityTypes/&lt;Entity Type ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the entity type.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the entity type.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the entity type.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the entity type.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the entity type.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private int kind_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Indicates the kind of entity type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EntityType.Kind kind = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for kind.
     */
    @java.lang.Override
    public int getKindValue() {
      return kind_;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the kind of entity type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EntityType.Kind kind = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindValue(int value) {

      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the kind of entity type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EntityType.Kind kind = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The kind.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EntityType.Kind getKind() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2.EntityType.Kind result =
          com.google.cloud.dialogflow.v2.EntityType.Kind.valueOf(kind_);
      return result == null ? com.google.cloud.dialogflow.v2.EntityType.Kind.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the kind of entity type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EntityType.Kind kind = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(com.google.cloud.dialogflow.v2.EntityType.Kind value) {
      if (value == null) {
        throw new NullPointerException();
      }

      kind_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Indicates the kind of entity type.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EntityType.Kind kind = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {

      kind_ = 0;
      onChanged();
      return this;
    }

    private int autoExpansionMode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the entity type can be automatically
     * expanded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EntityType.AutoExpansionMode auto_expansion_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for autoExpansionMode.
     */
    @java.lang.Override
    public int getAutoExpansionModeValue() {
      return autoExpansionMode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the entity type can be automatically
     * expanded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EntityType.AutoExpansionMode auto_expansion_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for autoExpansionMode to set.
     * @return This builder for chaining.
     */
    public Builder setAutoExpansionModeValue(int value) {

      autoExpansionMode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the entity type can be automatically
     * expanded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EntityType.AutoExpansionMode auto_expansion_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The autoExpansionMode.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.EntityType.AutoExpansionMode getAutoExpansionMode() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2.EntityType.AutoExpansionMode result =
          com.google.cloud.dialogflow.v2.EntityType.AutoExpansionMode.valueOf(autoExpansionMode_);
      return result == null
          ? com.google.cloud.dialogflow.v2.EntityType.AutoExpansionMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the entity type can be automatically
     * expanded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EntityType.AutoExpansionMode auto_expansion_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The autoExpansionMode to set.
     * @return This builder for chaining.
     */
    public Builder setAutoExpansionMode(
        com.google.cloud.dialogflow.v2.EntityType.AutoExpansionMode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      autoExpansionMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates whether the entity type can be automatically
     * expanded.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.EntityType.AutoExpansionMode auto_expansion_mode = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoExpansionMode() {

      autoExpansionMode_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.v2.EntityType.Entity> entities_ =
        java.util.Collections.emptyList();

    private void ensureEntitiesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        entities_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2.EntityType.Entity>(entities_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.EntityType.Entity,
            com.google.cloud.dialogflow.v2.EntityType.Entity.Builder,
            com.google.cloud.dialogflow.v2.EntityType.EntityOrBuilder>
        entitiesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.EntityType.Entity> getEntitiesList() {
      if (entitiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(entities_);
      } else {
        return entitiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getEntitiesCount() {
      if (entitiesBuilder_ == null) {
        return entities_.size();
      } else {
        return entitiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.EntityType.Entity getEntities(int index) {
      if (entitiesBuilder_ == null) {
        return entities_.get(index);
      } else {
        return entitiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEntities(int index, com.google.cloud.dialogflow.v2.EntityType.Entity value) {
      if (entitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntitiesIsMutable();
        entities_.set(index, value);
        onChanged();
      } else {
        entitiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEntities(
        int index, com.google.cloud.dialogflow.v2.EntityType.Entity.Builder builderForValue) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        entities_.set(index, builderForValue.build());
        onChanged();
      } else {
        entitiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addEntities(com.google.cloud.dialogflow.v2.EntityType.Entity value) {
      if (entitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntitiesIsMutable();
        entities_.add(value);
        onChanged();
      } else {
        entitiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addEntities(int index, com.google.cloud.dialogflow.v2.EntityType.Entity value) {
      if (entitiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntitiesIsMutable();
        entities_.add(index, value);
        onChanged();
      } else {
        entitiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addEntities(
        com.google.cloud.dialogflow.v2.EntityType.Entity.Builder builderForValue) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        entities_.add(builderForValue.build());
        onChanged();
      } else {
        entitiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addEntities(
        int index, com.google.cloud.dialogflow.v2.EntityType.Entity.Builder builderForValue) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        entities_.add(index, builderForValue.build());
        onChanged();
      } else {
        entitiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllEntities(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2.EntityType.Entity> values) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entities_);
        onChanged();
      } else {
        entitiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEntities() {
      if (entitiesBuilder_ == null) {
        entities_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        entitiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeEntities(int index) {
      if (entitiesBuilder_ == null) {
        ensureEntitiesIsMutable();
        entities_.remove(index);
        onChanged();
      } else {
        entitiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.EntityType.Entity.Builder getEntitiesBuilder(int index) {
      return getEntitiesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.EntityType.EntityOrBuilder getEntitiesOrBuilder(
        int index) {
      if (entitiesBuilder_ == null) {
        return entities_.get(index);
      } else {
        return entitiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2.EntityType.EntityOrBuilder>
        getEntitiesOrBuilderList() {
      if (entitiesBuilder_ != null) {
        return entitiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(entities_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.EntityType.Entity.Builder addEntitiesBuilder() {
      return getEntitiesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2.EntityType.Entity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.EntityType.Entity.Builder addEntitiesBuilder(int index) {
      return getEntitiesFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.v2.EntityType.Entity.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of entity entries associated with the entity type.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2.EntityType.Entity entities = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2.EntityType.Entity.Builder>
        getEntitiesBuilderList() {
      return getEntitiesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2.EntityType.Entity,
            com.google.cloud.dialogflow.v2.EntityType.Entity.Builder,
            com.google.cloud.dialogflow.v2.EntityType.EntityOrBuilder>
        getEntitiesFieldBuilder() {
      if (entitiesBuilder_ == null) {
        entitiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2.EntityType.Entity,
                com.google.cloud.dialogflow.v2.EntityType.Entity.Builder,
                com.google.cloud.dialogflow.v2.EntityType.EntityOrBuilder>(
                entities_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        entities_ = null;
      }
      return entitiesBuilder_;
    }

    private boolean enableFuzzyExtraction_;
    /**
     *
     *
     * <pre>
     * Optional. Enables fuzzy entity extraction during classification.
     * </pre>
     *
     * <code>bool enable_fuzzy_extraction = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableFuzzyExtraction.
     */
    @java.lang.Override
    public boolean getEnableFuzzyExtraction() {
      return enableFuzzyExtraction_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Enables fuzzy entity extraction during classification.
     * </pre>
     *
     * <code>bool enable_fuzzy_extraction = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableFuzzyExtraction to set.
     * @return This builder for chaining.
     */
    public Builder setEnableFuzzyExtraction(boolean value) {

      enableFuzzyExtraction_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Enables fuzzy entity extraction during classification.
     * </pre>
     *
     * <code>bool enable_fuzzy_extraction = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableFuzzyExtraction() {

      enableFuzzyExtraction_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.EntityType)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.EntityType)
  private static final com.google.cloud.dialogflow.v2.EntityType DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.EntityType();
  }

  public static com.google.cloud.dialogflow.v2.EntityType getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EntityType> PARSER =
      new com.google.protobuf.AbstractParser<EntityType>() {
        @java.lang.Override
        public EntityType parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new EntityType(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<EntityType> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EntityType> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.EntityType getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
