/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2/document.proto

package com.google.cloud.dialogflow.v2;

/**
 *
 *
 * <pre>
 * Request message for [Documents.ImportDocuments][google.cloud.dialogflow.v2.Documents.ImportDocuments].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2.ImportDocumentsRequest}
 */
public final class ImportDocumentsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2.ImportDocumentsRequest)
    ImportDocumentsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportDocumentsRequest.newBuilder() to construct.
  private ImportDocumentsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportDocumentsRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportDocumentsRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2.DocumentProto
        .internal_static_google_cloud_dialogflow_v2_ImportDocumentsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2.DocumentProto
        .internal_static_google_cloud_dialogflow_v2_ImportDocumentsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2.ImportDocumentsRequest.class,
            com.google.cloud.dialogflow.v2.ImportDocumentsRequest.Builder.class);
  }

  private int sourceCase_ = 0;
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_SOURCE(2),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return GCS_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. The knowledge base to import documents into.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The knowledge base to import documents into.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location for the documents.
   * The path can include a wildcard.
   * These URIs may have the forms
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   * `gs://&lt;bucket-name&gt;/&lt;object-path&gt;/&#42;.&lt;extension&gt;`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.GcsSources gcs_source = 2;</code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location for the documents.
   * The path can include a wildcard.
   * These URIs may have the forms
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   * `gs://&lt;bucket-name&gt;/&lt;object-path&gt;/&#42;.&lt;extension&gt;`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.GcsSources gcs_source = 2;</code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.GcsSources getGcsSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.dialogflow.v2.GcsSources) source_;
    }
    return com.google.cloud.dialogflow.v2.GcsSources.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The Google Cloud Storage location for the documents.
   * The path can include a wildcard.
   * These URIs may have the forms
   * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
   * `gs://&lt;bucket-name&gt;/&lt;object-path&gt;/&#42;.&lt;extension&gt;`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2.GcsSources gcs_source = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.GcsSourcesOrBuilder getGcsSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.dialogflow.v2.GcsSources) source_;
    }
    return com.google.cloud.dialogflow.v2.GcsSources.getDefaultInstance();
  }

  public static final int DOCUMENT_TEMPLATE_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.v2.ImportDocumentTemplate documentTemplate_;
  /**
   *
   *
   * <pre>
   * Required. Document template used for importing all the documents.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ImportDocumentTemplate document_template = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the documentTemplate field is set.
   */
  @java.lang.Override
  public boolean hasDocumentTemplate() {
    return documentTemplate_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Document template used for importing all the documents.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ImportDocumentTemplate document_template = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The documentTemplate.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ImportDocumentTemplate getDocumentTemplate() {
    return documentTemplate_ == null
        ? com.google.cloud.dialogflow.v2.ImportDocumentTemplate.getDefaultInstance()
        : documentTemplate_;
  }
  /**
   *
   *
   * <pre>
   * Required. Document template used for importing all the documents.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2.ImportDocumentTemplate document_template = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ImportDocumentTemplateOrBuilder
      getDocumentTemplateOrBuilder() {
    return getDocumentTemplate();
  }

  public static final int IMPORT_GCS_CUSTOM_METADATA_FIELD_NUMBER = 4;
  private boolean importGcsCustomMetadata_;
  /**
   *
   *
   * <pre>
   * Whether to import custom metadata from Google Cloud Storage.
   * Only valid when the document source is Google Cloud Storage URI.
   * </pre>
   *
   * <code>bool import_gcs_custom_metadata = 4;</code>
   *
   * @return The importGcsCustomMetadata.
   */
  @java.lang.Override
  public boolean getImportGcsCustomMetadata() {
    return importGcsCustomMetadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.dialogflow.v2.GcsSources) source_);
    }
    if (documentTemplate_ != null) {
      output.writeMessage(3, getDocumentTemplate());
    }
    if (importGcsCustomMetadata_ != false) {
      output.writeBool(4, importGcsCustomMetadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dialogflow.v2.GcsSources) source_);
    }
    if (documentTemplate_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDocumentTemplate());
    }
    if (importGcsCustomMetadata_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, importGcsCustomMetadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2.ImportDocumentsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2.ImportDocumentsRequest other =
        (com.google.cloud.dialogflow.v2.ImportDocumentsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasDocumentTemplate() != other.hasDocumentTemplate()) return false;
    if (hasDocumentTemplate()) {
      if (!getDocumentTemplate().equals(other.getDocumentTemplate())) return false;
    }
    if (getImportGcsCustomMetadata() != other.getImportGcsCustomMetadata()) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasDocumentTemplate()) {
      hash = (37 * hash) + DOCUMENT_TEMPLATE_FIELD_NUMBER;
      hash = (53 * hash) + getDocumentTemplate().hashCode();
    }
    hash = (37 * hash) + IMPORT_GCS_CUSTOM_METADATA_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getImportGcsCustomMetadata());
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2.ImportDocumentsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for [Documents.ImportDocuments][google.cloud.dialogflow.v2.Documents.ImportDocuments].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2.ImportDocumentsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2.ImportDocumentsRequest)
      com.google.cloud.dialogflow.v2.ImportDocumentsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2.DocumentProto
          .internal_static_google_cloud_dialogflow_v2_ImportDocumentsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2.DocumentProto
          .internal_static_google_cloud_dialogflow_v2_ImportDocumentsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2.ImportDocumentsRequest.class,
              com.google.cloud.dialogflow.v2.ImportDocumentsRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2.ImportDocumentsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      if (gcsSourceBuilder_ != null) {
        gcsSourceBuilder_.clear();
      }
      if (documentTemplateBuilder_ == null) {
        documentTemplate_ = null;
      } else {
        documentTemplate_ = null;
        documentTemplateBuilder_ = null;
      }
      importGcsCustomMetadata_ = false;

      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2.DocumentProto
          .internal_static_google_cloud_dialogflow_v2_ImportDocumentsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ImportDocumentsRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2.ImportDocumentsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ImportDocumentsRequest build() {
      com.google.cloud.dialogflow.v2.ImportDocumentsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2.ImportDocumentsRequest buildPartial() {
      com.google.cloud.dialogflow.v2.ImportDocumentsRequest result =
          new com.google.cloud.dialogflow.v2.ImportDocumentsRequest(this);
      result.parent_ = parent_;
      if (sourceCase_ == 2) {
        if (gcsSourceBuilder_ == null) {
          result.source_ = source_;
        } else {
          result.source_ = gcsSourceBuilder_.build();
        }
      }
      if (documentTemplateBuilder_ == null) {
        result.documentTemplate_ = documentTemplate_;
      } else {
        result.documentTemplate_ = documentTemplateBuilder_.build();
      }
      result.importGcsCustomMetadata_ = importGcsCustomMetadata_;
      result.sourceCase_ = sourceCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2.ImportDocumentsRequest) {
        return mergeFrom((com.google.cloud.dialogflow.v2.ImportDocumentsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2.ImportDocumentsRequest other) {
      if (other == com.google.cloud.dialogflow.v2.ImportDocumentsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (other.hasDocumentTemplate()) {
        mergeDocumentTemplate(other.getDocumentTemplate());
      }
      if (other.getImportGcsCustomMetadata() != false) {
        setImportGcsCustomMetadata(other.getImportGcsCustomMetadata());
      }
      switch (other.getSourceCase()) {
        case GCS_SOURCE:
          {
            mergeGcsSource(other.getGcsSource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getDocumentTemplateFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 32:
              {
                importGcsCustomMetadata_ = input.readBool();

                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The knowledge base to import documents into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge base to import documents into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge base to import documents into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge base to import documents into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The knowledge base to import documents into.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.GcsSources,
            com.google.cloud.dialogflow.v2.GcsSources.Builder,
            com.google.cloud.dialogflow.v2.GcsSourcesOrBuilder>
        gcsSourceBuilder_;
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the documents.
     * The path can include a wildcard.
     * These URIs may have the forms
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * `gs://&lt;bucket-name&gt;/&lt;object-path&gt;/&#42;.&lt;extension&gt;`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsSources gcs_source = 2;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the documents.
     * The path can include a wildcard.
     * These URIs may have the forms
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * `gs://&lt;bucket-name&gt;/&lt;object-path&gt;/&#42;.&lt;extension&gt;`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsSources gcs_source = 2;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.GcsSources getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.dialogflow.v2.GcsSources) source_;
        }
        return com.google.cloud.dialogflow.v2.GcsSources.getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return gcsSourceBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2.GcsSources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the documents.
     * The path can include a wildcard.
     * These URIs may have the forms
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * `gs://&lt;bucket-name&gt;/&lt;object-path&gt;/&#42;.&lt;extension&gt;`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsSources gcs_source = 2;</code>
     */
    public Builder setGcsSource(com.google.cloud.dialogflow.v2.GcsSources value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the documents.
     * The path can include a wildcard.
     * These URIs may have the forms
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * `gs://&lt;bucket-name&gt;/&lt;object-path&gt;/&#42;.&lt;extension&gt;`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsSources gcs_source = 2;</code>
     */
    public Builder setGcsSource(com.google.cloud.dialogflow.v2.GcsSources.Builder builderForValue) {
      if (gcsSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the documents.
     * The path can include a wildcard.
     * These URIs may have the forms
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * `gs://&lt;bucket-name&gt;/&lt;object-path&gt;/&#42;.&lt;extension&gt;`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsSources gcs_source = 2;</code>
     */
    public Builder mergeGcsSource(com.google.cloud.dialogflow.v2.GcsSources value) {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_ != com.google.cloud.dialogflow.v2.GcsSources.getDefaultInstance()) {
          source_ =
              com.google.cloud.dialogflow.v2.GcsSources.newBuilder(
                      (com.google.cloud.dialogflow.v2.GcsSources) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          gcsSourceBuilder_.mergeFrom(value);
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the documents.
     * The path can include a wildcard.
     * These URIs may have the forms
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * `gs://&lt;bucket-name&gt;/&lt;object-path&gt;/&#42;.&lt;extension&gt;`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsSources gcs_source = 2;</code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        gcsSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the documents.
     * The path can include a wildcard.
     * These URIs may have the forms
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * `gs://&lt;bucket-name&gt;/&lt;object-path&gt;/&#42;.&lt;extension&gt;`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsSources gcs_source = 2;</code>
     */
    public com.google.cloud.dialogflow.v2.GcsSources.Builder getGcsSourceBuilder() {
      return getGcsSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the documents.
     * The path can include a wildcard.
     * These URIs may have the forms
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * `gs://&lt;bucket-name&gt;/&lt;object-path&gt;/&#42;.&lt;extension&gt;`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsSources gcs_source = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2.GcsSourcesOrBuilder getGcsSourceOrBuilder() {
      if ((sourceCase_ == 2) && (gcsSourceBuilder_ != null)) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.dialogflow.v2.GcsSources) source_;
        }
        return com.google.cloud.dialogflow.v2.GcsSources.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The Google Cloud Storage location for the documents.
     * The path can include a wildcard.
     * These URIs may have the forms
     * `gs://&lt;bucket-name&gt;/&lt;object-name&gt;`.
     * `gs://&lt;bucket-name&gt;/&lt;object-path&gt;/&#42;.&lt;extension&gt;`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2.GcsSources gcs_source = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.GcsSources,
            com.google.cloud.dialogflow.v2.GcsSources.Builder,
            com.google.cloud.dialogflow.v2.GcsSourcesOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ = com.google.cloud.dialogflow.v2.GcsSources.getDefaultInstance();
        }
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.GcsSources,
                com.google.cloud.dialogflow.v2.GcsSources.Builder,
                com.google.cloud.dialogflow.v2.GcsSourcesOrBuilder>(
                (com.google.cloud.dialogflow.v2.GcsSources) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      ;
      return gcsSourceBuilder_;
    }

    private com.google.cloud.dialogflow.v2.ImportDocumentTemplate documentTemplate_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.ImportDocumentTemplate,
            com.google.cloud.dialogflow.v2.ImportDocumentTemplate.Builder,
            com.google.cloud.dialogflow.v2.ImportDocumentTemplateOrBuilder>
        documentTemplateBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Document template used for importing all the documents.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ImportDocumentTemplate document_template = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the documentTemplate field is set.
     */
    public boolean hasDocumentTemplate() {
      return documentTemplateBuilder_ != null || documentTemplate_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Document template used for importing all the documents.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ImportDocumentTemplate document_template = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The documentTemplate.
     */
    public com.google.cloud.dialogflow.v2.ImportDocumentTemplate getDocumentTemplate() {
      if (documentTemplateBuilder_ == null) {
        return documentTemplate_ == null
            ? com.google.cloud.dialogflow.v2.ImportDocumentTemplate.getDefaultInstance()
            : documentTemplate_;
      } else {
        return documentTemplateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Document template used for importing all the documents.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ImportDocumentTemplate document_template = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDocumentTemplate(
        com.google.cloud.dialogflow.v2.ImportDocumentTemplate value) {
      if (documentTemplateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        documentTemplate_ = value;
        onChanged();
      } else {
        documentTemplateBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Document template used for importing all the documents.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ImportDocumentTemplate document_template = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDocumentTemplate(
        com.google.cloud.dialogflow.v2.ImportDocumentTemplate.Builder builderForValue) {
      if (documentTemplateBuilder_ == null) {
        documentTemplate_ = builderForValue.build();
        onChanged();
      } else {
        documentTemplateBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Document template used for importing all the documents.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ImportDocumentTemplate document_template = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDocumentTemplate(
        com.google.cloud.dialogflow.v2.ImportDocumentTemplate value) {
      if (documentTemplateBuilder_ == null) {
        if (documentTemplate_ != null) {
          documentTemplate_ =
              com.google.cloud.dialogflow.v2.ImportDocumentTemplate.newBuilder(documentTemplate_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          documentTemplate_ = value;
        }
        onChanged();
      } else {
        documentTemplateBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Document template used for importing all the documents.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ImportDocumentTemplate document_template = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDocumentTemplate() {
      if (documentTemplateBuilder_ == null) {
        documentTemplate_ = null;
        onChanged();
      } else {
        documentTemplate_ = null;
        documentTemplateBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Document template used for importing all the documents.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ImportDocumentTemplate document_template = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.ImportDocumentTemplate.Builder
        getDocumentTemplateBuilder() {

      onChanged();
      return getDocumentTemplateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Document template used for importing all the documents.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ImportDocumentTemplate document_template = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dialogflow.v2.ImportDocumentTemplateOrBuilder
        getDocumentTemplateOrBuilder() {
      if (documentTemplateBuilder_ != null) {
        return documentTemplateBuilder_.getMessageOrBuilder();
      } else {
        return documentTemplate_ == null
            ? com.google.cloud.dialogflow.v2.ImportDocumentTemplate.getDefaultInstance()
            : documentTemplate_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Document template used for importing all the documents.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2.ImportDocumentTemplate document_template = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2.ImportDocumentTemplate,
            com.google.cloud.dialogflow.v2.ImportDocumentTemplate.Builder,
            com.google.cloud.dialogflow.v2.ImportDocumentTemplateOrBuilder>
        getDocumentTemplateFieldBuilder() {
      if (documentTemplateBuilder_ == null) {
        documentTemplateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2.ImportDocumentTemplate,
                com.google.cloud.dialogflow.v2.ImportDocumentTemplate.Builder,
                com.google.cloud.dialogflow.v2.ImportDocumentTemplateOrBuilder>(
                getDocumentTemplate(), getParentForChildren(), isClean());
        documentTemplate_ = null;
      }
      return documentTemplateBuilder_;
    }

    private boolean importGcsCustomMetadata_;
    /**
     *
     *
     * <pre>
     * Whether to import custom metadata from Google Cloud Storage.
     * Only valid when the document source is Google Cloud Storage URI.
     * </pre>
     *
     * <code>bool import_gcs_custom_metadata = 4;</code>
     *
     * @return The importGcsCustomMetadata.
     */
    @java.lang.Override
    public boolean getImportGcsCustomMetadata() {
      return importGcsCustomMetadata_;
    }
    /**
     *
     *
     * <pre>
     * Whether to import custom metadata from Google Cloud Storage.
     * Only valid when the document source is Google Cloud Storage URI.
     * </pre>
     *
     * <code>bool import_gcs_custom_metadata = 4;</code>
     *
     * @param value The importGcsCustomMetadata to set.
     * @return This builder for chaining.
     */
    public Builder setImportGcsCustomMetadata(boolean value) {

      importGcsCustomMetadata_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to import custom metadata from Google Cloud Storage.
     * Only valid when the document source is Google Cloud Storage URI.
     * </pre>
     *
     * <code>bool import_gcs_custom_metadata = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImportGcsCustomMetadata() {

      importGcsCustomMetadata_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2.ImportDocumentsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2.ImportDocumentsRequest)
  private static final com.google.cloud.dialogflow.v2.ImportDocumentsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2.ImportDocumentsRequest();
  }

  public static com.google.cloud.dialogflow.v2.ImportDocumentsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportDocumentsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportDocumentsRequest>() {
        @java.lang.Override
        public ImportDocumentsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportDocumentsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportDocumentsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2.ImportDocumentsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
