/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.cloud.dialogflow.v2beta1.ProjectAgentNameType;
import com.google.common.base.Preconditions;
import java.util.Map;

public class ProjectAgentName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent");
    private final String project;

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectAgentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public static ProjectAgentName of(String project) {
        return ProjectAgentName.newBuilder().setProject(project).build();
    }

    @Deprecated
    public static ProjectAgentName create(String project) {
        return ProjectAgentName.of(project);
    }

    public static ProjectAgentName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectAgentName.parse: formattedString not in valid format");
        return ProjectAgentName.of((String)matchMap.get("project"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return ProjectAgentNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectAgentName) {
            ProjectAgentName that = (ProjectAgentName)o;
            return this.project.equals(that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.project.hashCode();
    }

    public static class Builder {
        private String project;

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder() {
        }

        private Builder(ProjectAgentName projectAgentName) {
            this.project = projectAgentName.project;
        }

        public ProjectAgentName build() {
            return new ProjectAgentName(this);
        }
    }
}

