/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/session.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents the result of querying a Knowledge base.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.KnowledgeAnswers}
 */
public final class KnowledgeAnswers extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.KnowledgeAnswers)
    KnowledgeAnswersOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KnowledgeAnswers.newBuilder() to construct.
  private KnowledgeAnswers(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KnowledgeAnswers() {
    answers_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KnowledgeAnswers();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private KnowledgeAnswers(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                answers_ =
                    new java.util.ArrayList<
                        com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer>();
                mutable_bitField0_ |= 0x00000001;
              }
              answers_.add(
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.parser(),
                      extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        answers_ = java.util.Collections.unmodifiableList(answers_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.SessionProto
        .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeAnswers_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.SessionProto
        .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeAnswers_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.class,
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Builder.class);
  }

  public interface AnswerOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Indicates which Knowledge Document this answer was extracted from.
     * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
     * ID&gt;/documents/&lt;Document ID&gt;`.
     * </pre>
     *
     * <code>string source = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The source.
     */
    java.lang.String getSource();
    /**
     *
     *
     * <pre>
     * Indicates which Knowledge Document this answer was extracted from.
     * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
     * ID&gt;/documents/&lt;Document ID&gt;`.
     * </pre>
     *
     * <code>string source = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for source.
     */
    com.google.protobuf.ByteString getSourceBytes();

    /**
     *
     *
     * <pre>
     * The corresponding FAQ question if the answer was extracted from a FAQ
     * Document, empty otherwise.
     * </pre>
     *
     * <code>string faq_question = 2;</code>
     *
     * @return The faqQuestion.
     */
    java.lang.String getFaqQuestion();
    /**
     *
     *
     * <pre>
     * The corresponding FAQ question if the answer was extracted from a FAQ
     * Document, empty otherwise.
     * </pre>
     *
     * <code>string faq_question = 2;</code>
     *
     * @return The bytes for faqQuestion.
     */
    com.google.protobuf.ByteString getFaqQuestionBytes();

    /**
     *
     *
     * <pre>
     * The piece of text from the `source` knowledge base document that answers
     * this conversational query.
     * </pre>
     *
     * <code>string answer = 3;</code>
     *
     * @return The answer.
     */
    java.lang.String getAnswer();
    /**
     *
     *
     * <pre>
     * The piece of text from the `source` knowledge base document that answers
     * this conversational query.
     * </pre>
     *
     * <code>string answer = 3;</code>
     *
     * @return The bytes for answer.
     */
    com.google.protobuf.ByteString getAnswerBytes();

    /**
     *
     *
     * <pre>
     * The system's confidence level that this knowledge answer is a good match
     * for this conversational query.
     * NOTE: The confidence level for a given `&lt;query, answer&gt;` pair may change
     * without notice, as it depends on models that are constantly being
     * improved. However, it will change less frequently than the confidence
     * score below, and should be preferred for referencing the quality of an
     * answer.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel match_confidence_level = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for matchConfidenceLevel.
     */
    int getMatchConfidenceLevelValue();
    /**
     *
     *
     * <pre>
     * The system's confidence level that this knowledge answer is a good match
     * for this conversational query.
     * NOTE: The confidence level for a given `&lt;query, answer&gt;` pair may change
     * without notice, as it depends on models that are constantly being
     * improved. However, it will change less frequently than the confidence
     * score below, and should be preferred for referencing the quality of an
     * answer.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel match_confidence_level = 4;
     * </code>
     *
     * @return The matchConfidenceLevel.
     */
    com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel
        getMatchConfidenceLevel();

    /**
     *
     *
     * <pre>
     * The system's confidence score that this Knowledge answer is a good match
     * for this conversational query.
     * The range is from 0.0 (completely uncertain) to 1.0 (completely certain).
     * Note: The confidence score is likely to vary somewhat (possibly even for
     * identical requests), as the underlying model is under constant
     * improvement. It may be deprecated in the future. We recommend using
     * `match_confidence_level` which should be generally more stable.
     * </pre>
     *
     * <code>float match_confidence = 5;</code>
     *
     * @return The matchConfidence.
     */
    float getMatchConfidence();
  }
  /**
   *
   *
   * <pre>
   * An answer from Knowledge Connector.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer}
   */
  public static final class Answer extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer)
      AnswerOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Answer.newBuilder() to construct.
    private Answer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Answer() {
      source_ = "";
      faqQuestion_ = "";
      answer_ = "";
      matchConfidenceLevel_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Answer();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Answer(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                source_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                faqQuestion_ = s;
                break;
              }
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();

                answer_ = s;
                break;
              }
            case 32:
              {
                int rawValue = input.readEnum();

                matchConfidenceLevel_ = rawValue;
                break;
              }
            case 45:
              {
                matchConfidence_ = input.readFloat();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeAnswers_Answer_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeAnswers_Answer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.class,
              com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Represents the system's confidence that this knowledge answer is a good
     * match for this conversational query.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel}
     */
    public enum MatchConfidenceLevel implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Not specified.
       * </pre>
       *
       * <code>MATCH_CONFIDENCE_LEVEL_UNSPECIFIED = 0;</code>
       */
      MATCH_CONFIDENCE_LEVEL_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Indicates that the confidence is low.
       * </pre>
       *
       * <code>LOW = 1;</code>
       */
      LOW(1),
      /**
       *
       *
       * <pre>
       * Indicates our confidence is medium.
       * </pre>
       *
       * <code>MEDIUM = 2;</code>
       */
      MEDIUM(2),
      /**
       *
       *
       * <pre>
       * Indicates our confidence is high.
       * </pre>
       *
       * <code>HIGH = 3;</code>
       */
      HIGH(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Not specified.
       * </pre>
       *
       * <code>MATCH_CONFIDENCE_LEVEL_UNSPECIFIED = 0;</code>
       */
      public static final int MATCH_CONFIDENCE_LEVEL_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Indicates that the confidence is low.
       * </pre>
       *
       * <code>LOW = 1;</code>
       */
      public static final int LOW_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Indicates our confidence is medium.
       * </pre>
       *
       * <code>MEDIUM = 2;</code>
       */
      public static final int MEDIUM_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Indicates our confidence is high.
       * </pre>
       *
       * <code>HIGH = 3;</code>
       */
      public static final int HIGH_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static MatchConfidenceLevel valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static MatchConfidenceLevel forNumber(int value) {
        switch (value) {
          case 0:
            return MATCH_CONFIDENCE_LEVEL_UNSPECIFIED;
          case 1:
            return LOW;
          case 2:
            return MEDIUM;
          case 3:
            return HIGH;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<MatchConfidenceLevel>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<MatchConfidenceLevel>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<MatchConfidenceLevel>() {
                public MatchConfidenceLevel findValueByNumber(int number) {
                  return MatchConfidenceLevel.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final MatchConfidenceLevel[] VALUES = values();

      public static MatchConfidenceLevel valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private MatchConfidenceLevel(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel)
    }

    public static final int SOURCE_FIELD_NUMBER = 1;
    private volatile java.lang.Object source_;
    /**
     *
     *
     * <pre>
     * Indicates which Knowledge Document this answer was extracted from.
     * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
     * ID&gt;/documents/&lt;Document ID&gt;`.
     * </pre>
     *
     * <code>string source = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The source.
     */
    @java.lang.Override
    public java.lang.String getSource() {
      java.lang.Object ref = source_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        source_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Indicates which Knowledge Document this answer was extracted from.
     * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
     * ID&gt;/documents/&lt;Document ID&gt;`.
     * </pre>
     *
     * <code>string source = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for source.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceBytes() {
      java.lang.Object ref = source_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        source_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FAQ_QUESTION_FIELD_NUMBER = 2;
    private volatile java.lang.Object faqQuestion_;
    /**
     *
     *
     * <pre>
     * The corresponding FAQ question if the answer was extracted from a FAQ
     * Document, empty otherwise.
     * </pre>
     *
     * <code>string faq_question = 2;</code>
     *
     * @return The faqQuestion.
     */
    @java.lang.Override
    public java.lang.String getFaqQuestion() {
      java.lang.Object ref = faqQuestion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        faqQuestion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The corresponding FAQ question if the answer was extracted from a FAQ
     * Document, empty otherwise.
     * </pre>
     *
     * <code>string faq_question = 2;</code>
     *
     * @return The bytes for faqQuestion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFaqQuestionBytes() {
      java.lang.Object ref = faqQuestion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        faqQuestion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ANSWER_FIELD_NUMBER = 3;
    private volatile java.lang.Object answer_;
    /**
     *
     *
     * <pre>
     * The piece of text from the `source` knowledge base document that answers
     * this conversational query.
     * </pre>
     *
     * <code>string answer = 3;</code>
     *
     * @return The answer.
     */
    @java.lang.Override
    public java.lang.String getAnswer() {
      java.lang.Object ref = answer_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answer_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The piece of text from the `source` knowledge base document that answers
     * this conversational query.
     * </pre>
     *
     * <code>string answer = 3;</code>
     *
     * @return The bytes for answer.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAnswerBytes() {
      java.lang.Object ref = answer_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MATCH_CONFIDENCE_LEVEL_FIELD_NUMBER = 4;
    private int matchConfidenceLevel_;
    /**
     *
     *
     * <pre>
     * The system's confidence level that this knowledge answer is a good match
     * for this conversational query.
     * NOTE: The confidence level for a given `&lt;query, answer&gt;` pair may change
     * without notice, as it depends on models that are constantly being
     * improved. However, it will change less frequently than the confidence
     * score below, and should be preferred for referencing the quality of an
     * answer.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel match_confidence_level = 4;
     * </code>
     *
     * @return The enum numeric value on the wire for matchConfidenceLevel.
     */
    @java.lang.Override
    public int getMatchConfidenceLevelValue() {
      return matchConfidenceLevel_;
    }
    /**
     *
     *
     * <pre>
     * The system's confidence level that this knowledge answer is a good match
     * for this conversational query.
     * NOTE: The confidence level for a given `&lt;query, answer&gt;` pair may change
     * without notice, as it depends on models that are constantly being
     * improved. However, it will change less frequently than the confidence
     * score below, and should be preferred for referencing the quality of an
     * answer.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel match_confidence_level = 4;
     * </code>
     *
     * @return The matchConfidenceLevel.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel
        getMatchConfidenceLevel() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel result =
          com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel.valueOf(
              matchConfidenceLevel_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel
              .UNRECOGNIZED
          : result;
    }

    public static final int MATCH_CONFIDENCE_FIELD_NUMBER = 5;
    private float matchConfidence_;
    /**
     *
     *
     * <pre>
     * The system's confidence score that this Knowledge answer is a good match
     * for this conversational query.
     * The range is from 0.0 (completely uncertain) to 1.0 (completely certain).
     * Note: The confidence score is likely to vary somewhat (possibly even for
     * identical requests), as the underlying model is under constant
     * improvement. It may be deprecated in the future. We recommend using
     * `match_confidence_level` which should be generally more stable.
     * </pre>
     *
     * <code>float match_confidence = 5;</code>
     *
     * @return The matchConfidence.
     */
    @java.lang.Override
    public float getMatchConfidence() {
      return matchConfidence_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, source_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(faqQuestion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, faqQuestion_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answer_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, answer_);
      }
      if (matchConfidenceLevel_
          != com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel
              .MATCH_CONFIDENCE_LEVEL_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, matchConfidenceLevel_);
      }
      if (matchConfidence_ != 0F) {
        output.writeFloat(5, matchConfidence_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, source_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(faqQuestion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, faqQuestion_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answer_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, answer_);
      }
      if (matchConfidenceLevel_
          != com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel
              .MATCH_CONFIDENCE_LEVEL_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, matchConfidenceLevel_);
      }
      if (matchConfidence_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, matchConfidence_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer other =
          (com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer) obj;

      if (!getSource().equals(other.getSource())) return false;
      if (!getFaqQuestion().equals(other.getFaqQuestion())) return false;
      if (!getAnswer().equals(other.getAnswer())) return false;
      if (matchConfidenceLevel_ != other.matchConfidenceLevel_) return false;
      if (java.lang.Float.floatToIntBits(getMatchConfidence())
          != java.lang.Float.floatToIntBits(other.getMatchConfidence())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getSource().hashCode();
      hash = (37 * hash) + FAQ_QUESTION_FIELD_NUMBER;
      hash = (53 * hash) + getFaqQuestion().hashCode();
      hash = (37 * hash) + ANSWER_FIELD_NUMBER;
      hash = (53 * hash) + getAnswer().hashCode();
      hash = (37 * hash) + MATCH_CONFIDENCE_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + matchConfidenceLevel_;
      hash = (37 * hash) + MATCH_CONFIDENCE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getMatchConfidence());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An answer from Knowledge Connector.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer)
        com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.AnswerOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.SessionProto
            .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeAnswers_Answer_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.SessionProto
            .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeAnswers_Answer_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.class,
                com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        source_ = "";

        faqQuestion_ = "";

        answer_ = "";

        matchConfidenceLevel_ = 0;

        matchConfidence_ = 0F;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.SessionProto
            .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeAnswers_Answer_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer build() {
        com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer buildPartial() {
        com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer result =
            new com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer(this);
        result.source_ = source_;
        result.faqQuestion_ = faqQuestion_;
        result.answer_ = answer_;
        result.matchConfidenceLevel_ = matchConfidenceLevel_;
        result.matchConfidence_ = matchConfidence_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer) {
          return mergeFrom((com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.getDefaultInstance())
          return this;
        if (!other.getSource().isEmpty()) {
          source_ = other.source_;
          onChanged();
        }
        if (!other.getFaqQuestion().isEmpty()) {
          faqQuestion_ = other.faqQuestion_;
          onChanged();
        }
        if (!other.getAnswer().isEmpty()) {
          answer_ = other.answer_;
          onChanged();
        }
        if (other.matchConfidenceLevel_ != 0) {
          setMatchConfidenceLevelValue(other.getMatchConfidenceLevelValue());
        }
        if (other.getMatchConfidence() != 0F) {
          setMatchConfidence(other.getMatchConfidence());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object source_ = "";
      /**
       *
       *
       * <pre>
       * Indicates which Knowledge Document this answer was extracted from.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`.
       * </pre>
       *
       * <code>string source = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The source.
       */
      public java.lang.String getSource() {
        java.lang.Object ref = source_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          source_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Indicates which Knowledge Document this answer was extracted from.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`.
       * </pre>
       *
       * <code>string source = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for source.
       */
      public com.google.protobuf.ByteString getSourceBytes() {
        java.lang.Object ref = source_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          source_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Indicates which Knowledge Document this answer was extracted from.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`.
       * </pre>
       *
       * <code>string source = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The source to set.
       * @return This builder for chaining.
       */
      public Builder setSource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        source_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates which Knowledge Document this answer was extracted from.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`.
       * </pre>
       *
       * <code>string source = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSource() {

        source_ = getDefaultInstance().getSource();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates which Knowledge Document this answer was extracted from.
       * Format: `projects/&lt;Project ID&gt;/knowledgeBases/&lt;Knowledge Base
       * ID&gt;/documents/&lt;Document ID&gt;`.
       * </pre>
       *
       * <code>string source = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for source to set.
       * @return This builder for chaining.
       */
      public Builder setSourceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        source_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object faqQuestion_ = "";
      /**
       *
       *
       * <pre>
       * The corresponding FAQ question if the answer was extracted from a FAQ
       * Document, empty otherwise.
       * </pre>
       *
       * <code>string faq_question = 2;</code>
       *
       * @return The faqQuestion.
       */
      public java.lang.String getFaqQuestion() {
        java.lang.Object ref = faqQuestion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          faqQuestion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The corresponding FAQ question if the answer was extracted from a FAQ
       * Document, empty otherwise.
       * </pre>
       *
       * <code>string faq_question = 2;</code>
       *
       * @return The bytes for faqQuestion.
       */
      public com.google.protobuf.ByteString getFaqQuestionBytes() {
        java.lang.Object ref = faqQuestion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          faqQuestion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The corresponding FAQ question if the answer was extracted from a FAQ
       * Document, empty otherwise.
       * </pre>
       *
       * <code>string faq_question = 2;</code>
       *
       * @param value The faqQuestion to set.
       * @return This builder for chaining.
       */
      public Builder setFaqQuestion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        faqQuestion_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The corresponding FAQ question if the answer was extracted from a FAQ
       * Document, empty otherwise.
       * </pre>
       *
       * <code>string faq_question = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFaqQuestion() {

        faqQuestion_ = getDefaultInstance().getFaqQuestion();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The corresponding FAQ question if the answer was extracted from a FAQ
       * Document, empty otherwise.
       * </pre>
       *
       * <code>string faq_question = 2;</code>
       *
       * @param value The bytes for faqQuestion to set.
       * @return This builder for chaining.
       */
      public Builder setFaqQuestionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        faqQuestion_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object answer_ = "";
      /**
       *
       *
       * <pre>
       * The piece of text from the `source` knowledge base document that answers
       * this conversational query.
       * </pre>
       *
       * <code>string answer = 3;</code>
       *
       * @return The answer.
       */
      public java.lang.String getAnswer() {
        java.lang.Object ref = answer_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          answer_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The piece of text from the `source` knowledge base document that answers
       * this conversational query.
       * </pre>
       *
       * <code>string answer = 3;</code>
       *
       * @return The bytes for answer.
       */
      public com.google.protobuf.ByteString getAnswerBytes() {
        java.lang.Object ref = answer_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          answer_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The piece of text from the `source` knowledge base document that answers
       * this conversational query.
       * </pre>
       *
       * <code>string answer = 3;</code>
       *
       * @param value The answer to set.
       * @return This builder for chaining.
       */
      public Builder setAnswer(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        answer_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The piece of text from the `source` knowledge base document that answers
       * this conversational query.
       * </pre>
       *
       * <code>string answer = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAnswer() {

        answer_ = getDefaultInstance().getAnswer();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The piece of text from the `source` knowledge base document that answers
       * this conversational query.
       * </pre>
       *
       * <code>string answer = 3;</code>
       *
       * @param value The bytes for answer to set.
       * @return This builder for chaining.
       */
      public Builder setAnswerBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        answer_ = value;
        onChanged();
        return this;
      }

      private int matchConfidenceLevel_ = 0;
      /**
       *
       *
       * <pre>
       * The system's confidence level that this knowledge answer is a good match
       * for this conversational query.
       * NOTE: The confidence level for a given `&lt;query, answer&gt;` pair may change
       * without notice, as it depends on models that are constantly being
       * improved. However, it will change less frequently than the confidence
       * score below, and should be preferred for referencing the quality of an
       * answer.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel match_confidence_level = 4;
       * </code>
       *
       * @return The enum numeric value on the wire for matchConfidenceLevel.
       */
      @java.lang.Override
      public int getMatchConfidenceLevelValue() {
        return matchConfidenceLevel_;
      }
      /**
       *
       *
       * <pre>
       * The system's confidence level that this knowledge answer is a good match
       * for this conversational query.
       * NOTE: The confidence level for a given `&lt;query, answer&gt;` pair may change
       * without notice, as it depends on models that are constantly being
       * improved. However, it will change less frequently than the confidence
       * score below, and should be preferred for referencing the quality of an
       * answer.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel match_confidence_level = 4;
       * </code>
       *
       * @param value The enum numeric value on the wire for matchConfidenceLevel to set.
       * @return This builder for chaining.
       */
      public Builder setMatchConfidenceLevelValue(int value) {

        matchConfidenceLevel_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The system's confidence level that this knowledge answer is a good match
       * for this conversational query.
       * NOTE: The confidence level for a given `&lt;query, answer&gt;` pair may change
       * without notice, as it depends on models that are constantly being
       * improved. However, it will change less frequently than the confidence
       * score below, and should be preferred for referencing the quality of an
       * answer.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel match_confidence_level = 4;
       * </code>
       *
       * @return The matchConfidenceLevel.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel
          getMatchConfidenceLevel() {
        @SuppressWarnings("deprecation")
        com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel result =
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel
                .valueOf(matchConfidenceLevel_);
        return result == null
            ? com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The system's confidence level that this knowledge answer is a good match
       * for this conversational query.
       * NOTE: The confidence level for a given `&lt;query, answer&gt;` pair may change
       * without notice, as it depends on models that are constantly being
       * improved. However, it will change less frequently than the confidence
       * score below, and should be preferred for referencing the quality of an
       * answer.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel match_confidence_level = 4;
       * </code>
       *
       * @param value The matchConfidenceLevel to set.
       * @return This builder for chaining.
       */
      public Builder setMatchConfidenceLevel(
          com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel value) {
        if (value == null) {
          throw new NullPointerException();
        }

        matchConfidenceLevel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The system's confidence level that this knowledge answer is a good match
       * for this conversational query.
       * NOTE: The confidence level for a given `&lt;query, answer&gt;` pair may change
       * without notice, as it depends on models that are constantly being
       * improved. However, it will change less frequently than the confidence
       * score below, and should be preferred for referencing the quality of an
       * answer.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.MatchConfidenceLevel match_confidence_level = 4;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMatchConfidenceLevel() {

        matchConfidenceLevel_ = 0;
        onChanged();
        return this;
      }

      private float matchConfidence_;
      /**
       *
       *
       * <pre>
       * The system's confidence score that this Knowledge answer is a good match
       * for this conversational query.
       * The range is from 0.0 (completely uncertain) to 1.0 (completely certain).
       * Note: The confidence score is likely to vary somewhat (possibly even for
       * identical requests), as the underlying model is under constant
       * improvement. It may be deprecated in the future. We recommend using
       * `match_confidence_level` which should be generally more stable.
       * </pre>
       *
       * <code>float match_confidence = 5;</code>
       *
       * @return The matchConfidence.
       */
      @java.lang.Override
      public float getMatchConfidence() {
        return matchConfidence_;
      }
      /**
       *
       *
       * <pre>
       * The system's confidence score that this Knowledge answer is a good match
       * for this conversational query.
       * The range is from 0.0 (completely uncertain) to 1.0 (completely certain).
       * Note: The confidence score is likely to vary somewhat (possibly even for
       * identical requests), as the underlying model is under constant
       * improvement. It may be deprecated in the future. We recommend using
       * `match_confidence_level` which should be generally more stable.
       * </pre>
       *
       * <code>float match_confidence = 5;</code>
       *
       * @param value The matchConfidence to set.
       * @return This builder for chaining.
       */
      public Builder setMatchConfidence(float value) {

        matchConfidence_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The system's confidence score that this Knowledge answer is a good match
       * for this conversational query.
       * The range is from 0.0 (completely uncertain) to 1.0 (completely certain).
       * Note: The confidence score is likely to vary somewhat (possibly even for
       * identical requests), as the underlying model is under constant
       * improvement. It may be deprecated in the future. We recommend using
       * `match_confidence_level` which should be generally more stable.
       * </pre>
       *
       * <code>float match_confidence = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMatchConfidence() {

        matchConfidence_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer)
    private static final com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer();
    }

    public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Answer> PARSER =
        new com.google.protobuf.AbstractParser<Answer>() {
          @java.lang.Override
          public Answer parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Answer(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Answer> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Answer> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ANSWERS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer> answers_;
  /**
   *
   *
   * <pre>
   * A list of answers from Knowledge Connector.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer>
      getAnswersList() {
    return answers_;
  }
  /**
   *
   *
   * <pre>
   * A list of answers from Knowledge Connector.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.AnswerOrBuilder>
      getAnswersOrBuilderList() {
    return answers_;
  }
  /**
   *
   *
   * <pre>
   * A list of answers from Knowledge Connector.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
   */
  @java.lang.Override
  public int getAnswersCount() {
    return answers_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of answers from Knowledge Connector.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer getAnswers(int index) {
    return answers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of answers from Knowledge Connector.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.AnswerOrBuilder getAnswersOrBuilder(
      int index) {
    return answers_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < answers_.size(); i++) {
      output.writeMessage(1, answers_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < answers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, answers_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers other =
        (com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers) obj;

    if (!getAnswersList().equals(other.getAnswersList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAnswersCount() > 0) {
      hash = (37 * hash) + ANSWERS_FIELD_NUMBER;
      hash = (53 * hash) + getAnswersList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the result of querying a Knowledge base.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.KnowledgeAnswers}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.KnowledgeAnswers)
      com.google.cloud.dialogflow.v2beta1.KnowledgeAnswersOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeAnswers_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeAnswers_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.class,
              com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAnswersFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (answersBuilder_ == null) {
        answers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        answersBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeAnswers_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers build() {
      com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers buildPartial() {
      com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers result =
          new com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers(this);
      int from_bitField0_ = bitField0_;
      if (answersBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          answers_ = java.util.Collections.unmodifiableList(answers_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.answers_ = answers_;
      } else {
        result.answers_ = answersBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers other) {
      if (other == com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.getDefaultInstance())
        return this;
      if (answersBuilder_ == null) {
        if (!other.answers_.isEmpty()) {
          if (answers_.isEmpty()) {
            answers_ = other.answers_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAnswersIsMutable();
            answers_.addAll(other.answers_);
          }
          onChanged();
        }
      } else {
        if (!other.answers_.isEmpty()) {
          if (answersBuilder_.isEmpty()) {
            answersBuilder_.dispose();
            answersBuilder_ = null;
            answers_ = other.answers_;
            bitField0_ = (bitField0_ & ~0x00000001);
            answersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAnswersFieldBuilder()
                    : null;
          } else {
            answersBuilder_.addAllMessages(other.answers_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer> answers_ =
        java.util.Collections.emptyList();

    private void ensureAnswersIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        answers_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer>(
                answers_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer,
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.Builder,
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.AnswerOrBuilder>
        answersBuilder_;

    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer>
        getAnswersList() {
      if (answersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(answers_);
      } else {
        return answersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public int getAnswersCount() {
      if (answersBuilder_ == null) {
        return answers_.size();
      } else {
        return answersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer getAnswers(int index) {
      if (answersBuilder_ == null) {
        return answers_.get(index);
      } else {
        return answersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public Builder setAnswers(
        int index, com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer value) {
      if (answersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswersIsMutable();
        answers_.set(index, value);
        onChanged();
      } else {
        answersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public Builder setAnswers(
        int index,
        com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.Builder builderForValue) {
      if (answersBuilder_ == null) {
        ensureAnswersIsMutable();
        answers_.set(index, builderForValue.build());
        onChanged();
      } else {
        answersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public Builder addAnswers(com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer value) {
      if (answersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswersIsMutable();
        answers_.add(value);
        onChanged();
      } else {
        answersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public Builder addAnswers(
        int index, com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer value) {
      if (answersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswersIsMutable();
        answers_.add(index, value);
        onChanged();
      } else {
        answersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public Builder addAnswers(
        com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.Builder builderForValue) {
      if (answersBuilder_ == null) {
        ensureAnswersIsMutable();
        answers_.add(builderForValue.build());
        onChanged();
      } else {
        answersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public Builder addAnswers(
        int index,
        com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.Builder builderForValue) {
      if (answersBuilder_ == null) {
        ensureAnswersIsMutable();
        answers_.add(index, builderForValue.build());
        onChanged();
      } else {
        answersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public Builder addAllAnswers(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer>
            values) {
      if (answersBuilder_ == null) {
        ensureAnswersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, answers_);
        onChanged();
      } else {
        answersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public Builder clearAnswers() {
      if (answersBuilder_ == null) {
        answers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        answersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public Builder removeAnswers(int index) {
      if (answersBuilder_ == null) {
        ensureAnswersIsMutable();
        answers_.remove(index);
        onChanged();
      } else {
        answersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.Builder getAnswersBuilder(
        int index) {
      return getAnswersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.AnswerOrBuilder getAnswersOrBuilder(
        int index) {
      if (answersBuilder_ == null) {
        return answers_.get(index);
      } else {
        return answersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.AnswerOrBuilder>
        getAnswersOrBuilderList() {
      if (answersBuilder_ != null) {
        return answersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(answers_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.Builder addAnswersBuilder() {
      return getAnswersFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.Builder addAnswersBuilder(
        int index) {
      return getAnswersFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of answers from Knowledge Connector.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer answers = 1;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.Builder>
        getAnswersBuilderList() {
      return getAnswersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer,
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.Builder,
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.AnswerOrBuilder>
        getAnswersFieldBuilder() {
      if (answersBuilder_ == null) {
        answersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer,
                com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer.Builder,
                com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.AnswerOrBuilder>(
                answers_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        answers_ = null;
      }
      return answersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.KnowledgeAnswers)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.KnowledgeAnswers)
  private static final com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers();
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KnowledgeAnswers> PARSER =
      new com.google.protobuf.AbstractParser<KnowledgeAnswers>() {
        @java.lang.Override
        public KnowledgeAnswers parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new KnowledgeAnswers(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<KnowledgeAnswers> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KnowledgeAnswers> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
