/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversationName
implements ResourceName {
    private static final PathTemplate PROJECT_CONVERSATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/conversations/{conversation}");
    private static final PathTemplate PROJECT_LOCATION_CONVERSATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversations/{conversation}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String conversation;
    private final String location;

    @Deprecated
    protected ConversationName() {
        this.project = null;
        this.conversation = null;
        this.location = null;
    }

    private ConversationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.location = null;
        this.pathTemplate = PROJECT_CONVERSATION;
    }

    private ConversationName(ProjectLocationConversationBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.pathTemplate = PROJECT_LOCATION_CONVERSATION;
    }

    public String getProject() {
        return this.project;
    }

    public String getConversation() {
        return this.conversation;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectConversationBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationConversationBuilder newProjectLocationConversationBuilder() {
        return new ProjectLocationConversationBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversationName of(String project, String conversation) {
        return ConversationName.newBuilder().setProject(project).setConversation(conversation).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ConversationName ofProjectConversationName(String project, String conversation) {
        return ConversationName.newBuilder().setProject(project).setConversation(conversation).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ConversationName ofProjectLocationConversationName(String project, String location, String conversation) {
        return ConversationName.newProjectLocationConversationBuilder().setProject(project).setLocation(location).setConversation(conversation).build();
    }

    public static String format(String project, String conversation) {
        return ConversationName.newBuilder().setProject(project).setConversation(conversation).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectConversationName(String project, String conversation) {
        return ConversationName.newBuilder().setProject(project).setConversation(conversation).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationConversationName(String project, String location, String conversation) {
        return ConversationName.newProjectLocationConversationBuilder().setProject(project).setLocation(location).setConversation(conversation).build().toString();
    }

    public static ConversationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_CONVERSATION.matches(formattedString)) {
            Map matchMap = PROJECT_CONVERSATION.match(formattedString);
            return ConversationName.ofProjectConversationName((String)matchMap.get("project"), (String)matchMap.get("conversation"));
        }
        if (PROJECT_LOCATION_CONVERSATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CONVERSATION.match(formattedString);
            return ConversationName.ofProjectLocationConversationName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversation"));
        }
        throw new ValidationException("ConversationName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ConversationName> parseList(List<String> formattedStrings) {
        ArrayList<ConversationName> list = new ArrayList<ConversationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_CONVERSATION.matches(formattedString) || PROJECT_LOCATION_CONVERSATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversationName conversationName = this;
            synchronized (conversationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.conversation != null) {
                        fieldMapBuilder.put((Object)"conversation", (Object)this.conversation);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ConversationName that = (ConversationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.conversation, that.conversation) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.conversation);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationConversationBuilder {
        private String project;
        private String location;
        private String conversation;

        protected ProjectLocationConversationBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversation() {
            return this.conversation;
        }

        public ProjectLocationConversationBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationConversationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationConversationBuilder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public ConversationName build() {
            return new ConversationName(this);
        }
    }

    public static class Builder {
        private String project;
        private String conversation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getConversation() {
            return this.conversation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        private Builder(ConversationName conversationName) {
            Preconditions.checkArgument((boolean)Objects.equals(conversationName.pathTemplate, PROJECT_CONVERSATION), (Object)"toBuilder is only supported when ConversationName has the pattern of projects/{project}/conversations/{conversation}");
            this.project = conversationName.project;
            this.conversation = conversationName.conversation;
        }

        public ConversationName build() {
            return new ConversationName(this);
        }
    }
}

