/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/answer_record.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents feedback the customer has about the quality &amp; correctness of a
 * certain answer in a conversation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.AnswerFeedback}
 */
public final class AnswerFeedback extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.AnswerFeedback)
    AnswerFeedbackOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnswerFeedback.newBuilder() to construct.
  private AnswerFeedback(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnswerFeedback() {
    correctnessLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnswerFeedback();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AnswerFeedback(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              int rawValue = input.readEnum();

              correctnessLevel_ = rawValue;
              break;
            }
          case 18:
            {
              com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.Builder subBuilder = null;
              if (detailFeedbackCase_ == 2) {
                subBuilder =
                    ((com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback) detailFeedback_)
                        .toBuilder();
              }
              detailFeedback_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback) detailFeedback_);
                detailFeedback_ = subBuilder.buildPartial();
              }
              detailFeedbackCase_ = 2;
              break;
            }
          case 24:
            {
              clicked_ = input.readBool();
              break;
            }
          case 32:
            {
              displayed_ = input.readBool();
              break;
            }
          case 42:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (clickTime_ != null) {
                subBuilder = clickTime_.toBuilder();
              }
              clickTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(clickTime_);
                clickTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (displayTime_ != null) {
                subBuilder = displayTime_.toBuilder();
              }
              displayTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(displayTime_);
                displayTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.AnswerRecordsProto
        .internal_static_google_cloud_dialogflow_v2beta1_AnswerFeedback_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.AnswerRecordsProto
        .internal_static_google_cloud_dialogflow_v2beta1_AnswerFeedback_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.AnswerFeedback.class,
            com.google.cloud.dialogflow.v2beta1.AnswerFeedback.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The correctness level of an answer.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel}
   */
  public enum CorrectnessLevel implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Correctness level unspecified.
     * </pre>
     *
     * <code>CORRECTNESS_LEVEL_UNSPECIFIED = 0;</code>
     */
    CORRECTNESS_LEVEL_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Answer is totally wrong.
     * </pre>
     *
     * <code>NOT_CORRECT = 1;</code>
     */
    NOT_CORRECT(1),
    /**
     *
     *
     * <pre>
     * Answer is partially correct.
     * </pre>
     *
     * <code>PARTIALLY_CORRECT = 2;</code>
     */
    PARTIALLY_CORRECT(2),
    /**
     *
     *
     * <pre>
     * Answer is fully correct.
     * </pre>
     *
     * <code>FULLY_CORRECT = 3;</code>
     */
    FULLY_CORRECT(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Correctness level unspecified.
     * </pre>
     *
     * <code>CORRECTNESS_LEVEL_UNSPECIFIED = 0;</code>
     */
    public static final int CORRECTNESS_LEVEL_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Answer is totally wrong.
     * </pre>
     *
     * <code>NOT_CORRECT = 1;</code>
     */
    public static final int NOT_CORRECT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Answer is partially correct.
     * </pre>
     *
     * <code>PARTIALLY_CORRECT = 2;</code>
     */
    public static final int PARTIALLY_CORRECT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Answer is fully correct.
     * </pre>
     *
     * <code>FULLY_CORRECT = 3;</code>
     */
    public static final int FULLY_CORRECT_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static CorrectnessLevel valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static CorrectnessLevel forNumber(int value) {
      switch (value) {
        case 0:
          return CORRECTNESS_LEVEL_UNSPECIFIED;
        case 1:
          return NOT_CORRECT;
        case 2:
          return PARTIALLY_CORRECT;
        case 3:
          return FULLY_CORRECT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<CorrectnessLevel> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<CorrectnessLevel>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CorrectnessLevel>() {
              public CorrectnessLevel findValueByNumber(int number) {
                return CorrectnessLevel.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.AnswerFeedback.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final CorrectnessLevel[] VALUES = values();

    public static CorrectnessLevel valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private CorrectnessLevel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel)
  }

  private int detailFeedbackCase_ = 0;
  private java.lang.Object detailFeedback_;

  public enum DetailFeedbackCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AGENT_ASSISTANT_DETAIL_FEEDBACK(2),
    DETAILFEEDBACK_NOT_SET(0);
    private final int value;

    private DetailFeedbackCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DetailFeedbackCase valueOf(int value) {
      return forNumber(value);
    }

    public static DetailFeedbackCase forNumber(int value) {
      switch (value) {
        case 2:
          return AGENT_ASSISTANT_DETAIL_FEEDBACK;
        case 0:
          return DETAILFEEDBACK_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DetailFeedbackCase getDetailFeedbackCase() {
    return DetailFeedbackCase.forNumber(detailFeedbackCase_);
  }

  public static final int CORRECTNESS_LEVEL_FIELD_NUMBER = 1;
  private int correctnessLevel_;
  /**
   *
   *
   * <pre>
   * The correctness level of the specific answer.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel correctness_level = 1;
   * </code>
   *
   * @return The enum numeric value on the wire for correctnessLevel.
   */
  @java.lang.Override
  public int getCorrectnessLevelValue() {
    return correctnessLevel_;
  }
  /**
   *
   *
   * <pre>
   * The correctness level of the specific answer.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel correctness_level = 1;
   * </code>
   *
   * @return The correctnessLevel.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel getCorrectnessLevel() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel result =
        com.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel.valueOf(
            correctnessLevel_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel.UNRECOGNIZED
        : result;
  }

  public static final int AGENT_ASSISTANT_DETAIL_FEEDBACK_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Optional. Detail feedback of agent assistant suggestions.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.AgentAssistantFeedback agent_assistant_detail_feedback = 2;
   * </code>
   *
   * @return Whether the agentAssistantDetailFeedback field is set.
   */
  @java.lang.Override
  public boolean hasAgentAssistantDetailFeedback() {
    return detailFeedbackCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Optional. Detail feedback of agent assistant suggestions.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.AgentAssistantFeedback agent_assistant_detail_feedback = 2;
   * </code>
   *
   * @return The agentAssistantDetailFeedback.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback
      getAgentAssistantDetailFeedback() {
    if (detailFeedbackCase_ == 2) {
      return (com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback) detailFeedback_;
    }
    return com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Detail feedback of agent assistant suggestions.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.AgentAssistantFeedback agent_assistant_detail_feedback = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedbackOrBuilder
      getAgentAssistantDetailFeedbackOrBuilder() {
    if (detailFeedbackCase_ == 2) {
      return (com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback) detailFeedback_;
    }
    return com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.getDefaultInstance();
  }

  public static final int CLICKED_FIELD_NUMBER = 3;
  private boolean clicked_;
  /**
   *
   *
   * <pre>
   * Indicates whether the answer/item was clicked by the human agent
   * or not. Default to false.
   * </pre>
   *
   * <code>bool clicked = 3;</code>
   *
   * @return The clicked.
   */
  @java.lang.Override
  public boolean getClicked() {
    return clicked_;
  }

  public static final int CLICK_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp clickTime_;
  /**
   *
   *
   * <pre>
   * Time when the answer/item was clicked.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp click_time = 5;</code>
   *
   * @return Whether the clickTime field is set.
   */
  @java.lang.Override
  public boolean hasClickTime() {
    return clickTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time when the answer/item was clicked.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp click_time = 5;</code>
   *
   * @return The clickTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getClickTime() {
    return clickTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : clickTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the answer/item was clicked.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp click_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getClickTimeOrBuilder() {
    return getClickTime();
  }

  public static final int DISPLAYED_FIELD_NUMBER = 4;
  private boolean displayed_;
  /**
   *
   *
   * <pre>
   * Indicates whether the answer/item was displayed to the human
   * agent in the agent desktop UI. Default to false.
   * </pre>
   *
   * <code>bool displayed = 4;</code>
   *
   * @return The displayed.
   */
  @java.lang.Override
  public boolean getDisplayed() {
    return displayed_;
  }

  public static final int DISPLAY_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp displayTime_;
  /**
   *
   *
   * <pre>
   * Time when the answer/item was displayed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp display_time = 6;</code>
   *
   * @return Whether the displayTime field is set.
   */
  @java.lang.Override
  public boolean hasDisplayTime() {
    return displayTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Time when the answer/item was displayed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp display_time = 6;</code>
   *
   * @return The displayTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDisplayTime() {
    return displayTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : displayTime_;
  }
  /**
   *
   *
   * <pre>
   * Time when the answer/item was displayed.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp display_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDisplayTimeOrBuilder() {
    return getDisplayTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (correctnessLevel_
        != com.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel
            .CORRECTNESS_LEVEL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, correctnessLevel_);
    }
    if (detailFeedbackCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback) detailFeedback_);
    }
    if (clicked_ != false) {
      output.writeBool(3, clicked_);
    }
    if (displayed_ != false) {
      output.writeBool(4, displayed_);
    }
    if (clickTime_ != null) {
      output.writeMessage(5, getClickTime());
    }
    if (displayTime_ != null) {
      output.writeMessage(6, getDisplayTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (correctnessLevel_
        != com.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel
            .CORRECTNESS_LEVEL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, correctnessLevel_);
    }
    if (detailFeedbackCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback) detailFeedback_);
    }
    if (clicked_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, clicked_);
    }
    if (displayed_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, displayed_);
    }
    if (clickTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getClickTime());
    }
    if (displayTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getDisplayTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.AnswerFeedback)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.AnswerFeedback other =
        (com.google.cloud.dialogflow.v2beta1.AnswerFeedback) obj;

    if (correctnessLevel_ != other.correctnessLevel_) return false;
    if (getClicked() != other.getClicked()) return false;
    if (hasClickTime() != other.hasClickTime()) return false;
    if (hasClickTime()) {
      if (!getClickTime().equals(other.getClickTime())) return false;
    }
    if (getDisplayed() != other.getDisplayed()) return false;
    if (hasDisplayTime() != other.hasDisplayTime()) return false;
    if (hasDisplayTime()) {
      if (!getDisplayTime().equals(other.getDisplayTime())) return false;
    }
    if (!getDetailFeedbackCase().equals(other.getDetailFeedbackCase())) return false;
    switch (detailFeedbackCase_) {
      case 2:
        if (!getAgentAssistantDetailFeedback().equals(other.getAgentAssistantDetailFeedback()))
          return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CORRECTNESS_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + correctnessLevel_;
    hash = (37 * hash) + CLICKED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getClicked());
    if (hasClickTime()) {
      hash = (37 * hash) + CLICK_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getClickTime().hashCode();
    }
    hash = (37 * hash) + DISPLAYED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisplayed());
    if (hasDisplayTime()) {
      hash = (37 * hash) + DISPLAY_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayTime().hashCode();
    }
    switch (detailFeedbackCase_) {
      case 2:
        hash = (37 * hash) + AGENT_ASSISTANT_DETAIL_FEEDBACK_FIELD_NUMBER;
        hash = (53 * hash) + getAgentAssistantDetailFeedback().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerFeedback parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerFeedback parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerFeedback parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerFeedback parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerFeedback parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerFeedback parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerFeedback parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerFeedback parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerFeedback parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerFeedback parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerFeedback parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerFeedback parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.AnswerFeedback prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents feedback the customer has about the quality &amp; correctness of a
   * certain answer in a conversation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.AnswerFeedback}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.AnswerFeedback)
      com.google.cloud.dialogflow.v2beta1.AnswerFeedbackOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.AnswerRecordsProto
          .internal_static_google_cloud_dialogflow_v2beta1_AnswerFeedback_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.AnswerRecordsProto
          .internal_static_google_cloud_dialogflow_v2beta1_AnswerFeedback_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.AnswerFeedback.class,
              com.google.cloud.dialogflow.v2beta1.AnswerFeedback.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.AnswerFeedback.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      correctnessLevel_ = 0;

      clicked_ = false;

      if (clickTimeBuilder_ == null) {
        clickTime_ = null;
      } else {
        clickTime_ = null;
        clickTimeBuilder_ = null;
      }
      displayed_ = false;

      if (displayTimeBuilder_ == null) {
        displayTime_ = null;
      } else {
        displayTime_ = null;
        displayTimeBuilder_ = null;
      }
      detailFeedbackCase_ = 0;
      detailFeedback_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.AnswerRecordsProto
          .internal_static_google_cloud_dialogflow_v2beta1_AnswerFeedback_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AnswerFeedback getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.AnswerFeedback.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AnswerFeedback build() {
      com.google.cloud.dialogflow.v2beta1.AnswerFeedback result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AnswerFeedback buildPartial() {
      com.google.cloud.dialogflow.v2beta1.AnswerFeedback result =
          new com.google.cloud.dialogflow.v2beta1.AnswerFeedback(this);
      result.correctnessLevel_ = correctnessLevel_;
      if (detailFeedbackCase_ == 2) {
        if (agentAssistantDetailFeedbackBuilder_ == null) {
          result.detailFeedback_ = detailFeedback_;
        } else {
          result.detailFeedback_ = agentAssistantDetailFeedbackBuilder_.build();
        }
      }
      result.clicked_ = clicked_;
      if (clickTimeBuilder_ == null) {
        result.clickTime_ = clickTime_;
      } else {
        result.clickTime_ = clickTimeBuilder_.build();
      }
      result.displayed_ = displayed_;
      if (displayTimeBuilder_ == null) {
        result.displayTime_ = displayTime_;
      } else {
        result.displayTime_ = displayTimeBuilder_.build();
      }
      result.detailFeedbackCase_ = detailFeedbackCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.AnswerFeedback) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.AnswerFeedback) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.AnswerFeedback other) {
      if (other == com.google.cloud.dialogflow.v2beta1.AnswerFeedback.getDefaultInstance())
        return this;
      if (other.correctnessLevel_ != 0) {
        setCorrectnessLevelValue(other.getCorrectnessLevelValue());
      }
      if (other.getClicked() != false) {
        setClicked(other.getClicked());
      }
      if (other.hasClickTime()) {
        mergeClickTime(other.getClickTime());
      }
      if (other.getDisplayed() != false) {
        setDisplayed(other.getDisplayed());
      }
      if (other.hasDisplayTime()) {
        mergeDisplayTime(other.getDisplayTime());
      }
      switch (other.getDetailFeedbackCase()) {
        case AGENT_ASSISTANT_DETAIL_FEEDBACK:
          {
            mergeAgentAssistantDetailFeedback(other.getAgentAssistantDetailFeedback());
            break;
          }
        case DETAILFEEDBACK_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2beta1.AnswerFeedback parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.dialogflow.v2beta1.AnswerFeedback) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int detailFeedbackCase_ = 0;
    private java.lang.Object detailFeedback_;

    public DetailFeedbackCase getDetailFeedbackCase() {
      return DetailFeedbackCase.forNumber(detailFeedbackCase_);
    }

    public Builder clearDetailFeedback() {
      detailFeedbackCase_ = 0;
      detailFeedback_ = null;
      onChanged();
      return this;
    }

    private int correctnessLevel_ = 0;
    /**
     *
     *
     * <pre>
     * The correctness level of the specific answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel correctness_level = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for correctnessLevel.
     */
    @java.lang.Override
    public int getCorrectnessLevelValue() {
      return correctnessLevel_;
    }
    /**
     *
     *
     * <pre>
     * The correctness level of the specific answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel correctness_level = 1;
     * </code>
     *
     * @param value The enum numeric value on the wire for correctnessLevel to set.
     * @return This builder for chaining.
     */
    public Builder setCorrectnessLevelValue(int value) {

      correctnessLevel_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The correctness level of the specific answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel correctness_level = 1;
     * </code>
     *
     * @return The correctnessLevel.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel
        getCorrectnessLevel() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel result =
          com.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel.valueOf(
              correctnessLevel_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The correctness level of the specific answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel correctness_level = 1;
     * </code>
     *
     * @param value The correctnessLevel to set.
     * @return This builder for chaining.
     */
    public Builder setCorrectnessLevel(
        com.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }

      correctnessLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The correctness level of the specific answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback.CorrectnessLevel correctness_level = 1;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCorrectnessLevel() {

      correctnessLevel_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback,
            com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.Builder,
            com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedbackOrBuilder>
        agentAssistantDetailFeedbackBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Detail feedback of agent assistant suggestions.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AgentAssistantFeedback agent_assistant_detail_feedback = 2;
     * </code>
     *
     * @return Whether the agentAssistantDetailFeedback field is set.
     */
    @java.lang.Override
    public boolean hasAgentAssistantDetailFeedback() {
      return detailFeedbackCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Optional. Detail feedback of agent assistant suggestions.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AgentAssistantFeedback agent_assistant_detail_feedback = 2;
     * </code>
     *
     * @return The agentAssistantDetailFeedback.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback
        getAgentAssistantDetailFeedback() {
      if (agentAssistantDetailFeedbackBuilder_ == null) {
        if (detailFeedbackCase_ == 2) {
          return (com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback) detailFeedback_;
        }
        return com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.getDefaultInstance();
      } else {
        if (detailFeedbackCase_ == 2) {
          return agentAssistantDetailFeedbackBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Detail feedback of agent assistant suggestions.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AgentAssistantFeedback agent_assistant_detail_feedback = 2;
     * </code>
     */
    public Builder setAgentAssistantDetailFeedback(
        com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback value) {
      if (agentAssistantDetailFeedbackBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        detailFeedback_ = value;
        onChanged();
      } else {
        agentAssistantDetailFeedbackBuilder_.setMessage(value);
      }
      detailFeedbackCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Detail feedback of agent assistant suggestions.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AgentAssistantFeedback agent_assistant_detail_feedback = 2;
     * </code>
     */
    public Builder setAgentAssistantDetailFeedback(
        com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.Builder builderForValue) {
      if (agentAssistantDetailFeedbackBuilder_ == null) {
        detailFeedback_ = builderForValue.build();
        onChanged();
      } else {
        agentAssistantDetailFeedbackBuilder_.setMessage(builderForValue.build());
      }
      detailFeedbackCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Detail feedback of agent assistant suggestions.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AgentAssistantFeedback agent_assistant_detail_feedback = 2;
     * </code>
     */
    public Builder mergeAgentAssistantDetailFeedback(
        com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback value) {
      if (agentAssistantDetailFeedbackBuilder_ == null) {
        if (detailFeedbackCase_ == 2
            && detailFeedback_
                != com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback
                    .getDefaultInstance()) {
          detailFeedback_ =
              com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback) detailFeedback_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          detailFeedback_ = value;
        }
        onChanged();
      } else {
        if (detailFeedbackCase_ == 2) {
          agentAssistantDetailFeedbackBuilder_.mergeFrom(value);
        }
        agentAssistantDetailFeedbackBuilder_.setMessage(value);
      }
      detailFeedbackCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Detail feedback of agent assistant suggestions.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AgentAssistantFeedback agent_assistant_detail_feedback = 2;
     * </code>
     */
    public Builder clearAgentAssistantDetailFeedback() {
      if (agentAssistantDetailFeedbackBuilder_ == null) {
        if (detailFeedbackCase_ == 2) {
          detailFeedbackCase_ = 0;
          detailFeedback_ = null;
          onChanged();
        }
      } else {
        if (detailFeedbackCase_ == 2) {
          detailFeedbackCase_ = 0;
          detailFeedback_ = null;
        }
        agentAssistantDetailFeedbackBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Detail feedback of agent assistant suggestions.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AgentAssistantFeedback agent_assistant_detail_feedback = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.Builder
        getAgentAssistantDetailFeedbackBuilder() {
      return getAgentAssistantDetailFeedbackFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Detail feedback of agent assistant suggestions.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AgentAssistantFeedback agent_assistant_detail_feedback = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedbackOrBuilder
        getAgentAssistantDetailFeedbackOrBuilder() {
      if ((detailFeedbackCase_ == 2) && (agentAssistantDetailFeedbackBuilder_ != null)) {
        return agentAssistantDetailFeedbackBuilder_.getMessageOrBuilder();
      } else {
        if (detailFeedbackCase_ == 2) {
          return (com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback) detailFeedback_;
        }
        return com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Detail feedback of agent assistant suggestions.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.AgentAssistantFeedback agent_assistant_detail_feedback = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback,
            com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.Builder,
            com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedbackOrBuilder>
        getAgentAssistantDetailFeedbackFieldBuilder() {
      if (agentAssistantDetailFeedbackBuilder_ == null) {
        if (!(detailFeedbackCase_ == 2)) {
          detailFeedback_ =
              com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.getDefaultInstance();
        }
        agentAssistantDetailFeedbackBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback,
                com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback.Builder,
                com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedbackOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.AgentAssistantFeedback) detailFeedback_,
                getParentForChildren(),
                isClean());
        detailFeedback_ = null;
      }
      detailFeedbackCase_ = 2;
      onChanged();
      ;
      return agentAssistantDetailFeedbackBuilder_;
    }

    private boolean clicked_;
    /**
     *
     *
     * <pre>
     * Indicates whether the answer/item was clicked by the human agent
     * or not. Default to false.
     * </pre>
     *
     * <code>bool clicked = 3;</code>
     *
     * @return The clicked.
     */
    @java.lang.Override
    public boolean getClicked() {
      return clicked_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the answer/item was clicked by the human agent
     * or not. Default to false.
     * </pre>
     *
     * <code>bool clicked = 3;</code>
     *
     * @param value The clicked to set.
     * @return This builder for chaining.
     */
    public Builder setClicked(boolean value) {

      clicked_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the answer/item was clicked by the human agent
     * or not. Default to false.
     * </pre>
     *
     * <code>bool clicked = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClicked() {

      clicked_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp clickTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        clickTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the answer/item was clicked.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp click_time = 5;</code>
     *
     * @return Whether the clickTime field is set.
     */
    public boolean hasClickTime() {
      return clickTimeBuilder_ != null || clickTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was clicked.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp click_time = 5;</code>
     *
     * @return The clickTime.
     */
    public com.google.protobuf.Timestamp getClickTime() {
      if (clickTimeBuilder_ == null) {
        return clickTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : clickTime_;
      } else {
        return clickTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was clicked.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp click_time = 5;</code>
     */
    public Builder setClickTime(com.google.protobuf.Timestamp value) {
      if (clickTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        clickTime_ = value;
        onChanged();
      } else {
        clickTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was clicked.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp click_time = 5;</code>
     */
    public Builder setClickTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (clickTimeBuilder_ == null) {
        clickTime_ = builderForValue.build();
        onChanged();
      } else {
        clickTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was clicked.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp click_time = 5;</code>
     */
    public Builder mergeClickTime(com.google.protobuf.Timestamp value) {
      if (clickTimeBuilder_ == null) {
        if (clickTime_ != null) {
          clickTime_ =
              com.google.protobuf.Timestamp.newBuilder(clickTime_).mergeFrom(value).buildPartial();
        } else {
          clickTime_ = value;
        }
        onChanged();
      } else {
        clickTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was clicked.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp click_time = 5;</code>
     */
    public Builder clearClickTime() {
      if (clickTimeBuilder_ == null) {
        clickTime_ = null;
        onChanged();
      } else {
        clickTime_ = null;
        clickTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was clicked.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp click_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getClickTimeBuilder() {

      onChanged();
      return getClickTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was clicked.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp click_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getClickTimeOrBuilder() {
      if (clickTimeBuilder_ != null) {
        return clickTimeBuilder_.getMessageOrBuilder();
      } else {
        return clickTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : clickTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was clicked.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp click_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getClickTimeFieldBuilder() {
      if (clickTimeBuilder_ == null) {
        clickTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getClickTime(), getParentForChildren(), isClean());
        clickTime_ = null;
      }
      return clickTimeBuilder_;
    }

    private boolean displayed_;
    /**
     *
     *
     * <pre>
     * Indicates whether the answer/item was displayed to the human
     * agent in the agent desktop UI. Default to false.
     * </pre>
     *
     * <code>bool displayed = 4;</code>
     *
     * @return The displayed.
     */
    @java.lang.Override
    public boolean getDisplayed() {
      return displayed_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the answer/item was displayed to the human
     * agent in the agent desktop UI. Default to false.
     * </pre>
     *
     * <code>bool displayed = 4;</code>
     *
     * @param value The displayed to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayed(boolean value) {

      displayed_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the answer/item was displayed to the human
     * agent in the agent desktop UI. Default to false.
     * </pre>
     *
     * <code>bool displayed = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayed() {

      displayed_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp displayTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        displayTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Time when the answer/item was displayed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp display_time = 6;</code>
     *
     * @return Whether the displayTime field is set.
     */
    public boolean hasDisplayTime() {
      return displayTimeBuilder_ != null || displayTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was displayed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp display_time = 6;</code>
     *
     * @return The displayTime.
     */
    public com.google.protobuf.Timestamp getDisplayTime() {
      if (displayTimeBuilder_ == null) {
        return displayTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : displayTime_;
      } else {
        return displayTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was displayed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp display_time = 6;</code>
     */
    public Builder setDisplayTime(com.google.protobuf.Timestamp value) {
      if (displayTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayTime_ = value;
        onChanged();
      } else {
        displayTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was displayed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp display_time = 6;</code>
     */
    public Builder setDisplayTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (displayTimeBuilder_ == null) {
        displayTime_ = builderForValue.build();
        onChanged();
      } else {
        displayTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was displayed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp display_time = 6;</code>
     */
    public Builder mergeDisplayTime(com.google.protobuf.Timestamp value) {
      if (displayTimeBuilder_ == null) {
        if (displayTime_ != null) {
          displayTime_ =
              com.google.protobuf.Timestamp.newBuilder(displayTime_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          displayTime_ = value;
        }
        onChanged();
      } else {
        displayTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was displayed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp display_time = 6;</code>
     */
    public Builder clearDisplayTime() {
      if (displayTimeBuilder_ == null) {
        displayTime_ = null;
        onChanged();
      } else {
        displayTime_ = null;
        displayTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was displayed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp display_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getDisplayTimeBuilder() {

      onChanged();
      return getDisplayTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was displayed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp display_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getDisplayTimeOrBuilder() {
      if (displayTimeBuilder_ != null) {
        return displayTimeBuilder_.getMessageOrBuilder();
      } else {
        return displayTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : displayTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time when the answer/item was displayed.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp display_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDisplayTimeFieldBuilder() {
      if (displayTimeBuilder_ == null) {
        displayTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDisplayTime(), getParentForChildren(), isClean());
        displayTime_ = null;
      }
      return displayTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.AnswerFeedback)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.AnswerFeedback)
  private static final com.google.cloud.dialogflow.v2beta1.AnswerFeedback DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.AnswerFeedback();
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerFeedback getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnswerFeedback> PARSER =
      new com.google.protobuf.AbstractParser<AnswerFeedback>() {
        @java.lang.Override
        public AnswerFeedback parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AnswerFeedback(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AnswerFeedback> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnswerFeedback> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AnswerFeedback getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
