/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/environment.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * You can create multiple versions of your agent and publish them to separate
 * environments.
 * When you edit an agent, you are editing the draft agent. At any point, you
 * can save the draft agent as an agent version, which is an immutable snapshot
 * of your agent.
 * When you save the draft agent, it is published to the default environment.
 * When you create agent versions, you can publish them to custom environments.
 * You can create a variety of custom environments for:
 * - testing
 * - development
 * - production
 * - etc.
 * For more information, see the [versions and environments
 * guide](https://cloud.google.com/dialogflow/docs/agents-versions).
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.Environment}
 */
public final class Environment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Environment)
    EnvironmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Environment.newBuilder() to construct.
  private Environment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Environment() {
    name_ = "";
    description_ = "";
    agentVersion_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Environment();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Environment(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              agentVersion_ = s;
              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 42:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (updateTime_ != null) {
                subBuilder = updateTime_.toBuilder();
              }
              updateTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(updateTime_);
                updateTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.Builder subBuilder = null;
              if (textToSpeechSettings_ != null) {
                subBuilder = textToSpeechSettings_.toBuilder();
              }
              textToSpeechSettings_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(textToSpeechSettings_);
                textToSpeechSettings_ = subBuilder.buildPartial();
              }

              break;
            }
          case 66:
            {
              com.google.cloud.dialogflow.v2beta1.Fulfillment.Builder subBuilder = null;
              if (fulfillment_ != null) {
                subBuilder = fulfillment_.toBuilder();
              }
              fulfillment_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.Fulfillment.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(fulfillment_);
                fulfillment_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.EnvironmentProto
        .internal_static_google_cloud_dialogflow_v2beta1_Environment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.EnvironmentProto
        .internal_static_google_cloud_dialogflow_v2beta1_Environment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.Environment.class,
            com.google.cloud.dialogflow.v2beta1.Environment.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Represents an environment state. When an environment is pointed to a new
   * agent version, the environment is temporarily set to the `LOADING` state.
   * During that time, the environment keeps on serving the previous version of
   * the agent. After the new agent version is done loading, the environment is
   * set back to the `RUNNING` state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2beta1.Environment.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. This value is not used.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Stopped.
     * </pre>
     *
     * <code>STOPPED = 1;</code>
     */
    STOPPED(1),
    /**
     *
     *
     * <pre>
     * Loading.
     * </pre>
     *
     * <code>LOADING = 2;</code>
     */
    LOADING(2),
    /**
     *
     *
     * <pre>
     * Running.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    RUNNING(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. This value is not used.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Stopped.
     * </pre>
     *
     * <code>STOPPED = 1;</code>
     */
    public static final int STOPPED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Loading.
     * </pre>
     *
     * <code>LOADING = 2;</code>
     */
    public static final int LOADING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Running.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    public static final int RUNNING_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return STOPPED;
        case 2:
          return LOADING;
        case 3:
          return RUNNING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.Environment.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.Environment.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. The unique identifier of this agent environment.
   * Supported formats:
   * - `projects/&lt;Project Number / ID&gt;/agent/environments/&lt;Environment ID&gt;`
   * - `projects/&lt;Project Number / ID&gt;/locations/&lt;Location
   *   ID&gt;/agent/environments/&lt;Environment ID&gt;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The unique identifier of this agent environment.
   * Supported formats:
   * - `projects/&lt;Project Number / ID&gt;/agent/environments/&lt;Environment ID&gt;`
   * - `projects/&lt;Project Number / ID&gt;/locations/&lt;Location
   *   ID&gt;/agent/environments/&lt;Environment ID&gt;`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Optional. The developer-provided description for this environment.
   * The maximum length is 500 characters. If exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The developer-provided description for this environment.
   * The maximum length is 500 characters. If exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AGENT_VERSION_FIELD_NUMBER = 3;
  private volatile java.lang.Object agentVersion_;
  /**
   *
   *
   * <pre>
   * Optional. The agent version loaded into this environment.
   * Supported formats:
   * - `projects/&lt;Project ID&gt;/agent/versions/&lt;Version ID&gt;`
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/versions/&lt;Version
   *   ID&gt;`
   * </pre>
   *
   * <code>
   * string agent_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The agentVersion.
   */
  @java.lang.Override
  public java.lang.String getAgentVersion() {
    java.lang.Object ref = agentVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      agentVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The agent version loaded into this environment.
   * Supported formats:
   * - `projects/&lt;Project ID&gt;/agent/versions/&lt;Version ID&gt;`
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/versions/&lt;Version
   *   ID&gt;`
   * </pre>
   *
   * <code>
   * string agent_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for agentVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAgentVersionBytes() {
    java.lang.Object ref = agentVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      agentVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 4;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. The state of this environment. This field is read-only, i.e., it cannot be
   * set by create and update methods.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Environment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of this environment. This field is read-only, i.e., it cannot be
   * set by create and update methods.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Environment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Environment.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2beta1.Environment.State result =
        com.google.cloud.dialogflow.v2beta1.Environment.State.valueOf(state_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.Environment.State.UNRECOGNIZED
        : result;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update time of this environment. This field is read-only, i.e., it
   * cannot be set by create and update methods.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update time of this environment. This field is read-only, i.e., it
   * cannot be set by create and update methods.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update time of this environment. This field is read-only, i.e., it
   * cannot be set by create and update methods.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return getUpdateTime();
  }

  public static final int TEXT_TO_SPEECH_SETTINGS_FIELD_NUMBER = 7;
  private com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings textToSpeechSettings_;
  /**
   *
   *
   * <pre>
   * Optional. Text to speech settings for this environment.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.TextToSpeechSettings text_to_speech_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the textToSpeechSettings field is set.
   */
  @java.lang.Override
  public boolean hasTextToSpeechSettings() {
    return textToSpeechSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Text to speech settings for this environment.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.TextToSpeechSettings text_to_speech_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The textToSpeechSettings.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings getTextToSpeechSettings() {
    return textToSpeechSettings_ == null
        ? com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.getDefaultInstance()
        : textToSpeechSettings_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Text to speech settings for this environment.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.TextToSpeechSettings text_to_speech_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TextToSpeechSettingsOrBuilder
      getTextToSpeechSettingsOrBuilder() {
    return getTextToSpeechSettings();
  }

  public static final int FULFILLMENT_FIELD_NUMBER = 8;
  private com.google.cloud.dialogflow.v2beta1.Fulfillment fulfillment_;
  /**
   *
   *
   * <pre>
   * Optional. The fulfillment settings to use for this environment.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Fulfillment fulfillment = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the fulfillment field is set.
   */
  @java.lang.Override
  public boolean hasFulfillment() {
    return fulfillment_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The fulfillment settings to use for this environment.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Fulfillment fulfillment = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The fulfillment.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Fulfillment getFulfillment() {
    return fulfillment_ == null
        ? com.google.cloud.dialogflow.v2beta1.Fulfillment.getDefaultInstance()
        : fulfillment_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The fulfillment settings to use for this environment.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.Fulfillment fulfillment = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.FulfillmentOrBuilder getFulfillmentOrBuilder() {
    return getFulfillment();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, agentVersion_);
    }
    if (state_
        != com.google.cloud.dialogflow.v2beta1.Environment.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, state_);
    }
    if (updateTime_ != null) {
      output.writeMessage(5, getUpdateTime());
    }
    if (textToSpeechSettings_ != null) {
      output.writeMessage(7, getTextToSpeechSettings());
    }
    if (fulfillment_ != null) {
      output.writeMessage(8, getFulfillment());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, agentVersion_);
    }
    if (state_
        != com.google.cloud.dialogflow.v2beta1.Environment.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    if (textToSpeechSettings_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTextToSpeechSettings());
    }
    if (fulfillment_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getFulfillment());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.Environment)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.Environment other =
        (com.google.cloud.dialogflow.v2beta1.Environment) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getAgentVersion().equals(other.getAgentVersion())) return false;
    if (state_ != other.state_) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasTextToSpeechSettings() != other.hasTextToSpeechSettings()) return false;
    if (hasTextToSpeechSettings()) {
      if (!getTextToSpeechSettings().equals(other.getTextToSpeechSettings())) return false;
    }
    if (hasFulfillment() != other.hasFulfillment()) return false;
    if (hasFulfillment()) {
      if (!getFulfillment().equals(other.getFulfillment())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + AGENT_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getAgentVersion().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasTextToSpeechSettings()) {
      hash = (37 * hash) + TEXT_TO_SPEECH_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getTextToSpeechSettings().hashCode();
    }
    if (hasFulfillment()) {
      hash = (37 * hash) + FULFILLMENT_FIELD_NUMBER;
      hash = (53 * hash) + getFulfillment().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.Environment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Environment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Environment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Environment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Environment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Environment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Environment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Environment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Environment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Environment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Environment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Environment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.Environment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * You can create multiple versions of your agent and publish them to separate
   * environments.
   * When you edit an agent, you are editing the draft agent. At any point, you
   * can save the draft agent as an agent version, which is an immutable snapshot
   * of your agent.
   * When you save the draft agent, it is published to the default environment.
   * When you create agent versions, you can publish them to custom environments.
   * You can create a variety of custom environments for:
   * - testing
   * - development
   * - production
   * - etc.
   * For more information, see the [versions and environments
   * guide](https://cloud.google.com/dialogflow/docs/agents-versions).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Environment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Environment)
      com.google.cloud.dialogflow.v2beta1.EnvironmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_v2beta1_Environment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_v2beta1_Environment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Environment.class,
              com.google.cloud.dialogflow.v2beta1.Environment.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.Environment.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      description_ = "";

      agentVersion_ = "";

      state_ = 0;

      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }
      if (textToSpeechSettingsBuilder_ == null) {
        textToSpeechSettings_ = null;
      } else {
        textToSpeechSettings_ = null;
        textToSpeechSettingsBuilder_ = null;
      }
      if (fulfillmentBuilder_ == null) {
        fulfillment_ = null;
      } else {
        fulfillment_ = null;
        fulfillmentBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_v2beta1_Environment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Environment getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.Environment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Environment build() {
      com.google.cloud.dialogflow.v2beta1.Environment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Environment buildPartial() {
      com.google.cloud.dialogflow.v2beta1.Environment result =
          new com.google.cloud.dialogflow.v2beta1.Environment(this);
      result.name_ = name_;
      result.description_ = description_;
      result.agentVersion_ = agentVersion_;
      result.state_ = state_;
      if (updateTimeBuilder_ == null) {
        result.updateTime_ = updateTime_;
      } else {
        result.updateTime_ = updateTimeBuilder_.build();
      }
      if (textToSpeechSettingsBuilder_ == null) {
        result.textToSpeechSettings_ = textToSpeechSettings_;
      } else {
        result.textToSpeechSettings_ = textToSpeechSettingsBuilder_.build();
      }
      if (fulfillmentBuilder_ == null) {
        result.fulfillment_ = fulfillment_;
      } else {
        result.fulfillment_ = fulfillmentBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.Environment) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.Environment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.Environment other) {
      if (other == com.google.cloud.dialogflow.v2beta1.Environment.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (!other.getAgentVersion().isEmpty()) {
        agentVersion_ = other.agentVersion_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasTextToSpeechSettings()) {
        mergeTextToSpeechSettings(other.getTextToSpeechSettings());
      }
      if (other.hasFulfillment()) {
        mergeFulfillment(other.getFulfillment());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2beta1.Environment parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.dialogflow.v2beta1.Environment) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this agent environment.
     * Supported formats:
     * - `projects/&lt;Project Number / ID&gt;/agent/environments/&lt;Environment ID&gt;`
     * - `projects/&lt;Project Number / ID&gt;/locations/&lt;Location
     *   ID&gt;/agent/environments/&lt;Environment ID&gt;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this agent environment.
     * Supported formats:
     * - `projects/&lt;Project Number / ID&gt;/agent/environments/&lt;Environment ID&gt;`
     * - `projects/&lt;Project Number / ID&gt;/locations/&lt;Location
     *   ID&gt;/agent/environments/&lt;Environment ID&gt;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this agent environment.
     * Supported formats:
     * - `projects/&lt;Project Number / ID&gt;/agent/environments/&lt;Environment ID&gt;`
     * - `projects/&lt;Project Number / ID&gt;/locations/&lt;Location
     *   ID&gt;/agent/environments/&lt;Environment ID&gt;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this agent environment.
     * Supported formats:
     * - `projects/&lt;Project Number / ID&gt;/agent/environments/&lt;Environment ID&gt;`
     * - `projects/&lt;Project Number / ID&gt;/locations/&lt;Location
     *   ID&gt;/agent/environments/&lt;Environment ID&gt;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The unique identifier of this agent environment.
     * Supported formats:
     * - `projects/&lt;Project Number / ID&gt;/agent/environments/&lt;Environment ID&gt;`
     * - `projects/&lt;Project Number / ID&gt;/locations/&lt;Location
     *   ID&gt;/agent/environments/&lt;Environment ID&gt;`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The developer-provided description for this environment.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The developer-provided description for this environment.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The developer-provided description for this environment.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The developer-provided description for this environment.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The developer-provided description for this environment.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object agentVersion_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The agent version loaded into this environment.
     * Supported formats:
     * - `projects/&lt;Project ID&gt;/agent/versions/&lt;Version ID&gt;`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/versions/&lt;Version
     *   ID&gt;`
     * </pre>
     *
     * <code>
     * string agent_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The agentVersion.
     */
    public java.lang.String getAgentVersion() {
      java.lang.Object ref = agentVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agentVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The agent version loaded into this environment.
     * Supported formats:
     * - `projects/&lt;Project ID&gt;/agent/versions/&lt;Version ID&gt;`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/versions/&lt;Version
     *   ID&gt;`
     * </pre>
     *
     * <code>
     * string agent_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for agentVersion.
     */
    public com.google.protobuf.ByteString getAgentVersionBytes() {
      java.lang.Object ref = agentVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agentVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The agent version loaded into this environment.
     * Supported formats:
     * - `projects/&lt;Project ID&gt;/agent/versions/&lt;Version ID&gt;`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/versions/&lt;Version
     *   ID&gt;`
     * </pre>
     *
     * <code>
     * string agent_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The agentVersion to set.
     * @return This builder for chaining.
     */
    public Builder setAgentVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      agentVersion_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The agent version loaded into this environment.
     * Supported formats:
     * - `projects/&lt;Project ID&gt;/agent/versions/&lt;Version ID&gt;`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/versions/&lt;Version
     *   ID&gt;`
     * </pre>
     *
     * <code>
     * string agent_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgentVersion() {

      agentVersion_ = getDefaultInstance().getAgentVersion();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The agent version loaded into this environment.
     * Supported formats:
     * - `projects/&lt;Project ID&gt;/agent/versions/&lt;Version ID&gt;`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/versions/&lt;Version
     *   ID&gt;`
     * </pre>
     *
     * <code>
     * string agent_version = 3 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for agentVersion to set.
     * @return This builder for chaining.
     */
    public Builder setAgentVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      agentVersion_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of this environment. This field is read-only, i.e., it cannot be
     * set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Environment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this environment. This field is read-only, i.e., it cannot be
     * set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Environment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this environment. This field is read-only, i.e., it cannot be
     * set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Environment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Environment.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2beta1.Environment.State result =
          com.google.cloud.dialogflow.v2beta1.Environment.State.valueOf(state_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.Environment.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this environment. This field is read-only, i.e., it cannot be
     * set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Environment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.dialogflow.v2beta1.Environment.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of this environment. This field is read-only, i.e., it cannot be
     * set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Environment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update time of this environment. This field is read-only, i.e., it
     * cannot be set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return updateTimeBuilder_ != null || updateTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of this environment. This field is read-only, i.e., it
     * cannot be set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of this environment. This field is read-only, i.e., it
     * cannot be set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of this environment. This field is read-only, i.e., it
     * cannot be set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of this environment. This field is read-only, i.e., it
     * cannot be set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (updateTime_ != null) {
          updateTime_ =
              com.google.protobuf.Timestamp.newBuilder(updateTime_).mergeFrom(value).buildPartial();
        } else {
          updateTime_ = value;
        }
        onChanged();
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of this environment. This field is read-only, i.e., it
     * cannot be set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        updateTime_ = null;
        onChanged();
      } else {
        updateTime_ = null;
        updateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of this environment. This field is read-only, i.e., it
     * cannot be set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {

      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of this environment. This field is read-only, i.e., it
     * cannot be set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of this environment. This field is read-only, i.e., it
     * cannot be set by create and update methods.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings textToSpeechSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings,
            com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.Builder,
            com.google.cloud.dialogflow.v2beta1.TextToSpeechSettingsOrBuilder>
        textToSpeechSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Text to speech settings for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TextToSpeechSettings text_to_speech_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the textToSpeechSettings field is set.
     */
    public boolean hasTextToSpeechSettings() {
      return textToSpeechSettingsBuilder_ != null || textToSpeechSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Text to speech settings for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TextToSpeechSettings text_to_speech_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The textToSpeechSettings.
     */
    public com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings getTextToSpeechSettings() {
      if (textToSpeechSettingsBuilder_ == null) {
        return textToSpeechSettings_ == null
            ? com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.getDefaultInstance()
            : textToSpeechSettings_;
      } else {
        return textToSpeechSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Text to speech settings for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TextToSpeechSettings text_to_speech_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTextToSpeechSettings(
        com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings value) {
      if (textToSpeechSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        textToSpeechSettings_ = value;
        onChanged();
      } else {
        textToSpeechSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Text to speech settings for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TextToSpeechSettings text_to_speech_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTextToSpeechSettings(
        com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.Builder builderForValue) {
      if (textToSpeechSettingsBuilder_ == null) {
        textToSpeechSettings_ = builderForValue.build();
        onChanged();
      } else {
        textToSpeechSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Text to speech settings for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TextToSpeechSettings text_to_speech_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTextToSpeechSettings(
        com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings value) {
      if (textToSpeechSettingsBuilder_ == null) {
        if (textToSpeechSettings_ != null) {
          textToSpeechSettings_ =
              com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.newBuilder(
                      textToSpeechSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          textToSpeechSettings_ = value;
        }
        onChanged();
      } else {
        textToSpeechSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Text to speech settings for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TextToSpeechSettings text_to_speech_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTextToSpeechSettings() {
      if (textToSpeechSettingsBuilder_ == null) {
        textToSpeechSettings_ = null;
        onChanged();
      } else {
        textToSpeechSettings_ = null;
        textToSpeechSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Text to speech settings for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TextToSpeechSettings text_to_speech_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.Builder
        getTextToSpeechSettingsBuilder() {

      onChanged();
      return getTextToSpeechSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Text to speech settings for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TextToSpeechSettings text_to_speech_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.TextToSpeechSettingsOrBuilder
        getTextToSpeechSettingsOrBuilder() {
      if (textToSpeechSettingsBuilder_ != null) {
        return textToSpeechSettingsBuilder_.getMessageOrBuilder();
      } else {
        return textToSpeechSettings_ == null
            ? com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.getDefaultInstance()
            : textToSpeechSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Text to speech settings for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.TextToSpeechSettings text_to_speech_settings = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings,
            com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.Builder,
            com.google.cloud.dialogflow.v2beta1.TextToSpeechSettingsOrBuilder>
        getTextToSpeechSettingsFieldBuilder() {
      if (textToSpeechSettingsBuilder_ == null) {
        textToSpeechSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings,
                com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.Builder,
                com.google.cloud.dialogflow.v2beta1.TextToSpeechSettingsOrBuilder>(
                getTextToSpeechSettings(), getParentForChildren(), isClean());
        textToSpeechSettings_ = null;
      }
      return textToSpeechSettingsBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.Fulfillment fulfillment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Fulfillment,
            com.google.cloud.dialogflow.v2beta1.Fulfillment.Builder,
            com.google.cloud.dialogflow.v2beta1.FulfillmentOrBuilder>
        fulfillmentBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The fulfillment settings to use for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Fulfillment fulfillment = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the fulfillment field is set.
     */
    public boolean hasFulfillment() {
      return fulfillmentBuilder_ != null || fulfillment_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The fulfillment settings to use for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Fulfillment fulfillment = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The fulfillment.
     */
    public com.google.cloud.dialogflow.v2beta1.Fulfillment getFulfillment() {
      if (fulfillmentBuilder_ == null) {
        return fulfillment_ == null
            ? com.google.cloud.dialogflow.v2beta1.Fulfillment.getDefaultInstance()
            : fulfillment_;
      } else {
        return fulfillmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The fulfillment settings to use for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Fulfillment fulfillment = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFulfillment(com.google.cloud.dialogflow.v2beta1.Fulfillment value) {
      if (fulfillmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fulfillment_ = value;
        onChanged();
      } else {
        fulfillmentBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The fulfillment settings to use for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Fulfillment fulfillment = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFulfillment(
        com.google.cloud.dialogflow.v2beta1.Fulfillment.Builder builderForValue) {
      if (fulfillmentBuilder_ == null) {
        fulfillment_ = builderForValue.build();
        onChanged();
      } else {
        fulfillmentBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The fulfillment settings to use for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Fulfillment fulfillment = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFulfillment(com.google.cloud.dialogflow.v2beta1.Fulfillment value) {
      if (fulfillmentBuilder_ == null) {
        if (fulfillment_ != null) {
          fulfillment_ =
              com.google.cloud.dialogflow.v2beta1.Fulfillment.newBuilder(fulfillment_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          fulfillment_ = value;
        }
        onChanged();
      } else {
        fulfillmentBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The fulfillment settings to use for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Fulfillment fulfillment = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFulfillment() {
      if (fulfillmentBuilder_ == null) {
        fulfillment_ = null;
        onChanged();
      } else {
        fulfillment_ = null;
        fulfillmentBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The fulfillment settings to use for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Fulfillment fulfillment = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Fulfillment.Builder getFulfillmentBuilder() {

      onChanged();
      return getFulfillmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The fulfillment settings to use for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Fulfillment fulfillment = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.FulfillmentOrBuilder getFulfillmentOrBuilder() {
      if (fulfillmentBuilder_ != null) {
        return fulfillmentBuilder_.getMessageOrBuilder();
      } else {
        return fulfillment_ == null
            ? com.google.cloud.dialogflow.v2beta1.Fulfillment.getDefaultInstance()
            : fulfillment_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The fulfillment settings to use for this environment.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.Fulfillment fulfillment = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Fulfillment,
            com.google.cloud.dialogflow.v2beta1.Fulfillment.Builder,
            com.google.cloud.dialogflow.v2beta1.FulfillmentOrBuilder>
        getFulfillmentFieldBuilder() {
      if (fulfillmentBuilder_ == null) {
        fulfillmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.Fulfillment,
                com.google.cloud.dialogflow.v2beta1.Fulfillment.Builder,
                com.google.cloud.dialogflow.v2beta1.FulfillmentOrBuilder>(
                getFulfillment(), getParentForChildren(), isClean());
        fulfillment_ = null;
      }
      return fulfillmentBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Environment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Environment)
  private static final com.google.cloud.dialogflow.v2beta1.Environment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.Environment();
  }

  public static com.google.cloud.dialogflow.v2beta1.Environment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Environment> PARSER =
      new com.google.protobuf.AbstractParser<Environment>() {
        @java.lang.Override
        public Environment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Environment(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Environment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Environment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Environment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
