/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/document.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Metadata in google::longrunning::Operation for Knowledge operations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata}
 */
public final class KnowledgeOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata)
    KnowledgeOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KnowledgeOperationMetadata.newBuilder() to construct.
  private KnowledgeOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KnowledgeOperationMetadata() {
    state_ = 0;
    knowledgeBase_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KnowledgeOperationMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private KnowledgeOperationMetadata(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              knowledgeBase_ = s;
              break;
            }
          case 34:
            {
              com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.Builder subBuilder = null;
              if (operationMetadataCase_ == 4) {
                subBuilder =
                    ((com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata)
                            operationMetadata_)
                        .toBuilder();
              }
              operationMetadata_ =
                  input.readMessage(
                      com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata)
                        operationMetadata_);
                operationMetadata_ = subBuilder.buildPartial();
              }
              operationMetadataCase_ = 4;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.DocumentProto
        .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.DocumentProto
        .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.class,
            com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * States of the operation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * State unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The operation has been created.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The operation is currently running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The operation is done, either cancelled or completed.
     * </pre>
     *
     * <code>DONE = 3;</code>
     */
    DONE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * State unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The operation has been created.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The operation is currently running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The operation is done, either cancelled or completed.
     * </pre>
     *
     * <code>DONE = 3;</code>
     */
    public static final int DONE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return RUNNING;
        case 3:
          return DONE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State)
  }

  private int operationMetadataCase_ = 0;
  private java.lang.Object operationMetadata_;

  public enum OperationMetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXPORT_OPERATION_METADATA(4),
    OPERATIONMETADATA_NOT_SET(0);
    private final int value;

    private OperationMetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OperationMetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static OperationMetadataCase forNumber(int value) {
      switch (value) {
        case 4:
          return EXPORT_OPERATION_METADATA;
        case 0:
          return OPERATIONMETADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OperationMetadataCase getOperationMetadataCase() {
    return OperationMetadataCase.forNumber(operationMetadataCase_);
  }

  public static final int STATE_FIELD_NUMBER = 1;
  private int state_;
  /**
   *
   *
   * <pre>
   * Required. Output only. The current state of this operation.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Required. Output only. The current state of this operation.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State result =
        com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State.valueOf(state_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State.UNRECOGNIZED
        : result;
  }

  public static final int KNOWLEDGE_BASE_FIELD_NUMBER = 3;
  private volatile java.lang.Object knowledgeBase_;
  /**
   *
   *
   * <pre>
   * The name of the knowledge base interacted with during the operation.
   * </pre>
   *
   * <code>string knowledge_base = 3;</code>
   *
   * @return The knowledgeBase.
   */
  @java.lang.Override
  public java.lang.String getKnowledgeBase() {
    java.lang.Object ref = knowledgeBase_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      knowledgeBase_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the knowledge base interacted with during the operation.
   * </pre>
   *
   * <code>string knowledge_base = 3;</code>
   *
   * @return The bytes for knowledgeBase.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKnowledgeBaseBytes() {
    java.lang.Object ref = knowledgeBase_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      knowledgeBase_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPORT_OPERATION_METADATA_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Metadata for the Export Data Operation such as the destination of export.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.ExportOperationMetadata export_operation_metadata = 4;
   * </code>
   *
   * @return Whether the exportOperationMetadata field is set.
   */
  @java.lang.Override
  public boolean hasExportOperationMetadata() {
    return operationMetadataCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Metadata for the Export Data Operation such as the destination of export.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.ExportOperationMetadata export_operation_metadata = 4;
   * </code>
   *
   * @return The exportOperationMetadata.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata getExportOperationMetadata() {
    if (operationMetadataCase_ == 4) {
      return (com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata) operationMetadata_;
    }
    return com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Metadata for the Export Data Operation such as the destination of export.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.ExportOperationMetadata export_operation_metadata = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.ExportOperationMetadataOrBuilder
      getExportOperationMetadataOrBuilder() {
    if (operationMetadataCase_ == 4) {
      return (com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata) operationMetadata_;
    }
    return com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (state_
        != com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(knowledgeBase_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, knowledgeBase_);
    }
    if (operationMetadataCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata) operationMetadata_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (state_
        != com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(knowledgeBase_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, knowledgeBase_);
    }
    if (operationMetadataCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata) operationMetadata_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata other =
        (com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata) obj;

    if (state_ != other.state_) return false;
    if (!getKnowledgeBase().equals(other.getKnowledgeBase())) return false;
    if (!getOperationMetadataCase().equals(other.getOperationMetadataCase())) return false;
    switch (operationMetadataCase_) {
      case 4:
        if (!getExportOperationMetadata().equals(other.getExportOperationMetadata())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + KNOWLEDGE_BASE_FIELD_NUMBER;
    hash = (53 * hash) + getKnowledgeBase().hashCode();
    switch (operationMetadataCase_) {
      case 4:
        hash = (37 * hash) + EXPORT_OPERATION_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getExportOperationMetadata().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata in google::longrunning::Operation for Knowledge operations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata)
      com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.DocumentProto
          .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.DocumentProto
          .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.class,
              com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      state_ = 0;

      knowledgeBase_ = "";

      operationMetadataCase_ = 0;
      operationMetadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.DocumentProto
          .internal_static_google_cloud_dialogflow_v2beta1_KnowledgeOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata build() {
      com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata buildPartial() {
      com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata result =
          new com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata(this);
      result.state_ = state_;
      result.knowledgeBase_ = knowledgeBase_;
      if (operationMetadataCase_ == 4) {
        if (exportOperationMetadataBuilder_ == null) {
          result.operationMetadata_ = operationMetadata_;
        } else {
          result.operationMetadata_ = exportOperationMetadataBuilder_.build();
        }
      }
      result.operationMetadataCase_ = operationMetadataCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata other) {
      if (other
          == com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.getDefaultInstance())
        return this;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getKnowledgeBase().isEmpty()) {
        knowledgeBase_ = other.knowledgeBase_;
        onChanged();
      }
      switch (other.getOperationMetadataCase()) {
        case EXPORT_OPERATION_METADATA:
          {
            mergeExportOperationMetadata(other.getExportOperationMetadata());
            break;
          }
        case OPERATIONMETADATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int operationMetadataCase_ = 0;
    private java.lang.Object operationMetadata_;

    public OperationMetadataCase getOperationMetadataCase() {
      return OperationMetadataCase.forNumber(operationMetadataCase_);
    }

    public Builder clearOperationMetadata() {
      operationMetadataCase_ = 0;
      operationMetadata_ = null;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Output only. The current state of this operation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Required. Output only. The current state of this operation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {

      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Output only. The current state of this operation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State result =
          com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State.valueOf(state_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Output only. The current state of this operation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(
        com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Output only. The current state of this operation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object knowledgeBase_ = "";
    /**
     *
     *
     * <pre>
     * The name of the knowledge base interacted with during the operation.
     * </pre>
     *
     * <code>string knowledge_base = 3;</code>
     *
     * @return The knowledgeBase.
     */
    public java.lang.String getKnowledgeBase() {
      java.lang.Object ref = knowledgeBase_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        knowledgeBase_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the knowledge base interacted with during the operation.
     * </pre>
     *
     * <code>string knowledge_base = 3;</code>
     *
     * @return The bytes for knowledgeBase.
     */
    public com.google.protobuf.ByteString getKnowledgeBaseBytes() {
      java.lang.Object ref = knowledgeBase_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        knowledgeBase_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the knowledge base interacted with during the operation.
     * </pre>
     *
     * <code>string knowledge_base = 3;</code>
     *
     * @param value The knowledgeBase to set.
     * @return This builder for chaining.
     */
    public Builder setKnowledgeBase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      knowledgeBase_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the knowledge base interacted with during the operation.
     * </pre>
     *
     * <code>string knowledge_base = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKnowledgeBase() {

      knowledgeBase_ = getDefaultInstance().getKnowledgeBase();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the knowledge base interacted with during the operation.
     * </pre>
     *
     * <code>string knowledge_base = 3;</code>
     *
     * @param value The bytes for knowledgeBase to set.
     * @return This builder for chaining.
     */
    public Builder setKnowledgeBaseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      knowledgeBase_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata,
            com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.Builder,
            com.google.cloud.dialogflow.v2beta1.ExportOperationMetadataOrBuilder>
        exportOperationMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata for the Export Data Operation such as the destination of export.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.ExportOperationMetadata export_operation_metadata = 4;
     * </code>
     *
     * @return Whether the exportOperationMetadata field is set.
     */
    @java.lang.Override
    public boolean hasExportOperationMetadata() {
      return operationMetadataCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the Export Data Operation such as the destination of export.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.ExportOperationMetadata export_operation_metadata = 4;
     * </code>
     *
     * @return The exportOperationMetadata.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata
        getExportOperationMetadata() {
      if (exportOperationMetadataBuilder_ == null) {
        if (operationMetadataCase_ == 4) {
          return (com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata) operationMetadata_;
        }
        return com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.getDefaultInstance();
      } else {
        if (operationMetadataCase_ == 4) {
          return exportOperationMetadataBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for the Export Data Operation such as the destination of export.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.ExportOperationMetadata export_operation_metadata = 4;
     * </code>
     */
    public Builder setExportOperationMetadata(
        com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata value) {
      if (exportOperationMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operationMetadata_ = value;
        onChanged();
      } else {
        exportOperationMetadataBuilder_.setMessage(value);
      }
      operationMetadataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the Export Data Operation such as the destination of export.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.ExportOperationMetadata export_operation_metadata = 4;
     * </code>
     */
    public Builder setExportOperationMetadata(
        com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.Builder builderForValue) {
      if (exportOperationMetadataBuilder_ == null) {
        operationMetadata_ = builderForValue.build();
        onChanged();
      } else {
        exportOperationMetadataBuilder_.setMessage(builderForValue.build());
      }
      operationMetadataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the Export Data Operation such as the destination of export.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.ExportOperationMetadata export_operation_metadata = 4;
     * </code>
     */
    public Builder mergeExportOperationMetadata(
        com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata value) {
      if (exportOperationMetadataBuilder_ == null) {
        if (operationMetadataCase_ == 4
            && operationMetadata_
                != com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata
                    .getDefaultInstance()) {
          operationMetadata_ =
              com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata)
                          operationMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operationMetadata_ = value;
        }
        onChanged();
      } else {
        if (operationMetadataCase_ == 4) {
          exportOperationMetadataBuilder_.mergeFrom(value);
        } else {
          exportOperationMetadataBuilder_.setMessage(value);
        }
      }
      operationMetadataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the Export Data Operation such as the destination of export.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.ExportOperationMetadata export_operation_metadata = 4;
     * </code>
     */
    public Builder clearExportOperationMetadata() {
      if (exportOperationMetadataBuilder_ == null) {
        if (operationMetadataCase_ == 4) {
          operationMetadataCase_ = 0;
          operationMetadata_ = null;
          onChanged();
        }
      } else {
        if (operationMetadataCase_ == 4) {
          operationMetadataCase_ = 0;
          operationMetadata_ = null;
        }
        exportOperationMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata for the Export Data Operation such as the destination of export.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.ExportOperationMetadata export_operation_metadata = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.Builder
        getExportOperationMetadataBuilder() {
      return getExportOperationMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata for the Export Data Operation such as the destination of export.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.ExportOperationMetadata export_operation_metadata = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.ExportOperationMetadataOrBuilder
        getExportOperationMetadataOrBuilder() {
      if ((operationMetadataCase_ == 4) && (exportOperationMetadataBuilder_ != null)) {
        return exportOperationMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (operationMetadataCase_ == 4) {
          return (com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata) operationMetadata_;
        }
        return com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata for the Export Data Operation such as the destination of export.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.ExportOperationMetadata export_operation_metadata = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata,
            com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.Builder,
            com.google.cloud.dialogflow.v2beta1.ExportOperationMetadataOrBuilder>
        getExportOperationMetadataFieldBuilder() {
      if (exportOperationMetadataBuilder_ == null) {
        if (!(operationMetadataCase_ == 4)) {
          operationMetadata_ =
              com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.getDefaultInstance();
        }
        exportOperationMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata,
                com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata.Builder,
                com.google.cloud.dialogflow.v2beta1.ExportOperationMetadataOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.ExportOperationMetadata) operationMetadata_,
                getParentForChildren(),
                isClean());
        operationMetadata_ = null;
      }
      operationMetadataCase_ = 4;
      onChanged();
      ;
      return exportOperationMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata)
  private static final com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata();
  }

  public static com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KnowledgeOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<KnowledgeOperationMetadata>() {
        @java.lang.Override
        public KnowledgeOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new KnowledgeOperationMetadata(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<KnowledgeOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KnowledgeOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
