/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/session.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents the query input. It can contain either:
 * 1.  An audio config which
 *     instructs the speech recognizer how to process the speech audio.
 * 2.  A conversational query in the form of text.
 * 3.  An event that specifies which intent to trigger.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.QueryInput}
 */
public final class QueryInput extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.QueryInput)
    QueryInputOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QueryInput.newBuilder() to construct.
  private QueryInput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QueryInput() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QueryInput();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.SessionProto
        .internal_static_google_cloud_dialogflow_v2beta1_QueryInput_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.SessionProto
        .internal_static_google_cloud_dialogflow_v2beta1_QueryInput_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.QueryInput.class,
            com.google.cloud.dialogflow.v2beta1.QueryInput.Builder.class);
  }

  private int inputCase_ = 0;
  private java.lang.Object input_;

  public enum InputCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AUDIO_CONFIG(1),
    TEXT(2),
    EVENT(3),
    DTMF(4),
    INPUT_NOT_SET(0);
    private final int value;

    private InputCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InputCase valueOf(int value) {
      return forNumber(value);
    }

    public static InputCase forNumber(int value) {
      switch (value) {
        case 1:
          return AUDIO_CONFIG;
        case 2:
          return TEXT;
        case 3:
          return EVENT;
        case 4:
          return DTMF;
        case 0:
          return INPUT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public InputCase getInputCase() {
    return InputCase.forNumber(inputCase_);
  }

  public static final int AUDIO_CONFIG_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Instructs the speech recognizer how to process the speech audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 1;</code>
   *
   * @return Whether the audioConfig field is set.
   */
  @java.lang.Override
  public boolean hasAudioConfig() {
    return inputCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Instructs the speech recognizer how to process the speech audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 1;</code>
   *
   * @return The audioConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.InputAudioConfig getAudioConfig() {
    if (inputCase_ == 1) {
      return (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Instructs the speech recognizer how to process the speech audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder getAudioConfigOrBuilder() {
    if (inputCase_ == 1) {
      return (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
  }

  public static final int TEXT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TextInput text = 2;</code>
   *
   * @return Whether the text field is set.
   */
  @java.lang.Override
  public boolean hasText() {
    return inputCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TextInput text = 2;</code>
   *
   * @return The text.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TextInput getText() {
    if (inputCase_ == 2) {
      return (com.google.cloud.dialogflow.v2beta1.TextInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TextInput text = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder getTextOrBuilder() {
    if (inputCase_ == 2) {
      return (com.google.cloud.dialogflow.v2beta1.TextInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance();
  }

  public static final int EVENT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The event to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.EventInput event = 3;</code>
   *
   * @return Whether the event field is set.
   */
  @java.lang.Override
  public boolean hasEvent() {
    return inputCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The event to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.EventInput event = 3;</code>
   *
   * @return The event.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.EventInput getEvent() {
    if (inputCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.EventInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The event to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.EventInput event = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder getEventOrBuilder() {
    if (inputCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.EventInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance();
  }

  public static final int DTMF_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The DTMF digits used to invoke intent and fill in parameter value.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents dtmf = 4;</code>
   *
   * @return Whether the dtmf field is set.
   */
  @java.lang.Override
  public boolean hasDtmf() {
    return inputCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The DTMF digits used to invoke intent and fill in parameter value.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents dtmf = 4;</code>
   *
   * @return The dtmf.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents getDtmf() {
    if (inputCase_ == 4) {
      return (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The DTMF digits used to invoke intent and fill in parameter value.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents dtmf = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder getDtmfOrBuilder() {
    if (inputCase_ == 4) {
      return (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (inputCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) input_);
    }
    if (inputCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.dialogflow.v2beta1.TextInput) input_);
    }
    if (inputCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.dialogflow.v2beta1.EventInput) input_);
    }
    if (inputCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (inputCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) input_);
    }
    if (inputCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dialogflow.v2beta1.TextInput) input_);
    }
    if (inputCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dialogflow.v2beta1.EventInput) input_);
    }
    if (inputCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.QueryInput)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.QueryInput other =
        (com.google.cloud.dialogflow.v2beta1.QueryInput) obj;

    if (!getInputCase().equals(other.getInputCase())) return false;
    switch (inputCase_) {
      case 1:
        if (!getAudioConfig().equals(other.getAudioConfig())) return false;
        break;
      case 2:
        if (!getText().equals(other.getText())) return false;
        break;
      case 3:
        if (!getEvent().equals(other.getEvent())) return false;
        break;
      case 4:
        if (!getDtmf().equals(other.getDtmf())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (inputCase_) {
      case 1:
        hash = (37 * hash) + AUDIO_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getAudioConfig().hashCode();
        break;
      case 2:
        hash = (37 * hash) + TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getText().hashCode();
        break;
      case 3:
        hash = (37 * hash) + EVENT_FIELD_NUMBER;
        hash = (53 * hash) + getEvent().hashCode();
        break;
      case 4:
        hash = (37 * hash) + DTMF_FIELD_NUMBER;
        hash = (53 * hash) + getDtmf().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryInput parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryInput parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryInput parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryInput parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryInput parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryInput parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryInput parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryInput parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryInput parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryInput parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryInput parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryInput parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.QueryInput prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the query input. It can contain either:
   * 1.  An audio config which
   *     instructs the speech recognizer how to process the speech audio.
   * 2.  A conversational query in the form of text.
   * 3.  An event that specifies which intent to trigger.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.QueryInput}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.QueryInput)
      com.google.cloud.dialogflow.v2beta1.QueryInputOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_QueryInput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_QueryInput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.QueryInput.class,
              com.google.cloud.dialogflow.v2beta1.QueryInput.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.QueryInput.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (audioConfigBuilder_ != null) {
        audioConfigBuilder_.clear();
      }
      if (textBuilder_ != null) {
        textBuilder_.clear();
      }
      if (eventBuilder_ != null) {
        eventBuilder_.clear();
      }
      if (dtmfBuilder_ != null) {
        dtmfBuilder_.clear();
      }
      inputCase_ = 0;
      input_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_QueryInput_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.QueryInput getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.QueryInput.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.QueryInput build() {
      com.google.cloud.dialogflow.v2beta1.QueryInput result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.QueryInput buildPartial() {
      com.google.cloud.dialogflow.v2beta1.QueryInput result =
          new com.google.cloud.dialogflow.v2beta1.QueryInput(this);
      if (inputCase_ == 1) {
        if (audioConfigBuilder_ == null) {
          result.input_ = input_;
        } else {
          result.input_ = audioConfigBuilder_.build();
        }
      }
      if (inputCase_ == 2) {
        if (textBuilder_ == null) {
          result.input_ = input_;
        } else {
          result.input_ = textBuilder_.build();
        }
      }
      if (inputCase_ == 3) {
        if (eventBuilder_ == null) {
          result.input_ = input_;
        } else {
          result.input_ = eventBuilder_.build();
        }
      }
      if (inputCase_ == 4) {
        if (dtmfBuilder_ == null) {
          result.input_ = input_;
        } else {
          result.input_ = dtmfBuilder_.build();
        }
      }
      result.inputCase_ = inputCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.QueryInput) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.QueryInput) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.QueryInput other) {
      if (other == com.google.cloud.dialogflow.v2beta1.QueryInput.getDefaultInstance()) return this;
      switch (other.getInputCase()) {
        case AUDIO_CONFIG:
          {
            mergeAudioConfig(other.getAudioConfig());
            break;
          }
        case TEXT:
          {
            mergeText(other.getText());
            break;
          }
        case EVENT:
          {
            mergeEvent(other.getEvent());
            break;
          }
        case DTMF:
          {
            mergeDtmf(other.getDtmf());
            break;
          }
        case INPUT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAudioConfigFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTextFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getEventFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDtmfFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int inputCase_ = 0;
    private java.lang.Object input_;

    public InputCase getInputCase() {
      return InputCase.forNumber(inputCase_);
    }

    public Builder clearInput() {
      inputCase_ = 0;
      input_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder>
        audioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 1;</code>
     *
     * @return Whether the audioConfig field is set.
     */
    @java.lang.Override
    public boolean hasAudioConfig() {
      return inputCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 1;</code>
     *
     * @return The audioConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.InputAudioConfig getAudioConfig() {
      if (audioConfigBuilder_ == null) {
        if (inputCase_ == 1) {
          return (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
      } else {
        if (inputCase_ == 1) {
          return audioConfigBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 1;</code>
     */
    public Builder setAudioConfig(com.google.cloud.dialogflow.v2beta1.InputAudioConfig value) {
      if (audioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        audioConfigBuilder_.setMessage(value);
      }
      inputCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 1;</code>
     */
    public Builder setAudioConfig(
        com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder builderForValue) {
      if (audioConfigBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        audioConfigBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 1;</code>
     */
    public Builder mergeAudioConfig(com.google.cloud.dialogflow.v2beta1.InputAudioConfig value) {
      if (audioConfigBuilder_ == null) {
        if (inputCase_ == 1
            && input_
                != com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.v2beta1.InputAudioConfig.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 1) {
          audioConfigBuilder_.mergeFrom(value);
        } else {
          audioConfigBuilder_.setMessage(value);
        }
      }
      inputCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 1;</code>
     */
    public Builder clearAudioConfig() {
      if (audioConfigBuilder_ == null) {
        if (inputCase_ == 1) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 1) {
          inputCase_ = 0;
          input_ = null;
        }
        audioConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 1;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder getAudioConfigBuilder() {
      return getAudioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder getAudioConfigOrBuilder() {
      if ((inputCase_ == 1) && (audioConfigBuilder_ != null)) {
        return audioConfigBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 1) {
          return (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Instructs the speech recognizer how to process the speech audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.InputAudioConfig audio_config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder>
        getAudioConfigFieldBuilder() {
      if (audioConfigBuilder_ == null) {
        if (!(inputCase_ == 1)) {
          input_ = com.google.cloud.dialogflow.v2beta1.InputAudioConfig.getDefaultInstance();
        }
        audioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.InputAudioConfig,
                com.google.cloud.dialogflow.v2beta1.InputAudioConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.InputAudioConfigOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.InputAudioConfig) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 1;
      onChanged();
      ;
      return audioConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TextInput,
            com.google.cloud.dialogflow.v2beta1.TextInput.Builder,
            com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder>
        textBuilder_;
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text = 2;</code>
     *
     * @return Whether the text field is set.
     */
    @java.lang.Override
    public boolean hasText() {
      return inputCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text = 2;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TextInput getText() {
      if (textBuilder_ == null) {
        if (inputCase_ == 2) {
          return (com.google.cloud.dialogflow.v2beta1.TextInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance();
      } else {
        if (inputCase_ == 2) {
          return textBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text = 2;</code>
     */
    public Builder setText(com.google.cloud.dialogflow.v2beta1.TextInput value) {
      if (textBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        textBuilder_.setMessage(value);
      }
      inputCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text = 2;</code>
     */
    public Builder setText(com.google.cloud.dialogflow.v2beta1.TextInput.Builder builderForValue) {
      if (textBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        textBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text = 2;</code>
     */
    public Builder mergeText(com.google.cloud.dialogflow.v2beta1.TextInput value) {
      if (textBuilder_ == null) {
        if (inputCase_ == 2
            && input_ != com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.v2beta1.TextInput.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.TextInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 2) {
          textBuilder_.mergeFrom(value);
        } else {
          textBuilder_.setMessage(value);
        }
      }
      inputCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text = 2;</code>
     */
    public Builder clearText() {
      if (textBuilder_ == null) {
        if (inputCase_ == 2) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 2) {
          inputCase_ = 0;
          input_ = null;
        }
        textBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.TextInput.Builder getTextBuilder() {
      return getTextFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder getTextOrBuilder() {
      if ((inputCase_ == 2) && (textBuilder_ != null)) {
        return textBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 2) {
          return (com.google.cloud.dialogflow.v2beta1.TextInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TextInput,
            com.google.cloud.dialogflow.v2beta1.TextInput.Builder,
            com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder>
        getTextFieldBuilder() {
      if (textBuilder_ == null) {
        if (!(inputCase_ == 2)) {
          input_ = com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance();
        }
        textBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.TextInput,
                com.google.cloud.dialogflow.v2beta1.TextInput.Builder,
                com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.TextInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 2;
      onChanged();
      ;
      return textBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.EventInput,
            com.google.cloud.dialogflow.v2beta1.EventInput.Builder,
            com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder>
        eventBuilder_;
    /**
     *
     *
     * <pre>
     * The event to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event = 3;</code>
     *
     * @return Whether the event field is set.
     */
    @java.lang.Override
    public boolean hasEvent() {
      return inputCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The event to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event = 3;</code>
     *
     * @return The event.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.EventInput getEvent() {
      if (eventBuilder_ == null) {
        if (inputCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.EventInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance();
      } else {
        if (inputCase_ == 3) {
          return eventBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The event to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event = 3;</code>
     */
    public Builder setEvent(com.google.cloud.dialogflow.v2beta1.EventInput value) {
      if (eventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        eventBuilder_.setMessage(value);
      }
      inputCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event = 3;</code>
     */
    public Builder setEvent(
        com.google.cloud.dialogflow.v2beta1.EventInput.Builder builderForValue) {
      if (eventBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        eventBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event = 3;</code>
     */
    public Builder mergeEvent(com.google.cloud.dialogflow.v2beta1.EventInput value) {
      if (eventBuilder_ == null) {
        if (inputCase_ == 3
            && input_ != com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.v2beta1.EventInput.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.EventInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 3) {
          eventBuilder_.mergeFrom(value);
        } else {
          eventBuilder_.setMessage(value);
        }
      }
      inputCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event = 3;</code>
     */
    public Builder clearEvent() {
      if (eventBuilder_ == null) {
        if (inputCase_ == 3) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 3) {
          inputCase_ = 0;
          input_ = null;
        }
        eventBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The event to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.EventInput.Builder getEventBuilder() {
      return getEventFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The event to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder getEventOrBuilder() {
      if ((inputCase_ == 3) && (eventBuilder_ != null)) {
        return eventBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.EventInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The event to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.EventInput,
            com.google.cloud.dialogflow.v2beta1.EventInput.Builder,
            com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder>
        getEventFieldBuilder() {
      if (eventBuilder_ == null) {
        if (!(inputCase_ == 3)) {
          input_ = com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance();
        }
        eventBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.EventInput,
                com.google.cloud.dialogflow.v2beta1.EventInput.Builder,
                com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.EventInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 3;
      onChanged();
      ;
      return eventBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents,
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder,
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder>
        dtmfBuilder_;
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents dtmf = 4;</code>
     *
     * @return Whether the dtmf field is set.
     */
    @java.lang.Override
    public boolean hasDtmf() {
      return inputCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents dtmf = 4;</code>
     *
     * @return The dtmf.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents getDtmf() {
      if (dtmfBuilder_ == null) {
        if (inputCase_ == 4) {
          return (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
      } else {
        if (inputCase_ == 4) {
          return dtmfBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents dtmf = 4;</code>
     */
    public Builder setDtmf(com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents value) {
      if (dtmfBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        dtmfBuilder_.setMessage(value);
      }
      inputCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents dtmf = 4;</code>
     */
    public Builder setDtmf(
        com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder builderForValue) {
      if (dtmfBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        dtmfBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents dtmf = 4;</code>
     */
    public Builder mergeDtmf(com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents value) {
      if (dtmfBuilder_ == null) {
        if (inputCase_ == 4
            && input_
                != com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 4) {
          dtmfBuilder_.mergeFrom(value);
        } else {
          dtmfBuilder_.setMessage(value);
        }
      }
      inputCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents dtmf = 4;</code>
     */
    public Builder clearDtmf() {
      if (dtmfBuilder_ == null) {
        if (inputCase_ == 4) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 4) {
          inputCase_ = 0;
          input_ = null;
        }
        dtmfBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents dtmf = 4;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder getDtmfBuilder() {
      return getDtmfFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents dtmf = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder getDtmfOrBuilder() {
      if ((inputCase_ == 4) && (dtmfBuilder_ != null)) {
        return dtmfBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 4) {
          return (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The DTMF digits used to invoke intent and fill in parameter value.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents dtmf = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents,
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder,
            com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder>
        getDtmfFieldBuilder() {
      if (dtmfBuilder_ == null) {
        if (!(inputCase_ == 4)) {
          input_ = com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.getDefaultInstance();
        }
        dtmfBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents,
                com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents.Builder,
                com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEventsOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 4;
      onChanged();
      ;
      return dtmfBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.QueryInput)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.QueryInput)
  private static final com.google.cloud.dialogflow.v2beta1.QueryInput DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.QueryInput();
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryInput getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QueryInput> PARSER =
      new com.google.protobuf.AbstractParser<QueryInput>() {
        @java.lang.Override
        public QueryInput parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QueryInput> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QueryInput> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryInput getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
