/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EnvironmentSessionEntityTypeName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/entityTypes/{entity_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String environment;
    private final String user;
    private final String session;
    private final String entityType;

    public String getProject() {
        return this.project;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getUser() {
        return this.user;
    }

    public String getSession() {
        return this.session;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private EnvironmentSessionEntityTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.entityType = (String)Preconditions.checkNotNull((Object)builder.getEntityType());
    }

    public static EnvironmentSessionEntityTypeName of(String project, String environment, String user, String session, String entityType) {
        return EnvironmentSessionEntityTypeName.newBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).setEntityType(entityType).build();
    }

    public static String format(String project, String environment, String user, String session, String entityType) {
        return EnvironmentSessionEntityTypeName.newBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).setEntityType(entityType).build().toString();
    }

    public static EnvironmentSessionEntityTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "EnvironmentSessionEntityTypeName.parse: formattedString not in valid format");
        return EnvironmentSessionEntityTypeName.of((String)matchMap.get("project"), (String)matchMap.get("environment"), (String)matchMap.get("user"), (String)matchMap.get("session"), (String)matchMap.get("entity_type"));
    }

    public static List<EnvironmentSessionEntityTypeName> parseList(List<String> formattedStrings) {
        ArrayList<EnvironmentSessionEntityTypeName> list = new ArrayList<EnvironmentSessionEntityTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EnvironmentSessionEntityTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EnvironmentSessionEntityTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EnvironmentSessionEntityTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EnvironmentSessionEntityTypeName environmentSessionEntityTypeName = this;
            synchronized (environmentSessionEntityTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    fieldMapBuilder.put((Object)"user", (Object)this.user);
                    fieldMapBuilder.put((Object)"session", (Object)this.session);
                    fieldMapBuilder.put((Object)"entityType", (Object)this.entityType);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("EnvironmentSessionEntityTypeName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "environment", this.environment, "user", this.user, "session", this.session, "entity_type", this.entityType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EnvironmentSessionEntityTypeName) {
            EnvironmentSessionEntityTypeName that = (EnvironmentSessionEntityTypeName)o;
            return this.project.equals(that.project) && this.environment.equals(that.environment) && this.user.equals(that.user) && this.session.equals(that.session) && this.entityType.equals(that.entityType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.environment.hashCode();
        h *= 1000003;
        h ^= this.user.hashCode();
        h *= 1000003;
        h ^= this.session.hashCode();
        h *= 1000003;
        return h ^= this.entityType.hashCode();
    }

    public static class Builder {
        private String project;
        private String environment;
        private String user;
        private String session;
        private String entityType;

        public String getProject() {
            return this.project;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getUser() {
            return this.user;
        }

        public String getSession() {
            return this.session;
        }

        public String getEntityType() {
            return this.entityType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        public Builder setEntityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        private Builder() {
        }

        private Builder(EnvironmentSessionEntityTypeName environmentSessionEntityTypeName) {
            this.project = environmentSessionEntityTypeName.project;
            this.environment = environmentSessionEntityTypeName.environment;
            this.user = environmentSessionEntityTypeName.user;
            this.session = environmentSessionEntityTypeName.session;
            this.entityType = environmentSessionEntityTypeName.entityType;
        }

        public EnvironmentSessionEntityTypeName build() {
            return new EnvironmentSessionEntityTypeName(this);
        }
    }
}

