/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/context.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Dialogflow contexts are similar to natural language context. If a person says
 * to you "they are orange", you need context in order to understand what "they"
 * is referring to. Similarly, for Dialogflow to handle an end-user expression
 * like that, it needs to be provided with context in order to correctly match
 * an intent.
 * Using contexts, you can control the flow of a conversation. You can configure
 * contexts for an intent by setting input and output contexts, which are
 * identified by string names. When an intent is matched, any configured output
 * contexts for that intent become active. While any contexts are active,
 * Dialogflow is more likely to match intents that are configured with input
 * contexts that correspond to the currently active contexts.
 * For more information about context, see the
 * [Contexts guide](https://cloud.google.com/dialogflow/docs/contexts-overview).
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.Context}
 */
public final class Context extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Context)
    ContextOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Context.newBuilder() to construct.
  private Context(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Context() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Context();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ContextProto
        .internal_static_google_cloud_dialogflow_v2beta1_Context_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ContextProto
        .internal_static_google_cloud_dialogflow_v2beta1_Context_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.Context.class,
            com.google.cloud.dialogflow.v2beta1.Context.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The unique identifier of the context. Supported formats:
   * - `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;/contexts/&lt;Context
   *   ID&gt;`,
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/sessions/&lt;Session
   *   ID&gt;/contexts/&lt;Context ID&gt;`,
   * - `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
   *   ID&gt;/sessions/&lt;Session ID&gt;/contexts/&lt;Context ID&gt;`,
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location
   *   ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User ID&gt;/sessions/&lt;Session
   *   ID&gt;/contexts/&lt;Context ID&gt;`,
   * The `Context ID` is always converted to lowercase, may only contain
   * characters in a-zA-Z0-9_-% and may be at most 250 bytes long.
   * If `Environment ID` is not specified, we assume default 'draft'
   * environment. If `User ID` is not specified, we assume default '-' user.
   * The following context names are reserved for internal use by Dialogflow.
   * You should not use these contexts or create contexts with these names:
   * * `__system_counters__`
   * * `*_id_dialog_context`
   * * `*_dialog_params_size`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique identifier of the context. Supported formats:
   * - `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;/contexts/&lt;Context
   *   ID&gt;`,
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/sessions/&lt;Session
   *   ID&gt;/contexts/&lt;Context ID&gt;`,
   * - `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
   *   ID&gt;/sessions/&lt;Session ID&gt;/contexts/&lt;Context ID&gt;`,
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location
   *   ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User ID&gt;/sessions/&lt;Session
   *   ID&gt;/contexts/&lt;Context ID&gt;`,
   * The `Context ID` is always converted to lowercase, may only contain
   * characters in a-zA-Z0-9_-% and may be at most 250 bytes long.
   * If `Environment ID` is not specified, we assume default 'draft'
   * environment. If `User ID` is not specified, we assume default '-' user.
   * The following context names are reserved for internal use by Dialogflow.
   * You should not use these contexts or create contexts with these names:
   * * `__system_counters__`
   * * `*_id_dialog_context`
   * * `*_dialog_params_size`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LIFESPAN_COUNT_FIELD_NUMBER = 2;
  private int lifespanCount_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The number of conversational query requests after which the
   * context expires. The default is `0`. If set to `0`, the context expires
   * immediately. Contexts expire automatically after 20 minutes if there
   * are no matching queries.
   * </pre>
   *
   * <code>int32 lifespan_count = 2;</code>
   *
   * @return The lifespanCount.
   */
  @java.lang.Override
  public int getLifespanCount() {
    return lifespanCount_;
  }

  public static final int PARAMETERS_FIELD_NUMBER = 3;
  private com.google.protobuf.Struct parameters_;
  /**
   *
   *
   * <pre>
   * Optional. The collection of parameters associated with this context.
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   * -   MapKey type: string
   * -   MapKey value: parameter name
   * -   MapValue type:
   *     -   If parameter's entity type is a composite entity: map
   *     -   Else: depending on parameter value type, could be one of string,
   *         number, boolean, null, list or map
   * -   MapValue value:
   *     -   If parameter's entity type is a composite entity:
   *         map from composite entity property names to property values
   *     -   Else: parameter value
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 3;</code>
   *
   * @return Whether the parameters field is set.
   */
  @java.lang.Override
  public boolean hasParameters() {
    return parameters_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The collection of parameters associated with this context.
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   * -   MapKey type: string
   * -   MapKey value: parameter name
   * -   MapValue type:
   *     -   If parameter's entity type is a composite entity: map
   *     -   Else: depending on parameter value type, could be one of string,
   *         number, boolean, null, list or map
   * -   MapValue value:
   *     -   If parameter's entity type is a composite entity:
   *         map from composite entity property names to property values
   *     -   Else: parameter value
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 3;</code>
   *
   * @return The parameters.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getParameters() {
    return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The collection of parameters associated with this context.
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   * -   MapKey type: string
   * -   MapKey value: parameter name
   * -   MapValue type:
   *     -   If parameter's entity type is a composite entity: map
   *     -   Else: depending on parameter value type, could be one of string,
   *         number, boolean, null, list or map
   * -   MapValue value:
   *     -   If parameter's entity type is a composite entity:
   *         map from composite entity property names to property values
   *     -   Else: parameter value
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
    return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (lifespanCount_ != 0) {
      output.writeInt32(2, lifespanCount_);
    }
    if (parameters_ != null) {
      output.writeMessage(3, getParameters());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (lifespanCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, lifespanCount_);
    }
    if (parameters_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getParameters());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.Context)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.Context other =
        (com.google.cloud.dialogflow.v2beta1.Context) obj;

    if (!getName().equals(other.getName())) return false;
    if (getLifespanCount() != other.getLifespanCount()) return false;
    if (hasParameters() != other.hasParameters()) return false;
    if (hasParameters()) {
      if (!getParameters().equals(other.getParameters())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LIFESPAN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getLifespanCount();
    if (hasParameters()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParameters().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.Context parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Context parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Context parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Context parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Context parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Context parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Context parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Context parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Context parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Context parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Context parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Context parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.Context prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Dialogflow contexts are similar to natural language context. If a person says
   * to you "they are orange", you need context in order to understand what "they"
   * is referring to. Similarly, for Dialogflow to handle an end-user expression
   * like that, it needs to be provided with context in order to correctly match
   * an intent.
   * Using contexts, you can control the flow of a conversation. You can configure
   * contexts for an intent by setting input and output contexts, which are
   * identified by string names. When an intent is matched, any configured output
   * contexts for that intent become active. While any contexts are active,
   * Dialogflow is more likely to match intents that are configured with input
   * contexts that correspond to the currently active contexts.
   * For more information about context, see the
   * [Contexts guide](https://cloud.google.com/dialogflow/docs/contexts-overview).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Context}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Context)
      com.google.cloud.dialogflow.v2beta1.ContextOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ContextProto
          .internal_static_google_cloud_dialogflow_v2beta1_Context_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ContextProto
          .internal_static_google_cloud_dialogflow_v2beta1_Context_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Context.class,
              com.google.cloud.dialogflow.v2beta1.Context.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.Context.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      lifespanCount_ = 0;
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ContextProto
          .internal_static_google_cloud_dialogflow_v2beta1_Context_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Context getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.Context.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Context build() {
      com.google.cloud.dialogflow.v2beta1.Context result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Context buildPartial() {
      com.google.cloud.dialogflow.v2beta1.Context result =
          new com.google.cloud.dialogflow.v2beta1.Context(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.Context result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.lifespanCount_ = lifespanCount_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parameters_ = parametersBuilder_ == null ? parameters_ : parametersBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.Context) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.Context) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.Context other) {
      if (other == com.google.cloud.dialogflow.v2beta1.Context.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getLifespanCount() != 0) {
        setLifespanCount(other.getLifespanCount());
      }
      if (other.hasParameters()) {
        mergeParameters(other.getParameters());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                lifespanCount_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the context. Supported formats:
     * - `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;/contexts/&lt;Context
     *   ID&gt;`,
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/sessions/&lt;Session
     *   ID&gt;/contexts/&lt;Context ID&gt;`,
     * - `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     *   ID&gt;/sessions/&lt;Session ID&gt;/contexts/&lt;Context ID&gt;`,
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location
     *   ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User ID&gt;/sessions/&lt;Session
     *   ID&gt;/contexts/&lt;Context ID&gt;`,
     * The `Context ID` is always converted to lowercase, may only contain
     * characters in a-zA-Z0-9_-% and may be at most 250 bytes long.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment. If `User ID` is not specified, we assume default '-' user.
     * The following context names are reserved for internal use by Dialogflow.
     * You should not use these contexts or create contexts with these names:
     * * `__system_counters__`
     * * `*_id_dialog_context`
     * * `*_dialog_params_size`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the context. Supported formats:
     * - `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;/contexts/&lt;Context
     *   ID&gt;`,
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/sessions/&lt;Session
     *   ID&gt;/contexts/&lt;Context ID&gt;`,
     * - `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     *   ID&gt;/sessions/&lt;Session ID&gt;/contexts/&lt;Context ID&gt;`,
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location
     *   ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User ID&gt;/sessions/&lt;Session
     *   ID&gt;/contexts/&lt;Context ID&gt;`,
     * The `Context ID` is always converted to lowercase, may only contain
     * characters in a-zA-Z0-9_-% and may be at most 250 bytes long.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment. If `User ID` is not specified, we assume default '-' user.
     * The following context names are reserved for internal use by Dialogflow.
     * You should not use these contexts or create contexts with these names:
     * * `__system_counters__`
     * * `*_id_dialog_context`
     * * `*_dialog_params_size`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the context. Supported formats:
     * - `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;/contexts/&lt;Context
     *   ID&gt;`,
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/sessions/&lt;Session
     *   ID&gt;/contexts/&lt;Context ID&gt;`,
     * - `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     *   ID&gt;/sessions/&lt;Session ID&gt;/contexts/&lt;Context ID&gt;`,
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location
     *   ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User ID&gt;/sessions/&lt;Session
     *   ID&gt;/contexts/&lt;Context ID&gt;`,
     * The `Context ID` is always converted to lowercase, may only contain
     * characters in a-zA-Z0-9_-% and may be at most 250 bytes long.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment. If `User ID` is not specified, we assume default '-' user.
     * The following context names are reserved for internal use by Dialogflow.
     * You should not use these contexts or create contexts with these names:
     * * `__system_counters__`
     * * `*_id_dialog_context`
     * * `*_dialog_params_size`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the context. Supported formats:
     * - `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;/contexts/&lt;Context
     *   ID&gt;`,
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/sessions/&lt;Session
     *   ID&gt;/contexts/&lt;Context ID&gt;`,
     * - `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     *   ID&gt;/sessions/&lt;Session ID&gt;/contexts/&lt;Context ID&gt;`,
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location
     *   ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User ID&gt;/sessions/&lt;Session
     *   ID&gt;/contexts/&lt;Context ID&gt;`,
     * The `Context ID` is always converted to lowercase, may only contain
     * characters in a-zA-Z0-9_-% and may be at most 250 bytes long.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment. If `User ID` is not specified, we assume default '-' user.
     * The following context names are reserved for internal use by Dialogflow.
     * You should not use these contexts or create contexts with these names:
     * * `__system_counters__`
     * * `*_id_dialog_context`
     * * `*_dialog_params_size`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the context. Supported formats:
     * - `projects/&lt;Project ID&gt;/agent/sessions/&lt;Session ID&gt;/contexts/&lt;Context
     *   ID&gt;`,
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/sessions/&lt;Session
     *   ID&gt;/contexts/&lt;Context ID&gt;`,
     * - `projects/&lt;Project ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User
     *   ID&gt;/sessions/&lt;Session ID&gt;/contexts/&lt;Context ID&gt;`,
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location
     *   ID&gt;/agent/environments/&lt;Environment ID&gt;/users/&lt;User ID&gt;/sessions/&lt;Session
     *   ID&gt;/contexts/&lt;Context ID&gt;`,
     * The `Context ID` is always converted to lowercase, may only contain
     * characters in a-zA-Z0-9_-% and may be at most 250 bytes long.
     * If `Environment ID` is not specified, we assume default 'draft'
     * environment. If `User ID` is not specified, we assume default '-' user.
     * The following context names are reserved for internal use by Dialogflow.
     * You should not use these contexts or create contexts with these names:
     * * `__system_counters__`
     * * `*_id_dialog_context`
     * * `*_dialog_params_size`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int lifespanCount_;
    /**
     *
     *
     * <pre>
     * Optional. The number of conversational query requests after which the
     * context expires. The default is `0`. If set to `0`, the context expires
     * immediately. Contexts expire automatically after 20 minutes if there
     * are no matching queries.
     * </pre>
     *
     * <code>int32 lifespan_count = 2;</code>
     *
     * @return The lifespanCount.
     */
    @java.lang.Override
    public int getLifespanCount() {
      return lifespanCount_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of conversational query requests after which the
     * context expires. The default is `0`. If set to `0`, the context expires
     * immediately. Contexts expire automatically after 20 minutes if there
     * are no matching queries.
     * </pre>
     *
     * <code>int32 lifespan_count = 2;</code>
     *
     * @param value The lifespanCount to set.
     * @return This builder for chaining.
     */
    public Builder setLifespanCount(int value) {

      lifespanCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The number of conversational query requests after which the
     * context expires. The default is `0`. If set to `0`, the context expires
     * immediately. Contexts expire automatically after 20 minutes if there
     * are no matching queries.
     * </pre>
     *
     * <code>int32 lifespan_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLifespanCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      lifespanCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct parameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        parametersBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The collection of parameters associated with this context.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * -   MapKey type: string
     * -   MapKey value: parameter name
     * -   MapValue type:
     *     -   If parameter's entity type is a composite entity: map
     *     -   Else: depending on parameter value type, could be one of string,
     *         number, boolean, null, list or map
     * -   MapValue value:
     *     -   If parameter's entity type is a composite entity:
     *         map from composite entity property names to property values
     *     -   Else: parameter value
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     *
     * @return Whether the parameters field is set.
     */
    public boolean hasParameters() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of parameters associated with this context.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * -   MapKey type: string
     * -   MapKey value: parameter name
     * -   MapValue type:
     *     -   If parameter's entity type is a composite entity: map
     *     -   Else: depending on parameter value type, could be one of string,
     *         number, boolean, null, list or map
     * -   MapValue value:
     *     -   If parameter's entity type is a composite entity:
     *         map from composite entity property names to property values
     *     -   Else: parameter value
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     *
     * @return The parameters.
     */
    public com.google.protobuf.Struct getParameters() {
      if (parametersBuilder_ == null) {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      } else {
        return parametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of parameters associated with this context.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * -   MapKey type: string
     * -   MapKey value: parameter name
     * -   MapValue type:
     *     -   If parameter's entity type is a composite entity: map
     *     -   Else: depending on parameter value type, could be one of string,
     *         number, boolean, null, list or map
     * -   MapValue value:
     *     -   If parameter's entity type is a composite entity:
     *         map from composite entity property names to property values
     *     -   Else: parameter value
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameters_ = value;
      } else {
        parametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of parameters associated with this context.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * -   MapKey type: string
     * -   MapKey value: parameter name
     * -   MapValue type:
     *     -   If parameter's entity type is a composite entity: map
     *     -   Else: depending on parameter value type, could be one of string,
     *         number, boolean, null, list or map
     * -   MapValue value:
     *     -   If parameter's entity type is a composite entity:
     *         map from composite entity property names to property values
     *     -   Else: parameter value
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        parameters_ = builderForValue.build();
      } else {
        parametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of parameters associated with this context.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * -   MapKey type: string
     * -   MapKey value: parameter name
     * -   MapValue type:
     *     -   If parameter's entity type is a composite entity: map
     *     -   Else: depending on parameter value type, could be one of string,
     *         number, boolean, null, list or map
     * -   MapValue value:
     *     -   If parameter's entity type is a composite entity:
     *         map from composite entity property names to property values
     *     -   Else: parameter value
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    public Builder mergeParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && parameters_ != null
            && parameters_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getParametersBuilder().mergeFrom(value);
        } else {
          parameters_ = value;
        }
      } else {
        parametersBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of parameters associated with this context.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * -   MapKey type: string
     * -   MapKey value: parameter name
     * -   MapValue type:
     *     -   If parameter's entity type is a composite entity: map
     *     -   Else: depending on parameter value type, could be one of string,
     *         number, boolean, null, list or map
     * -   MapValue value:
     *     -   If parameter's entity type is a composite entity:
     *         map from composite entity property names to property values
     *     -   Else: parameter value
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    public Builder clearParameters() {
      bitField0_ = (bitField0_ & ~0x00000004);
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of parameters associated with this context.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * -   MapKey type: string
     * -   MapKey value: parameter name
     * -   MapValue type:
     *     -   If parameter's entity type is a composite entity: map
     *     -   Else: depending on parameter value type, could be one of string,
     *         number, boolean, null, list or map
     * -   MapValue value:
     *     -   If parameter's entity type is a composite entity:
     *         map from composite entity property names to property values
     *     -   Else: parameter value
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    public com.google.protobuf.Struct.Builder getParametersBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of parameters associated with this context.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * -   MapKey type: string
     * -   MapKey value: parameter name
     * -   MapValue type:
     *     -   If parameter's entity type is a composite entity: map
     *     -   Else: depending on parameter value type, could be one of string,
     *         number, boolean, null, list or map
     * -   MapValue value:
     *     -   If parameter's entity type is a composite entity:
     *         map from composite entity property names to property values
     *     -   Else: parameter value
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilder();
      } else {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of parameters associated with this context.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * -   MapKey type: string
     * -   MapKey value: parameter name
     * -   MapValue type:
     *     -   If parameter's entity type is a composite entity: map
     *     -   Else: depending on parameter value type, could be one of string,
     *         number, boolean, null, list or map
     * -   MapValue value:
     *     -   If parameter's entity type is a composite entity:
     *         map from composite entity property names to property values
     *     -   Else: parameter value
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getParameters(), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Context)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Context)
  private static final com.google.cloud.dialogflow.v2beta1.Context DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.Context();
  }

  public static com.google.cloud.dialogflow.v2beta1.Context getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Context> PARSER =
      new com.google.protobuf.AbstractParser<Context>() {
        @java.lang.Override
        public Context parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Context> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Context> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Context getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
