/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/session.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * The top-level message returned from the
 * `StreamingDetectIntent` method.
 * Multiple response messages can be returned in order:
 * 1.  If the `StreamingDetectIntentRequest.input_audio` field was
 *     set, the `recognition_result` field is populated for one
 *     or more messages.
 *     See the [StreamingRecognitionResult][google.cloud.dialogflow.v2beta1.StreamingRecognitionResult] message for details
 *     about the result message sequence.
 * 2.  The next message contains `response_id`, `query_result`,
 *     `alternative_query_results` and optionally `webhook_status` if a WebHook
 *     was called.
 * 3.  If `output_audio_config` was specified in the request or agent-level
 *     speech synthesizer is configured, all subsequent messages contain
 *     `output_audio` and `output_audio_config`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse}
 */
public final class StreamingDetectIntentResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse)
    StreamingDetectIntentResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamingDetectIntentResponse.newBuilder() to construct.
  private StreamingDetectIntentResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingDetectIntentResponse() {
    responseId_ = "";
    alternativeQueryResults_ = java.util.Collections.emptyList();
    outputAudio_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingDetectIntentResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.SessionProto
        .internal_static_google_cloud_dialogflow_v2beta1_StreamingDetectIntentResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.SessionProto
        .internal_static_google_cloud_dialogflow_v2beta1_StreamingDetectIntentResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse.class,
            com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse.Builder.class);
  }

  public static final int RESPONSE_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object responseId_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the response. It can be used to
   * locate a response in the training example set or for reporting issues.
   * </pre>
   *
   * <code>string response_id = 1;</code>
   *
   * @return The responseId.
   */
  @java.lang.Override
  public java.lang.String getResponseId() {
    java.lang.Object ref = responseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      responseId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the response. It can be used to
   * locate a response in the training example set or for reporting issues.
   * </pre>
   *
   * <code>string response_id = 1;</code>
   *
   * @return The bytes for responseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResponseIdBytes() {
    java.lang.Object ref = responseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      responseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECOGNITION_RESULT_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognitionResult_;
  /**
   *
   *
   * <pre>
   * The result of speech recognition.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognition_result = 2;
   * </code>
   *
   * @return Whether the recognitionResult field is set.
   */
  @java.lang.Override
  public boolean hasRecognitionResult() {
    return recognitionResult_ != null;
  }
  /**
   *
   *
   * <pre>
   * The result of speech recognition.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognition_result = 2;
   * </code>
   *
   * @return The recognitionResult.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult getRecognitionResult() {
    return recognitionResult_ == null
        ? com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult.getDefaultInstance()
        : recognitionResult_;
  }
  /**
   *
   *
   * <pre>
   * The result of speech recognition.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognition_result = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResultOrBuilder
      getRecognitionResultOrBuilder() {
    return recognitionResult_ == null
        ? com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult.getDefaultInstance()
        : recognitionResult_;
  }

  public static final int QUERY_RESULT_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.v2beta1.QueryResult queryResult_;
  /**
   *
   *
   * <pre>
   * The selected results of the conversational query or event processing.
   * See `alternative_query_results` for additional potential results.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 3;</code>
   *
   * @return Whether the queryResult field is set.
   */
  @java.lang.Override
  public boolean hasQueryResult() {
    return queryResult_ != null;
  }
  /**
   *
   *
   * <pre>
   * The selected results of the conversational query or event processing.
   * See `alternative_query_results` for additional potential results.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 3;</code>
   *
   * @return The queryResult.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryResult getQueryResult() {
    return queryResult_ == null
        ? com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance()
        : queryResult_;
  }
  /**
   *
   *
   * <pre>
   * The selected results of the conversational query or event processing.
   * See `alternative_query_results` for additional potential results.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder getQueryResultOrBuilder() {
    return queryResult_ == null
        ? com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance()
        : queryResult_;
  }

  public static final int ALTERNATIVE_QUERY_RESULTS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.QueryResult> alternativeQueryResults_;
  /**
   *
   *
   * <pre>
   * If Knowledge Connectors are enabled, there could be more than one result
   * returned for a given query or event, and this field will contain all
   * results except for the top one, which is captured in query_result. The
   * alternative results are ordered by decreasing
   * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
   * disabled, this field will be empty until multiple responses for regular
   * intents are supported, at which point those additional results will be
   * surfaced here.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.QueryResult>
      getAlternativeQueryResultsList() {
    return alternativeQueryResults_;
  }
  /**
   *
   *
   * <pre>
   * If Knowledge Connectors are enabled, there could be more than one result
   * returned for a given query or event, and this field will contain all
   * results except for the top one, which is captured in query_result. The
   * alternative results are ordered by decreasing
   * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
   * disabled, this field will be empty until multiple responses for regular
   * intents are supported, at which point those additional results will be
   * surfaced here.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
      getAlternativeQueryResultsOrBuilderList() {
    return alternativeQueryResults_;
  }
  /**
   *
   *
   * <pre>
   * If Knowledge Connectors are enabled, there could be more than one result
   * returned for a given query or event, and this field will contain all
   * results except for the top one, which is captured in query_result. The
   * alternative results are ordered by decreasing
   * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
   * disabled, this field will be empty until multiple responses for regular
   * intents are supported, at which point those additional results will be
   * surfaced here.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
   * </code>
   */
  @java.lang.Override
  public int getAlternativeQueryResultsCount() {
    return alternativeQueryResults_.size();
  }
  /**
   *
   *
   * <pre>
   * If Knowledge Connectors are enabled, there could be more than one result
   * returned for a given query or event, and this field will contain all
   * results except for the top one, which is captured in query_result. The
   * alternative results are ordered by decreasing
   * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
   * disabled, this field will be empty until multiple responses for regular
   * intents are supported, at which point those additional results will be
   * surfaced here.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryResult getAlternativeQueryResults(int index) {
    return alternativeQueryResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If Knowledge Connectors are enabled, there could be more than one result
   * returned for a given query or event, and this field will contain all
   * results except for the top one, which is captured in query_result. The
   * alternative results are ordered by decreasing
   * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
   * disabled, this field will be empty until multiple responses for regular
   * intents are supported, at which point those additional results will be
   * surfaced here.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder
      getAlternativeQueryResultsOrBuilder(int index) {
    return alternativeQueryResults_.get(index);
  }

  public static final int WEBHOOK_STATUS_FIELD_NUMBER = 4;
  private com.google.rpc.Status webhookStatus_;
  /**
   *
   *
   * <pre>
   * Specifies the status of the webhook request.
   * </pre>
   *
   * <code>.google.rpc.Status webhook_status = 4;</code>
   *
   * @return Whether the webhookStatus field is set.
   */
  @java.lang.Override
  public boolean hasWebhookStatus() {
    return webhookStatus_ != null;
  }
  /**
   *
   *
   * <pre>
   * Specifies the status of the webhook request.
   * </pre>
   *
   * <code>.google.rpc.Status webhook_status = 4;</code>
   *
   * @return The webhookStatus.
   */
  @java.lang.Override
  public com.google.rpc.Status getWebhookStatus() {
    return webhookStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : webhookStatus_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the status of the webhook request.
   * </pre>
   *
   * <code>.google.rpc.Status webhook_status = 4;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getWebhookStatusOrBuilder() {
    return webhookStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : webhookStatus_;
  }

  public static final int OUTPUT_AUDIO_FIELD_NUMBER = 5;
  private com.google.protobuf.ByteString outputAudio_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The audio data bytes encoded as specified in the request.
   * Note: The output audio is generated based on the values of default platform
   * text responses found in the `query_result.fulfillment_messages` field. If
   * multiple default text responses exist, they will be concatenated when
   * generating audio. If no default platform text responses exist, the
   * generated audio content will be empty.
   * In some scenarios, multiple output audio fields may be present in the
   * response structure. In these cases, only the top-most-level audio output
   * has content.
   * </pre>
   *
   * <code>bytes output_audio = 5;</code>
   *
   * @return The outputAudio.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputAudio() {
    return outputAudio_;
  }

  public static final int OUTPUT_AUDIO_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.dialogflow.v2beta1.OutputAudioConfig outputAudioConfig_;
  /**
   *
   *
   * <pre>
   * The config used by the speech synthesizer to generate the output audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
   *
   * @return Whether the outputAudioConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputAudioConfig() {
    return outputAudioConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The config used by the speech synthesizer to generate the output audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
   *
   * @return The outputAudioConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig getOutputAudioConfig() {
    return outputAudioConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
        : outputAudioConfig_;
  }
  /**
   *
   *
   * <pre>
   * The config used by the speech synthesizer to generate the output audio.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder
      getOutputAudioConfigOrBuilder() {
    return outputAudioConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
        : outputAudioConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, responseId_);
    }
    if (recognitionResult_ != null) {
      output.writeMessage(2, getRecognitionResult());
    }
    if (queryResult_ != null) {
      output.writeMessage(3, getQueryResult());
    }
    if (webhookStatus_ != null) {
      output.writeMessage(4, getWebhookStatus());
    }
    if (!outputAudio_.isEmpty()) {
      output.writeBytes(5, outputAudio_);
    }
    if (outputAudioConfig_ != null) {
      output.writeMessage(6, getOutputAudioConfig());
    }
    for (int i = 0; i < alternativeQueryResults_.size(); i++) {
      output.writeMessage(7, alternativeQueryResults_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, responseId_);
    }
    if (recognitionResult_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRecognitionResult());
    }
    if (queryResult_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getQueryResult());
    }
    if (webhookStatus_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getWebhookStatus());
    }
    if (!outputAudio_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(5, outputAudio_);
    }
    if (outputAudioConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getOutputAudioConfig());
    }
    for (int i = 0; i < alternativeQueryResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, alternativeQueryResults_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse other =
        (com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse) obj;

    if (!getResponseId().equals(other.getResponseId())) return false;
    if (hasRecognitionResult() != other.hasRecognitionResult()) return false;
    if (hasRecognitionResult()) {
      if (!getRecognitionResult().equals(other.getRecognitionResult())) return false;
    }
    if (hasQueryResult() != other.hasQueryResult()) return false;
    if (hasQueryResult()) {
      if (!getQueryResult().equals(other.getQueryResult())) return false;
    }
    if (!getAlternativeQueryResultsList().equals(other.getAlternativeQueryResultsList()))
      return false;
    if (hasWebhookStatus() != other.hasWebhookStatus()) return false;
    if (hasWebhookStatus()) {
      if (!getWebhookStatus().equals(other.getWebhookStatus())) return false;
    }
    if (!getOutputAudio().equals(other.getOutputAudio())) return false;
    if (hasOutputAudioConfig() != other.hasOutputAudioConfig()) return false;
    if (hasOutputAudioConfig()) {
      if (!getOutputAudioConfig().equals(other.getOutputAudioConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESPONSE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getResponseId().hashCode();
    if (hasRecognitionResult()) {
      hash = (37 * hash) + RECOGNITION_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getRecognitionResult().hashCode();
    }
    if (hasQueryResult()) {
      hash = (37 * hash) + QUERY_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getQueryResult().hashCode();
    }
    if (getAlternativeQueryResultsCount() > 0) {
      hash = (37 * hash) + ALTERNATIVE_QUERY_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getAlternativeQueryResultsList().hashCode();
    }
    if (hasWebhookStatus()) {
      hash = (37 * hash) + WEBHOOK_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getWebhookStatus().hashCode();
    }
    hash = (37 * hash) + OUTPUT_AUDIO_FIELD_NUMBER;
    hash = (53 * hash) + getOutputAudio().hashCode();
    if (hasOutputAudioConfig()) {
      hash = (37 * hash) + OUTPUT_AUDIO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputAudioConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The top-level message returned from the
   * `StreamingDetectIntent` method.
   * Multiple response messages can be returned in order:
   * 1.  If the `StreamingDetectIntentRequest.input_audio` field was
   *     set, the `recognition_result` field is populated for one
   *     or more messages.
   *     See the [StreamingRecognitionResult][google.cloud.dialogflow.v2beta1.StreamingRecognitionResult] message for details
   *     about the result message sequence.
   * 2.  The next message contains `response_id`, `query_result`,
   *     `alternative_query_results` and optionally `webhook_status` if a WebHook
   *     was called.
   * 3.  If `output_audio_config` was specified in the request or agent-level
   *     speech synthesizer is configured, all subsequent messages contain
   *     `output_audio` and `output_audio_config`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse)
      com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_StreamingDetectIntentResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_StreamingDetectIntentResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse.class,
              com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse.Builder.class);
    }

    // Construct using
    // com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      responseId_ = "";
      recognitionResult_ = null;
      if (recognitionResultBuilder_ != null) {
        recognitionResultBuilder_.dispose();
        recognitionResultBuilder_ = null;
      }
      queryResult_ = null;
      if (queryResultBuilder_ != null) {
        queryResultBuilder_.dispose();
        queryResultBuilder_ = null;
      }
      if (alternativeQueryResultsBuilder_ == null) {
        alternativeQueryResults_ = java.util.Collections.emptyList();
      } else {
        alternativeQueryResults_ = null;
        alternativeQueryResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      webhookStatus_ = null;
      if (webhookStatusBuilder_ != null) {
        webhookStatusBuilder_.dispose();
        webhookStatusBuilder_ = null;
      }
      outputAudio_ = com.google.protobuf.ByteString.EMPTY;
      outputAudioConfig_ = null;
      if (outputAudioConfigBuilder_ != null) {
        outputAudioConfigBuilder_.dispose();
        outputAudioConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_StreamingDetectIntentResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse build() {
      com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse buildPartial() {
      com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse result =
          new com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse result) {
      if (alternativeQueryResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          alternativeQueryResults_ =
              java.util.Collections.unmodifiableList(alternativeQueryResults_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.alternativeQueryResults_ = alternativeQueryResults_;
      } else {
        result.alternativeQueryResults_ = alternativeQueryResultsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.responseId_ = responseId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.recognitionResult_ =
            recognitionResultBuilder_ == null
                ? recognitionResult_
                : recognitionResultBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.queryResult_ =
            queryResultBuilder_ == null ? queryResult_ : queryResultBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.webhookStatus_ =
            webhookStatusBuilder_ == null ? webhookStatus_ : webhookStatusBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.outputAudio_ = outputAudio_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.outputAudioConfig_ =
            outputAudioConfigBuilder_ == null
                ? outputAudioConfig_
                : outputAudioConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse other) {
      if (other
          == com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse.getDefaultInstance())
        return this;
      if (!other.getResponseId().isEmpty()) {
        responseId_ = other.responseId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasRecognitionResult()) {
        mergeRecognitionResult(other.getRecognitionResult());
      }
      if (other.hasQueryResult()) {
        mergeQueryResult(other.getQueryResult());
      }
      if (alternativeQueryResultsBuilder_ == null) {
        if (!other.alternativeQueryResults_.isEmpty()) {
          if (alternativeQueryResults_.isEmpty()) {
            alternativeQueryResults_ = other.alternativeQueryResults_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureAlternativeQueryResultsIsMutable();
            alternativeQueryResults_.addAll(other.alternativeQueryResults_);
          }
          onChanged();
        }
      } else {
        if (!other.alternativeQueryResults_.isEmpty()) {
          if (alternativeQueryResultsBuilder_.isEmpty()) {
            alternativeQueryResultsBuilder_.dispose();
            alternativeQueryResultsBuilder_ = null;
            alternativeQueryResults_ = other.alternativeQueryResults_;
            bitField0_ = (bitField0_ & ~0x00000008);
            alternativeQueryResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAlternativeQueryResultsFieldBuilder()
                    : null;
          } else {
            alternativeQueryResultsBuilder_.addAllMessages(other.alternativeQueryResults_);
          }
        }
      }
      if (other.hasWebhookStatus()) {
        mergeWebhookStatus(other.getWebhookStatus());
      }
      if (other.getOutputAudio() != com.google.protobuf.ByteString.EMPTY) {
        setOutputAudio(other.getOutputAudio());
      }
      if (other.hasOutputAudioConfig()) {
        mergeOutputAudioConfig(other.getOutputAudioConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                responseId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getRecognitionResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getQueryResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getWebhookStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                outputAudio_ = input.readBytes();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getOutputAudioConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.dialogflow.v2beta1.QueryResult m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.QueryResult.parser(),
                        extensionRegistry);
                if (alternativeQueryResultsBuilder_ == null) {
                  ensureAlternativeQueryResultsIsMutable();
                  alternativeQueryResults_.add(m);
                } else {
                  alternativeQueryResultsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object responseId_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @return The responseId.
     */
    public java.lang.String getResponseId() {
      java.lang.Object ref = responseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        responseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @return The bytes for responseId.
     */
    public com.google.protobuf.ByteString getResponseIdBytes() {
      java.lang.Object ref = responseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        responseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @param value The responseId to set.
     * @return This builder for chaining.
     */
    public Builder setResponseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      responseId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseId() {
      responseId_ = getDefaultInstance().getResponseId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the response. It can be used to
     * locate a response in the training example set or for reporting issues.
     * </pre>
     *
     * <code>string response_id = 1;</code>
     *
     * @param value The bytes for responseId to set.
     * @return This builder for chaining.
     */
    public Builder setResponseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      responseId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognitionResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult,
            com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult.Builder,
            com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResultOrBuilder>
        recognitionResultBuilder_;
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognition_result = 2;
     * </code>
     *
     * @return Whether the recognitionResult field is set.
     */
    public boolean hasRecognitionResult() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognition_result = 2;
     * </code>
     *
     * @return The recognitionResult.
     */
    public com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult getRecognitionResult() {
      if (recognitionResultBuilder_ == null) {
        return recognitionResult_ == null
            ? com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult.getDefaultInstance()
            : recognitionResult_;
      } else {
        return recognitionResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognition_result = 2;
     * </code>
     */
    public Builder setRecognitionResult(
        com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult value) {
      if (recognitionResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        recognitionResult_ = value;
      } else {
        recognitionResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognition_result = 2;
     * </code>
     */
    public Builder setRecognitionResult(
        com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult.Builder builderForValue) {
      if (recognitionResultBuilder_ == null) {
        recognitionResult_ = builderForValue.build();
      } else {
        recognitionResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognition_result = 2;
     * </code>
     */
    public Builder mergeRecognitionResult(
        com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult value) {
      if (recognitionResultBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && recognitionResult_ != null
            && recognitionResult_
                != com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult
                    .getDefaultInstance()) {
          getRecognitionResultBuilder().mergeFrom(value);
        } else {
          recognitionResult_ = value;
        }
      } else {
        recognitionResultBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognition_result = 2;
     * </code>
     */
    public Builder clearRecognitionResult() {
      bitField0_ = (bitField0_ & ~0x00000002);
      recognitionResult_ = null;
      if (recognitionResultBuilder_ != null) {
        recognitionResultBuilder_.dispose();
        recognitionResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognition_result = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult.Builder
        getRecognitionResultBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getRecognitionResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognition_result = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResultOrBuilder
        getRecognitionResultOrBuilder() {
      if (recognitionResultBuilder_ != null) {
        return recognitionResultBuilder_.getMessageOrBuilder();
      } else {
        return recognitionResult_ == null
            ? com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult.getDefaultInstance()
            : recognitionResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * The result of speech recognition.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult recognition_result = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult,
            com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult.Builder,
            com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResultOrBuilder>
        getRecognitionResultFieldBuilder() {
      if (recognitionResultBuilder_ == null) {
        recognitionResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult,
                com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResult.Builder,
                com.google.cloud.dialogflow.v2beta1.StreamingRecognitionResultOrBuilder>(
                getRecognitionResult(), getParentForChildren(), isClean());
        recognitionResult_ = null;
      }
      return recognitionResultBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.QueryResult queryResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryResult,
            com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
        queryResultBuilder_;
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 3;</code>
     *
     * @return Whether the queryResult field is set.
     */
    public boolean hasQueryResult() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 3;</code>
     *
     * @return The queryResult.
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResult getQueryResult() {
      if (queryResultBuilder_ == null) {
        return queryResult_ == null
            ? com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance()
            : queryResult_;
      } else {
        return queryResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 3;</code>
     */
    public Builder setQueryResult(com.google.cloud.dialogflow.v2beta1.QueryResult value) {
      if (queryResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryResult_ = value;
      } else {
        queryResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 3;</code>
     */
    public Builder setQueryResult(
        com.google.cloud.dialogflow.v2beta1.QueryResult.Builder builderForValue) {
      if (queryResultBuilder_ == null) {
        queryResult_ = builderForValue.build();
      } else {
        queryResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 3;</code>
     */
    public Builder mergeQueryResult(com.google.cloud.dialogflow.v2beta1.QueryResult value) {
      if (queryResultBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && queryResult_ != null
            && queryResult_
                != com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance()) {
          getQueryResultBuilder().mergeFrom(value);
        } else {
          queryResult_ = value;
        }
      } else {
        queryResultBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 3;</code>
     */
    public Builder clearQueryResult() {
      bitField0_ = (bitField0_ & ~0x00000004);
      queryResult_ = null;
      if (queryResultBuilder_ != null) {
        queryResultBuilder_.dispose();
        queryResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResult.Builder getQueryResultBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getQueryResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder getQueryResultOrBuilder() {
      if (queryResultBuilder_ != null) {
        return queryResultBuilder_.getMessageOrBuilder();
      } else {
        return queryResult_ == null
            ? com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance()
            : queryResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * The selected results of the conversational query or event processing.
     * See `alternative_query_results` for additional potential results.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryResult query_result = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryResult,
            com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
        getQueryResultFieldBuilder() {
      if (queryResultBuilder_ == null) {
        queryResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.QueryResult,
                com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
                com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>(
                getQueryResult(), getParentForChildren(), isClean());
        queryResult_ = null;
      }
      return queryResultBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.QueryResult>
        alternativeQueryResults_ = java.util.Collections.emptyList();

    private void ensureAlternativeQueryResultsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        alternativeQueryResults_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.QueryResult>(
                alternativeQueryResults_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryResult,
            com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
        alternativeQueryResultsBuilder_;

    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.QueryResult>
        getAlternativeQueryResultsList() {
      if (alternativeQueryResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(alternativeQueryResults_);
      } else {
        return alternativeQueryResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public int getAlternativeQueryResultsCount() {
      if (alternativeQueryResultsBuilder_ == null) {
        return alternativeQueryResults_.size();
      } else {
        return alternativeQueryResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResult getAlternativeQueryResults(int index) {
      if (alternativeQueryResultsBuilder_ == null) {
        return alternativeQueryResults_.get(index);
      } else {
        return alternativeQueryResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public Builder setAlternativeQueryResults(
        int index, com.google.cloud.dialogflow.v2beta1.QueryResult value) {
      if (alternativeQueryResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.set(index, value);
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public Builder setAlternativeQueryResults(
        int index, com.google.cloud.dialogflow.v2beta1.QueryResult.Builder builderForValue) {
      if (alternativeQueryResultsBuilder_ == null) {
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public Builder addAlternativeQueryResults(
        com.google.cloud.dialogflow.v2beta1.QueryResult value) {
      if (alternativeQueryResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.add(value);
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public Builder addAlternativeQueryResults(
        int index, com.google.cloud.dialogflow.v2beta1.QueryResult value) {
      if (alternativeQueryResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.add(index, value);
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public Builder addAlternativeQueryResults(
        com.google.cloud.dialogflow.v2beta1.QueryResult.Builder builderForValue) {
      if (alternativeQueryResultsBuilder_ == null) {
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.add(builderForValue.build());
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public Builder addAlternativeQueryResults(
        int index, com.google.cloud.dialogflow.v2beta1.QueryResult.Builder builderForValue) {
      if (alternativeQueryResultsBuilder_ == null) {
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public Builder addAllAlternativeQueryResults(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.QueryResult> values) {
      if (alternativeQueryResultsBuilder_ == null) {
        ensureAlternativeQueryResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, alternativeQueryResults_);
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public Builder clearAlternativeQueryResults() {
      if (alternativeQueryResultsBuilder_ == null) {
        alternativeQueryResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public Builder removeAlternativeQueryResults(int index) {
      if (alternativeQueryResultsBuilder_ == null) {
        ensureAlternativeQueryResultsIsMutable();
        alternativeQueryResults_.remove(index);
        onChanged();
      } else {
        alternativeQueryResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResult.Builder
        getAlternativeQueryResultsBuilder(int index) {
      return getAlternativeQueryResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder
        getAlternativeQueryResultsOrBuilder(int index) {
      if (alternativeQueryResultsBuilder_ == null) {
        return alternativeQueryResults_.get(index);
      } else {
        return alternativeQueryResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
        getAlternativeQueryResultsOrBuilderList() {
      if (alternativeQueryResultsBuilder_ != null) {
        return alternativeQueryResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(alternativeQueryResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResult.Builder
        addAlternativeQueryResultsBuilder() {
      return getAlternativeQueryResultsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryResult.Builder
        addAlternativeQueryResultsBuilder(int index) {
      return getAlternativeQueryResultsFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * If Knowledge Connectors are enabled, there could be more than one result
     * returned for a given query or event, and this field will contain all
     * results except for the top one, which is captured in query_result. The
     * alternative results are ordered by decreasing
     * `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
     * disabled, this field will be empty until multiple responses for regular
     * intents are supported, at which point those additional results will be
     * surfaced here.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.QueryResult alternative_query_results = 7;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.QueryResult.Builder>
        getAlternativeQueryResultsBuilderList() {
      return getAlternativeQueryResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryResult,
            com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>
        getAlternativeQueryResultsFieldBuilder() {
      if (alternativeQueryResultsBuilder_ == null) {
        alternativeQueryResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.QueryResult,
                com.google.cloud.dialogflow.v2beta1.QueryResult.Builder,
                com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder>(
                alternativeQueryResults_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        alternativeQueryResults_ = null;
      }
      return alternativeQueryResultsBuilder_;
    }

    private com.google.rpc.Status webhookStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        webhookStatusBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 4;</code>
     *
     * @return Whether the webhookStatus field is set.
     */
    public boolean hasWebhookStatus() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 4;</code>
     *
     * @return The webhookStatus.
     */
    public com.google.rpc.Status getWebhookStatus() {
      if (webhookStatusBuilder_ == null) {
        return webhookStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : webhookStatus_;
      } else {
        return webhookStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 4;</code>
     */
    public Builder setWebhookStatus(com.google.rpc.Status value) {
      if (webhookStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webhookStatus_ = value;
      } else {
        webhookStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 4;</code>
     */
    public Builder setWebhookStatus(com.google.rpc.Status.Builder builderForValue) {
      if (webhookStatusBuilder_ == null) {
        webhookStatus_ = builderForValue.build();
      } else {
        webhookStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 4;</code>
     */
    public Builder mergeWebhookStatus(com.google.rpc.Status value) {
      if (webhookStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && webhookStatus_ != null
            && webhookStatus_ != com.google.rpc.Status.getDefaultInstance()) {
          getWebhookStatusBuilder().mergeFrom(value);
        } else {
          webhookStatus_ = value;
        }
      } else {
        webhookStatusBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 4;</code>
     */
    public Builder clearWebhookStatus() {
      bitField0_ = (bitField0_ & ~0x00000010);
      webhookStatus_ = null;
      if (webhookStatusBuilder_ != null) {
        webhookStatusBuilder_.dispose();
        webhookStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 4;</code>
     */
    public com.google.rpc.Status.Builder getWebhookStatusBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getWebhookStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 4;</code>
     */
    public com.google.rpc.StatusOrBuilder getWebhookStatusOrBuilder() {
      if (webhookStatusBuilder_ != null) {
        return webhookStatusBuilder_.getMessageOrBuilder();
      } else {
        return webhookStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : webhookStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the status of the webhook request.
     * </pre>
     *
     * <code>.google.rpc.Status webhook_status = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getWebhookStatusFieldBuilder() {
      if (webhookStatusBuilder_ == null) {
        webhookStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                getWebhookStatus(), getParentForChildren(), isClean());
        webhookStatus_ = null;
      }
      return webhookStatusBuilder_;
    }

    private com.google.protobuf.ByteString outputAudio_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in the request.
     * Note: The output audio is generated based on the values of default platform
     * text responses found in the `query_result.fulfillment_messages` field. If
     * multiple default text responses exist, they will be concatenated when
     * generating audio. If no default platform text responses exist, the
     * generated audio content will be empty.
     * In some scenarios, multiple output audio fields may be present in the
     * response structure. In these cases, only the top-most-level audio output
     * has content.
     * </pre>
     *
     * <code>bytes output_audio = 5;</code>
     *
     * @return The outputAudio.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getOutputAudio() {
      return outputAudio_;
    }
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in the request.
     * Note: The output audio is generated based on the values of default platform
     * text responses found in the `query_result.fulfillment_messages` field. If
     * multiple default text responses exist, they will be concatenated when
     * generating audio. If no default platform text responses exist, the
     * generated audio content will be empty.
     * In some scenarios, multiple output audio fields may be present in the
     * response structure. In these cases, only the top-most-level audio output
     * has content.
     * </pre>
     *
     * <code>bytes output_audio = 5;</code>
     *
     * @param value The outputAudio to set.
     * @return This builder for chaining.
     */
    public Builder setOutputAudio(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      outputAudio_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in the request.
     * Note: The output audio is generated based on the values of default platform
     * text responses found in the `query_result.fulfillment_messages` field. If
     * multiple default text responses exist, they will be concatenated when
     * generating audio. If no default platform text responses exist, the
     * generated audio content will be empty.
     * In some scenarios, multiple output audio fields may be present in the
     * response structure. In these cases, only the top-most-level audio output
     * has content.
     * </pre>
     *
     * <code>bytes output_audio = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputAudio() {
      bitField0_ = (bitField0_ & ~0x00000020);
      outputAudio_ = getDefaultInstance().getOutputAudio();
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2beta1.OutputAudioConfig outputAudioConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>
        outputAudioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     *
     * @return Whether the outputAudioConfig field is set.
     */
    public boolean hasOutputAudioConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     *
     * @return The outputAudioConfig.
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig getOutputAudioConfig() {
      if (outputAudioConfigBuilder_ == null) {
        return outputAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
            : outputAudioConfig_;
      } else {
        return outputAudioConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    public Builder setOutputAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig value) {
      if (outputAudioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputAudioConfig_ = value;
      } else {
        outputAudioConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    public Builder setOutputAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder builderForValue) {
      if (outputAudioConfigBuilder_ == null) {
        outputAudioConfig_ = builderForValue.build();
      } else {
        outputAudioConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    public Builder mergeOutputAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig value) {
      if (outputAudioConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && outputAudioConfig_ != null
            && outputAudioConfig_
                != com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()) {
          getOutputAudioConfigBuilder().mergeFrom(value);
        } else {
          outputAudioConfig_ = value;
        }
      } else {
        outputAudioConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    public Builder clearOutputAudioConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      outputAudioConfig_ = null;
      if (outputAudioConfigBuilder_ != null) {
        outputAudioConfigBuilder_.dispose();
        outputAudioConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder
        getOutputAudioConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getOutputAudioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder
        getOutputAudioConfigOrBuilder() {
      if (outputAudioConfigBuilder_ != null) {
        return outputAudioConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
            : outputAudioConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The config used by the speech synthesizer to generate the output audio.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig output_audio_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>
        getOutputAudioConfigFieldBuilder() {
      if (outputAudioConfigBuilder_ == null) {
        outputAudioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>(
                getOutputAudioConfig(), getParentForChildren(), isClean());
        outputAudioConfig_ = null;
      }
      return outputAudioConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse)
  private static final com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse();
  }

  public static com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingDetectIntentResponse> PARSER =
      new com.google.protobuf.AbstractParser<StreamingDetectIntentResponse>() {
        @java.lang.Override
        public StreamingDetectIntentResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamingDetectIntentResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingDetectIntentResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
