/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/environment.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Instructs the speech synthesizer on how to generate the output audio content.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.TextToSpeechSettings}
 */
public final class TextToSpeechSettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.TextToSpeechSettings)
    TextToSpeechSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TextToSpeechSettings.newBuilder() to construct.
  private TextToSpeechSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TextToSpeechSettings() {
    outputAudioEncoding_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TextToSpeechSettings();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.EnvironmentProto
        .internal_static_google_cloud_dialogflow_v2beta1_TextToSpeechSettings_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetSynthesizeSpeechConfigs();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.EnvironmentProto
        .internal_static_google_cloud_dialogflow_v2beta1_TextToSpeechSettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.class,
            com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.Builder.class);
  }

  public static final int ENABLE_TEXT_TO_SPEECH_FIELD_NUMBER = 1;
  private boolean enableTextToSpeech_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Indicates whether text to speech is enabled. Even when this field is false,
   * other settings in this proto are still retained.
   * </pre>
   *
   * <code>bool enable_text_to_speech = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The enableTextToSpeech.
   */
  @java.lang.Override
  public boolean getEnableTextToSpeech() {
    return enableTextToSpeech_;
  }

  public static final int OUTPUT_AUDIO_ENCODING_FIELD_NUMBER = 2;
  private int outputAudioEncoding_ = 0;
  /**
   *
   *
   * <pre>
   * Required. Audio encoding of the synthesized audio content.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.OutputAudioEncoding output_audio_encoding = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for outputAudioEncoding.
   */
  @java.lang.Override
  public int getOutputAudioEncodingValue() {
    return outputAudioEncoding_;
  }
  /**
   *
   *
   * <pre>
   * Required. Audio encoding of the synthesized audio content.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.OutputAudioEncoding output_audio_encoding = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The outputAudioEncoding.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.OutputAudioEncoding getOutputAudioEncoding() {
    com.google.cloud.dialogflow.v2beta1.OutputAudioEncoding result =
        com.google.cloud.dialogflow.v2beta1.OutputAudioEncoding.forNumber(outputAudioEncoding_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.OutputAudioEncoding.UNRECOGNIZED
        : result;
  }

  public static final int SAMPLE_RATE_HERTZ_FIELD_NUMBER = 3;
  private int sampleRateHertz_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The synthesis sample rate (in hertz) for this audio. If not provided, then
   * the synthesizer will use the default sample rate based on the audio
   * encoding. If this is different from the voice's natural sample rate, then
   * the synthesizer will honor this request by converting to the desired sample
   * rate (which might result in worse audio quality).
   * </pre>
   *
   * <code>int32 sample_rate_hertz = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The sampleRateHertz.
   */
  @java.lang.Override
  public int getSampleRateHertz() {
    return sampleRateHertz_;
  }

  public static final int SYNTHESIZE_SPEECH_CONFIGS_FIELD_NUMBER = 4;

  private static final class SynthesizeSpeechConfigsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
                    newDefaultInstance(
                        com.google.cloud.dialogflow.v2beta1.EnvironmentProto
                            .internal_static_google_cloud_dialogflow_v2beta1_TextToSpeechSettings_SynthesizeSpeechConfigsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
      synthesizeSpeechConfigs_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
      internalGetSynthesizeSpeechConfigs() {
    if (synthesizeSpeechConfigs_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SynthesizeSpeechConfigsDefaultEntryHolder.defaultEntry);
    }
    return synthesizeSpeechConfigs_;
  }

  public int getSynthesizeSpeechConfigsCount() {
    return internalGetSynthesizeSpeechConfigs().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration of how speech should be synthesized, mapping from language
   * (https://cloud.google.com/dialogflow/docs/reference/language) to
   * SynthesizeSpeechConfig.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsSynthesizeSpeechConfigs(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetSynthesizeSpeechConfigs().getMap().containsKey(key);
  }
  /** Use {@link #getSynthesizeSpeechConfigsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
      getSynthesizeSpeechConfigs() {
    return getSynthesizeSpeechConfigsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration of how speech should be synthesized, mapping from language
   * (https://cloud.google.com/dialogflow/docs/reference/language) to
   * SynthesizeSpeechConfig.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
      getSynthesizeSpeechConfigsMap() {
    return internalGetSynthesizeSpeechConfigs().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration of how speech should be synthesized, mapping from language
   * (https://cloud.google.com/dialogflow/docs/reference/language) to
   * SynthesizeSpeechConfig.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig
      getSynthesizeSpeechConfigsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
        map = internalGetSynthesizeSpeechConfigs().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration of how speech should be synthesized, mapping from language
   * (https://cloud.google.com/dialogflow/docs/reference/language) to
   * SynthesizeSpeechConfig.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig
      getSynthesizeSpeechConfigsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
        map = internalGetSynthesizeSpeechConfigs().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (enableTextToSpeech_ != false) {
      output.writeBool(1, enableTextToSpeech_);
    }
    if (outputAudioEncoding_
        != com.google.cloud.dialogflow.v2beta1.OutputAudioEncoding.OUTPUT_AUDIO_ENCODING_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, outputAudioEncoding_);
    }
    if (sampleRateHertz_ != 0) {
      output.writeInt32(3, sampleRateHertz_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetSynthesizeSpeechConfigs(),
        SynthesizeSpeechConfigsDefaultEntryHolder.defaultEntry,
        4);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (enableTextToSpeech_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, enableTextToSpeech_);
    }
    if (outputAudioEncoding_
        != com.google.cloud.dialogflow.v2beta1.OutputAudioEncoding.OUTPUT_AUDIO_ENCODING_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, outputAudioEncoding_);
    }
    if (sampleRateHertz_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, sampleRateHertz_);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
        entry : internalGetSynthesizeSpeechConfigs().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
          synthesizeSpeechConfigs__ =
              SynthesizeSpeechConfigsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, synthesizeSpeechConfigs__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings other =
        (com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings) obj;

    if (getEnableTextToSpeech() != other.getEnableTextToSpeech()) return false;
    if (outputAudioEncoding_ != other.outputAudioEncoding_) return false;
    if (getSampleRateHertz() != other.getSampleRateHertz()) return false;
    if (!internalGetSynthesizeSpeechConfigs().equals(other.internalGetSynthesizeSpeechConfigs()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENABLE_TEXT_TO_SPEECH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableTextToSpeech());
    hash = (37 * hash) + OUTPUT_AUDIO_ENCODING_FIELD_NUMBER;
    hash = (53 * hash) + outputAudioEncoding_;
    hash = (37 * hash) + SAMPLE_RATE_HERTZ_FIELD_NUMBER;
    hash = (53 * hash) + getSampleRateHertz();
    if (!internalGetSynthesizeSpeechConfigs().getMap().isEmpty()) {
      hash = (37 * hash) + SYNTHESIZE_SPEECH_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSynthesizeSpeechConfigs().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Instructs the speech synthesizer on how to generate the output audio content.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.TextToSpeechSettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.TextToSpeechSettings)
      com.google.cloud.dialogflow.v2beta1.TextToSpeechSettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_v2beta1_TextToSpeechSettings_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetSynthesizeSpeechConfigs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableSynthesizeSpeechConfigs();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_v2beta1_TextToSpeechSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.class,
              com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      enableTextToSpeech_ = false;
      outputAudioEncoding_ = 0;
      sampleRateHertz_ = 0;
      internalGetMutableSynthesizeSpeechConfigs().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.EnvironmentProto
          .internal_static_google_cloud_dialogflow_v2beta1_TextToSpeechSettings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings build() {
      com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings buildPartial() {
      com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings result =
          new com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.enableTextToSpeech_ = enableTextToSpeech_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.outputAudioEncoding_ = outputAudioEncoding_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.sampleRateHertz_ = sampleRateHertz_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.synthesizeSpeechConfigs_ = internalGetSynthesizeSpeechConfigs();
        result.synthesizeSpeechConfigs_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings other) {
      if (other == com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings.getDefaultInstance())
        return this;
      if (other.getEnableTextToSpeech() != false) {
        setEnableTextToSpeech(other.getEnableTextToSpeech());
      }
      if (other.outputAudioEncoding_ != 0) {
        setOutputAudioEncodingValue(other.getOutputAudioEncodingValue());
      }
      if (other.getSampleRateHertz() != 0) {
        setSampleRateHertz(other.getSampleRateHertz());
      }
      internalGetMutableSynthesizeSpeechConfigs()
          .mergeFrom(other.internalGetSynthesizeSpeechConfigs());
      bitField0_ |= 0x00000008;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                enableTextToSpeech_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                outputAudioEncoding_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                sampleRateHertz_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
                    synthesizeSpeechConfigs__ =
                        input.readMessage(
                            SynthesizeSpeechConfigsDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableSynthesizeSpeechConfigs()
                    .getMutableMap()
                    .put(synthesizeSpeechConfigs__.getKey(), synthesizeSpeechConfigs__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean enableTextToSpeech_;
    /**
     *
     *
     * <pre>
     * Optional. Indicates whether text to speech is enabled. Even when this field is false,
     * other settings in this proto are still retained.
     * </pre>
     *
     * <code>bool enable_text_to_speech = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The enableTextToSpeech.
     */
    @java.lang.Override
    public boolean getEnableTextToSpeech() {
      return enableTextToSpeech_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates whether text to speech is enabled. Even when this field is false,
     * other settings in this proto are still retained.
     * </pre>
     *
     * <code>bool enable_text_to_speech = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The enableTextToSpeech to set.
     * @return This builder for chaining.
     */
    public Builder setEnableTextToSpeech(boolean value) {

      enableTextToSpeech_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates whether text to speech is enabled. Even when this field is false,
     * other settings in this proto are still retained.
     * </pre>
     *
     * <code>bool enable_text_to_speech = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableTextToSpeech() {
      bitField0_ = (bitField0_ & ~0x00000001);
      enableTextToSpeech_ = false;
      onChanged();
      return this;
    }

    private int outputAudioEncoding_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the synthesized audio content.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.OutputAudioEncoding output_audio_encoding = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for outputAudioEncoding.
     */
    @java.lang.Override
    public int getOutputAudioEncodingValue() {
      return outputAudioEncoding_;
    }
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the synthesized audio content.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.OutputAudioEncoding output_audio_encoding = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for outputAudioEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setOutputAudioEncodingValue(int value) {
      outputAudioEncoding_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the synthesized audio content.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.OutputAudioEncoding output_audio_encoding = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The outputAudioEncoding.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.OutputAudioEncoding getOutputAudioEncoding() {
      com.google.cloud.dialogflow.v2beta1.OutputAudioEncoding result =
          com.google.cloud.dialogflow.v2beta1.OutputAudioEncoding.forNumber(outputAudioEncoding_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.OutputAudioEncoding.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the synthesized audio content.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.OutputAudioEncoding output_audio_encoding = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The outputAudioEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setOutputAudioEncoding(
        com.google.cloud.dialogflow.v2beta1.OutputAudioEncoding value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      outputAudioEncoding_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Audio encoding of the synthesized audio content.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.OutputAudioEncoding output_audio_encoding = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputAudioEncoding() {
      bitField0_ = (bitField0_ & ~0x00000002);
      outputAudioEncoding_ = 0;
      onChanged();
      return this;
    }

    private int sampleRateHertz_;
    /**
     *
     *
     * <pre>
     * Optional. The synthesis sample rate (in hertz) for this audio. If not provided, then
     * the synthesizer will use the default sample rate based on the audio
     * encoding. If this is different from the voice's natural sample rate, then
     * the synthesizer will honor this request by converting to the desired sample
     * rate (which might result in worse audio quality).
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The sampleRateHertz.
     */
    @java.lang.Override
    public int getSampleRateHertz() {
      return sampleRateHertz_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The synthesis sample rate (in hertz) for this audio. If not provided, then
     * the synthesizer will use the default sample rate based on the audio
     * encoding. If this is different from the voice's natural sample rate, then
     * the synthesizer will honor this request by converting to the desired sample
     * rate (which might result in worse audio quality).
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The sampleRateHertz to set.
     * @return This builder for chaining.
     */
    public Builder setSampleRateHertz(int value) {

      sampleRateHertz_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The synthesis sample rate (in hertz) for this audio. If not provided, then
     * the synthesizer will use the default sample rate based on the audio
     * encoding. If this is different from the voice's natural sample rate, then
     * the synthesizer will honor this request by converting to the desired sample
     * rate (which might result in worse audio quality).
     * </pre>
     *
     * <code>int32 sample_rate_hertz = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSampleRateHertz() {
      bitField0_ = (bitField0_ & ~0x00000004);
      sampleRateHertz_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
        synthesizeSpeechConfigs_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
        internalGetSynthesizeSpeechConfigs() {
      if (synthesizeSpeechConfigs_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SynthesizeSpeechConfigsDefaultEntryHolder.defaultEntry);
      }
      return synthesizeSpeechConfigs_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
        internalGetMutableSynthesizeSpeechConfigs() {
      if (synthesizeSpeechConfigs_ == null) {
        synthesizeSpeechConfigs_ =
            com.google.protobuf.MapField.newMapField(
                SynthesizeSpeechConfigsDefaultEntryHolder.defaultEntry);
      }
      if (!synthesizeSpeechConfigs_.isMutable()) {
        synthesizeSpeechConfigs_ = synthesizeSpeechConfigs_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return synthesizeSpeechConfigs_;
    }

    public int getSynthesizeSpeechConfigsCount() {
      return internalGetSynthesizeSpeechConfigs().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/docs/reference/language) to
     * SynthesizeSpeechConfig.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsSynthesizeSpeechConfigs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetSynthesizeSpeechConfigs().getMap().containsKey(key);
    }
    /** Use {@link #getSynthesizeSpeechConfigsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
        getSynthesizeSpeechConfigs() {
      return getSynthesizeSpeechConfigsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/docs/reference/language) to
     * SynthesizeSpeechConfig.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
        getSynthesizeSpeechConfigsMap() {
      return internalGetSynthesizeSpeechConfigs().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/docs/reference/language) to
     * SynthesizeSpeechConfig.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig
        getSynthesizeSpeechConfigsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
          map = internalGetSynthesizeSpeechConfigs().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/docs/reference/language) to
     * SynthesizeSpeechConfig.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig
        getSynthesizeSpeechConfigsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
          map = internalGetSynthesizeSpeechConfigs().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSynthesizeSpeechConfigs() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableSynthesizeSpeechConfigs().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/docs/reference/language) to
     * SynthesizeSpeechConfig.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeSynthesizeSpeechConfigs(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableSynthesizeSpeechConfigs().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
        getMutableSynthesizeSpeechConfigs() {
      bitField0_ |= 0x00000008;
      return internalGetMutableSynthesizeSpeechConfigs().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/docs/reference/language) to
     * SynthesizeSpeechConfig.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putSynthesizeSpeechConfigs(
        java.lang.String key, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableSynthesizeSpeechConfigs().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration of how speech should be synthesized, mapping from language
     * (https://cloud.google.com/dialogflow/docs/reference/language) to
     * SynthesizeSpeechConfig.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig&gt; synthesize_speech_configs = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllSynthesizeSpeechConfigs(
        java.util.Map<java.lang.String, com.google.cloud.dialogflow.v2beta1.SynthesizeSpeechConfig>
            values) {
      internalGetMutableSynthesizeSpeechConfigs().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.TextToSpeechSettings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.TextToSpeechSettings)
  private static final com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings();
  }

  public static com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TextToSpeechSettings> PARSER =
      new com.google.protobuf.AbstractParser<TextToSpeechSettings>() {
        @java.lang.Override
        public TextToSpeechSettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TextToSpeechSettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TextToSpeechSettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TextToSpeechSettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
