/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DocumentName
implements ResourceName {
    private static final PathTemplate PROJECT_KNOWLEDGE_BASE_DOCUMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}");
    private static final PathTemplate PROJECT_LOCATION_KNOWLEDGE_BASE_DOCUMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/knowledgeBases/{knowledge_base}/documents/{document}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String knowledgeBase;
    private final String document;
    private final String location;

    @Deprecated
    protected DocumentName() {
        this.project = null;
        this.knowledgeBase = null;
        this.document = null;
        this.location = null;
    }

    private DocumentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.knowledgeBase = (String)Preconditions.checkNotNull((Object)builder.getKnowledgeBase());
        this.document = (String)Preconditions.checkNotNull((Object)builder.getDocument());
        this.location = null;
        this.pathTemplate = PROJECT_KNOWLEDGE_BASE_DOCUMENT;
    }

    private DocumentName(ProjectLocationKnowledgeBaseDocumentBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.knowledgeBase = (String)Preconditions.checkNotNull((Object)builder.getKnowledgeBase());
        this.document = (String)Preconditions.checkNotNull((Object)builder.getDocument());
        this.pathTemplate = PROJECT_LOCATION_KNOWLEDGE_BASE_DOCUMENT;
    }

    public String getProject() {
        return this.project;
    }

    public String getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public String getDocument() {
        return this.document;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectKnowledgeBaseDocumentBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationKnowledgeBaseDocumentBuilder newProjectLocationKnowledgeBaseDocumentBuilder() {
        return new ProjectLocationKnowledgeBaseDocumentBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DocumentName of(String project, String knowledgeBase, String document) {
        return DocumentName.newBuilder().setProject(project).setKnowledgeBase(knowledgeBase).setDocument(document).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static DocumentName ofProjectKnowledgeBaseDocumentName(String project, String knowledgeBase, String document) {
        return DocumentName.newBuilder().setProject(project).setKnowledgeBase(knowledgeBase).setDocument(document).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static DocumentName ofProjectLocationKnowledgeBaseDocumentName(String project, String location, String knowledgeBase, String document) {
        return DocumentName.newProjectLocationKnowledgeBaseDocumentBuilder().setProject(project).setLocation(location).setKnowledgeBase(knowledgeBase).setDocument(document).build();
    }

    public static String format(String project, String knowledgeBase, String document) {
        return DocumentName.newBuilder().setProject(project).setKnowledgeBase(knowledgeBase).setDocument(document).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectKnowledgeBaseDocumentName(String project, String knowledgeBase, String document) {
        return DocumentName.newBuilder().setProject(project).setKnowledgeBase(knowledgeBase).setDocument(document).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationKnowledgeBaseDocumentName(String project, String location, String knowledgeBase, String document) {
        return DocumentName.newProjectLocationKnowledgeBaseDocumentBuilder().setProject(project).setLocation(location).setKnowledgeBase(knowledgeBase).setDocument(document).build().toString();
    }

    public static DocumentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_KNOWLEDGE_BASE_DOCUMENT.matches(formattedString)) {
            Map matchMap = PROJECT_KNOWLEDGE_BASE_DOCUMENT.match(formattedString);
            return DocumentName.ofProjectKnowledgeBaseDocumentName((String)matchMap.get("project"), (String)matchMap.get("knowledge_base"), (String)matchMap.get("document"));
        }
        if (PROJECT_LOCATION_KNOWLEDGE_BASE_DOCUMENT.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_KNOWLEDGE_BASE_DOCUMENT.match(formattedString);
            return DocumentName.ofProjectLocationKnowledgeBaseDocumentName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("knowledge_base"), (String)matchMap.get("document"));
        }
        throw new ValidationException("DocumentName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<DocumentName> parseList(List<String> formattedStrings) {
        ArrayList<DocumentName> list = new ArrayList<DocumentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DocumentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DocumentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DocumentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_KNOWLEDGE_BASE_DOCUMENT.matches(formattedString) || PROJECT_LOCATION_KNOWLEDGE_BASE_DOCUMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DocumentName documentName = this;
            synchronized (documentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.knowledgeBase != null) {
                        fieldMapBuilder.put((Object)"knowledge_base", (Object)this.knowledgeBase);
                    }
                    if (this.document != null) {
                        fieldMapBuilder.put((Object)"document", (Object)this.document);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DocumentName that = (DocumentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.knowledgeBase, that.knowledgeBase) && Objects.equals(this.document, that.document) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.knowledgeBase);
        h *= 1000003;
        h ^= Objects.hashCode(this.document);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationKnowledgeBaseDocumentBuilder {
        private String project;
        private String location;
        private String knowledgeBase;
        private String document;

        protected ProjectLocationKnowledgeBaseDocumentBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKnowledgeBase() {
            return this.knowledgeBase;
        }

        public String getDocument() {
            return this.document;
        }

        public ProjectLocationKnowledgeBaseDocumentBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationKnowledgeBaseDocumentBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationKnowledgeBaseDocumentBuilder setKnowledgeBase(String knowledgeBase) {
            this.knowledgeBase = knowledgeBase;
            return this;
        }

        public ProjectLocationKnowledgeBaseDocumentBuilder setDocument(String document) {
            this.document = document;
            return this;
        }

        public DocumentName build() {
            return new DocumentName(this);
        }
    }

    public static class Builder {
        private String project;
        private String knowledgeBase;
        private String document;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getKnowledgeBase() {
            return this.knowledgeBase;
        }

        public String getDocument() {
            return this.document;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setKnowledgeBase(String knowledgeBase) {
            this.knowledgeBase = knowledgeBase;
            return this;
        }

        public Builder setDocument(String document) {
            this.document = document;
            return this;
        }

        private Builder(DocumentName documentName) {
            Preconditions.checkArgument((boolean)Objects.equals(documentName.pathTemplate, PROJECT_KNOWLEDGE_BASE_DOCUMENT), (Object)"toBuilder is only supported when DocumentName has the pattern of projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}");
            this.project = documentName.project;
            this.knowledgeBase = documentName.knowledgeBase;
            this.document = documentName.document;
        }

        public DocumentName build() {
            return new DocumentName(this);
        }
    }
}

