/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/answer_record.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Answer records are records to manage answer history and feedbacks for
 * Dialogflow.
 * Currently, answer record includes:
 * - human agent assistant article suggestion
 * - human agent assistant faq article
 * It doesn't include:
 * - `DetectIntent` intent matching
 * - `DetectIntent` knowledge
 * Answer records are not related to the conversation history in the
 * Dialogflow Console. A Record is generated even when the end-user disables
 * conversation history in the console. Records are created when there's a human
 * agent assistant suggestion generated.
 * A typical workflow for customers provide feedback to an answer is:
 * 1. For human agent assistant, customers get suggestion via ListSuggestions
 *    API. Together with the answers,
 *    [AnswerRecord.name][google.cloud.dialogflow.v2beta1.AnswerRecord.name] are
 *    returned to the customers.
 * 2. The customer uses the
 * [AnswerRecord.name][google.cloud.dialogflow.v2beta1.AnswerRecord.name] to
 * call the
 *    [UpdateAnswerRecord][] method to send feedback about a specific answer
 *    that they believe is wrong.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.AnswerRecord}
 */
public final class AnswerRecord extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.AnswerRecord)
    AnswerRecordOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnswerRecord.newBuilder() to construct.
  private AnswerRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnswerRecord() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnswerRecord();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.AnswerRecordsProto
        .internal_static_google_cloud_dialogflow_v2beta1_AnswerRecord_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.AnswerRecordsProto
        .internal_static_google_cloud_dialogflow_v2beta1_AnswerRecord_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.AnswerRecord.class,
            com.google.cloud.dialogflow.v2beta1.AnswerRecord.Builder.class);
  }

  private int recordCase_ = 0;
  private java.lang.Object record_;

  public enum RecordCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AGENT_ASSISTANT_RECORD(4),
    RECORD_NOT_SET(0);
    private final int value;

    private RecordCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RecordCase valueOf(int value) {
      return forNumber(value);
    }

    public static RecordCase forNumber(int value) {
      switch (value) {
        case 4:
          return AGENT_ASSISTANT_RECORD;
        case 0:
          return RECORD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RecordCase getRecordCase() {
    return RecordCase.forNumber(recordCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of this answer record.
   * Required for
   * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
   * method. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/answerRecords/&lt;Answer Record ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of this answer record.
   * Required for
   * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
   * method. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/answerRecords/&lt;Answer Record ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANSWER_FEEDBACK_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.v2beta1.AnswerFeedback answerFeedback_;
  /**
   *
   *
   * <pre>
   * Optional. The AnswerFeedback for this record. You can set this with
   * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
   * in order to give us feedback about this answer.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback answer_feedback = 3;</code>
   *
   * @return Whether the answerFeedback field is set.
   */
  @java.lang.Override
  public boolean hasAnswerFeedback() {
    return answerFeedback_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. The AnswerFeedback for this record. You can set this with
   * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
   * in order to give us feedback about this answer.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback answer_feedback = 3;</code>
   *
   * @return The answerFeedback.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AnswerFeedback getAnswerFeedback() {
    return answerFeedback_ == null
        ? com.google.cloud.dialogflow.v2beta1.AnswerFeedback.getDefaultInstance()
        : answerFeedback_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The AnswerFeedback for this record. You can set this with
   * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
   * in order to give us feedback about this answer.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback answer_feedback = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AnswerFeedbackOrBuilder getAnswerFeedbackOrBuilder() {
    return answerFeedback_ == null
        ? com.google.cloud.dialogflow.v2beta1.AnswerFeedback.getDefaultInstance()
        : answerFeedback_;
  }

  public static final int AGENT_ASSISTANT_RECORD_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Output only. The record for human agent assistant.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AgentAssistantRecord agent_assistant_record = 4;</code>
   *
   * @return Whether the agentAssistantRecord field is set.
   */
  @java.lang.Override
  public boolean hasAgentAssistantRecord() {
    return recordCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Output only. The record for human agent assistant.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AgentAssistantRecord agent_assistant_record = 4;</code>
   *
   * @return The agentAssistantRecord.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord getAgentAssistantRecord() {
    if (recordCase_ == 4) {
      return (com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord) record_;
    }
    return com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. The record for human agent assistant.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AgentAssistantRecord agent_assistant_record = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AgentAssistantRecordOrBuilder
      getAgentAssistantRecordOrBuilder() {
    if (recordCase_ == 4) {
      return (com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord) record_;
    }
    return com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (answerFeedback_ != null) {
      output.writeMessage(3, getAnswerFeedback());
    }
    if (recordCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord) record_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (answerFeedback_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAnswerFeedback());
    }
    if (recordCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord) record_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.AnswerRecord)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.AnswerRecord other =
        (com.google.cloud.dialogflow.v2beta1.AnswerRecord) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasAnswerFeedback() != other.hasAnswerFeedback()) return false;
    if (hasAnswerFeedback()) {
      if (!getAnswerFeedback().equals(other.getAnswerFeedback())) return false;
    }
    if (!getRecordCase().equals(other.getRecordCase())) return false;
    switch (recordCase_) {
      case 4:
        if (!getAgentAssistantRecord().equals(other.getAgentAssistantRecord())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasAnswerFeedback()) {
      hash = (37 * hash) + ANSWER_FEEDBACK_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerFeedback().hashCode();
    }
    switch (recordCase_) {
      case 4:
        hash = (37 * hash) + AGENT_ASSISTANT_RECORD_FIELD_NUMBER;
        hash = (53 * hash) + getAgentAssistantRecord().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerRecord parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerRecord parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerRecord parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerRecord parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerRecord parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerRecord parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerRecord parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerRecord parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerRecord parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerRecord parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerRecord parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerRecord parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.AnswerRecord prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Answer records are records to manage answer history and feedbacks for
   * Dialogflow.
   * Currently, answer record includes:
   * - human agent assistant article suggestion
   * - human agent assistant faq article
   * It doesn't include:
   * - `DetectIntent` intent matching
   * - `DetectIntent` knowledge
   * Answer records are not related to the conversation history in the
   * Dialogflow Console. A Record is generated even when the end-user disables
   * conversation history in the console. Records are created when there's a human
   * agent assistant suggestion generated.
   * A typical workflow for customers provide feedback to an answer is:
   * 1. For human agent assistant, customers get suggestion via ListSuggestions
   *    API. Together with the answers,
   *    [AnswerRecord.name][google.cloud.dialogflow.v2beta1.AnswerRecord.name] are
   *    returned to the customers.
   * 2. The customer uses the
   * [AnswerRecord.name][google.cloud.dialogflow.v2beta1.AnswerRecord.name] to
   * call the
   *    [UpdateAnswerRecord][] method to send feedback about a specific answer
   *    that they believe is wrong.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.AnswerRecord}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.AnswerRecord)
      com.google.cloud.dialogflow.v2beta1.AnswerRecordOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.AnswerRecordsProto
          .internal_static_google_cloud_dialogflow_v2beta1_AnswerRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.AnswerRecordsProto
          .internal_static_google_cloud_dialogflow_v2beta1_AnswerRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.AnswerRecord.class,
              com.google.cloud.dialogflow.v2beta1.AnswerRecord.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.AnswerRecord.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      answerFeedback_ = null;
      if (answerFeedbackBuilder_ != null) {
        answerFeedbackBuilder_.dispose();
        answerFeedbackBuilder_ = null;
      }
      if (agentAssistantRecordBuilder_ != null) {
        agentAssistantRecordBuilder_.clear();
      }
      recordCase_ = 0;
      record_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.AnswerRecordsProto
          .internal_static_google_cloud_dialogflow_v2beta1_AnswerRecord_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AnswerRecord getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.AnswerRecord.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AnswerRecord build() {
      com.google.cloud.dialogflow.v2beta1.AnswerRecord result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AnswerRecord buildPartial() {
      com.google.cloud.dialogflow.v2beta1.AnswerRecord result =
          new com.google.cloud.dialogflow.v2beta1.AnswerRecord(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.AnswerRecord result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.answerFeedback_ =
            answerFeedbackBuilder_ == null ? answerFeedback_ : answerFeedbackBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.v2beta1.AnswerRecord result) {
      result.recordCase_ = recordCase_;
      result.record_ = this.record_;
      if (recordCase_ == 4 && agentAssistantRecordBuilder_ != null) {
        result.record_ = agentAssistantRecordBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.AnswerRecord) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.AnswerRecord) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.AnswerRecord other) {
      if (other == com.google.cloud.dialogflow.v2beta1.AnswerRecord.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasAnswerFeedback()) {
        mergeAnswerFeedback(other.getAnswerFeedback());
      }
      switch (other.getRecordCase()) {
        case AGENT_ASSISTANT_RECORD:
          {
            mergeAgentAssistantRecord(other.getAgentAssistantRecord());
            break;
          }
        case RECORD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getAnswerFeedbackFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getAgentAssistantRecordFieldBuilder().getBuilder(), extensionRegistry);
                recordCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int recordCase_ = 0;
    private java.lang.Object record_;

    public RecordCase getRecordCase() {
      return RecordCase.forNumber(recordCase_);
    }

    public Builder clearRecord() {
      recordCase_ = 0;
      record_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of this answer record.
     * Required for
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * method. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/answerRecords/&lt;Answer Record ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of this answer record.
     * Required for
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * method. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/answerRecords/&lt;Answer Record ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of this answer record.
     * Required for
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * method. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/answerRecords/&lt;Answer Record ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of this answer record.
     * Required for
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * method. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/answerRecords/&lt;Answer Record ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of this answer record.
     * Required for
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * method. Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/answerRecords/&lt;Answer Record ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2beta1.AnswerFeedback answerFeedback_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.AnswerFeedback,
            com.google.cloud.dialogflow.v2beta1.AnswerFeedback.Builder,
            com.google.cloud.dialogflow.v2beta1.AnswerFeedbackOrBuilder>
        answerFeedbackBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The AnswerFeedback for this record. You can set this with
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * in order to give us feedback about this answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback answer_feedback = 3;</code>
     *
     * @return Whether the answerFeedback field is set.
     */
    public boolean hasAnswerFeedback() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The AnswerFeedback for this record. You can set this with
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * in order to give us feedback about this answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback answer_feedback = 3;</code>
     *
     * @return The answerFeedback.
     */
    public com.google.cloud.dialogflow.v2beta1.AnswerFeedback getAnswerFeedback() {
      if (answerFeedbackBuilder_ == null) {
        return answerFeedback_ == null
            ? com.google.cloud.dialogflow.v2beta1.AnswerFeedback.getDefaultInstance()
            : answerFeedback_;
      } else {
        return answerFeedbackBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The AnswerFeedback for this record. You can set this with
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * in order to give us feedback about this answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback answer_feedback = 3;</code>
     */
    public Builder setAnswerFeedback(com.google.cloud.dialogflow.v2beta1.AnswerFeedback value) {
      if (answerFeedbackBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        answerFeedback_ = value;
      } else {
        answerFeedbackBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The AnswerFeedback for this record. You can set this with
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * in order to give us feedback about this answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback answer_feedback = 3;</code>
     */
    public Builder setAnswerFeedback(
        com.google.cloud.dialogflow.v2beta1.AnswerFeedback.Builder builderForValue) {
      if (answerFeedbackBuilder_ == null) {
        answerFeedback_ = builderForValue.build();
      } else {
        answerFeedbackBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The AnswerFeedback for this record. You can set this with
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * in order to give us feedback about this answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback answer_feedback = 3;</code>
     */
    public Builder mergeAnswerFeedback(com.google.cloud.dialogflow.v2beta1.AnswerFeedback value) {
      if (answerFeedbackBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && answerFeedback_ != null
            && answerFeedback_
                != com.google.cloud.dialogflow.v2beta1.AnswerFeedback.getDefaultInstance()) {
          getAnswerFeedbackBuilder().mergeFrom(value);
        } else {
          answerFeedback_ = value;
        }
      } else {
        answerFeedbackBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The AnswerFeedback for this record. You can set this with
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * in order to give us feedback about this answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback answer_feedback = 3;</code>
     */
    public Builder clearAnswerFeedback() {
      bitField0_ = (bitField0_ & ~0x00000002);
      answerFeedback_ = null;
      if (answerFeedbackBuilder_ != null) {
        answerFeedbackBuilder_.dispose();
        answerFeedbackBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The AnswerFeedback for this record. You can set this with
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * in order to give us feedback about this answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback answer_feedback = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.AnswerFeedback.Builder getAnswerFeedbackBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getAnswerFeedbackFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The AnswerFeedback for this record. You can set this with
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * in order to give us feedback about this answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback answer_feedback = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.AnswerFeedbackOrBuilder
        getAnswerFeedbackOrBuilder() {
      if (answerFeedbackBuilder_ != null) {
        return answerFeedbackBuilder_.getMessageOrBuilder();
      } else {
        return answerFeedback_ == null
            ? com.google.cloud.dialogflow.v2beta1.AnswerFeedback.getDefaultInstance()
            : answerFeedback_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The AnswerFeedback for this record. You can set this with
     * [AnswerRecords.UpdateAnswerRecord][google.cloud.dialogflow.v2beta1.AnswerRecords.UpdateAnswerRecord]
     * in order to give us feedback about this answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AnswerFeedback answer_feedback = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.AnswerFeedback,
            com.google.cloud.dialogflow.v2beta1.AnswerFeedback.Builder,
            com.google.cloud.dialogflow.v2beta1.AnswerFeedbackOrBuilder>
        getAnswerFeedbackFieldBuilder() {
      if (answerFeedbackBuilder_ == null) {
        answerFeedbackBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.AnswerFeedback,
                com.google.cloud.dialogflow.v2beta1.AnswerFeedback.Builder,
                com.google.cloud.dialogflow.v2beta1.AnswerFeedbackOrBuilder>(
                getAnswerFeedback(), getParentForChildren(), isClean());
        answerFeedback_ = null;
      }
      return answerFeedbackBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord,
            com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord.Builder,
            com.google.cloud.dialogflow.v2beta1.AgentAssistantRecordOrBuilder>
        agentAssistantRecordBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The record for human agent assistant.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AgentAssistantRecord agent_assistant_record = 4;
     * </code>
     *
     * @return Whether the agentAssistantRecord field is set.
     */
    @java.lang.Override
    public boolean hasAgentAssistantRecord() {
      return recordCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Output only. The record for human agent assistant.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AgentAssistantRecord agent_assistant_record = 4;
     * </code>
     *
     * @return The agentAssistantRecord.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord getAgentAssistantRecord() {
      if (agentAssistantRecordBuilder_ == null) {
        if (recordCase_ == 4) {
          return (com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord) record_;
        }
        return com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord.getDefaultInstance();
      } else {
        if (recordCase_ == 4) {
          return agentAssistantRecordBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The record for human agent assistant.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AgentAssistantRecord agent_assistant_record = 4;
     * </code>
     */
    public Builder setAgentAssistantRecord(
        com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord value) {
      if (agentAssistantRecordBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        record_ = value;
        onChanged();
      } else {
        agentAssistantRecordBuilder_.setMessage(value);
      }
      recordCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The record for human agent assistant.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AgentAssistantRecord agent_assistant_record = 4;
     * </code>
     */
    public Builder setAgentAssistantRecord(
        com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord.Builder builderForValue) {
      if (agentAssistantRecordBuilder_ == null) {
        record_ = builderForValue.build();
        onChanged();
      } else {
        agentAssistantRecordBuilder_.setMessage(builderForValue.build());
      }
      recordCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The record for human agent assistant.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AgentAssistantRecord agent_assistant_record = 4;
     * </code>
     */
    public Builder mergeAgentAssistantRecord(
        com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord value) {
      if (agentAssistantRecordBuilder_ == null) {
        if (recordCase_ == 4
            && record_
                != com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord.getDefaultInstance()) {
          record_ =
              com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord) record_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          record_ = value;
        }
        onChanged();
      } else {
        if (recordCase_ == 4) {
          agentAssistantRecordBuilder_.mergeFrom(value);
        } else {
          agentAssistantRecordBuilder_.setMessage(value);
        }
      }
      recordCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The record for human agent assistant.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AgentAssistantRecord agent_assistant_record = 4;
     * </code>
     */
    public Builder clearAgentAssistantRecord() {
      if (agentAssistantRecordBuilder_ == null) {
        if (recordCase_ == 4) {
          recordCase_ = 0;
          record_ = null;
          onChanged();
        }
      } else {
        if (recordCase_ == 4) {
          recordCase_ = 0;
          record_ = null;
        }
        agentAssistantRecordBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The record for human agent assistant.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AgentAssistantRecord agent_assistant_record = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord.Builder
        getAgentAssistantRecordBuilder() {
      return getAgentAssistantRecordFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The record for human agent assistant.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AgentAssistantRecord agent_assistant_record = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AgentAssistantRecordOrBuilder
        getAgentAssistantRecordOrBuilder() {
      if ((recordCase_ == 4) && (agentAssistantRecordBuilder_ != null)) {
        return agentAssistantRecordBuilder_.getMessageOrBuilder();
      } else {
        if (recordCase_ == 4) {
          return (com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord) record_;
        }
        return com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The record for human agent assistant.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AgentAssistantRecord agent_assistant_record = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord,
            com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord.Builder,
            com.google.cloud.dialogflow.v2beta1.AgentAssistantRecordOrBuilder>
        getAgentAssistantRecordFieldBuilder() {
      if (agentAssistantRecordBuilder_ == null) {
        if (!(recordCase_ == 4)) {
          record_ = com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord.getDefaultInstance();
        }
        agentAssistantRecordBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord,
                com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord.Builder,
                com.google.cloud.dialogflow.v2beta1.AgentAssistantRecordOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.AgentAssistantRecord) record_,
                getParentForChildren(),
                isClean());
        record_ = null;
      }
      recordCase_ = 4;
      onChanged();
      return agentAssistantRecordBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.AnswerRecord)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.AnswerRecord)
  private static final com.google.cloud.dialogflow.v2beta1.AnswerRecord DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.AnswerRecord();
  }

  public static com.google.cloud.dialogflow.v2beta1.AnswerRecord getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnswerRecord> PARSER =
      new com.google.protobuf.AbstractParser<AnswerRecord>() {
        @java.lang.Override
        public AnswerRecord parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnswerRecord> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnswerRecord> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AnswerRecord getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
