/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/audio_config.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Configuration of the barge-in behavior. Barge-in instructs the API to return
 * a detected utterance at a proper time while the client is playing back the
 * response audio from a previous request. When the client sees the
 * utterance, it should stop the playback and immediately get ready for
 * receiving the responses for the current request.
 *
 * The barge-in handling requires the client to start streaming audio input
 * as soon as it starts playing back the audio from the previous response. The
 * playback is modeled into two phases:
 *
 * * No barge-in phase: which goes first and during which speech detection
 *   should not be carried out.
 *
 * * Barge-in phase: which follows the no barge-in phase and during which
 *   the API starts speech detection and may inform the client that an utterance
 *   has been detected. Note that no-speech event is not expected in this
 *   phase.
 *
 * The client provides this configuration in terms of the durations of those
 * two phases. The durations are measured in terms of the audio length fromt the
 * the start of the input audio.
 *
 * The flow goes like below:
 *
 * --&gt; Time
 *
 * without speech detection  | utterance only | utterance or no-speech event
 *                           |                |
 *           +-------------+ | +------------+ | +---------------+
 * ----------+ no barge-in +-|-+  barge-in  +-|-+ normal period +-----------
 *           +-------------+ | +------------+ | +---------------+
 *
 * No-speech event is a response with END_OF_UTTERANCE without any transcript
 * following up.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.BargeInConfig}
 */
public final class BargeInConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.BargeInConfig)
    BargeInConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BargeInConfig.newBuilder() to construct.
  private BargeInConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BargeInConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BargeInConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
        .internal_static_google_cloud_dialogflow_v2beta1_BargeInConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
        .internal_static_google_cloud_dialogflow_v2beta1_BargeInConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.BargeInConfig.class,
            com.google.cloud.dialogflow.v2beta1.BargeInConfig.Builder.class);
  }

  public static final int NO_BARGE_IN_DURATION_FIELD_NUMBER = 1;
  private com.google.protobuf.Duration noBargeInDuration_;
  /**
   *
   *
   * <pre>
   * Duration that is not eligible for barge-in at the beginning of the input
   * audio.
   * </pre>
   *
   * <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
   *
   * @return Whether the noBargeInDuration field is set.
   */
  @java.lang.Override
  public boolean hasNoBargeInDuration() {
    return noBargeInDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Duration that is not eligible for barge-in at the beginning of the input
   * audio.
   * </pre>
   *
   * <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
   *
   * @return The noBargeInDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getNoBargeInDuration() {
    return noBargeInDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : noBargeInDuration_;
  }
  /**
   *
   *
   * <pre>
   * Duration that is not eligible for barge-in at the beginning of the input
   * audio.
   * </pre>
   *
   * <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getNoBargeInDurationOrBuilder() {
    return noBargeInDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : noBargeInDuration_;
  }

  public static final int TOTAL_DURATION_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration totalDuration_;
  /**
   *
   *
   * <pre>
   * Total duration for the playback at the beginning of the input audio.
   * </pre>
   *
   * <code>.google.protobuf.Duration total_duration = 2;</code>
   *
   * @return Whether the totalDuration field is set.
   */
  @java.lang.Override
  public boolean hasTotalDuration() {
    return totalDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Total duration for the playback at the beginning of the input audio.
   * </pre>
   *
   * <code>.google.protobuf.Duration total_duration = 2;</code>
   *
   * @return The totalDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTotalDuration() {
    return totalDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : totalDuration_;
  }
  /**
   *
   *
   * <pre>
   * Total duration for the playback at the beginning of the input audio.
   * </pre>
   *
   * <code>.google.protobuf.Duration total_duration = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTotalDurationOrBuilder() {
    return totalDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : totalDuration_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (noBargeInDuration_ != null) {
      output.writeMessage(1, getNoBargeInDuration());
    }
    if (totalDuration_ != null) {
      output.writeMessage(2, getTotalDuration());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (noBargeInDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getNoBargeInDuration());
    }
    if (totalDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTotalDuration());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.BargeInConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.BargeInConfig other =
        (com.google.cloud.dialogflow.v2beta1.BargeInConfig) obj;

    if (hasNoBargeInDuration() != other.hasNoBargeInDuration()) return false;
    if (hasNoBargeInDuration()) {
      if (!getNoBargeInDuration().equals(other.getNoBargeInDuration())) return false;
    }
    if (hasTotalDuration() != other.hasTotalDuration()) return false;
    if (hasTotalDuration()) {
      if (!getTotalDuration().equals(other.getTotalDuration())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasNoBargeInDuration()) {
      hash = (37 * hash) + NO_BARGE_IN_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getNoBargeInDuration().hashCode();
    }
    if (hasTotalDuration()) {
      hash = (37 * hash) + TOTAL_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getTotalDuration().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.BargeInConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.BargeInConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BargeInConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.BargeInConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BargeInConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.BargeInConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BargeInConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.BargeInConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BargeInConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.BargeInConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BargeInConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.BargeInConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.BargeInConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration of the barge-in behavior. Barge-in instructs the API to return
   * a detected utterance at a proper time while the client is playing back the
   * response audio from a previous request. When the client sees the
   * utterance, it should stop the playback and immediately get ready for
   * receiving the responses for the current request.
   *
   * The barge-in handling requires the client to start streaming audio input
   * as soon as it starts playing back the audio from the previous response. The
   * playback is modeled into two phases:
   *
   * * No barge-in phase: which goes first and during which speech detection
   *   should not be carried out.
   *
   * * Barge-in phase: which follows the no barge-in phase and during which
   *   the API starts speech detection and may inform the client that an utterance
   *   has been detected. Note that no-speech event is not expected in this
   *   phase.
   *
   * The client provides this configuration in terms of the durations of those
   * two phases. The durations are measured in terms of the audio length fromt the
   * the start of the input audio.
   *
   * The flow goes like below:
   *
   * --&gt; Time
   *
   * without speech detection  | utterance only | utterance or no-speech event
   *                           |                |
   *           +-------------+ | +------------+ | +---------------+
   * ----------+ no barge-in +-|-+  barge-in  +-|-+ normal period +-----------
   *           +-------------+ | +------------+ | +---------------+
   *
   * No-speech event is a response with END_OF_UTTERANCE without any transcript
   * following up.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.BargeInConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.BargeInConfig)
      com.google.cloud.dialogflow.v2beta1.BargeInConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
          .internal_static_google_cloud_dialogflow_v2beta1_BargeInConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
          .internal_static_google_cloud_dialogflow_v2beta1_BargeInConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.BargeInConfig.class,
              com.google.cloud.dialogflow.v2beta1.BargeInConfig.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.BargeInConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      noBargeInDuration_ = null;
      if (noBargeInDurationBuilder_ != null) {
        noBargeInDurationBuilder_.dispose();
        noBargeInDurationBuilder_ = null;
      }
      totalDuration_ = null;
      if (totalDurationBuilder_ != null) {
        totalDurationBuilder_.dispose();
        totalDurationBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.AudioConfigProto
          .internal_static_google_cloud_dialogflow_v2beta1_BargeInConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.BargeInConfig getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.BargeInConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.BargeInConfig build() {
      com.google.cloud.dialogflow.v2beta1.BargeInConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.BargeInConfig buildPartial() {
      com.google.cloud.dialogflow.v2beta1.BargeInConfig result =
          new com.google.cloud.dialogflow.v2beta1.BargeInConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.BargeInConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.noBargeInDuration_ =
            noBargeInDurationBuilder_ == null
                ? noBargeInDuration_
                : noBargeInDurationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.totalDuration_ =
            totalDurationBuilder_ == null ? totalDuration_ : totalDurationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.BargeInConfig) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.BargeInConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.BargeInConfig other) {
      if (other == com.google.cloud.dialogflow.v2beta1.BargeInConfig.getDefaultInstance())
        return this;
      if (other.hasNoBargeInDuration()) {
        mergeNoBargeInDuration(other.getNoBargeInDuration());
      }
      if (other.hasTotalDuration()) {
        mergeTotalDuration(other.getTotalDuration());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getNoBargeInDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTotalDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Duration noBargeInDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        noBargeInDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Duration that is not eligible for barge-in at the beginning of the input
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
     *
     * @return Whether the noBargeInDuration field is set.
     */
    public boolean hasNoBargeInDuration() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Duration that is not eligible for barge-in at the beginning of the input
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
     *
     * @return The noBargeInDuration.
     */
    public com.google.protobuf.Duration getNoBargeInDuration() {
      if (noBargeInDurationBuilder_ == null) {
        return noBargeInDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : noBargeInDuration_;
      } else {
        return noBargeInDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Duration that is not eligible for barge-in at the beginning of the input
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
     */
    public Builder setNoBargeInDuration(com.google.protobuf.Duration value) {
      if (noBargeInDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        noBargeInDuration_ = value;
      } else {
        noBargeInDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration that is not eligible for barge-in at the beginning of the input
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
     */
    public Builder setNoBargeInDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (noBargeInDurationBuilder_ == null) {
        noBargeInDuration_ = builderForValue.build();
      } else {
        noBargeInDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration that is not eligible for barge-in at the beginning of the input
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
     */
    public Builder mergeNoBargeInDuration(com.google.protobuf.Duration value) {
      if (noBargeInDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && noBargeInDuration_ != null
            && noBargeInDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getNoBargeInDurationBuilder().mergeFrom(value);
        } else {
          noBargeInDuration_ = value;
        }
      } else {
        noBargeInDurationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration that is not eligible for barge-in at the beginning of the input
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
     */
    public Builder clearNoBargeInDuration() {
      bitField0_ = (bitField0_ & ~0x00000001);
      noBargeInDuration_ = null;
      if (noBargeInDurationBuilder_ != null) {
        noBargeInDurationBuilder_.dispose();
        noBargeInDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Duration that is not eligible for barge-in at the beginning of the input
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
     */
    public com.google.protobuf.Duration.Builder getNoBargeInDurationBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getNoBargeInDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Duration that is not eligible for barge-in at the beginning of the input
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
     */
    public com.google.protobuf.DurationOrBuilder getNoBargeInDurationOrBuilder() {
      if (noBargeInDurationBuilder_ != null) {
        return noBargeInDurationBuilder_.getMessageOrBuilder();
      } else {
        return noBargeInDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : noBargeInDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Duration that is not eligible for barge-in at the beginning of the input
     * audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getNoBargeInDurationFieldBuilder() {
      if (noBargeInDurationBuilder_ == null) {
        noBargeInDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getNoBargeInDuration(), getParentForChildren(), isClean());
        noBargeInDuration_ = null;
      }
      return noBargeInDurationBuilder_;
    }

    private com.google.protobuf.Duration totalDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        totalDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Total duration for the playback at the beginning of the input audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 2;</code>
     *
     * @return Whether the totalDuration field is set.
     */
    public boolean hasTotalDuration() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Total duration for the playback at the beginning of the input audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 2;</code>
     *
     * @return The totalDuration.
     */
    public com.google.protobuf.Duration getTotalDuration() {
      if (totalDurationBuilder_ == null) {
        return totalDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : totalDuration_;
      } else {
        return totalDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Total duration for the playback at the beginning of the input audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 2;</code>
     */
    public Builder setTotalDuration(com.google.protobuf.Duration value) {
      if (totalDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        totalDuration_ = value;
      } else {
        totalDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total duration for the playback at the beginning of the input audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 2;</code>
     */
    public Builder setTotalDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (totalDurationBuilder_ == null) {
        totalDuration_ = builderForValue.build();
      } else {
        totalDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total duration for the playback at the beginning of the input audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 2;</code>
     */
    public Builder mergeTotalDuration(com.google.protobuf.Duration value) {
      if (totalDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && totalDuration_ != null
            && totalDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTotalDurationBuilder().mergeFrom(value);
        } else {
          totalDuration_ = value;
        }
      } else {
        totalDurationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total duration for the playback at the beginning of the input audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 2;</code>
     */
    public Builder clearTotalDuration() {
      bitField0_ = (bitField0_ & ~0x00000002);
      totalDuration_ = null;
      if (totalDurationBuilder_ != null) {
        totalDurationBuilder_.dispose();
        totalDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total duration for the playback at the beginning of the input audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 2;</code>
     */
    public com.google.protobuf.Duration.Builder getTotalDurationBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTotalDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Total duration for the playback at the beginning of the input audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 2;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTotalDurationOrBuilder() {
      if (totalDurationBuilder_ != null) {
        return totalDurationBuilder_.getMessageOrBuilder();
      } else {
        return totalDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : totalDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Total duration for the playback at the beginning of the input audio.
     * </pre>
     *
     * <code>.google.protobuf.Duration total_duration = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTotalDurationFieldBuilder() {
      if (totalDurationBuilder_ == null) {
        totalDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTotalDuration(), getParentForChildren(), isClean());
        totalDuration_ = null;
      }
      return totalDurationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.BargeInConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.BargeInConfig)
  private static final com.google.cloud.dialogflow.v2beta1.BargeInConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.BargeInConfig();
  }

  public static com.google.cloud.dialogflow.v2beta1.BargeInConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BargeInConfig> PARSER =
      new com.google.protobuf.AbstractParser<BargeInConfig>() {
        @java.lang.Override
        public BargeInConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BargeInConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BargeInConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.BargeInConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
