/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/participant.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * One response of different type of suggestion response which is used in
 * the response of
 * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
 * and
 * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent],
 * as well as
 * [HumanAgentAssistantEvent][google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.SuggestionResult}
 */
public final class SuggestionResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.SuggestionResult)
    SuggestionResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SuggestionResult.newBuilder() to construct.
  private SuggestionResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SuggestionResult() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SuggestionResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_SuggestionResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_SuggestionResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.SuggestionResult.class,
            com.google.cloud.dialogflow.v2beta1.SuggestionResult.Builder.class);
  }

  private int suggestionResponseCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object suggestionResponse_;

  public enum SuggestionResponseCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ERROR(1),
    SUGGEST_ARTICLES_RESPONSE(2),
    SUGGEST_FAQ_ANSWERS_RESPONSE(3),
    SUGGEST_SMART_REPLIES_RESPONSE(4),
    SUGGESTIONRESPONSE_NOT_SET(0);
    private final int value;

    private SuggestionResponseCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SuggestionResponseCase valueOf(int value) {
      return forNumber(value);
    }

    public static SuggestionResponseCase forNumber(int value) {
      switch (value) {
        case 1:
          return ERROR;
        case 2:
          return SUGGEST_ARTICLES_RESPONSE;
        case 3:
          return SUGGEST_FAQ_ANSWERS_RESPONSE;
        case 4:
          return SUGGEST_SMART_REPLIES_RESPONSE;
        case 0:
          return SUGGESTIONRESPONSE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SuggestionResponseCase getSuggestionResponseCase() {
    return SuggestionResponseCase.forNumber(suggestionResponseCase_);
  }

  public static final int ERROR_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Error status if the request failed.
   * </pre>
   *
   * <code>.google.rpc.Status error = 1;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return suggestionResponseCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Error status if the request failed.
   * </pre>
   *
   * <code>.google.rpc.Status error = 1;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    if (suggestionResponseCase_ == 1) {
      return (com.google.rpc.Status) suggestionResponse_;
    }
    return com.google.rpc.Status.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Error status if the request failed.
   * </pre>
   *
   * <code>.google.rpc.Status error = 1;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    if (suggestionResponseCase_ == 1) {
      return (com.google.rpc.Status) suggestionResponse_;
    }
    return com.google.rpc.Status.getDefaultInstance();
  }

  public static final int SUGGEST_ARTICLES_RESPONSE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse suggest_articles_response = 2;
   * </code>
   *
   * @return Whether the suggestArticlesResponse field is set.
   */
  @java.lang.Override
  public boolean hasSuggestArticlesResponse() {
    return suggestionResponseCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse suggest_articles_response = 2;
   * </code>
   *
   * @return The suggestArticlesResponse.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse getSuggestArticlesResponse() {
    if (suggestionResponseCase_ == 2) {
      return (com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse) suggestionResponse_;
    }
    return com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse suggest_articles_response = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponseOrBuilder
      getSuggestArticlesResponseOrBuilder() {
    if (suggestionResponseCase_ == 2) {
      return (com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse) suggestionResponse_;
    }
    return com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.getDefaultInstance();
  }

  public static final int SUGGEST_FAQ_ANSWERS_RESPONSE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse suggest_faq_answers_response = 3;
   * </code>
   *
   * @return Whether the suggestFaqAnswersResponse field is set.
   */
  @java.lang.Override
  public boolean hasSuggestFaqAnswersResponse() {
    return suggestionResponseCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse suggest_faq_answers_response = 3;
   * </code>
   *
   * @return The suggestFaqAnswersResponse.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse
      getSuggestFaqAnswersResponse() {
    if (suggestionResponseCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse) suggestionResponse_;
    }
    return com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse suggest_faq_answers_response = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponseOrBuilder
      getSuggestFaqAnswersResponseOrBuilder() {
    if (suggestionResponseCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse) suggestionResponse_;
    }
    return com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.getDefaultInstance();
  }

  public static final int SUGGEST_SMART_REPLIES_RESPONSE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * SuggestSmartRepliesResponse if request is for SMART_REPLY.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse suggest_smart_replies_response = 4;
   * </code>
   *
   * @return Whether the suggestSmartRepliesResponse field is set.
   */
  @java.lang.Override
  public boolean hasSuggestSmartRepliesResponse() {
    return suggestionResponseCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * SuggestSmartRepliesResponse if request is for SMART_REPLY.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse suggest_smart_replies_response = 4;
   * </code>
   *
   * @return The suggestSmartRepliesResponse.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse
      getSuggestSmartRepliesResponse() {
    if (suggestionResponseCase_ == 4) {
      return (com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse) suggestionResponse_;
    }
    return com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * SuggestSmartRepliesResponse if request is for SMART_REPLY.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse suggest_smart_replies_response = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponseOrBuilder
      getSuggestSmartRepliesResponseOrBuilder() {
    if (suggestionResponseCase_ == 4) {
      return (com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse) suggestionResponse_;
    }
    return com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (suggestionResponseCase_ == 1) {
      output.writeMessage(1, (com.google.rpc.Status) suggestionResponse_);
    }
    if (suggestionResponseCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse) suggestionResponse_);
    }
    if (suggestionResponseCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse) suggestionResponse_);
    }
    if (suggestionResponseCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse) suggestionResponse_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (suggestionResponseCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.rpc.Status) suggestionResponse_);
    }
    if (suggestionResponseCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse) suggestionResponse_);
    }
    if (suggestionResponseCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse) suggestionResponse_);
    }
    if (suggestionResponseCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse)
                  suggestionResponse_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.SuggestionResult)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.SuggestionResult other =
        (com.google.cloud.dialogflow.v2beta1.SuggestionResult) obj;

    if (!getSuggestionResponseCase().equals(other.getSuggestionResponseCase())) return false;
    switch (suggestionResponseCase_) {
      case 1:
        if (!getError().equals(other.getError())) return false;
        break;
      case 2:
        if (!getSuggestArticlesResponse().equals(other.getSuggestArticlesResponse())) return false;
        break;
      case 3:
        if (!getSuggestFaqAnswersResponse().equals(other.getSuggestFaqAnswersResponse()))
          return false;
        break;
      case 4:
        if (!getSuggestSmartRepliesResponse().equals(other.getSuggestSmartRepliesResponse()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (suggestionResponseCase_) {
      case 1:
        hash = (37 * hash) + ERROR_FIELD_NUMBER;
        hash = (53 * hash) + getError().hashCode();
        break;
      case 2:
        hash = (37 * hash) + SUGGEST_ARTICLES_RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getSuggestArticlesResponse().hashCode();
        break;
      case 3:
        hash = (37 * hash) + SUGGEST_FAQ_ANSWERS_RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getSuggestFaqAnswersResponse().hashCode();
        break;
      case 4:
        hash = (37 * hash) + SUGGEST_SMART_REPLIES_RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getSuggestSmartRepliesResponse().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.SuggestionResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * One response of different type of suggestion response which is used in
   * the response of
   * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
   * and
   * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent],
   * as well as
   * [HumanAgentAssistantEvent][google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.SuggestionResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.SuggestionResult)
      com.google.cloud.dialogflow.v2beta1.SuggestionResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_SuggestionResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_SuggestionResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.SuggestionResult.class,
              com.google.cloud.dialogflow.v2beta1.SuggestionResult.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.SuggestionResult.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (errorBuilder_ != null) {
        errorBuilder_.clear();
      }
      if (suggestArticlesResponseBuilder_ != null) {
        suggestArticlesResponseBuilder_.clear();
      }
      if (suggestFaqAnswersResponseBuilder_ != null) {
        suggestFaqAnswersResponseBuilder_.clear();
      }
      if (suggestSmartRepliesResponseBuilder_ != null) {
        suggestSmartRepliesResponseBuilder_.clear();
      }
      suggestionResponseCase_ = 0;
      suggestionResponse_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_SuggestionResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestionResult getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.SuggestionResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestionResult build() {
      com.google.cloud.dialogflow.v2beta1.SuggestionResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestionResult buildPartial() {
      com.google.cloud.dialogflow.v2beta1.SuggestionResult result =
          new com.google.cloud.dialogflow.v2beta1.SuggestionResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.SuggestionResult result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.v2beta1.SuggestionResult result) {
      result.suggestionResponseCase_ = suggestionResponseCase_;
      result.suggestionResponse_ = this.suggestionResponse_;
      if (suggestionResponseCase_ == 1 && errorBuilder_ != null) {
        result.suggestionResponse_ = errorBuilder_.build();
      }
      if (suggestionResponseCase_ == 2 && suggestArticlesResponseBuilder_ != null) {
        result.suggestionResponse_ = suggestArticlesResponseBuilder_.build();
      }
      if (suggestionResponseCase_ == 3 && suggestFaqAnswersResponseBuilder_ != null) {
        result.suggestionResponse_ = suggestFaqAnswersResponseBuilder_.build();
      }
      if (suggestionResponseCase_ == 4 && suggestSmartRepliesResponseBuilder_ != null) {
        result.suggestionResponse_ = suggestSmartRepliesResponseBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.SuggestionResult) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.SuggestionResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.SuggestionResult other) {
      if (other == com.google.cloud.dialogflow.v2beta1.SuggestionResult.getDefaultInstance())
        return this;
      switch (other.getSuggestionResponseCase()) {
        case ERROR:
          {
            mergeError(other.getError());
            break;
          }
        case SUGGEST_ARTICLES_RESPONSE:
          {
            mergeSuggestArticlesResponse(other.getSuggestArticlesResponse());
            break;
          }
        case SUGGEST_FAQ_ANSWERS_RESPONSE:
          {
            mergeSuggestFaqAnswersResponse(other.getSuggestFaqAnswersResponse());
            break;
          }
        case SUGGEST_SMART_REPLIES_RESPONSE:
          {
            mergeSuggestSmartRepliesResponse(other.getSuggestSmartRepliesResponse());
            break;
          }
        case SUGGESTIONRESPONSE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                suggestionResponseCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getSuggestArticlesResponseFieldBuilder().getBuilder(), extensionRegistry);
                suggestionResponseCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getSuggestFaqAnswersResponseFieldBuilder().getBuilder(), extensionRegistry);
                suggestionResponseCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getSuggestSmartRepliesResponseFieldBuilder().getBuilder(), extensionRegistry);
                suggestionResponseCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int suggestionResponseCase_ = 0;
    private java.lang.Object suggestionResponse_;

    public SuggestionResponseCase getSuggestionResponseCase() {
      return SuggestionResponseCase.forNumber(suggestionResponseCase_);
    }

    public Builder clearSuggestionResponse() {
      suggestionResponseCase_ = 0;
      suggestionResponse_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * Error status if the request failed.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     *
     * @return Whether the error field is set.
     */
    @java.lang.Override
    public boolean hasError() {
      return suggestionResponseCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Error status if the request failed.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     *
     * @return The error.
     */
    @java.lang.Override
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        if (suggestionResponseCase_ == 1) {
          return (com.google.rpc.Status) suggestionResponse_;
        }
        return com.google.rpc.Status.getDefaultInstance();
      } else {
        if (suggestionResponseCase_ == 1) {
          return errorBuilder_.getMessage();
        }
        return com.google.rpc.Status.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Error status if the request failed.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestionResponse_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }
      suggestionResponseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error status if the request failed.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        suggestionResponse_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      suggestionResponseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error status if the request failed.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (suggestionResponseCase_ == 1
            && suggestionResponse_ != com.google.rpc.Status.getDefaultInstance()) {
          suggestionResponse_ =
              com.google.rpc.Status.newBuilder((com.google.rpc.Status) suggestionResponse_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          suggestionResponse_ = value;
        }
        onChanged();
      } else {
        if (suggestionResponseCase_ == 1) {
          errorBuilder_.mergeFrom(value);
        } else {
          errorBuilder_.setMessage(value);
        }
      }
      suggestionResponseCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error status if the request failed.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        if (suggestionResponseCase_ == 1) {
          suggestionResponseCase_ = 0;
          suggestionResponse_ = null;
          onChanged();
        }
      } else {
        if (suggestionResponseCase_ == 1) {
          suggestionResponseCase_ = 0;
          suggestionResponse_ = null;
        }
        errorBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Error status if the request failed.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Error status if the request failed.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if ((suggestionResponseCase_ == 1) && (errorBuilder_ != null)) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        if (suggestionResponseCase_ == 1) {
          return (com.google.rpc.Status) suggestionResponse_;
        }
        return com.google.rpc.Status.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Error status if the request failed.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        if (!(suggestionResponseCase_ == 1)) {
          suggestionResponse_ = com.google.rpc.Status.getDefaultInstance();
        }
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                (com.google.rpc.Status) suggestionResponse_, getParentForChildren(), isClean());
        suggestionResponse_ = null;
      }
      suggestionResponseCase_ = 1;
      onChanged();
      return errorBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse,
            com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.Builder,
            com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponseOrBuilder>
        suggestArticlesResponseBuilder_;
    /**
     *
     *
     * <pre>
     * SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse suggest_articles_response = 2;
     * </code>
     *
     * @return Whether the suggestArticlesResponse field is set.
     */
    @java.lang.Override
    public boolean hasSuggestArticlesResponse() {
      return suggestionResponseCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse suggest_articles_response = 2;
     * </code>
     *
     * @return The suggestArticlesResponse.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse
        getSuggestArticlesResponse() {
      if (suggestArticlesResponseBuilder_ == null) {
        if (suggestionResponseCase_ == 2) {
          return (com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse) suggestionResponse_;
        }
        return com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.getDefaultInstance();
      } else {
        if (suggestionResponseCase_ == 2) {
          return suggestArticlesResponseBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse suggest_articles_response = 2;
     * </code>
     */
    public Builder setSuggestArticlesResponse(
        com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse value) {
      if (suggestArticlesResponseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestionResponse_ = value;
        onChanged();
      } else {
        suggestArticlesResponseBuilder_.setMessage(value);
      }
      suggestionResponseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse suggest_articles_response = 2;
     * </code>
     */
    public Builder setSuggestArticlesResponse(
        com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.Builder builderForValue) {
      if (suggestArticlesResponseBuilder_ == null) {
        suggestionResponse_ = builderForValue.build();
        onChanged();
      } else {
        suggestArticlesResponseBuilder_.setMessage(builderForValue.build());
      }
      suggestionResponseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse suggest_articles_response = 2;
     * </code>
     */
    public Builder mergeSuggestArticlesResponse(
        com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse value) {
      if (suggestArticlesResponseBuilder_ == null) {
        if (suggestionResponseCase_ == 2
            && suggestionResponse_
                != com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse
                    .getDefaultInstance()) {
          suggestionResponse_ =
              com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse)
                          suggestionResponse_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          suggestionResponse_ = value;
        }
        onChanged();
      } else {
        if (suggestionResponseCase_ == 2) {
          suggestArticlesResponseBuilder_.mergeFrom(value);
        } else {
          suggestArticlesResponseBuilder_.setMessage(value);
        }
      }
      suggestionResponseCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse suggest_articles_response = 2;
     * </code>
     */
    public Builder clearSuggestArticlesResponse() {
      if (suggestArticlesResponseBuilder_ == null) {
        if (suggestionResponseCase_ == 2) {
          suggestionResponseCase_ = 0;
          suggestionResponse_ = null;
          onChanged();
        }
      } else {
        if (suggestionResponseCase_ == 2) {
          suggestionResponseCase_ = 0;
          suggestionResponse_ = null;
        }
        suggestArticlesResponseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse suggest_articles_response = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.Builder
        getSuggestArticlesResponseBuilder() {
      return getSuggestArticlesResponseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse suggest_articles_response = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponseOrBuilder
        getSuggestArticlesResponseOrBuilder() {
      if ((suggestionResponseCase_ == 2) && (suggestArticlesResponseBuilder_ != null)) {
        return suggestArticlesResponseBuilder_.getMessageOrBuilder();
      } else {
        if (suggestionResponseCase_ == 2) {
          return (com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse) suggestionResponse_;
        }
        return com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse suggest_articles_response = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse,
            com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.Builder,
            com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponseOrBuilder>
        getSuggestArticlesResponseFieldBuilder() {
      if (suggestArticlesResponseBuilder_ == null) {
        if (!(suggestionResponseCase_ == 2)) {
          suggestionResponse_ =
              com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.getDefaultInstance();
        }
        suggestArticlesResponseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse,
                com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.Builder,
                com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponseOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.SuggestArticlesResponse) suggestionResponse_,
                getParentForChildren(),
                isClean());
        suggestionResponse_ = null;
      }
      suggestionResponseCase_ = 2;
      onChanged();
      return suggestArticlesResponseBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse,
            com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.Builder,
            com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponseOrBuilder>
        suggestFaqAnswersResponseBuilder_;
    /**
     *
     *
     * <pre>
     * SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse suggest_faq_answers_response = 3;
     * </code>
     *
     * @return Whether the suggestFaqAnswersResponse field is set.
     */
    @java.lang.Override
    public boolean hasSuggestFaqAnswersResponse() {
      return suggestionResponseCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse suggest_faq_answers_response = 3;
     * </code>
     *
     * @return The suggestFaqAnswersResponse.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse
        getSuggestFaqAnswersResponse() {
      if (suggestFaqAnswersResponseBuilder_ == null) {
        if (suggestionResponseCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse)
              suggestionResponse_;
        }
        return com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.getDefaultInstance();
      } else {
        if (suggestionResponseCase_ == 3) {
          return suggestFaqAnswersResponseBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse suggest_faq_answers_response = 3;
     * </code>
     */
    public Builder setSuggestFaqAnswersResponse(
        com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse value) {
      if (suggestFaqAnswersResponseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestionResponse_ = value;
        onChanged();
      } else {
        suggestFaqAnswersResponseBuilder_.setMessage(value);
      }
      suggestionResponseCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse suggest_faq_answers_response = 3;
     * </code>
     */
    public Builder setSuggestFaqAnswersResponse(
        com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.Builder builderForValue) {
      if (suggestFaqAnswersResponseBuilder_ == null) {
        suggestionResponse_ = builderForValue.build();
        onChanged();
      } else {
        suggestFaqAnswersResponseBuilder_.setMessage(builderForValue.build());
      }
      suggestionResponseCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse suggest_faq_answers_response = 3;
     * </code>
     */
    public Builder mergeSuggestFaqAnswersResponse(
        com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse value) {
      if (suggestFaqAnswersResponseBuilder_ == null) {
        if (suggestionResponseCase_ == 3
            && suggestionResponse_
                != com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse
                    .getDefaultInstance()) {
          suggestionResponse_ =
              com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse)
                          suggestionResponse_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          suggestionResponse_ = value;
        }
        onChanged();
      } else {
        if (suggestionResponseCase_ == 3) {
          suggestFaqAnswersResponseBuilder_.mergeFrom(value);
        } else {
          suggestFaqAnswersResponseBuilder_.setMessage(value);
        }
      }
      suggestionResponseCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse suggest_faq_answers_response = 3;
     * </code>
     */
    public Builder clearSuggestFaqAnswersResponse() {
      if (suggestFaqAnswersResponseBuilder_ == null) {
        if (suggestionResponseCase_ == 3) {
          suggestionResponseCase_ = 0;
          suggestionResponse_ = null;
          onChanged();
        }
      } else {
        if (suggestionResponseCase_ == 3) {
          suggestionResponseCase_ = 0;
          suggestionResponse_ = null;
        }
        suggestFaqAnswersResponseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse suggest_faq_answers_response = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.Builder
        getSuggestFaqAnswersResponseBuilder() {
      return getSuggestFaqAnswersResponseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse suggest_faq_answers_response = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponseOrBuilder
        getSuggestFaqAnswersResponseOrBuilder() {
      if ((suggestionResponseCase_ == 3) && (suggestFaqAnswersResponseBuilder_ != null)) {
        return suggestFaqAnswersResponseBuilder_.getMessageOrBuilder();
      } else {
        if (suggestionResponseCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse)
              suggestionResponse_;
        }
        return com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse suggest_faq_answers_response = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse,
            com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.Builder,
            com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponseOrBuilder>
        getSuggestFaqAnswersResponseFieldBuilder() {
      if (suggestFaqAnswersResponseBuilder_ == null) {
        if (!(suggestionResponseCase_ == 3)) {
          suggestionResponse_ =
              com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.getDefaultInstance();
        }
        suggestFaqAnswersResponseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse,
                com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.Builder,
                com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponseOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse) suggestionResponse_,
                getParentForChildren(),
                isClean());
        suggestionResponse_ = null;
      }
      suggestionResponseCase_ = 3;
      onChanged();
      return suggestFaqAnswersResponseBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse,
            com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.Builder,
            com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponseOrBuilder>
        suggestSmartRepliesResponseBuilder_;
    /**
     *
     *
     * <pre>
     * SuggestSmartRepliesResponse if request is for SMART_REPLY.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse suggest_smart_replies_response = 4;
     * </code>
     *
     * @return Whether the suggestSmartRepliesResponse field is set.
     */
    @java.lang.Override
    public boolean hasSuggestSmartRepliesResponse() {
      return suggestionResponseCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * SuggestSmartRepliesResponse if request is for SMART_REPLY.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse suggest_smart_replies_response = 4;
     * </code>
     *
     * @return The suggestSmartRepliesResponse.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse
        getSuggestSmartRepliesResponse() {
      if (suggestSmartRepliesResponseBuilder_ == null) {
        if (suggestionResponseCase_ == 4) {
          return (com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse)
              suggestionResponse_;
        }
        return com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.getDefaultInstance();
      } else {
        if (suggestionResponseCase_ == 4) {
          return suggestSmartRepliesResponseBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * SuggestSmartRepliesResponse if request is for SMART_REPLY.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse suggest_smart_replies_response = 4;
     * </code>
     */
    public Builder setSuggestSmartRepliesResponse(
        com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse value) {
      if (suggestSmartRepliesResponseBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestionResponse_ = value;
        onChanged();
      } else {
        suggestSmartRepliesResponseBuilder_.setMessage(value);
      }
      suggestionResponseCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * SuggestSmartRepliesResponse if request is for SMART_REPLY.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse suggest_smart_replies_response = 4;
     * </code>
     */
    public Builder setSuggestSmartRepliesResponse(
        com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.Builder builderForValue) {
      if (suggestSmartRepliesResponseBuilder_ == null) {
        suggestionResponse_ = builderForValue.build();
        onChanged();
      } else {
        suggestSmartRepliesResponseBuilder_.setMessage(builderForValue.build());
      }
      suggestionResponseCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * SuggestSmartRepliesResponse if request is for SMART_REPLY.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse suggest_smart_replies_response = 4;
     * </code>
     */
    public Builder mergeSuggestSmartRepliesResponse(
        com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse value) {
      if (suggestSmartRepliesResponseBuilder_ == null) {
        if (suggestionResponseCase_ == 4
            && suggestionResponse_
                != com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse
                    .getDefaultInstance()) {
          suggestionResponse_ =
              com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse)
                          suggestionResponse_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          suggestionResponse_ = value;
        }
        onChanged();
      } else {
        if (suggestionResponseCase_ == 4) {
          suggestSmartRepliesResponseBuilder_.mergeFrom(value);
        } else {
          suggestSmartRepliesResponseBuilder_.setMessage(value);
        }
      }
      suggestionResponseCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * SuggestSmartRepliesResponse if request is for SMART_REPLY.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse suggest_smart_replies_response = 4;
     * </code>
     */
    public Builder clearSuggestSmartRepliesResponse() {
      if (suggestSmartRepliesResponseBuilder_ == null) {
        if (suggestionResponseCase_ == 4) {
          suggestionResponseCase_ = 0;
          suggestionResponse_ = null;
          onChanged();
        }
      } else {
        if (suggestionResponseCase_ == 4) {
          suggestionResponseCase_ = 0;
          suggestionResponse_ = null;
        }
        suggestSmartRepliesResponseBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * SuggestSmartRepliesResponse if request is for SMART_REPLY.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse suggest_smart_replies_response = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.Builder
        getSuggestSmartRepliesResponseBuilder() {
      return getSuggestSmartRepliesResponseFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * SuggestSmartRepliesResponse if request is for SMART_REPLY.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse suggest_smart_replies_response = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponseOrBuilder
        getSuggestSmartRepliesResponseOrBuilder() {
      if ((suggestionResponseCase_ == 4) && (suggestSmartRepliesResponseBuilder_ != null)) {
        return suggestSmartRepliesResponseBuilder_.getMessageOrBuilder();
      } else {
        if (suggestionResponseCase_ == 4) {
          return (com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse)
              suggestionResponse_;
        }
        return com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * SuggestSmartRepliesResponse if request is for SMART_REPLY.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse suggest_smart_replies_response = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse,
            com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.Builder,
            com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponseOrBuilder>
        getSuggestSmartRepliesResponseFieldBuilder() {
      if (suggestSmartRepliesResponseBuilder_ == null) {
        if (!(suggestionResponseCase_ == 4)) {
          suggestionResponse_ =
              com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.getDefaultInstance();
        }
        suggestSmartRepliesResponseBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse,
                com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.Builder,
                com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponseOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse)
                    suggestionResponse_,
                getParentForChildren(),
                isClean());
        suggestionResponse_ = null;
      }
      suggestionResponseCase_ = 4;
      onChanged();
      return suggestSmartRepliesResponseBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.SuggestionResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.SuggestionResult)
  private static final com.google.cloud.dialogflow.v2beta1.SuggestionResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.SuggestionResult();
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SuggestionResult> PARSER =
      new com.google.protobuf.AbstractParser<SuggestionResult>() {
        @java.lang.Override
        public SuggestionResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SuggestionResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SuggestionResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SuggestionResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
