/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/entity_type.proto

package com.google.cloud.dialogflow.v2beta1;

public interface BatchDeleteEntitiesRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.BatchDeleteEntitiesRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The name of the entity type to delete entries for.
   * Supported formats:
   * - `projects/&lt;Project ID&gt;/agent/entityTypes/&lt;Entity Type ID&gt;`
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/entityTypes/&lt;Entity
   *   Type ID&gt;`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. The name of the entity type to delete entries for.
   * Supported formats:
   * - `projects/&lt;Project ID&gt;/agent/entityTypes/&lt;Entity Type ID&gt;`
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/entityTypes/&lt;Entity
   *   Type ID&gt;`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. The reference `values` of the entities to delete. Note that
   * these are not fully-qualified names, i.e. they don't start with
   * `projects/&lt;Project ID&gt;`.
   * </pre>
   *
   * <code>repeated string entity_values = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the entityValues.
   */
  java.util.List<java.lang.String> getEntityValuesList();
  /**
   *
   *
   * <pre>
   * Required. The reference `values` of the entities to delete. Note that
   * these are not fully-qualified names, i.e. they don't start with
   * `projects/&lt;Project ID&gt;`.
   * </pre>
   *
   * <code>repeated string entity_values = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of entityValues.
   */
  int getEntityValuesCount();
  /**
   *
   *
   * <pre>
   * Required. The reference `values` of the entities to delete. Note that
   * these are not fully-qualified names, i.e. they don't start with
   * `projects/&lt;Project ID&gt;`.
   * </pre>
   *
   * <code>repeated string entity_values = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The entityValues at the given index.
   */
  java.lang.String getEntityValues(int index);
  /**
   *
   *
   * <pre>
   * Required. The reference `values` of the entities to delete. Note that
   * these are not fully-qualified names, i.e. they don't start with
   * `projects/&lt;Project ID&gt;`.
   * </pre>
   *
   * <code>repeated string entity_values = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the entityValues at the given index.
   */
  com.google.protobuf.ByteString getEntityValuesBytes(int index);

  /**
   *
   *
   * <pre>
   * Optional. The language used to access language-specific data.
   * If not specified, the agent's default language is used.
   * For more information, see
   * [Multilingual intent and entity
   * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
   * </pre>
   *
   * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The languageCode.
   */
  java.lang.String getLanguageCode();
  /**
   *
   *
   * <pre>
   * Optional. The language used to access language-specific data.
   * If not specified, the agent's default language is used.
   * For more information, see
   * [Multilingual intent and entity
   * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
   * </pre>
   *
   * <code>string language_code = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for languageCode.
   */
  com.google.protobuf.ByteString getLanguageCodeBytes();
}
