/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EnvironmentContextName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/agent/environments/{environment}/users/{user}/sessions/{session}/contexts/{context}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String environment;
    private final String user;
    private final String session;
    private final String context;

    public String getProject() {
        return this.project;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getUser() {
        return this.user;
    }

    public String getSession() {
        return this.session;
    }

    public String getContext() {
        return this.context;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private EnvironmentContextName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.context = (String)Preconditions.checkNotNull((Object)builder.getContext());
    }

    public static EnvironmentContextName of(String project, String environment, String user, String session, String context) {
        return EnvironmentContextName.newBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).setContext(context).build();
    }

    public static String format(String project, String environment, String user, String session, String context) {
        return EnvironmentContextName.newBuilder().setProject(project).setEnvironment(environment).setUser(user).setSession(session).setContext(context).build().toString();
    }

    public static EnvironmentContextName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "EnvironmentContextName.parse: formattedString not in valid format");
        return EnvironmentContextName.of((String)matchMap.get("project"), (String)matchMap.get("environment"), (String)matchMap.get("user"), (String)matchMap.get("session"), (String)matchMap.get("context"));
    }

    public static List<EnvironmentContextName> parseList(List<String> formattedStrings) {
        ArrayList<EnvironmentContextName> list = new ArrayList<EnvironmentContextName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EnvironmentContextName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EnvironmentContextName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EnvironmentContextName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EnvironmentContextName environmentContextName = this;
            synchronized (environmentContextName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    fieldMapBuilder.put((Object)"user", (Object)this.user);
                    fieldMapBuilder.put((Object)"session", (Object)this.session);
                    fieldMapBuilder.put((Object)"context", (Object)this.context);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("EnvironmentContextName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "environment", this.environment, "user", this.user, "session", this.session, "context", this.context});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EnvironmentContextName) {
            EnvironmentContextName that = (EnvironmentContextName)o;
            return this.project.equals(that.project) && this.environment.equals(that.environment) && this.user.equals(that.user) && this.session.equals(that.session) && this.context.equals(that.context);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.environment.hashCode();
        h *= 1000003;
        h ^= this.user.hashCode();
        h *= 1000003;
        h ^= this.session.hashCode();
        h *= 1000003;
        return h ^= this.context.hashCode();
    }

    public static class Builder {
        private String project;
        private String environment;
        private String user;
        private String session;
        private String context;

        public String getProject() {
            return this.project;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getUser() {
            return this.user;
        }

        public String getSession() {
            return this.session;
        }

        public String getContext() {
            return this.context;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        public Builder setContext(String context) {
            this.context = context;
            return this;
        }

        private Builder() {
        }

        private Builder(EnvironmentContextName environmentContextName) {
            this.project = environmentContextName.project;
            this.environment = environmentContextName.environment;
            this.user = environmentContextName.user;
            this.session = environmentContextName.session;
            this.context = environmentContextName.context;
        }

        public EnvironmentContextName build() {
            return new EnvironmentContextName(this);
        }
    }
}

