/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/fulfillment.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * By default, your agent responds to a matched intent with a static response.
 * As an alternative, you can provide a more dynamic response by using
 * fulfillment. When you enable fulfillment for an intent, Dialogflow responds
 * to that intent by calling a service that you define. For example, if an
 * end-user wants to schedule a haircut on Friday, your service can check your
 * database and respond to the end-user with availability information for
 * Friday.
 *
 * For more information, see the [fulfillment
 * guide](https://cloud.google.com/dialogflow/docs/fulfillment-overview).
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.Fulfillment}
 */
public final class Fulfillment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Fulfillment)
    FulfillmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Fulfillment.newBuilder() to construct.
  private Fulfillment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Fulfillment() {
    name_ = "";
    displayName_ = "";
    features_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Fulfillment();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
        .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
        .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.Fulfillment.class,
            com.google.cloud.dialogflow.v2beta1.Fulfillment.Builder.class);
  }

  public interface GenericWebServiceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The fulfillment URI for receiving POST requests.
     * It must use https protocol.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * Required. The fulfillment URI for receiving POST requests.
     * It must use https protocol.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * The user name for HTTP Basic authentication.
     * </pre>
     *
     * <code>string username = 2;</code>
     *
     * @return The username.
     */
    java.lang.String getUsername();
    /**
     *
     *
     * <pre>
     * The user name for HTTP Basic authentication.
     * </pre>
     *
     * <code>string username = 2;</code>
     *
     * @return The bytes for username.
     */
    com.google.protobuf.ByteString getUsernameBytes();

    /**
     *
     *
     * <pre>
     * The password for HTTP Basic authentication.
     * </pre>
     *
     * <code>string password = 3;</code>
     *
     * @return The password.
     */
    java.lang.String getPassword();
    /**
     *
     *
     * <pre>
     * The password for HTTP Basic authentication.
     * </pre>
     *
     * <code>string password = 3;</code>
     *
     * @return The bytes for password.
     */
    com.google.protobuf.ByteString getPasswordBytes();

    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with fulfillment requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    int getRequestHeadersCount();
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with fulfillment requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    boolean containsRequestHeaders(java.lang.String key);
    /** Use {@link #getRequestHeadersMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getRequestHeaders();
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with fulfillment requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getRequestHeadersMap();
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with fulfillment requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    /* nullable */
    java.lang.String getRequestHeadersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with fulfillment requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    java.lang.String getRequestHeadersOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Optional. Indicates if generic web service is created through Cloud
     * Functions integration. Defaults to false.
     *
     * is_cloud_function is deprecated. Cloud functions can be configured by
     * its uri as a regular web service now.
     * </pre>
     *
     * <code>
     * bool is_cloud_function = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.is_cloud_function
     *     is deprecated. See google/cloud/dialogflow/v2beta1/fulfillment.proto;l=109
     * @return The isCloudFunction.
     */
    @java.lang.Deprecated
    boolean getIsCloudFunction();
  }
  /**
   *
   *
   * <pre>
   * Represents configuration for a generic web service.
   * Dialogflow supports two mechanisms for authentications:
   *
   * - Basic authentication with username and password.
   * - Authentication with additional authentication headers.
   *
   * More information could be found at:
   * https://cloud.google.com/dialogflow/docs/fulfillment-configure.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService}
   */
  public static final class GenericWebService extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService)
      GenericWebServiceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GenericWebService.newBuilder() to construct.
    private GenericWebService(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GenericWebService() {
      uri_ = "";
      username_ = "";
      password_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GenericWebService();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
          .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_GenericWebService_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetRequestHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
          .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_GenericWebService_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.class,
              com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.Builder.class);
    }

    public static final int URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The fulfillment URI for receiving POST requests.
     * It must use https protocol.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fulfillment URI for receiving POST requests.
     * It must use https protocol.
     * </pre>
     *
     * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int USERNAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object username_ = "";
    /**
     *
     *
     * <pre>
     * The user name for HTTP Basic authentication.
     * </pre>
     *
     * <code>string username = 2;</code>
     *
     * @return The username.
     */
    @java.lang.Override
    public java.lang.String getUsername() {
      java.lang.Object ref = username_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        username_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The user name for HTTP Basic authentication.
     * </pre>
     *
     * <code>string username = 2;</code>
     *
     * @return The bytes for username.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUsernameBytes() {
      java.lang.Object ref = username_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        username_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PASSWORD_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object password_ = "";
    /**
     *
     *
     * <pre>
     * The password for HTTP Basic authentication.
     * </pre>
     *
     * <code>string password = 3;</code>
     *
     * @return The password.
     */
    @java.lang.Override
    public java.lang.String getPassword() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        password_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The password for HTTP Basic authentication.
     * </pre>
     *
     * <code>string password = 3;</code>
     *
     * @return The bytes for password.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPasswordBytes() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        password_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REQUEST_HEADERS_FIELD_NUMBER = 4;

    private static final class RequestHeadersDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.dialogflow.v2beta1.FulfillmentProto
                  .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_GenericWebService_RequestHeadersEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> requestHeaders_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetRequestHeaders() {
      if (requestHeaders_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            RequestHeadersDefaultEntryHolder.defaultEntry);
      }
      return requestHeaders_;
    }

    public int getRequestHeadersCount() {
      return internalGetRequestHeaders().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with fulfillment requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    @java.lang.Override
    public boolean containsRequestHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetRequestHeaders().getMap().containsKey(key);
    }
    /** Use {@link #getRequestHeadersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getRequestHeaders() {
      return getRequestHeadersMap();
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with fulfillment requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getRequestHeadersMap() {
      return internalGetRequestHeaders().getMap();
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with fulfillment requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getRequestHeadersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetRequestHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The HTTP request headers to send together with fulfillment requests.
     * </pre>
     *
     * <code>map&lt;string, string&gt; request_headers = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getRequestHeadersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetRequestHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int IS_CLOUD_FUNCTION_FIELD_NUMBER = 5;
    private boolean isCloudFunction_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Indicates if generic web service is created through Cloud
     * Functions integration. Defaults to false.
     *
     * is_cloud_function is deprecated. Cloud functions can be configured by
     * its uri as a regular web service now.
     * </pre>
     *
     * <code>
     * bool is_cloud_function = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.is_cloud_function
     *     is deprecated. See google/cloud/dialogflow/v2beta1/fulfillment.proto;l=109
     * @return The isCloudFunction.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getIsCloudFunction() {
      return isCloudFunction_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, username_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, password_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetRequestHeaders(), RequestHeadersDefaultEntryHolder.defaultEntry, 4);
      if (isCloudFunction_ != false) {
        output.writeBool(5, isCloudFunction_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, username_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, password_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetRequestHeaders().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> requestHeaders__ =
            RequestHeadersDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, requestHeaders__);
      }
      if (isCloudFunction_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, isCloudFunction_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService other =
          (com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService) obj;

      if (!getUri().equals(other.getUri())) return false;
      if (!getUsername().equals(other.getUsername())) return false;
      if (!getPassword().equals(other.getPassword())) return false;
      if (!internalGetRequestHeaders().equals(other.internalGetRequestHeaders())) return false;
      if (getIsCloudFunction() != other.getIsCloudFunction()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
      hash = (37 * hash) + USERNAME_FIELD_NUMBER;
      hash = (53 * hash) + getUsername().hashCode();
      hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
      hash = (53 * hash) + getPassword().hashCode();
      if (!internalGetRequestHeaders().getMap().isEmpty()) {
        hash = (37 * hash) + REQUEST_HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetRequestHeaders().hashCode();
      }
      hash = (37 * hash) + IS_CLOUD_FUNCTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsCloudFunction());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents configuration for a generic web service.
     * Dialogflow supports two mechanisms for authentications:
     *
     * - Basic authentication with username and password.
     * - Authentication with additional authentication headers.
     *
     * More information could be found at:
     * https://cloud.google.com/dialogflow/docs/fulfillment-configure.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService)
        com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebServiceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
            .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_GenericWebService_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 4:
            return internalGetRequestHeaders();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 4:
            return internalGetMutableRequestHeaders();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
            .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_GenericWebService_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.class,
                com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        uri_ = "";
        username_ = "";
        password_ = "";
        internalGetMutableRequestHeaders().clear();
        isCloudFunction_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
            .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_GenericWebService_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService build() {
        com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService buildPartial() {
        com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService result =
            new com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.uri_ = uri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.username_ = username_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.password_ = password_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.requestHeaders_ = internalGetRequestHeaders();
          result.requestHeaders_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.isCloudFunction_ = isCloudFunction_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
                .getDefaultInstance()) return this;
        if (!other.getUri().isEmpty()) {
          uri_ = other.uri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getUsername().isEmpty()) {
          username_ = other.username_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getPassword().isEmpty()) {
          password_ = other.password_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        internalGetMutableRequestHeaders().mergeFrom(other.internalGetRequestHeaders());
        bitField0_ |= 0x00000008;
        if (other.getIsCloudFunction() != false) {
          setIsCloudFunction(other.getIsCloudFunction());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  uri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  username_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  password_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                      requestHeaders__ =
                          input.readMessage(
                              RequestHeadersDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableRequestHeaders()
                      .getMutableMap()
                      .put(requestHeaders__.getKey(), requestHeaders__.getValue());
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 40:
                {
                  isCloudFunction_ = input.readBool();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * Required. The fulfillment URI for receiving POST requests.
       * It must use https protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment URI for receiving POST requests.
       * It must use https protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment URI for receiving POST requests.
       * It must use https protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        uri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment URI for receiving POST requests.
       * It must use https protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {
        uri_ = getDefaultInstance().getUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The fulfillment URI for receiving POST requests.
       * It must use https protocol.
       * </pre>
       *
       * <code>string uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        uri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object username_ = "";
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2;</code>
       *
       * @return The username.
       */
      public java.lang.String getUsername() {
        java.lang.Object ref = username_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          username_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2;</code>
       *
       * @return The bytes for username.
       */
      public com.google.protobuf.ByteString getUsernameBytes() {
        java.lang.Object ref = username_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          username_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2;</code>
       *
       * @param value The username to set.
       * @return This builder for chaining.
       */
      public Builder setUsername(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        username_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUsername() {
        username_ = getDefaultInstance().getUsername();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The user name for HTTP Basic authentication.
       * </pre>
       *
       * <code>string username = 2;</code>
       *
       * @param value The bytes for username to set.
       * @return This builder for chaining.
       */
      public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        username_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object password_ = "";
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3;</code>
       *
       * @return The password.
       */
      public java.lang.String getPassword() {
        java.lang.Object ref = password_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          password_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3;</code>
       *
       * @return The bytes for password.
       */
      public com.google.protobuf.ByteString getPasswordBytes() {
        java.lang.Object ref = password_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          password_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3;</code>
       *
       * @param value The password to set.
       * @return This builder for chaining.
       */
      public Builder setPassword(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        password_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPassword() {
        password_ = getDefaultInstance().getPassword();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The password for HTTP Basic authentication.
       * </pre>
       *
       * <code>string password = 3;</code>
       *
       * @param value The bytes for password to set.
       * @return This builder for chaining.
       */
      public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        password_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> requestHeaders_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetRequestHeaders() {
        if (requestHeaders_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              RequestHeadersDefaultEntryHolder.defaultEntry);
        }
        return requestHeaders_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableRequestHeaders() {
        if (requestHeaders_ == null) {
          requestHeaders_ =
              com.google.protobuf.MapField.newMapField(
                  RequestHeadersDefaultEntryHolder.defaultEntry);
        }
        if (!requestHeaders_.isMutable()) {
          requestHeaders_ = requestHeaders_.copy();
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return requestHeaders_;
      }

      public int getRequestHeadersCount() {
        return internalGetRequestHeaders().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with fulfillment requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      @java.lang.Override
      public boolean containsRequestHeaders(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetRequestHeaders().getMap().containsKey(key);
      }
      /** Use {@link #getRequestHeadersMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getRequestHeaders() {
        return getRequestHeadersMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with fulfillment requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getRequestHeadersMap() {
        return internalGetRequestHeaders().getMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with fulfillment requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getRequestHeadersOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetRequestHeaders().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with fulfillment requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      @java.lang.Override
      public java.lang.String getRequestHeadersOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetRequestHeaders().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearRequestHeaders() {
        bitField0_ = (bitField0_ & ~0x00000008);
        internalGetMutableRequestHeaders().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with fulfillment requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      public Builder removeRequestHeaders(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableRequestHeaders().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableRequestHeaders() {
        bitField0_ |= 0x00000008;
        return internalGetMutableRequestHeaders().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with fulfillment requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      public Builder putRequestHeaders(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableRequestHeaders().getMutableMap().put(key, value);
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The HTTP request headers to send together with fulfillment requests.
       * </pre>
       *
       * <code>map&lt;string, string&gt; request_headers = 4;</code>
       */
      public Builder putAllRequestHeaders(
          java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableRequestHeaders().getMutableMap().putAll(values);
        bitField0_ |= 0x00000008;
        return this;
      }

      private boolean isCloudFunction_;
      /**
       *
       *
       * <pre>
       * Optional. Indicates if generic web service is created through Cloud
       * Functions integration. Defaults to false.
       *
       * is_cloud_function is deprecated. Cloud functions can be configured by
       * its uri as a regular web service now.
       * </pre>
       *
       * <code>
       * bool is_cloud_function = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @deprecated google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.is_cloud_function
       *     is deprecated. See google/cloud/dialogflow/v2beta1/fulfillment.proto;l=109
       * @return The isCloudFunction.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public boolean getIsCloudFunction() {
        return isCloudFunction_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indicates if generic web service is created through Cloud
       * Functions integration. Defaults to false.
       *
       * is_cloud_function is deprecated. Cloud functions can be configured by
       * its uri as a regular web service now.
       * </pre>
       *
       * <code>
       * bool is_cloud_function = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @deprecated google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.is_cloud_function
       *     is deprecated. See google/cloud/dialogflow/v2beta1/fulfillment.proto;l=109
       * @param value The isCloudFunction to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setIsCloudFunction(boolean value) {

        isCloudFunction_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indicates if generic web service is created through Cloud
       * Functions integration. Defaults to false.
       *
       * is_cloud_function is deprecated. Cloud functions can be configured by
       * its uri as a regular web service now.
       * </pre>
       *
       * <code>
       * bool is_cloud_function = 5 [deprecated = true, (.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @deprecated google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.is_cloud_function
       *     is deprecated. See google/cloud/dialogflow/v2beta1/fulfillment.proto;l=109
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearIsCloudFunction() {
        bitField0_ = (bitField0_ & ~0x00000010);
        isCloudFunction_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService)
    private static final com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService();
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GenericWebService> PARSER =
        new com.google.protobuf.AbstractParser<GenericWebService>() {
          @java.lang.Override
          public GenericWebService parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GenericWebService> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GenericWebService> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FeatureOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.Fulfillment.Feature)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The type of the feature that enabled for fulfillment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * The type of the feature that enabled for fulfillment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type type = 1;</code>
     *
     * @return The type.
     */
    com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type getType();
  }
  /**
   *
   *
   * <pre>
   * Whether fulfillment is enabled for the specific feature.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Fulfillment.Feature}
   */
  public static final class Feature extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Fulfillment.Feature)
      FeatureOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Feature.newBuilder() to construct.
    private Feature(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Feature() {
      type_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Feature();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
          .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_Feature_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
          .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_Feature_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.class,
              com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The type of the feature.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type}
     */
    public enum Type implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Feature type not specified.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Fulfillment is enabled for SmallTalk.
       * </pre>
       *
       * <code>SMALLTALK = 1;</code>
       */
      SMALLTALK(1),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Feature type not specified.
       * </pre>
       *
       * <code>TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Fulfillment is enabled for SmallTalk.
       * </pre>
       *
       * <code>SMALLTALK = 1;</code>
       */
      public static final int SMALLTALK_VALUE = 1;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 0:
            return TYPE_UNSPECIFIED;
          case 1:
            return SMALLTALK;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Type>() {
            public Type findValueByNumber(int number) {
              return Type.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type)
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the feature that enabled for fulfillment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The type of the feature that enabled for fulfillment.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type getType() {
      com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type result =
          com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (type_
          != com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_
          != com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature other =
          (com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature) obj;

      if (type_ != other.type_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Whether fulfillment is enabled for the specific feature.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2beta1.Fulfillment.Feature}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Fulfillment.Feature)
        com.google.cloud.dialogflow.v2beta1.Fulfillment.FeatureOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
            .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_Feature_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
            .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_Feature_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.class,
                com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
            .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_Feature_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature build() {
        com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature buildPartial() {
        com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature result =
            new com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature) {
          return mergeFrom((com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature other) {
        if (other == com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.getDefaultInstance())
          return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * The type of the feature that enabled for fulfillment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type type = 1;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * The type of the feature that enabled for fulfillment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type type = 1;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the feature that enabled for fulfillment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type type = 1;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type getType() {
        com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type result =
            com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type.forNumber(type_);
        return result == null
            ? com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The type of the feature that enabled for fulfillment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type type = 1;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The type of the feature that enabled for fulfillment.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Type type = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Fulfillment.Feature)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Fulfillment.Feature)
    private static final com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature();
    }

    public static com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Feature> PARSER =
        new com.google.protobuf.AbstractParser<Feature>() {
          @java.lang.Override
          public Feature parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Feature> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Feature> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int fulfillmentCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object fulfillment_;

  public enum FulfillmentCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GENERIC_WEB_SERVICE(3),
    FULFILLMENT_NOT_SET(0);
    private final int value;

    private FulfillmentCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FulfillmentCase valueOf(int value) {
      return forNumber(value);
    }

    public static FulfillmentCase forNumber(int value) {
      switch (value) {
        case 3:
          return GENERIC_WEB_SERVICE;
        case 0:
          return FULFILLMENT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FulfillmentCase getFulfillmentCase() {
    return FulfillmentCase.forNumber(fulfillmentCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The unique identifier of the fulfillment.
   * Supported formats:
   *
   * - `projects/&lt;Project ID&gt;/agent/fulfillment`
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/fulfillment`
   *
   * This field is not used for Fulfillment in an Environment.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique identifier of the fulfillment.
   * Supported formats:
   *
   * - `projects/&lt;Project ID&gt;/agent/fulfillment`
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/fulfillment`
   *
   * This field is not used for Fulfillment in an Environment.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The human-readable name of the fulfillment, unique within the agent.
   *
   * This field is not used for Fulfillment in an Environment.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The human-readable name of the fulfillment, unique within the agent.
   *
   * This field is not used for Fulfillment in an Environment.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GENERIC_WEB_SERVICE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Configuration for a generic web service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService generic_web_service = 3;
   * </code>
   *
   * @return Whether the genericWebService field is set.
   */
  @java.lang.Override
  public boolean hasGenericWebService() {
    return fulfillmentCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Configuration for a generic web service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService generic_web_service = 3;
   * </code>
   *
   * @return The genericWebService.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService getGenericWebService() {
    if (fulfillmentCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService) fulfillment_;
    }
    return com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for a generic web service.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService generic_web_service = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebServiceOrBuilder
      getGenericWebServiceOrBuilder() {
    if (fulfillmentCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService) fulfillment_;
    }
    return com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.getDefaultInstance();
  }

  public static final int ENABLED_FIELD_NUMBER = 4;
  private boolean enabled_ = false;
  /**
   *
   *
   * <pre>
   * Whether fulfillment is enabled.
   * </pre>
   *
   * <code>bool enabled = 4;</code>
   *
   * @return The enabled.
   */
  @java.lang.Override
  public boolean getEnabled() {
    return enabled_;
  }

  public static final int FEATURES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature> features_;
  /**
   *
   *
   * <pre>
   * The field defines whether the fulfillment is enabled for certain features.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature> getFeaturesList() {
    return features_;
  }
  /**
   *
   *
   * <pre>
   * The field defines whether the fulfillment is enabled for certain features.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.Fulfillment.FeatureOrBuilder>
      getFeaturesOrBuilderList() {
    return features_;
  }
  /**
   *
   *
   * <pre>
   * The field defines whether the fulfillment is enabled for certain features.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
   */
  @java.lang.Override
  public int getFeaturesCount() {
    return features_.size();
  }
  /**
   *
   *
   * <pre>
   * The field defines whether the fulfillment is enabled for certain features.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature getFeatures(int index) {
    return features_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The field defines whether the fulfillment is enabled for certain features.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Fulfillment.FeatureOrBuilder getFeaturesOrBuilder(
      int index) {
    return features_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (fulfillmentCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService) fulfillment_);
    }
    if (enabled_ != false) {
      output.writeBool(4, enabled_);
    }
    for (int i = 0; i < features_.size(); i++) {
      output.writeMessage(5, features_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (fulfillmentCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService) fulfillment_);
    }
    if (enabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, enabled_);
    }
    for (int i = 0; i < features_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, features_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.Fulfillment)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.Fulfillment other =
        (com.google.cloud.dialogflow.v2beta1.Fulfillment) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (getEnabled() != other.getEnabled()) return false;
    if (!getFeaturesList().equals(other.getFeaturesList())) return false;
    if (!getFulfillmentCase().equals(other.getFulfillmentCase())) return false;
    switch (fulfillmentCase_) {
      case 3:
        if (!getGenericWebService().equals(other.getGenericWebService())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + ENABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnabled());
    if (getFeaturesCount() > 0) {
      hash = (37 * hash) + FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getFeaturesList().hashCode();
    }
    switch (fulfillmentCase_) {
      case 3:
        hash = (37 * hash) + GENERIC_WEB_SERVICE_FIELD_NUMBER;
        hash = (53 * hash) + getGenericWebService().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.Fulfillment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Fulfillment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Fulfillment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Fulfillment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Fulfillment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Fulfillment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Fulfillment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Fulfillment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Fulfillment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Fulfillment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Fulfillment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Fulfillment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.Fulfillment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * By default, your agent responds to a matched intent with a static response.
   * As an alternative, you can provide a more dynamic response by using
   * fulfillment. When you enable fulfillment for an intent, Dialogflow responds
   * to that intent by calling a service that you define. For example, if an
   * end-user wants to schedule a haircut on Friday, your service can check your
   * database and respond to the end-user with availability information for
   * Friday.
   *
   * For more information, see the [fulfillment
   * guide](https://cloud.google.com/dialogflow/docs/fulfillment-overview).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Fulfillment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Fulfillment)
      com.google.cloud.dialogflow.v2beta1.FulfillmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
          .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
          .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Fulfillment.class,
              com.google.cloud.dialogflow.v2beta1.Fulfillment.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.Fulfillment.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      if (genericWebServiceBuilder_ != null) {
        genericWebServiceBuilder_.clear();
      }
      enabled_ = false;
      if (featuresBuilder_ == null) {
        features_ = java.util.Collections.emptyList();
      } else {
        features_ = null;
        featuresBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      fulfillmentCase_ = 0;
      fulfillment_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.FulfillmentProto
          .internal_static_google_cloud_dialogflow_v2beta1_Fulfillment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Fulfillment getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.Fulfillment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Fulfillment build() {
      com.google.cloud.dialogflow.v2beta1.Fulfillment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Fulfillment buildPartial() {
      com.google.cloud.dialogflow.v2beta1.Fulfillment result =
          new com.google.cloud.dialogflow.v2beta1.Fulfillment(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2beta1.Fulfillment result) {
      if (featuresBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          features_ = java.util.Collections.unmodifiableList(features_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.features_ = features_;
      } else {
        result.features_ = featuresBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.Fulfillment result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.enabled_ = enabled_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.dialogflow.v2beta1.Fulfillment result) {
      result.fulfillmentCase_ = fulfillmentCase_;
      result.fulfillment_ = this.fulfillment_;
      if (fulfillmentCase_ == 3 && genericWebServiceBuilder_ != null) {
        result.fulfillment_ = genericWebServiceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.Fulfillment) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.Fulfillment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.Fulfillment other) {
      if (other == com.google.cloud.dialogflow.v2beta1.Fulfillment.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getEnabled() != false) {
        setEnabled(other.getEnabled());
      }
      if (featuresBuilder_ == null) {
        if (!other.features_.isEmpty()) {
          if (features_.isEmpty()) {
            features_ = other.features_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureFeaturesIsMutable();
            features_.addAll(other.features_);
          }
          onChanged();
        }
      } else {
        if (!other.features_.isEmpty()) {
          if (featuresBuilder_.isEmpty()) {
            featuresBuilder_.dispose();
            featuresBuilder_ = null;
            features_ = other.features_;
            bitField0_ = (bitField0_ & ~0x00000010);
            featuresBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFeaturesFieldBuilder()
                    : null;
          } else {
            featuresBuilder_.addAllMessages(other.features_);
          }
        }
      }
      switch (other.getFulfillmentCase()) {
        case GENERIC_WEB_SERVICE:
          {
            mergeGenericWebService(other.getGenericWebService());
            break;
          }
        case FULFILLMENT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getGenericWebServiceFieldBuilder().getBuilder(), extensionRegistry);
                fulfillmentCase_ = 3;
                break;
              } // case 26
            case 32:
              {
                enabled_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.parser(),
                        extensionRegistry);
                if (featuresBuilder_ == null) {
                  ensureFeaturesIsMutable();
                  features_.add(m);
                } else {
                  featuresBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int fulfillmentCase_ = 0;
    private java.lang.Object fulfillment_;

    public FulfillmentCase getFulfillmentCase() {
      return FulfillmentCase.forNumber(fulfillmentCase_);
    }

    public Builder clearFulfillment() {
      fulfillmentCase_ = 0;
      fulfillment_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the fulfillment.
     * Supported formats:
     *
     * - `projects/&lt;Project ID&gt;/agent/fulfillment`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/fulfillment`
     *
     * This field is not used for Fulfillment in an Environment.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the fulfillment.
     * Supported formats:
     *
     * - `projects/&lt;Project ID&gt;/agent/fulfillment`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/fulfillment`
     *
     * This field is not used for Fulfillment in an Environment.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the fulfillment.
     * Supported formats:
     *
     * - `projects/&lt;Project ID&gt;/agent/fulfillment`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/fulfillment`
     *
     * This field is not used for Fulfillment in an Environment.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the fulfillment.
     * Supported formats:
     *
     * - `projects/&lt;Project ID&gt;/agent/fulfillment`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/fulfillment`
     *
     * This field is not used for Fulfillment in an Environment.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique identifier of the fulfillment.
     * Supported formats:
     *
     * - `projects/&lt;Project ID&gt;/agent/fulfillment`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent/fulfillment`
     *
     * This field is not used for Fulfillment in an Environment.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The human-readable name of the fulfillment, unique within the agent.
     *
     * This field is not used for Fulfillment in an Environment.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable name of the fulfillment, unique within the agent.
     *
     * This field is not used for Fulfillment in an Environment.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable name of the fulfillment, unique within the agent.
     *
     * This field is not used for Fulfillment in an Environment.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable name of the fulfillment, unique within the agent.
     *
     * This field is not used for Fulfillment in an Environment.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable name of the fulfillment, unique within the agent.
     *
     * This field is not used for Fulfillment in an Environment.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService,
            com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.Builder,
            com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebServiceOrBuilder>
        genericWebServiceBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService generic_web_service = 3;
     * </code>
     *
     * @return Whether the genericWebService field is set.
     */
    @java.lang.Override
    public boolean hasGenericWebService() {
      return fulfillmentCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService generic_web_service = 3;
     * </code>
     *
     * @return The genericWebService.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
        getGenericWebService() {
      if (genericWebServiceBuilder_ == null) {
        if (fulfillmentCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService) fulfillment_;
        }
        return com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
            .getDefaultInstance();
      } else {
        if (fulfillmentCase_ == 3) {
          return genericWebServiceBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService generic_web_service = 3;
     * </code>
     */
    public Builder setGenericWebService(
        com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService value) {
      if (genericWebServiceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fulfillment_ = value;
        onChanged();
      } else {
        genericWebServiceBuilder_.setMessage(value);
      }
      fulfillmentCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService generic_web_service = 3;
     * </code>
     */
    public Builder setGenericWebService(
        com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.Builder builderForValue) {
      if (genericWebServiceBuilder_ == null) {
        fulfillment_ = builderForValue.build();
        onChanged();
      } else {
        genericWebServiceBuilder_.setMessage(builderForValue.build());
      }
      fulfillmentCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService generic_web_service = 3;
     * </code>
     */
    public Builder mergeGenericWebService(
        com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService value) {
      if (genericWebServiceBuilder_ == null) {
        if (fulfillmentCase_ == 3
            && fulfillment_
                != com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
                    .getDefaultInstance()) {
          fulfillment_ =
              com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService)
                          fulfillment_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          fulfillment_ = value;
        }
        onChanged();
      } else {
        if (fulfillmentCase_ == 3) {
          genericWebServiceBuilder_.mergeFrom(value);
        } else {
          genericWebServiceBuilder_.setMessage(value);
        }
      }
      fulfillmentCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService generic_web_service = 3;
     * </code>
     */
    public Builder clearGenericWebService() {
      if (genericWebServiceBuilder_ == null) {
        if (fulfillmentCase_ == 3) {
          fulfillmentCase_ = 0;
          fulfillment_ = null;
          onChanged();
        }
      } else {
        if (fulfillmentCase_ == 3) {
          fulfillmentCase_ = 0;
          fulfillment_ = null;
        }
        genericWebServiceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService generic_web_service = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.Builder
        getGenericWebServiceBuilder() {
      return getGenericWebServiceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService generic_web_service = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebServiceOrBuilder
        getGenericWebServiceOrBuilder() {
      if ((fulfillmentCase_ == 3) && (genericWebServiceBuilder_ != null)) {
        return genericWebServiceBuilder_.getMessageOrBuilder();
      } else {
        if (fulfillmentCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService) fulfillment_;
        }
        return com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for a generic web service.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService generic_web_service = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService,
            com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.Builder,
            com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebServiceOrBuilder>
        getGenericWebServiceFieldBuilder() {
      if (genericWebServiceBuilder_ == null) {
        if (!(fulfillmentCase_ == 3)) {
          fulfillment_ =
              com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService
                  .getDefaultInstance();
        }
        genericWebServiceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService,
                com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService.Builder,
                com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebServiceOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.Fulfillment.GenericWebService) fulfillment_,
                getParentForChildren(),
                isClean());
        fulfillment_ = null;
      }
      fulfillmentCase_ = 3;
      onChanged();
      return genericWebServiceBuilder_;
    }

    private boolean enabled_;
    /**
     *
     *
     * <pre>
     * Whether fulfillment is enabled.
     * </pre>
     *
     * <code>bool enabled = 4;</code>
     *
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }
    /**
     *
     *
     * <pre>
     * Whether fulfillment is enabled.
     * </pre>
     *
     * <code>bool enabled = 4;</code>
     *
     * @param value The enabled to set.
     * @return This builder for chaining.
     */
    public Builder setEnabled(boolean value) {

      enabled_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether fulfillment is enabled.
     * </pre>
     *
     * <code>bool enabled = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnabled() {
      bitField0_ = (bitField0_ & ~0x00000008);
      enabled_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature> features_ =
        java.util.Collections.emptyList();

    private void ensureFeaturesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        features_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature>(
                features_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature,
            com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Builder,
            com.google.cloud.dialogflow.v2beta1.Fulfillment.FeatureOrBuilder>
        featuresBuilder_;

    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature>
        getFeaturesList() {
      if (featuresBuilder_ == null) {
        return java.util.Collections.unmodifiableList(features_);
      } else {
        return featuresBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public int getFeaturesCount() {
      if (featuresBuilder_ == null) {
        return features_.size();
      } else {
        return featuresBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature getFeatures(int index) {
      if (featuresBuilder_ == null) {
        return features_.get(index);
      } else {
        return featuresBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public Builder setFeatures(
        int index, com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature value) {
      if (featuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeaturesIsMutable();
        features_.set(index, value);
        onChanged();
      } else {
        featuresBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public Builder setFeatures(
        int index,
        com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Builder builderForValue) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        features_.set(index, builderForValue.build());
        onChanged();
      } else {
        featuresBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public Builder addFeatures(com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature value) {
      if (featuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeaturesIsMutable();
        features_.add(value);
        onChanged();
      } else {
        featuresBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public Builder addFeatures(
        int index, com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature value) {
      if (featuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFeaturesIsMutable();
        features_.add(index, value);
        onChanged();
      } else {
        featuresBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public Builder addFeatures(
        com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Builder builderForValue) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        features_.add(builderForValue.build());
        onChanged();
      } else {
        featuresBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public Builder addFeatures(
        int index,
        com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Builder builderForValue) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        features_.add(index, builderForValue.build());
        onChanged();
      } else {
        featuresBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public Builder addAllFeatures(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature>
            values) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, features_);
        onChanged();
      } else {
        featuresBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public Builder clearFeatures() {
      if (featuresBuilder_ == null) {
        features_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        featuresBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public Builder removeFeatures(int index) {
      if (featuresBuilder_ == null) {
        ensureFeaturesIsMutable();
        features_.remove(index);
        onChanged();
      } else {
        featuresBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Builder getFeaturesBuilder(
        int index) {
      return getFeaturesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Fulfillment.FeatureOrBuilder getFeaturesOrBuilder(
        int index) {
      if (featuresBuilder_ == null) {
        return features_.get(index);
      } else {
        return featuresBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.v2beta1.Fulfillment.FeatureOrBuilder>
        getFeaturesOrBuilderList() {
      if (featuresBuilder_ != null) {
        return featuresBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(features_);
      }
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Builder addFeaturesBuilder() {
      return getFeaturesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Builder addFeaturesBuilder(
        int index) {
      return getFeaturesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The field defines whether the fulfillment is enabled for certain features.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Fulfillment.Feature features = 5;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Builder>
        getFeaturesBuilderList() {
      return getFeaturesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature,
            com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Builder,
            com.google.cloud.dialogflow.v2beta1.Fulfillment.FeatureOrBuilder>
        getFeaturesFieldBuilder() {
      if (featuresBuilder_ == null) {
        featuresBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature,
                com.google.cloud.dialogflow.v2beta1.Fulfillment.Feature.Builder,
                com.google.cloud.dialogflow.v2beta1.Fulfillment.FeatureOrBuilder>(
                features_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        features_ = null;
      }
      return featuresBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Fulfillment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Fulfillment)
  private static final com.google.cloud.dialogflow.v2beta1.Fulfillment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.Fulfillment();
  }

  public static com.google.cloud.dialogflow.v2beta1.Fulfillment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Fulfillment> PARSER =
      new com.google.protobuf.AbstractParser<Fulfillment>() {
        @java.lang.Override
        public Fulfillment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Fulfillment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Fulfillment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Fulfillment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
