/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/participant.proto

package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents the selection of a suggestion.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.SuggestionInput}
 */
public final class SuggestionInput extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.SuggestionInput)
    SuggestionInputOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SuggestionInput.newBuilder() to construct.
  private SuggestionInput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SuggestionInput() {
    answerRecord_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SuggestionInput();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_SuggestionInput_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_SuggestionInput_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.SuggestionInput.class,
            com.google.cloud.dialogflow.v2beta1.SuggestionInput.Builder.class);
  }

  public static final int ANSWER_RECORD_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object answerRecord_ = "";
  /**
   *
   *
   * <pre>
   * Required. The ID of a suggestion selected by the human agent.
   * The suggestion(s) were generated in a previous call to
   * request Dialogflow assist.
   * The format is:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
   * ID&gt;` where &lt;Answer Record ID&gt; is an alphanumeric string.
   * </pre>
   *
   * <code>string answer_record = 1;</code>
   *
   * @return The answerRecord.
   */
  @java.lang.Override
  public java.lang.String getAnswerRecord() {
    java.lang.Object ref = answerRecord_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      answerRecord_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID of a suggestion selected by the human agent.
   * The suggestion(s) were generated in a previous call to
   * request Dialogflow assist.
   * The format is:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
   * ID&gt;` where &lt;Answer Record ID&gt; is an alphanumeric string.
   * </pre>
   *
   * <code>string answer_record = 1;</code>
   *
   * @return The bytes for answerRecord.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnswerRecordBytes() {
    java.lang.Object ref = answerRecord_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      answerRecord_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEXT_OVERRIDE_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.v2beta1.TextInput textOverride_;
  /**
   *
   *
   * <pre>
   * Optional. If the customer edited the suggestion before using it, include
   * the revised text here.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
   *
   * @return Whether the textOverride field is set.
   */
  @java.lang.Override
  public boolean hasTextOverride() {
    return textOverride_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. If the customer edited the suggestion before using it, include
   * the revised text here.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
   *
   * @return The textOverride.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TextInput getTextOverride() {
    return textOverride_ == null
        ? com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance()
        : textOverride_;
  }
  /**
   *
   *
   * <pre>
   * Optional. If the customer edited the suggestion before using it, include
   * the revised text here.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder getTextOverrideOrBuilder() {
    return textOverride_ == null
        ? com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance()
        : textOverride_;
  }

  public static final int PARAMETERS_FIELD_NUMBER = 4;
  private com.google.protobuf.Struct parameters_;
  /**
   *
   *
   * <pre>
   * In Dialogflow assist for v3, the user can submit a form by sending
   * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
   * form is uniquely determined by the
   * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
   * field, which identifies a v3
   * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
   * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
   * are specified via the
   * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
   * field.
   *
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   *
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 4;</code>
   *
   * @return Whether the parameters field is set.
   */
  @java.lang.Override
  public boolean hasParameters() {
    return parameters_ != null;
  }
  /**
   *
   *
   * <pre>
   * In Dialogflow assist for v3, the user can submit a form by sending
   * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
   * form is uniquely determined by the
   * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
   * field, which identifies a v3
   * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
   * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
   * are specified via the
   * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
   * field.
   *
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   *
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 4;</code>
   *
   * @return The parameters.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getParameters() {
    return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
  }
  /**
   *
   *
   * <pre>
   * In Dialogflow assist for v3, the user can submit a form by sending
   * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
   * form is uniquely determined by the
   * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
   * field, which identifies a v3
   * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
   * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
   * are specified via the
   * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
   * field.
   *
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   *
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
    return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
  }

  public static final int INTENT_INPUT_FIELD_NUMBER = 6;
  private com.google.cloud.dialogflow.v2beta1.IntentInput intentInput_;
  /**
   *
   *
   * <pre>
   * The intent to be triggered on V3 agent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
   *
   * @return Whether the intentInput field is set.
   */
  @java.lang.Override
  public boolean hasIntentInput() {
    return intentInput_ != null;
  }
  /**
   *
   *
   * <pre>
   * The intent to be triggered on V3 agent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
   *
   * @return The intentInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.IntentInput getIntentInput() {
    return intentInput_ == null
        ? com.google.cloud.dialogflow.v2beta1.IntentInput.getDefaultInstance()
        : intentInput_;
  }
  /**
   *
   *
   * <pre>
   * The intent to be triggered on V3 agent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.IntentInputOrBuilder getIntentInputOrBuilder() {
    return intentInput_ == null
        ? com.google.cloud.dialogflow.v2beta1.IntentInput.getDefaultInstance()
        : intentInput_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerRecord_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, answerRecord_);
    }
    if (textOverride_ != null) {
      output.writeMessage(2, getTextOverride());
    }
    if (parameters_ != null) {
      output.writeMessage(4, getParameters());
    }
    if (intentInput_ != null) {
      output.writeMessage(6, getIntentInput());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerRecord_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, answerRecord_);
    }
    if (textOverride_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTextOverride());
    }
    if (parameters_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getParameters());
    }
    if (intentInput_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getIntentInput());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.SuggestionInput)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.SuggestionInput other =
        (com.google.cloud.dialogflow.v2beta1.SuggestionInput) obj;

    if (!getAnswerRecord().equals(other.getAnswerRecord())) return false;
    if (hasTextOverride() != other.hasTextOverride()) return false;
    if (hasTextOverride()) {
      if (!getTextOverride().equals(other.getTextOverride())) return false;
    }
    if (hasParameters() != other.hasParameters()) return false;
    if (hasParameters()) {
      if (!getParameters().equals(other.getParameters())) return false;
    }
    if (hasIntentInput() != other.hasIntentInput()) return false;
    if (hasIntentInput()) {
      if (!getIntentInput().equals(other.getIntentInput())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ANSWER_RECORD_FIELD_NUMBER;
    hash = (53 * hash) + getAnswerRecord().hashCode();
    if (hasTextOverride()) {
      hash = (37 * hash) + TEXT_OVERRIDE_FIELD_NUMBER;
      hash = (53 * hash) + getTextOverride().hashCode();
    }
    if (hasParameters()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParameters().hashCode();
    }
    if (hasIntentInput()) {
      hash = (37 * hash) + INTENT_INPUT_FIELD_NUMBER;
      hash = (53 * hash) + getIntentInput().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionInput parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionInput parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionInput parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionInput parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionInput parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionInput parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionInput parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionInput parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionInput parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionInput parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionInput parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionInput parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.SuggestionInput prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the selection of a suggestion.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.SuggestionInput}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.SuggestionInput)
      com.google.cloud.dialogflow.v2beta1.SuggestionInputOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_SuggestionInput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_SuggestionInput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.SuggestionInput.class,
              com.google.cloud.dialogflow.v2beta1.SuggestionInput.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.SuggestionInput.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      answerRecord_ = "";
      textOverride_ = null;
      if (textOverrideBuilder_ != null) {
        textOverrideBuilder_.dispose();
        textOverrideBuilder_ = null;
      }
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      intentInput_ = null;
      if (intentInputBuilder_ != null) {
        intentInputBuilder_.dispose();
        intentInputBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_SuggestionInput_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestionInput getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.SuggestionInput.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestionInput build() {
      com.google.cloud.dialogflow.v2beta1.SuggestionInput result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestionInput buildPartial() {
      com.google.cloud.dialogflow.v2beta1.SuggestionInput result =
          new com.google.cloud.dialogflow.v2beta1.SuggestionInput(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.SuggestionInput result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.answerRecord_ = answerRecord_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.textOverride_ =
            textOverrideBuilder_ == null ? textOverride_ : textOverrideBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parameters_ = parametersBuilder_ == null ? parameters_ : parametersBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.intentInput_ =
            intentInputBuilder_ == null ? intentInput_ : intentInputBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.SuggestionInput) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.SuggestionInput) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.SuggestionInput other) {
      if (other == com.google.cloud.dialogflow.v2beta1.SuggestionInput.getDefaultInstance())
        return this;
      if (!other.getAnswerRecord().isEmpty()) {
        answerRecord_ = other.answerRecord_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasTextOverride()) {
        mergeTextOverride(other.getTextOverride());
      }
      if (other.hasParameters()) {
        mergeParameters(other.getParameters());
      }
      if (other.hasIntentInput()) {
        mergeIntentInput(other.getIntentInput());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                answerRecord_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTextOverrideFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(getIntentInputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object answerRecord_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of a suggestion selected by the human agent.
     * The suggestion(s) were generated in a previous call to
     * request Dialogflow assist.
     * The format is:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
     * ID&gt;` where &lt;Answer Record ID&gt; is an alphanumeric string.
     * </pre>
     *
     * <code>string answer_record = 1;</code>
     *
     * @return The answerRecord.
     */
    public java.lang.String getAnswerRecord() {
      java.lang.Object ref = answerRecord_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answerRecord_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of a suggestion selected by the human agent.
     * The suggestion(s) were generated in a previous call to
     * request Dialogflow assist.
     * The format is:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
     * ID&gt;` where &lt;Answer Record ID&gt; is an alphanumeric string.
     * </pre>
     *
     * <code>string answer_record = 1;</code>
     *
     * @return The bytes for answerRecord.
     */
    public com.google.protobuf.ByteString getAnswerRecordBytes() {
      java.lang.Object ref = answerRecord_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answerRecord_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of a suggestion selected by the human agent.
     * The suggestion(s) were generated in a previous call to
     * request Dialogflow assist.
     * The format is:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
     * ID&gt;` where &lt;Answer Record ID&gt; is an alphanumeric string.
     * </pre>
     *
     * <code>string answer_record = 1;</code>
     *
     * @param value The answerRecord to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerRecord(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      answerRecord_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of a suggestion selected by the human agent.
     * The suggestion(s) were generated in a previous call to
     * request Dialogflow assist.
     * The format is:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
     * ID&gt;` where &lt;Answer Record ID&gt; is an alphanumeric string.
     * </pre>
     *
     * <code>string answer_record = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnswerRecord() {
      answerRecord_ = getDefaultInstance().getAnswerRecord();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of a suggestion selected by the human agent.
     * The suggestion(s) were generated in a previous call to
     * request Dialogflow assist.
     * The format is:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
     * ID&gt;` where &lt;Answer Record ID&gt; is an alphanumeric string.
     * </pre>
     *
     * <code>string answer_record = 1;</code>
     *
     * @param value The bytes for answerRecord to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerRecordBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      answerRecord_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.dialogflow.v2beta1.TextInput textOverride_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TextInput,
            com.google.cloud.dialogflow.v2beta1.TextInput.Builder,
            com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder>
        textOverrideBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. If the customer edited the suggestion before using it, include
     * the revised text here.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
     *
     * @return Whether the textOverride field is set.
     */
    public boolean hasTextOverride() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. If the customer edited the suggestion before using it, include
     * the revised text here.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
     *
     * @return The textOverride.
     */
    public com.google.cloud.dialogflow.v2beta1.TextInput getTextOverride() {
      if (textOverrideBuilder_ == null) {
        return textOverride_ == null
            ? com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance()
            : textOverride_;
      } else {
        return textOverrideBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If the customer edited the suggestion before using it, include
     * the revised text here.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
     */
    public Builder setTextOverride(com.google.cloud.dialogflow.v2beta1.TextInput value) {
      if (textOverrideBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        textOverride_ = value;
      } else {
        textOverrideBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If the customer edited the suggestion before using it, include
     * the revised text here.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
     */
    public Builder setTextOverride(
        com.google.cloud.dialogflow.v2beta1.TextInput.Builder builderForValue) {
      if (textOverrideBuilder_ == null) {
        textOverride_ = builderForValue.build();
      } else {
        textOverrideBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If the customer edited the suggestion before using it, include
     * the revised text here.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
     */
    public Builder mergeTextOverride(com.google.cloud.dialogflow.v2beta1.TextInput value) {
      if (textOverrideBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && textOverride_ != null
            && textOverride_
                != com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance()) {
          getTextOverrideBuilder().mergeFrom(value);
        } else {
          textOverride_ = value;
        }
      } else {
        textOverrideBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If the customer edited the suggestion before using it, include
     * the revised text here.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
     */
    public Builder clearTextOverride() {
      bitField0_ = (bitField0_ & ~0x00000002);
      textOverride_ = null;
      if (textOverrideBuilder_ != null) {
        textOverrideBuilder_.dispose();
        textOverrideBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If the customer edited the suggestion before using it, include
     * the revised text here.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.TextInput.Builder getTextOverrideBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTextOverrideFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. If the customer edited the suggestion before using it, include
     * the revised text here.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder getTextOverrideOrBuilder() {
      if (textOverrideBuilder_ != null) {
        return textOverrideBuilder_.getMessageOrBuilder();
      } else {
        return textOverride_ == null
            ? com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance()
            : textOverride_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If the customer edited the suggestion before using it, include
     * the revised text here.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TextInput,
            com.google.cloud.dialogflow.v2beta1.TextInput.Builder,
            com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder>
        getTextOverrideFieldBuilder() {
      if (textOverrideBuilder_ == null) {
        textOverrideBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.TextInput,
                com.google.cloud.dialogflow.v2beta1.TextInput.Builder,
                com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder>(
                getTextOverride(), getParentForChildren(), isClean());
        textOverride_ = null;
      }
      return textOverrideBuilder_;
    }

    private com.google.protobuf.Struct parameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        parametersBuilder_;
    /**
     *
     *
     * <pre>
     * In Dialogflow assist for v3, the user can submit a form by sending
     * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
     * form is uniquely determined by the
     * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
     * field, which identifies a v3
     * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
     * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
     * are specified via the
     * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
     * field.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     *
     * @return Whether the parameters field is set.
     */
    public boolean hasParameters() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * In Dialogflow assist for v3, the user can submit a form by sending
     * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
     * form is uniquely determined by the
     * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
     * field, which identifies a v3
     * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
     * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
     * are specified via the
     * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
     * field.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     *
     * @return The parameters.
     */
    public com.google.protobuf.Struct getParameters() {
      if (parametersBuilder_ == null) {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      } else {
        return parametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * In Dialogflow assist for v3, the user can submit a form by sending
     * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
     * form is uniquely determined by the
     * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
     * field, which identifies a v3
     * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
     * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
     * are specified via the
     * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
     * field.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameters_ = value;
      } else {
        parametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In Dialogflow assist for v3, the user can submit a form by sending
     * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
     * form is uniquely determined by the
     * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
     * field, which identifies a v3
     * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
     * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
     * are specified via the
     * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
     * field.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        parameters_ = builderForValue.build();
      } else {
        parametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In Dialogflow assist for v3, the user can submit a form by sending
     * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
     * form is uniquely determined by the
     * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
     * field, which identifies a v3
     * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
     * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
     * are specified via the
     * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
     * field.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    public Builder mergeParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && parameters_ != null
            && parameters_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getParametersBuilder().mergeFrom(value);
        } else {
          parameters_ = value;
        }
      } else {
        parametersBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In Dialogflow assist for v3, the user can submit a form by sending
     * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
     * form is uniquely determined by the
     * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
     * field, which identifies a v3
     * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
     * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
     * are specified via the
     * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
     * field.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    public Builder clearParameters() {
      bitField0_ = (bitField0_ & ~0x00000004);
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In Dialogflow assist for v3, the user can submit a form by sending
     * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
     * form is uniquely determined by the
     * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
     * field, which identifies a v3
     * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
     * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
     * are specified via the
     * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
     * field.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    public com.google.protobuf.Struct.Builder getParametersBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * In Dialogflow assist for v3, the user can submit a form by sending
     * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
     * form is uniquely determined by the
     * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
     * field, which identifies a v3
     * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
     * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
     * are specified via the
     * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
     * field.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilder();
      } else {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * In Dialogflow assist for v3, the user can submit a form by sending
     * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
     * form is uniquely determined by the
     * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
     * field, which identifies a v3
     * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
     * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
     * are specified via the
     * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
     * field.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getParameters(), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.IntentInput intentInput_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.IntentInput,
            com.google.cloud.dialogflow.v2beta1.IntentInput.Builder,
            com.google.cloud.dialogflow.v2beta1.IntentInputOrBuilder>
        intentInputBuilder_;
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
     *
     * @return Whether the intentInput field is set.
     */
    public boolean hasIntentInput() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
     *
     * @return The intentInput.
     */
    public com.google.cloud.dialogflow.v2beta1.IntentInput getIntentInput() {
      if (intentInputBuilder_ == null) {
        return intentInput_ == null
            ? com.google.cloud.dialogflow.v2beta1.IntentInput.getDefaultInstance()
            : intentInput_;
      } else {
        return intentInputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
     */
    public Builder setIntentInput(com.google.cloud.dialogflow.v2beta1.IntentInput value) {
      if (intentInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        intentInput_ = value;
      } else {
        intentInputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
     */
    public Builder setIntentInput(
        com.google.cloud.dialogflow.v2beta1.IntentInput.Builder builderForValue) {
      if (intentInputBuilder_ == null) {
        intentInput_ = builderForValue.build();
      } else {
        intentInputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
     */
    public Builder mergeIntentInput(com.google.cloud.dialogflow.v2beta1.IntentInput value) {
      if (intentInputBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && intentInput_ != null
            && intentInput_
                != com.google.cloud.dialogflow.v2beta1.IntentInput.getDefaultInstance()) {
          getIntentInputBuilder().mergeFrom(value);
        } else {
          intentInput_ = value;
        }
      } else {
        intentInputBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
     */
    public Builder clearIntentInput() {
      bitField0_ = (bitField0_ & ~0x00000008);
      intentInput_ = null;
      if (intentInputBuilder_ != null) {
        intentInputBuilder_.dispose();
        intentInputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.IntentInput.Builder getIntentInputBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getIntentInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.IntentInputOrBuilder getIntentInputOrBuilder() {
      if (intentInputBuilder_ != null) {
        return intentInputBuilder_.getMessageOrBuilder();
      } else {
        return intentInput_ == null
            ? com.google.cloud.dialogflow.v2beta1.IntentInput.getDefaultInstance()
            : intentInput_;
      }
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.IntentInput,
            com.google.cloud.dialogflow.v2beta1.IntentInput.Builder,
            com.google.cloud.dialogflow.v2beta1.IntentInputOrBuilder>
        getIntentInputFieldBuilder() {
      if (intentInputBuilder_ == null) {
        intentInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.IntentInput,
                com.google.cloud.dialogflow.v2beta1.IntentInput.Builder,
                com.google.cloud.dialogflow.v2beta1.IntentInputOrBuilder>(
                getIntentInput(), getParentForChildren(), isClean());
        intentInput_ = null;
      }
      return intentInputBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.SuggestionInput)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.SuggestionInput)
  private static final com.google.cloud.dialogflow.v2beta1.SuggestionInput DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.SuggestionInput();
  }

  public static com.google.cloud.dialogflow.v2beta1.SuggestionInput getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SuggestionInput> PARSER =
      new com.google.protobuf.AbstractParser<SuggestionInput>() {
        @java.lang.Override
        public SuggestionInput parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SuggestionInput> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SuggestionInput> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SuggestionInput getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
