/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/entity_type.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * The request message for
 * [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.BatchUpdateEntityTypes].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest}
 */
public final class BatchUpdateEntityTypesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest)
    BatchUpdateEntityTypesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchUpdateEntityTypesRequest.newBuilder() to construct.
  private BatchUpdateEntityTypesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchUpdateEntityTypesRequest() {
    parent_ = "";
    languageCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchUpdateEntityTypesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.EntityTypeProto
        .internal_static_google_cloud_dialogflow_v2beta1_BatchUpdateEntityTypesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.EntityTypeProto
        .internal_static_google_cloud_dialogflow_v2beta1_BatchUpdateEntityTypesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest.class,
            com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest.Builder.class);
  }

  private int bitField0_;
  private int entityTypeBatchCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object entityTypeBatch_;

  public enum EntityTypeBatchCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ENTITY_TYPE_BATCH_URI(2),
    ENTITY_TYPE_BATCH_INLINE(3),
    ENTITYTYPEBATCH_NOT_SET(0);
    private final int value;

    private EntityTypeBatchCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EntityTypeBatchCase valueOf(int value) {
      return forNumber(value);
    }

    public static EntityTypeBatchCase forNumber(int value) {
      switch (value) {
        case 2:
          return ENTITY_TYPE_BATCH_URI;
        case 3:
          return ENTITY_TYPE_BATCH_INLINE;
        case 0:
          return ENTITYTYPEBATCH_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EntityTypeBatchCase getEntityTypeBatchCase() {
    return EntityTypeBatchCase.forNumber(entityTypeBatchCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the agent to update or create entity types in.
   * Supported formats:
   * - `projects/&lt;Project ID&gt;/agent`
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the agent to update or create entity types in.
   * Supported formats:
   * - `projects/&lt;Project ID&gt;/agent`
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_TYPE_BATCH_URI_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The URI to a Google Cloud Storage file containing entity types to update
   * or create. The file format can either be a serialized proto (of
   * EntityBatch type) or a JSON object. Note: The URI must start with
   * "gs://".
   * </pre>
   *
   * <code>string entity_type_batch_uri = 2;</code>
   *
   * @return Whether the entityTypeBatchUri field is set.
   */
  public boolean hasEntityTypeBatchUri() {
    return entityTypeBatchCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The URI to a Google Cloud Storage file containing entity types to update
   * or create. The file format can either be a serialized proto (of
   * EntityBatch type) or a JSON object. Note: The URI must start with
   * "gs://".
   * </pre>
   *
   * <code>string entity_type_batch_uri = 2;</code>
   *
   * @return The entityTypeBatchUri.
   */
  public java.lang.String getEntityTypeBatchUri() {
    java.lang.Object ref = "";
    if (entityTypeBatchCase_ == 2) {
      ref = entityTypeBatch_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (entityTypeBatchCase_ == 2) {
        entityTypeBatch_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI to a Google Cloud Storage file containing entity types to update
   * or create. The file format can either be a serialized proto (of
   * EntityBatch type) or a JSON object. Note: The URI must start with
   * "gs://".
   * </pre>
   *
   * <code>string entity_type_batch_uri = 2;</code>
   *
   * @return The bytes for entityTypeBatchUri.
   */
  public com.google.protobuf.ByteString getEntityTypeBatchUriBytes() {
    java.lang.Object ref = "";
    if (entityTypeBatchCase_ == 2) {
      ref = entityTypeBatch_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (entityTypeBatchCase_ == 2) {
        entityTypeBatch_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTITY_TYPE_BATCH_INLINE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The collection of entity types to update or create.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.EntityTypeBatch entity_type_batch_inline = 3;</code>
   *
   * @return Whether the entityTypeBatchInline field is set.
   */
  @java.lang.Override
  public boolean hasEntityTypeBatchInline() {
    return entityTypeBatchCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The collection of entity types to update or create.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.EntityTypeBatch entity_type_batch_inline = 3;</code>
   *
   * @return The entityTypeBatchInline.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.EntityTypeBatch getEntityTypeBatchInline() {
    if (entityTypeBatchCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.EntityTypeBatch) entityTypeBatch_;
    }
    return com.google.cloud.dialogflow.v2beta1.EntityTypeBatch.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The collection of entity types to update or create.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.EntityTypeBatch entity_type_batch_inline = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.EntityTypeBatchOrBuilder
      getEntityTypeBatchInlineOrBuilder() {
    if (entityTypeBatchCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.EntityTypeBatch) entityTypeBatch_;
    }
    return com.google.cloud.dialogflow.v2beta1.EntityTypeBatch.getDefaultInstance();
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The language used to access language-specific data.
   * If not specified, the agent's default language is used.
   * For more information, see
   * [Multilingual intent and entity
   * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
   * </pre>
   *
   * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The language used to access language-specific data.
   * If not specified, the agent's default language is used.
   * For more information, see
   * [Multilingual intent and entity
   * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
   * </pre>
   *
   * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 5;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Optional. The mask to control which fields get updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The mask to control which fields get updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The mask to control which fields get updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (entityTypeBatchCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, entityTypeBatch_);
    }
    if (entityTypeBatchCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.dialogflow.v2beta1.EntityTypeBatch) entityTypeBatch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, languageCode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getUpdateMask());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (entityTypeBatchCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, entityTypeBatch_);
    }
    if (entityTypeBatchCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dialogflow.v2beta1.EntityTypeBatch) entityTypeBatch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, languageCode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateMask());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest other =
        (com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (!getEntityTypeBatchCase().equals(other.getEntityTypeBatchCase())) return false;
    switch (entityTypeBatchCase_) {
      case 2:
        if (!getEntityTypeBatchUri().equals(other.getEntityTypeBatchUri())) return false;
        break;
      case 3:
        if (!getEntityTypeBatchInline().equals(other.getEntityTypeBatchInline())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    switch (entityTypeBatchCase_) {
      case 2:
        hash = (37 * hash) + ENTITY_TYPE_BATCH_URI_FIELD_NUMBER;
        hash = (53 * hash) + getEntityTypeBatchUri().hashCode();
        break;
      case 3:
        hash = (37 * hash) + ENTITY_TYPE_BATCH_INLINE_FIELD_NUMBER;
        hash = (53 * hash) + getEntityTypeBatchInline().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for
   * [EntityTypes.BatchUpdateEntityTypes][google.cloud.dialogflow.v2beta1.EntityTypes.BatchUpdateEntityTypes].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest)
      com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.EntityTypeProto
          .internal_static_google_cloud_dialogflow_v2beta1_BatchUpdateEntityTypesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.EntityTypeProto
          .internal_static_google_cloud_dialogflow_v2beta1_BatchUpdateEntityTypesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest.class,
              com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUpdateMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (entityTypeBatchInlineBuilder_ != null) {
        entityTypeBatchInlineBuilder_.clear();
      }
      languageCode_ = "";
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      entityTypeBatchCase_ = 0;
      entityTypeBatch_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.EntityTypeProto
          .internal_static_google_cloud_dialogflow_v2beta1_BatchUpdateEntityTypesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest build() {
      com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest buildPartial() {
      com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest result =
          new com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.languageCode_ = languageCode_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest result) {
      result.entityTypeBatchCase_ = entityTypeBatchCase_;
      result.entityTypeBatch_ = this.entityTypeBatch_;
      if (entityTypeBatchCase_ == 3 && entityTypeBatchInlineBuilder_ != null) {
        result.entityTypeBatch_ = entityTypeBatchInlineBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest other) {
      if (other
          == com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      switch (other.getEntityTypeBatchCase()) {
        case ENTITY_TYPE_BATCH_URI:
          {
            entityTypeBatchCase_ = 2;
            entityTypeBatch_ = other.entityTypeBatch_;
            onChanged();
            break;
          }
        case ENTITY_TYPE_BATCH_INLINE:
          {
            mergeEntityTypeBatchInline(other.getEntityTypeBatchInline());
            break;
          }
        case ENTITYTYPEBATCH_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                entityTypeBatchCase_ = 2;
                entityTypeBatch_ = s;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getEntityTypeBatchInlineFieldBuilder().getBuilder(), extensionRegistry);
                entityTypeBatchCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int entityTypeBatchCase_ = 0;
    private java.lang.Object entityTypeBatch_;

    public EntityTypeBatchCase getEntityTypeBatchCase() {
      return EntityTypeBatchCase.forNumber(entityTypeBatchCase_);
    }

    public Builder clearEntityTypeBatch() {
      entityTypeBatchCase_ = 0;
      entityTypeBatch_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to update or create entity types in.
     * Supported formats:
     * - `projects/&lt;Project ID&gt;/agent`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to update or create entity types in.
     * Supported formats:
     * - `projects/&lt;Project ID&gt;/agent`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to update or create entity types in.
     * Supported formats:
     * - `projects/&lt;Project ID&gt;/agent`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to update or create entity types in.
     * Supported formats:
     * - `projects/&lt;Project ID&gt;/agent`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to update or create entity types in.
     * Supported formats:
     * - `projects/&lt;Project ID&gt;/agent`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URI to a Google Cloud Storage file containing entity types to update
     * or create. The file format can either be a serialized proto (of
     * EntityBatch type) or a JSON object. Note: The URI must start with
     * "gs://".
     * </pre>
     *
     * <code>string entity_type_batch_uri = 2;</code>
     *
     * @return Whether the entityTypeBatchUri field is set.
     */
    @java.lang.Override
    public boolean hasEntityTypeBatchUri() {
      return entityTypeBatchCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The URI to a Google Cloud Storage file containing entity types to update
     * or create. The file format can either be a serialized proto (of
     * EntityBatch type) or a JSON object. Note: The URI must start with
     * "gs://".
     * </pre>
     *
     * <code>string entity_type_batch_uri = 2;</code>
     *
     * @return The entityTypeBatchUri.
     */
    @java.lang.Override
    public java.lang.String getEntityTypeBatchUri() {
      java.lang.Object ref = "";
      if (entityTypeBatchCase_ == 2) {
        ref = entityTypeBatch_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (entityTypeBatchCase_ == 2) {
          entityTypeBatch_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI to a Google Cloud Storage file containing entity types to update
     * or create. The file format can either be a serialized proto (of
     * EntityBatch type) or a JSON object. Note: The URI must start with
     * "gs://".
     * </pre>
     *
     * <code>string entity_type_batch_uri = 2;</code>
     *
     * @return The bytes for entityTypeBatchUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEntityTypeBatchUriBytes() {
      java.lang.Object ref = "";
      if (entityTypeBatchCase_ == 2) {
        ref = entityTypeBatch_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (entityTypeBatchCase_ == 2) {
          entityTypeBatch_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI to a Google Cloud Storage file containing entity types to update
     * or create. The file format can either be a serialized proto (of
     * EntityBatch type) or a JSON object. Note: The URI must start with
     * "gs://".
     * </pre>
     *
     * <code>string entity_type_batch_uri = 2;</code>
     *
     * @param value The entityTypeBatchUri to set.
     * @return This builder for chaining.
     */
    public Builder setEntityTypeBatchUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entityTypeBatchCase_ = 2;
      entityTypeBatch_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI to a Google Cloud Storage file containing entity types to update
     * or create. The file format can either be a serialized proto (of
     * EntityBatch type) or a JSON object. Note: The URI must start with
     * "gs://".
     * </pre>
     *
     * <code>string entity_type_batch_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityTypeBatchUri() {
      if (entityTypeBatchCase_ == 2) {
        entityTypeBatchCase_ = 0;
        entityTypeBatch_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI to a Google Cloud Storage file containing entity types to update
     * or create. The file format can either be a serialized proto (of
     * EntityBatch type) or a JSON object. Note: The URI must start with
     * "gs://".
     * </pre>
     *
     * <code>string entity_type_batch_uri = 2;</code>
     *
     * @param value The bytes for entityTypeBatchUri to set.
     * @return This builder for chaining.
     */
    public Builder setEntityTypeBatchUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      entityTypeBatchCase_ = 2;
      entityTypeBatch_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.EntityTypeBatch,
            com.google.cloud.dialogflow.v2beta1.EntityTypeBatch.Builder,
            com.google.cloud.dialogflow.v2beta1.EntityTypeBatchOrBuilder>
        entityTypeBatchInlineBuilder_;
    /**
     *
     *
     * <pre>
     * The collection of entity types to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EntityTypeBatch entity_type_batch_inline = 3;</code>
     *
     * @return Whether the entityTypeBatchInline field is set.
     */
    @java.lang.Override
    public boolean hasEntityTypeBatchInline() {
      return entityTypeBatchCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The collection of entity types to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EntityTypeBatch entity_type_batch_inline = 3;</code>
     *
     * @return The entityTypeBatchInline.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.EntityTypeBatch getEntityTypeBatchInline() {
      if (entityTypeBatchInlineBuilder_ == null) {
        if (entityTypeBatchCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.EntityTypeBatch) entityTypeBatch_;
        }
        return com.google.cloud.dialogflow.v2beta1.EntityTypeBatch.getDefaultInstance();
      } else {
        if (entityTypeBatchCase_ == 3) {
          return entityTypeBatchInlineBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.EntityTypeBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of entity types to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EntityTypeBatch entity_type_batch_inline = 3;</code>
     */
    public Builder setEntityTypeBatchInline(
        com.google.cloud.dialogflow.v2beta1.EntityTypeBatch value) {
      if (entityTypeBatchInlineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entityTypeBatch_ = value;
        onChanged();
      } else {
        entityTypeBatchInlineBuilder_.setMessage(value);
      }
      entityTypeBatchCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of entity types to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EntityTypeBatch entity_type_batch_inline = 3;</code>
     */
    public Builder setEntityTypeBatchInline(
        com.google.cloud.dialogflow.v2beta1.EntityTypeBatch.Builder builderForValue) {
      if (entityTypeBatchInlineBuilder_ == null) {
        entityTypeBatch_ = builderForValue.build();
        onChanged();
      } else {
        entityTypeBatchInlineBuilder_.setMessage(builderForValue.build());
      }
      entityTypeBatchCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of entity types to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EntityTypeBatch entity_type_batch_inline = 3;</code>
     */
    public Builder mergeEntityTypeBatchInline(
        com.google.cloud.dialogflow.v2beta1.EntityTypeBatch value) {
      if (entityTypeBatchInlineBuilder_ == null) {
        if (entityTypeBatchCase_ == 3
            && entityTypeBatch_
                != com.google.cloud.dialogflow.v2beta1.EntityTypeBatch.getDefaultInstance()) {
          entityTypeBatch_ =
              com.google.cloud.dialogflow.v2beta1.EntityTypeBatch.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.EntityTypeBatch) entityTypeBatch_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entityTypeBatch_ = value;
        }
        onChanged();
      } else {
        if (entityTypeBatchCase_ == 3) {
          entityTypeBatchInlineBuilder_.mergeFrom(value);
        } else {
          entityTypeBatchInlineBuilder_.setMessage(value);
        }
      }
      entityTypeBatchCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of entity types to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EntityTypeBatch entity_type_batch_inline = 3;</code>
     */
    public Builder clearEntityTypeBatchInline() {
      if (entityTypeBatchInlineBuilder_ == null) {
        if (entityTypeBatchCase_ == 3) {
          entityTypeBatchCase_ = 0;
          entityTypeBatch_ = null;
          onChanged();
        }
      } else {
        if (entityTypeBatchCase_ == 3) {
          entityTypeBatchCase_ = 0;
          entityTypeBatch_ = null;
        }
        entityTypeBatchInlineBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of entity types to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EntityTypeBatch entity_type_batch_inline = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.EntityTypeBatch.Builder
        getEntityTypeBatchInlineBuilder() {
      return getEntityTypeBatchInlineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The collection of entity types to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EntityTypeBatch entity_type_batch_inline = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.EntityTypeBatchOrBuilder
        getEntityTypeBatchInlineOrBuilder() {
      if ((entityTypeBatchCase_ == 3) && (entityTypeBatchInlineBuilder_ != null)) {
        return entityTypeBatchInlineBuilder_.getMessageOrBuilder();
      } else {
        if (entityTypeBatchCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.EntityTypeBatch) entityTypeBatch_;
        }
        return com.google.cloud.dialogflow.v2beta1.EntityTypeBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of entity types to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EntityTypeBatch entity_type_batch_inline = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.EntityTypeBatch,
            com.google.cloud.dialogflow.v2beta1.EntityTypeBatch.Builder,
            com.google.cloud.dialogflow.v2beta1.EntityTypeBatchOrBuilder>
        getEntityTypeBatchInlineFieldBuilder() {
      if (entityTypeBatchInlineBuilder_ == null) {
        if (!(entityTypeBatchCase_ == 3)) {
          entityTypeBatch_ =
              com.google.cloud.dialogflow.v2beta1.EntityTypeBatch.getDefaultInstance();
        }
        entityTypeBatchInlineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.EntityTypeBatch,
                com.google.cloud.dialogflow.v2beta1.EntityTypeBatch.Builder,
                com.google.cloud.dialogflow.v2beta1.EntityTypeBatchOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.EntityTypeBatch) entityTypeBatch_,
                getParentForChildren(),
                isClean());
        entityTypeBatch_ = null;
      }
      entityTypeBatchCase_ = 3;
      onChanged();
      return entityTypeBatchInlineBuilder_;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The language used to access language-specific data.
     * If not specified, the agent's default language is used.
     * For more information, see
     * [Multilingual intent and entity
     * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The language used to access language-specific data.
     * If not specified, the agent's default language is used.
     * For more information, see
     * [Multilingual intent and entity
     * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The language used to access language-specific data.
     * If not specified, the agent's default language is used.
     * For more information, see
     * [Multilingual intent and entity
     * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The language used to access language-specific data.
     * If not specified, the agent's default language is used.
     * For more information, see
     * [Multilingual intent and entity
     * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The language used to access language-specific data.
     * If not specified, the agent's default language is used.
     * For more information, see
     * [Multilingual intent and entity
     * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      if (updateMask_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest)
  private static final com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest();
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchUpdateEntityTypesRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchUpdateEntityTypesRequest>() {
        @java.lang.Override
        public BatchUpdateEntityTypesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchUpdateEntityTypesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchUpdateEntityTypesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.BatchUpdateEntityTypesRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
