/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/intent.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * The request message for
 * [Intents.BatchUpdateIntents][google.cloud.dialogflow.v2beta1.Intents.BatchUpdateIntents].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest}
 */
public final class BatchUpdateIntentsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest)
    BatchUpdateIntentsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchUpdateIntentsRequest.newBuilder() to construct.
  private BatchUpdateIntentsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchUpdateIntentsRequest() {
    parent_ = "";
    languageCode_ = "";
    intentView_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchUpdateIntentsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.IntentProto
        .internal_static_google_cloud_dialogflow_v2beta1_BatchUpdateIntentsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.IntentProto
        .internal_static_google_cloud_dialogflow_v2beta1_BatchUpdateIntentsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest.class,
            com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest.Builder.class);
  }

  private int bitField0_;
  private int intentBatchCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object intentBatch_;

  public enum IntentBatchCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INTENT_BATCH_URI(2),
    INTENT_BATCH_INLINE(3),
    INTENTBATCH_NOT_SET(0);
    private final int value;

    private IntentBatchCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IntentBatchCase valueOf(int value) {
      return forNumber(value);
    }

    public static IntentBatchCase forNumber(int value) {
      switch (value) {
        case 2:
          return INTENT_BATCH_URI;
        case 3:
          return INTENT_BATCH_INLINE;
        case 0:
          return INTENTBATCH_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public IntentBatchCase getIntentBatchCase() {
    return IntentBatchCase.forNumber(intentBatchCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the agent to update or create intents in.
   * Supported formats:
   *
   * - `projects/&lt;Project ID&gt;/agent`
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the agent to update or create intents in.
   * Supported formats:
   *
   * - `projects/&lt;Project ID&gt;/agent`
   * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTENT_BATCH_URI_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The URI to a Google Cloud Storage file containing intents to update or
   * create. The file format can either be a serialized proto (of IntentBatch
   * type) or JSON object. Note: The URI must start with "gs://".
   * </pre>
   *
   * <code>string intent_batch_uri = 2;</code>
   *
   * @return Whether the intentBatchUri field is set.
   */
  public boolean hasIntentBatchUri() {
    return intentBatchCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The URI to a Google Cloud Storage file containing intents to update or
   * create. The file format can either be a serialized proto (of IntentBatch
   * type) or JSON object. Note: The URI must start with "gs://".
   * </pre>
   *
   * <code>string intent_batch_uri = 2;</code>
   *
   * @return The intentBatchUri.
   */
  public java.lang.String getIntentBatchUri() {
    java.lang.Object ref = "";
    if (intentBatchCase_ == 2) {
      ref = intentBatch_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (intentBatchCase_ == 2) {
        intentBatch_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI to a Google Cloud Storage file containing intents to update or
   * create. The file format can either be a serialized proto (of IntentBatch
   * type) or JSON object. Note: The URI must start with "gs://".
   * </pre>
   *
   * <code>string intent_batch_uri = 2;</code>
   *
   * @return The bytes for intentBatchUri.
   */
  public com.google.protobuf.ByteString getIntentBatchUriBytes() {
    java.lang.Object ref = "";
    if (intentBatchCase_ == 2) {
      ref = intentBatch_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (intentBatchCase_ == 2) {
        intentBatch_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INTENT_BATCH_INLINE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The collection of intents to update or create.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentBatch intent_batch_inline = 3;</code>
   *
   * @return Whether the intentBatchInline field is set.
   */
  @java.lang.Override
  public boolean hasIntentBatchInline() {
    return intentBatchCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The collection of intents to update or create.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentBatch intent_batch_inline = 3;</code>
   *
   * @return The intentBatchInline.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.IntentBatch getIntentBatchInline() {
    if (intentBatchCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.IntentBatch) intentBatch_;
    }
    return com.google.cloud.dialogflow.v2beta1.IntentBatch.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The collection of intents to update or create.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentBatch intent_batch_inline = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.IntentBatchOrBuilder getIntentBatchInlineOrBuilder() {
    if (intentBatchCase_ == 3) {
      return (com.google.cloud.dialogflow.v2beta1.IntentBatch) intentBatch_;
    }
    return com.google.cloud.dialogflow.v2beta1.IntentBatch.getDefaultInstance();
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The language used to access language-specific data.
   * If not specified, the agent's default language is used.
   * For more information, see
   * [Multilingual intent and entity
   * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
   * </pre>
   *
   * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The language used to access language-specific data.
   * If not specified, the agent's default language is used.
   * For more information, see
   * [Multilingual intent and entity
   * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
   * </pre>
   *
   * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 5;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Optional. The mask to control which fields get updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 5;</code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The mask to control which fields get updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 5;</code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The mask to control which fields get updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  public static final int INTENT_VIEW_FIELD_NUMBER = 6;
  private int intentView_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The resource view to apply to the returned intent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentView intent_view = 6;</code>
   *
   * @return The enum numeric value on the wire for intentView.
   */
  @java.lang.Override
  public int getIntentViewValue() {
    return intentView_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The resource view to apply to the returned intent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentView intent_view = 6;</code>
   *
   * @return The intentView.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.IntentView getIntentView() {
    com.google.cloud.dialogflow.v2beta1.IntentView result =
        com.google.cloud.dialogflow.v2beta1.IntentView.forNumber(intentView_);
    return result == null ? com.google.cloud.dialogflow.v2beta1.IntentView.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (intentBatchCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, intentBatch_);
    }
    if (intentBatchCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.dialogflow.v2beta1.IntentBatch) intentBatch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, languageCode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getUpdateMask());
    }
    if (intentView_
        != com.google.cloud.dialogflow.v2beta1.IntentView.INTENT_VIEW_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, intentView_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (intentBatchCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, intentBatch_);
    }
    if (intentBatchCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dialogflow.v2beta1.IntentBatch) intentBatch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, languageCode_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateMask());
    }
    if (intentView_
        != com.google.cloud.dialogflow.v2beta1.IntentView.INTENT_VIEW_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, intentView_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest other =
        (com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (intentView_ != other.intentView_) return false;
    if (!getIntentBatchCase().equals(other.getIntentBatchCase())) return false;
    switch (intentBatchCase_) {
      case 2:
        if (!getIntentBatchUri().equals(other.getIntentBatchUri())) return false;
        break;
      case 3:
        if (!getIntentBatchInline().equals(other.getIntentBatchInline())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    hash = (37 * hash) + INTENT_VIEW_FIELD_NUMBER;
    hash = (53 * hash) + intentView_;
    switch (intentBatchCase_) {
      case 2:
        hash = (37 * hash) + INTENT_BATCH_URI_FIELD_NUMBER;
        hash = (53 * hash) + getIntentBatchUri().hashCode();
        break;
      case 3:
        hash = (37 * hash) + INTENT_BATCH_INLINE_FIELD_NUMBER;
        hash = (53 * hash) + getIntentBatchInline().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for
   * [Intents.BatchUpdateIntents][google.cloud.dialogflow.v2beta1.Intents.BatchUpdateIntents].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest)
      com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.IntentProto
          .internal_static_google_cloud_dialogflow_v2beta1_BatchUpdateIntentsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.IntentProto
          .internal_static_google_cloud_dialogflow_v2beta1_BatchUpdateIntentsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest.class,
              com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUpdateMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (intentBatchInlineBuilder_ != null) {
        intentBatchInlineBuilder_.clear();
      }
      languageCode_ = "";
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      intentView_ = 0;
      intentBatchCase_ = 0;
      intentBatch_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.IntentProto
          .internal_static_google_cloud_dialogflow_v2beta1_BatchUpdateIntentsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest build() {
      com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest buildPartial() {
      com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest result =
          new com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.languageCode_ = languageCode_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.intentView_ = intentView_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest result) {
      result.intentBatchCase_ = intentBatchCase_;
      result.intentBatch_ = this.intentBatch_;
      if (intentBatchCase_ == 3 && intentBatchInlineBuilder_ != null) {
        result.intentBatch_ = intentBatchInlineBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest other) {
      if (other
          == com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      if (other.intentView_ != 0) {
        setIntentViewValue(other.getIntentViewValue());
      }
      switch (other.getIntentBatchCase()) {
        case INTENT_BATCH_URI:
          {
            intentBatchCase_ = 2;
            intentBatch_ = other.intentBatch_;
            onChanged();
            break;
          }
        case INTENT_BATCH_INLINE:
          {
            mergeIntentBatchInline(other.getIntentBatchInline());
            break;
          }
        case INTENTBATCH_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                intentBatchCase_ = 2;
                intentBatch_ = s;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getIntentBatchInlineFieldBuilder().getBuilder(), extensionRegistry);
                intentBatchCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                intentView_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int intentBatchCase_ = 0;
    private java.lang.Object intentBatch_;

    public IntentBatchCase getIntentBatchCase() {
      return IntentBatchCase.forNumber(intentBatchCase_);
    }

    public Builder clearIntentBatch() {
      intentBatchCase_ = 0;
      intentBatch_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to update or create intents in.
     * Supported formats:
     *
     * - `projects/&lt;Project ID&gt;/agent`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to update or create intents in.
     * Supported formats:
     *
     * - `projects/&lt;Project ID&gt;/agent`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to update or create intents in.
     * Supported formats:
     *
     * - `projects/&lt;Project ID&gt;/agent`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to update or create intents in.
     * Supported formats:
     *
     * - `projects/&lt;Project ID&gt;/agent`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the agent to update or create intents in.
     * Supported formats:
     *
     * - `projects/&lt;Project ID&gt;/agent`
     * - `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URI to a Google Cloud Storage file containing intents to update or
     * create. The file format can either be a serialized proto (of IntentBatch
     * type) or JSON object. Note: The URI must start with "gs://".
     * </pre>
     *
     * <code>string intent_batch_uri = 2;</code>
     *
     * @return Whether the intentBatchUri field is set.
     */
    @java.lang.Override
    public boolean hasIntentBatchUri() {
      return intentBatchCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The URI to a Google Cloud Storage file containing intents to update or
     * create. The file format can either be a serialized proto (of IntentBatch
     * type) or JSON object. Note: The URI must start with "gs://".
     * </pre>
     *
     * <code>string intent_batch_uri = 2;</code>
     *
     * @return The intentBatchUri.
     */
    @java.lang.Override
    public java.lang.String getIntentBatchUri() {
      java.lang.Object ref = "";
      if (intentBatchCase_ == 2) {
        ref = intentBatch_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (intentBatchCase_ == 2) {
          intentBatch_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI to a Google Cloud Storage file containing intents to update or
     * create. The file format can either be a serialized proto (of IntentBatch
     * type) or JSON object. Note: The URI must start with "gs://".
     * </pre>
     *
     * <code>string intent_batch_uri = 2;</code>
     *
     * @return The bytes for intentBatchUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIntentBatchUriBytes() {
      java.lang.Object ref = "";
      if (intentBatchCase_ == 2) {
        ref = intentBatch_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (intentBatchCase_ == 2) {
          intentBatch_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI to a Google Cloud Storage file containing intents to update or
     * create. The file format can either be a serialized proto (of IntentBatch
     * type) or JSON object. Note: The URI must start with "gs://".
     * </pre>
     *
     * <code>string intent_batch_uri = 2;</code>
     *
     * @param value The intentBatchUri to set.
     * @return This builder for chaining.
     */
    public Builder setIntentBatchUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      intentBatchCase_ = 2;
      intentBatch_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI to a Google Cloud Storage file containing intents to update or
     * create. The file format can either be a serialized proto (of IntentBatch
     * type) or JSON object. Note: The URI must start with "gs://".
     * </pre>
     *
     * <code>string intent_batch_uri = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntentBatchUri() {
      if (intentBatchCase_ == 2) {
        intentBatchCase_ = 0;
        intentBatch_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI to a Google Cloud Storage file containing intents to update or
     * create. The file format can either be a serialized proto (of IntentBatch
     * type) or JSON object. Note: The URI must start with "gs://".
     * </pre>
     *
     * <code>string intent_batch_uri = 2;</code>
     *
     * @param value The bytes for intentBatchUri to set.
     * @return This builder for chaining.
     */
    public Builder setIntentBatchUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      intentBatchCase_ = 2;
      intentBatch_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.IntentBatch,
            com.google.cloud.dialogflow.v2beta1.IntentBatch.Builder,
            com.google.cloud.dialogflow.v2beta1.IntentBatchOrBuilder>
        intentBatchInlineBuilder_;
    /**
     *
     *
     * <pre>
     * The collection of intents to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentBatch intent_batch_inline = 3;</code>
     *
     * @return Whether the intentBatchInline field is set.
     */
    @java.lang.Override
    public boolean hasIntentBatchInline() {
      return intentBatchCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The collection of intents to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentBatch intent_batch_inline = 3;</code>
     *
     * @return The intentBatchInline.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.IntentBatch getIntentBatchInline() {
      if (intentBatchInlineBuilder_ == null) {
        if (intentBatchCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.IntentBatch) intentBatch_;
        }
        return com.google.cloud.dialogflow.v2beta1.IntentBatch.getDefaultInstance();
      } else {
        if (intentBatchCase_ == 3) {
          return intentBatchInlineBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.IntentBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of intents to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentBatch intent_batch_inline = 3;</code>
     */
    public Builder setIntentBatchInline(com.google.cloud.dialogflow.v2beta1.IntentBatch value) {
      if (intentBatchInlineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        intentBatch_ = value;
        onChanged();
      } else {
        intentBatchInlineBuilder_.setMessage(value);
      }
      intentBatchCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of intents to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentBatch intent_batch_inline = 3;</code>
     */
    public Builder setIntentBatchInline(
        com.google.cloud.dialogflow.v2beta1.IntentBatch.Builder builderForValue) {
      if (intentBatchInlineBuilder_ == null) {
        intentBatch_ = builderForValue.build();
        onChanged();
      } else {
        intentBatchInlineBuilder_.setMessage(builderForValue.build());
      }
      intentBatchCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of intents to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentBatch intent_batch_inline = 3;</code>
     */
    public Builder mergeIntentBatchInline(com.google.cloud.dialogflow.v2beta1.IntentBatch value) {
      if (intentBatchInlineBuilder_ == null) {
        if (intentBatchCase_ == 3
            && intentBatch_
                != com.google.cloud.dialogflow.v2beta1.IntentBatch.getDefaultInstance()) {
          intentBatch_ =
              com.google.cloud.dialogflow.v2beta1.IntentBatch.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.IntentBatch) intentBatch_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          intentBatch_ = value;
        }
        onChanged();
      } else {
        if (intentBatchCase_ == 3) {
          intentBatchInlineBuilder_.mergeFrom(value);
        } else {
          intentBatchInlineBuilder_.setMessage(value);
        }
      }
      intentBatchCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of intents to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentBatch intent_batch_inline = 3;</code>
     */
    public Builder clearIntentBatchInline() {
      if (intentBatchInlineBuilder_ == null) {
        if (intentBatchCase_ == 3) {
          intentBatchCase_ = 0;
          intentBatch_ = null;
          onChanged();
        }
      } else {
        if (intentBatchCase_ == 3) {
          intentBatchCase_ = 0;
          intentBatch_ = null;
        }
        intentBatchInlineBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of intents to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentBatch intent_batch_inline = 3;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.IntentBatch.Builder getIntentBatchInlineBuilder() {
      return getIntentBatchInlineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The collection of intents to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentBatch intent_batch_inline = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.IntentBatchOrBuilder
        getIntentBatchInlineOrBuilder() {
      if ((intentBatchCase_ == 3) && (intentBatchInlineBuilder_ != null)) {
        return intentBatchInlineBuilder_.getMessageOrBuilder();
      } else {
        if (intentBatchCase_ == 3) {
          return (com.google.cloud.dialogflow.v2beta1.IntentBatch) intentBatch_;
        }
        return com.google.cloud.dialogflow.v2beta1.IntentBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of intents to update or create.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentBatch intent_batch_inline = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.IntentBatch,
            com.google.cloud.dialogflow.v2beta1.IntentBatch.Builder,
            com.google.cloud.dialogflow.v2beta1.IntentBatchOrBuilder>
        getIntentBatchInlineFieldBuilder() {
      if (intentBatchInlineBuilder_ == null) {
        if (!(intentBatchCase_ == 3)) {
          intentBatch_ = com.google.cloud.dialogflow.v2beta1.IntentBatch.getDefaultInstance();
        }
        intentBatchInlineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.IntentBatch,
                com.google.cloud.dialogflow.v2beta1.IntentBatch.Builder,
                com.google.cloud.dialogflow.v2beta1.IntentBatchOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.IntentBatch) intentBatch_,
                getParentForChildren(),
                isClean());
        intentBatch_ = null;
      }
      intentBatchCase_ = 3;
      onChanged();
      return intentBatchInlineBuilder_;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The language used to access language-specific data.
     * If not specified, the agent's default language is used.
     * For more information, see
     * [Multilingual intent and entity
     * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The language used to access language-specific data.
     * If not specified, the agent's default language is used.
     * For more information, see
     * [Multilingual intent and entity
     * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The language used to access language-specific data.
     * If not specified, the agent's default language is used.
     * For more information, see
     * [Multilingual intent and entity
     * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The language used to access language-specific data.
     * If not specified, the agent's default language is used.
     * For more information, see
     * [Multilingual intent and entity
     * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The language used to access language-specific data.
     * If not specified, the agent's default language is used.
     * For more information, see
     * [Multilingual intent and entity
     * data](https://cloud.google.com/dialogflow/docs/agents-multilingual#intent-entity).
     * </pre>
     *
     * <code>string language_code = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5;</code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5;</code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5;</code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5;</code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5;</code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      if (updateMask_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5;</code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5;</code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The mask to control which fields get updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    private int intentView_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The resource view to apply to the returned intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentView intent_view = 6;</code>
     *
     * @return The enum numeric value on the wire for intentView.
     */
    @java.lang.Override
    public int getIntentViewValue() {
      return intentView_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource view to apply to the returned intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentView intent_view = 6;</code>
     *
     * @param value The enum numeric value on the wire for intentView to set.
     * @return This builder for chaining.
     */
    public Builder setIntentViewValue(int value) {
      intentView_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource view to apply to the returned intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentView intent_view = 6;</code>
     *
     * @return The intentView.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.IntentView getIntentView() {
      com.google.cloud.dialogflow.v2beta1.IntentView result =
          com.google.cloud.dialogflow.v2beta1.IntentView.forNumber(intentView_);
      return result == null ? com.google.cloud.dialogflow.v2beta1.IntentView.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource view to apply to the returned intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentView intent_view = 6;</code>
     *
     * @param value The intentView to set.
     * @return This builder for chaining.
     */
    public Builder setIntentView(com.google.cloud.dialogflow.v2beta1.IntentView value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      intentView_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The resource view to apply to the returned intent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentView intent_view = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntentView() {
      bitField0_ = (bitField0_ & ~0x00000020);
      intentView_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest)
  private static final com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest();
  }

  public static com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchUpdateIntentsRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchUpdateIntentsRequest>() {
        @java.lang.Override
        public BatchUpdateIntentsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchUpdateIntentsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchUpdateIntentsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
