/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/conversation_profile.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Defines the Human Agent Assistant to connect to a conversation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig}
 */
public final class HumanAgentAssistantConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig)
    HumanAgentAssistantConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HumanAgentAssistantConfig.newBuilder() to construct.
  private HumanAgentAssistantConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HumanAgentAssistantConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HumanAgentAssistantConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
        .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
        .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.class,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.Builder.class);
  }

  public interface SuggestionTriggerSettingsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Do not trigger if last utterance is small talk.
     * </pre>
     *
     * <code>bool no_small_talk = 1;</code>
     *
     * @return The noSmallTalk.
     */
    boolean getNoSmallTalk();

    /**
     *
     *
     * <pre>
     * Only trigger suggestion if participant role of last utterance is
     * END_USER.
     * </pre>
     *
     * <code>bool only_end_user = 2;</code>
     *
     * @return The onlyEndUser.
     */
    boolean getOnlyEndUser();
  }
  /**
   *
   *
   * <pre>
   * Settings of suggestion trigger.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings}
   */
  public static final class SuggestionTriggerSettings extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings)
      SuggestionTriggerSettingsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SuggestionTriggerSettings.newBuilder() to construct.
    private SuggestionTriggerSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SuggestionTriggerSettings() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SuggestionTriggerSettings();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionTriggerSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionTriggerSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionTriggerSettings.class,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionTriggerSettings.Builder.class);
    }

    public static final int NO_SMALL_TALK_FIELD_NUMBER = 1;
    private boolean noSmallTalk_ = false;
    /**
     *
     *
     * <pre>
     * Do not trigger if last utterance is small talk.
     * </pre>
     *
     * <code>bool no_small_talk = 1;</code>
     *
     * @return The noSmallTalk.
     */
    @java.lang.Override
    public boolean getNoSmallTalk() {
      return noSmallTalk_;
    }

    public static final int ONLY_END_USER_FIELD_NUMBER = 2;
    private boolean onlyEndUser_ = false;
    /**
     *
     *
     * <pre>
     * Only trigger suggestion if participant role of last utterance is
     * END_USER.
     * </pre>
     *
     * <code>bool only_end_user = 2;</code>
     *
     * @return The onlyEndUser.
     */
    @java.lang.Override
    public boolean getOnlyEndUser() {
      return onlyEndUser_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (noSmallTalk_ != false) {
        output.writeBool(1, noSmallTalk_);
      }
      if (onlyEndUser_ != false) {
        output.writeBool(2, onlyEndUser_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (noSmallTalk_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, noSmallTalk_);
      }
      if (onlyEndUser_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, onlyEndUser_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionTriggerSettings)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
          other =
              (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionTriggerSettings)
                  obj;

      if (getNoSmallTalk() != other.getNoSmallTalk()) return false;
      if (getOnlyEndUser() != other.getOnlyEndUser()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NO_SMALL_TALK_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNoSmallTalk());
      hash = (37 * hash) + ONLY_END_USER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getOnlyEndUser());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Settings of suggestion trigger.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings)
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionTriggerSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionTriggerSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionTriggerSettings.class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionTriggerSettings.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        noSmallTalk_ = false;
        onlyEndUser_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionTriggerSettings_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
          build() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
          buildPartial() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
            result =
                new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionTriggerSettings(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.noSmallTalk_ = noSmallTalk_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.onlyEndUser_ = onlyEndUser_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionTriggerSettings) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionTriggerSettings)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
              other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionTriggerSettings.getDefaultInstance()) return this;
        if (other.getNoSmallTalk() != false) {
          setNoSmallTalk(other.getNoSmallTalk());
        }
        if (other.getOnlyEndUser() != false) {
          setOnlyEndUser(other.getOnlyEndUser());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  noSmallTalk_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  onlyEndUser_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean noSmallTalk_;
      /**
       *
       *
       * <pre>
       * Do not trigger if last utterance is small talk.
       * </pre>
       *
       * <code>bool no_small_talk = 1;</code>
       *
       * @return The noSmallTalk.
       */
      @java.lang.Override
      public boolean getNoSmallTalk() {
        return noSmallTalk_;
      }
      /**
       *
       *
       * <pre>
       * Do not trigger if last utterance is small talk.
       * </pre>
       *
       * <code>bool no_small_talk = 1;</code>
       *
       * @param value The noSmallTalk to set.
       * @return This builder for chaining.
       */
      public Builder setNoSmallTalk(boolean value) {

        noSmallTalk_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Do not trigger if last utterance is small talk.
       * </pre>
       *
       * <code>bool no_small_talk = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNoSmallTalk() {
        bitField0_ = (bitField0_ & ~0x00000001);
        noSmallTalk_ = false;
        onChanged();
        return this;
      }

      private boolean onlyEndUser_;
      /**
       *
       *
       * <pre>
       * Only trigger suggestion if participant role of last utterance is
       * END_USER.
       * </pre>
       *
       * <code>bool only_end_user = 2;</code>
       *
       * @return The onlyEndUser.
       */
      @java.lang.Override
      public boolean getOnlyEndUser() {
        return onlyEndUser_;
      }
      /**
       *
       *
       * <pre>
       * Only trigger suggestion if participant role of last utterance is
       * END_USER.
       * </pre>
       *
       * <code>bool only_end_user = 2;</code>
       *
       * @param value The onlyEndUser to set.
       * @return This builder for chaining.
       */
      public Builder setOnlyEndUser(boolean value) {

        onlyEndUser_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Only trigger suggestion if participant role of last utterance is
       * END_USER.
       * </pre>
       *
       * <code>bool only_end_user = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOnlyEndUser() {
        bitField0_ = (bitField0_ & ~0x00000002);
        onlyEndUser_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings)
    private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionTriggerSettings();
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettings
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SuggestionTriggerSettings> PARSER =
        new com.google.protobuf.AbstractParser<SuggestionTriggerSettings>() {
          @java.lang.Override
          public SuggestionTriggerSettings parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SuggestionTriggerSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SuggestionTriggerSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SuggestionFeatureConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The suggestion feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
     *
     * @return Whether the suggestionFeature field is set.
     */
    boolean hasSuggestionFeature();
    /**
     *
     *
     * <pre>
     * The suggestion feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
     *
     * @return The suggestionFeature.
     */
    com.google.cloud.dialogflow.v2beta1.SuggestionFeature getSuggestionFeature();
    /**
     *
     *
     * <pre>
     * The suggestion feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
     */
    com.google.cloud.dialogflow.v2beta1.SuggestionFeatureOrBuilder getSuggestionFeatureOrBuilder();

    /**
     *
     *
     * <pre>
     * Automatically iterates all participants and tries to compile
     * suggestions.
     *
     * Supported features: ARTICLE_SUGGESTION, FAQ, DIALOGFLOW_ASSIST,
     * ENTITY_EXTRACTION, KNOWLEDGE_ASSIST.
     * </pre>
     *
     * <code>bool enable_event_based_suggestion = 3;</code>
     *
     * @return The enableEventBasedSuggestion.
     */
    boolean getEnableEventBasedSuggestion();

    /**
     *
     *
     * <pre>
     * Optional. Disable the logging of search queries sent by human agents. It
     * can prevent those queries from being stored at answer records.
     *
     * Supported features: KNOWLEDGE_SEARCH.
     * </pre>
     *
     * <code>bool disable_agent_query_logging = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disableAgentQueryLogging.
     */
    boolean getDisableAgentQueryLogging();

    /**
     *
     *
     * <pre>
     * Optional. Enable query suggestion even if we can't find its answer.
     * By default, queries are suggested only if we find its answer.
     * Supported features: KNOWLEDGE_ASSIST
     * </pre>
     *
     * <code>
     * bool enable_query_suggestion_when_no_answer = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enableQuerySuggestionWhenNoAnswer.
     */
    boolean getEnableQuerySuggestionWhenNoAnswer();

    /**
     *
     *
     * <pre>
     * Optional. Enable including conversation context during query answer
     * generation. Supported features: KNOWLEDGE_SEARCH.
     * </pre>
     *
     * <code>
     * bool enable_conversation_augmented_query = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enableConversationAugmentedQuery.
     */
    boolean getEnableConversationAugmentedQuery();

    /**
     *
     *
     * <pre>
     * Optional. Enable query suggestion only.
     * Supported features: KNOWLEDGE_ASSIST
     * </pre>
     *
     * <code>bool enable_query_suggestion_only = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enableQuerySuggestionOnly.
     */
    boolean getEnableQuerySuggestionOnly();

    /**
     *
     *
     * <pre>
     * Settings of suggestion trigger.
     *
     * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
     * this field.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
     * </code>
     *
     * @return Whether the suggestionTriggerSettings field is set.
     */
    boolean hasSuggestionTriggerSettings();
    /**
     *
     *
     * <pre>
     * Settings of suggestion trigger.
     *
     * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
     * this field.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
     * </code>
     *
     * @return The suggestionTriggerSettings.
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
        getSuggestionTriggerSettings();
    /**
     *
     *
     * <pre>
     * Settings of suggestion trigger.
     *
     * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
     * this field.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettingsOrBuilder
        getSuggestionTriggerSettingsOrBuilder();

    /**
     *
     *
     * <pre>
     * Configs of query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
     * </code>
     *
     * @return Whether the queryConfig field is set.
     */
    boolean hasQueryConfig();
    /**
     *
     *
     * <pre>
     * Configs of query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
     * </code>
     *
     * @return The queryConfig.
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
        getQueryConfig();
    /**
     *
     *
     * <pre>
     * Configs of query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfigOrBuilder
        getQueryConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Configs of custom conversation model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
     * </code>
     *
     * @return Whether the conversationModelConfig field is set.
     */
    boolean hasConversationModelConfig();
    /**
     *
     *
     * <pre>
     * Configs of custom conversation model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
     * </code>
     *
     * @return The conversationModelConfig.
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
        getConversationModelConfig();
    /**
     *
     *
     * <pre>
     * Configs of custom conversation model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfigOrBuilder
        getConversationModelConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Configs for processing conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
     * </code>
     *
     * @return Whether the conversationProcessConfig field is set.
     */
    boolean hasConversationProcessConfig();
    /**
     *
     *
     * <pre>
     * Configs for processing conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
     * </code>
     *
     * @return The conversationProcessConfig.
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
        getConversationProcessConfig();
    /**
     *
     *
     * <pre>
     * Configs for processing conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfigOrBuilder
        getConversationProcessConfigOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Config for suggestion features.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig}
   */
  public static final class SuggestionFeatureConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig)
      SuggestionFeatureConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SuggestionFeatureConfig.newBuilder() to construct.
    private SuggestionFeatureConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SuggestionFeatureConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SuggestionFeatureConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionFeatureConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionFeatureConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
                  .class,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
                  .Builder.class);
    }

    private int bitField0_;
    public static final int SUGGESTION_FEATURE_FIELD_NUMBER = 5;
    private com.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestionFeature_;
    /**
     *
     *
     * <pre>
     * The suggestion feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
     *
     * @return Whether the suggestionFeature field is set.
     */
    @java.lang.Override
    public boolean hasSuggestionFeature() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The suggestion feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
     *
     * @return The suggestionFeature.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestionFeature getSuggestionFeature() {
      return suggestionFeature_ == null
          ? com.google.cloud.dialogflow.v2beta1.SuggestionFeature.getDefaultInstance()
          : suggestionFeature_;
    }
    /**
     *
     *
     * <pre>
     * The suggestion feature.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestionFeatureOrBuilder
        getSuggestionFeatureOrBuilder() {
      return suggestionFeature_ == null
          ? com.google.cloud.dialogflow.v2beta1.SuggestionFeature.getDefaultInstance()
          : suggestionFeature_;
    }

    public static final int ENABLE_EVENT_BASED_SUGGESTION_FIELD_NUMBER = 3;
    private boolean enableEventBasedSuggestion_ = false;
    /**
     *
     *
     * <pre>
     * Automatically iterates all participants and tries to compile
     * suggestions.
     *
     * Supported features: ARTICLE_SUGGESTION, FAQ, DIALOGFLOW_ASSIST,
     * ENTITY_EXTRACTION, KNOWLEDGE_ASSIST.
     * </pre>
     *
     * <code>bool enable_event_based_suggestion = 3;</code>
     *
     * @return The enableEventBasedSuggestion.
     */
    @java.lang.Override
    public boolean getEnableEventBasedSuggestion() {
      return enableEventBasedSuggestion_;
    }

    public static final int DISABLE_AGENT_QUERY_LOGGING_FIELD_NUMBER = 14;
    private boolean disableAgentQueryLogging_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Disable the logging of search queries sent by human agents. It
     * can prevent those queries from being stored at answer records.
     *
     * Supported features: KNOWLEDGE_SEARCH.
     * </pre>
     *
     * <code>bool disable_agent_query_logging = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disableAgentQueryLogging.
     */
    @java.lang.Override
    public boolean getDisableAgentQueryLogging() {
      return disableAgentQueryLogging_;
    }

    public static final int ENABLE_QUERY_SUGGESTION_WHEN_NO_ANSWER_FIELD_NUMBER = 15;
    private boolean enableQuerySuggestionWhenNoAnswer_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Enable query suggestion even if we can't find its answer.
     * By default, queries are suggested only if we find its answer.
     * Supported features: KNOWLEDGE_ASSIST
     * </pre>
     *
     * <code>
     * bool enable_query_suggestion_when_no_answer = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enableQuerySuggestionWhenNoAnswer.
     */
    @java.lang.Override
    public boolean getEnableQuerySuggestionWhenNoAnswer() {
      return enableQuerySuggestionWhenNoAnswer_;
    }

    public static final int ENABLE_CONVERSATION_AUGMENTED_QUERY_FIELD_NUMBER = 16;
    private boolean enableConversationAugmentedQuery_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Enable including conversation context during query answer
     * generation. Supported features: KNOWLEDGE_SEARCH.
     * </pre>
     *
     * <code>
     * bool enable_conversation_augmented_query = 16 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enableConversationAugmentedQuery.
     */
    @java.lang.Override
    public boolean getEnableConversationAugmentedQuery() {
      return enableConversationAugmentedQuery_;
    }

    public static final int ENABLE_QUERY_SUGGESTION_ONLY_FIELD_NUMBER = 17;
    private boolean enableQuerySuggestionOnly_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Enable query suggestion only.
     * Supported features: KNOWLEDGE_ASSIST
     * </pre>
     *
     * <code>bool enable_query_suggestion_only = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enableQuerySuggestionOnly.
     */
    @java.lang.Override
    public boolean getEnableQuerySuggestionOnly() {
      return enableQuerySuggestionOnly_;
    }

    public static final int SUGGESTION_TRIGGER_SETTINGS_FIELD_NUMBER = 10;
    private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
        suggestionTriggerSettings_;
    /**
     *
     *
     * <pre>
     * Settings of suggestion trigger.
     *
     * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
     * this field.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
     * </code>
     *
     * @return Whether the suggestionTriggerSettings field is set.
     */
    @java.lang.Override
    public boolean hasSuggestionTriggerSettings() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings of suggestion trigger.
     *
     * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
     * this field.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
     * </code>
     *
     * @return The suggestionTriggerSettings.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
        getSuggestionTriggerSettings() {
      return suggestionTriggerSettings_ == null
          ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
              .getDefaultInstance()
          : suggestionTriggerSettings_;
    }
    /**
     *
     *
     * <pre>
     * Settings of suggestion trigger.
     *
     * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
     * this field.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionTriggerSettingsOrBuilder
        getSuggestionTriggerSettingsOrBuilder() {
      return suggestionTriggerSettings_ == null
          ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
              .getDefaultInstance()
          : suggestionTriggerSettings_;
    }

    public static final int QUERY_CONFIG_FIELD_NUMBER = 6;
    private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
        queryConfig_;
    /**
     *
     *
     * <pre>
     * Configs of query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
     * </code>
     *
     * @return Whether the queryConfig field is set.
     */
    @java.lang.Override
    public boolean hasQueryConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configs of query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
     * </code>
     *
     * @return The queryConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
        getQueryConfig() {
      return queryConfig_ == null
          ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .getDefaultInstance()
          : queryConfig_;
    }
    /**
     *
     *
     * <pre>
     * Configs of query.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfigOrBuilder
        getQueryConfigOrBuilder() {
      return queryConfig_ == null
          ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .getDefaultInstance()
          : queryConfig_;
    }

    public static final int CONVERSATION_MODEL_CONFIG_FIELD_NUMBER = 7;
    private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
        conversationModelConfig_;
    /**
     *
     *
     * <pre>
     * Configs of custom conversation model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
     * </code>
     *
     * @return Whether the conversationModelConfig field is set.
     */
    @java.lang.Override
    public boolean hasConversationModelConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configs of custom conversation model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
     * </code>
     *
     * @return The conversationModelConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
        getConversationModelConfig() {
      return conversationModelConfig_ == null
          ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
              .getDefaultInstance()
          : conversationModelConfig_;
    }
    /**
     *
     *
     * <pre>
     * Configs of custom conversation model.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfigOrBuilder
        getConversationModelConfigOrBuilder() {
      return conversationModelConfig_ == null
          ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
              .getDefaultInstance()
          : conversationModelConfig_;
    }

    public static final int CONVERSATION_PROCESS_CONFIG_FIELD_NUMBER = 8;
    private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
        conversationProcessConfig_;
    /**
     *
     *
     * <pre>
     * Configs for processing conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
     * </code>
     *
     * @return Whether the conversationProcessConfig field is set.
     */
    @java.lang.Override
    public boolean hasConversationProcessConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configs for processing conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
     * </code>
     *
     * @return The conversationProcessConfig.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
        getConversationProcessConfig() {
      return conversationProcessConfig_ == null
          ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
              .getDefaultInstance()
          : conversationProcessConfig_;
    }
    /**
     *
     *
     * <pre>
     * Configs for processing conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfigOrBuilder
        getConversationProcessConfigOrBuilder() {
      return conversationProcessConfig_ == null
          ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
              .getDefaultInstance()
          : conversationProcessConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enableEventBasedSuggestion_ != false) {
        output.writeBool(3, enableEventBasedSuggestion_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(5, getSuggestionFeature());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(6, getQueryConfig());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(7, getConversationModelConfig());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeMessage(8, getConversationProcessConfig());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(10, getSuggestionTriggerSettings());
      }
      if (disableAgentQueryLogging_ != false) {
        output.writeBool(14, disableAgentQueryLogging_);
      }
      if (enableQuerySuggestionWhenNoAnswer_ != false) {
        output.writeBool(15, enableQuerySuggestionWhenNoAnswer_);
      }
      if (enableConversationAugmentedQuery_ != false) {
        output.writeBool(16, enableConversationAugmentedQuery_);
      }
      if (enableQuerySuggestionOnly_ != false) {
        output.writeBool(17, enableQuerySuggestionOnly_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enableEventBasedSuggestion_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(3, enableEventBasedSuggestion_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSuggestionFeature());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getQueryConfig());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                7, getConversationModelConfig());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                8, getConversationProcessConfig());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                10, getSuggestionTriggerSettings());
      }
      if (disableAgentQueryLogging_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(14, disableAgentQueryLogging_);
      }
      if (enableQuerySuggestionWhenNoAnswer_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                15, enableQuerySuggestionWhenNoAnswer_);
      }
      if (enableConversationAugmentedQuery_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                16, enableConversationAugmentedQuery_);
      }
      if (enableQuerySuggestionOnly_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(17, enableQuerySuggestionOnly_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig other =
          (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig)
              obj;

      if (hasSuggestionFeature() != other.hasSuggestionFeature()) return false;
      if (hasSuggestionFeature()) {
        if (!getSuggestionFeature().equals(other.getSuggestionFeature())) return false;
      }
      if (getEnableEventBasedSuggestion() != other.getEnableEventBasedSuggestion()) return false;
      if (getDisableAgentQueryLogging() != other.getDisableAgentQueryLogging()) return false;
      if (getEnableQuerySuggestionWhenNoAnswer() != other.getEnableQuerySuggestionWhenNoAnswer())
        return false;
      if (getEnableConversationAugmentedQuery() != other.getEnableConversationAugmentedQuery())
        return false;
      if (getEnableQuerySuggestionOnly() != other.getEnableQuerySuggestionOnly()) return false;
      if (hasSuggestionTriggerSettings() != other.hasSuggestionTriggerSettings()) return false;
      if (hasSuggestionTriggerSettings()) {
        if (!getSuggestionTriggerSettings().equals(other.getSuggestionTriggerSettings()))
          return false;
      }
      if (hasQueryConfig() != other.hasQueryConfig()) return false;
      if (hasQueryConfig()) {
        if (!getQueryConfig().equals(other.getQueryConfig())) return false;
      }
      if (hasConversationModelConfig() != other.hasConversationModelConfig()) return false;
      if (hasConversationModelConfig()) {
        if (!getConversationModelConfig().equals(other.getConversationModelConfig())) return false;
      }
      if (hasConversationProcessConfig() != other.hasConversationProcessConfig()) return false;
      if (hasConversationProcessConfig()) {
        if (!getConversationProcessConfig().equals(other.getConversationProcessConfig()))
          return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSuggestionFeature()) {
        hash = (37 * hash) + SUGGESTION_FEATURE_FIELD_NUMBER;
        hash = (53 * hash) + getSuggestionFeature().hashCode();
      }
      hash = (37 * hash) + ENABLE_EVENT_BASED_SUGGESTION_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableEventBasedSuggestion());
      hash = (37 * hash) + DISABLE_AGENT_QUERY_LOGGING_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableAgentQueryLogging());
      hash = (37 * hash) + ENABLE_QUERY_SUGGESTION_WHEN_NO_ANSWER_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getEnableQuerySuggestionWhenNoAnswer());
      hash = (37 * hash) + ENABLE_CONVERSATION_AUGMENTED_QUERY_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getEnableConversationAugmentedQuery());
      hash = (37 * hash) + ENABLE_QUERY_SUGGESTION_ONLY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableQuerySuggestionOnly());
      if (hasSuggestionTriggerSettings()) {
        hash = (37 * hash) + SUGGESTION_TRIGGER_SETTINGS_FIELD_NUMBER;
        hash = (53 * hash) + getSuggestionTriggerSettings().hashCode();
      }
      if (hasQueryConfig()) {
        hash = (37 * hash) + QUERY_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getQueryConfig().hashCode();
      }
      if (hasConversationModelConfig()) {
        hash = (37 * hash) + CONVERSATION_MODEL_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getConversationModelConfig().hashCode();
      }
      if (hasConversationProcessConfig()) {
        hash = (37 * hash) + CONVERSATION_PROCESS_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getConversationProcessConfig().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config for suggestion features.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig)
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionFeatureConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionFeatureConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionFeatureConfig.class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionFeatureConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSuggestionFeatureFieldBuilder();
          getSuggestionTriggerSettingsFieldBuilder();
          getQueryConfigFieldBuilder();
          getConversationModelConfigFieldBuilder();
          getConversationProcessConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        suggestionFeature_ = null;
        if (suggestionFeatureBuilder_ != null) {
          suggestionFeatureBuilder_.dispose();
          suggestionFeatureBuilder_ = null;
        }
        enableEventBasedSuggestion_ = false;
        disableAgentQueryLogging_ = false;
        enableQuerySuggestionWhenNoAnswer_ = false;
        enableConversationAugmentedQuery_ = false;
        enableQuerySuggestionOnly_ = false;
        suggestionTriggerSettings_ = null;
        if (suggestionTriggerSettingsBuilder_ != null) {
          suggestionTriggerSettingsBuilder_.dispose();
          suggestionTriggerSettingsBuilder_ = null;
        }
        queryConfig_ = null;
        if (queryConfigBuilder_ != null) {
          queryConfigBuilder_.dispose();
          queryConfigBuilder_ = null;
        }
        conversationModelConfig_ = null;
        if (conversationModelConfigBuilder_ != null) {
          conversationModelConfigBuilder_.dispose();
          conversationModelConfigBuilder_ = null;
        }
        conversationProcessConfig_ = null;
        if (conversationProcessConfigBuilder_ != null) {
          conversationProcessConfigBuilder_.dispose();
          conversationProcessConfigBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionFeatureConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
          build() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
          buildPartial() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
            result =
                new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionFeatureConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.suggestionFeature_ =
              suggestionFeatureBuilder_ == null
                  ? suggestionFeature_
                  : suggestionFeatureBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.enableEventBasedSuggestion_ = enableEventBasedSuggestion_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.disableAgentQueryLogging_ = disableAgentQueryLogging_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.enableQuerySuggestionWhenNoAnswer_ = enableQuerySuggestionWhenNoAnswer_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.enableConversationAugmentedQuery_ = enableConversationAugmentedQuery_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.enableQuerySuggestionOnly_ = enableQuerySuggestionOnly_;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.suggestionTriggerSettings_ =
              suggestionTriggerSettingsBuilder_ == null
                  ? suggestionTriggerSettings_
                  : suggestionTriggerSettingsBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.queryConfig_ =
              queryConfigBuilder_ == null ? queryConfig_ : queryConfigBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.conversationModelConfig_ =
              conversationModelConfigBuilder_ == null
                  ? conversationModelConfig_
                  : conversationModelConfigBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.conversationProcessConfig_ =
              conversationProcessConfigBuilder_ == null
                  ? conversationProcessConfig_
                  : conversationProcessConfigBuilder_.build();
          to_bitField0_ |= 0x00000010;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionFeatureConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
              other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
                .getDefaultInstance()) return this;
        if (other.hasSuggestionFeature()) {
          mergeSuggestionFeature(other.getSuggestionFeature());
        }
        if (other.getEnableEventBasedSuggestion() != false) {
          setEnableEventBasedSuggestion(other.getEnableEventBasedSuggestion());
        }
        if (other.getDisableAgentQueryLogging() != false) {
          setDisableAgentQueryLogging(other.getDisableAgentQueryLogging());
        }
        if (other.getEnableQuerySuggestionWhenNoAnswer() != false) {
          setEnableQuerySuggestionWhenNoAnswer(other.getEnableQuerySuggestionWhenNoAnswer());
        }
        if (other.getEnableConversationAugmentedQuery() != false) {
          setEnableConversationAugmentedQuery(other.getEnableConversationAugmentedQuery());
        }
        if (other.getEnableQuerySuggestionOnly() != false) {
          setEnableQuerySuggestionOnly(other.getEnableQuerySuggestionOnly());
        }
        if (other.hasSuggestionTriggerSettings()) {
          mergeSuggestionTriggerSettings(other.getSuggestionTriggerSettings());
        }
        if (other.hasQueryConfig()) {
          mergeQueryConfig(other.getQueryConfig());
        }
        if (other.hasConversationModelConfig()) {
          mergeConversationModelConfig(other.getConversationModelConfig());
        }
        if (other.hasConversationProcessConfig()) {
          mergeConversationProcessConfig(other.getConversationProcessConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 24:
                {
                  enableEventBasedSuggestion_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 24
              case 42:
                {
                  input.readMessage(
                      getSuggestionFeatureFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getQueryConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000080;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(
                      getConversationModelConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000100;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(
                      getConversationProcessConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000200;
                  break;
                } // case 66
              case 82:
                {
                  input.readMessage(
                      getSuggestionTriggerSettingsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 82
              case 112:
                {
                  disableAgentQueryLogging_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 112
              case 120:
                {
                  enableQuerySuggestionWhenNoAnswer_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 120
              case 128:
                {
                  enableConversationAugmentedQuery_ = input.readBool();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 128
              case 136:
                {
                  enableQuerySuggestionOnly_ = input.readBool();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 136
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestionFeature_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.SuggestionFeature,
              com.google.cloud.dialogflow.v2beta1.SuggestionFeature.Builder,
              com.google.cloud.dialogflow.v2beta1.SuggestionFeatureOrBuilder>
          suggestionFeatureBuilder_;
      /**
       *
       *
       * <pre>
       * The suggestion feature.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
       *
       * @return Whether the suggestionFeature field is set.
       */
      public boolean hasSuggestionFeature() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The suggestion feature.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
       *
       * @return The suggestionFeature.
       */
      public com.google.cloud.dialogflow.v2beta1.SuggestionFeature getSuggestionFeature() {
        if (suggestionFeatureBuilder_ == null) {
          return suggestionFeature_ == null
              ? com.google.cloud.dialogflow.v2beta1.SuggestionFeature.getDefaultInstance()
              : suggestionFeature_;
        } else {
          return suggestionFeatureBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion feature.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
       */
      public Builder setSuggestionFeature(
          com.google.cloud.dialogflow.v2beta1.SuggestionFeature value) {
        if (suggestionFeatureBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          suggestionFeature_ = value;
        } else {
          suggestionFeatureBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion feature.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
       */
      public Builder setSuggestionFeature(
          com.google.cloud.dialogflow.v2beta1.SuggestionFeature.Builder builderForValue) {
        if (suggestionFeatureBuilder_ == null) {
          suggestionFeature_ = builderForValue.build();
        } else {
          suggestionFeatureBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion feature.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
       */
      public Builder mergeSuggestionFeature(
          com.google.cloud.dialogflow.v2beta1.SuggestionFeature value) {
        if (suggestionFeatureBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && suggestionFeature_ != null
              && suggestionFeature_
                  != com.google.cloud.dialogflow.v2beta1.SuggestionFeature.getDefaultInstance()) {
            getSuggestionFeatureBuilder().mergeFrom(value);
          } else {
            suggestionFeature_ = value;
          }
        } else {
          suggestionFeatureBuilder_.mergeFrom(value);
        }
        if (suggestionFeature_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion feature.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
       */
      public Builder clearSuggestionFeature() {
        bitField0_ = (bitField0_ & ~0x00000001);
        suggestionFeature_ = null;
        if (suggestionFeatureBuilder_ != null) {
          suggestionFeatureBuilder_.dispose();
          suggestionFeatureBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion feature.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
       */
      public com.google.cloud.dialogflow.v2beta1.SuggestionFeature.Builder
          getSuggestionFeatureBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getSuggestionFeatureFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The suggestion feature.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
       */
      public com.google.cloud.dialogflow.v2beta1.SuggestionFeatureOrBuilder
          getSuggestionFeatureOrBuilder() {
        if (suggestionFeatureBuilder_ != null) {
          return suggestionFeatureBuilder_.getMessageOrBuilder();
        } else {
          return suggestionFeature_ == null
              ? com.google.cloud.dialogflow.v2beta1.SuggestionFeature.getDefaultInstance()
              : suggestionFeature_;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion feature.
       * </pre>
       *
       * <code>.google.cloud.dialogflow.v2beta1.SuggestionFeature suggestion_feature = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.SuggestionFeature,
              com.google.cloud.dialogflow.v2beta1.SuggestionFeature.Builder,
              com.google.cloud.dialogflow.v2beta1.SuggestionFeatureOrBuilder>
          getSuggestionFeatureFieldBuilder() {
        if (suggestionFeatureBuilder_ == null) {
          suggestionFeatureBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2beta1.SuggestionFeature,
                  com.google.cloud.dialogflow.v2beta1.SuggestionFeature.Builder,
                  com.google.cloud.dialogflow.v2beta1.SuggestionFeatureOrBuilder>(
                  getSuggestionFeature(), getParentForChildren(), isClean());
          suggestionFeature_ = null;
        }
        return suggestionFeatureBuilder_;
      }

      private boolean enableEventBasedSuggestion_;
      /**
       *
       *
       * <pre>
       * Automatically iterates all participants and tries to compile
       * suggestions.
       *
       * Supported features: ARTICLE_SUGGESTION, FAQ, DIALOGFLOW_ASSIST,
       * ENTITY_EXTRACTION, KNOWLEDGE_ASSIST.
       * </pre>
       *
       * <code>bool enable_event_based_suggestion = 3;</code>
       *
       * @return The enableEventBasedSuggestion.
       */
      @java.lang.Override
      public boolean getEnableEventBasedSuggestion() {
        return enableEventBasedSuggestion_;
      }
      /**
       *
       *
       * <pre>
       * Automatically iterates all participants and tries to compile
       * suggestions.
       *
       * Supported features: ARTICLE_SUGGESTION, FAQ, DIALOGFLOW_ASSIST,
       * ENTITY_EXTRACTION, KNOWLEDGE_ASSIST.
       * </pre>
       *
       * <code>bool enable_event_based_suggestion = 3;</code>
       *
       * @param value The enableEventBasedSuggestion to set.
       * @return This builder for chaining.
       */
      public Builder setEnableEventBasedSuggestion(boolean value) {

        enableEventBasedSuggestion_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Automatically iterates all participants and tries to compile
       * suggestions.
       *
       * Supported features: ARTICLE_SUGGESTION, FAQ, DIALOGFLOW_ASSIST,
       * ENTITY_EXTRACTION, KNOWLEDGE_ASSIST.
       * </pre>
       *
       * <code>bool enable_event_based_suggestion = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableEventBasedSuggestion() {
        bitField0_ = (bitField0_ & ~0x00000002);
        enableEventBasedSuggestion_ = false;
        onChanged();
        return this;
      }

      private boolean disableAgentQueryLogging_;
      /**
       *
       *
       * <pre>
       * Optional. Disable the logging of search queries sent by human agents. It
       * can prevent those queries from being stored at answer records.
       *
       * Supported features: KNOWLEDGE_SEARCH.
       * </pre>
       *
       * <code>bool disable_agent_query_logging = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The disableAgentQueryLogging.
       */
      @java.lang.Override
      public boolean getDisableAgentQueryLogging() {
        return disableAgentQueryLogging_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Disable the logging of search queries sent by human agents. It
       * can prevent those queries from being stored at answer records.
       *
       * Supported features: KNOWLEDGE_SEARCH.
       * </pre>
       *
       * <code>bool disable_agent_query_logging = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The disableAgentQueryLogging to set.
       * @return This builder for chaining.
       */
      public Builder setDisableAgentQueryLogging(boolean value) {

        disableAgentQueryLogging_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Disable the logging of search queries sent by human agents. It
       * can prevent those queries from being stored at answer records.
       *
       * Supported features: KNOWLEDGE_SEARCH.
       * </pre>
       *
       * <code>bool disable_agent_query_logging = 14 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisableAgentQueryLogging() {
        bitField0_ = (bitField0_ & ~0x00000004);
        disableAgentQueryLogging_ = false;
        onChanged();
        return this;
      }

      private boolean enableQuerySuggestionWhenNoAnswer_;
      /**
       *
       *
       * <pre>
       * Optional. Enable query suggestion even if we can't find its answer.
       * By default, queries are suggested only if we find its answer.
       * Supported features: KNOWLEDGE_ASSIST
       * </pre>
       *
       * <code>
       * bool enable_query_suggestion_when_no_answer = 15 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enableQuerySuggestionWhenNoAnswer.
       */
      @java.lang.Override
      public boolean getEnableQuerySuggestionWhenNoAnswer() {
        return enableQuerySuggestionWhenNoAnswer_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Enable query suggestion even if we can't find its answer.
       * By default, queries are suggested only if we find its answer.
       * Supported features: KNOWLEDGE_ASSIST
       * </pre>
       *
       * <code>
       * bool enable_query_suggestion_when_no_answer = 15 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enableQuerySuggestionWhenNoAnswer to set.
       * @return This builder for chaining.
       */
      public Builder setEnableQuerySuggestionWhenNoAnswer(boolean value) {

        enableQuerySuggestionWhenNoAnswer_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Enable query suggestion even if we can't find its answer.
       * By default, queries are suggested only if we find its answer.
       * Supported features: KNOWLEDGE_ASSIST
       * </pre>
       *
       * <code>
       * bool enable_query_suggestion_when_no_answer = 15 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableQuerySuggestionWhenNoAnswer() {
        bitField0_ = (bitField0_ & ~0x00000008);
        enableQuerySuggestionWhenNoAnswer_ = false;
        onChanged();
        return this;
      }

      private boolean enableConversationAugmentedQuery_;
      /**
       *
       *
       * <pre>
       * Optional. Enable including conversation context during query answer
       * generation. Supported features: KNOWLEDGE_SEARCH.
       * </pre>
       *
       * <code>
       * bool enable_conversation_augmented_query = 16 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enableConversationAugmentedQuery.
       */
      @java.lang.Override
      public boolean getEnableConversationAugmentedQuery() {
        return enableConversationAugmentedQuery_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Enable including conversation context during query answer
       * generation. Supported features: KNOWLEDGE_SEARCH.
       * </pre>
       *
       * <code>
       * bool enable_conversation_augmented_query = 16 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enableConversationAugmentedQuery to set.
       * @return This builder for chaining.
       */
      public Builder setEnableConversationAugmentedQuery(boolean value) {

        enableConversationAugmentedQuery_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Enable including conversation context during query answer
       * generation. Supported features: KNOWLEDGE_SEARCH.
       * </pre>
       *
       * <code>
       * bool enable_conversation_augmented_query = 16 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableConversationAugmentedQuery() {
        bitField0_ = (bitField0_ & ~0x00000010);
        enableConversationAugmentedQuery_ = false;
        onChanged();
        return this;
      }

      private boolean enableQuerySuggestionOnly_;
      /**
       *
       *
       * <pre>
       * Optional. Enable query suggestion only.
       * Supported features: KNOWLEDGE_ASSIST
       * </pre>
       *
       * <code>bool enable_query_suggestion_only = 17 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enableQuerySuggestionOnly.
       */
      @java.lang.Override
      public boolean getEnableQuerySuggestionOnly() {
        return enableQuerySuggestionOnly_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Enable query suggestion only.
       * Supported features: KNOWLEDGE_ASSIST
       * </pre>
       *
       * <code>bool enable_query_suggestion_only = 17 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enableQuerySuggestionOnly to set.
       * @return This builder for chaining.
       */
      public Builder setEnableQuerySuggestionOnly(boolean value) {

        enableQuerySuggestionOnly_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Enable query suggestion only.
       * Supported features: KNOWLEDGE_ASSIST
       * </pre>
       *
       * <code>bool enable_query_suggestion_only = 17 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableQuerySuggestionOnly() {
        bitField0_ = (bitField0_ & ~0x00000020);
        enableQuerySuggestionOnly_ = false;
        onChanged();
        return this;
      }

      private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionTriggerSettings
          suggestionTriggerSettings_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionTriggerSettings,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionTriggerSettings.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionTriggerSettingsOrBuilder>
          suggestionTriggerSettingsBuilder_;
      /**
       *
       *
       * <pre>
       * Settings of suggestion trigger.
       *
       * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
       * this field.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
       * </code>
       *
       * @return Whether the suggestionTriggerSettings field is set.
       */
      public boolean hasSuggestionTriggerSettings() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * Settings of suggestion trigger.
       *
       * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
       * this field.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
       * </code>
       *
       * @return The suggestionTriggerSettings.
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
          getSuggestionTriggerSettings() {
        if (suggestionTriggerSettingsBuilder_ == null) {
          return suggestionTriggerSettings_ == null
              ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionTriggerSettings.getDefaultInstance()
              : suggestionTriggerSettings_;
        } else {
          return suggestionTriggerSettingsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Settings of suggestion trigger.
       *
       * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
       * this field.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
       * </code>
       */
      public Builder setSuggestionTriggerSettings(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
              value) {
        if (suggestionTriggerSettingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          suggestionTriggerSettings_ = value;
        } else {
          suggestionTriggerSettingsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Settings of suggestion trigger.
       *
       * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
       * this field.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
       * </code>
       */
      public Builder setSuggestionTriggerSettings(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
                  .Builder
              builderForValue) {
        if (suggestionTriggerSettingsBuilder_ == null) {
          suggestionTriggerSettings_ = builderForValue.build();
        } else {
          suggestionTriggerSettingsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Settings of suggestion trigger.
       *
       * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
       * this field.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
       * </code>
       */
      public Builder mergeSuggestionTriggerSettings(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
              value) {
        if (suggestionTriggerSettingsBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && suggestionTriggerSettings_ != null
              && suggestionTriggerSettings_
                  != com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionTriggerSettings.getDefaultInstance()) {
            getSuggestionTriggerSettingsBuilder().mergeFrom(value);
          } else {
            suggestionTriggerSettings_ = value;
          }
        } else {
          suggestionTriggerSettingsBuilder_.mergeFrom(value);
        }
        if (suggestionTriggerSettings_ != null) {
          bitField0_ |= 0x00000040;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Settings of suggestion trigger.
       *
       * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
       * this field.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
       * </code>
       */
      public Builder clearSuggestionTriggerSettings() {
        bitField0_ = (bitField0_ & ~0x00000040);
        suggestionTriggerSettings_ = null;
        if (suggestionTriggerSettingsBuilder_ != null) {
          suggestionTriggerSettingsBuilder_.dispose();
          suggestionTriggerSettingsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Settings of suggestion trigger.
       *
       * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
       * this field.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings
              .Builder
          getSuggestionTriggerSettingsBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getSuggestionTriggerSettingsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Settings of suggestion trigger.
       *
       * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
       * this field.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionTriggerSettingsOrBuilder
          getSuggestionTriggerSettingsOrBuilder() {
        if (suggestionTriggerSettingsBuilder_ != null) {
          return suggestionTriggerSettingsBuilder_.getMessageOrBuilder();
        } else {
          return suggestionTriggerSettings_ == null
              ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionTriggerSettings.getDefaultInstance()
              : suggestionTriggerSettings_;
        }
      }
      /**
       *
       *
       * <pre>
       * Settings of suggestion trigger.
       *
       * Currently, only ARTICLE_SUGGESTION, FAQ, and DIALOGFLOW_ASSIST will use
       * this field.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionTriggerSettings suggestion_trigger_settings = 10;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionTriggerSettings,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionTriggerSettings.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionTriggerSettingsOrBuilder>
          getSuggestionTriggerSettingsFieldBuilder() {
        if (suggestionTriggerSettingsBuilder_ == null) {
          suggestionTriggerSettingsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionTriggerSettings,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionTriggerSettings.Builder,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionTriggerSettingsOrBuilder>(
                  getSuggestionTriggerSettings(), getParentForChildren(), isClean());
          suggestionTriggerSettings_ = null;
        }
        return suggestionTriggerSettingsBuilder_;
      }

      private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
          queryConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionQueryConfigOrBuilder>
          queryConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Configs of query.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
       * </code>
       *
       * @return Whether the queryConfig field is set.
       */
      public boolean hasQueryConfig() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * Configs of query.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
       * </code>
       *
       * @return The queryConfig.
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
          getQueryConfig() {
        if (queryConfigBuilder_ == null) {
          return queryConfig_ == null
              ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .getDefaultInstance()
              : queryConfig_;
        } else {
          return queryConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Configs of query.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
       * </code>
       */
      public Builder setQueryConfig(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              value) {
        if (queryConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          queryConfig_ = value;
        } else {
          queryConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configs of query.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
       * </code>
       */
      public Builder setQueryConfig(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Builder
              builderForValue) {
        if (queryConfigBuilder_ == null) {
          queryConfig_ = builderForValue.build();
        } else {
          queryConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configs of query.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
       * </code>
       */
      public Builder mergeQueryConfig(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              value) {
        if (queryConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0)
              && queryConfig_ != null
              && queryConfig_
                  != com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.getDefaultInstance()) {
            getQueryConfigBuilder().mergeFrom(value);
          } else {
            queryConfig_ = value;
          }
        } else {
          queryConfigBuilder_.mergeFrom(value);
        }
        if (queryConfig_ != null) {
          bitField0_ |= 0x00000080;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configs of query.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
       * </code>
       */
      public Builder clearQueryConfig() {
        bitField0_ = (bitField0_ & ~0x00000080);
        queryConfig_ = null;
        if (queryConfigBuilder_ != null) {
          queryConfigBuilder_.dispose();
          queryConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configs of query.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .Builder
          getQueryConfigBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getQueryConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Configs of query.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfigOrBuilder
          getQueryConfigOrBuilder() {
        if (queryConfigBuilder_ != null) {
          return queryConfigBuilder_.getMessageOrBuilder();
        } else {
          return queryConfig_ == null
              ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .getDefaultInstance()
              : queryConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Configs of query.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig query_config = 6;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionQueryConfigOrBuilder>
          getQueryConfigFieldBuilder() {
        if (queryConfigBuilder_ == null) {
          queryConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.Builder,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfigOrBuilder>(
                  getQueryConfig(), getParentForChildren(), isClean());
          queryConfig_ = null;
        }
        return queryConfigBuilder_;
      }

      private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
          conversationModelConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
                  .Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationModelConfigOrBuilder>
          conversationModelConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Configs of custom conversation model.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
       * </code>
       *
       * @return Whether the conversationModelConfig field is set.
       */
      public boolean hasConversationModelConfig() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       *
       *
       * <pre>
       * Configs of custom conversation model.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
       * </code>
       *
       * @return The conversationModelConfig.
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
          getConversationModelConfig() {
        if (conversationModelConfigBuilder_ == null) {
          return conversationModelConfig_ == null
              ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationModelConfig.getDefaultInstance()
              : conversationModelConfig_;
        } else {
          return conversationModelConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Configs of custom conversation model.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
       * </code>
       */
      public Builder setConversationModelConfig(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
              value) {
        if (conversationModelConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          conversationModelConfig_ = value;
        } else {
          conversationModelConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configs of custom conversation model.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
       * </code>
       */
      public Builder setConversationModelConfig(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
                  .Builder
              builderForValue) {
        if (conversationModelConfigBuilder_ == null) {
          conversationModelConfig_ = builderForValue.build();
        } else {
          conversationModelConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configs of custom conversation model.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
       * </code>
       */
      public Builder mergeConversationModelConfig(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
              value) {
        if (conversationModelConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0)
              && conversationModelConfig_ != null
              && conversationModelConfig_
                  != com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .ConversationModelConfig.getDefaultInstance()) {
            getConversationModelConfigBuilder().mergeFrom(value);
          } else {
            conversationModelConfig_ = value;
          }
        } else {
          conversationModelConfigBuilder_.mergeFrom(value);
        }
        if (conversationModelConfig_ != null) {
          bitField0_ |= 0x00000100;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configs of custom conversation model.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
       * </code>
       */
      public Builder clearConversationModelConfig() {
        bitField0_ = (bitField0_ & ~0x00000100);
        conversationModelConfig_ = null;
        if (conversationModelConfigBuilder_ != null) {
          conversationModelConfigBuilder_.dispose();
          conversationModelConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configs of custom conversation model.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
              .Builder
          getConversationModelConfigBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getConversationModelConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Configs of custom conversation model.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .ConversationModelConfigOrBuilder
          getConversationModelConfigOrBuilder() {
        if (conversationModelConfigBuilder_ != null) {
          return conversationModelConfigBuilder_.getMessageOrBuilder();
        } else {
          return conversationModelConfig_ == null
              ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationModelConfig.getDefaultInstance()
              : conversationModelConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Configs of custom conversation model.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig conversation_model_config = 7;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
                  .Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationModelConfigOrBuilder>
          getConversationModelConfigFieldBuilder() {
        if (conversationModelConfigBuilder_ == null) {
          conversationModelConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .ConversationModelConfig,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .ConversationModelConfig.Builder,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .ConversationModelConfigOrBuilder>(
                  getConversationModelConfig(), getParentForChildren(), isClean());
          conversationModelConfig_ = null;
        }
        return conversationModelConfigBuilder_;
      }

      private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .ConversationProcessConfig
          conversationProcessConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationProcessConfig,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationProcessConfig.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationProcessConfigOrBuilder>
          conversationProcessConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Configs for processing conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
       * </code>
       *
       * @return Whether the conversationProcessConfig field is set.
       */
      public boolean hasConversationProcessConfig() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       *
       *
       * <pre>
       * Configs for processing conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
       * </code>
       *
       * @return The conversationProcessConfig.
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
          getConversationProcessConfig() {
        if (conversationProcessConfigBuilder_ == null) {
          return conversationProcessConfig_ == null
              ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationProcessConfig.getDefaultInstance()
              : conversationProcessConfig_;
        } else {
          return conversationProcessConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Configs for processing conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
       * </code>
       */
      public Builder setConversationProcessConfig(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
              value) {
        if (conversationProcessConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          conversationProcessConfig_ = value;
        } else {
          conversationProcessConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configs for processing conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
       * </code>
       */
      public Builder setConversationProcessConfig(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
                  .Builder
              builderForValue) {
        if (conversationProcessConfigBuilder_ == null) {
          conversationProcessConfig_ = builderForValue.build();
        } else {
          conversationProcessConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configs for processing conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
       * </code>
       */
      public Builder mergeConversationProcessConfig(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
              value) {
        if (conversationProcessConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000200) != 0)
              && conversationProcessConfig_ != null
              && conversationProcessConfig_
                  != com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .ConversationProcessConfig.getDefaultInstance()) {
            getConversationProcessConfigBuilder().mergeFrom(value);
          } else {
            conversationProcessConfig_ = value;
          }
        } else {
          conversationProcessConfigBuilder_.mergeFrom(value);
        }
        if (conversationProcessConfig_ != null) {
          bitField0_ |= 0x00000200;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configs for processing conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
       * </code>
       */
      public Builder clearConversationProcessConfig() {
        bitField0_ = (bitField0_ & ~0x00000200);
        conversationProcessConfig_ = null;
        if (conversationProcessConfigBuilder_ != null) {
          conversationProcessConfigBuilder_.dispose();
          conversationProcessConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configs for processing conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
              .Builder
          getConversationProcessConfigBuilder() {
        bitField0_ |= 0x00000200;
        onChanged();
        return getConversationProcessConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Configs for processing conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .ConversationProcessConfigOrBuilder
          getConversationProcessConfigOrBuilder() {
        if (conversationProcessConfigBuilder_ != null) {
          return conversationProcessConfigBuilder_.getMessageOrBuilder();
        } else {
          return conversationProcessConfig_ == null
              ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationProcessConfig.getDefaultInstance()
              : conversationProcessConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Configs for processing conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig conversation_process_config = 8;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationProcessConfig,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationProcessConfig.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationProcessConfigOrBuilder>
          getConversationProcessConfigFieldBuilder() {
        if (conversationProcessConfigBuilder_ == null) {
          conversationProcessConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .ConversationProcessConfig,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .ConversationProcessConfig.Builder,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .ConversationProcessConfigOrBuilder>(
                  getConversationProcessConfig(), getParentForChildren(), isClean());
          conversationProcessConfig_ = null;
        }
        return conversationProcessConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig)
    private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionFeatureConfig();
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SuggestionFeatureConfig> PARSER =
        new com.google.protobuf.AbstractParser<SuggestionFeatureConfig>() {
          @java.lang.Override
          public SuggestionFeatureConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SuggestionFeatureConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SuggestionFeatureConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SuggestionConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Configuration of different suggestion features. One feature can have only
     * one config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
     * </code>
     */
    java.util.List<
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig>
        getFeatureConfigsList();
    /**
     *
     *
     * <pre>
     * Configuration of different suggestion features. One feature can have only
     * one config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
        getFeatureConfigs(int index);
    /**
     *
     *
     * <pre>
     * Configuration of different suggestion features. One feature can have only
     * one config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
     * </code>
     */
    int getFeatureConfigsCount();
    /**
     *
     *
     * <pre>
     * Configuration of different suggestion features. One feature can have only
     * one config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionFeatureConfigOrBuilder>
        getFeatureConfigsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Configuration of different suggestion features. One feature can have only
     * one config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfigOrBuilder
        getFeatureConfigsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * If `group_suggestion_responses` is false, and there are multiple
     * `feature_configs` in `event based suggestion` or
     * StreamingAnalyzeContent, we will try to deliver suggestions to customers
     * as soon as we get new suggestion. Different type of suggestions based on
     * the same context will be in  separate Pub/Sub event or
     * `StreamingAnalyzeContentResponse`.
     *
     * If `group_suggestion_responses` set to true. All the suggestions to the
     * same participant based on the same context will be grouped into a single
     * Pub/Sub event or StreamingAnalyzeContentResponse.
     * </pre>
     *
     * <code>bool group_suggestion_responses = 3;</code>
     *
     * @return The groupSuggestionResponses.
     */
    boolean getGroupSuggestionResponses();

    /**
     *
     *
     * <pre>
     * Optional. List of various generator resource names used in the
     * conversation profile.
     * </pre>
     *
     * <code>
     * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the generators.
     */
    java.util.List<java.lang.String> getGeneratorsList();
    /**
     *
     *
     * <pre>
     * Optional. List of various generator resource names used in the
     * conversation profile.
     * </pre>
     *
     * <code>
     * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of generators.
     */
    int getGeneratorsCount();
    /**
     *
     *
     * <pre>
     * Optional. List of various generator resource names used in the
     * conversation profile.
     * </pre>
     *
     * <code>
     * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The generators at the given index.
     */
    java.lang.String getGenerators(int index);
    /**
     *
     *
     * <pre>
     * Optional. List of various generator resource names used in the
     * conversation profile.
     * </pre>
     *
     * <code>
     * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the generators at the given index.
     */
    com.google.protobuf.ByteString getGeneratorsBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. When disable_high_latency_features_sync_delivery is true and
     * using the AnalyzeContent API, we will not deliver the responses from high
     * latency features in the API response. The
     * human_agent_assistant_config.notification_config must be configured and
     * enable_event_based_suggestion must be set to true to receive the
     * responses from high latency features in Pub/Sub. High latency feature(s):
     * KNOWLEDGE_ASSIST
     * </pre>
     *
     * <code>
     * bool disable_high_latency_features_sync_delivery = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The disableHighLatencyFeaturesSyncDelivery.
     */
    boolean getDisableHighLatencyFeaturesSyncDelivery();
  }
  /**
   *
   *
   * <pre>
   * Detail human agent assistant config.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig}
   */
  public static final class SuggestionConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig)
      SuggestionConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SuggestionConfig.newBuilder() to construct.
    private SuggestionConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SuggestionConfig() {
      featureConfigs_ = java.util.Collections.emptyList();
      generators_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SuggestionConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.class,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.Builder
                  .class);
    }

    public static final int FEATURE_CONFIGS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig>
        featureConfigs_;
    /**
     *
     *
     * <pre>
     * Configuration of different suggestion features. One feature can have only
     * one config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig>
        getFeatureConfigsList() {
      return featureConfigs_;
    }
    /**
     *
     *
     * <pre>
     * Configuration of different suggestion features. One feature can have only
     * one config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionFeatureConfigOrBuilder>
        getFeatureConfigsOrBuilderList() {
      return featureConfigs_;
    }
    /**
     *
     *
     * <pre>
     * Configuration of different suggestion features. One feature can have only
     * one config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
     * </code>
     */
    @java.lang.Override
    public int getFeatureConfigsCount() {
      return featureConfigs_.size();
    }
    /**
     *
     *
     * <pre>
     * Configuration of different suggestion features. One feature can have only
     * one config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
        getFeatureConfigs(int index) {
      return featureConfigs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Configuration of different suggestion features. One feature can have only
     * one config.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionFeatureConfigOrBuilder
        getFeatureConfigsOrBuilder(int index) {
      return featureConfigs_.get(index);
    }

    public static final int GROUP_SUGGESTION_RESPONSES_FIELD_NUMBER = 3;
    private boolean groupSuggestionResponses_ = false;
    /**
     *
     *
     * <pre>
     * If `group_suggestion_responses` is false, and there are multiple
     * `feature_configs` in `event based suggestion` or
     * StreamingAnalyzeContent, we will try to deliver suggestions to customers
     * as soon as we get new suggestion. Different type of suggestions based on
     * the same context will be in  separate Pub/Sub event or
     * `StreamingAnalyzeContentResponse`.
     *
     * If `group_suggestion_responses` set to true. All the suggestions to the
     * same participant based on the same context will be grouped into a single
     * Pub/Sub event or StreamingAnalyzeContentResponse.
     * </pre>
     *
     * <code>bool group_suggestion_responses = 3;</code>
     *
     * @return The groupSuggestionResponses.
     */
    @java.lang.Override
    public boolean getGroupSuggestionResponses() {
      return groupSuggestionResponses_;
    }

    public static final int GENERATORS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList generators_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. List of various generator resource names used in the
     * conversation profile.
     * </pre>
     *
     * <code>
     * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return A list containing the generators.
     */
    public com.google.protobuf.ProtocolStringList getGeneratorsList() {
      return generators_;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of various generator resource names used in the
     * conversation profile.
     * </pre>
     *
     * <code>
     * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The count of generators.
     */
    public int getGeneratorsCount() {
      return generators_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. List of various generator resource names used in the
     * conversation profile.
     * </pre>
     *
     * <code>
     * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the element to return.
     * @return The generators at the given index.
     */
    public java.lang.String getGenerators(int index) {
      return generators_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of various generator resource names used in the
     * conversation profile.
     * </pre>
     *
     * <code>
     * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the generators at the given index.
     */
    public com.google.protobuf.ByteString getGeneratorsBytes(int index) {
      return generators_.getByteString(index);
    }

    public static final int DISABLE_HIGH_LATENCY_FEATURES_SYNC_DELIVERY_FIELD_NUMBER = 5;
    private boolean disableHighLatencyFeaturesSyncDelivery_ = false;
    /**
     *
     *
     * <pre>
     * Optional. When disable_high_latency_features_sync_delivery is true and
     * using the AnalyzeContent API, we will not deliver the responses from high
     * latency features in the API response. The
     * human_agent_assistant_config.notification_config must be configured and
     * enable_event_based_suggestion must be set to true to receive the
     * responses from high latency features in Pub/Sub. High latency feature(s):
     * KNOWLEDGE_ASSIST
     * </pre>
     *
     * <code>
     * bool disable_high_latency_features_sync_delivery = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The disableHighLatencyFeaturesSyncDelivery.
     */
    @java.lang.Override
    public boolean getDisableHighLatencyFeaturesSyncDelivery() {
      return disableHighLatencyFeaturesSyncDelivery_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < featureConfigs_.size(); i++) {
        output.writeMessage(2, featureConfigs_.get(i));
      }
      if (groupSuggestionResponses_ != false) {
        output.writeBool(3, groupSuggestionResponses_);
      }
      for (int i = 0; i < generators_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, generators_.getRaw(i));
      }
      if (disableHighLatencyFeaturesSyncDelivery_ != false) {
        output.writeBool(5, disableHighLatencyFeaturesSyncDelivery_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < featureConfigs_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, featureConfigs_.get(i));
      }
      if (groupSuggestionResponses_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, groupSuggestionResponses_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < generators_.size(); i++) {
          dataSize += computeStringSizeNoTag(generators_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getGeneratorsList().size();
      }
      if (disableHighLatencyFeaturesSyncDelivery_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                5, disableHighLatencyFeaturesSyncDelivery_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig other =
          (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig) obj;

      if (!getFeatureConfigsList().equals(other.getFeatureConfigsList())) return false;
      if (getGroupSuggestionResponses() != other.getGroupSuggestionResponses()) return false;
      if (!getGeneratorsList().equals(other.getGeneratorsList())) return false;
      if (getDisableHighLatencyFeaturesSyncDelivery()
          != other.getDisableHighLatencyFeaturesSyncDelivery()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFeatureConfigsCount() > 0) {
        hash = (37 * hash) + FEATURE_CONFIGS_FIELD_NUMBER;
        hash = (53 * hash) + getFeatureConfigsList().hashCode();
      }
      hash = (37 * hash) + GROUP_SUGGESTION_RESPONSES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getGroupSuggestionResponses());
      if (getGeneratorsCount() > 0) {
        hash = (37 * hash) + GENERATORS_FIELD_NUMBER;
        hash = (53 * hash) + getGeneratorsList().hashCode();
      }
      hash = (37 * hash) + DISABLE_HIGH_LATENCY_FEATURES_SYNC_DELIVERY_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(
                  getDisableHighLatencyFeaturesSyncDelivery());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Detail human agent assistant config.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig)
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
                    .class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (featureConfigsBuilder_ == null) {
          featureConfigs_ = java.util.Collections.emptyList();
        } else {
          featureConfigs_ = null;
          featureConfigsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        groupSuggestionResponses_ = false;
        generators_ = com.google.protobuf.LazyStringArrayList.emptyList();
        disableHighLatencyFeaturesSyncDelivery_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
          build() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
          buildPartial() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig result =
            new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig result) {
        if (featureConfigsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            featureConfigs_ = java.util.Collections.unmodifiableList(featureConfigs_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.featureConfigs_ = featureConfigs_;
        } else {
          result.featureConfigs_ = featureConfigsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.groupSuggestionResponses_ = groupSuggestionResponses_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          generators_.makeImmutable();
          result.generators_ = generators_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.disableHighLatencyFeaturesSyncDelivery_ = disableHighLatencyFeaturesSyncDelivery_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
                .getDefaultInstance()) return this;
        if (featureConfigsBuilder_ == null) {
          if (!other.featureConfigs_.isEmpty()) {
            if (featureConfigs_.isEmpty()) {
              featureConfigs_ = other.featureConfigs_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFeatureConfigsIsMutable();
              featureConfigs_.addAll(other.featureConfigs_);
            }
            onChanged();
          }
        } else {
          if (!other.featureConfigs_.isEmpty()) {
            if (featureConfigsBuilder_.isEmpty()) {
              featureConfigsBuilder_.dispose();
              featureConfigsBuilder_ = null;
              featureConfigs_ = other.featureConfigs_;
              bitField0_ = (bitField0_ & ~0x00000001);
              featureConfigsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFeatureConfigsFieldBuilder()
                      : null;
            } else {
              featureConfigsBuilder_.addAllMessages(other.featureConfigs_);
            }
          }
        }
        if (other.getGroupSuggestionResponses() != false) {
          setGroupSuggestionResponses(other.getGroupSuggestionResponses());
        }
        if (!other.generators_.isEmpty()) {
          if (generators_.isEmpty()) {
            generators_ = other.generators_;
            bitField0_ |= 0x00000004;
          } else {
            ensureGeneratorsIsMutable();
            generators_.addAll(other.generators_);
          }
          onChanged();
        }
        if (other.getDisableHighLatencyFeaturesSyncDelivery() != false) {
          setDisableHighLatencyFeaturesSyncDelivery(
              other.getDisableHighLatencyFeaturesSyncDelivery());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                          .SuggestionFeatureConfig
                      m =
                          input.readMessage(
                              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                                  .SuggestionFeatureConfig.parser(),
                              extensionRegistry);
                  if (featureConfigsBuilder_ == null) {
                    ensureFeatureConfigsIsMutable();
                    featureConfigs_.add(m);
                  } else {
                    featureConfigsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 24:
                {
                  groupSuggestionResponses_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 24
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureGeneratorsIsMutable();
                  generators_.add(s);
                  break;
                } // case 34
              case 40:
                {
                  disableHighLatencyFeaturesSyncDelivery_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig>
          featureConfigs_ = java.util.Collections.emptyList();

      private void ensureFeatureConfigsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          featureConfigs_ =
              new java.util.ArrayList<
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionFeatureConfig>(featureConfigs_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
                  .Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionFeatureConfigOrBuilder>
          featureConfigsBuilder_;

      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig>
          getFeatureConfigsList() {
        if (featureConfigsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(featureConfigs_);
        } else {
          return featureConfigsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public int getFeatureConfigsCount() {
        if (featureConfigsBuilder_ == null) {
          return featureConfigs_.size();
        } else {
          return featureConfigsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
          getFeatureConfigs(int index) {
        if (featureConfigsBuilder_ == null) {
          return featureConfigs_.get(index);
        } else {
          return featureConfigsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public Builder setFeatureConfigs(
          int index,
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
              value) {
        if (featureConfigsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeatureConfigsIsMutable();
          featureConfigs_.set(index, value);
          onChanged();
        } else {
          featureConfigsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public Builder setFeatureConfigs(
          int index,
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
                  .Builder
              builderForValue) {
        if (featureConfigsBuilder_ == null) {
          ensureFeatureConfigsIsMutable();
          featureConfigs_.set(index, builderForValue.build());
          onChanged();
        } else {
          featureConfigsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public Builder addFeatureConfigs(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
              value) {
        if (featureConfigsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeatureConfigsIsMutable();
          featureConfigs_.add(value);
          onChanged();
        } else {
          featureConfigsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public Builder addFeatureConfigs(
          int index,
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
              value) {
        if (featureConfigsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeatureConfigsIsMutable();
          featureConfigs_.add(index, value);
          onChanged();
        } else {
          featureConfigsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public Builder addFeatureConfigs(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
                  .Builder
              builderForValue) {
        if (featureConfigsBuilder_ == null) {
          ensureFeatureConfigsIsMutable();
          featureConfigs_.add(builderForValue.build());
          onChanged();
        } else {
          featureConfigsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public Builder addFeatureConfigs(
          int index,
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
                  .Builder
              builderForValue) {
        if (featureConfigsBuilder_ == null) {
          ensureFeatureConfigsIsMutable();
          featureConfigs_.add(index, builderForValue.build());
          onChanged();
        } else {
          featureConfigsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public Builder addAllFeatureConfigs(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                          .SuggestionFeatureConfig>
              values) {
        if (featureConfigsBuilder_ == null) {
          ensureFeatureConfigsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, featureConfigs_);
          onChanged();
        } else {
          featureConfigsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public Builder clearFeatureConfigs() {
        if (featureConfigsBuilder_ == null) {
          featureConfigs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          featureConfigsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public Builder removeFeatureConfigs(int index) {
        if (featureConfigsBuilder_ == null) {
          ensureFeatureConfigsIsMutable();
          featureConfigs_.remove(index);
          onChanged();
        } else {
          featureConfigsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
              .Builder
          getFeatureConfigsBuilder(int index) {
        return getFeatureConfigsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionFeatureConfigOrBuilder
          getFeatureConfigsOrBuilder(int index) {
        if (featureConfigsBuilder_ == null) {
          return featureConfigs_.get(index);
        } else {
          return featureConfigsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionFeatureConfigOrBuilder>
          getFeatureConfigsOrBuilderList() {
        if (featureConfigsBuilder_ != null) {
          return featureConfigsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(featureConfigs_);
        }
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
              .Builder
          addFeatureConfigsBuilder() {
        return getFeatureConfigsFieldBuilder()
            .addBuilder(
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionFeatureConfig.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
              .Builder
          addFeatureConfigsBuilder(int index) {
        return getFeatureConfigsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionFeatureConfig.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Configuration of different suggestion features. One feature can have only
       * one config.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig feature_configs = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
                  .Builder>
          getFeatureConfigsBuilderList() {
        return getFeatureConfigsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionFeatureConfig
                  .Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionFeatureConfigOrBuilder>
          getFeatureConfigsFieldBuilder() {
        if (featureConfigsBuilder_ == null) {
          featureConfigsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionFeatureConfig,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionFeatureConfig.Builder,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionFeatureConfigOrBuilder>(
                  featureConfigs_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          featureConfigs_ = null;
        }
        return featureConfigsBuilder_;
      }

      private boolean groupSuggestionResponses_;
      /**
       *
       *
       * <pre>
       * If `group_suggestion_responses` is false, and there are multiple
       * `feature_configs` in `event based suggestion` or
       * StreamingAnalyzeContent, we will try to deliver suggestions to customers
       * as soon as we get new suggestion. Different type of suggestions based on
       * the same context will be in  separate Pub/Sub event or
       * `StreamingAnalyzeContentResponse`.
       *
       * If `group_suggestion_responses` set to true. All the suggestions to the
       * same participant based on the same context will be grouped into a single
       * Pub/Sub event or StreamingAnalyzeContentResponse.
       * </pre>
       *
       * <code>bool group_suggestion_responses = 3;</code>
       *
       * @return The groupSuggestionResponses.
       */
      @java.lang.Override
      public boolean getGroupSuggestionResponses() {
        return groupSuggestionResponses_;
      }
      /**
       *
       *
       * <pre>
       * If `group_suggestion_responses` is false, and there are multiple
       * `feature_configs` in `event based suggestion` or
       * StreamingAnalyzeContent, we will try to deliver suggestions to customers
       * as soon as we get new suggestion. Different type of suggestions based on
       * the same context will be in  separate Pub/Sub event or
       * `StreamingAnalyzeContentResponse`.
       *
       * If `group_suggestion_responses` set to true. All the suggestions to the
       * same participant based on the same context will be grouped into a single
       * Pub/Sub event or StreamingAnalyzeContentResponse.
       * </pre>
       *
       * <code>bool group_suggestion_responses = 3;</code>
       *
       * @param value The groupSuggestionResponses to set.
       * @return This builder for chaining.
       */
      public Builder setGroupSuggestionResponses(boolean value) {

        groupSuggestionResponses_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If `group_suggestion_responses` is false, and there are multiple
       * `feature_configs` in `event based suggestion` or
       * StreamingAnalyzeContent, we will try to deliver suggestions to customers
       * as soon as we get new suggestion. Different type of suggestions based on
       * the same context will be in  separate Pub/Sub event or
       * `StreamingAnalyzeContentResponse`.
       *
       * If `group_suggestion_responses` set to true. All the suggestions to the
       * same participant based on the same context will be grouped into a single
       * Pub/Sub event or StreamingAnalyzeContentResponse.
       * </pre>
       *
       * <code>bool group_suggestion_responses = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGroupSuggestionResponses() {
        bitField0_ = (bitField0_ & ~0x00000002);
        groupSuggestionResponses_ = false;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList generators_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureGeneratorsIsMutable() {
        if (!generators_.isModifiable()) {
          generators_ = new com.google.protobuf.LazyStringArrayList(generators_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of various generator resource names used in the
       * conversation profile.
       * </pre>
       *
       * <code>
       * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return A list containing the generators.
       */
      public com.google.protobuf.ProtocolStringList getGeneratorsList() {
        generators_.makeImmutable();
        return generators_;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of various generator resource names used in the
       * conversation profile.
       * </pre>
       *
       * <code>
       * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The count of generators.
       */
      public int getGeneratorsCount() {
        return generators_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. List of various generator resource names used in the
       * conversation profile.
       * </pre>
       *
       * <code>
       * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the element to return.
       * @return The generators at the given index.
       */
      public java.lang.String getGenerators(int index) {
        return generators_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of various generator resource names used in the
       * conversation profile.
       * </pre>
       *
       * <code>
       * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the generators at the given index.
       */
      public com.google.protobuf.ByteString getGeneratorsBytes(int index) {
        return generators_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. List of various generator resource names used in the
       * conversation profile.
       * </pre>
       *
       * <code>
       * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The generators to set.
       * @return This builder for chaining.
       */
      public Builder setGenerators(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGeneratorsIsMutable();
        generators_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of various generator resource names used in the
       * conversation profile.
       * </pre>
       *
       * <code>
       * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The generators to add.
       * @return This builder for chaining.
       */
      public Builder addGenerators(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGeneratorsIsMutable();
        generators_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of various generator resource names used in the
       * conversation profile.
       * </pre>
       *
       * <code>
       * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param values The generators to add.
       * @return This builder for chaining.
       */
      public Builder addAllGenerators(java.lang.Iterable<java.lang.String> values) {
        ensureGeneratorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, generators_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of various generator resource names used in the
       * conversation profile.
       * </pre>
       *
       * <code>
       * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGenerators() {
        generators_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. List of various generator resource names used in the
       * conversation profile.
       * </pre>
       *
       * <code>
       * repeated string generators = 4 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes of the generators to add.
       * @return This builder for chaining.
       */
      public Builder addGeneratorsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureGeneratorsIsMutable();
        generators_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private boolean disableHighLatencyFeaturesSyncDelivery_;
      /**
       *
       *
       * <pre>
       * Optional. When disable_high_latency_features_sync_delivery is true and
       * using the AnalyzeContent API, we will not deliver the responses from high
       * latency features in the API response. The
       * human_agent_assistant_config.notification_config must be configured and
       * enable_event_based_suggestion must be set to true to receive the
       * responses from high latency features in Pub/Sub. High latency feature(s):
       * KNOWLEDGE_ASSIST
       * </pre>
       *
       * <code>
       * bool disable_high_latency_features_sync_delivery = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The disableHighLatencyFeaturesSyncDelivery.
       */
      @java.lang.Override
      public boolean getDisableHighLatencyFeaturesSyncDelivery() {
        return disableHighLatencyFeaturesSyncDelivery_;
      }
      /**
       *
       *
       * <pre>
       * Optional. When disable_high_latency_features_sync_delivery is true and
       * using the AnalyzeContent API, we will not deliver the responses from high
       * latency features in the API response. The
       * human_agent_assistant_config.notification_config must be configured and
       * enable_event_based_suggestion must be set to true to receive the
       * responses from high latency features in Pub/Sub. High latency feature(s):
       * KNOWLEDGE_ASSIST
       * </pre>
       *
       * <code>
       * bool disable_high_latency_features_sync_delivery = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The disableHighLatencyFeaturesSyncDelivery to set.
       * @return This builder for chaining.
       */
      public Builder setDisableHighLatencyFeaturesSyncDelivery(boolean value) {

        disableHighLatencyFeaturesSyncDelivery_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. When disable_high_latency_features_sync_delivery is true and
       * using the AnalyzeContent API, we will not deliver the responses from high
       * latency features in the API response. The
       * human_agent_assistant_config.notification_config must be configured and
       * enable_event_based_suggestion must be set to true to receive the
       * responses from high latency features in Pub/Sub. High latency feature(s):
       * KNOWLEDGE_ASSIST
       * </pre>
       *
       * <code>
       * bool disable_high_latency_features_sync_delivery = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisableHighLatencyFeaturesSyncDelivery() {
        bitField0_ = (bitField0_ & ~0x00000008);
        disableHighLatencyFeaturesSyncDelivery_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig)
    private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig();
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SuggestionConfig> PARSER =
        new com.google.protobuf.AbstractParser<SuggestionConfig>() {
          @java.lang.Override
          public SuggestionConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SuggestionConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SuggestionConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SuggestionQueryConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Query from knowledgebase. It is used by:
     * ARTICLE_SUGGESTION, FAQ.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
     * </code>
     *
     * @return Whether the knowledgeBaseQuerySource field is set.
     */
    boolean hasKnowledgeBaseQuerySource();
    /**
     *
     *
     * <pre>
     * Query from knowledgebase. It is used by:
     * ARTICLE_SUGGESTION, FAQ.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
     * </code>
     *
     * @return The knowledgeBaseQuerySource.
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .KnowledgeBaseQuerySource
        getKnowledgeBaseQuerySource();
    /**
     *
     *
     * <pre>
     * Query from knowledgebase. It is used by:
     * ARTICLE_SUGGESTION, FAQ.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .KnowledgeBaseQuerySourceOrBuilder
        getKnowledgeBaseQuerySourceOrBuilder();

    /**
     *
     *
     * <pre>
     * Query from knowledge base document. It is used by:
     * SMART_REPLY, SMART_COMPOSE.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
     * </code>
     *
     * @return Whether the documentQuerySource field is set.
     */
    boolean hasDocumentQuerySource();
    /**
     *
     *
     * <pre>
     * Query from knowledge base document. It is used by:
     * SMART_REPLY, SMART_COMPOSE.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
     * </code>
     *
     * @return The documentQuerySource.
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .DocumentQuerySource
        getDocumentQuerySource();
    /**
     *
     *
     * <pre>
     * Query from knowledge base document. It is used by:
     * SMART_REPLY, SMART_COMPOSE.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .DocumentQuerySourceOrBuilder
        getDocumentQuerySourceOrBuilder();

    /**
     *
     *
     * <pre>
     * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
     * ENTITY_EXTRACTION.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
     * </code>
     *
     * @return Whether the dialogflowQuerySource field is set.
     */
    boolean hasDialogflowQuerySource();
    /**
     *
     *
     * <pre>
     * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
     * ENTITY_EXTRACTION.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
     * </code>
     *
     * @return The dialogflowQuerySource.
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .DialogflowQuerySource
        getDialogflowQuerySource();
    /**
     *
     *
     * <pre>
     * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
     * ENTITY_EXTRACTION.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .DialogflowQuerySourceOrBuilder
        getDialogflowQuerySourceOrBuilder();

    /**
     *
     *
     * <pre>
     * Maximum number of results to return. Currently, if unset, defaults to 10.
     * And the max number is 20.
     * </pre>
     *
     * <code>int32 max_results = 4;</code>
     *
     * @return The maxResults.
     */
    int getMaxResults();

    /**
     *
     *
     * <pre>
     * Confidence threshold of query result.
     *
     * Agent Assist gives each suggestion a score in the range [0.0, 1.0], based
     * on the relevance between the suggestion and the current conversation
     * context. A score of 0.0 has no relevance, while a score of 1.0 has high
     * relevance. Only suggestions with a score greater than or equal to the
     * value of this field are included in the results.
     *
     * For a baseline model (the default), the recommended value is in the range
     * [0.05, 0.1].
     *
     * For a custom model, there is no recommended value. Tune this value by
     * starting from a very low value and slowly increasing until you have
     * desired results.
     *
     * If this field is not set, it is default to 0.0, which means that all
     * suggestions are returned.
     *
     * Supported features: ARTICLE_SUGGESTION, FAQ, SMART_REPLY, SMART_COMPOSE,
     * KNOWLEDGE_SEARCH, KNOWLEDGE_ASSIST, ENTITY_EXTRACTION.
     * </pre>
     *
     * <code>float confidence_threshold = 5;</code>
     *
     * @return The confidenceThreshold.
     */
    float getConfidenceThreshold();

    /**
     *
     *
     * <pre>
     * Determines how recent conversation context is filtered when generating
     * suggestions. If unspecified, no messages will be dropped.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
     * </code>
     *
     * @return Whether the contextFilterSettings field is set.
     */
    boolean hasContextFilterSettings();
    /**
     *
     *
     * <pre>
     * Determines how recent conversation context is filtered when generating
     * suggestions. If unspecified, no messages will be dropped.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
     * </code>
     *
     * @return The contextFilterSettings.
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .ContextFilterSettings
        getContextFilterSettings();
    /**
     *
     *
     * <pre>
     * Determines how recent conversation context is filtered when generating
     * suggestions. If unspecified, no messages will be dropped.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .ContextFilterSettingsOrBuilder
        getContextFilterSettingsOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. The customized sections chosen to return when requesting a
     * summary of a conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sections field is set.
     */
    boolean hasSections();
    /**
     *
     *
     * <pre>
     * Optional. The customized sections chosen to return when requesting a
     * summary of a conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sections.
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections
        getSections();
    /**
     *
     *
     * <pre>
     * Optional. The customized sections chosen to return when requesting a
     * summary of a conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .SectionsOrBuilder
        getSectionsOrBuilder();

    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .QuerySourceCase
        getQuerySourceCase();
  }
  /**
   *
   *
   * <pre>
   * Config for suggestion query.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig}
   */
  public static final class SuggestionQueryConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig)
      SuggestionQueryConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SuggestionQueryConfig.newBuilder() to construct.
    private SuggestionQueryConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SuggestionQueryConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SuggestionQueryConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .class,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Builder.class);
    }

    public interface KnowledgeBaseQuerySourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Knowledge bases to query. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
       * base is supported.
       * </pre>
       *
       * <code>
       * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return A list containing the knowledgeBases.
       */
      java.util.List<java.lang.String> getKnowledgeBasesList();
      /**
       *
       *
       * <pre>
       * Required. Knowledge bases to query. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
       * base is supported.
       * </pre>
       *
       * <code>
       * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The count of knowledgeBases.
       */
      int getKnowledgeBasesCount();
      /**
       *
       *
       * <pre>
       * Required. Knowledge bases to query. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
       * base is supported.
       * </pre>
       *
       * <code>
       * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the element to return.
       * @return The knowledgeBases at the given index.
       */
      java.lang.String getKnowledgeBases(int index);
      /**
       *
       *
       * <pre>
       * Required. Knowledge bases to query. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
       * base is supported.
       * </pre>
       *
       * <code>
       * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the knowledgeBases at the given index.
       */
      com.google.protobuf.ByteString getKnowledgeBasesBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * Knowledge base source settings.
     *
     * Supported features: ARTICLE_SUGGESTION, FAQ.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource}
     */
    public static final class KnowledgeBaseQuerySource
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource)
        KnowledgeBaseQuerySourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use KnowledgeBaseQuerySource.newBuilder() to construct.
      private KnowledgeBaseQuerySource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private KnowledgeBaseQuerySource() {
        knowledgeBases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new KnowledgeBaseQuerySource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .KnowledgeBaseQuerySource.class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .KnowledgeBaseQuerySource.Builder.class);
      }

      public static final int KNOWLEDGE_BASES_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList knowledgeBases_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Required. Knowledge bases to query. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
       * base is supported.
       * </pre>
       *
       * <code>
       * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return A list containing the knowledgeBases.
       */
      public com.google.protobuf.ProtocolStringList getKnowledgeBasesList() {
        return knowledgeBases_;
      }
      /**
       *
       *
       * <pre>
       * Required. Knowledge bases to query. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
       * base is supported.
       * </pre>
       *
       * <code>
       * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The count of knowledgeBases.
       */
      public int getKnowledgeBasesCount() {
        return knowledgeBases_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. Knowledge bases to query. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
       * base is supported.
       * </pre>
       *
       * <code>
       * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the element to return.
       * @return The knowledgeBases at the given index.
       */
      public java.lang.String getKnowledgeBases(int index) {
        return knowledgeBases_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. Knowledge bases to query. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
       * base is supported.
       * </pre>
       *
       * <code>
       * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the knowledgeBases at the given index.
       */
      public com.google.protobuf.ByteString getKnowledgeBasesBytes(int index) {
        return knowledgeBases_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < knowledgeBases_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, knowledgeBases_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < knowledgeBases_.size(); i++) {
            dataSize += computeStringSizeNoTag(knowledgeBases_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getKnowledgeBasesList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .KnowledgeBaseQuerySource)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .KnowledgeBaseQuerySource
            other =
                (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                        .KnowledgeBaseQuerySource)
                    obj;

        if (!getKnowledgeBasesList().equals(other.getKnowledgeBasesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getKnowledgeBasesCount() > 0) {
          hash = (37 * hash) + KNOWLEDGE_BASES_FIELD_NUMBER;
          hash = (53 * hash) + getKnowledgeBasesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySource
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Knowledge base source settings.
       *
       * Supported features: ARTICLE_SUGGESTION, FAQ.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource)
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .KnowledgeBaseQuerySourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.KnowledgeBaseQuerySource.class,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.KnowledgeBaseQuerySource.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          knowledgeBases_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_KnowledgeBaseQuerySource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .KnowledgeBaseQuerySource
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .KnowledgeBaseQuerySource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .KnowledgeBaseQuerySource
            build() {
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySource
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .KnowledgeBaseQuerySource
            buildPartial() {
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySource
              result =
                  new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.KnowledgeBaseQuerySource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .KnowledgeBaseQuerySource
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            knowledgeBases_.makeImmutable();
            result.knowledgeBases_ = knowledgeBases_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySource) {
            return mergeFrom(
                (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                        .KnowledgeBaseQuerySource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .KnowledgeBaseQuerySource
                other) {
          if (other
              == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySource.getDefaultInstance()) return this;
          if (!other.knowledgeBases_.isEmpty()) {
            if (knowledgeBases_.isEmpty()) {
              knowledgeBases_ = other.knowledgeBases_;
              bitField0_ |= 0x00000001;
            } else {
              ensureKnowledgeBasesIsMutable();
              knowledgeBases_.addAll(other.knowledgeBases_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureKnowledgeBasesIsMutable();
                    knowledgeBases_.add(s);
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList knowledgeBases_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureKnowledgeBasesIsMutable() {
          if (!knowledgeBases_.isModifiable()) {
            knowledgeBases_ = new com.google.protobuf.LazyStringArrayList(knowledgeBases_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge bases to query. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
         * base is supported.
         * </pre>
         *
         * <code>
         * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return A list containing the knowledgeBases.
         */
        public com.google.protobuf.ProtocolStringList getKnowledgeBasesList() {
          knowledgeBases_.makeImmutable();
          return knowledgeBases_;
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge bases to query. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
         * base is supported.
         * </pre>
         *
         * <code>
         * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The count of knowledgeBases.
         */
        public int getKnowledgeBasesCount() {
          return knowledgeBases_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge bases to query. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
         * base is supported.
         * </pre>
         *
         * <code>
         * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param index The index of the element to return.
         * @return The knowledgeBases at the given index.
         */
        public java.lang.String getKnowledgeBases(int index) {
          return knowledgeBases_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge bases to query. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
         * base is supported.
         * </pre>
         *
         * <code>
         * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the knowledgeBases at the given index.
         */
        public com.google.protobuf.ByteString getKnowledgeBasesBytes(int index) {
          return knowledgeBases_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge bases to query. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
         * base is supported.
         * </pre>
         *
         * <code>
         * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The knowledgeBases to set.
         * @return This builder for chaining.
         */
        public Builder setKnowledgeBases(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureKnowledgeBasesIsMutable();
          knowledgeBases_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge bases to query. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
         * base is supported.
         * </pre>
         *
         * <code>
         * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The knowledgeBases to add.
         * @return This builder for chaining.
         */
        public Builder addKnowledgeBases(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureKnowledgeBasesIsMutable();
          knowledgeBases_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge bases to query. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
         * base is supported.
         * </pre>
         *
         * <code>
         * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param values The knowledgeBases to add.
         * @return This builder for chaining.
         */
        public Builder addAllKnowledgeBases(java.lang.Iterable<java.lang.String> values) {
          ensureKnowledgeBasesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, knowledgeBases_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge bases to query. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
         * base is supported.
         * </pre>
         *
         * <code>
         * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearKnowledgeBases() {
          knowledgeBases_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge bases to query. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;Knowledge Base ID&gt;`. Currently, only one knowledge
         * base is supported.
         * </pre>
         *
         * <code>
         * repeated string knowledge_bases = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes of the knowledgeBases to add.
         * @return This builder for chaining.
         */
        public Builder addKnowledgeBasesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureKnowledgeBasesIsMutable();
          knowledgeBases_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource)
      private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .KnowledgeBaseQuerySource();
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.KnowledgeBaseQuerySource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<KnowledgeBaseQuerySource> PARSER =
          new com.google.protobuf.AbstractParser<KnowledgeBaseQuerySource>() {
            @java.lang.Override
            public KnowledgeBaseQuerySource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<KnowledgeBaseQuerySource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<KnowledgeBaseQuerySource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .KnowledgeBaseQuerySource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface DocumentQuerySourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Knowledge documents to query from. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
       * Currently, only one document is supported.
       * </pre>
       *
       * <code>
       * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return A list containing the documents.
       */
      java.util.List<java.lang.String> getDocumentsList();
      /**
       *
       *
       * <pre>
       * Required. Knowledge documents to query from. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
       * Currently, only one document is supported.
       * </pre>
       *
       * <code>
       * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The count of documents.
       */
      int getDocumentsCount();
      /**
       *
       *
       * <pre>
       * Required. Knowledge documents to query from. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
       * Currently, only one document is supported.
       * </pre>
       *
       * <code>
       * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the element to return.
       * @return The documents at the given index.
       */
      java.lang.String getDocuments(int index);
      /**
       *
       *
       * <pre>
       * Required. Knowledge documents to query from. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
       * Currently, only one document is supported.
       * </pre>
       *
       * <code>
       * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the documents at the given index.
       */
      com.google.protobuf.ByteString getDocumentsBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * Document source settings.
     *
     * Supported features: SMART_REPLY, SMART_COMPOSE.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource}
     */
    public static final class DocumentQuerySource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource)
        DocumentQuerySourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DocumentQuerySource.newBuilder() to construct.
      private DocumentQuerySource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DocumentQuerySource() {
        documents_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DocumentQuerySource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DocumentQuerySource.class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DocumentQuerySource.Builder.class);
      }

      public static final int DOCUMENTS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList documents_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Required. Knowledge documents to query from. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
       * Currently, only one document is supported.
       * </pre>
       *
       * <code>
       * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return A list containing the documents.
       */
      public com.google.protobuf.ProtocolStringList getDocumentsList() {
        return documents_;
      }
      /**
       *
       *
       * <pre>
       * Required. Knowledge documents to query from. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
       * Currently, only one document is supported.
       * </pre>
       *
       * <code>
       * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The count of documents.
       */
      public int getDocumentsCount() {
        return documents_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. Knowledge documents to query from. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
       * Currently, only one document is supported.
       * </pre>
       *
       * <code>
       * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the element to return.
       * @return The documents at the given index.
       */
      public java.lang.String getDocuments(int index) {
        return documents_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. Knowledge documents to query from. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
       * Currently, only one document is supported.
       * </pre>
       *
       * <code>
       * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the documents at the given index.
       */
      public com.google.protobuf.ByteString getDocumentsBytes(int index) {
        return documents_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < documents_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, documents_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < documents_.size(); i++) {
            dataSize += computeStringSizeNoTag(documents_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getDocumentsList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DocumentQuerySource)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DocumentQuerySource
            other =
                (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                        .DocumentQuerySource)
                    obj;

        if (!getDocumentsList().equals(other.getDocumentsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getDocumentsCount() > 0) {
          hash = (37 * hash) + DOCUMENTS_FIELD_NUMBER;
          hash = (53 * hash) + getDocumentsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySource
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Document source settings.
       *
       * Supported features: SMART_REPLY, SMART_COMPOSE.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource)
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DocumentQuerySourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DocumentQuerySource.class,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DocumentQuerySource.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          documents_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DocumentQuerySource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DocumentQuerySource
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DocumentQuerySource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DocumentQuerySource
            build() {
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySource
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DocumentQuerySource
            buildPartial() {
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySource
              result =
                  new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DocumentQuerySource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DocumentQuerySource
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            documents_.makeImmutable();
            result.documents_ = documents_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySource) {
            return mergeFrom(
                (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                        .DocumentQuerySource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DocumentQuerySource
                other) {
          if (other
              == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySource.getDefaultInstance()) return this;
          if (!other.documents_.isEmpty()) {
            if (documents_.isEmpty()) {
              documents_ = other.documents_;
              bitField0_ |= 0x00000001;
            } else {
              ensureDocumentsIsMutable();
              documents_.addAll(other.documents_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureDocumentsIsMutable();
                    documents_.add(s);
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList documents_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureDocumentsIsMutable() {
          if (!documents_.isModifiable()) {
            documents_ = new com.google.protobuf.LazyStringArrayList(documents_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge documents to query from. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
         * Currently, only one document is supported.
         * </pre>
         *
         * <code>
         * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return A list containing the documents.
         */
        public com.google.protobuf.ProtocolStringList getDocumentsList() {
          documents_.makeImmutable();
          return documents_;
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge documents to query from. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
         * Currently, only one document is supported.
         * </pre>
         *
         * <code>
         * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The count of documents.
         */
        public int getDocumentsCount() {
          return documents_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge documents to query from. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
         * Currently, only one document is supported.
         * </pre>
         *
         * <code>
         * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param index The index of the element to return.
         * @return The documents at the given index.
         */
        public java.lang.String getDocuments(int index) {
          return documents_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge documents to query from. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
         * Currently, only one document is supported.
         * </pre>
         *
         * <code>
         * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the documents at the given index.
         */
        public com.google.protobuf.ByteString getDocumentsBytes(int index) {
          return documents_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge documents to query from. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
         * Currently, only one document is supported.
         * </pre>
         *
         * <code>
         * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The documents to set.
         * @return This builder for chaining.
         */
        public Builder setDocuments(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentsIsMutable();
          documents_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge documents to query from. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
         * Currently, only one document is supported.
         * </pre>
         *
         * <code>
         * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The documents to add.
         * @return This builder for chaining.
         */
        public Builder addDocuments(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDocumentsIsMutable();
          documents_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge documents to query from. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
         * Currently, only one document is supported.
         * </pre>
         *
         * <code>
         * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param values The documents to add.
         * @return This builder for chaining.
         */
        public Builder addAllDocuments(java.lang.Iterable<java.lang.String> values) {
          ensureDocumentsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, documents_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge documents to query from. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
         * Currently, only one document is supported.
         * </pre>
         *
         * <code>
         * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDocuments() {
          documents_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Knowledge documents to query from. Format:
         * `projects/&lt;Project ID&gt;/locations/&lt;Location
         * ID&gt;/knowledgeBases/&lt;KnowledgeBase ID&gt;/documents/&lt;Document ID&gt;`.
         * Currently, only one document is supported.
         * </pre>
         *
         * <code>
         * repeated string documents = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes of the documents to add.
         * @return This builder for chaining.
         */
        public Builder addDocumentsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureDocumentsIsMutable();
          documents_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource)
      private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DocumentQuerySource();
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DocumentQuerySource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DocumentQuerySource> PARSER =
          new com.google.protobuf.AbstractParser<DocumentQuerySource>() {
            @java.lang.Override
            public DocumentQuerySource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DocumentQuerySource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DocumentQuerySource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DocumentQuerySource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface DialogflowQuerySourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The name of a dialogflow virtual agent used for end user side
       * intent detection and suggestion. Format: `projects/&lt;Project
       * ID&gt;/locations/&lt;Location ID&gt;/agent`. When multiple agents are allowed in
       * the same Dialogflow project.
       * </pre>
       *
       * <code>
       * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The agent.
       */
      java.lang.String getAgent();
      /**
       *
       *
       * <pre>
       * Required. The name of a dialogflow virtual agent used for end user side
       * intent detection and suggestion. Format: `projects/&lt;Project
       * ID&gt;/locations/&lt;Location ID&gt;/agent`. When multiple agents are allowed in
       * the same Dialogflow project.
       * </pre>
       *
       * <code>
       * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for agent.
       */
      com.google.protobuf.ByteString getAgentBytes();

      /**
       *
       *
       * <pre>
       * The Dialogflow assist configuration for human agent.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
       * </code>
       *
       * @return Whether the humanAgentSideConfig field is set.
       */
      boolean hasHumanAgentSideConfig();
      /**
       *
       *
       * <pre>
       * The Dialogflow assist configuration for human agent.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
       * </code>
       *
       * @return The humanAgentSideConfig.
       */
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySource.HumanAgentSideConfig
          getHumanAgentSideConfig();
      /**
       *
       *
       * <pre>
       * The Dialogflow assist configuration for human agent.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
       * </code>
       */
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySource.HumanAgentSideConfigOrBuilder
          getHumanAgentSideConfigOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Dialogflow source setting.
     *
     * Supported feature: DIALOGFLOW_ASSIST, ENTITY_EXTRACTION.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource}
     */
    public static final class DialogflowQuerySource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource)
        DialogflowQuerySourceOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DialogflowQuerySource.newBuilder() to construct.
      private DialogflowQuerySource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DialogflowQuerySource() {
        agent_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DialogflowQuerySource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.Builder.class);
      }

      public interface HumanAgentSideConfigOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Optional. The name of a dialogflow virtual agent used for intent
         * detection and suggestion triggered by human agent.
         * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`.
         * </pre>
         *
         * <code>
         * string agent = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The agent.
         */
        java.lang.String getAgent();
        /**
         *
         *
         * <pre>
         * Optional. The name of a dialogflow virtual agent used for intent
         * detection and suggestion triggered by human agent.
         * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`.
         * </pre>
         *
         * <code>
         * string agent = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for agent.
         */
        com.google.protobuf.ByteString getAgentBytes();
      }
      /**
       *
       *
       * <pre>
       * The configuration used for human agent side Dialogflow assist
       * suggestion.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig}
       */
      public static final class HumanAgentSideConfig extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig)
          HumanAgentSideConfigOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use HumanAgentSideConfig.newBuilder() to construct.
        private HumanAgentSideConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private HumanAgentSideConfig() {
          agent_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new HumanAgentSideConfig();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig.class,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig.Builder
                      .class);
        }

        public static final int AGENT_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private volatile java.lang.Object agent_ = "";
        /**
         *
         *
         * <pre>
         * Optional. The name of a dialogflow virtual agent used for intent
         * detection and suggestion triggered by human agent.
         * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`.
         * </pre>
         *
         * <code>
         * string agent = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The agent.
         */
        @java.lang.Override
        public java.lang.String getAgent() {
          java.lang.Object ref = agent_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            agent_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. The name of a dialogflow virtual agent used for intent
         * detection and suggestion triggered by human agent.
         * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`.
         * </pre>
         *
         * <code>
         * string agent = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for agent.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getAgentBytes() {
          java.lang.Object ref = agent_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            agent_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agent_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, agent_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agent_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, agent_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource.HumanAgentSideConfig)) {
            return super.equals(obj);
          }
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource.HumanAgentSideConfig
              other =
                  (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                          .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig)
                      obj;

          if (!getAgent().equals(other.getAgent())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + AGENT_FIELD_NUMBER;
          hash = (53 * hash) + getAgent().hashCode();
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.HumanAgentSideConfig
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * The configuration used for human agent side Dialogflow assist
         * suggestion.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig)
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource.HumanAgentSideConfigOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
                .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
                .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                        .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig.class,
                    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                        .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig.Builder
                        .class);
          }

          // Construct using
          // com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            agent_ = "";
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
                .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_HumanAgentSideConfig_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource.HumanAgentSideConfig
              getDefaultInstanceForType() {
            return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
                .getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource.HumanAgentSideConfig
              build() {
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.HumanAgentSideConfig
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource.HumanAgentSideConfig
              buildPartial() {
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.HumanAgentSideConfig
                result =
                    new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                        .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                      .DialogflowQuerySource.HumanAgentSideConfig
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.agent_ = agent_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.HumanAgentSideConfig) {
              return mergeFrom(
                  (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                          .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                      .DialogflowQuerySource.HumanAgentSideConfig
                  other) {
            if (other
                == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
                    .getDefaultInstance()) return this;
            if (!other.getAgent().isEmpty()) {
              agent_ = other.agent_;
              bitField0_ |= 0x00000001;
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      agent_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private java.lang.Object agent_ = "";
          /**
           *
           *
           * <pre>
           * Optional. The name of a dialogflow virtual agent used for intent
           * detection and suggestion triggered by human agent.
           * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`.
           * </pre>
           *
           * <code>
           * string agent = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
           * </code>
           *
           * @return The agent.
           */
          public java.lang.String getAgent() {
            java.lang.Object ref = agent_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              agent_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The name of a dialogflow virtual agent used for intent
           * detection and suggestion triggered by human agent.
           * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`.
           * </pre>
           *
           * <code>
           * string agent = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
           * </code>
           *
           * @return The bytes for agent.
           */
          public com.google.protobuf.ByteString getAgentBytes() {
            java.lang.Object ref = agent_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              agent_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * Optional. The name of a dialogflow virtual agent used for intent
           * detection and suggestion triggered by human agent.
           * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`.
           * </pre>
           *
           * <code>
           * string agent = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
           * </code>
           *
           * @param value The agent to set.
           * @return This builder for chaining.
           */
          public Builder setAgent(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            agent_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The name of a dialogflow virtual agent used for intent
           * detection and suggestion triggered by human agent.
           * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`.
           * </pre>
           *
           * <code>
           * string agent = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
           * </code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAgent() {
            agent_ = getDefaultInstance().getAgent();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Optional. The name of a dialogflow virtual agent used for intent
           * detection and suggestion triggered by human agent.
           * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agent`.
           * </pre>
           *
           * <code>
           * string agent = 1 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
           * </code>
           *
           * @param value The bytes for agent to set.
           * @return This builder for chaining.
           */
          public Builder setAgentBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            agent_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig)
        private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig();
        }

        public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<HumanAgentSideConfig> PARSER =
            new com.google.protobuf.AbstractParser<HumanAgentSideConfig>() {
              @java.lang.Override
              public HumanAgentSideConfig parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<HumanAgentSideConfig> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<HumanAgentSideConfig> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource.HumanAgentSideConfig
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      public static final int AGENT_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object agent_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of a dialogflow virtual agent used for end user side
       * intent detection and suggestion. Format: `projects/&lt;Project
       * ID&gt;/locations/&lt;Location ID&gt;/agent`. When multiple agents are allowed in
       * the same Dialogflow project.
       * </pre>
       *
       * <code>
       * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The agent.
       */
      @java.lang.Override
      public java.lang.String getAgent() {
        java.lang.Object ref = agent_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          agent_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of a dialogflow virtual agent used for end user side
       * intent detection and suggestion. Format: `projects/&lt;Project
       * ID&gt;/locations/&lt;Location ID&gt;/agent`. When multiple agents are allowed in
       * the same Dialogflow project.
       * </pre>
       *
       * <code>
       * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for agent.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getAgentBytes() {
        java.lang.Object ref = agent_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          agent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int HUMAN_AGENT_SIDE_CONFIG_FIELD_NUMBER = 3;
      private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySource.HumanAgentSideConfig
          humanAgentSideConfig_;
      /**
       *
       *
       * <pre>
       * The Dialogflow assist configuration for human agent.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
       * </code>
       *
       * @return Whether the humanAgentSideConfig field is set.
       */
      @java.lang.Override
      public boolean hasHumanAgentSideConfig() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The Dialogflow assist configuration for human agent.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
       * </code>
       *
       * @return The humanAgentSideConfig.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySource.HumanAgentSideConfig
          getHumanAgentSideConfig() {
        return humanAgentSideConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource.HumanAgentSideConfig.getDefaultInstance()
            : humanAgentSideConfig_;
      }
      /**
       *
       *
       * <pre>
       * The Dialogflow assist configuration for human agent.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySource.HumanAgentSideConfigOrBuilder
          getHumanAgentSideConfigOrBuilder() {
        return humanAgentSideConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource.HumanAgentSideConfig.getDefaultInstance()
            : humanAgentSideConfig_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agent_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, agent_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(3, getHumanAgentSideConfig());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agent_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, agent_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3, getHumanAgentSideConfig());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource
            other =
                (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                        .DialogflowQuerySource)
                    obj;

        if (!getAgent().equals(other.getAgent())) return false;
        if (hasHumanAgentSideConfig() != other.hasHumanAgentSideConfig()) return false;
        if (hasHumanAgentSideConfig()) {
          if (!getHumanAgentSideConfig().equals(other.getHumanAgentSideConfig())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + AGENT_FIELD_NUMBER;
        hash = (53 * hash) + getAgent().hashCode();
        if (hasHumanAgentSideConfig()) {
          hash = (37 * hash) + HUMAN_AGENT_SIDE_CONFIG_FIELD_NUMBER;
          hash = (53 * hash) + getHumanAgentSideConfig().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Dialogflow source setting.
       *
       * Supported feature: DIALOGFLOW_ASSIST, ENTITY_EXTRACTION.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource)
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DialogflowQuerySource.class,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DialogflowQuerySource.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getHumanAgentSideConfigFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          agent_ = "";
          humanAgentSideConfig_ = null;
          if (humanAgentSideConfigBuilder_ != null) {
            humanAgentSideConfigBuilder_.dispose();
            humanAgentSideConfigBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_DialogflowQuerySource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource
            build() {
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource
            buildPartial() {
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource
              result =
                  new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DialogflowQuerySource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.agent_ = agent_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.humanAgentSideConfig_ =
                humanAgentSideConfigBuilder_ == null
                    ? humanAgentSideConfig_
                    : humanAgentSideConfigBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource) {
            return mergeFrom(
                (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                        .DialogflowQuerySource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource
                other) {
          if (other
              == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource.getDefaultInstance()) return this;
          if (!other.getAgent().isEmpty()) {
            agent_ = other.agent_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasHumanAgentSideConfig()) {
            mergeHumanAgentSideConfig(other.getHumanAgentSideConfig());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    agent_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 26:
                  {
                    input.readMessage(
                        getHumanAgentSideConfigFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object agent_ = "";
        /**
         *
         *
         * <pre>
         * Required. The name of a dialogflow virtual agent used for end user side
         * intent detection and suggestion. Format: `projects/&lt;Project
         * ID&gt;/locations/&lt;Location ID&gt;/agent`. When multiple agents are allowed in
         * the same Dialogflow project.
         * </pre>
         *
         * <code>
         * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The agent.
         */
        public java.lang.String getAgent() {
          java.lang.Object ref = agent_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            agent_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The name of a dialogflow virtual agent used for end user side
         * intent detection and suggestion. Format: `projects/&lt;Project
         * ID&gt;/locations/&lt;Location ID&gt;/agent`. When multiple agents are allowed in
         * the same Dialogflow project.
         * </pre>
         *
         * <code>
         * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The bytes for agent.
         */
        public com.google.protobuf.ByteString getAgentBytes() {
          java.lang.Object ref = agent_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            agent_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The name of a dialogflow virtual agent used for end user side
         * intent detection and suggestion. Format: `projects/&lt;Project
         * ID&gt;/locations/&lt;Location ID&gt;/agent`. When multiple agents are allowed in
         * the same Dialogflow project.
         * </pre>
         *
         * <code>
         * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The agent to set.
         * @return This builder for chaining.
         */
        public Builder setAgent(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          agent_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The name of a dialogflow virtual agent used for end user side
         * intent detection and suggestion. Format: `projects/&lt;Project
         * ID&gt;/locations/&lt;Location ID&gt;/agent`. When multiple agents are allowed in
         * the same Dialogflow project.
         * </pre>
         *
         * <code>
         * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAgent() {
          agent_ = getDefaultInstance().getAgent();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The name of a dialogflow virtual agent used for end user side
         * intent detection and suggestion. Format: `projects/&lt;Project
         * ID&gt;/locations/&lt;Location ID&gt;/agent`. When multiple agents are allowed in
         * the same Dialogflow project.
         * </pre>
         *
         * <code>
         * string agent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes for agent to set.
         * @return This builder for chaining.
         */
        public Builder setAgentBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          agent_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource.HumanAgentSideConfig
            humanAgentSideConfig_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.HumanAgentSideConfig,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.HumanAgentSideConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.HumanAgentSideConfigOrBuilder>
            humanAgentSideConfigBuilder_;
        /**
         *
         *
         * <pre>
         * The Dialogflow assist configuration for human agent.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
         * </code>
         *
         * @return Whether the humanAgentSideConfig field is set.
         */
        public boolean hasHumanAgentSideConfig() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * The Dialogflow assist configuration for human agent.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
         * </code>
         *
         * @return The humanAgentSideConfig.
         */
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource.HumanAgentSideConfig
            getHumanAgentSideConfig() {
          if (humanAgentSideConfigBuilder_ == null) {
            return humanAgentSideConfig_ == null
                ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
                    .getDefaultInstance()
                : humanAgentSideConfig_;
          } else {
            return humanAgentSideConfigBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The Dialogflow assist configuration for human agent.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
         * </code>
         */
        public Builder setHumanAgentSideConfig(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.HumanAgentSideConfig
                value) {
          if (humanAgentSideConfigBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            humanAgentSideConfig_ = value;
          } else {
            humanAgentSideConfigBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The Dialogflow assist configuration for human agent.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
         * </code>
         */
        public Builder setHumanAgentSideConfig(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.HumanAgentSideConfig.Builder
                builderForValue) {
          if (humanAgentSideConfigBuilder_ == null) {
            humanAgentSideConfig_ = builderForValue.build();
          } else {
            humanAgentSideConfigBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The Dialogflow assist configuration for human agent.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
         * </code>
         */
        public Builder mergeHumanAgentSideConfig(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.HumanAgentSideConfig
                value) {
          if (humanAgentSideConfigBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && humanAgentSideConfig_ != null
                && humanAgentSideConfig_
                    != com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                        .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
                        .getDefaultInstance()) {
              getHumanAgentSideConfigBuilder().mergeFrom(value);
            } else {
              humanAgentSideConfig_ = value;
            }
          } else {
            humanAgentSideConfigBuilder_.mergeFrom(value);
          }
          if (humanAgentSideConfig_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The Dialogflow assist configuration for human agent.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
         * </code>
         */
        public Builder clearHumanAgentSideConfig() {
          bitField0_ = (bitField0_ & ~0x00000002);
          humanAgentSideConfig_ = null;
          if (humanAgentSideConfigBuilder_ != null) {
            humanAgentSideConfigBuilder_.dispose();
            humanAgentSideConfigBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The Dialogflow assist configuration for human agent.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
         * </code>
         */
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource.HumanAgentSideConfig.Builder
            getHumanAgentSideConfigBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getHumanAgentSideConfigFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The Dialogflow assist configuration for human agent.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
         * </code>
         */
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource.HumanAgentSideConfigOrBuilder
            getHumanAgentSideConfigOrBuilder() {
          if (humanAgentSideConfigBuilder_ != null) {
            return humanAgentSideConfigBuilder_.getMessageOrBuilder();
          } else {
            return humanAgentSideConfig_ == null
                ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig
                    .getDefaultInstance()
                : humanAgentSideConfig_;
          }
        }
        /**
         *
         *
         * <pre>
         * The Dialogflow assist configuration for human agent.
         * </pre>
         *
         * <code>
         * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig human_agent_side_config = 3;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.HumanAgentSideConfig,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.HumanAgentSideConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.HumanAgentSideConfigOrBuilder>
            getHumanAgentSideConfigFieldBuilder() {
          if (humanAgentSideConfigBuilder_ == null) {
            humanAgentSideConfigBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                        .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig,
                    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                        .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfig.Builder,
                    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                        .SuggestionQueryConfig.DialogflowQuerySource.HumanAgentSideConfigOrBuilder>(
                    getHumanAgentSideConfig(), getParentForChildren(), isClean());
            humanAgentSideConfig_ = null;
          }
          return humanAgentSideConfigBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource)
      private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource();
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.DialogflowQuerySource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DialogflowQuerySource> PARSER =
          new com.google.protobuf.AbstractParser<DialogflowQuerySource>() {
            @java.lang.Override
            public DialogflowQuerySource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DialogflowQuerySource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DialogflowQuerySource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ContextFilterSettingsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * If set to true, the last message from virtual agent (hand off message)
       * and the message before it (trigger message of hand off) are dropped.
       * </pre>
       *
       * <code>bool drop_handoff_messages = 1;</code>
       *
       * @return The dropHandoffMessages.
       */
      boolean getDropHandoffMessages();

      /**
       *
       *
       * <pre>
       * If set to true, all messages from virtual agent are dropped.
       * </pre>
       *
       * <code>bool drop_virtual_agent_messages = 2;</code>
       *
       * @return The dropVirtualAgentMessages.
       */
      boolean getDropVirtualAgentMessages();

      /**
       *
       *
       * <pre>
       * If set to true, all messages from ivr stage are dropped.
       * </pre>
       *
       * <code>bool drop_ivr_messages = 3;</code>
       *
       * @return The dropIvrMessages.
       */
      boolean getDropIvrMessages();
    }
    /**
     *
     *
     * <pre>
     * Settings that determine how to filter recent conversation context when
     * generating suggestions.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings}
     */
    public static final class ContextFilterSettings extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings)
        ContextFilterSettingsOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ContextFilterSettings.newBuilder() to construct.
      private ContextFilterSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ContextFilterSettings() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ContextFilterSettings();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .ContextFilterSettings.class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .ContextFilterSettings.Builder.class);
      }

      public static final int DROP_HANDOFF_MESSAGES_FIELD_NUMBER = 1;
      private boolean dropHandoffMessages_ = false;
      /**
       *
       *
       * <pre>
       * If set to true, the last message from virtual agent (hand off message)
       * and the message before it (trigger message of hand off) are dropped.
       * </pre>
       *
       * <code>bool drop_handoff_messages = 1;</code>
       *
       * @return The dropHandoffMessages.
       */
      @java.lang.Override
      public boolean getDropHandoffMessages() {
        return dropHandoffMessages_;
      }

      public static final int DROP_VIRTUAL_AGENT_MESSAGES_FIELD_NUMBER = 2;
      private boolean dropVirtualAgentMessages_ = false;
      /**
       *
       *
       * <pre>
       * If set to true, all messages from virtual agent are dropped.
       * </pre>
       *
       * <code>bool drop_virtual_agent_messages = 2;</code>
       *
       * @return The dropVirtualAgentMessages.
       */
      @java.lang.Override
      public boolean getDropVirtualAgentMessages() {
        return dropVirtualAgentMessages_;
      }

      public static final int DROP_IVR_MESSAGES_FIELD_NUMBER = 3;
      private boolean dropIvrMessages_ = false;
      /**
       *
       *
       * <pre>
       * If set to true, all messages from ivr stage are dropped.
       * </pre>
       *
       * <code>bool drop_ivr_messages = 3;</code>
       *
       * @return The dropIvrMessages.
       */
      @java.lang.Override
      public boolean getDropIvrMessages() {
        return dropIvrMessages_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (dropHandoffMessages_ != false) {
          output.writeBool(1, dropHandoffMessages_);
        }
        if (dropVirtualAgentMessages_ != false) {
          output.writeBool(2, dropVirtualAgentMessages_);
        }
        if (dropIvrMessages_ != false) {
          output.writeBool(3, dropIvrMessages_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (dropHandoffMessages_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, dropHandoffMessages_);
        }
        if (dropVirtualAgentMessages_ != false) {
          size +=
              com.google.protobuf.CodedOutputStream.computeBoolSize(2, dropVirtualAgentMessages_);
        }
        if (dropIvrMessages_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, dropIvrMessages_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .ContextFilterSettings)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .ContextFilterSettings
            other =
                (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                        .ContextFilterSettings)
                    obj;

        if (getDropHandoffMessages() != other.getDropHandoffMessages()) return false;
        if (getDropVirtualAgentMessages() != other.getDropVirtualAgentMessages()) return false;
        if (getDropIvrMessages() != other.getDropIvrMessages()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DROP_HANDOFF_MESSAGES_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDropHandoffMessages());
        hash = (37 * hash) + DROP_VIRTUAL_AGENT_MESSAGES_FIELD_NUMBER;
        hash =
            (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDropVirtualAgentMessages());
        hash = (37 * hash) + DROP_IVR_MESSAGES_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDropIvrMessages());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Settings that determine how to filter recent conversation context when
       * generating suggestions.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings)
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .ContextFilterSettingsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.ContextFilterSettings.class,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.ContextFilterSettings.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          dropHandoffMessages_ = false;
          dropVirtualAgentMessages_ = false;
          dropIvrMessages_ = false;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_ContextFilterSettings_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .ContextFilterSettings
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .ContextFilterSettings.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .ContextFilterSettings
            build() {
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .ContextFilterSettings
            buildPartial() {
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings
              result =
                  new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.ContextFilterSettings(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .ContextFilterSettings
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.dropHandoffMessages_ = dropHandoffMessages_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.dropVirtualAgentMessages_ = dropVirtualAgentMessages_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.dropIvrMessages_ = dropIvrMessages_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings) {
            return mergeFrom(
                (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                        .ContextFilterSettings)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .ContextFilterSettings
                other) {
          if (other
              == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings.getDefaultInstance()) return this;
          if (other.getDropHandoffMessages() != false) {
            setDropHandoffMessages(other.getDropHandoffMessages());
          }
          if (other.getDropVirtualAgentMessages() != false) {
            setDropVirtualAgentMessages(other.getDropVirtualAgentMessages());
          }
          if (other.getDropIvrMessages() != false) {
            setDropIvrMessages(other.getDropIvrMessages());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    dropHandoffMessages_ = input.readBool();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    dropVirtualAgentMessages_ = input.readBool();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 24:
                  {
                    dropIvrMessages_ = input.readBool();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private boolean dropHandoffMessages_;
        /**
         *
         *
         * <pre>
         * If set to true, the last message from virtual agent (hand off message)
         * and the message before it (trigger message of hand off) are dropped.
         * </pre>
         *
         * <code>bool drop_handoff_messages = 1;</code>
         *
         * @return The dropHandoffMessages.
         */
        @java.lang.Override
        public boolean getDropHandoffMessages() {
          return dropHandoffMessages_;
        }
        /**
         *
         *
         * <pre>
         * If set to true, the last message from virtual agent (hand off message)
         * and the message before it (trigger message of hand off) are dropped.
         * </pre>
         *
         * <code>bool drop_handoff_messages = 1;</code>
         *
         * @param value The dropHandoffMessages to set.
         * @return This builder for chaining.
         */
        public Builder setDropHandoffMessages(boolean value) {

          dropHandoffMessages_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If set to true, the last message from virtual agent (hand off message)
         * and the message before it (trigger message of hand off) are dropped.
         * </pre>
         *
         * <code>bool drop_handoff_messages = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDropHandoffMessages() {
          bitField0_ = (bitField0_ & ~0x00000001);
          dropHandoffMessages_ = false;
          onChanged();
          return this;
        }

        private boolean dropVirtualAgentMessages_;
        /**
         *
         *
         * <pre>
         * If set to true, all messages from virtual agent are dropped.
         * </pre>
         *
         * <code>bool drop_virtual_agent_messages = 2;</code>
         *
         * @return The dropVirtualAgentMessages.
         */
        @java.lang.Override
        public boolean getDropVirtualAgentMessages() {
          return dropVirtualAgentMessages_;
        }
        /**
         *
         *
         * <pre>
         * If set to true, all messages from virtual agent are dropped.
         * </pre>
         *
         * <code>bool drop_virtual_agent_messages = 2;</code>
         *
         * @param value The dropVirtualAgentMessages to set.
         * @return This builder for chaining.
         */
        public Builder setDropVirtualAgentMessages(boolean value) {

          dropVirtualAgentMessages_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If set to true, all messages from virtual agent are dropped.
         * </pre>
         *
         * <code>bool drop_virtual_agent_messages = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDropVirtualAgentMessages() {
          bitField0_ = (bitField0_ & ~0x00000002);
          dropVirtualAgentMessages_ = false;
          onChanged();
          return this;
        }

        private boolean dropIvrMessages_;
        /**
         *
         *
         * <pre>
         * If set to true, all messages from ivr stage are dropped.
         * </pre>
         *
         * <code>bool drop_ivr_messages = 3;</code>
         *
         * @return The dropIvrMessages.
         */
        @java.lang.Override
        public boolean getDropIvrMessages() {
          return dropIvrMessages_;
        }
        /**
         *
         *
         * <pre>
         * If set to true, all messages from ivr stage are dropped.
         * </pre>
         *
         * <code>bool drop_ivr_messages = 3;</code>
         *
         * @param value The dropIvrMessages to set.
         * @return This builder for chaining.
         */
        public Builder setDropIvrMessages(boolean value) {

          dropIvrMessages_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * If set to true, all messages from ivr stage are dropped.
         * </pre>
         *
         * <code>bool drop_ivr_messages = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDropIvrMessages() {
          bitField0_ = (bitField0_ & ~0x00000004);
          dropIvrMessages_ = false;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings)
      private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .ContextFilterSettings();
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.ContextFilterSettings
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ContextFilterSettings> PARSER =
          new com.google.protobuf.AbstractParser<ContextFilterSettings>() {
            @java.lang.Override
            public ContextFilterSettings parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ContextFilterSettings> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ContextFilterSettings> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .ContextFilterSettings
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface SectionsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The selected sections chosen to return when requesting a summary of a
       * conversation. A duplicate selected section will be treated as a single
       * selected section. If section types are not provided, the default will
       * be {SITUATION, ACTION, RESULT}.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
       * </code>
       *
       * @return A list containing the sectionTypes.
       */
      java.util.List<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections.SectionType>
          getSectionTypesList();
      /**
       *
       *
       * <pre>
       * The selected sections chosen to return when requesting a summary of a
       * conversation. A duplicate selected section will be treated as a single
       * selected section. If section types are not provided, the default will
       * be {SITUATION, ACTION, RESULT}.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
       * </code>
       *
       * @return The count of sectionTypes.
       */
      int getSectionTypesCount();
      /**
       *
       *
       * <pre>
       * The selected sections chosen to return when requesting a summary of a
       * conversation. A duplicate selected section will be treated as a single
       * selected section. If section types are not provided, the default will
       * be {SITUATION, ACTION, RESULT}.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The sectionTypes at the given index.
       */
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections
              .SectionType
          getSectionTypes(int index);
      /**
       *
       *
       * <pre>
       * The selected sections chosen to return when requesting a summary of a
       * conversation. A duplicate selected section will be treated as a single
       * selected section. If section types are not provided, the default will
       * be {SITUATION, ACTION, RESULT}.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for sectionTypes.
       */
      java.util.List<java.lang.Integer> getSectionTypesValueList();
      /**
       *
       *
       * <pre>
       * The selected sections chosen to return when requesting a summary of a
       * conversation. A duplicate selected section will be treated as a single
       * selected section. If section types are not provided, the default will
       * be {SITUATION, ACTION, RESULT}.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of sectionTypes at the given index.
       */
      int getSectionTypesValue(int index);
    }
    /**
     *
     *
     * <pre>
     * Custom sections to return when requesting a summary of a conversation.
     * This is only supported when `baseline_model_version` == '2.0'.
     *
     * Supported features: CONVERSATION_SUMMARIZATION,
     * CONVERSATION_SUMMARIZATION_VOICE.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections}
     */
    public static final class Sections extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections)
        SectionsOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Sections.newBuilder() to construct.
      private Sections(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Sections() {
        sectionTypes_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Sections();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .Sections.class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .Sections.Builder.class);
      }

      /**
       *
       *
       * <pre>
       * Selectable sections to return when requesting a summary of a
       * conversation.
       * </pre>
       *
       * Protobuf enum {@code
       * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType}
       */
      public enum SectionType implements com.google.protobuf.ProtocolMessageEnum {
        /**
         *
         *
         * <pre>
         * Undefined section type, does not return anything.
         * </pre>
         *
         * <code>SECTION_TYPE_UNSPECIFIED = 0;</code>
         */
        SECTION_TYPE_UNSPECIFIED(0),
        /**
         *
         *
         * <pre>
         * What the customer needs help with or has question about.
         * Section name: "situation".
         * </pre>
         *
         * <code>SITUATION = 1;</code>
         */
        SITUATION(1),
        /**
         *
         *
         * <pre>
         * What the agent does to help the customer.
         * Section name: "action".
         * </pre>
         *
         * <code>ACTION = 2;</code>
         */
        ACTION(2),
        /**
         *
         *
         * <pre>
         * Result of the customer service. A single word describing the result
         * of the conversation.
         * Section name: "resolution".
         * </pre>
         *
         * <code>RESOLUTION = 3;</code>
         */
        RESOLUTION(3),
        /**
         *
         *
         * <pre>
         * Reason for cancellation if the customer requests for a cancellation.
         * "N/A" otherwise.
         * Section name: "reason_for_cancellation".
         * </pre>
         *
         * <code>REASON_FOR_CANCELLATION = 4;</code>
         */
        REASON_FOR_CANCELLATION(4),
        /**
         *
         *
         * <pre>
         * "Unsatisfied" or "Satisfied" depending on the customer's feelings at
         * the end of the conversation.
         * Section name: "customer_satisfaction".
         * </pre>
         *
         * <code>CUSTOMER_SATISFACTION = 5;</code>
         */
        CUSTOMER_SATISFACTION(5),
        /**
         *
         *
         * <pre>
         * Key entities extracted from the conversation, such as ticket number,
         * order number, dollar amount, etc.
         * Section names are prefixed by "entities/".
         * </pre>
         *
         * <code>ENTITIES = 6;</code>
         */
        ENTITIES(6),
        UNRECOGNIZED(-1),
        ;

        /**
         *
         *
         * <pre>
         * Undefined section type, does not return anything.
         * </pre>
         *
         * <code>SECTION_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int SECTION_TYPE_UNSPECIFIED_VALUE = 0;
        /**
         *
         *
         * <pre>
         * What the customer needs help with or has question about.
         * Section name: "situation".
         * </pre>
         *
         * <code>SITUATION = 1;</code>
         */
        public static final int SITUATION_VALUE = 1;
        /**
         *
         *
         * <pre>
         * What the agent does to help the customer.
         * Section name: "action".
         * </pre>
         *
         * <code>ACTION = 2;</code>
         */
        public static final int ACTION_VALUE = 2;
        /**
         *
         *
         * <pre>
         * Result of the customer service. A single word describing the result
         * of the conversation.
         * Section name: "resolution".
         * </pre>
         *
         * <code>RESOLUTION = 3;</code>
         */
        public static final int RESOLUTION_VALUE = 3;
        /**
         *
         *
         * <pre>
         * Reason for cancellation if the customer requests for a cancellation.
         * "N/A" otherwise.
         * Section name: "reason_for_cancellation".
         * </pre>
         *
         * <code>REASON_FOR_CANCELLATION = 4;</code>
         */
        public static final int REASON_FOR_CANCELLATION_VALUE = 4;
        /**
         *
         *
         * <pre>
         * "Unsatisfied" or "Satisfied" depending on the customer's feelings at
         * the end of the conversation.
         * Section name: "customer_satisfaction".
         * </pre>
         *
         * <code>CUSTOMER_SATISFACTION = 5;</code>
         */
        public static final int CUSTOMER_SATISFACTION_VALUE = 5;
        /**
         *
         *
         * <pre>
         * Key entities extracted from the conversation, such as ticket number,
         * order number, dollar amount, etc.
         * Section names are prefixed by "entities/".
         * </pre>
         *
         * <code>ENTITIES = 6;</code>
         */
        public static final int ENTITIES_VALUE = 6;

        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static SectionType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static SectionType forNumber(int value) {
          switch (value) {
            case 0:
              return SECTION_TYPE_UNSPECIFIED;
            case 1:
              return SITUATION;
            case 2:
              return ACTION;
            case 3:
              return RESOLUTION;
            case 4:
              return REASON_FOR_CANCELLATION;
            case 5:
              return CUSTOMER_SATISFACTION;
            case 6:
              return ENTITIES;
            default:
              return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<SectionType> internalGetValueMap() {
          return internalValueMap;
        }

        private static final com.google.protobuf.Internal.EnumLiteMap<SectionType>
            internalValueMap =
                new com.google.protobuf.Internal.EnumLiteMap<SectionType>() {
                  public SectionType findValueByNumber(int number) {
                    return SectionType.forNumber(number);
                  }
                };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }

        public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
          return getDescriptor();
        }

        public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .Sections.getDescriptor()
              .getEnumTypes()
              .get(0);
        }

        private static final SectionType[] VALUES = values();

        public static SectionType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
                "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private SectionType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType)
      }

      public static final int SECTION_TYPES_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private java.util.List<java.lang.Integer> sectionTypes_;

      private static final com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections.SectionType>
          sectionTypes_converter_ =
              new com.google.protobuf.Internal.ListAdapter.Converter<
                  java.lang.Integer,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.Sections.SectionType>() {
                public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                        .SuggestionQueryConfig.Sections.SectionType
                    convert(java.lang.Integer from) {
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                          .SuggestionQueryConfig.Sections.SectionType
                      result =
                          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                              .SuggestionQueryConfig.Sections.SectionType.forNumber(from);
                  return result == null
                      ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                          .SuggestionQueryConfig.Sections.SectionType.UNRECOGNIZED
                      : result;
                }
              };
      /**
       *
       *
       * <pre>
       * The selected sections chosen to return when requesting a summary of a
       * conversation. A duplicate selected section will be treated as a single
       * selected section. If section types are not provided, the default will
       * be {SITUATION, ACTION, RESULT}.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
       * </code>
       *
       * @return A list containing the sectionTypes.
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections.SectionType>
          getSectionTypesList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .Sections.SectionType>(sectionTypes_, sectionTypes_converter_);
      }
      /**
       *
       *
       * <pre>
       * The selected sections chosen to return when requesting a summary of a
       * conversation. A duplicate selected section will be treated as a single
       * selected section. If section types are not provided, the default will
       * be {SITUATION, ACTION, RESULT}.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
       * </code>
       *
       * @return The count of sectionTypes.
       */
      @java.lang.Override
      public int getSectionTypesCount() {
        return sectionTypes_.size();
      }
      /**
       *
       *
       * <pre>
       * The selected sections chosen to return when requesting a summary of a
       * conversation. A duplicate selected section will be treated as a single
       * selected section. If section types are not provided, the default will
       * be {SITUATION, ACTION, RESULT}.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The sectionTypes at the given index.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .Sections.SectionType
          getSectionTypes(int index) {
        return sectionTypes_converter_.convert(sectionTypes_.get(index));
      }
      /**
       *
       *
       * <pre>
       * The selected sections chosen to return when requesting a summary of a
       * conversation. A duplicate selected section will be treated as a single
       * selected section. If section types are not provided, the default will
       * be {SITUATION, ACTION, RESULT}.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for sectionTypes.
       */
      @java.lang.Override
      public java.util.List<java.lang.Integer> getSectionTypesValueList() {
        return sectionTypes_;
      }
      /**
       *
       *
       * <pre>
       * The selected sections chosen to return when requesting a summary of a
       * conversation. A duplicate selected section will be treated as a single
       * selected section. If section types are not provided, the default will
       * be {SITUATION, ACTION, RESULT}.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of sectionTypes at the given index.
       */
      @java.lang.Override
      public int getSectionTypesValue(int index) {
        return sectionTypes_.get(index);
      }

      private int sectionTypesMemoizedSerializedSize;

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getSerializedSize();
        if (getSectionTypesList().size() > 0) {
          output.writeUInt32NoTag(10);
          output.writeUInt32NoTag(sectionTypesMemoizedSerializedSize);
        }
        for (int i = 0; i < sectionTypes_.size(); i++) {
          output.writeEnumNoTag(sectionTypes_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < sectionTypes_.size(); i++) {
            dataSize +=
                com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(sectionTypes_.get(i));
          }
          size += dataSize;
          if (!getSectionTypesList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
          }
          sectionTypesMemoizedSerializedSize = dataSize;
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .Sections)) {
          return super.equals(obj);
        }
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections
            other =
                (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                        .Sections)
                    obj;

        if (!sectionTypes_.equals(other.sectionTypes_)) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getSectionTypesCount() > 0) {
          hash = (37 * hash) + SECTION_TYPES_FIELD_NUMBER;
          hash = (53 * hash) + sectionTypes_.hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Custom sections to return when requesting a summary of a conversation.
       * This is only supported when `baseline_model_version` == '2.0'.
       *
       * Supported features: CONVERSATION_SUMMARIZATION,
       * CONVERSATION_SUMMARIZATION_VOICE.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections)
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .SectionsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.Sections.class,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.Sections.Builder.class);
        }

        // Construct using
        // com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          sectionTypes_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
              .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_Sections_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .Sections
            getDefaultInstanceForType() {
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .Sections.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .Sections
            build() {
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .Sections
            buildPartial() {
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections
              result =
                  new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.Sections(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .Sections
                result) {
          if (((bitField0_ & 0x00000001) != 0)) {
            sectionTypes_ = java.util.Collections.unmodifiableList(sectionTypes_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.sectionTypes_ = sectionTypes_;
        }

        private void buildPartial0(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .Sections
                result) {
          int from_bitField0_ = bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections) {
            return mergeFrom(
                (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                        .Sections)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .Sections
                other) {
          if (other
              == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections.getDefaultInstance()) return this;
          if (!other.sectionTypes_.isEmpty()) {
            if (sectionTypes_.isEmpty()) {
              sectionTypes_ = other.sectionTypes_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureSectionTypesIsMutable();
              sectionTypes_.addAll(other.sectionTypes_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    int tmpRaw = input.readEnum();
                    ensureSectionTypesIsMutable();
                    sectionTypes_.add(tmpRaw);
                    break;
                  } // case 8
                case 10:
                  {
                    int length = input.readRawVarint32();
                    int oldLimit = input.pushLimit(length);
                    while (input.getBytesUntilLimit() > 0) {
                      int tmpRaw = input.readEnum();
                      ensureSectionTypesIsMutable();
                      sectionTypes_.add(tmpRaw);
                    }
                    input.popLimit(oldLimit);
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<java.lang.Integer> sectionTypes_ = java.util.Collections.emptyList();

        private void ensureSectionTypesIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            sectionTypes_ = new java.util.ArrayList<java.lang.Integer>(sectionTypes_);
            bitField0_ |= 0x00000001;
          }
        }
        /**
         *
         *
         * <pre>
         * The selected sections chosen to return when requesting a summary of a
         * conversation. A duplicate selected section will be treated as a single
         * selected section. If section types are not provided, the default will
         * be {SITUATION, ACTION, RESULT}.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
         * </code>
         *
         * @return A list containing the sectionTypes.
         */
        public java.util.List<
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .Sections.SectionType>
            getSectionTypesList() {
          return new com.google.protobuf.Internal.ListAdapter<
              java.lang.Integer,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections.SectionType>(sectionTypes_, sectionTypes_converter_);
        }
        /**
         *
         *
         * <pre>
         * The selected sections chosen to return when requesting a summary of a
         * conversation. A duplicate selected section will be treated as a single
         * selected section. If section types are not provided, the default will
         * be {SITUATION, ACTION, RESULT}.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
         * </code>
         *
         * @return The count of sectionTypes.
         */
        public int getSectionTypesCount() {
          return sectionTypes_.size();
        }
        /**
         *
         *
         * <pre>
         * The selected sections chosen to return when requesting a summary of a
         * conversation. A duplicate selected section will be treated as a single
         * selected section. If section types are not provided, the default will
         * be {SITUATION, ACTION, RESULT}.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
         * </code>
         *
         * @param index The index of the element to return.
         * @return The sectionTypes at the given index.
         */
        public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .Sections.SectionType
            getSectionTypes(int index) {
          return sectionTypes_converter_.convert(sectionTypes_.get(index));
        }
        /**
         *
         *
         * <pre>
         * The selected sections chosen to return when requesting a summary of a
         * conversation. A duplicate selected section will be treated as a single
         * selected section. If section types are not provided, the default will
         * be {SITUATION, ACTION, RESULT}.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The sectionTypes to set.
         * @return This builder for chaining.
         */
        public Builder setSectionTypes(
            int index,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .Sections.SectionType
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSectionTypesIsMutable();
          sectionTypes_.set(index, value.getNumber());
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The selected sections chosen to return when requesting a summary of a
         * conversation. A duplicate selected section will be treated as a single
         * selected section. If section types are not provided, the default will
         * be {SITUATION, ACTION, RESULT}.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
         * </code>
         *
         * @param value The sectionTypes to add.
         * @return This builder for chaining.
         */
        public Builder addSectionTypes(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .Sections.SectionType
                value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSectionTypesIsMutable();
          sectionTypes_.add(value.getNumber());
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The selected sections chosen to return when requesting a summary of a
         * conversation. A duplicate selected section will be treated as a single
         * selected section. If section types are not provided, the default will
         * be {SITUATION, ACTION, RESULT}.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
         * </code>
         *
         * @param values The sectionTypes to add.
         * @return This builder for chaining.
         */
        public Builder addAllSectionTypes(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                            .SuggestionQueryConfig.Sections.SectionType>
                values) {
          ensureSectionTypesIsMutable();
          for (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections.SectionType
              value : values) {
            sectionTypes_.add(value.getNumber());
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The selected sections chosen to return when requesting a summary of a
         * conversation. A duplicate selected section will be treated as a single
         * selected section. If section types are not provided, the default will
         * be {SITUATION, ACTION, RESULT}.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSectionTypes() {
          sectionTypes_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The selected sections chosen to return when requesting a summary of a
         * conversation. A duplicate selected section will be treated as a single
         * selected section. If section types are not provided, the default will
         * be {SITUATION, ACTION, RESULT}.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
         * </code>
         *
         * @return A list containing the enum numeric values on the wire for sectionTypes.
         */
        public java.util.List<java.lang.Integer> getSectionTypesValueList() {
          return java.util.Collections.unmodifiableList(sectionTypes_);
        }
        /**
         *
         *
         * <pre>
         * The selected sections chosen to return when requesting a summary of a
         * conversation. A duplicate selected section will be treated as a single
         * selected section. If section types are not provided, the default will
         * be {SITUATION, ACTION, RESULT}.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
         * </code>
         *
         * @param index The index of the value to return.
         * @return The enum numeric value on the wire of sectionTypes at the given index.
         */
        public int getSectionTypesValue(int index) {
          return sectionTypes_.get(index);
        }
        /**
         *
         *
         * <pre>
         * The selected sections chosen to return when requesting a summary of a
         * conversation. A duplicate selected section will be treated as a single
         * selected section. If section types are not provided, the default will
         * be {SITUATION, ACTION, RESULT}.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The enum numeric value on the wire for sectionTypes to set.
         * @return This builder for chaining.
         */
        public Builder setSectionTypesValue(int index, int value) {
          ensureSectionTypesIsMutable();
          sectionTypes_.set(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The selected sections chosen to return when requesting a summary of a
         * conversation. A duplicate selected section will be treated as a single
         * selected section. If section types are not provided, the default will
         * be {SITUATION, ACTION, RESULT}.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
         * </code>
         *
         * @param value The enum numeric value on the wire for sectionTypes to add.
         * @return This builder for chaining.
         */
        public Builder addSectionTypesValue(int value) {
          ensureSectionTypesIsMutable();
          sectionTypes_.add(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The selected sections chosen to return when requesting a summary of a
         * conversation. A duplicate selected section will be treated as a single
         * selected section. If section types are not provided, the default will
         * be {SITUATION, ACTION, RESULT}.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections.SectionType section_types = 1;
         * </code>
         *
         * @param values The enum numeric values on the wire for sectionTypes to add.
         * @return This builder for chaining.
         */
        public Builder addAllSectionTypesValue(java.lang.Iterable<java.lang.Integer> values) {
          ensureSectionTypesIsMutable();
          for (int value : values) {
            sectionTypes_.add(value);
          }
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections)
      private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .Sections();
      }

      public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .SuggestionQueryConfig.Sections
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Sections> PARSER =
          new com.google.protobuf.AbstractParser<Sections>() {
            @java.lang.Override
            public Sections parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Sections> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Sections> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .Sections
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    private int querySourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object querySource_;

    public enum QuerySourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      KNOWLEDGE_BASE_QUERY_SOURCE(1),
      DOCUMENT_QUERY_SOURCE(2),
      DIALOGFLOW_QUERY_SOURCE(3),
      QUERYSOURCE_NOT_SET(0);
      private final int value;

      private QuerySourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static QuerySourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static QuerySourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return KNOWLEDGE_BASE_QUERY_SOURCE;
          case 2:
            return DOCUMENT_QUERY_SOURCE;
          case 3:
            return DIALOGFLOW_QUERY_SOURCE;
          case 0:
            return QUERYSOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public QuerySourceCase getQuerySourceCase() {
      return QuerySourceCase.forNumber(querySourceCase_);
    }

    public static final int KNOWLEDGE_BASE_QUERY_SOURCE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Query from knowledgebase. It is used by:
     * ARTICLE_SUGGESTION, FAQ.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
     * </code>
     *
     * @return Whether the knowledgeBaseQuerySource field is set.
     */
    @java.lang.Override
    public boolean hasKnowledgeBaseQuerySource() {
      return querySourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Query from knowledgebase. It is used by:
     * ARTICLE_SUGGESTION, FAQ.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
     * </code>
     *
     * @return The knowledgeBaseQuerySource.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .KnowledgeBaseQuerySource
        getKnowledgeBaseQuerySource() {
      if (querySourceCase_ == 1) {
        return (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .KnowledgeBaseQuerySource)
            querySource_;
      }
      return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
          .KnowledgeBaseQuerySource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Query from knowledgebase. It is used by:
     * ARTICLE_SUGGESTION, FAQ.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .KnowledgeBaseQuerySourceOrBuilder
        getKnowledgeBaseQuerySourceOrBuilder() {
      if (querySourceCase_ == 1) {
        return (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .KnowledgeBaseQuerySource)
            querySource_;
      }
      return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
          .KnowledgeBaseQuerySource.getDefaultInstance();
    }

    public static final int DOCUMENT_QUERY_SOURCE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Query from knowledge base document. It is used by:
     * SMART_REPLY, SMART_COMPOSE.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
     * </code>
     *
     * @return Whether the documentQuerySource field is set.
     */
    @java.lang.Override
    public boolean hasDocumentQuerySource() {
      return querySourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Query from knowledge base document. It is used by:
     * SMART_REPLY, SMART_COMPOSE.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
     * </code>
     *
     * @return The documentQuerySource.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .DocumentQuerySource
        getDocumentQuerySource() {
      if (querySourceCase_ == 2) {
        return (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DocumentQuerySource)
            querySource_;
      }
      return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
          .DocumentQuerySource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Query from knowledge base document. It is used by:
     * SMART_REPLY, SMART_COMPOSE.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .DocumentQuerySourceOrBuilder
        getDocumentQuerySourceOrBuilder() {
      if (querySourceCase_ == 2) {
        return (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DocumentQuerySource)
            querySource_;
      }
      return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
          .DocumentQuerySource.getDefaultInstance();
    }

    public static final int DIALOGFLOW_QUERY_SOURCE_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
     * ENTITY_EXTRACTION.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
     * </code>
     *
     * @return Whether the dialogflowQuerySource field is set.
     */
    @java.lang.Override
    public boolean hasDialogflowQuerySource() {
      return querySourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
     * ENTITY_EXTRACTION.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
     * </code>
     *
     * @return The dialogflowQuerySource.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .DialogflowQuerySource
        getDialogflowQuerySource() {
      if (querySourceCase_ == 3) {
        return (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource)
            querySource_;
      }
      return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
          .DialogflowQuerySource.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
     * ENTITY_EXTRACTION.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .DialogflowQuerySourceOrBuilder
        getDialogflowQuerySourceOrBuilder() {
      if (querySourceCase_ == 3) {
        return (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .DialogflowQuerySource)
            querySource_;
      }
      return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
          .DialogflowQuerySource.getDefaultInstance();
    }

    public static final int MAX_RESULTS_FIELD_NUMBER = 4;
    private int maxResults_ = 0;
    /**
     *
     *
     * <pre>
     * Maximum number of results to return. Currently, if unset, defaults to 10.
     * And the max number is 20.
     * </pre>
     *
     * <code>int32 max_results = 4;</code>
     *
     * @return The maxResults.
     */
    @java.lang.Override
    public int getMaxResults() {
      return maxResults_;
    }

    public static final int CONFIDENCE_THRESHOLD_FIELD_NUMBER = 5;
    private float confidenceThreshold_ = 0F;
    /**
     *
     *
     * <pre>
     * Confidence threshold of query result.
     *
     * Agent Assist gives each suggestion a score in the range [0.0, 1.0], based
     * on the relevance between the suggestion and the current conversation
     * context. A score of 0.0 has no relevance, while a score of 1.0 has high
     * relevance. Only suggestions with a score greater than or equal to the
     * value of this field are included in the results.
     *
     * For a baseline model (the default), the recommended value is in the range
     * [0.05, 0.1].
     *
     * For a custom model, there is no recommended value. Tune this value by
     * starting from a very low value and slowly increasing until you have
     * desired results.
     *
     * If this field is not set, it is default to 0.0, which means that all
     * suggestions are returned.
     *
     * Supported features: ARTICLE_SUGGESTION, FAQ, SMART_REPLY, SMART_COMPOSE,
     * KNOWLEDGE_SEARCH, KNOWLEDGE_ASSIST, ENTITY_EXTRACTION.
     * </pre>
     *
     * <code>float confidence_threshold = 5;</code>
     *
     * @return The confidenceThreshold.
     */
    @java.lang.Override
    public float getConfidenceThreshold() {
      return confidenceThreshold_;
    }

    public static final int CONTEXT_FILTER_SETTINGS_FIELD_NUMBER = 7;
    private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .ContextFilterSettings
        contextFilterSettings_;
    /**
     *
     *
     * <pre>
     * Determines how recent conversation context is filtered when generating
     * suggestions. If unspecified, no messages will be dropped.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
     * </code>
     *
     * @return Whether the contextFilterSettings field is set.
     */
    @java.lang.Override
    public boolean hasContextFilterSettings() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Determines how recent conversation context is filtered when generating
     * suggestions. If unspecified, no messages will be dropped.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
     * </code>
     *
     * @return The contextFilterSettings.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .ContextFilterSettings
        getContextFilterSettings() {
      return contextFilterSettings_ == null
          ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .ContextFilterSettings.getDefaultInstance()
          : contextFilterSettings_;
    }
    /**
     *
     *
     * <pre>
     * Determines how recent conversation context is filtered when generating
     * suggestions. If unspecified, no messages will be dropped.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .ContextFilterSettingsOrBuilder
        getContextFilterSettingsOrBuilder() {
      return contextFilterSettings_ == null
          ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .ContextFilterSettings.getDefaultInstance()
          : contextFilterSettings_;
    }

    public static final int SECTIONS_FIELD_NUMBER = 8;
    private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .Sections
        sections_;
    /**
     *
     *
     * <pre>
     * Optional. The customized sections chosen to return when requesting a
     * summary of a conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sections field is set.
     */
    @java.lang.Override
    public boolean hasSections() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The customized sections chosen to return when requesting a
     * summary of a conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sections.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .Sections
        getSections() {
      return sections_ == null
          ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .Sections.getDefaultInstance()
          : sections_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The customized sections chosen to return when requesting a
     * summary of a conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .SectionsOrBuilder
        getSectionsOrBuilder() {
      return sections_ == null
          ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .Sections.getDefaultInstance()
          : sections_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (querySourceCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .KnowledgeBaseQuerySource)
                querySource_);
      }
      if (querySourceCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DocumentQuerySource)
                querySource_);
      }
      if (querySourceCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource)
                querySource_);
      }
      if (maxResults_ != 0) {
        output.writeInt32(4, maxResults_);
      }
      if (java.lang.Float.floatToRawIntBits(confidenceThreshold_) != 0) {
        output.writeFloat(5, confidenceThreshold_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(7, getContextFilterSettings());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(8, getSections());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (querySourceCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                        .KnowledgeBaseQuerySource)
                    querySource_);
      }
      if (querySourceCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                        .DocumentQuerySource)
                    querySource_);
      }
      if (querySourceCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                        .DialogflowQuerySource)
                    querySource_);
      }
      if (maxResults_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, maxResults_);
      }
      if (java.lang.Float.floatToRawIntBits(confidenceThreshold_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, confidenceThreshold_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(7, getContextFilterSettings());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getSections());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig other =
          (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig) obj;

      if (getMaxResults() != other.getMaxResults()) return false;
      if (java.lang.Float.floatToIntBits(getConfidenceThreshold())
          != java.lang.Float.floatToIntBits(other.getConfidenceThreshold())) return false;
      if (hasContextFilterSettings() != other.hasContextFilterSettings()) return false;
      if (hasContextFilterSettings()) {
        if (!getContextFilterSettings().equals(other.getContextFilterSettings())) return false;
      }
      if (hasSections() != other.hasSections()) return false;
      if (hasSections()) {
        if (!getSections().equals(other.getSections())) return false;
      }
      if (!getQuerySourceCase().equals(other.getQuerySourceCase())) return false;
      switch (querySourceCase_) {
        case 1:
          if (!getKnowledgeBaseQuerySource().equals(other.getKnowledgeBaseQuerySource()))
            return false;
          break;
        case 2:
          if (!getDocumentQuerySource().equals(other.getDocumentQuerySource())) return false;
          break;
        case 3:
          if (!getDialogflowQuerySource().equals(other.getDialogflowQuerySource())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MAX_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getMaxResults();
      hash = (37 * hash) + CONFIDENCE_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidenceThreshold());
      if (hasContextFilterSettings()) {
        hash = (37 * hash) + CONTEXT_FILTER_SETTINGS_FIELD_NUMBER;
        hash = (53 * hash) + getContextFilterSettings().hashCode();
      }
      if (hasSections()) {
        hash = (37 * hash) + SECTIONS_FIELD_NUMBER;
        hash = (53 * hash) + getSections().hashCode();
      }
      switch (querySourceCase_) {
        case 1:
          hash = (37 * hash) + KNOWLEDGE_BASE_QUERY_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getKnowledgeBaseQuerySource().hashCode();
          break;
        case 2:
          hash = (37 * hash) + DOCUMENT_QUERY_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getDocumentQuerySource().hashCode();
          break;
        case 3:
          hash = (37 * hash) + DIALOGFLOW_QUERY_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getDialogflowQuerySource().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config for suggestion query.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig)
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getContextFilterSettingsFieldBuilder();
          getSectionsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (knowledgeBaseQuerySourceBuilder_ != null) {
          knowledgeBaseQuerySourceBuilder_.clear();
        }
        if (documentQuerySourceBuilder_ != null) {
          documentQuerySourceBuilder_.clear();
        }
        if (dialogflowQuerySourceBuilder_ != null) {
          dialogflowQuerySourceBuilder_.clear();
        }
        maxResults_ = 0;
        confidenceThreshold_ = 0F;
        contextFilterSettings_ = null;
        if (contextFilterSettingsBuilder_ != null) {
          contextFilterSettingsBuilder_.dispose();
          contextFilterSettingsBuilder_ = null;
        }
        sections_ = null;
        if (sectionsBuilder_ != null) {
          sectionsBuilder_.dispose();
          sectionsBuilder_ = null;
        }
        querySourceCase_ = 0;
        querySource_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_SuggestionQueryConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
          build() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
          buildPartial() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig result =
            new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.maxResults_ = maxResults_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.confidenceThreshold_ = confidenceThreshold_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.contextFilterSettings_ =
              contextFilterSettingsBuilder_ == null
                  ? contextFilterSettings_
                  : contextFilterSettingsBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.sections_ = sectionsBuilder_ == null ? sections_ : sectionsBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              result) {
        result.querySourceCase_ = querySourceCase_;
        result.querySource_ = this.querySource_;
        if (querySourceCase_ == 1 && knowledgeBaseQuerySourceBuilder_ != null) {
          result.querySource_ = knowledgeBaseQuerySourceBuilder_.build();
        }
        if (querySourceCase_ == 2 && documentQuerySourceBuilder_ != null) {
          result.querySource_ = documentQuerySourceBuilder_.build();
        }
        if (querySourceCase_ == 3 && dialogflowQuerySourceBuilder_ != null) {
          result.querySource_ = dialogflowQuerySourceBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                .getDefaultInstance()) return this;
        if (other.getMaxResults() != 0) {
          setMaxResults(other.getMaxResults());
        }
        if (other.getConfidenceThreshold() != 0F) {
          setConfidenceThreshold(other.getConfidenceThreshold());
        }
        if (other.hasContextFilterSettings()) {
          mergeContextFilterSettings(other.getContextFilterSettings());
        }
        if (other.hasSections()) {
          mergeSections(other.getSections());
        }
        switch (other.getQuerySourceCase()) {
          case KNOWLEDGE_BASE_QUERY_SOURCE:
            {
              mergeKnowledgeBaseQuerySource(other.getKnowledgeBaseQuerySource());
              break;
            }
          case DOCUMENT_QUERY_SOURCE:
            {
              mergeDocumentQuerySource(other.getDocumentQuerySource());
              break;
            }
          case DIALOGFLOW_QUERY_SOURCE:
            {
              mergeDialogflowQuerySource(other.getDialogflowQuerySource());
              break;
            }
          case QUERYSOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getKnowledgeBaseQuerySourceFieldBuilder().getBuilder(), extensionRegistry);
                  querySourceCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getDocumentQuerySourceFieldBuilder().getBuilder(), extensionRegistry);
                  querySourceCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getDialogflowQuerySourceFieldBuilder().getBuilder(), extensionRegistry);
                  querySourceCase_ = 3;
                  break;
                } // case 26
              case 32:
                {
                  maxResults_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 45:
                {
                  confidenceThreshold_ = input.readFloat();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 45
              case 58:
                {
                  input.readMessage(
                      getContextFilterSettingsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(getSectionsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 66
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int querySourceCase_ = 0;
      private java.lang.Object querySource_;

      public QuerySourceCase getQuerySourceCase() {
        return QuerySourceCase.forNumber(querySourceCase_);
      }

      public Builder clearQuerySource() {
        querySourceCase_ = 0;
        querySource_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySource,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySource.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySourceOrBuilder>
          knowledgeBaseQuerySourceBuilder_;
      /**
       *
       *
       * <pre>
       * Query from knowledgebase. It is used by:
       * ARTICLE_SUGGESTION, FAQ.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
       * </code>
       *
       * @return Whether the knowledgeBaseQuerySource field is set.
       */
      @java.lang.Override
      public boolean hasKnowledgeBaseQuerySource() {
        return querySourceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Query from knowledgebase. It is used by:
       * ARTICLE_SUGGESTION, FAQ.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
       * </code>
       *
       * @return The knowledgeBaseQuerySource.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .KnowledgeBaseQuerySource
          getKnowledgeBaseQuerySource() {
        if (knowledgeBaseQuerySourceBuilder_ == null) {
          if (querySourceCase_ == 1) {
            return (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionQueryConfig.KnowledgeBaseQuerySource)
                querySource_;
          }
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .KnowledgeBaseQuerySource.getDefaultInstance();
        } else {
          if (querySourceCase_ == 1) {
            return knowledgeBaseQuerySourceBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .KnowledgeBaseQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Query from knowledgebase. It is used by:
       * ARTICLE_SUGGESTION, FAQ.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
       * </code>
       */
      public Builder setKnowledgeBaseQuerySource(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySource
              value) {
        if (knowledgeBaseQuerySourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          querySource_ = value;
          onChanged();
        } else {
          knowledgeBaseQuerySourceBuilder_.setMessage(value);
        }
        querySourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query from knowledgebase. It is used by:
       * ARTICLE_SUGGESTION, FAQ.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
       * </code>
       */
      public Builder setKnowledgeBaseQuerySource(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySource.Builder
              builderForValue) {
        if (knowledgeBaseQuerySourceBuilder_ == null) {
          querySource_ = builderForValue.build();
          onChanged();
        } else {
          knowledgeBaseQuerySourceBuilder_.setMessage(builderForValue.build());
        }
        querySourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query from knowledgebase. It is used by:
       * ARTICLE_SUGGESTION, FAQ.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
       * </code>
       */
      public Builder mergeKnowledgeBaseQuerySource(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySource
              value) {
        if (knowledgeBaseQuerySourceBuilder_ == null) {
          if (querySourceCase_ == 1
              && querySource_
                  != com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.KnowledgeBaseQuerySource.getDefaultInstance()) {
            querySource_ =
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .KnowledgeBaseQuerySource.newBuilder(
                        (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                                .SuggestionQueryConfig.KnowledgeBaseQuerySource)
                            querySource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            querySource_ = value;
          }
          onChanged();
        } else {
          if (querySourceCase_ == 1) {
            knowledgeBaseQuerySourceBuilder_.mergeFrom(value);
          } else {
            knowledgeBaseQuerySourceBuilder_.setMessage(value);
          }
        }
        querySourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query from knowledgebase. It is used by:
       * ARTICLE_SUGGESTION, FAQ.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
       * </code>
       */
      public Builder clearKnowledgeBaseQuerySource() {
        if (knowledgeBaseQuerySourceBuilder_ == null) {
          if (querySourceCase_ == 1) {
            querySourceCase_ = 0;
            querySource_ = null;
            onChanged();
          }
        } else {
          if (querySourceCase_ == 1) {
            querySourceCase_ = 0;
            querySource_ = null;
          }
          knowledgeBaseQuerySourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query from knowledgebase. It is used by:
       * ARTICLE_SUGGESTION, FAQ.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .KnowledgeBaseQuerySource.Builder
          getKnowledgeBaseQuerySourceBuilder() {
        return getKnowledgeBaseQuerySourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Query from knowledgebase. It is used by:
       * ARTICLE_SUGGESTION, FAQ.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .KnowledgeBaseQuerySourceOrBuilder
          getKnowledgeBaseQuerySourceOrBuilder() {
        if ((querySourceCase_ == 1) && (knowledgeBaseQuerySourceBuilder_ != null)) {
          return knowledgeBaseQuerySourceBuilder_.getMessageOrBuilder();
        } else {
          if (querySourceCase_ == 1) {
            return (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionQueryConfig.KnowledgeBaseQuerySource)
                querySource_;
          }
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .KnowledgeBaseQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Query from knowledgebase. It is used by:
       * ARTICLE_SUGGESTION, FAQ.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.KnowledgeBaseQuerySource knowledge_base_query_source = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySource,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySource.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .KnowledgeBaseQuerySourceOrBuilder>
          getKnowledgeBaseQuerySourceFieldBuilder() {
        if (knowledgeBaseQuerySourceBuilder_ == null) {
          if (!(querySourceCase_ == 1)) {
            querySource_ =
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .KnowledgeBaseQuerySource.getDefaultInstance();
          }
          knowledgeBaseQuerySourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.KnowledgeBaseQuerySource,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.KnowledgeBaseQuerySource.Builder,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.KnowledgeBaseQuerySourceOrBuilder>(
                  (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                          .SuggestionQueryConfig.KnowledgeBaseQuerySource)
                      querySource_,
                  getParentForChildren(),
                  isClean());
          querySource_ = null;
        }
        querySourceCase_ = 1;
        onChanged();
        return knowledgeBaseQuerySourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySource,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySource.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySourceOrBuilder>
          documentQuerySourceBuilder_;
      /**
       *
       *
       * <pre>
       * Query from knowledge base document. It is used by:
       * SMART_REPLY, SMART_COMPOSE.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
       * </code>
       *
       * @return Whether the documentQuerySource field is set.
       */
      @java.lang.Override
      public boolean hasDocumentQuerySource() {
        return querySourceCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Query from knowledge base document. It is used by:
       * SMART_REPLY, SMART_COMPOSE.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
       * </code>
       *
       * @return The documentQuerySource.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DocumentQuerySource
          getDocumentQuerySource() {
        if (documentQuerySourceBuilder_ == null) {
          if (querySourceCase_ == 2) {
            return (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionQueryConfig.DocumentQuerySource)
                querySource_;
          }
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DocumentQuerySource.getDefaultInstance();
        } else {
          if (querySourceCase_ == 2) {
            return documentQuerySourceBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DocumentQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Query from knowledge base document. It is used by:
       * SMART_REPLY, SMART_COMPOSE.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
       * </code>
       */
      public Builder setDocumentQuerySource(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySource
              value) {
        if (documentQuerySourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          querySource_ = value;
          onChanged();
        } else {
          documentQuerySourceBuilder_.setMessage(value);
        }
        querySourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query from knowledge base document. It is used by:
       * SMART_REPLY, SMART_COMPOSE.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
       * </code>
       */
      public Builder setDocumentQuerySource(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySource.Builder
              builderForValue) {
        if (documentQuerySourceBuilder_ == null) {
          querySource_ = builderForValue.build();
          onChanged();
        } else {
          documentQuerySourceBuilder_.setMessage(builderForValue.build());
        }
        querySourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query from knowledge base document. It is used by:
       * SMART_REPLY, SMART_COMPOSE.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
       * </code>
       */
      public Builder mergeDocumentQuerySource(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySource
              value) {
        if (documentQuerySourceBuilder_ == null) {
          if (querySourceCase_ == 2
              && querySource_
                  != com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DocumentQuerySource.getDefaultInstance()) {
            querySource_ =
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DocumentQuerySource.newBuilder(
                        (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                                .SuggestionQueryConfig.DocumentQuerySource)
                            querySource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            querySource_ = value;
          }
          onChanged();
        } else {
          if (querySourceCase_ == 2) {
            documentQuerySourceBuilder_.mergeFrom(value);
          } else {
            documentQuerySourceBuilder_.setMessage(value);
          }
        }
        querySourceCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query from knowledge base document. It is used by:
       * SMART_REPLY, SMART_COMPOSE.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
       * </code>
       */
      public Builder clearDocumentQuerySource() {
        if (documentQuerySourceBuilder_ == null) {
          if (querySourceCase_ == 2) {
            querySourceCase_ = 0;
            querySource_ = null;
            onChanged();
          }
        } else {
          if (querySourceCase_ == 2) {
            querySourceCase_ = 0;
            querySource_ = null;
          }
          documentQuerySourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query from knowledge base document. It is used by:
       * SMART_REPLY, SMART_COMPOSE.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DocumentQuerySource.Builder
          getDocumentQuerySourceBuilder() {
        return getDocumentQuerySourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Query from knowledge base document. It is used by:
       * SMART_REPLY, SMART_COMPOSE.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DocumentQuerySourceOrBuilder
          getDocumentQuerySourceOrBuilder() {
        if ((querySourceCase_ == 2) && (documentQuerySourceBuilder_ != null)) {
          return documentQuerySourceBuilder_.getMessageOrBuilder();
        } else {
          if (querySourceCase_ == 2) {
            return (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionQueryConfig.DocumentQuerySource)
                querySource_;
          }
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DocumentQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Query from knowledge base document. It is used by:
       * SMART_REPLY, SMART_COMPOSE.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DocumentQuerySource document_query_source = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySource,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySource.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DocumentQuerySourceOrBuilder>
          getDocumentQuerySourceFieldBuilder() {
        if (documentQuerySourceBuilder_ == null) {
          if (!(querySourceCase_ == 2)) {
            querySource_ =
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DocumentQuerySource.getDefaultInstance();
          }
          documentQuerySourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DocumentQuerySource,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DocumentQuerySource.Builder,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DocumentQuerySourceOrBuilder>(
                  (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                          .SuggestionQueryConfig.DocumentQuerySource)
                      querySource_,
                  getParentForChildren(),
                  isClean());
          querySource_ = null;
        }
        querySourceCase_ = 2;
        onChanged();
        return documentQuerySourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySourceOrBuilder>
          dialogflowQuerySourceBuilder_;
      /**
       *
       *
       * <pre>
       * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
       * ENTITY_EXTRACTION.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
       * </code>
       *
       * @return Whether the dialogflowQuerySource field is set.
       */
      @java.lang.Override
      public boolean hasDialogflowQuerySource() {
        return querySourceCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
       * ENTITY_EXTRACTION.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
       * </code>
       *
       * @return The dialogflowQuerySource.
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySource
          getDialogflowQuerySource() {
        if (dialogflowQuerySourceBuilder_ == null) {
          if (querySourceCase_ == 3) {
            return (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionQueryConfig.DialogflowQuerySource)
                querySource_;
          }
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySource.getDefaultInstance();
        } else {
          if (querySourceCase_ == 3) {
            return dialogflowQuerySourceBuilder_.getMessage();
          }
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
       * ENTITY_EXTRACTION.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
       * </code>
       */
      public Builder setDialogflowQuerySource(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource
              value) {
        if (dialogflowQuerySourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          querySource_ = value;
          onChanged();
        } else {
          dialogflowQuerySourceBuilder_.setMessage(value);
        }
        querySourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
       * ENTITY_EXTRACTION.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
       * </code>
       */
      public Builder setDialogflowQuerySource(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource.Builder
              builderForValue) {
        if (dialogflowQuerySourceBuilder_ == null) {
          querySource_ = builderForValue.build();
          onChanged();
        } else {
          dialogflowQuerySourceBuilder_.setMessage(builderForValue.build());
        }
        querySourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
       * ENTITY_EXTRACTION.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
       * </code>
       */
      public Builder mergeDialogflowQuerySource(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource
              value) {
        if (dialogflowQuerySourceBuilder_ == null) {
          if (querySourceCase_ == 3
              && querySource_
                  != com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DialogflowQuerySource.getDefaultInstance()) {
            querySource_ =
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.newBuilder(
                        (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                                .SuggestionQueryConfig.DialogflowQuerySource)
                            querySource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            querySource_ = value;
          }
          onChanged();
        } else {
          if (querySourceCase_ == 3) {
            dialogflowQuerySourceBuilder_.mergeFrom(value);
          } else {
            dialogflowQuerySourceBuilder_.setMessage(value);
          }
        }
        querySourceCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
       * ENTITY_EXTRACTION.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
       * </code>
       */
      public Builder clearDialogflowQuerySource() {
        if (dialogflowQuerySourceBuilder_ == null) {
          if (querySourceCase_ == 3) {
            querySourceCase_ = 0;
            querySource_ = null;
            onChanged();
          }
        } else {
          if (querySourceCase_ == 3) {
            querySourceCase_ = 0;
            querySource_ = null;
          }
          dialogflowQuerySourceBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
       * ENTITY_EXTRACTION.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySource.Builder
          getDialogflowQuerySourceBuilder() {
        return getDialogflowQuerySourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
       * ENTITY_EXTRACTION.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySourceOrBuilder
          getDialogflowQuerySourceOrBuilder() {
        if ((querySourceCase_ == 3) && (dialogflowQuerySourceBuilder_ != null)) {
          return dialogflowQuerySourceBuilder_.getMessageOrBuilder();
        } else {
          if (querySourceCase_ == 3) {
            return (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionQueryConfig.DialogflowQuerySource)
                querySource_;
          }
          return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .DialogflowQuerySource.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST,
       * ENTITY_EXTRACTION.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.DialogflowQuerySource dialogflow_query_source = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySource.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .DialogflowQuerySourceOrBuilder>
          getDialogflowQuerySourceFieldBuilder() {
        if (dialogflowQuerySourceBuilder_ == null) {
          if (!(querySourceCase_ == 3)) {
            querySource_ =
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                    .DialogflowQuerySource.getDefaultInstance();
          }
          dialogflowQuerySourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DialogflowQuerySource,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DialogflowQuerySource.Builder,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.DialogflowQuerySourceOrBuilder>(
                  (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                          .SuggestionQueryConfig.DialogflowQuerySource)
                      querySource_,
                  getParentForChildren(),
                  isClean());
          querySource_ = null;
        }
        querySourceCase_ = 3;
        onChanged();
        return dialogflowQuerySourceBuilder_;
      }

      private int maxResults_;
      /**
       *
       *
       * <pre>
       * Maximum number of results to return. Currently, if unset, defaults to 10.
       * And the max number is 20.
       * </pre>
       *
       * <code>int32 max_results = 4;</code>
       *
       * @return The maxResults.
       */
      @java.lang.Override
      public int getMaxResults() {
        return maxResults_;
      }
      /**
       *
       *
       * <pre>
       * Maximum number of results to return. Currently, if unset, defaults to 10.
       * And the max number is 20.
       * </pre>
       *
       * <code>int32 max_results = 4;</code>
       *
       * @param value The maxResults to set.
       * @return This builder for chaining.
       */
      public Builder setMaxResults(int value) {

        maxResults_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Maximum number of results to return. Currently, if unset, defaults to 10.
       * And the max number is 20.
       * </pre>
       *
       * <code>int32 max_results = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxResults() {
        bitField0_ = (bitField0_ & ~0x00000008);
        maxResults_ = 0;
        onChanged();
        return this;
      }

      private float confidenceThreshold_;
      /**
       *
       *
       * <pre>
       * Confidence threshold of query result.
       *
       * Agent Assist gives each suggestion a score in the range [0.0, 1.0], based
       * on the relevance between the suggestion and the current conversation
       * context. A score of 0.0 has no relevance, while a score of 1.0 has high
       * relevance. Only suggestions with a score greater than or equal to the
       * value of this field are included in the results.
       *
       * For a baseline model (the default), the recommended value is in the range
       * [0.05, 0.1].
       *
       * For a custom model, there is no recommended value. Tune this value by
       * starting from a very low value and slowly increasing until you have
       * desired results.
       *
       * If this field is not set, it is default to 0.0, which means that all
       * suggestions are returned.
       *
       * Supported features: ARTICLE_SUGGESTION, FAQ, SMART_REPLY, SMART_COMPOSE,
       * KNOWLEDGE_SEARCH, KNOWLEDGE_ASSIST, ENTITY_EXTRACTION.
       * </pre>
       *
       * <code>float confidence_threshold = 5;</code>
       *
       * @return The confidenceThreshold.
       */
      @java.lang.Override
      public float getConfidenceThreshold() {
        return confidenceThreshold_;
      }
      /**
       *
       *
       * <pre>
       * Confidence threshold of query result.
       *
       * Agent Assist gives each suggestion a score in the range [0.0, 1.0], based
       * on the relevance between the suggestion and the current conversation
       * context. A score of 0.0 has no relevance, while a score of 1.0 has high
       * relevance. Only suggestions with a score greater than or equal to the
       * value of this field are included in the results.
       *
       * For a baseline model (the default), the recommended value is in the range
       * [0.05, 0.1].
       *
       * For a custom model, there is no recommended value. Tune this value by
       * starting from a very low value and slowly increasing until you have
       * desired results.
       *
       * If this field is not set, it is default to 0.0, which means that all
       * suggestions are returned.
       *
       * Supported features: ARTICLE_SUGGESTION, FAQ, SMART_REPLY, SMART_COMPOSE,
       * KNOWLEDGE_SEARCH, KNOWLEDGE_ASSIST, ENTITY_EXTRACTION.
       * </pre>
       *
       * <code>float confidence_threshold = 5;</code>
       *
       * @param value The confidenceThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setConfidenceThreshold(float value) {

        confidenceThreshold_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Confidence threshold of query result.
       *
       * Agent Assist gives each suggestion a score in the range [0.0, 1.0], based
       * on the relevance between the suggestion and the current conversation
       * context. A score of 0.0 has no relevance, while a score of 1.0 has high
       * relevance. Only suggestions with a score greater than or equal to the
       * value of this field are included in the results.
       *
       * For a baseline model (the default), the recommended value is in the range
       * [0.05, 0.1].
       *
       * For a custom model, there is no recommended value. Tune this value by
       * starting from a very low value and slowly increasing until you have
       * desired results.
       *
       * If this field is not set, it is default to 0.0, which means that all
       * suggestions are returned.
       *
       * Supported features: ARTICLE_SUGGESTION, FAQ, SMART_REPLY, SMART_COMPOSE,
       * KNOWLEDGE_SEARCH, KNOWLEDGE_ASSIST, ENTITY_EXTRACTION.
       * </pre>
       *
       * <code>float confidence_threshold = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConfidenceThreshold() {
        bitField0_ = (bitField0_ & ~0x00000010);
        confidenceThreshold_ = 0F;
        onChanged();
        return this;
      }

      private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .ContextFilterSettings
          contextFilterSettings_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettingsOrBuilder>
          contextFilterSettingsBuilder_;
      /**
       *
       *
       * <pre>
       * Determines how recent conversation context is filtered when generating
       * suggestions. If unspecified, no messages will be dropped.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
       * </code>
       *
       * @return Whether the contextFilterSettings field is set.
       */
      public boolean hasContextFilterSettings() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Determines how recent conversation context is filtered when generating
       * suggestions. If unspecified, no messages will be dropped.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
       * </code>
       *
       * @return The contextFilterSettings.
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .ContextFilterSettings
          getContextFilterSettings() {
        if (contextFilterSettingsBuilder_ == null) {
          return contextFilterSettings_ == null
              ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings.getDefaultInstance()
              : contextFilterSettings_;
        } else {
          return contextFilterSettingsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Determines how recent conversation context is filtered when generating
       * suggestions. If unspecified, no messages will be dropped.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
       * </code>
       */
      public Builder setContextFilterSettings(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings
              value) {
        if (contextFilterSettingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          contextFilterSettings_ = value;
        } else {
          contextFilterSettingsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Determines how recent conversation context is filtered when generating
       * suggestions. If unspecified, no messages will be dropped.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
       * </code>
       */
      public Builder setContextFilterSettings(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings.Builder
              builderForValue) {
        if (contextFilterSettingsBuilder_ == null) {
          contextFilterSettings_ = builderForValue.build();
        } else {
          contextFilterSettingsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Determines how recent conversation context is filtered when generating
       * suggestions. If unspecified, no messages will be dropped.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
       * </code>
       */
      public Builder mergeContextFilterSettings(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings
              value) {
        if (contextFilterSettingsBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && contextFilterSettings_ != null
              && contextFilterSettings_
                  != com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.ContextFilterSettings.getDefaultInstance()) {
            getContextFilterSettingsBuilder().mergeFrom(value);
          } else {
            contextFilterSettings_ = value;
          }
        } else {
          contextFilterSettingsBuilder_.mergeFrom(value);
        }
        if (contextFilterSettings_ != null) {
          bitField0_ |= 0x00000020;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Determines how recent conversation context is filtered when generating
       * suggestions. If unspecified, no messages will be dropped.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
       * </code>
       */
      public Builder clearContextFilterSettings() {
        bitField0_ = (bitField0_ & ~0x00000020);
        contextFilterSettings_ = null;
        if (contextFilterSettingsBuilder_ != null) {
          contextFilterSettingsBuilder_.dispose();
          contextFilterSettingsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Determines how recent conversation context is filtered when generating
       * suggestions. If unspecified, no messages will be dropped.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .ContextFilterSettings.Builder
          getContextFilterSettingsBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getContextFilterSettingsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Determines how recent conversation context is filtered when generating
       * suggestions. If unspecified, no messages will be dropped.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .ContextFilterSettingsOrBuilder
          getContextFilterSettingsOrBuilder() {
        if (contextFilterSettingsBuilder_ != null) {
          return contextFilterSettingsBuilder_.getMessageOrBuilder();
        } else {
          return contextFilterSettings_ == null
              ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings.getDefaultInstance()
              : contextFilterSettings_;
        }
      }
      /**
       *
       *
       * <pre>
       * Determines how recent conversation context is filtered when generating
       * suggestions. If unspecified, no messages will be dropped.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.ContextFilterSettings context_filter_settings = 7;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettings.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .ContextFilterSettingsOrBuilder>
          getContextFilterSettingsFieldBuilder() {
        if (contextFilterSettingsBuilder_ == null) {
          contextFilterSettingsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.ContextFilterSettings,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.ContextFilterSettings.Builder,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.ContextFilterSettingsOrBuilder>(
                  getContextFilterSettings(), getParentForChildren(), isClean());
          contextFilterSettings_ = null;
        }
        return contextFilterSettingsBuilder_;
      }

      private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .Sections
          sections_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .SectionsOrBuilder>
          sectionsBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. The customized sections chosen to return when requesting a
       * summary of a conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the sections field is set.
       */
      public boolean hasSections() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The customized sections chosen to return when requesting a
       * summary of a conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The sections.
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .Sections
          getSections() {
        if (sectionsBuilder_ == null) {
          return sections_ == null
              ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections.getDefaultInstance()
              : sections_;
        } else {
          return sectionsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The customized sections chosen to return when requesting a
       * summary of a conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSections(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections
              value) {
        if (sectionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          sections_ = value;
        } else {
          sectionsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The customized sections chosen to return when requesting a
       * summary of a conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSections(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections.Builder
              builderForValue) {
        if (sectionsBuilder_ == null) {
          sections_ = builderForValue.build();
        } else {
          sectionsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The customized sections chosen to return when requesting a
       * summary of a conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeSections(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections
              value) {
        if (sectionsBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && sections_ != null
              && sections_
                  != com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.Sections.getDefaultInstance()) {
            getSectionsBuilder().mergeFrom(value);
          } else {
            sections_ = value;
          }
        } else {
          sectionsBuilder_.mergeFrom(value);
        }
        if (sections_ != null) {
          bitField0_ |= 0x00000040;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The customized sections chosen to return when requesting a
       * summary of a conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearSections() {
        bitField0_ = (bitField0_ & ~0x00000040);
        sections_ = null;
        if (sectionsBuilder_ != null) {
          sectionsBuilder_.dispose();
          sectionsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The customized sections chosen to return when requesting a
       * summary of a conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .Sections.Builder
          getSectionsBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getSectionsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. The customized sections chosen to return when requesting a
       * summary of a conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
              .SectionsOrBuilder
          getSectionsOrBuilder() {
        if (sectionsBuilder_ != null) {
          return sectionsBuilder_.getMessageOrBuilder();
        } else {
          return sections_ == null
              ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections.getDefaultInstance()
              : sections_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The customized sections chosen to return when requesting a
       * summary of a conversation.
       * </pre>
       *
       * <code>
       * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig.Sections sections = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .Sections.Builder,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
                  .SectionsOrBuilder>
          getSectionsFieldBuilder() {
        if (sectionsBuilder_ == null) {
          sectionsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.Sections,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.Sections.Builder,
                  com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .SuggestionQueryConfig.SectionsOrBuilder>(
                  getSections(), getParentForChildren(), isClean());
          sections_ = null;
        }
        return sectionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig)
    private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig();
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .SuggestionQueryConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SuggestionQueryConfig> PARSER =
        new com.google.protobuf.AbstractParser<SuggestionQueryConfig>() {
          @java.lang.Override
          public SuggestionQueryConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SuggestionQueryConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SuggestionQueryConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionQueryConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConversationModelConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Conversation model resource name. Format: `projects/&lt;Project
     * ID&gt;/conversationModels/&lt;Model ID&gt;`.
     * </pre>
     *
     * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The model.
     */
    java.lang.String getModel();
    /**
     *
     *
     * <pre>
     * Conversation model resource name. Format: `projects/&lt;Project
     * ID&gt;/conversationModels/&lt;Model ID&gt;`.
     * </pre>
     *
     * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for model.
     */
    com.google.protobuf.ByteString getModelBytes();

    /**
     *
     *
     * <pre>
     * Version of current baseline model. It will be ignored if
     * [model][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig.model]
     * is set. Valid versions are:
     *   Article Suggestion baseline model:
     *     - 0.9
     *     - 1.0 (default)
     *   Summarization baseline model:
     *     - 1.0
     * </pre>
     *
     * <code>string baseline_model_version = 8;</code>
     *
     * @return The baselineModelVersion.
     */
    java.lang.String getBaselineModelVersion();
    /**
     *
     *
     * <pre>
     * Version of current baseline model. It will be ignored if
     * [model][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig.model]
     * is set. Valid versions are:
     *   Article Suggestion baseline model:
     *     - 0.9
     *     - 1.0 (default)
     *   Summarization baseline model:
     *     - 1.0
     * </pre>
     *
     * <code>string baseline_model_version = 8;</code>
     *
     * @return The bytes for baselineModelVersion.
     */
    com.google.protobuf.ByteString getBaselineModelVersionBytes();
  }
  /**
   *
   *
   * <pre>
   * Custom conversation models used in agent assist feature.
   *
   * Supported feature: ARTICLE_SUGGESTION, SMART_COMPOSE, SMART_REPLY,
   * CONVERSATION_SUMMARIZATION.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig}
   */
  public static final class ConversationModelConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig)
      ConversationModelConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConversationModelConfig.newBuilder() to construct.
    private ConversationModelConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConversationModelConfig() {
      model_ = "";
      baselineModelVersion_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConversationModelConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_ConversationModelConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_ConversationModelConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
                  .class,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
                  .Builder.class);
    }

    public static final int MODEL_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object model_ = "";
    /**
     *
     *
     * <pre>
     * Conversation model resource name. Format: `projects/&lt;Project
     * ID&gt;/conversationModels/&lt;Model ID&gt;`.
     * </pre>
     *
     * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The model.
     */
    @java.lang.Override
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Conversation model resource name. Format: `projects/&lt;Project
     * ID&gt;/conversationModels/&lt;Model ID&gt;`.
     * </pre>
     *
     * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for model.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BASELINE_MODEL_VERSION_FIELD_NUMBER = 8;

    @SuppressWarnings("serial")
    private volatile java.lang.Object baselineModelVersion_ = "";
    /**
     *
     *
     * <pre>
     * Version of current baseline model. It will be ignored if
     * [model][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig.model]
     * is set. Valid versions are:
     *   Article Suggestion baseline model:
     *     - 0.9
     *     - 1.0 (default)
     *   Summarization baseline model:
     *     - 1.0
     * </pre>
     *
     * <code>string baseline_model_version = 8;</code>
     *
     * @return The baselineModelVersion.
     */
    @java.lang.Override
    public java.lang.String getBaselineModelVersion() {
      java.lang.Object ref = baselineModelVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        baselineModelVersion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Version of current baseline model. It will be ignored if
     * [model][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig.model]
     * is set. Valid versions are:
     *   Article Suggestion baseline model:
     *     - 0.9
     *     - 1.0 (default)
     *   Summarization baseline model:
     *     - 1.0
     * </pre>
     *
     * <code>string baseline_model_version = 8;</code>
     *
     * @return The bytes for baselineModelVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBaselineModelVersionBytes() {
      java.lang.Object ref = baselineModelVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        baselineModelVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, model_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baselineModelVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, baselineModelVersion_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, model_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(baselineModelVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, baselineModelVersion_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig other =
          (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig)
              obj;

      if (!getModel().equals(other.getModel())) return false;
      if (!getBaselineModelVersion().equals(other.getBaselineModelVersion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getModel().hashCode();
      hash = (37 * hash) + BASELINE_MODEL_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getBaselineModelVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Custom conversation models used in agent assist feature.
     *
     * Supported feature: ARTICLE_SUGGESTION, SMART_COMPOSE, SMART_REPLY,
     * CONVERSATION_SUMMARIZATION.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig)
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_ConversationModelConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_ConversationModelConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .ConversationModelConfig.class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .ConversationModelConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        model_ = "";
        baselineModelVersion_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_ConversationModelConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
          build() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
          buildPartial() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
            result =
                new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .ConversationModelConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.model_ = model_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.baselineModelVersion_ = baselineModelVersion_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .ConversationModelConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
              other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
                .getDefaultInstance()) return this;
        if (!other.getModel().isEmpty()) {
          model_ = other.model_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getBaselineModelVersion().isEmpty()) {
          baselineModelVersion_ = other.baselineModelVersion_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  model_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 66:
                {
                  baselineModelVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 66
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object model_ = "";
      /**
       *
       *
       * <pre>
       * Conversation model resource name. Format: `projects/&lt;Project
       * ID&gt;/conversationModels/&lt;Model ID&gt;`.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The model.
       */
      public java.lang.String getModel() {
        java.lang.Object ref = model_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          model_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Conversation model resource name. Format: `projects/&lt;Project
       * ID&gt;/conversationModels/&lt;Model ID&gt;`.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for model.
       */
      public com.google.protobuf.ByteString getModelBytes() {
        java.lang.Object ref = model_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          model_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Conversation model resource name. Format: `projects/&lt;Project
       * ID&gt;/conversationModels/&lt;Model ID&gt;`.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The model to set.
       * @return This builder for chaining.
       */
      public Builder setModel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        model_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conversation model resource name. Format: `projects/&lt;Project
       * ID&gt;/conversationModels/&lt;Model ID&gt;`.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModel() {
        model_ = getDefaultInstance().getModel();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Conversation model resource name. Format: `projects/&lt;Project
       * ID&gt;/conversationModels/&lt;Model ID&gt;`.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for model to set.
       * @return This builder for chaining.
       */
      public Builder setModelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        model_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object baselineModelVersion_ = "";
      /**
       *
       *
       * <pre>
       * Version of current baseline model. It will be ignored if
       * [model][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig.model]
       * is set. Valid versions are:
       *   Article Suggestion baseline model:
       *     - 0.9
       *     - 1.0 (default)
       *   Summarization baseline model:
       *     - 1.0
       * </pre>
       *
       * <code>string baseline_model_version = 8;</code>
       *
       * @return The baselineModelVersion.
       */
      public java.lang.String getBaselineModelVersion() {
        java.lang.Object ref = baselineModelVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          baselineModelVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Version of current baseline model. It will be ignored if
       * [model][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig.model]
       * is set. Valid versions are:
       *   Article Suggestion baseline model:
       *     - 0.9
       *     - 1.0 (default)
       *   Summarization baseline model:
       *     - 1.0
       * </pre>
       *
       * <code>string baseline_model_version = 8;</code>
       *
       * @return The bytes for baselineModelVersion.
       */
      public com.google.protobuf.ByteString getBaselineModelVersionBytes() {
        java.lang.Object ref = baselineModelVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          baselineModelVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Version of current baseline model. It will be ignored if
       * [model][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig.model]
       * is set. Valid versions are:
       *   Article Suggestion baseline model:
       *     - 0.9
       *     - 1.0 (default)
       *   Summarization baseline model:
       *     - 1.0
       * </pre>
       *
       * <code>string baseline_model_version = 8;</code>
       *
       * @param value The baselineModelVersion to set.
       * @return This builder for chaining.
       */
      public Builder setBaselineModelVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        baselineModelVersion_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Version of current baseline model. It will be ignored if
       * [model][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig.model]
       * is set. Valid versions are:
       *   Article Suggestion baseline model:
       *     - 0.9
       *     - 1.0 (default)
       *   Summarization baseline model:
       *     - 1.0
       * </pre>
       *
       * <code>string baseline_model_version = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBaselineModelVersion() {
        baselineModelVersion_ = getDefaultInstance().getBaselineModelVersion();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Version of current baseline model. It will be ignored if
       * [model][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig.model]
       * is set. Valid versions are:
       *   Article Suggestion baseline model:
       *     - 0.9
       *     - 1.0 (default)
       *   Summarization baseline model:
       *     - 1.0
       * </pre>
       *
       * <code>string baseline_model_version = 8;</code>
       *
       * @param value The bytes for baselineModelVersion to set.
       * @return This builder for chaining.
       */
      public Builder setBaselineModelVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        baselineModelVersion_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig)
    private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .ConversationModelConfig();
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationModelConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConversationModelConfig> PARSER =
        new com.google.protobuf.AbstractParser<ConversationModelConfig>() {
          @java.lang.Override
          public ConversationModelConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConversationModelConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConversationModelConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationModelConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConversationProcessConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Number of recent non-small-talk sentences to use as context for article
     * and FAQ suggestion
     * </pre>
     *
     * <code>int32 recent_sentences_count = 2;</code>
     *
     * @return The recentSentencesCount.
     */
    int getRecentSentencesCount();
  }
  /**
   *
   *
   * <pre>
   * Config to process conversation.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig}
   */
  public static final class ConversationProcessConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig)
      ConversationProcessConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConversationProcessConfig.newBuilder() to construct.
    private ConversationProcessConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConversationProcessConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConversationProcessConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_ConversationProcessConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_ConversationProcessConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationProcessConfig.class,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                  .ConversationProcessConfig.Builder.class);
    }

    public static final int RECENT_SENTENCES_COUNT_FIELD_NUMBER = 2;
    private int recentSentencesCount_ = 0;
    /**
     *
     *
     * <pre>
     * Number of recent non-small-talk sentences to use as context for article
     * and FAQ suggestion
     * </pre>
     *
     * <code>int32 recent_sentences_count = 2;</code>
     *
     * @return The recentSentencesCount.
     */
    @java.lang.Override
    public int getRecentSentencesCount() {
      return recentSentencesCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (recentSentencesCount_ != 0) {
        output.writeInt32(2, recentSentencesCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (recentSentencesCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, recentSentencesCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .ConversationProcessConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
          other =
              (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .ConversationProcessConfig)
                  obj;

      if (getRecentSentencesCount() != other.getRecentSentencesCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RECENT_SENTENCES_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getRecentSentencesCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Config to process conversation.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig)
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_ConversationProcessConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_ConversationProcessConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .ConversationProcessConfig.class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .ConversationProcessConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        recentSentencesCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_ConversationProcessConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
          build() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
          buildPartial() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
            result =
                new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .ConversationProcessConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.recentSentencesCount_ = recentSentencesCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .ConversationProcessConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                      .ConversationProcessConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
              other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .ConversationProcessConfig.getDefaultInstance()) return this;
        if (other.getRecentSentencesCount() != 0) {
          setRecentSentencesCount(other.getRecentSentencesCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 16:
                {
                  recentSentencesCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int recentSentencesCount_;
      /**
       *
       *
       * <pre>
       * Number of recent non-small-talk sentences to use as context for article
       * and FAQ suggestion
       * </pre>
       *
       * <code>int32 recent_sentences_count = 2;</code>
       *
       * @return The recentSentencesCount.
       */
      @java.lang.Override
      public int getRecentSentencesCount() {
        return recentSentencesCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of recent non-small-talk sentences to use as context for article
       * and FAQ suggestion
       * </pre>
       *
       * <code>int32 recent_sentences_count = 2;</code>
       *
       * @param value The recentSentencesCount to set.
       * @return This builder for chaining.
       */
      public Builder setRecentSentencesCount(int value) {

        recentSentencesCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of recent non-small-talk sentences to use as context for article
       * and FAQ suggestion
       * </pre>
       *
       * <code>int32 recent_sentences_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecentSentencesCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        recentSentencesCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig)
    private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
              .ConversationProcessConfig();
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .ConversationProcessConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConversationProcessConfig> PARSER =
        new com.google.protobuf.AbstractParser<ConversationProcessConfig>() {
          @java.lang.Override
          public ConversationProcessConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConversationProcessConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConversationProcessConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.ConversationProcessConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MessageAnalysisConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Enable entity extraction in conversation messages on [agent assist
     * stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
     * If unspecified, defaults to false.
     *
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>bool enable_entity_extraction = 2;</code>
     *
     * @return The enableEntityExtraction.
     */
    boolean getEnableEntityExtraction();

    /**
     *
     *
     * <pre>
     * Enable sentiment analysis in conversation messages on [agent assist
     * stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
     * If unspecified, defaults to false. Sentiment analysis inspects user input
     * and identifies the prevailing subjective opinion, especially to determine
     * a user's attitude as positive, negative, or neutral:
     * https://cloud.google.com/natural-language/docs/basics#sentiment_analysis
     * For
     * [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent]
     * method, result will be in
     * [StreamingAnalyzeContentResponse.message.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.message].
     * For
     * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
     * method, result will be in
     * [AnalyzeContentResponse.message.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.AnalyzeContentResponse.message]
     * For
     * [Conversations.ListMessages][google.cloud.dialogflow.v2beta1.Conversations.ListMessages]
     * method, result will be in
     * [ListMessagesResponse.messages.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.ListMessagesResponse.messages]
     * If Pub/Sub notification is configured, result will be in
     * [ConversationEvent.new_message_payload.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.ConversationEvent.new_message_payload].
     * </pre>
     *
     * <code>bool enable_sentiment_analysis = 3;</code>
     *
     * @return The enableSentimentAnalysis.
     */
    boolean getEnableSentimentAnalysis();
  }
  /**
   *
   *
   * <pre>
   * Configuration for analyses to run on each conversation message.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig}
   */
  public static final class MessageAnalysisConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig)
      MessageAnalysisConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MessageAnalysisConfig.newBuilder() to construct.
    private MessageAnalysisConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MessageAnalysisConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MessageAnalysisConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_MessageAnalysisConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_MessageAnalysisConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
                  .class,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
                  .Builder.class);
    }

    public static final int ENABLE_ENTITY_EXTRACTION_FIELD_NUMBER = 2;
    private boolean enableEntityExtraction_ = false;
    /**
     *
     *
     * <pre>
     * Enable entity extraction in conversation messages on [agent assist
     * stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
     * If unspecified, defaults to false.
     *
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>bool enable_entity_extraction = 2;</code>
     *
     * @return The enableEntityExtraction.
     */
    @java.lang.Override
    public boolean getEnableEntityExtraction() {
      return enableEntityExtraction_;
    }

    public static final int ENABLE_SENTIMENT_ANALYSIS_FIELD_NUMBER = 3;
    private boolean enableSentimentAnalysis_ = false;
    /**
     *
     *
     * <pre>
     * Enable sentiment analysis in conversation messages on [agent assist
     * stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
     * If unspecified, defaults to false. Sentiment analysis inspects user input
     * and identifies the prevailing subjective opinion, especially to determine
     * a user's attitude as positive, negative, or neutral:
     * https://cloud.google.com/natural-language/docs/basics#sentiment_analysis
     * For
     * [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent]
     * method, result will be in
     * [StreamingAnalyzeContentResponse.message.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.message].
     * For
     * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
     * method, result will be in
     * [AnalyzeContentResponse.message.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.AnalyzeContentResponse.message]
     * For
     * [Conversations.ListMessages][google.cloud.dialogflow.v2beta1.Conversations.ListMessages]
     * method, result will be in
     * [ListMessagesResponse.messages.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.ListMessagesResponse.messages]
     * If Pub/Sub notification is configured, result will be in
     * [ConversationEvent.new_message_payload.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.ConversationEvent.new_message_payload].
     * </pre>
     *
     * <code>bool enable_sentiment_analysis = 3;</code>
     *
     * @return The enableSentimentAnalysis.
     */
    @java.lang.Override
    public boolean getEnableSentimentAnalysis() {
      return enableSentimentAnalysis_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (enableEntityExtraction_ != false) {
        output.writeBool(2, enableEntityExtraction_);
      }
      if (enableSentimentAnalysis_ != false) {
        output.writeBool(3, enableSentimentAnalysis_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (enableEntityExtraction_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, enableEntityExtraction_);
      }
      if (enableSentimentAnalysis_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, enableSentimentAnalysis_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig other =
          (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig) obj;

      if (getEnableEntityExtraction() != other.getEnableEntityExtraction()) return false;
      if (getEnableSentimentAnalysis() != other.getEnableSentimentAnalysis()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENABLE_ENTITY_EXTRACTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableEntityExtraction());
      hash = (37 * hash) + ENABLE_SENTIMENT_ANALYSIS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableSentimentAnalysis());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for analyses to run on each conversation message.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig)
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_MessageAnalysisConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_MessageAnalysisConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
                    .class,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        enableEntityExtraction_ = false;
        enableSentimentAnalysis_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
            .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_MessageAnalysisConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
          build() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
          buildPartial() {
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig result =
            new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.enableEntityExtraction_ = enableEntityExtraction_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.enableSentimentAnalysis_ = enableSentimentAnalysis_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
              other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
                .getDefaultInstance()) return this;
        if (other.getEnableEntityExtraction() != false) {
          setEnableEntityExtraction(other.getEnableEntityExtraction());
        }
        if (other.getEnableSentimentAnalysis() != false) {
          setEnableSentimentAnalysis(other.getEnableSentimentAnalysis());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 16:
                {
                  enableEntityExtraction_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 16
              case 24:
                {
                  enableSentimentAnalysis_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean enableEntityExtraction_;
      /**
       *
       *
       * <pre>
       * Enable entity extraction in conversation messages on [agent assist
       * stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
       * If unspecified, defaults to false.
       *
       * Currently, this feature is not general available, please contact Google
       * to get access.
       * </pre>
       *
       * <code>bool enable_entity_extraction = 2;</code>
       *
       * @return The enableEntityExtraction.
       */
      @java.lang.Override
      public boolean getEnableEntityExtraction() {
        return enableEntityExtraction_;
      }
      /**
       *
       *
       * <pre>
       * Enable entity extraction in conversation messages on [agent assist
       * stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
       * If unspecified, defaults to false.
       *
       * Currently, this feature is not general available, please contact Google
       * to get access.
       * </pre>
       *
       * <code>bool enable_entity_extraction = 2;</code>
       *
       * @param value The enableEntityExtraction to set.
       * @return This builder for chaining.
       */
      public Builder setEnableEntityExtraction(boolean value) {

        enableEntityExtraction_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enable entity extraction in conversation messages on [agent assist
       * stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
       * If unspecified, defaults to false.
       *
       * Currently, this feature is not general available, please contact Google
       * to get access.
       * </pre>
       *
       * <code>bool enable_entity_extraction = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableEntityExtraction() {
        bitField0_ = (bitField0_ & ~0x00000001);
        enableEntityExtraction_ = false;
        onChanged();
        return this;
      }

      private boolean enableSentimentAnalysis_;
      /**
       *
       *
       * <pre>
       * Enable sentiment analysis in conversation messages on [agent assist
       * stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
       * If unspecified, defaults to false. Sentiment analysis inspects user input
       * and identifies the prevailing subjective opinion, especially to determine
       * a user's attitude as positive, negative, or neutral:
       * https://cloud.google.com/natural-language/docs/basics#sentiment_analysis
       * For
       * [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent]
       * method, result will be in
       * [StreamingAnalyzeContentResponse.message.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.message].
       * For
       * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
       * method, result will be in
       * [AnalyzeContentResponse.message.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.AnalyzeContentResponse.message]
       * For
       * [Conversations.ListMessages][google.cloud.dialogflow.v2beta1.Conversations.ListMessages]
       * method, result will be in
       * [ListMessagesResponse.messages.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.ListMessagesResponse.messages]
       * If Pub/Sub notification is configured, result will be in
       * [ConversationEvent.new_message_payload.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.ConversationEvent.new_message_payload].
       * </pre>
       *
       * <code>bool enable_sentiment_analysis = 3;</code>
       *
       * @return The enableSentimentAnalysis.
       */
      @java.lang.Override
      public boolean getEnableSentimentAnalysis() {
        return enableSentimentAnalysis_;
      }
      /**
       *
       *
       * <pre>
       * Enable sentiment analysis in conversation messages on [agent assist
       * stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
       * If unspecified, defaults to false. Sentiment analysis inspects user input
       * and identifies the prevailing subjective opinion, especially to determine
       * a user's attitude as positive, negative, or neutral:
       * https://cloud.google.com/natural-language/docs/basics#sentiment_analysis
       * For
       * [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent]
       * method, result will be in
       * [StreamingAnalyzeContentResponse.message.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.message].
       * For
       * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
       * method, result will be in
       * [AnalyzeContentResponse.message.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.AnalyzeContentResponse.message]
       * For
       * [Conversations.ListMessages][google.cloud.dialogflow.v2beta1.Conversations.ListMessages]
       * method, result will be in
       * [ListMessagesResponse.messages.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.ListMessagesResponse.messages]
       * If Pub/Sub notification is configured, result will be in
       * [ConversationEvent.new_message_payload.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.ConversationEvent.new_message_payload].
       * </pre>
       *
       * <code>bool enable_sentiment_analysis = 3;</code>
       *
       * @param value The enableSentimentAnalysis to set.
       * @return This builder for chaining.
       */
      public Builder setEnableSentimentAnalysis(boolean value) {

        enableSentimentAnalysis_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Enable sentiment analysis in conversation messages on [agent assist
       * stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages).
       * If unspecified, defaults to false. Sentiment analysis inspects user input
       * and identifies the prevailing subjective opinion, especially to determine
       * a user's attitude as positive, negative, or neutral:
       * https://cloud.google.com/natural-language/docs/basics#sentiment_analysis
       * For
       * [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent]
       * method, result will be in
       * [StreamingAnalyzeContentResponse.message.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.message].
       * For
       * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
       * method, result will be in
       * [AnalyzeContentResponse.message.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.AnalyzeContentResponse.message]
       * For
       * [Conversations.ListMessages][google.cloud.dialogflow.v2beta1.Conversations.ListMessages]
       * method, result will be in
       * [ListMessagesResponse.messages.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.ListMessagesResponse.messages]
       * If Pub/Sub notification is configured, result will be in
       * [ConversationEvent.new_message_payload.SentimentAnalysisResult][google.cloud.dialogflow.v2beta1.ConversationEvent.new_message_payload].
       * </pre>
       *
       * <code>bool enable_sentiment_analysis = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEnableSentimentAnalysis() {
        bitField0_ = (bitField0_ & ~0x00000002);
        enableSentimentAnalysis_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig)
    private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig();
    }

    public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MessageAnalysisConfig> PARSER =
        new com.google.protobuf.AbstractParser<MessageAnalysisConfig>() {
          @java.lang.Override
          public MessageAnalysisConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MessageAnalysisConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MessageAnalysisConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NOTIFICATION_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.dialogflow.v2beta1.NotificationConfig notificationConfig_;
  /**
   *
   *
   * <pre>
   * Pub/Sub topic on which to publish new agent assistant events.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.NotificationConfig notification_config = 2;</code>
   *
   * @return Whether the notificationConfig field is set.
   */
  @java.lang.Override
  public boolean hasNotificationConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Pub/Sub topic on which to publish new agent assistant events.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.NotificationConfig notification_config = 2;</code>
   *
   * @return The notificationConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.NotificationConfig getNotificationConfig() {
    return notificationConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.NotificationConfig.getDefaultInstance()
        : notificationConfig_;
  }
  /**
   *
   *
   * <pre>
   * Pub/Sub topic on which to publish new agent assistant events.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.NotificationConfig notification_config = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.NotificationConfigOrBuilder
      getNotificationConfigOrBuilder() {
    return notificationConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.NotificationConfig.getDefaultInstance()
        : notificationConfig_;
  }

  public static final int HUMAN_AGENT_SUGGESTION_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
      humanAgentSuggestionConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for agent assistance of human agent participant.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig human_agent_suggestion_config = 3;
   * </code>
   *
   * @return Whether the humanAgentSuggestionConfig field is set.
   */
  @java.lang.Override
  public boolean hasHumanAgentSuggestionConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for agent assistance of human agent participant.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig human_agent_suggestion_config = 3;
   * </code>
   *
   * @return The humanAgentSuggestionConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
      getHumanAgentSuggestionConfig() {
    return humanAgentSuggestionConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
            .getDefaultInstance()
        : humanAgentSuggestionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for agent assistance of human agent participant.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig human_agent_suggestion_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfigOrBuilder
      getHumanAgentSuggestionConfigOrBuilder() {
    return humanAgentSuggestionConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
            .getDefaultInstance()
        : humanAgentSuggestionConfig_;
  }

  public static final int END_USER_SUGGESTION_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
      endUserSuggestionConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for agent assistance of end user participant.
   *
   * Currently, this feature is not general available, please contact Google
   * to get access.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig end_user_suggestion_config = 4;
   * </code>
   *
   * @return Whether the endUserSuggestionConfig field is set.
   */
  @java.lang.Override
  public boolean hasEndUserSuggestionConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for agent assistance of end user participant.
   *
   * Currently, this feature is not general available, please contact Google
   * to get access.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig end_user_suggestion_config = 4;
   * </code>
   *
   * @return The endUserSuggestionConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
      getEndUserSuggestionConfig() {
    return endUserSuggestionConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
            .getDefaultInstance()
        : endUserSuggestionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for agent assistance of end user participant.
   *
   * Currently, this feature is not general available, please contact Google
   * to get access.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig end_user_suggestion_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfigOrBuilder
      getEndUserSuggestionConfigOrBuilder() {
    return endUserSuggestionConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
            .getDefaultInstance()
        : endUserSuggestionConfig_;
  }

  public static final int MESSAGE_ANALYSIS_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
      messageAnalysisConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for message analysis.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig message_analysis_config = 5;
   * </code>
   *
   * @return Whether the messageAnalysisConfig field is set.
   */
  @java.lang.Override
  public boolean hasMessageAnalysisConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for message analysis.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig message_analysis_config = 5;
   * </code>
   *
   * @return The messageAnalysisConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
      getMessageAnalysisConfig() {
    return messageAnalysisConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
            .getDefaultInstance()
        : messageAnalysisConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for message analysis.
   * </pre>
   *
   * <code>
   * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig message_analysis_config = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
          .MessageAnalysisConfigOrBuilder
      getMessageAnalysisConfigOrBuilder() {
    return messageAnalysisConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
            .getDefaultInstance()
        : messageAnalysisConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getNotificationConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getHumanAgentSuggestionConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getEndUserSuggestionConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(5, getMessageAnalysisConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getNotificationConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, getHumanAgentSuggestionConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEndUserSuggestionConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMessageAnalysisConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig other =
        (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig) obj;

    if (hasNotificationConfig() != other.hasNotificationConfig()) return false;
    if (hasNotificationConfig()) {
      if (!getNotificationConfig().equals(other.getNotificationConfig())) return false;
    }
    if (hasHumanAgentSuggestionConfig() != other.hasHumanAgentSuggestionConfig()) return false;
    if (hasHumanAgentSuggestionConfig()) {
      if (!getHumanAgentSuggestionConfig().equals(other.getHumanAgentSuggestionConfig()))
        return false;
    }
    if (hasEndUserSuggestionConfig() != other.hasEndUserSuggestionConfig()) return false;
    if (hasEndUserSuggestionConfig()) {
      if (!getEndUserSuggestionConfig().equals(other.getEndUserSuggestionConfig())) return false;
    }
    if (hasMessageAnalysisConfig() != other.hasMessageAnalysisConfig()) return false;
    if (hasMessageAnalysisConfig()) {
      if (!getMessageAnalysisConfig().equals(other.getMessageAnalysisConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasNotificationConfig()) {
      hash = (37 * hash) + NOTIFICATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNotificationConfig().hashCode();
    }
    if (hasHumanAgentSuggestionConfig()) {
      hash = (37 * hash) + HUMAN_AGENT_SUGGESTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getHumanAgentSuggestionConfig().hashCode();
    }
    if (hasEndUserSuggestionConfig()) {
      hash = (37 * hash) + END_USER_SUGGESTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEndUserSuggestionConfig().hashCode();
    }
    if (hasMessageAnalysisConfig()) {
      hash = (37 * hash) + MESSAGE_ANALYSIS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getMessageAnalysisConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines the Human Agent Assistant to connect to a conversation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig)
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.class,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getNotificationConfigFieldBuilder();
        getHumanAgentSuggestionConfigFieldBuilder();
        getEndUserSuggestionConfigFieldBuilder();
        getMessageAnalysisConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      notificationConfig_ = null;
      if (notificationConfigBuilder_ != null) {
        notificationConfigBuilder_.dispose();
        notificationConfigBuilder_ = null;
      }
      humanAgentSuggestionConfig_ = null;
      if (humanAgentSuggestionConfigBuilder_ != null) {
        humanAgentSuggestionConfigBuilder_.dispose();
        humanAgentSuggestionConfigBuilder_ = null;
      }
      endUserSuggestionConfig_ = null;
      if (endUserSuggestionConfigBuilder_ != null) {
        endUserSuggestionConfigBuilder_.dispose();
        endUserSuggestionConfigBuilder_ = null;
      }
      messageAnalysisConfig_ = null;
      if (messageAnalysisConfigBuilder_ != null) {
        messageAnalysisConfigBuilder_.dispose();
        messageAnalysisConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProfileProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig build() {
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig buildPartial() {
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig result =
          new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.notificationConfig_ =
            notificationConfigBuilder_ == null
                ? notificationConfig_
                : notificationConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.humanAgentSuggestionConfig_ =
            humanAgentSuggestionConfigBuilder_ == null
                ? humanAgentSuggestionConfig_
                : humanAgentSuggestionConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.endUserSuggestionConfig_ =
            endUserSuggestionConfigBuilder_ == null
                ? endUserSuggestionConfig_
                : endUserSuggestionConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.messageAnalysisConfig_ =
            messageAnalysisConfigBuilder_ == null
                ? messageAnalysisConfig_
                : messageAnalysisConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig other) {
      if (other
          == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.getDefaultInstance())
        return this;
      if (other.hasNotificationConfig()) {
        mergeNotificationConfig(other.getNotificationConfig());
      }
      if (other.hasHumanAgentSuggestionConfig()) {
        mergeHumanAgentSuggestionConfig(other.getHumanAgentSuggestionConfig());
      }
      if (other.hasEndUserSuggestionConfig()) {
        mergeEndUserSuggestionConfig(other.getEndUserSuggestionConfig());
      }
      if (other.hasMessageAnalysisConfig()) {
        mergeMessageAnalysisConfig(other.getMessageAnalysisConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                input.readMessage(
                    getNotificationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getHumanAgentSuggestionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getEndUserSuggestionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getMessageAnalysisConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.dialogflow.v2beta1.NotificationConfig notificationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.NotificationConfig,
            com.google.cloud.dialogflow.v2beta1.NotificationConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.NotificationConfigOrBuilder>
        notificationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Pub/Sub topic on which to publish new agent assistant events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.NotificationConfig notification_config = 2;</code>
     *
     * @return Whether the notificationConfig field is set.
     */
    public boolean hasNotificationConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic on which to publish new agent assistant events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.NotificationConfig notification_config = 2;</code>
     *
     * @return The notificationConfig.
     */
    public com.google.cloud.dialogflow.v2beta1.NotificationConfig getNotificationConfig() {
      if (notificationConfigBuilder_ == null) {
        return notificationConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.NotificationConfig.getDefaultInstance()
            : notificationConfig_;
      } else {
        return notificationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic on which to publish new agent assistant events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.NotificationConfig notification_config = 2;</code>
     */
    public Builder setNotificationConfig(
        com.google.cloud.dialogflow.v2beta1.NotificationConfig value) {
      if (notificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        notificationConfig_ = value;
      } else {
        notificationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic on which to publish new agent assistant events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.NotificationConfig notification_config = 2;</code>
     */
    public Builder setNotificationConfig(
        com.google.cloud.dialogflow.v2beta1.NotificationConfig.Builder builderForValue) {
      if (notificationConfigBuilder_ == null) {
        notificationConfig_ = builderForValue.build();
      } else {
        notificationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic on which to publish new agent assistant events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.NotificationConfig notification_config = 2;</code>
     */
    public Builder mergeNotificationConfig(
        com.google.cloud.dialogflow.v2beta1.NotificationConfig value) {
      if (notificationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && notificationConfig_ != null
            && notificationConfig_
                != com.google.cloud.dialogflow.v2beta1.NotificationConfig.getDefaultInstance()) {
          getNotificationConfigBuilder().mergeFrom(value);
        } else {
          notificationConfig_ = value;
        }
      } else {
        notificationConfigBuilder_.mergeFrom(value);
      }
      if (notificationConfig_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic on which to publish new agent assistant events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.NotificationConfig notification_config = 2;</code>
     */
    public Builder clearNotificationConfig() {
      bitField0_ = (bitField0_ & ~0x00000001);
      notificationConfig_ = null;
      if (notificationConfigBuilder_ != null) {
        notificationConfigBuilder_.dispose();
        notificationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic on which to publish new agent assistant events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.NotificationConfig notification_config = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.NotificationConfig.Builder
        getNotificationConfigBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getNotificationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic on which to publish new agent assistant events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.NotificationConfig notification_config = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.NotificationConfigOrBuilder
        getNotificationConfigOrBuilder() {
      if (notificationConfigBuilder_ != null) {
        return notificationConfigBuilder_.getMessageOrBuilder();
      } else {
        return notificationConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.NotificationConfig.getDefaultInstance()
            : notificationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Pub/Sub topic on which to publish new agent assistant events.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.NotificationConfig notification_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.NotificationConfig,
            com.google.cloud.dialogflow.v2beta1.NotificationConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.NotificationConfigOrBuilder>
        getNotificationConfigFieldBuilder() {
      if (notificationConfigBuilder_ == null) {
        notificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.NotificationConfig,
                com.google.cloud.dialogflow.v2beta1.NotificationConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.NotificationConfigOrBuilder>(
                getNotificationConfig(), getParentForChildren(), isClean());
        notificationConfig_ = null;
      }
      return notificationConfigBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        humanAgentSuggestionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfigOrBuilder>
        humanAgentSuggestionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of human agent participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig human_agent_suggestion_config = 3;
     * </code>
     *
     * @return Whether the humanAgentSuggestionConfig field is set.
     */
    public boolean hasHumanAgentSuggestionConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of human agent participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig human_agent_suggestion_config = 3;
     * </code>
     *
     * @return The humanAgentSuggestionConfig.
     */
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        getHumanAgentSuggestionConfig() {
      if (humanAgentSuggestionConfigBuilder_ == null) {
        return humanAgentSuggestionConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
                .getDefaultInstance()
            : humanAgentSuggestionConfig_;
      } else {
        return humanAgentSuggestionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of human agent participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig human_agent_suggestion_config = 3;
     * </code>
     */
    public Builder setHumanAgentSuggestionConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig value) {
      if (humanAgentSuggestionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAgentSuggestionConfig_ = value;
      } else {
        humanAgentSuggestionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of human agent participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig human_agent_suggestion_config = 3;
     * </code>
     */
    public Builder setHumanAgentSuggestionConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.Builder
            builderForValue) {
      if (humanAgentSuggestionConfigBuilder_ == null) {
        humanAgentSuggestionConfig_ = builderForValue.build();
      } else {
        humanAgentSuggestionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of human agent participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig human_agent_suggestion_config = 3;
     * </code>
     */
    public Builder mergeHumanAgentSuggestionConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig value) {
      if (humanAgentSuggestionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && humanAgentSuggestionConfig_ != null
            && humanAgentSuggestionConfig_
                != com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
                    .getDefaultInstance()) {
          getHumanAgentSuggestionConfigBuilder().mergeFrom(value);
        } else {
          humanAgentSuggestionConfig_ = value;
        }
      } else {
        humanAgentSuggestionConfigBuilder_.mergeFrom(value);
      }
      if (humanAgentSuggestionConfig_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of human agent participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig human_agent_suggestion_config = 3;
     * </code>
     */
    public Builder clearHumanAgentSuggestionConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      humanAgentSuggestionConfig_ = null;
      if (humanAgentSuggestionConfigBuilder_ != null) {
        humanAgentSuggestionConfigBuilder_.dispose();
        humanAgentSuggestionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of human agent participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig human_agent_suggestion_config = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.Builder
        getHumanAgentSuggestionConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getHumanAgentSuggestionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of human agent participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig human_agent_suggestion_config = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfigOrBuilder
        getHumanAgentSuggestionConfigOrBuilder() {
      if (humanAgentSuggestionConfigBuilder_ != null) {
        return humanAgentSuggestionConfigBuilder_.getMessageOrBuilder();
      } else {
        return humanAgentSuggestionConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
                .getDefaultInstance()
            : humanAgentSuggestionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of human agent participant.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig human_agent_suggestion_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfigOrBuilder>
        getHumanAgentSuggestionConfigFieldBuilder() {
      if (humanAgentSuggestionConfigBuilder_ == null) {
        humanAgentSuggestionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
                    .Builder,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionConfigOrBuilder>(
                getHumanAgentSuggestionConfig(), getParentForChildren(), isClean());
        humanAgentSuggestionConfig_ = null;
      }
      return humanAgentSuggestionConfigBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        endUserSuggestionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfigOrBuilder>
        endUserSuggestionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of end user participant.
     *
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig end_user_suggestion_config = 4;
     * </code>
     *
     * @return Whether the endUserSuggestionConfig field is set.
     */
    public boolean hasEndUserSuggestionConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of end user participant.
     *
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig end_user_suggestion_config = 4;
     * </code>
     *
     * @return The endUserSuggestionConfig.
     */
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
        getEndUserSuggestionConfig() {
      if (endUserSuggestionConfigBuilder_ == null) {
        return endUserSuggestionConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
                .getDefaultInstance()
            : endUserSuggestionConfig_;
      } else {
        return endUserSuggestionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of end user participant.
     *
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig end_user_suggestion_config = 4;
     * </code>
     */
    public Builder setEndUserSuggestionConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig value) {
      if (endUserSuggestionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endUserSuggestionConfig_ = value;
      } else {
        endUserSuggestionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of end user participant.
     *
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig end_user_suggestion_config = 4;
     * </code>
     */
    public Builder setEndUserSuggestionConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.Builder
            builderForValue) {
      if (endUserSuggestionConfigBuilder_ == null) {
        endUserSuggestionConfig_ = builderForValue.build();
      } else {
        endUserSuggestionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of end user participant.
     *
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig end_user_suggestion_config = 4;
     * </code>
     */
    public Builder mergeEndUserSuggestionConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig value) {
      if (endUserSuggestionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && endUserSuggestionConfig_ != null
            && endUserSuggestionConfig_
                != com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
                    .getDefaultInstance()) {
          getEndUserSuggestionConfigBuilder().mergeFrom(value);
        } else {
          endUserSuggestionConfig_ = value;
        }
      } else {
        endUserSuggestionConfigBuilder_.mergeFrom(value);
      }
      if (endUserSuggestionConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of end user participant.
     *
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig end_user_suggestion_config = 4;
     * </code>
     */
    public Builder clearEndUserSuggestionConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      endUserSuggestionConfig_ = null;
      if (endUserSuggestionConfigBuilder_ != null) {
        endUserSuggestionConfigBuilder_.dispose();
        endUserSuggestionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of end user participant.
     *
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig end_user_suggestion_config = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.Builder
        getEndUserSuggestionConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getEndUserSuggestionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of end user participant.
     *
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig end_user_suggestion_config = 4;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfigOrBuilder
        getEndUserSuggestionConfigOrBuilder() {
      if (endUserSuggestionConfigBuilder_ != null) {
        return endUserSuggestionConfigBuilder_.getMessageOrBuilder();
      } else {
        return endUserSuggestionConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
                .getDefaultInstance()
            : endUserSuggestionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for agent assistance of end user participant.
     *
     * Currently, this feature is not general available, please contact Google
     * to get access.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig end_user_suggestion_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfigOrBuilder>
        getEndUserSuggestionConfigFieldBuilder() {
      if (endUserSuggestionConfigBuilder_ == null) {
        endUserSuggestionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig
                    .Builder,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .SuggestionConfigOrBuilder>(
                getEndUserSuggestionConfig(), getParentForChildren(), isClean());
        endUserSuggestionConfig_ = null;
      }
      return endUserSuggestionConfigBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
        messageAnalysisConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
                .Builder,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .MessageAnalysisConfigOrBuilder>
        messageAnalysisConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for message analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig message_analysis_config = 5;
     * </code>
     *
     * @return Whether the messageAnalysisConfig field is set.
     */
    public boolean hasMessageAnalysisConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for message analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig message_analysis_config = 5;
     * </code>
     *
     * @return The messageAnalysisConfig.
     */
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
        getMessageAnalysisConfig() {
      if (messageAnalysisConfigBuilder_ == null) {
        return messageAnalysisConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
                .getDefaultInstance()
            : messageAnalysisConfig_;
      } else {
        return messageAnalysisConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for message analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig message_analysis_config = 5;
     * </code>
     */
    public Builder setMessageAnalysisConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig value) {
      if (messageAnalysisConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        messageAnalysisConfig_ = value;
      } else {
        messageAnalysisConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for message analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig message_analysis_config = 5;
     * </code>
     */
    public Builder setMessageAnalysisConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig.Builder
            builderForValue) {
      if (messageAnalysisConfigBuilder_ == null) {
        messageAnalysisConfig_ = builderForValue.build();
      } else {
        messageAnalysisConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for message analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig message_analysis_config = 5;
     * </code>
     */
    public Builder mergeMessageAnalysisConfig(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig value) {
      if (messageAnalysisConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && messageAnalysisConfig_ != null
            && messageAnalysisConfig_
                != com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .MessageAnalysisConfig.getDefaultInstance()) {
          getMessageAnalysisConfigBuilder().mergeFrom(value);
        } else {
          messageAnalysisConfig_ = value;
        }
      } else {
        messageAnalysisConfigBuilder_.mergeFrom(value);
      }
      if (messageAnalysisConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for message analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig message_analysis_config = 5;
     * </code>
     */
    public Builder clearMessageAnalysisConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      messageAnalysisConfig_ = null;
      if (messageAnalysisConfigBuilder_ != null) {
        messageAnalysisConfigBuilder_.dispose();
        messageAnalysisConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for message analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig message_analysis_config = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
            .Builder
        getMessageAnalysisConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getMessageAnalysisConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for message analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig message_analysis_config = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
            .MessageAnalysisConfigOrBuilder
        getMessageAnalysisConfigOrBuilder() {
      if (messageAnalysisConfigBuilder_ != null) {
        return messageAnalysisConfigBuilder_.getMessageOrBuilder();
      } else {
        return messageAnalysisConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
                .getDefaultInstance()
            : messageAnalysisConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for message analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig message_analysis_config = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
                .Builder,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                .MessageAnalysisConfigOrBuilder>
        getMessageAnalysisConfigFieldBuilder() {
      if (messageAnalysisConfigBuilder_ == null) {
        messageAnalysisConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.MessageAnalysisConfig
                    .Builder,
                com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
                    .MessageAnalysisConfigOrBuilder>(
                getMessageAnalysisConfig(), getParentForChildren(), isClean());
        messageAnalysisConfig_ = null;
      }
      return messageAnalysisConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig)
  private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig();
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HumanAgentAssistantConfig> PARSER =
      new com.google.protobuf.AbstractParser<HumanAgentAssistantConfig>() {
        @java.lang.Override
        public HumanAgentAssistantConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HumanAgentAssistantConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HumanAgentAssistantConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
