/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/session.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents the result of conversational query or event processing.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.QueryResult}
 */
public final class QueryResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.QueryResult)
    QueryResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QueryResult.newBuilder() to construct.
  private QueryResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QueryResult() {
    queryText_ = "";
    languageCode_ = "";
    action_ = "";
    fulfillmentText_ = "";
    fulfillmentMessages_ = java.util.Collections.emptyList();
    webhookSource_ = "";
    outputContexts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QueryResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.SessionProto
        .internal_static_google_cloud_dialogflow_v2beta1_QueryResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.SessionProto
        .internal_static_google_cloud_dialogflow_v2beta1_QueryResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.QueryResult.class,
            com.google.cloud.dialogflow.v2beta1.QueryResult.Builder.class);
  }

  private int bitField0_;
  public static final int QUERY_TEXT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object queryText_ = "";
  /**
   *
   *
   * <pre>
   * The original conversational query text:
   *
   * - If natural language text was provided as input, `query_text` contains
   *   a copy of the input.
   * - If natural language speech audio was provided as input, `query_text`
   *   contains the speech recognition result. If speech recognizer produced
   *   multiple alternatives, a particular one is picked.
   * - If automatic spell correction is enabled, `query_text` will contain the
   *   corrected user input.
   * </pre>
   *
   * <code>string query_text = 1;</code>
   *
   * @return The queryText.
   */
  @java.lang.Override
  public java.lang.String getQueryText() {
    java.lang.Object ref = queryText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      queryText_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The original conversational query text:
   *
   * - If natural language text was provided as input, `query_text` contains
   *   a copy of the input.
   * - If natural language speech audio was provided as input, `query_text`
   *   contains the speech recognition result. If speech recognizer produced
   *   multiple alternatives, a particular one is picked.
   * - If automatic spell correction is enabled, `query_text` will contain the
   *   corrected user input.
   * </pre>
   *
   * <code>string query_text = 1;</code>
   *
   * @return The bytes for queryText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryTextBytes() {
    java.lang.Object ref = queryText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      queryText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * The language that was triggered during intent detection.
   * See [Language
   * Support](https://cloud.google.com/dialogflow/docs/reference/language)
   * for a list of the currently supported language codes.
   * </pre>
   *
   * <code>string language_code = 15;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The language that was triggered during intent detection.
   * See [Language
   * Support](https://cloud.google.com/dialogflow/docs/reference/language)
   * for a list of the currently supported language codes.
   * </pre>
   *
   * <code>string language_code = 15;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPEECH_RECOGNITION_CONFIDENCE_FIELD_NUMBER = 2;
  private float speechRecognitionConfidence_ = 0F;
  /**
   *
   *
   * <pre>
   * The Speech recognition confidence between 0.0 and 1.0. A higher number
   * indicates an estimated greater likelihood that the recognized words are
   * correct. The default of 0.0 is a sentinel value indicating that confidence
   * was not set.
   *
   * This field is not guaranteed to be accurate or set. In particular this
   * field isn't set for StreamingDetectIntent since the streaming endpoint has
   * separate confidence estimates per portion of the audio in
   * StreamingRecognitionResult.
   * </pre>
   *
   * <code>float speech_recognition_confidence = 2;</code>
   *
   * @return The speechRecognitionConfidence.
   */
  @java.lang.Override
  public float getSpeechRecognitionConfidence() {
    return speechRecognitionConfidence_;
  }

  public static final int ACTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object action_ = "";
  /**
   *
   *
   * <pre>
   * The action name from the matched intent.
   * </pre>
   *
   * <code>string action = 3;</code>
   *
   * @return The action.
   */
  @java.lang.Override
  public java.lang.String getAction() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      action_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The action name from the matched intent.
   * </pre>
   *
   * <code>string action = 3;</code>
   *
   * @return The bytes for action.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getActionBytes() {
    java.lang.Object ref = action_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      action_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARAMETERS_FIELD_NUMBER = 4;
  private com.google.protobuf.Struct parameters_;
  /**
   *
   *
   * <pre>
   * The collection of extracted parameters.
   *
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   *
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 4;</code>
   *
   * @return Whether the parameters field is set.
   */
  @java.lang.Override
  public boolean hasParameters() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The collection of extracted parameters.
   *
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   *
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 4;</code>
   *
   * @return The parameters.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getParameters() {
    return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
  }
  /**
   *
   *
   * <pre>
   * The collection of extracted parameters.
   *
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   *
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
    return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
  }

  public static final int ALL_REQUIRED_PARAMS_PRESENT_FIELD_NUMBER = 5;
  private boolean allRequiredParamsPresent_ = false;
  /**
   *
   *
   * <pre>
   * This field is set to:
   *
   * - `false` if the matched intent has required parameters and not all of
   *    the required parameter values have been collected.
   * - `true` if all required parameter values have been collected, or if the
   *    matched intent doesn't contain any required parameters.
   * </pre>
   *
   * <code>bool all_required_params_present = 5;</code>
   *
   * @return The allRequiredParamsPresent.
   */
  @java.lang.Override
  public boolean getAllRequiredParamsPresent() {
    return allRequiredParamsPresent_;
  }

  public static final int CANCELS_SLOT_FILLING_FIELD_NUMBER = 21;
  private boolean cancelsSlotFilling_ = false;
  /**
   *
   *
   * <pre>
   * Indicates whether the conversational query triggers a cancellation for slot
   * filling. For more information, see the [cancel slot filling
   * documentation](https://cloud.google.com/dialogflow/es/docs/intents-actions-parameters#cancel).
   * </pre>
   *
   * <code>bool cancels_slot_filling = 21;</code>
   *
   * @return The cancelsSlotFilling.
   */
  @java.lang.Override
  public boolean getCancelsSlotFilling() {
    return cancelsSlotFilling_;
  }

  public static final int FULFILLMENT_TEXT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fulfillmentText_ = "";
  /**
   *
   *
   * <pre>
   * The text to be pronounced to the user or shown on the screen.
   * Note: This is a legacy field, `fulfillment_messages` should be preferred.
   * </pre>
   *
   * <code>string fulfillment_text = 6;</code>
   *
   * @return The fulfillmentText.
   */
  @java.lang.Override
  public java.lang.String getFulfillmentText() {
    java.lang.Object ref = fulfillmentText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fulfillmentText_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The text to be pronounced to the user or shown on the screen.
   * Note: This is a legacy field, `fulfillment_messages` should be preferred.
   * </pre>
   *
   * <code>string fulfillment_text = 6;</code>
   *
   * @return The bytes for fulfillmentText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFulfillmentTextBytes() {
    java.lang.Object ref = fulfillmentText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fulfillmentText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FULFILLMENT_MESSAGES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.Intent.Message> fulfillmentMessages_;
  /**
   *
   *
   * <pre>
   * The collection of rich messages to present to the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.Intent.Message>
      getFulfillmentMessagesList() {
    return fulfillmentMessages_;
  }
  /**
   *
   *
   * <pre>
   * The collection of rich messages to present to the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder>
      getFulfillmentMessagesOrBuilderList() {
    return fulfillmentMessages_;
  }
  /**
   *
   *
   * <pre>
   * The collection of rich messages to present to the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;</code>
   */
  @java.lang.Override
  public int getFulfillmentMessagesCount() {
    return fulfillmentMessages_.size();
  }
  /**
   *
   *
   * <pre>
   * The collection of rich messages to present to the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Intent.Message getFulfillmentMessages(int index) {
    return fulfillmentMessages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The collection of rich messages to present to the user.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder
      getFulfillmentMessagesOrBuilder(int index) {
    return fulfillmentMessages_.get(index);
  }

  public static final int WEBHOOK_SOURCE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object webhookSource_ = "";
  /**
   *
   *
   * <pre>
   * If the query was fulfilled by a webhook call, this field is set to the
   * value of the `source` field returned in the webhook response.
   * </pre>
   *
   * <code>string webhook_source = 8;</code>
   *
   * @return The webhookSource.
   */
  @java.lang.Override
  public java.lang.String getWebhookSource() {
    java.lang.Object ref = webhookSource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      webhookSource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If the query was fulfilled by a webhook call, this field is set to the
   * value of the `source` field returned in the webhook response.
   * </pre>
   *
   * <code>string webhook_source = 8;</code>
   *
   * @return The bytes for webhookSource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWebhookSourceBytes() {
    java.lang.Object ref = webhookSource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      webhookSource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WEBHOOK_PAYLOAD_FIELD_NUMBER = 9;
  private com.google.protobuf.Struct webhookPayload_;
  /**
   *
   *
   * <pre>
   * If the query was fulfilled by a webhook call, this field is set to the
   * value of the `payload` field returned in the webhook response.
   * </pre>
   *
   * <code>.google.protobuf.Struct webhook_payload = 9;</code>
   *
   * @return Whether the webhookPayload field is set.
   */
  @java.lang.Override
  public boolean hasWebhookPayload() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * If the query was fulfilled by a webhook call, this field is set to the
   * value of the `payload` field returned in the webhook response.
   * </pre>
   *
   * <code>.google.protobuf.Struct webhook_payload = 9;</code>
   *
   * @return The webhookPayload.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getWebhookPayload() {
    return webhookPayload_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : webhookPayload_;
  }
  /**
   *
   *
   * <pre>
   * If the query was fulfilled by a webhook call, this field is set to the
   * value of the `payload` field returned in the webhook response.
   * </pre>
   *
   * <code>.google.protobuf.Struct webhook_payload = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getWebhookPayloadOrBuilder() {
    return webhookPayload_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : webhookPayload_;
  }

  public static final int OUTPUT_CONTEXTS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.Context> outputContexts_;
  /**
   *
   *
   * <pre>
   * The collection of output contexts. If applicable,
   * `output_contexts.parameters` contains entries with name
   * `&lt;parameter name&gt;.original` containing the original parameter values
   * before the query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.Context> getOutputContextsList() {
    return outputContexts_;
  }
  /**
   *
   *
   * <pre>
   * The collection of output contexts. If applicable,
   * `output_contexts.parameters` contains entries with name
   * `&lt;parameter name&gt;.original` containing the original parameter values
   * before the query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.ContextOrBuilder>
      getOutputContextsOrBuilderList() {
    return outputContexts_;
  }
  /**
   *
   *
   * <pre>
   * The collection of output contexts. If applicable,
   * `output_contexts.parameters` contains entries with name
   * `&lt;parameter name&gt;.original` containing the original parameter values
   * before the query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
   */
  @java.lang.Override
  public int getOutputContextsCount() {
    return outputContexts_.size();
  }
  /**
   *
   *
   * <pre>
   * The collection of output contexts. If applicable,
   * `output_contexts.parameters` contains entries with name
   * `&lt;parameter name&gt;.original` containing the original parameter values
   * before the query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Context getOutputContexts(int index) {
    return outputContexts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The collection of output contexts. If applicable,
   * `output_contexts.parameters` contains entries with name
   * `&lt;parameter name&gt;.original` containing the original parameter values
   * before the query.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.ContextOrBuilder getOutputContextsOrBuilder(
      int index) {
    return outputContexts_.get(index);
  }

  public static final int INTENT_FIELD_NUMBER = 11;
  private com.google.cloud.dialogflow.v2beta1.Intent intent_;
  /**
   *
   *
   * <pre>
   * The intent that matched the conversational query. Some, not
   * all fields are filled in this message, including but not limited to:
   * `name`, `display_name`, `end_interaction` and `is_fallback`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.Intent intent = 11;</code>
   *
   * @return Whether the intent field is set.
   */
  @java.lang.Override
  public boolean hasIntent() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The intent that matched the conversational query. Some, not
   * all fields are filled in this message, including but not limited to:
   * `name`, `display_name`, `end_interaction` and `is_fallback`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.Intent intent = 11;</code>
   *
   * @return The intent.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Intent getIntent() {
    return intent_ == null
        ? com.google.cloud.dialogflow.v2beta1.Intent.getDefaultInstance()
        : intent_;
  }
  /**
   *
   *
   * <pre>
   * The intent that matched the conversational query. Some, not
   * all fields are filled in this message, including but not limited to:
   * `name`, `display_name`, `end_interaction` and `is_fallback`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.Intent intent = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.IntentOrBuilder getIntentOrBuilder() {
    return intent_ == null
        ? com.google.cloud.dialogflow.v2beta1.Intent.getDefaultInstance()
        : intent_;
  }

  public static final int INTENT_DETECTION_CONFIDENCE_FIELD_NUMBER = 12;
  private float intentDetectionConfidence_ = 0F;
  /**
   *
   *
   * <pre>
   * The intent detection confidence. Values range from 0.0
   * (completely uncertain) to 1.0 (completely certain).
   * This value is for informational purpose only and is only used to
   * help match the best intent within the classification threshold.
   * This value may change for the same end-user expression at any time due to a
   * model retraining or change in implementation.
   * If there are `multiple knowledge_answers` messages, this value is set to
   * the greatest `knowledgeAnswers.match_confidence` value in the list.
   * </pre>
   *
   * <code>float intent_detection_confidence = 12;</code>
   *
   * @return The intentDetectionConfidence.
   */
  @java.lang.Override
  public float getIntentDetectionConfidence() {
    return intentDetectionConfidence_;
  }

  public static final int DIAGNOSTIC_INFO_FIELD_NUMBER = 14;
  private com.google.protobuf.Struct diagnosticInfo_;
  /**
   *
   *
   * <pre>
   * Free-form diagnostic information for the associated detect intent request.
   * The fields of this data can change without notice, so you should not write
   * code that depends on its structure.
   * The data may contain:
   *
   * - webhook call latency
   * - webhook errors
   * </pre>
   *
   * <code>.google.protobuf.Struct diagnostic_info = 14;</code>
   *
   * @return Whether the diagnosticInfo field is set.
   */
  @java.lang.Override
  public boolean hasDiagnosticInfo() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Free-form diagnostic information for the associated detect intent request.
   * The fields of this data can change without notice, so you should not write
   * code that depends on its structure.
   * The data may contain:
   *
   * - webhook call latency
   * - webhook errors
   * </pre>
   *
   * <code>.google.protobuf.Struct diagnostic_info = 14;</code>
   *
   * @return The diagnosticInfo.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getDiagnosticInfo() {
    return diagnosticInfo_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : diagnosticInfo_;
  }
  /**
   *
   *
   * <pre>
   * Free-form diagnostic information for the associated detect intent request.
   * The fields of this data can change without notice, so you should not write
   * code that depends on its structure.
   * The data may contain:
   *
   * - webhook call latency
   * - webhook errors
   * </pre>
   *
   * <code>.google.protobuf.Struct diagnostic_info = 14;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getDiagnosticInfoOrBuilder() {
    return diagnosticInfo_ == null
        ? com.google.protobuf.Struct.getDefaultInstance()
        : diagnosticInfo_;
  }

  public static final int SENTIMENT_ANALYSIS_RESULT_FIELD_NUMBER = 17;
  private com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentimentAnalysisResult_;
  /**
   *
   *
   * <pre>
   * The sentiment analysis result, which depends on the
   * `sentiment_analysis_request_config` specified in the request.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentiment_analysis_result = 17;
   * </code>
   *
   * @return Whether the sentimentAnalysisResult field is set.
   */
  @java.lang.Override
  public boolean hasSentimentAnalysisResult() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The sentiment analysis result, which depends on the
   * `sentiment_analysis_request_config` specified in the request.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentiment_analysis_result = 17;
   * </code>
   *
   * @return The sentimentAnalysisResult.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult getSentimentAnalysisResult() {
    return sentimentAnalysisResult_ == null
        ? com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult.getDefaultInstance()
        : sentimentAnalysisResult_;
  }
  /**
   *
   *
   * <pre>
   * The sentiment analysis result, which depends on the
   * `sentiment_analysis_request_config` specified in the request.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentiment_analysis_result = 17;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResultOrBuilder
      getSentimentAnalysisResultOrBuilder() {
    return sentimentAnalysisResult_ == null
        ? com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult.getDefaultInstance()
        : sentimentAnalysisResult_;
  }

  public static final int KNOWLEDGE_ANSWERS_FIELD_NUMBER = 18;
  private com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledgeAnswers_;
  /**
   *
   *
   * <pre>
   * The result from Knowledge Connector (if any), ordered by decreasing
   * `KnowledgeAnswers.match_confidence`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledge_answers = 18;</code>
   *
   * @return Whether the knowledgeAnswers field is set.
   */
  @java.lang.Override
  public boolean hasKnowledgeAnswers() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The result from Knowledge Connector (if any), ordered by decreasing
   * `KnowledgeAnswers.match_confidence`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledge_answers = 18;</code>
   *
   * @return The knowledgeAnswers.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers getKnowledgeAnswers() {
    return knowledgeAnswers_ == null
        ? com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.getDefaultInstance()
        : knowledgeAnswers_;
  }
  /**
   *
   *
   * <pre>
   * The result from Knowledge Connector (if any), ordered by decreasing
   * `KnowledgeAnswers.match_confidence`.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledge_answers = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswersOrBuilder
      getKnowledgeAnswersOrBuilder() {
    return knowledgeAnswers_ == null
        ? com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.getDefaultInstance()
        : knowledgeAnswers_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, queryText_);
    }
    if (java.lang.Float.floatToRawIntBits(speechRecognitionConfidence_) != 0) {
      output.writeFloat(2, speechRecognitionConfidence_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(action_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, action_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getParameters());
    }
    if (allRequiredParamsPresent_ != false) {
      output.writeBool(5, allRequiredParamsPresent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fulfillmentText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, fulfillmentText_);
    }
    for (int i = 0; i < fulfillmentMessages_.size(); i++) {
      output.writeMessage(7, fulfillmentMessages_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webhookSource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, webhookSource_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getWebhookPayload());
    }
    for (int i = 0; i < outputContexts_.size(); i++) {
      output.writeMessage(10, outputContexts_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(11, getIntent());
    }
    if (java.lang.Float.floatToRawIntBits(intentDetectionConfidence_) != 0) {
      output.writeFloat(12, intentDetectionConfidence_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(14, getDiagnosticInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, languageCode_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(17, getSentimentAnalysisResult());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(18, getKnowledgeAnswers());
    }
    if (cancelsSlotFilling_ != false) {
      output.writeBool(21, cancelsSlotFilling_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, queryText_);
    }
    if (java.lang.Float.floatToRawIntBits(speechRecognitionConfidence_) != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeFloatSize(2, speechRecognitionConfidence_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(action_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, action_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getParameters());
    }
    if (allRequiredParamsPresent_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, allRequiredParamsPresent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fulfillmentText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, fulfillmentText_);
    }
    for (int i = 0; i < fulfillmentMessages_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, fulfillmentMessages_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(webhookSource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, webhookSource_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getWebhookPayload());
    }
    for (int i = 0; i < outputContexts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, outputContexts_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getIntent());
    }
    if (java.lang.Float.floatToRawIntBits(intentDetectionConfidence_) != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeFloatSize(12, intentDetectionConfidence_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getDiagnosticInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, languageCode_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, getSentimentAnalysisResult());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getKnowledgeAnswers());
    }
    if (cancelsSlotFilling_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(21, cancelsSlotFilling_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.QueryResult)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.QueryResult other =
        (com.google.cloud.dialogflow.v2beta1.QueryResult) obj;

    if (!getQueryText().equals(other.getQueryText())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (java.lang.Float.floatToIntBits(getSpeechRecognitionConfidence())
        != java.lang.Float.floatToIntBits(other.getSpeechRecognitionConfidence())) return false;
    if (!getAction().equals(other.getAction())) return false;
    if (hasParameters() != other.hasParameters()) return false;
    if (hasParameters()) {
      if (!getParameters().equals(other.getParameters())) return false;
    }
    if (getAllRequiredParamsPresent() != other.getAllRequiredParamsPresent()) return false;
    if (getCancelsSlotFilling() != other.getCancelsSlotFilling()) return false;
    if (!getFulfillmentText().equals(other.getFulfillmentText())) return false;
    if (!getFulfillmentMessagesList().equals(other.getFulfillmentMessagesList())) return false;
    if (!getWebhookSource().equals(other.getWebhookSource())) return false;
    if (hasWebhookPayload() != other.hasWebhookPayload()) return false;
    if (hasWebhookPayload()) {
      if (!getWebhookPayload().equals(other.getWebhookPayload())) return false;
    }
    if (!getOutputContextsList().equals(other.getOutputContextsList())) return false;
    if (hasIntent() != other.hasIntent()) return false;
    if (hasIntent()) {
      if (!getIntent().equals(other.getIntent())) return false;
    }
    if (java.lang.Float.floatToIntBits(getIntentDetectionConfidence())
        != java.lang.Float.floatToIntBits(other.getIntentDetectionConfidence())) return false;
    if (hasDiagnosticInfo() != other.hasDiagnosticInfo()) return false;
    if (hasDiagnosticInfo()) {
      if (!getDiagnosticInfo().equals(other.getDiagnosticInfo())) return false;
    }
    if (hasSentimentAnalysisResult() != other.hasSentimentAnalysisResult()) return false;
    if (hasSentimentAnalysisResult()) {
      if (!getSentimentAnalysisResult().equals(other.getSentimentAnalysisResult())) return false;
    }
    if (hasKnowledgeAnswers() != other.hasKnowledgeAnswers()) return false;
    if (hasKnowledgeAnswers()) {
      if (!getKnowledgeAnswers().equals(other.getKnowledgeAnswers())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + QUERY_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getQueryText().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + SPEECH_RECOGNITION_CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getSpeechRecognitionConfidence());
    hash = (37 * hash) + ACTION_FIELD_NUMBER;
    hash = (53 * hash) + getAction().hashCode();
    if (hasParameters()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParameters().hashCode();
    }
    hash = (37 * hash) + ALL_REQUIRED_PARAMS_PRESENT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllRequiredParamsPresent());
    hash = (37 * hash) + CANCELS_SLOT_FILLING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCancelsSlotFilling());
    hash = (37 * hash) + FULFILLMENT_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getFulfillmentText().hashCode();
    if (getFulfillmentMessagesCount() > 0) {
      hash = (37 * hash) + FULFILLMENT_MESSAGES_FIELD_NUMBER;
      hash = (53 * hash) + getFulfillmentMessagesList().hashCode();
    }
    hash = (37 * hash) + WEBHOOK_SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getWebhookSource().hashCode();
    if (hasWebhookPayload()) {
      hash = (37 * hash) + WEBHOOK_PAYLOAD_FIELD_NUMBER;
      hash = (53 * hash) + getWebhookPayload().hashCode();
    }
    if (getOutputContextsCount() > 0) {
      hash = (37 * hash) + OUTPUT_CONTEXTS_FIELD_NUMBER;
      hash = (53 * hash) + getOutputContextsList().hashCode();
    }
    if (hasIntent()) {
      hash = (37 * hash) + INTENT_FIELD_NUMBER;
      hash = (53 * hash) + getIntent().hashCode();
    }
    hash = (37 * hash) + INTENT_DETECTION_CONFIDENCE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getIntentDetectionConfidence());
    if (hasDiagnosticInfo()) {
      hash = (37 * hash) + DIAGNOSTIC_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getDiagnosticInfo().hashCode();
    }
    if (hasSentimentAnalysisResult()) {
      hash = (37 * hash) + SENTIMENT_ANALYSIS_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getSentimentAnalysisResult().hashCode();
    }
    if (hasKnowledgeAnswers()) {
      hash = (37 * hash) + KNOWLEDGE_ANSWERS_FIELD_NUMBER;
      hash = (53 * hash) + getKnowledgeAnswers().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryResult parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryResult parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.QueryResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents the result of conversational query or event processing.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.QueryResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.QueryResult)
      com.google.cloud.dialogflow.v2beta1.QueryResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_QueryResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_QueryResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.QueryResult.class,
              com.google.cloud.dialogflow.v2beta1.QueryResult.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.QueryResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getParametersFieldBuilder();
        getFulfillmentMessagesFieldBuilder();
        getWebhookPayloadFieldBuilder();
        getOutputContextsFieldBuilder();
        getIntentFieldBuilder();
        getDiagnosticInfoFieldBuilder();
        getSentimentAnalysisResultFieldBuilder();
        getKnowledgeAnswersFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      queryText_ = "";
      languageCode_ = "";
      speechRecognitionConfidence_ = 0F;
      action_ = "";
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      allRequiredParamsPresent_ = false;
      cancelsSlotFilling_ = false;
      fulfillmentText_ = "";
      if (fulfillmentMessagesBuilder_ == null) {
        fulfillmentMessages_ = java.util.Collections.emptyList();
      } else {
        fulfillmentMessages_ = null;
        fulfillmentMessagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      webhookSource_ = "";
      webhookPayload_ = null;
      if (webhookPayloadBuilder_ != null) {
        webhookPayloadBuilder_.dispose();
        webhookPayloadBuilder_ = null;
      }
      if (outputContextsBuilder_ == null) {
        outputContexts_ = java.util.Collections.emptyList();
      } else {
        outputContexts_ = null;
        outputContextsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      intent_ = null;
      if (intentBuilder_ != null) {
        intentBuilder_.dispose();
        intentBuilder_ = null;
      }
      intentDetectionConfidence_ = 0F;
      diagnosticInfo_ = null;
      if (diagnosticInfoBuilder_ != null) {
        diagnosticInfoBuilder_.dispose();
        diagnosticInfoBuilder_ = null;
      }
      sentimentAnalysisResult_ = null;
      if (sentimentAnalysisResultBuilder_ != null) {
        sentimentAnalysisResultBuilder_.dispose();
        sentimentAnalysisResultBuilder_ = null;
      }
      knowledgeAnswers_ = null;
      if (knowledgeAnswersBuilder_ != null) {
        knowledgeAnswersBuilder_.dispose();
        knowledgeAnswersBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.SessionProto
          .internal_static_google_cloud_dialogflow_v2beta1_QueryResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.QueryResult getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.QueryResult build() {
      com.google.cloud.dialogflow.v2beta1.QueryResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.QueryResult buildPartial() {
      com.google.cloud.dialogflow.v2beta1.QueryResult result =
          new com.google.cloud.dialogflow.v2beta1.QueryResult(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2beta1.QueryResult result) {
      if (fulfillmentMessagesBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          fulfillmentMessages_ = java.util.Collections.unmodifiableList(fulfillmentMessages_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.fulfillmentMessages_ = fulfillmentMessages_;
      } else {
        result.fulfillmentMessages_ = fulfillmentMessagesBuilder_.build();
      }
      if (outputContextsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          outputContexts_ = java.util.Collections.unmodifiableList(outputContexts_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.outputContexts_ = outputContexts_;
      } else {
        result.outputContexts_ = outputContextsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.QueryResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.queryText_ = queryText_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.speechRecognitionConfidence_ = speechRecognitionConfidence_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.action_ = action_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.parameters_ = parametersBuilder_ == null ? parameters_ : parametersBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.allRequiredParamsPresent_ = allRequiredParamsPresent_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.cancelsSlotFilling_ = cancelsSlotFilling_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.fulfillmentText_ = fulfillmentText_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.webhookSource_ = webhookSource_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.webhookPayload_ =
            webhookPayloadBuilder_ == null ? webhookPayload_ : webhookPayloadBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.intent_ = intentBuilder_ == null ? intent_ : intentBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.intentDetectionConfidence_ = intentDetectionConfidence_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.diagnosticInfo_ =
            diagnosticInfoBuilder_ == null ? diagnosticInfo_ : diagnosticInfoBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.sentimentAnalysisResult_ =
            sentimentAnalysisResultBuilder_ == null
                ? sentimentAnalysisResult_
                : sentimentAnalysisResultBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.knowledgeAnswers_ =
            knowledgeAnswersBuilder_ == null ? knowledgeAnswers_ : knowledgeAnswersBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.QueryResult) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.QueryResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.QueryResult other) {
      if (other == com.google.cloud.dialogflow.v2beta1.QueryResult.getDefaultInstance())
        return this;
      if (!other.getQueryText().isEmpty()) {
        queryText_ = other.queryText_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getSpeechRecognitionConfidence() != 0F) {
        setSpeechRecognitionConfidence(other.getSpeechRecognitionConfidence());
      }
      if (!other.getAction().isEmpty()) {
        action_ = other.action_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasParameters()) {
        mergeParameters(other.getParameters());
      }
      if (other.getAllRequiredParamsPresent() != false) {
        setAllRequiredParamsPresent(other.getAllRequiredParamsPresent());
      }
      if (other.getCancelsSlotFilling() != false) {
        setCancelsSlotFilling(other.getCancelsSlotFilling());
      }
      if (!other.getFulfillmentText().isEmpty()) {
        fulfillmentText_ = other.fulfillmentText_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (fulfillmentMessagesBuilder_ == null) {
        if (!other.fulfillmentMessages_.isEmpty()) {
          if (fulfillmentMessages_.isEmpty()) {
            fulfillmentMessages_ = other.fulfillmentMessages_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureFulfillmentMessagesIsMutable();
            fulfillmentMessages_.addAll(other.fulfillmentMessages_);
          }
          onChanged();
        }
      } else {
        if (!other.fulfillmentMessages_.isEmpty()) {
          if (fulfillmentMessagesBuilder_.isEmpty()) {
            fulfillmentMessagesBuilder_.dispose();
            fulfillmentMessagesBuilder_ = null;
            fulfillmentMessages_ = other.fulfillmentMessages_;
            bitField0_ = (bitField0_ & ~0x00000100);
            fulfillmentMessagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFulfillmentMessagesFieldBuilder()
                    : null;
          } else {
            fulfillmentMessagesBuilder_.addAllMessages(other.fulfillmentMessages_);
          }
        }
      }
      if (!other.getWebhookSource().isEmpty()) {
        webhookSource_ = other.webhookSource_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasWebhookPayload()) {
        mergeWebhookPayload(other.getWebhookPayload());
      }
      if (outputContextsBuilder_ == null) {
        if (!other.outputContexts_.isEmpty()) {
          if (outputContexts_.isEmpty()) {
            outputContexts_ = other.outputContexts_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureOutputContextsIsMutable();
            outputContexts_.addAll(other.outputContexts_);
          }
          onChanged();
        }
      } else {
        if (!other.outputContexts_.isEmpty()) {
          if (outputContextsBuilder_.isEmpty()) {
            outputContextsBuilder_.dispose();
            outputContextsBuilder_ = null;
            outputContexts_ = other.outputContexts_;
            bitField0_ = (bitField0_ & ~0x00000800);
            outputContextsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOutputContextsFieldBuilder()
                    : null;
          } else {
            outputContextsBuilder_.addAllMessages(other.outputContexts_);
          }
        }
      }
      if (other.hasIntent()) {
        mergeIntent(other.getIntent());
      }
      if (other.getIntentDetectionConfidence() != 0F) {
        setIntentDetectionConfidence(other.getIntentDetectionConfidence());
      }
      if (other.hasDiagnosticInfo()) {
        mergeDiagnosticInfo(other.getDiagnosticInfo());
      }
      if (other.hasSentimentAnalysisResult()) {
        mergeSentimentAnalysisResult(other.getSentimentAnalysisResult());
      }
      if (other.hasKnowledgeAnswers()) {
        mergeKnowledgeAnswers(other.getKnowledgeAnswers());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                queryText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 21:
              {
                speechRecognitionConfidence_ = input.readFloat();
                bitField0_ |= 0x00000004;
                break;
              } // case 21
            case 26:
              {
                action_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 40:
              {
                allRequiredParamsPresent_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 50:
              {
                fulfillmentText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 58:
              {
                com.google.cloud.dialogflow.v2beta1.Intent.Message m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.Intent.Message.parser(),
                        extensionRegistry);
                if (fulfillmentMessagesBuilder_ == null) {
                  ensureFulfillmentMessagesIsMutable();
                  fulfillmentMessages_.add(m);
                } else {
                  fulfillmentMessagesBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 66:
              {
                webhookSource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getWebhookPayloadFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 74
            case 82:
              {
                com.google.cloud.dialogflow.v2beta1.Context m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.Context.parser(), extensionRegistry);
                if (outputContextsBuilder_ == null) {
                  ensureOutputContextsIsMutable();
                  outputContexts_.add(m);
                } else {
                  outputContextsBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getIntentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 90
            case 101:
              {
                intentDetectionConfidence_ = input.readFloat();
                bitField0_ |= 0x00002000;
                break;
              } // case 101
            case 114:
              {
                input.readMessage(getDiagnosticInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 114
            case 122:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 122
            case 138:
              {
                input.readMessage(
                    getSentimentAnalysisResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(
                    getKnowledgeAnswersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 146
            case 168:
              {
                cancelsSlotFilling_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 168
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object queryText_ = "";
    /**
     *
     *
     * <pre>
     * The original conversational query text:
     *
     * - If natural language text was provided as input, `query_text` contains
     *   a copy of the input.
     * - If natural language speech audio was provided as input, `query_text`
     *   contains the speech recognition result. If speech recognizer produced
     *   multiple alternatives, a particular one is picked.
     * - If automatic spell correction is enabled, `query_text` will contain the
     *   corrected user input.
     * </pre>
     *
     * <code>string query_text = 1;</code>
     *
     * @return The queryText.
     */
    public java.lang.String getQueryText() {
      java.lang.Object ref = queryText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        queryText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The original conversational query text:
     *
     * - If natural language text was provided as input, `query_text` contains
     *   a copy of the input.
     * - If natural language speech audio was provided as input, `query_text`
     *   contains the speech recognition result. If speech recognizer produced
     *   multiple alternatives, a particular one is picked.
     * - If automatic spell correction is enabled, `query_text` will contain the
     *   corrected user input.
     * </pre>
     *
     * <code>string query_text = 1;</code>
     *
     * @return The bytes for queryText.
     */
    public com.google.protobuf.ByteString getQueryTextBytes() {
      java.lang.Object ref = queryText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        queryText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The original conversational query text:
     *
     * - If natural language text was provided as input, `query_text` contains
     *   a copy of the input.
     * - If natural language speech audio was provided as input, `query_text`
     *   contains the speech recognition result. If speech recognizer produced
     *   multiple alternatives, a particular one is picked.
     * - If automatic spell correction is enabled, `query_text` will contain the
     *   corrected user input.
     * </pre>
     *
     * <code>string query_text = 1;</code>
     *
     * @param value The queryText to set.
     * @return This builder for chaining.
     */
    public Builder setQueryText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryText_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original conversational query text:
     *
     * - If natural language text was provided as input, `query_text` contains
     *   a copy of the input.
     * - If natural language speech audio was provided as input, `query_text`
     *   contains the speech recognition result. If speech recognizer produced
     *   multiple alternatives, a particular one is picked.
     * - If automatic spell correction is enabled, `query_text` will contain the
     *   corrected user input.
     * </pre>
     *
     * <code>string query_text = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryText() {
      queryText_ = getDefaultInstance().getQueryText();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original conversational query text:
     *
     * - If natural language text was provided as input, `query_text` contains
     *   a copy of the input.
     * - If natural language speech audio was provided as input, `query_text`
     *   contains the speech recognition result. If speech recognizer produced
     *   multiple alternatives, a particular one is picked.
     * - If automatic spell correction is enabled, `query_text` will contain the
     *   corrected user input.
     * </pre>
     *
     * <code>string query_text = 1;</code>
     *
     * @param value The bytes for queryText to set.
     * @return This builder for chaining.
     */
    public Builder setQueryTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryText_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * The language that was triggered during intent detection.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language that was triggered during intent detection.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language that was triggered during intent detection.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language that was triggered during intent detection.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language that was triggered during intent detection.
     * See [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes.
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private float speechRecognitionConfidence_;
    /**
     *
     *
     * <pre>
     * The Speech recognition confidence between 0.0 and 1.0. A higher number
     * indicates an estimated greater likelihood that the recognized words are
     * correct. The default of 0.0 is a sentinel value indicating that confidence
     * was not set.
     *
     * This field is not guaranteed to be accurate or set. In particular this
     * field isn't set for StreamingDetectIntent since the streaming endpoint has
     * separate confidence estimates per portion of the audio in
     * StreamingRecognitionResult.
     * </pre>
     *
     * <code>float speech_recognition_confidence = 2;</code>
     *
     * @return The speechRecognitionConfidence.
     */
    @java.lang.Override
    public float getSpeechRecognitionConfidence() {
      return speechRecognitionConfidence_;
    }
    /**
     *
     *
     * <pre>
     * The Speech recognition confidence between 0.0 and 1.0. A higher number
     * indicates an estimated greater likelihood that the recognized words are
     * correct. The default of 0.0 is a sentinel value indicating that confidence
     * was not set.
     *
     * This field is not guaranteed to be accurate or set. In particular this
     * field isn't set for StreamingDetectIntent since the streaming endpoint has
     * separate confidence estimates per portion of the audio in
     * StreamingRecognitionResult.
     * </pre>
     *
     * <code>float speech_recognition_confidence = 2;</code>
     *
     * @param value The speechRecognitionConfidence to set.
     * @return This builder for chaining.
     */
    public Builder setSpeechRecognitionConfidence(float value) {

      speechRecognitionConfidence_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Speech recognition confidence between 0.0 and 1.0. A higher number
     * indicates an estimated greater likelihood that the recognized words are
     * correct. The default of 0.0 is a sentinel value indicating that confidence
     * was not set.
     *
     * This field is not guaranteed to be accurate or set. In particular this
     * field isn't set for StreamingDetectIntent since the streaming endpoint has
     * separate confidence estimates per portion of the audio in
     * StreamingRecognitionResult.
     * </pre>
     *
     * <code>float speech_recognition_confidence = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpeechRecognitionConfidence() {
      bitField0_ = (bitField0_ & ~0x00000004);
      speechRecognitionConfidence_ = 0F;
      onChanged();
      return this;
    }

    private java.lang.Object action_ = "";
    /**
     *
     *
     * <pre>
     * The action name from the matched intent.
     * </pre>
     *
     * <code>string action = 3;</code>
     *
     * @return The action.
     */
    public java.lang.String getAction() {
      java.lang.Object ref = action_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        action_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The action name from the matched intent.
     * </pre>
     *
     * <code>string action = 3;</code>
     *
     * @return The bytes for action.
     */
    public com.google.protobuf.ByteString getActionBytes() {
      java.lang.Object ref = action_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        action_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The action name from the matched intent.
     * </pre>
     *
     * <code>string action = 3;</code>
     *
     * @param value The action to set.
     * @return This builder for chaining.
     */
    public Builder setAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      action_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The action name from the matched intent.
     * </pre>
     *
     * <code>string action = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAction() {
      action_ = getDefaultInstance().getAction();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The action name from the matched intent.
     * </pre>
     *
     * <code>string action = 3;</code>
     *
     * @param value The bytes for action to set.
     * @return This builder for chaining.
     */
    public Builder setActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      action_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct parameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        parametersBuilder_;
    /**
     *
     *
     * <pre>
     * The collection of extracted parameters.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     *
     * @return Whether the parameters field is set.
     */
    public boolean hasParameters() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The collection of extracted parameters.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     *
     * @return The parameters.
     */
    public com.google.protobuf.Struct getParameters() {
      if (parametersBuilder_ == null) {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      } else {
        return parametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of extracted parameters.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameters_ = value;
      } else {
        parametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of extracted parameters.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    public Builder setParameters(com.google.protobuf.Struct.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        parameters_ = builderForValue.build();
      } else {
        parametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of extracted parameters.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    public Builder mergeParameters(com.google.protobuf.Struct value) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && parameters_ != null
            && parameters_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getParametersBuilder().mergeFrom(value);
        } else {
          parameters_ = value;
        }
      } else {
        parametersBuilder_.mergeFrom(value);
      }
      if (parameters_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of extracted parameters.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    public Builder clearParameters() {
      bitField0_ = (bitField0_ & ~0x00000010);
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of extracted parameters.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    public com.google.protobuf.Struct.Builder getParametersBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The collection of extracted parameters.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    public com.google.protobuf.StructOrBuilder getParametersOrBuilder() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilder();
      } else {
        return parameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : parameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of extracted parameters.
     *
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     *
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     * </pre>
     *
     * <code>.google.protobuf.Struct parameters = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getParameters(), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private boolean allRequiredParamsPresent_;
    /**
     *
     *
     * <pre>
     * This field is set to:
     *
     * - `false` if the matched intent has required parameters and not all of
     *    the required parameter values have been collected.
     * - `true` if all required parameter values have been collected, or if the
     *    matched intent doesn't contain any required parameters.
     * </pre>
     *
     * <code>bool all_required_params_present = 5;</code>
     *
     * @return The allRequiredParamsPresent.
     */
    @java.lang.Override
    public boolean getAllRequiredParamsPresent() {
      return allRequiredParamsPresent_;
    }
    /**
     *
     *
     * <pre>
     * This field is set to:
     *
     * - `false` if the matched intent has required parameters and not all of
     *    the required parameter values have been collected.
     * - `true` if all required parameter values have been collected, or if the
     *    matched intent doesn't contain any required parameters.
     * </pre>
     *
     * <code>bool all_required_params_present = 5;</code>
     *
     * @param value The allRequiredParamsPresent to set.
     * @return This builder for chaining.
     */
    public Builder setAllRequiredParamsPresent(boolean value) {

      allRequiredParamsPresent_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is set to:
     *
     * - `false` if the matched intent has required parameters and not all of
     *    the required parameter values have been collected.
     * - `true` if all required parameter values have been collected, or if the
     *    matched intent doesn't contain any required parameters.
     * </pre>
     *
     * <code>bool all_required_params_present = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllRequiredParamsPresent() {
      bitField0_ = (bitField0_ & ~0x00000020);
      allRequiredParamsPresent_ = false;
      onChanged();
      return this;
    }

    private boolean cancelsSlotFilling_;
    /**
     *
     *
     * <pre>
     * Indicates whether the conversational query triggers a cancellation for slot
     * filling. For more information, see the [cancel slot filling
     * documentation](https://cloud.google.com/dialogflow/es/docs/intents-actions-parameters#cancel).
     * </pre>
     *
     * <code>bool cancels_slot_filling = 21;</code>
     *
     * @return The cancelsSlotFilling.
     */
    @java.lang.Override
    public boolean getCancelsSlotFilling() {
      return cancelsSlotFilling_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the conversational query triggers a cancellation for slot
     * filling. For more information, see the [cancel slot filling
     * documentation](https://cloud.google.com/dialogflow/es/docs/intents-actions-parameters#cancel).
     * </pre>
     *
     * <code>bool cancels_slot_filling = 21;</code>
     *
     * @param value The cancelsSlotFilling to set.
     * @return This builder for chaining.
     */
    public Builder setCancelsSlotFilling(boolean value) {

      cancelsSlotFilling_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether the conversational query triggers a cancellation for slot
     * filling. For more information, see the [cancel slot filling
     * documentation](https://cloud.google.com/dialogflow/es/docs/intents-actions-parameters#cancel).
     * </pre>
     *
     * <code>bool cancels_slot_filling = 21;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCancelsSlotFilling() {
      bitField0_ = (bitField0_ & ~0x00000040);
      cancelsSlotFilling_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object fulfillmentText_ = "";
    /**
     *
     *
     * <pre>
     * The text to be pronounced to the user or shown on the screen.
     * Note: This is a legacy field, `fulfillment_messages` should be preferred.
     * </pre>
     *
     * <code>string fulfillment_text = 6;</code>
     *
     * @return The fulfillmentText.
     */
    public java.lang.String getFulfillmentText() {
      java.lang.Object ref = fulfillmentText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fulfillmentText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The text to be pronounced to the user or shown on the screen.
     * Note: This is a legacy field, `fulfillment_messages` should be preferred.
     * </pre>
     *
     * <code>string fulfillment_text = 6;</code>
     *
     * @return The bytes for fulfillmentText.
     */
    public com.google.protobuf.ByteString getFulfillmentTextBytes() {
      java.lang.Object ref = fulfillmentText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fulfillmentText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The text to be pronounced to the user or shown on the screen.
     * Note: This is a legacy field, `fulfillment_messages` should be preferred.
     * </pre>
     *
     * <code>string fulfillment_text = 6;</code>
     *
     * @param value The fulfillmentText to set.
     * @return This builder for chaining.
     */
    public Builder setFulfillmentText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fulfillmentText_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text to be pronounced to the user or shown on the screen.
     * Note: This is a legacy field, `fulfillment_messages` should be preferred.
     * </pre>
     *
     * <code>string fulfillment_text = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFulfillmentText() {
      fulfillmentText_ = getDefaultInstance().getFulfillmentText();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text to be pronounced to the user or shown on the screen.
     * Note: This is a legacy field, `fulfillment_messages` should be preferred.
     * </pre>
     *
     * <code>string fulfillment_text = 6;</code>
     *
     * @param value The bytes for fulfillmentText to set.
     * @return This builder for chaining.
     */
    public Builder setFulfillmentTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fulfillmentText_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.Intent.Message>
        fulfillmentMessages_ = java.util.Collections.emptyList();

    private void ensureFulfillmentMessagesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        fulfillmentMessages_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.Intent.Message>(
                fulfillmentMessages_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Intent.Message,
            com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder,
            com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder>
        fulfillmentMessagesBuilder_;

    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Intent.Message>
        getFulfillmentMessagesList() {
      if (fulfillmentMessagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fulfillmentMessages_);
      } else {
        return fulfillmentMessagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public int getFulfillmentMessagesCount() {
      if (fulfillmentMessagesBuilder_ == null) {
        return fulfillmentMessages_.size();
      } else {
        return fulfillmentMessagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Intent.Message getFulfillmentMessages(int index) {
      if (fulfillmentMessagesBuilder_ == null) {
        return fulfillmentMessages_.get(index);
      } else {
        return fulfillmentMessagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public Builder setFulfillmentMessages(
        int index, com.google.cloud.dialogflow.v2beta1.Intent.Message value) {
      if (fulfillmentMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.set(index, value);
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public Builder setFulfillmentMessages(
        int index, com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder builderForValue) {
      if (fulfillmentMessagesBuilder_ == null) {
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.set(index, builderForValue.build());
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public Builder addFulfillmentMessages(
        com.google.cloud.dialogflow.v2beta1.Intent.Message value) {
      if (fulfillmentMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.add(value);
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public Builder addFulfillmentMessages(
        int index, com.google.cloud.dialogflow.v2beta1.Intent.Message value) {
      if (fulfillmentMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.add(index, value);
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public Builder addFulfillmentMessages(
        com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder builderForValue) {
      if (fulfillmentMessagesBuilder_ == null) {
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.add(builderForValue.build());
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public Builder addFulfillmentMessages(
        int index, com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder builderForValue) {
      if (fulfillmentMessagesBuilder_ == null) {
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.add(index, builderForValue.build());
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public Builder addAllFulfillmentMessages(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.Intent.Message> values) {
      if (fulfillmentMessagesBuilder_ == null) {
        ensureFulfillmentMessagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fulfillmentMessages_);
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public Builder clearFulfillmentMessages() {
      if (fulfillmentMessagesBuilder_ == null) {
        fulfillmentMessages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public Builder removeFulfillmentMessages(int index) {
      if (fulfillmentMessagesBuilder_ == null) {
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.remove(index);
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder getFulfillmentMessagesBuilder(
        int index) {
      return getFulfillmentMessagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder
        getFulfillmentMessagesOrBuilder(int index) {
      if (fulfillmentMessagesBuilder_ == null) {
        return fulfillmentMessages_.get(index);
      } else {
        return fulfillmentMessagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder>
        getFulfillmentMessagesOrBuilderList() {
      if (fulfillmentMessagesBuilder_ != null) {
        return fulfillmentMessagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fulfillmentMessages_);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder
        addFulfillmentMessagesBuilder() {
      return getFulfillmentMessagesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2beta1.Intent.Message.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder addFulfillmentMessagesBuilder(
        int index) {
      return getFulfillmentMessagesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.v2beta1.Intent.Message.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The collection of rich messages to present to the user.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 7;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder>
        getFulfillmentMessagesBuilderList() {
      return getFulfillmentMessagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Intent.Message,
            com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder,
            com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder>
        getFulfillmentMessagesFieldBuilder() {
      if (fulfillmentMessagesBuilder_ == null) {
        fulfillmentMessagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.Intent.Message,
                com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder,
                com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder>(
                fulfillmentMessages_,
                ((bitField0_ & 0x00000100) != 0),
                getParentForChildren(),
                isClean());
        fulfillmentMessages_ = null;
      }
      return fulfillmentMessagesBuilder_;
    }

    private java.lang.Object webhookSource_ = "";
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `source` field returned in the webhook response.
     * </pre>
     *
     * <code>string webhook_source = 8;</code>
     *
     * @return The webhookSource.
     */
    public java.lang.String getWebhookSource() {
      java.lang.Object ref = webhookSource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        webhookSource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `source` field returned in the webhook response.
     * </pre>
     *
     * <code>string webhook_source = 8;</code>
     *
     * @return The bytes for webhookSource.
     */
    public com.google.protobuf.ByteString getWebhookSourceBytes() {
      java.lang.Object ref = webhookSource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        webhookSource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `source` field returned in the webhook response.
     * </pre>
     *
     * <code>string webhook_source = 8;</code>
     *
     * @param value The webhookSource to set.
     * @return This builder for chaining.
     */
    public Builder setWebhookSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      webhookSource_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `source` field returned in the webhook response.
     * </pre>
     *
     * <code>string webhook_source = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWebhookSource() {
      webhookSource_ = getDefaultInstance().getWebhookSource();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `source` field returned in the webhook response.
     * </pre>
     *
     * <code>string webhook_source = 8;</code>
     *
     * @param value The bytes for webhookSource to set.
     * @return This builder for chaining.
     */
    public Builder setWebhookSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      webhookSource_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct webhookPayload_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        webhookPayloadBuilder_;
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `payload` field returned in the webhook response.
     * </pre>
     *
     * <code>.google.protobuf.Struct webhook_payload = 9;</code>
     *
     * @return Whether the webhookPayload field is set.
     */
    public boolean hasWebhookPayload() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `payload` field returned in the webhook response.
     * </pre>
     *
     * <code>.google.protobuf.Struct webhook_payload = 9;</code>
     *
     * @return The webhookPayload.
     */
    public com.google.protobuf.Struct getWebhookPayload() {
      if (webhookPayloadBuilder_ == null) {
        return webhookPayload_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : webhookPayload_;
      } else {
        return webhookPayloadBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `payload` field returned in the webhook response.
     * </pre>
     *
     * <code>.google.protobuf.Struct webhook_payload = 9;</code>
     */
    public Builder setWebhookPayload(com.google.protobuf.Struct value) {
      if (webhookPayloadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        webhookPayload_ = value;
      } else {
        webhookPayloadBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `payload` field returned in the webhook response.
     * </pre>
     *
     * <code>.google.protobuf.Struct webhook_payload = 9;</code>
     */
    public Builder setWebhookPayload(com.google.protobuf.Struct.Builder builderForValue) {
      if (webhookPayloadBuilder_ == null) {
        webhookPayload_ = builderForValue.build();
      } else {
        webhookPayloadBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `payload` field returned in the webhook response.
     * </pre>
     *
     * <code>.google.protobuf.Struct webhook_payload = 9;</code>
     */
    public Builder mergeWebhookPayload(com.google.protobuf.Struct value) {
      if (webhookPayloadBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && webhookPayload_ != null
            && webhookPayload_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getWebhookPayloadBuilder().mergeFrom(value);
        } else {
          webhookPayload_ = value;
        }
      } else {
        webhookPayloadBuilder_.mergeFrom(value);
      }
      if (webhookPayload_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `payload` field returned in the webhook response.
     * </pre>
     *
     * <code>.google.protobuf.Struct webhook_payload = 9;</code>
     */
    public Builder clearWebhookPayload() {
      bitField0_ = (bitField0_ & ~0x00000400);
      webhookPayload_ = null;
      if (webhookPayloadBuilder_ != null) {
        webhookPayloadBuilder_.dispose();
        webhookPayloadBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `payload` field returned in the webhook response.
     * </pre>
     *
     * <code>.google.protobuf.Struct webhook_payload = 9;</code>
     */
    public com.google.protobuf.Struct.Builder getWebhookPayloadBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getWebhookPayloadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `payload` field returned in the webhook response.
     * </pre>
     *
     * <code>.google.protobuf.Struct webhook_payload = 9;</code>
     */
    public com.google.protobuf.StructOrBuilder getWebhookPayloadOrBuilder() {
      if (webhookPayloadBuilder_ != null) {
        return webhookPayloadBuilder_.getMessageOrBuilder();
      } else {
        return webhookPayload_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : webhookPayload_;
      }
    }
    /**
     *
     *
     * <pre>
     * If the query was fulfilled by a webhook call, this field is set to the
     * value of the `payload` field returned in the webhook response.
     * </pre>
     *
     * <code>.google.protobuf.Struct webhook_payload = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getWebhookPayloadFieldBuilder() {
      if (webhookPayloadBuilder_ == null) {
        webhookPayloadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getWebhookPayload(), getParentForChildren(), isClean());
        webhookPayload_ = null;
      }
      return webhookPayloadBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.Context> outputContexts_ =
        java.util.Collections.emptyList();

    private void ensureOutputContextsIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        outputContexts_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.Context>(outputContexts_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Context,
            com.google.cloud.dialogflow.v2beta1.Context.Builder,
            com.google.cloud.dialogflow.v2beta1.ContextOrBuilder>
        outputContextsBuilder_;

    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Context> getOutputContextsList() {
      if (outputContextsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(outputContexts_);
      } else {
        return outputContextsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public int getOutputContextsCount() {
      if (outputContextsBuilder_ == null) {
        return outputContexts_.size();
      } else {
        return outputContextsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Context getOutputContexts(int index) {
      if (outputContextsBuilder_ == null) {
        return outputContexts_.get(index);
      } else {
        return outputContextsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public Builder setOutputContexts(int index, com.google.cloud.dialogflow.v2beta1.Context value) {
      if (outputContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputContextsIsMutable();
        outputContexts_.set(index, value);
        onChanged();
      } else {
        outputContextsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public Builder setOutputContexts(
        int index, com.google.cloud.dialogflow.v2beta1.Context.Builder builderForValue) {
      if (outputContextsBuilder_ == null) {
        ensureOutputContextsIsMutable();
        outputContexts_.set(index, builderForValue.build());
        onChanged();
      } else {
        outputContextsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public Builder addOutputContexts(com.google.cloud.dialogflow.v2beta1.Context value) {
      if (outputContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputContextsIsMutable();
        outputContexts_.add(value);
        onChanged();
      } else {
        outputContextsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public Builder addOutputContexts(int index, com.google.cloud.dialogflow.v2beta1.Context value) {
      if (outputContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputContextsIsMutable();
        outputContexts_.add(index, value);
        onChanged();
      } else {
        outputContextsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public Builder addOutputContexts(
        com.google.cloud.dialogflow.v2beta1.Context.Builder builderForValue) {
      if (outputContextsBuilder_ == null) {
        ensureOutputContextsIsMutable();
        outputContexts_.add(builderForValue.build());
        onChanged();
      } else {
        outputContextsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public Builder addOutputContexts(
        int index, com.google.cloud.dialogflow.v2beta1.Context.Builder builderForValue) {
      if (outputContextsBuilder_ == null) {
        ensureOutputContextsIsMutable();
        outputContexts_.add(index, builderForValue.build());
        onChanged();
      } else {
        outputContextsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public Builder addAllOutputContexts(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.Context> values) {
      if (outputContextsBuilder_ == null) {
        ensureOutputContextsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, outputContexts_);
        onChanged();
      } else {
        outputContextsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public Builder clearOutputContexts() {
      if (outputContextsBuilder_ == null) {
        outputContexts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        outputContextsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public Builder removeOutputContexts(int index) {
      if (outputContextsBuilder_ == null) {
        ensureOutputContextsIsMutable();
        outputContexts_.remove(index);
        onChanged();
      } else {
        outputContextsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Context.Builder getOutputContextsBuilder(int index) {
      return getOutputContextsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.ContextOrBuilder getOutputContextsOrBuilder(
        int index) {
      if (outputContextsBuilder_ == null) {
        return outputContexts_.get(index);
      } else {
        return outputContextsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.ContextOrBuilder>
        getOutputContextsOrBuilderList() {
      if (outputContextsBuilder_ != null) {
        return outputContextsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(outputContexts_);
      }
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Context.Builder addOutputContextsBuilder() {
      return getOutputContextsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2beta1.Context.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Context.Builder addOutputContextsBuilder(int index) {
      return getOutputContextsFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.v2beta1.Context.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The collection of output contexts. If applicable,
     * `output_contexts.parameters` contains entries with name
     * `&lt;parameter name&gt;.original` containing the original parameter values
     * before the query.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 10;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Context.Builder>
        getOutputContextsBuilderList() {
      return getOutputContextsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Context,
            com.google.cloud.dialogflow.v2beta1.Context.Builder,
            com.google.cloud.dialogflow.v2beta1.ContextOrBuilder>
        getOutputContextsFieldBuilder() {
      if (outputContextsBuilder_ == null) {
        outputContextsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.Context,
                com.google.cloud.dialogflow.v2beta1.Context.Builder,
                com.google.cloud.dialogflow.v2beta1.ContextOrBuilder>(
                outputContexts_,
                ((bitField0_ & 0x00000800) != 0),
                getParentForChildren(),
                isClean());
        outputContexts_ = null;
      }
      return outputContextsBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.Intent intent_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Intent,
            com.google.cloud.dialogflow.v2beta1.Intent.Builder,
            com.google.cloud.dialogflow.v2beta1.IntentOrBuilder>
        intentBuilder_;
    /**
     *
     *
     * <pre>
     * The intent that matched the conversational query. Some, not
     * all fields are filled in this message, including but not limited to:
     * `name`, `display_name`, `end_interaction` and `is_fallback`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Intent intent = 11;</code>
     *
     * @return Whether the intent field is set.
     */
    public boolean hasIntent() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The intent that matched the conversational query. Some, not
     * all fields are filled in this message, including but not limited to:
     * `name`, `display_name`, `end_interaction` and `is_fallback`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Intent intent = 11;</code>
     *
     * @return The intent.
     */
    public com.google.cloud.dialogflow.v2beta1.Intent getIntent() {
      if (intentBuilder_ == null) {
        return intent_ == null
            ? com.google.cloud.dialogflow.v2beta1.Intent.getDefaultInstance()
            : intent_;
      } else {
        return intentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The intent that matched the conversational query. Some, not
     * all fields are filled in this message, including but not limited to:
     * `name`, `display_name`, `end_interaction` and `is_fallback`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Intent intent = 11;</code>
     */
    public Builder setIntent(com.google.cloud.dialogflow.v2beta1.Intent value) {
      if (intentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        intent_ = value;
      } else {
        intentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent that matched the conversational query. Some, not
     * all fields are filled in this message, including but not limited to:
     * `name`, `display_name`, `end_interaction` and `is_fallback`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Intent intent = 11;</code>
     */
    public Builder setIntent(com.google.cloud.dialogflow.v2beta1.Intent.Builder builderForValue) {
      if (intentBuilder_ == null) {
        intent_ = builderForValue.build();
      } else {
        intentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent that matched the conversational query. Some, not
     * all fields are filled in this message, including but not limited to:
     * `name`, `display_name`, `end_interaction` and `is_fallback`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Intent intent = 11;</code>
     */
    public Builder mergeIntent(com.google.cloud.dialogflow.v2beta1.Intent value) {
      if (intentBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && intent_ != null
            && intent_ != com.google.cloud.dialogflow.v2beta1.Intent.getDefaultInstance()) {
          getIntentBuilder().mergeFrom(value);
        } else {
          intent_ = value;
        }
      } else {
        intentBuilder_.mergeFrom(value);
      }
      if (intent_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent that matched the conversational query. Some, not
     * all fields are filled in this message, including but not limited to:
     * `name`, `display_name`, `end_interaction` and `is_fallback`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Intent intent = 11;</code>
     */
    public Builder clearIntent() {
      bitField0_ = (bitField0_ & ~0x00001000);
      intent_ = null;
      if (intentBuilder_ != null) {
        intentBuilder_.dispose();
        intentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent that matched the conversational query. Some, not
     * all fields are filled in this message, including but not limited to:
     * `name`, `display_name`, `end_interaction` and `is_fallback`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Intent intent = 11;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Intent.Builder getIntentBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getIntentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The intent that matched the conversational query. Some, not
     * all fields are filled in this message, including but not limited to:
     * `name`, `display_name`, `end_interaction` and `is_fallback`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Intent intent = 11;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.IntentOrBuilder getIntentOrBuilder() {
      if (intentBuilder_ != null) {
        return intentBuilder_.getMessageOrBuilder();
      } else {
        return intent_ == null
            ? com.google.cloud.dialogflow.v2beta1.Intent.getDefaultInstance()
            : intent_;
      }
    }
    /**
     *
     *
     * <pre>
     * The intent that matched the conversational query. Some, not
     * all fields are filled in this message, including but not limited to:
     * `name`, `display_name`, `end_interaction` and `is_fallback`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Intent intent = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Intent,
            com.google.cloud.dialogflow.v2beta1.Intent.Builder,
            com.google.cloud.dialogflow.v2beta1.IntentOrBuilder>
        getIntentFieldBuilder() {
      if (intentBuilder_ == null) {
        intentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.Intent,
                com.google.cloud.dialogflow.v2beta1.Intent.Builder,
                com.google.cloud.dialogflow.v2beta1.IntentOrBuilder>(
                getIntent(), getParentForChildren(), isClean());
        intent_ = null;
      }
      return intentBuilder_;
    }

    private float intentDetectionConfidence_;
    /**
     *
     *
     * <pre>
     * The intent detection confidence. Values range from 0.0
     * (completely uncertain) to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to
     * help match the best intent within the classification threshold.
     * This value may change for the same end-user expression at any time due to a
     * model retraining or change in implementation.
     * If there are `multiple knowledge_answers` messages, this value is set to
     * the greatest `knowledgeAnswers.match_confidence` value in the list.
     * </pre>
     *
     * <code>float intent_detection_confidence = 12;</code>
     *
     * @return The intentDetectionConfidence.
     */
    @java.lang.Override
    public float getIntentDetectionConfidence() {
      return intentDetectionConfidence_;
    }
    /**
     *
     *
     * <pre>
     * The intent detection confidence. Values range from 0.0
     * (completely uncertain) to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to
     * help match the best intent within the classification threshold.
     * This value may change for the same end-user expression at any time due to a
     * model retraining or change in implementation.
     * If there are `multiple knowledge_answers` messages, this value is set to
     * the greatest `knowledgeAnswers.match_confidence` value in the list.
     * </pre>
     *
     * <code>float intent_detection_confidence = 12;</code>
     *
     * @param value The intentDetectionConfidence to set.
     * @return This builder for chaining.
     */
    public Builder setIntentDetectionConfidence(float value) {

      intentDetectionConfidence_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent detection confidence. Values range from 0.0
     * (completely uncertain) to 1.0 (completely certain).
     * This value is for informational purpose only and is only used to
     * help match the best intent within the classification threshold.
     * This value may change for the same end-user expression at any time due to a
     * model retraining or change in implementation.
     * If there are `multiple knowledge_answers` messages, this value is set to
     * the greatest `knowledgeAnswers.match_confidence` value in the list.
     * </pre>
     *
     * <code>float intent_detection_confidence = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntentDetectionConfidence() {
      bitField0_ = (bitField0_ & ~0x00002000);
      intentDetectionConfidence_ = 0F;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct diagnosticInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        diagnosticInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Free-form diagnostic information for the associated detect intent request.
     * The fields of this data can change without notice, so you should not write
     * code that depends on its structure.
     * The data may contain:
     *
     * - webhook call latency
     * - webhook errors
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 14;</code>
     *
     * @return Whether the diagnosticInfo field is set.
     */
    public boolean hasDiagnosticInfo() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Free-form diagnostic information for the associated detect intent request.
     * The fields of this data can change without notice, so you should not write
     * code that depends on its structure.
     * The data may contain:
     *
     * - webhook call latency
     * - webhook errors
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 14;</code>
     *
     * @return The diagnosticInfo.
     */
    public com.google.protobuf.Struct getDiagnosticInfo() {
      if (diagnosticInfoBuilder_ == null) {
        return diagnosticInfo_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : diagnosticInfo_;
      } else {
        return diagnosticInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Free-form diagnostic information for the associated detect intent request.
     * The fields of this data can change without notice, so you should not write
     * code that depends on its structure.
     * The data may contain:
     *
     * - webhook call latency
     * - webhook errors
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 14;</code>
     */
    public Builder setDiagnosticInfo(com.google.protobuf.Struct value) {
      if (diagnosticInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        diagnosticInfo_ = value;
      } else {
        diagnosticInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Free-form diagnostic information for the associated detect intent request.
     * The fields of this data can change without notice, so you should not write
     * code that depends on its structure.
     * The data may contain:
     *
     * - webhook call latency
     * - webhook errors
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 14;</code>
     */
    public Builder setDiagnosticInfo(com.google.protobuf.Struct.Builder builderForValue) {
      if (diagnosticInfoBuilder_ == null) {
        diagnosticInfo_ = builderForValue.build();
      } else {
        diagnosticInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Free-form diagnostic information for the associated detect intent request.
     * The fields of this data can change without notice, so you should not write
     * code that depends on its structure.
     * The data may contain:
     *
     * - webhook call latency
     * - webhook errors
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 14;</code>
     */
    public Builder mergeDiagnosticInfo(com.google.protobuf.Struct value) {
      if (diagnosticInfoBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && diagnosticInfo_ != null
            && diagnosticInfo_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getDiagnosticInfoBuilder().mergeFrom(value);
        } else {
          diagnosticInfo_ = value;
        }
      } else {
        diagnosticInfoBuilder_.mergeFrom(value);
      }
      if (diagnosticInfo_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Free-form diagnostic information for the associated detect intent request.
     * The fields of this data can change without notice, so you should not write
     * code that depends on its structure.
     * The data may contain:
     *
     * - webhook call latency
     * - webhook errors
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 14;</code>
     */
    public Builder clearDiagnosticInfo() {
      bitField0_ = (bitField0_ & ~0x00004000);
      diagnosticInfo_ = null;
      if (diagnosticInfoBuilder_ != null) {
        diagnosticInfoBuilder_.dispose();
        diagnosticInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Free-form diagnostic information for the associated detect intent request.
     * The fields of this data can change without notice, so you should not write
     * code that depends on its structure.
     * The data may contain:
     *
     * - webhook call latency
     * - webhook errors
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 14;</code>
     */
    public com.google.protobuf.Struct.Builder getDiagnosticInfoBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getDiagnosticInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Free-form diagnostic information for the associated detect intent request.
     * The fields of this data can change without notice, so you should not write
     * code that depends on its structure.
     * The data may contain:
     *
     * - webhook call latency
     * - webhook errors
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 14;</code>
     */
    public com.google.protobuf.StructOrBuilder getDiagnosticInfoOrBuilder() {
      if (diagnosticInfoBuilder_ != null) {
        return diagnosticInfoBuilder_.getMessageOrBuilder();
      } else {
        return diagnosticInfo_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : diagnosticInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Free-form diagnostic information for the associated detect intent request.
     * The fields of this data can change without notice, so you should not write
     * code that depends on its structure.
     * The data may contain:
     *
     * - webhook call latency
     * - webhook errors
     * </pre>
     *
     * <code>.google.protobuf.Struct diagnostic_info = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getDiagnosticInfoFieldBuilder() {
      if (diagnosticInfoBuilder_ == null) {
        diagnosticInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getDiagnosticInfo(), getParentForChildren(), isClean());
        diagnosticInfo_ = null;
      }
      return diagnosticInfoBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentimentAnalysisResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult,
            com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult.Builder,
            com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResultOrBuilder>
        sentimentAnalysisResultBuilder_;
    /**
     *
     *
     * <pre>
     * The sentiment analysis result, which depends on the
     * `sentiment_analysis_request_config` specified in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     *
     * @return Whether the sentimentAnalysisResult field is set.
     */
    public boolean hasSentimentAnalysisResult() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result, which depends on the
     * `sentiment_analysis_request_config` specified in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     *
     * @return The sentimentAnalysisResult.
     */
    public com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult
        getSentimentAnalysisResult() {
      if (sentimentAnalysisResultBuilder_ == null) {
        return sentimentAnalysisResult_ == null
            ? com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult.getDefaultInstance()
            : sentimentAnalysisResult_;
      } else {
        return sentimentAnalysisResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result, which depends on the
     * `sentiment_analysis_request_config` specified in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    public Builder setSentimentAnalysisResult(
        com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult value) {
      if (sentimentAnalysisResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sentimentAnalysisResult_ = value;
      } else {
        sentimentAnalysisResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result, which depends on the
     * `sentiment_analysis_request_config` specified in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    public Builder setSentimentAnalysisResult(
        com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult.Builder builderForValue) {
      if (sentimentAnalysisResultBuilder_ == null) {
        sentimentAnalysisResult_ = builderForValue.build();
      } else {
        sentimentAnalysisResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result, which depends on the
     * `sentiment_analysis_request_config` specified in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    public Builder mergeSentimentAnalysisResult(
        com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult value) {
      if (sentimentAnalysisResultBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && sentimentAnalysisResult_ != null
            && sentimentAnalysisResult_
                != com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult
                    .getDefaultInstance()) {
          getSentimentAnalysisResultBuilder().mergeFrom(value);
        } else {
          sentimentAnalysisResult_ = value;
        }
      } else {
        sentimentAnalysisResultBuilder_.mergeFrom(value);
      }
      if (sentimentAnalysisResult_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result, which depends on the
     * `sentiment_analysis_request_config` specified in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    public Builder clearSentimentAnalysisResult() {
      bitField0_ = (bitField0_ & ~0x00008000);
      sentimentAnalysisResult_ = null;
      if (sentimentAnalysisResultBuilder_ != null) {
        sentimentAnalysisResultBuilder_.dispose();
        sentimentAnalysisResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result, which depends on the
     * `sentiment_analysis_request_config` specified in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult.Builder
        getSentimentAnalysisResultBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getSentimentAnalysisResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result, which depends on the
     * `sentiment_analysis_request_config` specified in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResultOrBuilder
        getSentimentAnalysisResultOrBuilder() {
      if (sentimentAnalysisResultBuilder_ != null) {
        return sentimentAnalysisResultBuilder_.getMessageOrBuilder();
      } else {
        return sentimentAnalysisResult_ == null
            ? com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult.getDefaultInstance()
            : sentimentAnalysisResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * The sentiment analysis result, which depends on the
     * `sentiment_analysis_request_config` specified in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.dialogflow.v2beta1.SentimentAnalysisResult sentiment_analysis_result = 17;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult,
            com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult.Builder,
            com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResultOrBuilder>
        getSentimentAnalysisResultFieldBuilder() {
      if (sentimentAnalysisResultBuilder_ == null) {
        sentimentAnalysisResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult,
                com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResult.Builder,
                com.google.cloud.dialogflow.v2beta1.SentimentAnalysisResultOrBuilder>(
                getSentimentAnalysisResult(), getParentForChildren(), isClean());
        sentimentAnalysisResult_ = null;
      }
      return sentimentAnalysisResultBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledgeAnswers_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers,
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Builder,
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswersOrBuilder>
        knowledgeAnswersBuilder_;
    /**
     *
     *
     * <pre>
     * The result from Knowledge Connector (if any), ordered by decreasing
     * `KnowledgeAnswers.match_confidence`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledge_answers = 18;</code>
     *
     * @return Whether the knowledgeAnswers field is set.
     */
    public boolean hasKnowledgeAnswers() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The result from Knowledge Connector (if any), ordered by decreasing
     * `KnowledgeAnswers.match_confidence`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledge_answers = 18;</code>
     *
     * @return The knowledgeAnswers.
     */
    public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers getKnowledgeAnswers() {
      if (knowledgeAnswersBuilder_ == null) {
        return knowledgeAnswers_ == null
            ? com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.getDefaultInstance()
            : knowledgeAnswers_;
      } else {
        return knowledgeAnswersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The result from Knowledge Connector (if any), ordered by decreasing
     * `KnowledgeAnswers.match_confidence`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledge_answers = 18;</code>
     */
    public Builder setKnowledgeAnswers(com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers value) {
      if (knowledgeAnswersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        knowledgeAnswers_ = value;
      } else {
        knowledgeAnswersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result from Knowledge Connector (if any), ordered by decreasing
     * `KnowledgeAnswers.match_confidence`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledge_answers = 18;</code>
     */
    public Builder setKnowledgeAnswers(
        com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Builder builderForValue) {
      if (knowledgeAnswersBuilder_ == null) {
        knowledgeAnswers_ = builderForValue.build();
      } else {
        knowledgeAnswersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result from Knowledge Connector (if any), ordered by decreasing
     * `KnowledgeAnswers.match_confidence`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledge_answers = 18;</code>
     */
    public Builder mergeKnowledgeAnswers(
        com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers value) {
      if (knowledgeAnswersBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && knowledgeAnswers_ != null
            && knowledgeAnswers_
                != com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.getDefaultInstance()) {
          getKnowledgeAnswersBuilder().mergeFrom(value);
        } else {
          knowledgeAnswers_ = value;
        }
      } else {
        knowledgeAnswersBuilder_.mergeFrom(value);
      }
      if (knowledgeAnswers_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result from Knowledge Connector (if any), ordered by decreasing
     * `KnowledgeAnswers.match_confidence`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledge_answers = 18;</code>
     */
    public Builder clearKnowledgeAnswers() {
      bitField0_ = (bitField0_ & ~0x00010000);
      knowledgeAnswers_ = null;
      if (knowledgeAnswersBuilder_ != null) {
        knowledgeAnswersBuilder_.dispose();
        knowledgeAnswersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result from Knowledge Connector (if any), ordered by decreasing
     * `KnowledgeAnswers.match_confidence`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledge_answers = 18;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Builder
        getKnowledgeAnswersBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getKnowledgeAnswersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The result from Knowledge Connector (if any), ordered by decreasing
     * `KnowledgeAnswers.match_confidence`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledge_answers = 18;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.KnowledgeAnswersOrBuilder
        getKnowledgeAnswersOrBuilder() {
      if (knowledgeAnswersBuilder_ != null) {
        return knowledgeAnswersBuilder_.getMessageOrBuilder();
      } else {
        return knowledgeAnswers_ == null
            ? com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.getDefaultInstance()
            : knowledgeAnswers_;
      }
    }
    /**
     *
     *
     * <pre>
     * The result from Knowledge Connector (if any), ordered by decreasing
     * `KnowledgeAnswers.match_confidence`.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.KnowledgeAnswers knowledge_answers = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers,
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Builder,
            com.google.cloud.dialogflow.v2beta1.KnowledgeAnswersOrBuilder>
        getKnowledgeAnswersFieldBuilder() {
      if (knowledgeAnswersBuilder_ == null) {
        knowledgeAnswersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers,
                com.google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Builder,
                com.google.cloud.dialogflow.v2beta1.KnowledgeAnswersOrBuilder>(
                getKnowledgeAnswers(), getParentForChildren(), isClean());
        knowledgeAnswers_ = null;
      }
      return knowledgeAnswersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.QueryResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.QueryResult)
  private static final com.google.cloud.dialogflow.v2beta1.QueryResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.QueryResult();
  }

  public static com.google.cloud.dialogflow.v2beta1.QueryResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QueryResult> PARSER =
      new com.google.protobuf.AbstractParser<QueryResult>() {
        @java.lang.Override
        public QueryResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QueryResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QueryResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
