/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/participant.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents a suggestion for a human agent.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.Suggestion}
 */
@java.lang.Deprecated
public final class Suggestion extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Suggestion)
    SuggestionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Suggestion.newBuilder() to construct.
  private Suggestion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Suggestion() {
    name_ = "";
    articles_ = java.util.Collections.emptyList();
    faqAnswers_ = java.util.Collections.emptyList();
    latestMessage_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Suggestion();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.Suggestion.class,
            com.google.cloud.dialogflow.v2beta1.Suggestion.Builder.class);
  }

  public interface ArticleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.Suggestion.Article)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The article title.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The title.
     */
    java.lang.String getTitle();
    /**
     *
     *
     * <pre>
     * Output only. The article title.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The bytes for title.
     */
    com.google.protobuf.ByteString getTitleBytes();

    /**
     *
     *
     * <pre>
     * Output only. The article URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * Output only. The article URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * Output only. Article snippets.
     * </pre>
     *
     * <code>repeated string snippets = 3;</code>
     *
     * @return A list containing the snippets.
     */
    java.util.List<java.lang.String> getSnippetsList();
    /**
     *
     *
     * <pre>
     * Output only. Article snippets.
     * </pre>
     *
     * <code>repeated string snippets = 3;</code>
     *
     * @return The count of snippets.
     */
    int getSnippetsCount();
    /**
     *
     *
     * <pre>
     * Output only. Article snippets.
     * </pre>
     *
     * <code>repeated string snippets = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The snippets at the given index.
     */
    java.lang.String getSnippets(int index);
    /**
     *
     *
     * <pre>
     * Output only. Article snippets.
     * </pre>
     *
     * <code>repeated string snippets = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the snippets at the given index.
     */
    com.google.protobuf.ByteString getSnippetsBytes(int index);

    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    int getMetadataCount();
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    boolean containsMetadata(java.lang.String key);
    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getMetadata();
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getMetadataMap();
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    /* nullable */
    java.lang.String getMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    java.lang.String getMetadataOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Output only. The name of answer record, in the format of
     * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
     * Record ID&gt;"
     * </pre>
     *
     * <code>string answer_record = 6;</code>
     *
     * @return The answerRecord.
     */
    java.lang.String getAnswerRecord();
    /**
     *
     *
     * <pre>
     * Output only. The name of answer record, in the format of
     * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
     * Record ID&gt;"
     * </pre>
     *
     * <code>string answer_record = 6;</code>
     *
     * @return The bytes for answerRecord.
     */
    com.google.protobuf.ByteString getAnswerRecordBytes();
  }
  /**
   *
   *
   * <pre>
   * Represents suggested article.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Suggestion.Article}
   */
  public static final class Article extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Suggestion.Article)
      ArticleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Article.newBuilder() to construct.
    private Article(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Article() {
      title_ = "";
      uri_ = "";
      snippets_ = com.google.protobuf.LazyStringArrayList.emptyList();
      answerRecord_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Article();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_Article_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_Article_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Suggestion.Article.class,
              com.google.cloud.dialogflow.v2beta1.Suggestion.Article.Builder.class);
    }

    public static final int TITLE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object title_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The article title.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The title.
     */
    @java.lang.Override
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The article title.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The bytes for title.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int URI_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The article URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The article URI.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SNIPPETS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList snippets_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Output only. Article snippets.
     * </pre>
     *
     * <code>repeated string snippets = 3;</code>
     *
     * @return A list containing the snippets.
     */
    public com.google.protobuf.ProtocolStringList getSnippetsList() {
      return snippets_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Article snippets.
     * </pre>
     *
     * <code>repeated string snippets = 3;</code>
     *
     * @return The count of snippets.
     */
    public int getSnippetsCount() {
      return snippets_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Article snippets.
     * </pre>
     *
     * <code>repeated string snippets = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The snippets at the given index.
     */
    public java.lang.String getSnippets(int index) {
      return snippets_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Article snippets.
     * </pre>
     *
     * <code>repeated string snippets = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the snippets at the given index.
     */
    public com.google.protobuf.ByteString getSnippetsBytes(int index) {
      return snippets_.getByteString(index);
    }

    public static final int METADATA_FIELD_NUMBER = 5;

    private static final class MetadataDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.dialogflow.v2beta1.ParticipantProto
                  .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_Article_MetadataEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
      if (metadata_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      return metadata_;
    }

    public int getMetadataCount() {
      return internalGetMetadata().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    @java.lang.Override
    public boolean containsMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetadata().getMap().containsKey(key);
    }
    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
      return getMetadataMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
      return internalGetMetadata().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getMetadataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int ANSWER_RECORD_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object answerRecord_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of answer record, in the format of
     * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
     * Record ID&gt;"
     * </pre>
     *
     * <code>string answer_record = 6;</code>
     *
     * @return The answerRecord.
     */
    @java.lang.Override
    public java.lang.String getAnswerRecord() {
      java.lang.Object ref = answerRecord_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answerRecord_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of answer record, in the format of
     * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
     * Record ID&gt;"
     * </pre>
     *
     * <code>string answer_record = 6;</code>
     *
     * @return The bytes for answerRecord.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAnswerRecordBytes() {
      java.lang.Object ref = answerRecord_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answerRecord_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, title_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
      }
      for (int i = 0; i < snippets_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, snippets_.getRaw(i));
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, 5);
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerRecord_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, answerRecord_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, title_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < snippets_.size(); i++) {
          dataSize += computeStringSizeNoTag(snippets_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getSnippetsList().size();
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetMetadata().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
            MetadataDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, metadata__);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerRecord_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, answerRecord_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.Suggestion.Article)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.Suggestion.Article other =
          (com.google.cloud.dialogflow.v2beta1.Suggestion.Article) obj;

      if (!getTitle().equals(other.getTitle())) return false;
      if (!getUri().equals(other.getUri())) return false;
      if (!getSnippetsList().equals(other.getSnippetsList())) return false;
      if (!internalGetMetadata().equals(other.internalGetMetadata())) return false;
      if (!getAnswerRecord().equals(other.getAnswerRecord())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getTitle().hashCode();
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
      if (getSnippetsCount() > 0) {
        hash = (37 * hash) + SNIPPETS_FIELD_NUMBER;
        hash = (53 * hash) + getSnippetsList().hashCode();
      }
      if (!internalGetMetadata().getMap().isEmpty()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + internalGetMetadata().hashCode();
      }
      hash = (37 * hash) + ANSWER_RECORD_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerRecord().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.Article parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.Article parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.Article parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.Article parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.Article parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.Article parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.Article parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.Article parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.Article parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.Article parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.Article parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.Article parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.Suggestion.Article prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents suggested article.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2beta1.Suggestion.Article}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Suggestion.Article)
        com.google.cloud.dialogflow.v2beta1.Suggestion.ArticleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ParticipantProto
            .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_Article_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 5:
            return internalGetMetadata();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 5:
            return internalGetMutableMetadata();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ParticipantProto
            .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_Article_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.Suggestion.Article.class,
                com.google.cloud.dialogflow.v2beta1.Suggestion.Article.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.v2beta1.Suggestion.Article.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        title_ = "";
        uri_ = "";
        snippets_ = com.google.protobuf.LazyStringArrayList.emptyList();
        internalGetMutableMetadata().clear();
        answerRecord_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ParticipantProto
            .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_Article_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Suggestion.Article getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.Suggestion.Article.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Suggestion.Article build() {
        com.google.cloud.dialogflow.v2beta1.Suggestion.Article result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Suggestion.Article buildPartial() {
        com.google.cloud.dialogflow.v2beta1.Suggestion.Article result =
            new com.google.cloud.dialogflow.v2beta1.Suggestion.Article(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.dialogflow.v2beta1.Suggestion.Article result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.title_ = title_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.uri_ = uri_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          snippets_.makeImmutable();
          result.snippets_ = snippets_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.metadata_ = internalGetMetadata();
          result.metadata_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.answerRecord_ = answerRecord_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.v2beta1.Suggestion.Article) {
          return mergeFrom((com.google.cloud.dialogflow.v2beta1.Suggestion.Article) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.Suggestion.Article other) {
        if (other == com.google.cloud.dialogflow.v2beta1.Suggestion.Article.getDefaultInstance())
          return this;
        if (!other.getTitle().isEmpty()) {
          title_ = other.title_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getUri().isEmpty()) {
          uri_ = other.uri_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.snippets_.isEmpty()) {
          if (snippets_.isEmpty()) {
            snippets_ = other.snippets_;
            bitField0_ |= 0x00000004;
          } else {
            ensureSnippetsIsMutable();
            snippets_.addAll(other.snippets_);
          }
          onChanged();
        }
        internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
        bitField0_ |= 0x00000008;
        if (!other.getAnswerRecord().isEmpty()) {
          answerRecord_ = other.answerRecord_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  title_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  uri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureSnippetsIsMutable();
                  snippets_.add(s);
                  break;
                } // case 26
              case 42:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
                      input.readMessage(
                          MetadataDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableMetadata()
                      .getMutableMap()
                      .put(metadata__.getKey(), metadata__.getValue());
                  bitField0_ |= 0x00000008;
                  break;
                } // case 42
              case 50:
                {
                  answerRecord_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The article title.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The title.
       */
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The article title.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The bytes for title.
       */
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The article title.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @param value The title to set.
       * @return This builder for chaining.
       */
      public Builder setTitle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        title_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The article title.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTitle() {
        title_ = getDefaultInstance().getTitle();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The article title.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @param value The bytes for title to set.
       * @return This builder for chaining.
       */
      public Builder setTitleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        title_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The article URI.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The article URI.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The article URI.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        uri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The article URI.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {
        uri_ = getDefaultInstance().getUri();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The article URI.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        uri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList snippets_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureSnippetsIsMutable() {
        if (!snippets_.isModifiable()) {
          snippets_ = new com.google.protobuf.LazyStringArrayList(snippets_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * Output only. Article snippets.
       * </pre>
       *
       * <code>repeated string snippets = 3;</code>
       *
       * @return A list containing the snippets.
       */
      public com.google.protobuf.ProtocolStringList getSnippetsList() {
        snippets_.makeImmutable();
        return snippets_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Article snippets.
       * </pre>
       *
       * <code>repeated string snippets = 3;</code>
       *
       * @return The count of snippets.
       */
      public int getSnippetsCount() {
        return snippets_.size();
      }
      /**
       *
       *
       * <pre>
       * Output only. Article snippets.
       * </pre>
       *
       * <code>repeated string snippets = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The snippets at the given index.
       */
      public java.lang.String getSnippets(int index) {
        return snippets_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. Article snippets.
       * </pre>
       *
       * <code>repeated string snippets = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the snippets at the given index.
       */
      public com.google.protobuf.ByteString getSnippetsBytes(int index) {
        return snippets_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. Article snippets.
       * </pre>
       *
       * <code>repeated string snippets = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The snippets to set.
       * @return This builder for chaining.
       */
      public Builder setSnippets(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSnippetsIsMutable();
        snippets_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Article snippets.
       * </pre>
       *
       * <code>repeated string snippets = 3;</code>
       *
       * @param value The snippets to add.
       * @return This builder for chaining.
       */
      public Builder addSnippets(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSnippetsIsMutable();
        snippets_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Article snippets.
       * </pre>
       *
       * <code>repeated string snippets = 3;</code>
       *
       * @param values The snippets to add.
       * @return This builder for chaining.
       */
      public Builder addAllSnippets(java.lang.Iterable<java.lang.String> values) {
        ensureSnippetsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, snippets_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Article snippets.
       * </pre>
       *
       * <code>repeated string snippets = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSnippets() {
        snippets_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Article snippets.
       * </pre>
       *
       * <code>repeated string snippets = 3;</code>
       *
       * @param value The bytes of the snippets to add.
       * @return This builder for chaining.
       */
      public Builder addSnippetsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureSnippetsIsMutable();
        snippets_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMetadata() {
        if (metadata_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              MetadataDefaultEntryHolder.defaultEntry);
        }
        return metadata_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableMetadata() {
        if (metadata_ == null) {
          metadata_ =
              com.google.protobuf.MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
        }
        if (!metadata_.isMutable()) {
          metadata_ = metadata_.copy();
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return metadata_;
      }

      public int getMetadataCount() {
        return internalGetMetadata().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      @java.lang.Override
      public boolean containsMetadata(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetMetadata().getMap().containsKey(key);
      }
      /** Use {@link #getMetadataMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
        return getMetadataMap();
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
        return internalGetMetadata().getMap();
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getMetadataOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      @java.lang.Override
      public java.lang.String getMetadataOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearMetadata() {
        bitField0_ = (bitField0_ & ~0x00000008);
        internalGetMutableMetadata().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      public Builder removeMetadata(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableMetadata().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableMetadata() {
        bitField0_ |= 0x00000008;
        return internalGetMutableMetadata().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      public Builder putMetadata(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableMetadata().getMutableMap().put(key, value);
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      public Builder putAllMetadata(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableMetadata().getMutableMap().putAll(values);
        bitField0_ |= 0x00000008;
        return this;
      }

      private java.lang.Object answerRecord_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The name of answer record, in the format of
       * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
       * Record ID&gt;"
       * </pre>
       *
       * <code>string answer_record = 6;</code>
       *
       * @return The answerRecord.
       */
      public java.lang.String getAnswerRecord() {
        java.lang.Object ref = answerRecord_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          answerRecord_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of answer record, in the format of
       * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
       * Record ID&gt;"
       * </pre>
       *
       * <code>string answer_record = 6;</code>
       *
       * @return The bytes for answerRecord.
       */
      public com.google.protobuf.ByteString getAnswerRecordBytes() {
        java.lang.Object ref = answerRecord_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          answerRecord_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of answer record, in the format of
       * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
       * Record ID&gt;"
       * </pre>
       *
       * <code>string answer_record = 6;</code>
       *
       * @param value The answerRecord to set.
       * @return This builder for chaining.
       */
      public Builder setAnswerRecord(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        answerRecord_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of answer record, in the format of
       * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
       * Record ID&gt;"
       * </pre>
       *
       * <code>string answer_record = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAnswerRecord() {
        answerRecord_ = getDefaultInstance().getAnswerRecord();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of answer record, in the format of
       * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
       * Record ID&gt;"
       * </pre>
       *
       * <code>string answer_record = 6;</code>
       *
       * @param value The bytes for answerRecord to set.
       * @return This builder for chaining.
       */
      public Builder setAnswerRecordBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        answerRecord_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Suggestion.Article)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Suggestion.Article)
    private static final com.google.cloud.dialogflow.v2beta1.Suggestion.Article DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.Suggestion.Article();
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.Article getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Article> PARSER =
        new com.google.protobuf.AbstractParser<Article>() {
          @java.lang.Override
          public Article parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Article> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Article> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Suggestion.Article getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface FaqAnswerOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The piece of text from the `source` knowledge base document.
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @return The answer.
     */
    java.lang.String getAnswer();
    /**
     *
     *
     * <pre>
     * Output only. The piece of text from the `source` knowledge base document.
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @return The bytes for answer.
     */
    com.google.protobuf.ByteString getAnswerBytes();

    /**
     *
     *
     * <pre>
     * The system's confidence score that this Knowledge answer is a good match
     * for this conversational query, range from 0.0 (completely uncertain)
     * to 1.0 (completely certain).
     * </pre>
     *
     * <code>float confidence = 2;</code>
     *
     * @return The confidence.
     */
    float getConfidence();

    /**
     *
     *
     * <pre>
     * Output only. The corresponding FAQ question.
     * </pre>
     *
     * <code>string question = 3;</code>
     *
     * @return The question.
     */
    java.lang.String getQuestion();
    /**
     *
     *
     * <pre>
     * Output only. The corresponding FAQ question.
     * </pre>
     *
     * <code>string question = 3;</code>
     *
     * @return The bytes for question.
     */
    com.google.protobuf.ByteString getQuestionBytes();

    /**
     *
     *
     * <pre>
     * Output only. Indicates which Knowledge Document this answer was extracted
     * from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agent/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
     * </pre>
     *
     * <code>string source = 4;</code>
     *
     * @return The source.
     */
    java.lang.String getSource();
    /**
     *
     *
     * <pre>
     * Output only. Indicates which Knowledge Document this answer was extracted
     * from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agent/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
     * </pre>
     *
     * <code>string source = 4;</code>
     *
     * @return The bytes for source.
     */
    com.google.protobuf.ByteString getSourceBytes();

    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    int getMetadataCount();
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    boolean containsMetadata(java.lang.String key);
    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getMetadata();
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getMetadataMap();
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    /* nullable */
    java.lang.String getMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    java.lang.String getMetadataOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Output only. The name of answer record, in the format of
     * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
     * Record ID&gt;"
     * </pre>
     *
     * <code>string answer_record = 6;</code>
     *
     * @return The answerRecord.
     */
    java.lang.String getAnswerRecord();
    /**
     *
     *
     * <pre>
     * Output only. The name of answer record, in the format of
     * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
     * Record ID&gt;"
     * </pre>
     *
     * <code>string answer_record = 6;</code>
     *
     * @return The bytes for answerRecord.
     */
    com.google.protobuf.ByteString getAnswerRecordBytes();
  }
  /**
   *
   *
   * <pre>
   * Represents suggested answer from "frequently asked questions".
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer}
   */
  public static final class FaqAnswer extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer)
      FaqAnswerOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FaqAnswer.newBuilder() to construct.
    private FaqAnswer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FaqAnswer() {
      answer_ = "";
      question_ = "";
      source_ = "";
      answerRecord_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FaqAnswer();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_FaqAnswer_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_FaqAnswer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.class,
              com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.Builder.class);
    }

    public static final int ANSWER_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object answer_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The piece of text from the `source` knowledge base document.
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @return The answer.
     */
    @java.lang.Override
    public java.lang.String getAnswer() {
      java.lang.Object ref = answer_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answer_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The piece of text from the `source` knowledge base document.
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @return The bytes for answer.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAnswerBytes() {
      java.lang.Object ref = answer_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONFIDENCE_FIELD_NUMBER = 2;
    private float confidence_ = 0F;
    /**
     *
     *
     * <pre>
     * The system's confidence score that this Knowledge answer is a good match
     * for this conversational query, range from 0.0 (completely uncertain)
     * to 1.0 (completely certain).
     * </pre>
     *
     * <code>float confidence = 2;</code>
     *
     * @return The confidence.
     */
    @java.lang.Override
    public float getConfidence() {
      return confidence_;
    }

    public static final int QUESTION_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object question_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The corresponding FAQ question.
     * </pre>
     *
     * <code>string question = 3;</code>
     *
     * @return The question.
     */
    @java.lang.Override
    public java.lang.String getQuestion() {
      java.lang.Object ref = question_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        question_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The corresponding FAQ question.
     * </pre>
     *
     * <code>string question = 3;</code>
     *
     * @return The bytes for question.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQuestionBytes() {
      java.lang.Object ref = question_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        question_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SOURCE_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object source_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Indicates which Knowledge Document this answer was extracted
     * from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agent/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
     * </pre>
     *
     * <code>string source = 4;</code>
     *
     * @return The source.
     */
    @java.lang.Override
    public java.lang.String getSource() {
      java.lang.Object ref = source_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        source_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates which Knowledge Document this answer was extracted
     * from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/agent/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
     * </pre>
     *
     * <code>string source = 4;</code>
     *
     * @return The bytes for source.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceBytes() {
      java.lang.Object ref = source_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        source_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int METADATA_FIELD_NUMBER = 5;

    private static final class MetadataDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.dialogflow.v2beta1.ParticipantProto
                  .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_FaqAnswer_MetadataEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
      if (metadata_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      return metadata_;
    }

    public int getMetadataCount() {
      return internalGetMetadata().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    @java.lang.Override
    public boolean containsMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetadata().getMap().containsKey(key);
    }
    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
      return getMetadataMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
      return internalGetMetadata().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. A map that contains metadata about the answer and the
     * document from which it originates.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getMetadataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int ANSWER_RECORD_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private volatile java.lang.Object answerRecord_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of answer record, in the format of
     * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
     * Record ID&gt;"
     * </pre>
     *
     * <code>string answer_record = 6;</code>
     *
     * @return The answerRecord.
     */
    @java.lang.Override
    public java.lang.String getAnswerRecord() {
      java.lang.Object ref = answerRecord_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answerRecord_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of answer record, in the format of
     * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
     * Record ID&gt;"
     * </pre>
     *
     * <code>string answer_record = 6;</code>
     *
     * @return The bytes for answerRecord.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAnswerRecordBytes() {
      java.lang.Object ref = answerRecord_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answerRecord_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answer_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, answer_);
      }
      if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
        output.writeFloat(2, confidence_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(question_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, question_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, source_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, 5);
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerRecord_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, answerRecord_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answer_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, answer_);
      }
      if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, confidence_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(question_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, question_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, source_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetMetadata().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
            MetadataDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, metadata__);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerRecord_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, answerRecord_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer other =
          (com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer) obj;

      if (!getAnswer().equals(other.getAnswer())) return false;
      if (java.lang.Float.floatToIntBits(getConfidence())
          != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
      if (!getQuestion().equals(other.getQuestion())) return false;
      if (!getSource().equals(other.getSource())) return false;
      if (!internalGetMetadata().equals(other.internalGetMetadata())) return false;
      if (!getAnswerRecord().equals(other.getAnswerRecord())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ANSWER_FIELD_NUMBER;
      hash = (53 * hash) + getAnswer().hashCode();
      hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
      hash = (37 * hash) + QUESTION_FIELD_NUMBER;
      hash = (53 * hash) + getQuestion().hashCode();
      hash = (37 * hash) + SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getSource().hashCode();
      if (!internalGetMetadata().getMap().isEmpty()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + internalGetMetadata().hashCode();
      }
      hash = (37 * hash) + ANSWER_RECORD_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerRecord().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents suggested answer from "frequently asked questions".
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer)
        com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswerOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ParticipantProto
            .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_FaqAnswer_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 5:
            return internalGetMetadata();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 5:
            return internalGetMutableMetadata();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ParticipantProto
            .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_FaqAnswer_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.class,
                com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.Builder.class);
      }

      // Construct using com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        answer_ = "";
        confidence_ = 0F;
        question_ = "";
        source_ = "";
        internalGetMutableMetadata().clear();
        answerRecord_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ParticipantProto
            .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_FaqAnswer_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer build() {
        com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer buildPartial() {
        com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer result =
            new com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.answer_ = answer_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.confidence_ = confidence_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.question_ = question_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.source_ = source_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.metadata_ = internalGetMetadata();
          result.metadata_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.answerRecord_ = answerRecord_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer) {
          return mergeFrom((com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer other) {
        if (other == com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.getDefaultInstance())
          return this;
        if (!other.getAnswer().isEmpty()) {
          answer_ = other.answer_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getConfidence() != 0F) {
          setConfidence(other.getConfidence());
        }
        if (!other.getQuestion().isEmpty()) {
          question_ = other.question_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getSource().isEmpty()) {
          source_ = other.source_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
        bitField0_ |= 0x00000010;
        if (!other.getAnswerRecord().isEmpty()) {
          answerRecord_ = other.answerRecord_;
          bitField0_ |= 0x00000020;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  answer_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 21:
                {
                  confidence_ = input.readFloat();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 21
              case 26:
                {
                  question_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  source_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
                      input.readMessage(
                          MetadataDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
                  internalGetMutableMetadata()
                      .getMutableMap()
                      .put(metadata__.getKey(), metadata__.getValue());
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  answerRecord_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object answer_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The piece of text from the `source` knowledge base document.
       * </pre>
       *
       * <code>string answer = 1;</code>
       *
       * @return The answer.
       */
      public java.lang.String getAnswer() {
        java.lang.Object ref = answer_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          answer_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The piece of text from the `source` knowledge base document.
       * </pre>
       *
       * <code>string answer = 1;</code>
       *
       * @return The bytes for answer.
       */
      public com.google.protobuf.ByteString getAnswerBytes() {
        java.lang.Object ref = answer_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          answer_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The piece of text from the `source` knowledge base document.
       * </pre>
       *
       * <code>string answer = 1;</code>
       *
       * @param value The answer to set.
       * @return This builder for chaining.
       */
      public Builder setAnswer(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        answer_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The piece of text from the `source` knowledge base document.
       * </pre>
       *
       * <code>string answer = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAnswer() {
        answer_ = getDefaultInstance().getAnswer();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The piece of text from the `source` knowledge base document.
       * </pre>
       *
       * <code>string answer = 1;</code>
       *
       * @param value The bytes for answer to set.
       * @return This builder for chaining.
       */
      public Builder setAnswerBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        answer_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private float confidence_;
      /**
       *
       *
       * <pre>
       * The system's confidence score that this Knowledge answer is a good match
       * for this conversational query, range from 0.0 (completely uncertain)
       * to 1.0 (completely certain).
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @return The confidence.
       */
      @java.lang.Override
      public float getConfidence() {
        return confidence_;
      }
      /**
       *
       *
       * <pre>
       * The system's confidence score that this Knowledge answer is a good match
       * for this conversational query, range from 0.0 (completely uncertain)
       * to 1.0 (completely certain).
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @param value The confidence to set.
       * @return This builder for chaining.
       */
      public Builder setConfidence(float value) {

        confidence_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The system's confidence score that this Knowledge answer is a good match
       * for this conversational query, range from 0.0 (completely uncertain)
       * to 1.0 (completely certain).
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConfidence() {
        bitField0_ = (bitField0_ & ~0x00000002);
        confidence_ = 0F;
        onChanged();
        return this;
      }

      private java.lang.Object question_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The corresponding FAQ question.
       * </pre>
       *
       * <code>string question = 3;</code>
       *
       * @return The question.
       */
      public java.lang.String getQuestion() {
        java.lang.Object ref = question_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          question_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The corresponding FAQ question.
       * </pre>
       *
       * <code>string question = 3;</code>
       *
       * @return The bytes for question.
       */
      public com.google.protobuf.ByteString getQuestionBytes() {
        java.lang.Object ref = question_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          question_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The corresponding FAQ question.
       * </pre>
       *
       * <code>string question = 3;</code>
       *
       * @param value The question to set.
       * @return This builder for chaining.
       */
      public Builder setQuestion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        question_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The corresponding FAQ question.
       * </pre>
       *
       * <code>string question = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQuestion() {
        question_ = getDefaultInstance().getQuestion();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The corresponding FAQ question.
       * </pre>
       *
       * <code>string question = 3;</code>
       *
       * @param value The bytes for question to set.
       * @return This builder for chaining.
       */
      public Builder setQuestionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        question_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object source_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Indicates which Knowledge Document this answer was extracted
       * from.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/agent/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
       * </pre>
       *
       * <code>string source = 4;</code>
       *
       * @return The source.
       */
      public java.lang.String getSource() {
        java.lang.Object ref = source_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          source_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Indicates which Knowledge Document this answer was extracted
       * from.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/agent/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
       * </pre>
       *
       * <code>string source = 4;</code>
       *
       * @return The bytes for source.
       */
      public com.google.protobuf.ByteString getSourceBytes() {
        java.lang.Object ref = source_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          source_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Indicates which Knowledge Document this answer was extracted
       * from.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/agent/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
       * </pre>
       *
       * <code>string source = 4;</code>
       *
       * @param value The source to set.
       * @return This builder for chaining.
       */
      public Builder setSource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Indicates which Knowledge Document this answer was extracted
       * from.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/agent/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
       * </pre>
       *
       * <code>string source = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSource() {
        source_ = getDefaultInstance().getSource();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Indicates which Knowledge Document this answer was extracted
       * from.
       * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
       * ID&gt;/agent/knowledgeBases/&lt;Knowledge Base ID&gt;/documents/&lt;Document ID&gt;`.
       * </pre>
       *
       * <code>string source = 4;</code>
       *
       * @param value The bytes for source to set.
       * @return This builder for chaining.
       */
      public Builder setSourceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        source_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMetadata() {
        if (metadata_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              MetadataDefaultEntryHolder.defaultEntry);
        }
        return metadata_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableMetadata() {
        if (metadata_ == null) {
          metadata_ =
              com.google.protobuf.MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
        }
        if (!metadata_.isMutable()) {
          metadata_ = metadata_.copy();
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return metadata_;
      }

      public int getMetadataCount() {
        return internalGetMetadata().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      @java.lang.Override
      public boolean containsMetadata(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetMetadata().getMap().containsKey(key);
      }
      /** Use {@link #getMetadataMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
        return getMetadataMap();
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
        return internalGetMetadata().getMap();
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getMetadataOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      @java.lang.Override
      public java.lang.String getMetadataOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearMetadata() {
        bitField0_ = (bitField0_ & ~0x00000010);
        internalGetMutableMetadata().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      public Builder removeMetadata(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableMetadata().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableMetadata() {
        bitField0_ |= 0x00000010;
        return internalGetMutableMetadata().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      public Builder putMetadata(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableMetadata().getMutableMap().put(key, value);
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. A map that contains metadata about the answer and the
       * document from which it originates.
       * </pre>
       *
       * <code>map&lt;string, string&gt; metadata = 5;</code>
       */
      public Builder putAllMetadata(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableMetadata().getMutableMap().putAll(values);
        bitField0_ |= 0x00000010;
        return this;
      }

      private java.lang.Object answerRecord_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The name of answer record, in the format of
       * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
       * Record ID&gt;"
       * </pre>
       *
       * <code>string answer_record = 6;</code>
       *
       * @return The answerRecord.
       */
      public java.lang.String getAnswerRecord() {
        java.lang.Object ref = answerRecord_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          answerRecord_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of answer record, in the format of
       * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
       * Record ID&gt;"
       * </pre>
       *
       * <code>string answer_record = 6;</code>
       *
       * @return The bytes for answerRecord.
       */
      public com.google.protobuf.ByteString getAnswerRecordBytes() {
        java.lang.Object ref = answerRecord_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          answerRecord_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of answer record, in the format of
       * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
       * Record ID&gt;"
       * </pre>
       *
       * <code>string answer_record = 6;</code>
       *
       * @param value The answerRecord to set.
       * @return This builder for chaining.
       */
      public Builder setAnswerRecord(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        answerRecord_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of answer record, in the format of
       * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
       * Record ID&gt;"
       * </pre>
       *
       * <code>string answer_record = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAnswerRecord() {
        answerRecord_ = getDefaultInstance().getAnswerRecord();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of answer record, in the format of
       * "projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer
       * Record ID&gt;"
       * </pre>
       *
       * <code>string answer_record = 6;</code>
       *
       * @param value The bytes for answerRecord to set.
       * @return This builder for chaining.
       */
      public Builder setAnswerRecordBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        answerRecord_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer)
    private static final com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer();
    }

    public static com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FaqAnswer> PARSER =
        new com.google.protobuf.AbstractParser<FaqAnswer>() {
          @java.lang.Override
          public FaqAnswer parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FaqAnswer> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FaqAnswer> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of this suggestion.
   * Format:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/conversations/&lt;Conversation
   * ID&gt;/participants/&#42;&#47;suggestions/&lt;Suggestion ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of this suggestion.
   * Format:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/conversations/&lt;Conversation
   * ID&gt;/participants/&#42;&#47;suggestions/&lt;Suggestion ID&gt;`.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ARTICLES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.Suggestion.Article> articles_;
  /**
   *
   *
   * <pre>
   * Output only. Articles ordered by score in descending order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.Suggestion.Article> getArticlesList() {
    return articles_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Articles ordered by score in descending order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.Suggestion.ArticleOrBuilder>
      getArticlesOrBuilderList() {
    return articles_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Articles ordered by score in descending order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
   */
  @java.lang.Override
  public int getArticlesCount() {
    return articles_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Articles ordered by score in descending order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Suggestion.Article getArticles(int index) {
    return articles_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Articles ordered by score in descending order.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Suggestion.ArticleOrBuilder getArticlesOrBuilder(
      int index) {
    return articles_.get(index);
  }

  public static final int FAQ_ANSWERS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer> faqAnswers_;
  /**
   *
   *
   * <pre>
   * Output only. Answers extracted from FAQ documents.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer>
      getFaqAnswersList() {
    return faqAnswers_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Answers extracted from FAQ documents.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswerOrBuilder>
      getFaqAnswersOrBuilderList() {
    return faqAnswers_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Answers extracted from FAQ documents.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
   */
  @java.lang.Override
  public int getFaqAnswersCount() {
    return faqAnswers_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Answers extracted from FAQ documents.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer getFaqAnswers(int index) {
    return faqAnswers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Answers extracted from FAQ documents.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswerOrBuilder getFaqAnswersOrBuilder(
      int index) {
    return faqAnswers_.get(index);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the suggestion was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the suggestion was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the suggestion was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int LATEST_MESSAGE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object latestMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Latest message used as context to compile this suggestion.
   *
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
   * </pre>
   *
   * <code>string latest_message = 7;</code>
   *
   * @return The latestMessage.
   */
  @java.lang.Override
  public java.lang.String getLatestMessage() {
    java.lang.Object ref = latestMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      latestMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Latest message used as context to compile this suggestion.
   *
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
   * </pre>
   *
   * <code>string latest_message = 7;</code>
   *
   * @return The bytes for latestMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLatestMessageBytes() {
    java.lang.Object ref = latestMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      latestMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < articles_.size(); i++) {
      output.writeMessage(2, articles_.get(i));
    }
    for (int i = 0; i < faqAnswers_.size(); i++) {
      output.writeMessage(4, faqAnswers_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, latestMessage_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    for (int i = 0; i < articles_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, articles_.get(i));
    }
    for (int i = 0; i < faqAnswers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, faqAnswers_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(latestMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, latestMessage_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.Suggestion)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.Suggestion other =
        (com.google.cloud.dialogflow.v2beta1.Suggestion) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getArticlesList().equals(other.getArticlesList())) return false;
    if (!getFaqAnswersList().equals(other.getFaqAnswersList())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getLatestMessage().equals(other.getLatestMessage())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getArticlesCount() > 0) {
      hash = (37 * hash) + ARTICLES_FIELD_NUMBER;
      hash = (53 * hash) + getArticlesList().hashCode();
    }
    if (getFaqAnswersCount() > 0) {
      hash = (37 * hash) + FAQ_ANSWERS_FIELD_NUMBER;
      hash = (53 * hash) + getFaqAnswersList().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + LATEST_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getLatestMessage().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.Suggestion parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Suggestion parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Suggestion parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Suggestion parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Suggestion parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Suggestion parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Suggestion parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Suggestion parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Suggestion parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Suggestion parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Suggestion parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Suggestion parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.Suggestion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a suggestion for a human agent.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Suggestion}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Suggestion)
      com.google.cloud.dialogflow.v2beta1.SuggestionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Suggestion.class,
              com.google.cloud.dialogflow.v2beta1.Suggestion.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.Suggestion.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getArticlesFieldBuilder();
        getFaqAnswersFieldBuilder();
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (articlesBuilder_ == null) {
        articles_ = java.util.Collections.emptyList();
      } else {
        articles_ = null;
        articlesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (faqAnswersBuilder_ == null) {
        faqAnswers_ = java.util.Collections.emptyList();
      } else {
        faqAnswers_ = null;
        faqAnswersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      latestMessage_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_Suggestion_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Suggestion getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.Suggestion.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Suggestion build() {
      com.google.cloud.dialogflow.v2beta1.Suggestion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Suggestion buildPartial() {
      com.google.cloud.dialogflow.v2beta1.Suggestion result =
          new com.google.cloud.dialogflow.v2beta1.Suggestion(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dialogflow.v2beta1.Suggestion result) {
      if (articlesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          articles_ = java.util.Collections.unmodifiableList(articles_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.articles_ = articles_;
      } else {
        result.articles_ = articlesBuilder_.build();
      }
      if (faqAnswersBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          faqAnswers_ = java.util.Collections.unmodifiableList(faqAnswers_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.faqAnswers_ = faqAnswers_;
      } else {
        result.faqAnswers_ = faqAnswersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.Suggestion result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.latestMessage_ = latestMessage_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.Suggestion) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.Suggestion) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.Suggestion other) {
      if (other == com.google.cloud.dialogflow.v2beta1.Suggestion.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (articlesBuilder_ == null) {
        if (!other.articles_.isEmpty()) {
          if (articles_.isEmpty()) {
            articles_ = other.articles_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureArticlesIsMutable();
            articles_.addAll(other.articles_);
          }
          onChanged();
        }
      } else {
        if (!other.articles_.isEmpty()) {
          if (articlesBuilder_.isEmpty()) {
            articlesBuilder_.dispose();
            articlesBuilder_ = null;
            articles_ = other.articles_;
            bitField0_ = (bitField0_ & ~0x00000002);
            articlesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getArticlesFieldBuilder()
                    : null;
          } else {
            articlesBuilder_.addAllMessages(other.articles_);
          }
        }
      }
      if (faqAnswersBuilder_ == null) {
        if (!other.faqAnswers_.isEmpty()) {
          if (faqAnswers_.isEmpty()) {
            faqAnswers_ = other.faqAnswers_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureFaqAnswersIsMutable();
            faqAnswers_.addAll(other.faqAnswers_);
          }
          onChanged();
        }
      } else {
        if (!other.faqAnswers_.isEmpty()) {
          if (faqAnswersBuilder_.isEmpty()) {
            faqAnswersBuilder_.dispose();
            faqAnswersBuilder_ = null;
            faqAnswers_ = other.faqAnswers_;
            bitField0_ = (bitField0_ & ~0x00000004);
            faqAnswersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFaqAnswersFieldBuilder()
                    : null;
          } else {
            faqAnswersBuilder_.addAllMessages(other.faqAnswers_);
          }
        }
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getLatestMessage().isEmpty()) {
        latestMessage_ = other.latestMessage_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.dialogflow.v2beta1.Suggestion.Article m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.Suggestion.Article.parser(),
                        extensionRegistry);
                if (articlesBuilder_ == null) {
                  ensureArticlesIsMutable();
                  articles_.add(m);
                } else {
                  articlesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 34:
              {
                com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.parser(),
                        extensionRegistry);
                if (faqAnswersBuilder_ == null) {
                  ensureFaqAnswersIsMutable();
                  faqAnswers_.add(m);
                } else {
                  faqAnswersBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 58:
              {
                latestMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of this suggestion.
     * Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/conversations/&lt;Conversation
     * ID&gt;/participants/&#42;&#47;suggestions/&lt;Suggestion ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this suggestion.
     * Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/conversations/&lt;Conversation
     * ID&gt;/participants/&#42;&#47;suggestions/&lt;Suggestion ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this suggestion.
     * Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/conversations/&lt;Conversation
     * ID&gt;/participants/&#42;&#47;suggestions/&lt;Suggestion ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this suggestion.
     * Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/conversations/&lt;Conversation
     * ID&gt;/participants/&#42;&#47;suggestions/&lt;Suggestion ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of this suggestion.
     * Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/conversations/&lt;Conversation
     * ID&gt;/participants/&#42;&#47;suggestions/&lt;Suggestion ID&gt;`.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.Suggestion.Article> articles_ =
        java.util.Collections.emptyList();

    private void ensureArticlesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        articles_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.Suggestion.Article>(
                articles_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Suggestion.Article,
            com.google.cloud.dialogflow.v2beta1.Suggestion.Article.Builder,
            com.google.cloud.dialogflow.v2beta1.Suggestion.ArticleOrBuilder>
        articlesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Suggestion.Article>
        getArticlesList() {
      if (articlesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(articles_);
      } else {
        return articlesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public int getArticlesCount() {
      if (articlesBuilder_ == null) {
        return articles_.size();
      } else {
        return articlesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Suggestion.Article getArticles(int index) {
      if (articlesBuilder_ == null) {
        return articles_.get(index);
      } else {
        return articlesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public Builder setArticles(
        int index, com.google.cloud.dialogflow.v2beta1.Suggestion.Article value) {
      if (articlesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArticlesIsMutable();
        articles_.set(index, value);
        onChanged();
      } else {
        articlesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public Builder setArticles(
        int index, com.google.cloud.dialogflow.v2beta1.Suggestion.Article.Builder builderForValue) {
      if (articlesBuilder_ == null) {
        ensureArticlesIsMutable();
        articles_.set(index, builderForValue.build());
        onChanged();
      } else {
        articlesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public Builder addArticles(com.google.cloud.dialogflow.v2beta1.Suggestion.Article value) {
      if (articlesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArticlesIsMutable();
        articles_.add(value);
        onChanged();
      } else {
        articlesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public Builder addArticles(
        int index, com.google.cloud.dialogflow.v2beta1.Suggestion.Article value) {
      if (articlesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureArticlesIsMutable();
        articles_.add(index, value);
        onChanged();
      } else {
        articlesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public Builder addArticles(
        com.google.cloud.dialogflow.v2beta1.Suggestion.Article.Builder builderForValue) {
      if (articlesBuilder_ == null) {
        ensureArticlesIsMutable();
        articles_.add(builderForValue.build());
        onChanged();
      } else {
        articlesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public Builder addArticles(
        int index, com.google.cloud.dialogflow.v2beta1.Suggestion.Article.Builder builderForValue) {
      if (articlesBuilder_ == null) {
        ensureArticlesIsMutable();
        articles_.add(index, builderForValue.build());
        onChanged();
      } else {
        articlesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public Builder addAllArticles(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.Suggestion.Article>
            values) {
      if (articlesBuilder_ == null) {
        ensureArticlesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, articles_);
        onChanged();
      } else {
        articlesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public Builder clearArticles() {
      if (articlesBuilder_ == null) {
        articles_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        articlesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public Builder removeArticles(int index) {
      if (articlesBuilder_ == null) {
        ensureArticlesIsMutable();
        articles_.remove(index);
        onChanged();
      } else {
        articlesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Suggestion.Article.Builder getArticlesBuilder(
        int index) {
      return getArticlesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Suggestion.ArticleOrBuilder getArticlesOrBuilder(
        int index) {
      if (articlesBuilder_ == null) {
        return articles_.get(index);
      } else {
        return articlesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.Suggestion.ArticleOrBuilder>
        getArticlesOrBuilderList() {
      if (articlesBuilder_ != null) {
        return articlesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(articles_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Suggestion.Article.Builder addArticlesBuilder() {
      return getArticlesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2beta1.Suggestion.Article.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Suggestion.Article.Builder addArticlesBuilder(
        int index) {
      return getArticlesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.v2beta1.Suggestion.Article.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Articles ordered by score in descending order.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.Article articles = 2;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Suggestion.Article.Builder>
        getArticlesBuilderList() {
      return getArticlesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Suggestion.Article,
            com.google.cloud.dialogflow.v2beta1.Suggestion.Article.Builder,
            com.google.cloud.dialogflow.v2beta1.Suggestion.ArticleOrBuilder>
        getArticlesFieldBuilder() {
      if (articlesBuilder_ == null) {
        articlesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.Suggestion.Article,
                com.google.cloud.dialogflow.v2beta1.Suggestion.Article.Builder,
                com.google.cloud.dialogflow.v2beta1.Suggestion.ArticleOrBuilder>(
                articles_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        articles_ = null;
      }
      return articlesBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer> faqAnswers_ =
        java.util.Collections.emptyList();

    private void ensureFaqAnswersIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        faqAnswers_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer>(
                faqAnswers_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer,
            com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.Builder,
            com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswerOrBuilder>
        faqAnswersBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer>
        getFaqAnswersList() {
      if (faqAnswersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(faqAnswers_);
      } else {
        return faqAnswersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public int getFaqAnswersCount() {
      if (faqAnswersBuilder_ == null) {
        return faqAnswers_.size();
      } else {
        return faqAnswersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer getFaqAnswers(int index) {
      if (faqAnswersBuilder_ == null) {
        return faqAnswers_.get(index);
      } else {
        return faqAnswersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public Builder setFaqAnswers(
        int index, com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer value) {
      if (faqAnswersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaqAnswersIsMutable();
        faqAnswers_.set(index, value);
        onChanged();
      } else {
        faqAnswersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public Builder setFaqAnswers(
        int index,
        com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.Builder builderForValue) {
      if (faqAnswersBuilder_ == null) {
        ensureFaqAnswersIsMutable();
        faqAnswers_.set(index, builderForValue.build());
        onChanged();
      } else {
        faqAnswersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public Builder addFaqAnswers(com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer value) {
      if (faqAnswersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaqAnswersIsMutable();
        faqAnswers_.add(value);
        onChanged();
      } else {
        faqAnswersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public Builder addFaqAnswers(
        int index, com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer value) {
      if (faqAnswersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaqAnswersIsMutable();
        faqAnswers_.add(index, value);
        onChanged();
      } else {
        faqAnswersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public Builder addFaqAnswers(
        com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.Builder builderForValue) {
      if (faqAnswersBuilder_ == null) {
        ensureFaqAnswersIsMutable();
        faqAnswers_.add(builderForValue.build());
        onChanged();
      } else {
        faqAnswersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public Builder addFaqAnswers(
        int index,
        com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.Builder builderForValue) {
      if (faqAnswersBuilder_ == null) {
        ensureFaqAnswersIsMutable();
        faqAnswers_.add(index, builderForValue.build());
        onChanged();
      } else {
        faqAnswersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public Builder addAllFaqAnswers(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer>
            values) {
      if (faqAnswersBuilder_ == null) {
        ensureFaqAnswersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, faqAnswers_);
        onChanged();
      } else {
        faqAnswersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public Builder clearFaqAnswers() {
      if (faqAnswersBuilder_ == null) {
        faqAnswers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        faqAnswersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public Builder removeFaqAnswers(int index) {
      if (faqAnswersBuilder_ == null) {
        ensureFaqAnswersIsMutable();
        faqAnswers_.remove(index);
        onChanged();
      } else {
        faqAnswersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.Builder getFaqAnswersBuilder(
        int index) {
      return getFaqAnswersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswerOrBuilder getFaqAnswersOrBuilder(
        int index) {
      if (faqAnswersBuilder_ == null) {
        return faqAnswers_.get(index);
      } else {
        return faqAnswersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswerOrBuilder>
        getFaqAnswersOrBuilderList() {
      if (faqAnswersBuilder_ != null) {
        return faqAnswersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(faqAnswers_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.Builder addFaqAnswersBuilder() {
      return getFaqAnswersFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.Builder addFaqAnswersBuilder(
        int index) {
      return getFaqAnswersFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Answers extracted from FAQ documents.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer faq_answers = 4;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.Builder>
        getFaqAnswersBuilderList() {
      return getFaqAnswersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer,
            com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.Builder,
            com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswerOrBuilder>
        getFaqAnswersFieldBuilder() {
      if (faqAnswersBuilder_ == null) {
        faqAnswersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer,
                com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.Builder,
                com.google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswerOrBuilder>(
                faqAnswers_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        faqAnswers_ = null;
      }
      return faqAnswersBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the suggestion was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the suggestion was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the suggestion was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the suggestion was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the suggestion was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the suggestion was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the suggestion was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the suggestion was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the suggestion was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.lang.Object latestMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Latest message used as context to compile this suggestion.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string latest_message = 7;</code>
     *
     * @return The latestMessage.
     */
    public java.lang.String getLatestMessage() {
      java.lang.Object ref = latestMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        latestMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest message used as context to compile this suggestion.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string latest_message = 7;</code>
     *
     * @return The bytes for latestMessage.
     */
    public com.google.protobuf.ByteString getLatestMessageBytes() {
      java.lang.Object ref = latestMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        latestMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest message used as context to compile this suggestion.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string latest_message = 7;</code>
     *
     * @param value The latestMessage to set.
     * @return This builder for chaining.
     */
    public Builder setLatestMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      latestMessage_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest message used as context to compile this suggestion.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string latest_message = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLatestMessage() {
      latestMessage_ = getDefaultInstance().getLatestMessage();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest message used as context to compile this suggestion.
     *
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/messages/&lt;Message ID&gt;`.
     * </pre>
     *
     * <code>string latest_message = 7;</code>
     *
     * @param value The bytes for latestMessage to set.
     * @return This builder for chaining.
     */
    public Builder setLatestMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      latestMessage_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Suggestion)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Suggestion)
  private static final com.google.cloud.dialogflow.v2beta1.Suggestion DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.Suggestion();
  }

  public static com.google.cloud.dialogflow.v2beta1.Suggestion getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Suggestion> PARSER =
      new com.google.protobuf.AbstractParser<Suggestion>() {
        @java.lang.Override
        public Suggestion parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Suggestion> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Suggestion> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Suggestion getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
