/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/participant.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.dialogflow.v2beta1;

public interface SuggestionInputOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.SuggestionInput)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The ID of a suggestion selected by the human agent.
   * The suggestion(s) were generated in a previous call to
   * request Dialogflow assist.
   * The format is:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
   * ID&gt;` where &lt;Answer Record ID&gt; is an alphanumeric string.
   * </pre>
   *
   * <code>string answer_record = 1;</code>
   *
   * @return The answerRecord.
   */
  java.lang.String getAnswerRecord();
  /**
   *
   *
   * <pre>
   * Required. The ID of a suggestion selected by the human agent.
   * The suggestion(s) were generated in a previous call to
   * request Dialogflow assist.
   * The format is:
   * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/answerRecords/&lt;Answer Record
   * ID&gt;` where &lt;Answer Record ID&gt; is an alphanumeric string.
   * </pre>
   *
   * <code>string answer_record = 1;</code>
   *
   * @return The bytes for answerRecord.
   */
  com.google.protobuf.ByteString getAnswerRecordBytes();

  /**
   *
   *
   * <pre>
   * Optional. If the customer edited the suggestion before using it, include
   * the revised text here.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
   *
   * @return Whether the textOverride field is set.
   */
  boolean hasTextOverride();
  /**
   *
   *
   * <pre>
   * Optional. If the customer edited the suggestion before using it, include
   * the revised text here.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
   *
   * @return The textOverride.
   */
  com.google.cloud.dialogflow.v2beta1.TextInput getTextOverride();
  /**
   *
   *
   * <pre>
   * Optional. If the customer edited the suggestion before using it, include
   * the revised text here.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TextInput text_override = 2;</code>
   */
  com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder getTextOverrideOrBuilder();

  /**
   *
   *
   * <pre>
   * In Dialogflow assist for v3, the user can submit a form by sending
   * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
   * form is uniquely determined by the
   * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
   * field, which identifies a v3
   * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
   * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
   * are specified via the
   * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
   * field.
   *
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   *
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 4;</code>
   *
   * @return Whether the parameters field is set.
   */
  boolean hasParameters();
  /**
   *
   *
   * <pre>
   * In Dialogflow assist for v3, the user can submit a form by sending
   * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
   * form is uniquely determined by the
   * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
   * field, which identifies a v3
   * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
   * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
   * are specified via the
   * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
   * field.
   *
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   *
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 4;</code>
   *
   * @return The parameters.
   */
  com.google.protobuf.Struct getParameters();
  /**
   *
   *
   * <pre>
   * In Dialogflow assist for v3, the user can submit a form by sending
   * a [SuggestionInput][google.cloud.dialogflow.v2beta1.SuggestionInput]. The
   * form is uniquely determined by the
   * [answer_record][google.cloud.dialogflow.v2beta1.SuggestionInput.answer_record]
   * field, which identifies a v3
   * [QueryResult][google.cloud.dialogflow.v3alpha1.QueryResult] containing the
   * current [page][google.cloud.dialogflow.v3alpha1.Page]. The form parameters
   * are specified via the
   * [parameters][google.cloud.dialogflow.v2beta1.SuggestionInput.parameters]
   * field.
   *
   * Depending on your protocol or client library language, this is a
   * map, associative array, symbol table, dictionary, or JSON object
   * composed of a collection of (MapKey, MapValue) pairs:
   *
   * * MapKey type: string
   * * MapKey value: parameter name
   * * MapValue type: If parameter's entity type is a composite entity then use
   * map, otherwise, depending on the parameter value type, it could be one of
   * string, number, boolean, null, list or map.
   * * MapValue value: If parameter's entity type is a composite entity then use
   * map from composite entity property names to property values, otherwise,
   * use parameter value.
   * </pre>
   *
   * <code>.google.protobuf.Struct parameters = 4;</code>
   */
  com.google.protobuf.StructOrBuilder getParametersOrBuilder();

  /**
   *
   *
   * <pre>
   * The intent to be triggered on V3 agent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
   *
   * @return Whether the intentInput field is set.
   */
  boolean hasIntentInput();
  /**
   *
   *
   * <pre>
   * The intent to be triggered on V3 agent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
   *
   * @return The intentInput.
   */
  com.google.cloud.dialogflow.v2beta1.IntentInput getIntentInput();
  /**
   *
   *
   * <pre>
   * The intent to be triggered on V3 agent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 6;</code>
   */
  com.google.cloud.dialogflow.v2beta1.IntentInputOrBuilder getIntentInputOrBuilder();
}
