/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/participant.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * The request message for
 * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent].
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.AnalyzeContentRequest}
 */
public final class AnalyzeContentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.AnalyzeContentRequest)
    AnalyzeContentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnalyzeContentRequest.newBuilder() to construct.
  private AnalyzeContentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnalyzeContentRequest() {
    participant_ = "";
    cxCurrentPage_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnalyzeContentRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_AnalyzeContentRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ParticipantProto
        .internal_static_google_cloud_dialogflow_v2beta1_AnalyzeContentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.class,
            com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.Builder.class);
  }

  private int bitField0_;
  private int inputCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object input_;

  public enum InputCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT_INPUT(6),
    AUDIO_INPUT(7),
    EVENT_INPUT(8),
    SUGGESTION_INPUT(12),
    INTENT_INPUT(13),
    INPUT_NOT_SET(0);
    private final int value;

    private InputCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InputCase valueOf(int value) {
      return forNumber(value);
    }

    public static InputCase forNumber(int value) {
      switch (value) {
        case 6:
          return TEXT_INPUT;
        case 7:
          return AUDIO_INPUT;
        case 8:
          return EVENT_INPUT;
        case 12:
          return SUGGESTION_INPUT;
        case 13:
          return INTENT_INPUT;
        case 0:
          return INPUT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public InputCase getInputCase() {
    return InputCase.forNumber(inputCase_);
  }

  public static final int PARTICIPANT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object participant_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the participant this text comes from.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
   * </pre>
   *
   * <code>
   * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The participant.
   */
  @java.lang.Override
  public java.lang.String getParticipant() {
    java.lang.Object ref = participant_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      participant_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the participant this text comes from.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
   * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
   * </pre>
   *
   * <code>
   * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for participant.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParticipantBytes() {
    java.lang.Object ref = participant_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      participant_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEXT_INPUT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TextInput text_input = 6;</code>
   *
   * @return Whether the textInput field is set.
   */
  @java.lang.Override
  public boolean hasTextInput() {
    return inputCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TextInput text_input = 6;</code>
   *
   * @return The textInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TextInput getTextInput() {
    if (inputCase_ == 6) {
      return (com.google.cloud.dialogflow.v2beta1.TextInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The natural language text to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.TextInput text_input = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder getTextInputOrBuilder() {
    if (inputCase_ == 6) {
      return (com.google.cloud.dialogflow.v2beta1.TextInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance();
  }

  public static final int AUDIO_INPUT_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * The natural language speech audio to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AudioInput audio_input = 7;</code>
   *
   * @return Whether the audioInput field is set.
   */
  @java.lang.Override
  public boolean hasAudioInput() {
    return inputCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * The natural language speech audio to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AudioInput audio_input = 7;</code>
   *
   * @return The audioInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AudioInput getAudioInput() {
    if (inputCase_ == 7) {
      return (com.google.cloud.dialogflow.v2beta1.AudioInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.AudioInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The natural language speech audio to be processed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AudioInput audio_input = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AudioInputOrBuilder getAudioInputOrBuilder() {
    if (inputCase_ == 7) {
      return (com.google.cloud.dialogflow.v2beta1.AudioInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.AudioInput.getDefaultInstance();
  }

  public static final int EVENT_INPUT_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * An input event to send to Dialogflow.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.EventInput event_input = 8;</code>
   *
   * @return Whether the eventInput field is set.
   */
  @java.lang.Override
  public boolean hasEventInput() {
    return inputCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * An input event to send to Dialogflow.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.EventInput event_input = 8;</code>
   *
   * @return The eventInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.EventInput getEventInput() {
    if (inputCase_ == 8) {
      return (com.google.cloud.dialogflow.v2beta1.EventInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An input event to send to Dialogflow.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.EventInput event_input = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder getEventInputOrBuilder() {
    if (inputCase_ == 8) {
      return (com.google.cloud.dialogflow.v2beta1.EventInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance();
  }

  public static final int SUGGESTION_INPUT_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * An input representing the selection of a suggestion.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SuggestionInput suggestion_input = 12;</code>
   *
   * @return Whether the suggestionInput field is set.
   */
  @java.lang.Override
  public boolean hasSuggestionInput() {
    return inputCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * An input representing the selection of a suggestion.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SuggestionInput suggestion_input = 12;</code>
   *
   * @return The suggestionInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SuggestionInput getSuggestionInput() {
    if (inputCase_ == 12) {
      return (com.google.cloud.dialogflow.v2beta1.SuggestionInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.SuggestionInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An input representing the selection of a suggestion.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SuggestionInput suggestion_input = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SuggestionInputOrBuilder
      getSuggestionInputOrBuilder() {
    if (inputCase_ == 12) {
      return (com.google.cloud.dialogflow.v2beta1.SuggestionInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.SuggestionInput.getDefaultInstance();
  }

  public static final int INTENT_INPUT_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * The intent to be triggered on V3 agent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 13;</code>
   *
   * @return Whether the intentInput field is set.
   */
  @java.lang.Override
  public boolean hasIntentInput() {
    return inputCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * The intent to be triggered on V3 agent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 13;</code>
   *
   * @return The intentInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.IntentInput getIntentInput() {
    if (inputCase_ == 13) {
      return (com.google.cloud.dialogflow.v2beta1.IntentInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.IntentInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The intent to be triggered on V3 agent.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.IntentInputOrBuilder getIntentInputOrBuilder() {
    if (inputCase_ == 13) {
      return (com.google.cloud.dialogflow.v2beta1.IntentInput) input_;
    }
    return com.google.cloud.dialogflow.v2beta1.IntentInput.getDefaultInstance();
  }

  public static final int REPLY_AUDIO_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.dialogflow.v2beta1.OutputAudioConfig replyAudioConfig_;
  /**
   *
   *
   * <pre>
   * Speech synthesis configuration.
   * The speech synthesis settings for a virtual agent that may be configured
   * for the associated conversation profile are not used when calling
   * AnalyzeContent. If this configuration is not supplied, speech synthesis
   * is disabled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 5;</code>
   *
   * @return Whether the replyAudioConfig field is set.
   */
  @java.lang.Override
  public boolean hasReplyAudioConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Speech synthesis configuration.
   * The speech synthesis settings for a virtual agent that may be configured
   * for the associated conversation profile are not used when calling
   * AnalyzeContent. If this configuration is not supplied, speech synthesis
   * is disabled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 5;</code>
   *
   * @return The replyAudioConfig.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig getReplyAudioConfig() {
    return replyAudioConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
        : replyAudioConfig_;
  }
  /**
   *
   *
   * <pre>
   * Speech synthesis configuration.
   * The speech synthesis settings for a virtual agent that may be configured
   * for the associated conversation profile are not used when calling
   * AnalyzeContent. If this configuration is not supplied, speech synthesis
   * is disabled.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder
      getReplyAudioConfigOrBuilder() {
    return replyAudioConfig_ == null
        ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
        : replyAudioConfig_;
  }

  public static final int QUERY_PARAMS_FIELD_NUMBER = 9;
  private com.google.cloud.dialogflow.v2beta1.QueryParameters queryParams_;
  /**
   *
   *
   * <pre>
   * Parameters for a Dialogflow virtual-agent query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 9;</code>
   *
   * @return Whether the queryParams field is set.
   */
  @java.lang.Override
  public boolean hasQueryParams() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters for a Dialogflow virtual-agent query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 9;</code>
   *
   * @return The queryParams.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryParameters getQueryParams() {
    return queryParams_ == null
        ? com.google.cloud.dialogflow.v2beta1.QueryParameters.getDefaultInstance()
        : queryParams_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for a Dialogflow virtual-agent query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder getQueryParamsOrBuilder() {
    return queryParams_ == null
        ? com.google.cloud.dialogflow.v2beta1.QueryParameters.getDefaultInstance()
        : queryParams_;
  }

  public static final int ASSIST_QUERY_PARAMS_FIELD_NUMBER = 14;
  private com.google.cloud.dialogflow.v2beta1.AssistQueryParameters assistQueryParams_;
  /**
   *
   *
   * <pre>
   * Parameters for a human assist query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 14;</code>
   *
   * @return Whether the assistQueryParams field is set.
   */
  @java.lang.Override
  public boolean hasAssistQueryParams() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Parameters for a human assist query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 14;</code>
   *
   * @return The assistQueryParams.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AssistQueryParameters getAssistQueryParams() {
    return assistQueryParams_ == null
        ? com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.getDefaultInstance()
        : assistQueryParams_;
  }
  /**
   *
   *
   * <pre>
   * Parameters for a human assist query.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 14;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AssistQueryParametersOrBuilder
      getAssistQueryParamsOrBuilder() {
    return assistQueryParams_ == null
        ? com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.getDefaultInstance()
        : assistQueryParams_;
  }

  public static final int CX_PARAMETERS_FIELD_NUMBER = 18;
  private com.google.protobuf.Struct cxParameters_;
  /**
   *
   *
   * <pre>
   * Additional parameters to be put into Dialogflow CX session parameters. To
   * remove a parameter from the session, clients should explicitly set the
   * parameter value to null.
   *
   * Note: this field should only be used if you are connecting to a Dialogflow
   * CX agent.
   * </pre>
   *
   * <code>.google.protobuf.Struct cx_parameters = 18;</code>
   *
   * @return Whether the cxParameters field is set.
   */
  @java.lang.Override
  public boolean hasCxParameters() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Additional parameters to be put into Dialogflow CX session parameters. To
   * remove a parameter from the session, clients should explicitly set the
   * parameter value to null.
   *
   * Note: this field should only be used if you are connecting to a Dialogflow
   * CX agent.
   * </pre>
   *
   * <code>.google.protobuf.Struct cx_parameters = 18;</code>
   *
   * @return The cxParameters.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getCxParameters() {
    return cxParameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : cxParameters_;
  }
  /**
   *
   *
   * <pre>
   * Additional parameters to be put into Dialogflow CX session parameters. To
   * remove a parameter from the session, clients should explicitly set the
   * parameter value to null.
   *
   * Note: this field should only be used if you are connecting to a Dialogflow
   * CX agent.
   * </pre>
   *
   * <code>.google.protobuf.Struct cx_parameters = 18;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getCxParametersOrBuilder() {
    return cxParameters_ == null ? com.google.protobuf.Struct.getDefaultInstance() : cxParameters_;
  }

  public static final int CX_CURRENT_PAGE_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cxCurrentPage_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the CX page to override the `current_page` in the
   * session.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   *
   * If `cx_current_page` is specified, the previous state of the session will
   * be ignored by Dialogflow CX, including the [previous
   * page][QueryResult.current_page] and the [previous session
   * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
   * `cx_parameters` should be configured together to direct a session to a
   * specific state.
   *
   * Note: this field should only be used if you are connecting to a Dialogflow
   * CX agent.
   * </pre>
   *
   * <code>string cx_current_page = 20;</code>
   *
   * @return The cxCurrentPage.
   */
  @java.lang.Override
  public java.lang.String getCxCurrentPage() {
    java.lang.Object ref = cxCurrentPage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cxCurrentPage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the CX page to override the `current_page` in the
   * session.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
   * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
   *
   * If `cx_current_page` is specified, the previous state of the session will
   * be ignored by Dialogflow CX, including the [previous
   * page][QueryResult.current_page] and the [previous session
   * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
   * `cx_parameters` should be configured together to direct a session to a
   * specific state.
   *
   * Note: this field should only be used if you are connecting to a Dialogflow
   * CX agent.
   * </pre>
   *
   * <code>string cx_current_page = 20;</code>
   *
   * @return The bytes for cxCurrentPage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCxCurrentPageBytes() {
    java.lang.Object ref = cxCurrentPage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cxCurrentPage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MESSAGE_SEND_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp messageSendTime_;
  /**
   *
   *
   * <pre>
   * Optional. The send time of the message from end user or human agent's
   * perspective. It is used for identifying the same message under one
   * participant.
   *
   * Given two messages under the same participant:
   * * If send time are different regardless of whether the content of the
   * messages are exactly the same, the conversation will regard them as
   * two distinct messages sent by the participant.
   * * If send time is the same regardless of whether the content of the
   * messages are exactly the same, the conversation will regard them as
   * same message, and ignore the message received later.
   *
   * If the value is not provided, a new request will always be regarded as a
   * new message without any de-duplication.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp message_send_time = 10;</code>
   *
   * @return Whether the messageSendTime field is set.
   */
  @java.lang.Override
  public boolean hasMessageSendTime() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The send time of the message from end user or human agent's
   * perspective. It is used for identifying the same message under one
   * participant.
   *
   * Given two messages under the same participant:
   * * If send time are different regardless of whether the content of the
   * messages are exactly the same, the conversation will regard them as
   * two distinct messages sent by the participant.
   * * If send time is the same regardless of whether the content of the
   * messages are exactly the same, the conversation will regard them as
   * same message, and ignore the message received later.
   *
   * If the value is not provided, a new request will always be regarded as a
   * new message without any de-duplication.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp message_send_time = 10;</code>
   *
   * @return The messageSendTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getMessageSendTime() {
    return messageSendTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : messageSendTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The send time of the message from end user or human agent's
   * perspective. It is used for identifying the same message under one
   * participant.
   *
   * Given two messages under the same participant:
   * * If send time are different regardless of whether the content of the
   * messages are exactly the same, the conversation will regard them as
   * two distinct messages sent by the participant.
   * * If send time is the same regardless of whether the content of the
   * messages are exactly the same, the conversation will regard them as
   * same message, and ignore the message received later.
   *
   * If the value is not provided, a new request will always be regarded as a
   * new message without any de-duplication.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp message_send_time = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getMessageSendTimeOrBuilder() {
    return messageSendTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : messageSendTime_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * A unique identifier for this request. Restricted to 36 ASCII characters.
   * A random UUID is recommended.
   * This request is only idempotent if a `request_id` is provided.
   * </pre>
   *
   * <code>string request_id = 11;</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique identifier for this request. Restricted to 36 ASCII characters.
   * A random UUID is recommended.
   * This request is only idempotent if a `request_id` is provided.
   * </pre>
   *
   * <code>string request_id = 11;</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(participant_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, participant_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getReplyAudioConfig());
    }
    if (inputCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.dialogflow.v2beta1.TextInput) input_);
    }
    if (inputCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.dialogflow.v2beta1.AudioInput) input_);
    }
    if (inputCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.dialogflow.v2beta1.EventInput) input_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(9, getQueryParams());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(10, getMessageSendTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, requestId_);
    }
    if (inputCase_ == 12) {
      output.writeMessage(12, (com.google.cloud.dialogflow.v2beta1.SuggestionInput) input_);
    }
    if (inputCase_ == 13) {
      output.writeMessage(13, (com.google.cloud.dialogflow.v2beta1.IntentInput) input_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(14, getAssistQueryParams());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(18, getCxParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cxCurrentPage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 20, cxCurrentPage_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(participant_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, participant_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getReplyAudioConfig());
    }
    if (inputCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.dialogflow.v2beta1.TextInput) input_);
    }
    if (inputCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.dialogflow.v2beta1.AudioInput) input_);
    }
    if (inputCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.dialogflow.v2beta1.EventInput) input_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getQueryParams());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getMessageSendTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, requestId_);
    }
    if (inputCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.dialogflow.v2beta1.SuggestionInput) input_);
    }
    if (inputCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.dialogflow.v2beta1.IntentInput) input_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getAssistQueryParams());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, getCxParameters());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cxCurrentPage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, cxCurrentPage_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest other =
        (com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest) obj;

    if (!getParticipant().equals(other.getParticipant())) return false;
    if (hasReplyAudioConfig() != other.hasReplyAudioConfig()) return false;
    if (hasReplyAudioConfig()) {
      if (!getReplyAudioConfig().equals(other.getReplyAudioConfig())) return false;
    }
    if (hasQueryParams() != other.hasQueryParams()) return false;
    if (hasQueryParams()) {
      if (!getQueryParams().equals(other.getQueryParams())) return false;
    }
    if (hasAssistQueryParams() != other.hasAssistQueryParams()) return false;
    if (hasAssistQueryParams()) {
      if (!getAssistQueryParams().equals(other.getAssistQueryParams())) return false;
    }
    if (hasCxParameters() != other.hasCxParameters()) return false;
    if (hasCxParameters()) {
      if (!getCxParameters().equals(other.getCxParameters())) return false;
    }
    if (!getCxCurrentPage().equals(other.getCxCurrentPage())) return false;
    if (hasMessageSendTime() != other.hasMessageSendTime()) return false;
    if (hasMessageSendTime()) {
      if (!getMessageSendTime().equals(other.getMessageSendTime())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getInputCase().equals(other.getInputCase())) return false;
    switch (inputCase_) {
      case 6:
        if (!getTextInput().equals(other.getTextInput())) return false;
        break;
      case 7:
        if (!getAudioInput().equals(other.getAudioInput())) return false;
        break;
      case 8:
        if (!getEventInput().equals(other.getEventInput())) return false;
        break;
      case 12:
        if (!getSuggestionInput().equals(other.getSuggestionInput())) return false;
        break;
      case 13:
        if (!getIntentInput().equals(other.getIntentInput())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARTICIPANT_FIELD_NUMBER;
    hash = (53 * hash) + getParticipant().hashCode();
    if (hasReplyAudioConfig()) {
      hash = (37 * hash) + REPLY_AUDIO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getReplyAudioConfig().hashCode();
    }
    if (hasQueryParams()) {
      hash = (37 * hash) + QUERY_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getQueryParams().hashCode();
    }
    if (hasAssistQueryParams()) {
      hash = (37 * hash) + ASSIST_QUERY_PARAMS_FIELD_NUMBER;
      hash = (53 * hash) + getAssistQueryParams().hashCode();
    }
    if (hasCxParameters()) {
      hash = (37 * hash) + CX_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getCxParameters().hashCode();
    }
    hash = (37 * hash) + CX_CURRENT_PAGE_FIELD_NUMBER;
    hash = (53 * hash) + getCxCurrentPage().hashCode();
    if (hasMessageSendTime()) {
      hash = (37 * hash) + MESSAGE_SEND_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getMessageSendTime().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    switch (inputCase_) {
      case 6:
        hash = (37 * hash) + TEXT_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getTextInput().hashCode();
        break;
      case 7:
        hash = (37 * hash) + AUDIO_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getAudioInput().hashCode();
        break;
      case 8:
        hash = (37 * hash) + EVENT_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getEventInput().hashCode();
        break;
      case 12:
        hash = (37 * hash) + SUGGESTION_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getSuggestionInput().hashCode();
        break;
      case 13:
        hash = (37 * hash) + INTENT_INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getIntentInput().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for
   * [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent].
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.AnalyzeContentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.AnalyzeContentRequest)
      com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_AnalyzeContentRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_AnalyzeContentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.class,
              com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReplyAudioConfigFieldBuilder();
        getQueryParamsFieldBuilder();
        getAssistQueryParamsFieldBuilder();
        getCxParametersFieldBuilder();
        getMessageSendTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      participant_ = "";
      if (textInputBuilder_ != null) {
        textInputBuilder_.clear();
      }
      if (audioInputBuilder_ != null) {
        audioInputBuilder_.clear();
      }
      if (eventInputBuilder_ != null) {
        eventInputBuilder_.clear();
      }
      if (suggestionInputBuilder_ != null) {
        suggestionInputBuilder_.clear();
      }
      if (intentInputBuilder_ != null) {
        intentInputBuilder_.clear();
      }
      replyAudioConfig_ = null;
      if (replyAudioConfigBuilder_ != null) {
        replyAudioConfigBuilder_.dispose();
        replyAudioConfigBuilder_ = null;
      }
      queryParams_ = null;
      if (queryParamsBuilder_ != null) {
        queryParamsBuilder_.dispose();
        queryParamsBuilder_ = null;
      }
      assistQueryParams_ = null;
      if (assistQueryParamsBuilder_ != null) {
        assistQueryParamsBuilder_.dispose();
        assistQueryParamsBuilder_ = null;
      }
      cxParameters_ = null;
      if (cxParametersBuilder_ != null) {
        cxParametersBuilder_.dispose();
        cxParametersBuilder_ = null;
      }
      cxCurrentPage_ = "";
      messageSendTime_ = null;
      if (messageSendTimeBuilder_ != null) {
        messageSendTimeBuilder_.dispose();
        messageSendTimeBuilder_ = null;
      }
      requestId_ = "";
      inputCase_ = 0;
      input_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ParticipantProto
          .internal_static_google_cloud_dialogflow_v2beta1_AnalyzeContentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest build() {
      com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest buildPartial() {
      com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest result =
          new com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.participant_ = participant_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.replyAudioConfig_ =
            replyAudioConfigBuilder_ == null ? replyAudioConfig_ : replyAudioConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.queryParams_ =
            queryParamsBuilder_ == null ? queryParams_ : queryParamsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.assistQueryParams_ =
            assistQueryParamsBuilder_ == null
                ? assistQueryParams_
                : assistQueryParamsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.cxParameters_ =
            cxParametersBuilder_ == null ? cxParameters_ : cxParametersBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.cxCurrentPage_ = cxCurrentPage_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.messageSendTime_ =
            messageSendTimeBuilder_ == null ? messageSendTime_ : messageSendTimeBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.requestId_ = requestId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest result) {
      result.inputCase_ = inputCase_;
      result.input_ = this.input_;
      if (inputCase_ == 6 && textInputBuilder_ != null) {
        result.input_ = textInputBuilder_.build();
      }
      if (inputCase_ == 7 && audioInputBuilder_ != null) {
        result.input_ = audioInputBuilder_.build();
      }
      if (inputCase_ == 8 && eventInputBuilder_ != null) {
        result.input_ = eventInputBuilder_.build();
      }
      if (inputCase_ == 12 && suggestionInputBuilder_ != null) {
        result.input_ = suggestionInputBuilder_.build();
      }
      if (inputCase_ == 13 && intentInputBuilder_ != null) {
        result.input_ = intentInputBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest other) {
      if (other == com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.getDefaultInstance())
        return this;
      if (!other.getParticipant().isEmpty()) {
        participant_ = other.participant_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasReplyAudioConfig()) {
        mergeReplyAudioConfig(other.getReplyAudioConfig());
      }
      if (other.hasQueryParams()) {
        mergeQueryParams(other.getQueryParams());
      }
      if (other.hasAssistQueryParams()) {
        mergeAssistQueryParams(other.getAssistQueryParams());
      }
      if (other.hasCxParameters()) {
        mergeCxParameters(other.getCxParameters());
      }
      if (!other.getCxCurrentPage().isEmpty()) {
        cxCurrentPage_ = other.cxCurrentPage_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasMessageSendTime()) {
        mergeMessageSendTime(other.getMessageSendTime());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      switch (other.getInputCase()) {
        case TEXT_INPUT:
          {
            mergeTextInput(other.getTextInput());
            break;
          }
        case AUDIO_INPUT:
          {
            mergeAudioInput(other.getAudioInput());
            break;
          }
        case EVENT_INPUT:
          {
            mergeEventInput(other.getEventInput());
            break;
          }
        case SUGGESTION_INPUT:
          {
            mergeSuggestionInput(other.getSuggestionInput());
            break;
          }
        case INTENT_INPUT:
          {
            mergeIntentInput(other.getIntentInput());
            break;
          }
        case INPUT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                participant_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 42:
              {
                input.readMessage(
                    getReplyAudioConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getTextInputFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getAudioInputFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getEventInputFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getQueryParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getMessageSendTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 82
            case 90:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getSuggestionInputFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getIntentInputFieldBuilder().getBuilder(), extensionRegistry);
                inputCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getAssistQueryParamsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 114
            case 146:
              {
                input.readMessage(getCxParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 146
            case 162:
              {
                cxCurrentPage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 162
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int inputCase_ = 0;
    private java.lang.Object input_;

    public InputCase getInputCase() {
      return InputCase.forNumber(inputCase_);
    }

    public Builder clearInput() {
      inputCase_ = 0;
      input_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object participant_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The participant.
     */
    public java.lang.String getParticipant() {
      java.lang.Object ref = participant_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        participant_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for participant.
     */
    public com.google.protobuf.ByteString getParticipantBytes() {
      java.lang.Object ref = participant_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        participant_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The participant to set.
     * @return This builder for chaining.
     */
    public Builder setParticipant(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      participant_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParticipant() {
      participant_ = getDefaultInstance().getParticipant();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the participant this text comes from.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location
     * ID&gt;/conversations/&lt;Conversation ID&gt;/participants/&lt;Participant ID&gt;`.
     * </pre>
     *
     * <code>
     * string participant = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for participant to set.
     * @return This builder for chaining.
     */
    public Builder setParticipantBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      participant_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TextInput,
            com.google.cloud.dialogflow.v2beta1.TextInput.Builder,
            com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder>
        textInputBuilder_;
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_input = 6;</code>
     *
     * @return Whether the textInput field is set.
     */
    @java.lang.Override
    public boolean hasTextInput() {
      return inputCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_input = 6;</code>
     *
     * @return The textInput.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TextInput getTextInput() {
      if (textInputBuilder_ == null) {
        if (inputCase_ == 6) {
          return (com.google.cloud.dialogflow.v2beta1.TextInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance();
      } else {
        if (inputCase_ == 6) {
          return textInputBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_input = 6;</code>
     */
    public Builder setTextInput(com.google.cloud.dialogflow.v2beta1.TextInput value) {
      if (textInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        textInputBuilder_.setMessage(value);
      }
      inputCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_input = 6;</code>
     */
    public Builder setTextInput(
        com.google.cloud.dialogflow.v2beta1.TextInput.Builder builderForValue) {
      if (textInputBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        textInputBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_input = 6;</code>
     */
    public Builder mergeTextInput(com.google.cloud.dialogflow.v2beta1.TextInput value) {
      if (textInputBuilder_ == null) {
        if (inputCase_ == 6
            && input_ != com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.v2beta1.TextInput.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.TextInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 6) {
          textInputBuilder_.mergeFrom(value);
        } else {
          textInputBuilder_.setMessage(value);
        }
      }
      inputCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_input = 6;</code>
     */
    public Builder clearTextInput() {
      if (textInputBuilder_ == null) {
        if (inputCase_ == 6) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 6) {
          inputCase_ = 0;
          input_ = null;
        }
        textInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_input = 6;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.TextInput.Builder getTextInputBuilder() {
      return getTextInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_input = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder getTextInputOrBuilder() {
      if ((inputCase_ == 6) && (textInputBuilder_ != null)) {
        return textInputBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 6) {
          return (com.google.cloud.dialogflow.v2beta1.TextInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language text to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.TextInput text_input = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.TextInput,
            com.google.cloud.dialogflow.v2beta1.TextInput.Builder,
            com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder>
        getTextInputFieldBuilder() {
      if (textInputBuilder_ == null) {
        if (!(inputCase_ == 6)) {
          input_ = com.google.cloud.dialogflow.v2beta1.TextInput.getDefaultInstance();
        }
        textInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.TextInput,
                com.google.cloud.dialogflow.v2beta1.TextInput.Builder,
                com.google.cloud.dialogflow.v2beta1.TextInputOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.TextInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 6;
      onChanged();
      return textInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.AudioInput,
            com.google.cloud.dialogflow.v2beta1.AudioInput.Builder,
            com.google.cloud.dialogflow.v2beta1.AudioInputOrBuilder>
        audioInputBuilder_;
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AudioInput audio_input = 7;</code>
     *
     * @return Whether the audioInput field is set.
     */
    @java.lang.Override
    public boolean hasAudioInput() {
      return inputCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AudioInput audio_input = 7;</code>
     *
     * @return The audioInput.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AudioInput getAudioInput() {
      if (audioInputBuilder_ == null) {
        if (inputCase_ == 7) {
          return (com.google.cloud.dialogflow.v2beta1.AudioInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.AudioInput.getDefaultInstance();
      } else {
        if (inputCase_ == 7) {
          return audioInputBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.AudioInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AudioInput audio_input = 7;</code>
     */
    public Builder setAudioInput(com.google.cloud.dialogflow.v2beta1.AudioInput value) {
      if (audioInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        audioInputBuilder_.setMessage(value);
      }
      inputCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AudioInput audio_input = 7;</code>
     */
    public Builder setAudioInput(
        com.google.cloud.dialogflow.v2beta1.AudioInput.Builder builderForValue) {
      if (audioInputBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        audioInputBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AudioInput audio_input = 7;</code>
     */
    public Builder mergeAudioInput(com.google.cloud.dialogflow.v2beta1.AudioInput value) {
      if (audioInputBuilder_ == null) {
        if (inputCase_ == 7
            && input_ != com.google.cloud.dialogflow.v2beta1.AudioInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.v2beta1.AudioInput.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.AudioInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 7) {
          audioInputBuilder_.mergeFrom(value);
        } else {
          audioInputBuilder_.setMessage(value);
        }
      }
      inputCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AudioInput audio_input = 7;</code>
     */
    public Builder clearAudioInput() {
      if (audioInputBuilder_ == null) {
        if (inputCase_ == 7) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 7) {
          inputCase_ = 0;
          input_ = null;
        }
        audioInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AudioInput audio_input = 7;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.AudioInput.Builder getAudioInputBuilder() {
      return getAudioInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AudioInput audio_input = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.AudioInputOrBuilder getAudioInputOrBuilder() {
      if ((inputCase_ == 7) && (audioInputBuilder_ != null)) {
        return audioInputBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 7) {
          return (com.google.cloud.dialogflow.v2beta1.AudioInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.AudioInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The natural language speech audio to be processed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AudioInput audio_input = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.AudioInput,
            com.google.cloud.dialogflow.v2beta1.AudioInput.Builder,
            com.google.cloud.dialogflow.v2beta1.AudioInputOrBuilder>
        getAudioInputFieldBuilder() {
      if (audioInputBuilder_ == null) {
        if (!(inputCase_ == 7)) {
          input_ = com.google.cloud.dialogflow.v2beta1.AudioInput.getDefaultInstance();
        }
        audioInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.AudioInput,
                com.google.cloud.dialogflow.v2beta1.AudioInput.Builder,
                com.google.cloud.dialogflow.v2beta1.AudioInputOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.AudioInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 7;
      onChanged();
      return audioInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.EventInput,
            com.google.cloud.dialogflow.v2beta1.EventInput.Builder,
            com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder>
        eventInputBuilder_;
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event_input = 8;</code>
     *
     * @return Whether the eventInput field is set.
     */
    @java.lang.Override
    public boolean hasEventInput() {
      return inputCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event_input = 8;</code>
     *
     * @return The eventInput.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.EventInput getEventInput() {
      if (eventInputBuilder_ == null) {
        if (inputCase_ == 8) {
          return (com.google.cloud.dialogflow.v2beta1.EventInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance();
      } else {
        if (inputCase_ == 8) {
          return eventInputBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event_input = 8;</code>
     */
    public Builder setEventInput(com.google.cloud.dialogflow.v2beta1.EventInput value) {
      if (eventInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        eventInputBuilder_.setMessage(value);
      }
      inputCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event_input = 8;</code>
     */
    public Builder setEventInput(
        com.google.cloud.dialogflow.v2beta1.EventInput.Builder builderForValue) {
      if (eventInputBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        eventInputBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event_input = 8;</code>
     */
    public Builder mergeEventInput(com.google.cloud.dialogflow.v2beta1.EventInput value) {
      if (eventInputBuilder_ == null) {
        if (inputCase_ == 8
            && input_ != com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.v2beta1.EventInput.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.EventInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 8) {
          eventInputBuilder_.mergeFrom(value);
        } else {
          eventInputBuilder_.setMessage(value);
        }
      }
      inputCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event_input = 8;</code>
     */
    public Builder clearEventInput() {
      if (eventInputBuilder_ == null) {
        if (inputCase_ == 8) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 8) {
          inputCase_ = 0;
          input_ = null;
        }
        eventInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event_input = 8;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.EventInput.Builder getEventInputBuilder() {
      return getEventInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event_input = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder getEventInputOrBuilder() {
      if ((inputCase_ == 8) && (eventInputBuilder_ != null)) {
        return eventInputBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 8) {
          return (com.google.cloud.dialogflow.v2beta1.EventInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An input event to send to Dialogflow.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput event_input = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.EventInput,
            com.google.cloud.dialogflow.v2beta1.EventInput.Builder,
            com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder>
        getEventInputFieldBuilder() {
      if (eventInputBuilder_ == null) {
        if (!(inputCase_ == 8)) {
          input_ = com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance();
        }
        eventInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.EventInput,
                com.google.cloud.dialogflow.v2beta1.EventInput.Builder,
                com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.EventInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 8;
      onChanged();
      return eventInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SuggestionInput,
            com.google.cloud.dialogflow.v2beta1.SuggestionInput.Builder,
            com.google.cloud.dialogflow.v2beta1.SuggestionInputOrBuilder>
        suggestionInputBuilder_;
    /**
     *
     *
     * <pre>
     * An input representing the selection of a suggestion.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionInput suggestion_input = 12;</code>
     *
     * @return Whether the suggestionInput field is set.
     */
    @java.lang.Override
    public boolean hasSuggestionInput() {
      return inputCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * An input representing the selection of a suggestion.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionInput suggestion_input = 12;</code>
     *
     * @return The suggestionInput.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestionInput getSuggestionInput() {
      if (suggestionInputBuilder_ == null) {
        if (inputCase_ == 12) {
          return (com.google.cloud.dialogflow.v2beta1.SuggestionInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.SuggestionInput.getDefaultInstance();
      } else {
        if (inputCase_ == 12) {
          return suggestionInputBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.SuggestionInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An input representing the selection of a suggestion.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionInput suggestion_input = 12;</code>
     */
    public Builder setSuggestionInput(com.google.cloud.dialogflow.v2beta1.SuggestionInput value) {
      if (suggestionInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        suggestionInputBuilder_.setMessage(value);
      }
      inputCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An input representing the selection of a suggestion.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionInput suggestion_input = 12;</code>
     */
    public Builder setSuggestionInput(
        com.google.cloud.dialogflow.v2beta1.SuggestionInput.Builder builderForValue) {
      if (suggestionInputBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        suggestionInputBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An input representing the selection of a suggestion.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionInput suggestion_input = 12;</code>
     */
    public Builder mergeSuggestionInput(com.google.cloud.dialogflow.v2beta1.SuggestionInput value) {
      if (suggestionInputBuilder_ == null) {
        if (inputCase_ == 12
            && input_ != com.google.cloud.dialogflow.v2beta1.SuggestionInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.v2beta1.SuggestionInput.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.SuggestionInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 12) {
          suggestionInputBuilder_.mergeFrom(value);
        } else {
          suggestionInputBuilder_.setMessage(value);
        }
      }
      inputCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An input representing the selection of a suggestion.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionInput suggestion_input = 12;</code>
     */
    public Builder clearSuggestionInput() {
      if (suggestionInputBuilder_ == null) {
        if (inputCase_ == 12) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 12) {
          inputCase_ = 0;
          input_ = null;
        }
        suggestionInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An input representing the selection of a suggestion.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionInput suggestion_input = 12;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.SuggestionInput.Builder getSuggestionInputBuilder() {
      return getSuggestionInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An input representing the selection of a suggestion.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionInput suggestion_input = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SuggestionInputOrBuilder
        getSuggestionInputOrBuilder() {
      if ((inputCase_ == 12) && (suggestionInputBuilder_ != null)) {
        return suggestionInputBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 12) {
          return (com.google.cloud.dialogflow.v2beta1.SuggestionInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.SuggestionInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An input representing the selection of a suggestion.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SuggestionInput suggestion_input = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SuggestionInput,
            com.google.cloud.dialogflow.v2beta1.SuggestionInput.Builder,
            com.google.cloud.dialogflow.v2beta1.SuggestionInputOrBuilder>
        getSuggestionInputFieldBuilder() {
      if (suggestionInputBuilder_ == null) {
        if (!(inputCase_ == 12)) {
          input_ = com.google.cloud.dialogflow.v2beta1.SuggestionInput.getDefaultInstance();
        }
        suggestionInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.SuggestionInput,
                com.google.cloud.dialogflow.v2beta1.SuggestionInput.Builder,
                com.google.cloud.dialogflow.v2beta1.SuggestionInputOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.SuggestionInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 12;
      onChanged();
      return suggestionInputBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.IntentInput,
            com.google.cloud.dialogflow.v2beta1.IntentInput.Builder,
            com.google.cloud.dialogflow.v2beta1.IntentInputOrBuilder>
        intentInputBuilder_;
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 13;</code>
     *
     * @return Whether the intentInput field is set.
     */
    @java.lang.Override
    public boolean hasIntentInput() {
      return inputCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 13;</code>
     *
     * @return The intentInput.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.IntentInput getIntentInput() {
      if (intentInputBuilder_ == null) {
        if (inputCase_ == 13) {
          return (com.google.cloud.dialogflow.v2beta1.IntentInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.IntentInput.getDefaultInstance();
      } else {
        if (inputCase_ == 13) {
          return intentInputBuilder_.getMessage();
        }
        return com.google.cloud.dialogflow.v2beta1.IntentInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 13;</code>
     */
    public Builder setIntentInput(com.google.cloud.dialogflow.v2beta1.IntentInput value) {
      if (intentInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        intentInputBuilder_.setMessage(value);
      }
      inputCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 13;</code>
     */
    public Builder setIntentInput(
        com.google.cloud.dialogflow.v2beta1.IntentInput.Builder builderForValue) {
      if (intentInputBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        intentInputBuilder_.setMessage(builderForValue.build());
      }
      inputCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 13;</code>
     */
    public Builder mergeIntentInput(com.google.cloud.dialogflow.v2beta1.IntentInput value) {
      if (intentInputBuilder_ == null) {
        if (inputCase_ == 13
            && input_ != com.google.cloud.dialogflow.v2beta1.IntentInput.getDefaultInstance()) {
          input_ =
              com.google.cloud.dialogflow.v2beta1.IntentInput.newBuilder(
                      (com.google.cloud.dialogflow.v2beta1.IntentInput) input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        if (inputCase_ == 13) {
          intentInputBuilder_.mergeFrom(value);
        } else {
          intentInputBuilder_.setMessage(value);
        }
      }
      inputCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 13;</code>
     */
    public Builder clearIntentInput() {
      if (intentInputBuilder_ == null) {
        if (inputCase_ == 13) {
          inputCase_ = 0;
          input_ = null;
          onChanged();
        }
      } else {
        if (inputCase_ == 13) {
          inputCase_ = 0;
          input_ = null;
        }
        intentInputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 13;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.IntentInput.Builder getIntentInputBuilder() {
      return getIntentInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 13;</code>
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.IntentInputOrBuilder getIntentInputOrBuilder() {
      if ((inputCase_ == 13) && (intentInputBuilder_ != null)) {
        return intentInputBuilder_.getMessageOrBuilder();
      } else {
        if (inputCase_ == 13) {
          return (com.google.cloud.dialogflow.v2beta1.IntentInput) input_;
        }
        return com.google.cloud.dialogflow.v2beta1.IntentInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The intent to be triggered on V3 agent.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.IntentInput intent_input = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.IntentInput,
            com.google.cloud.dialogflow.v2beta1.IntentInput.Builder,
            com.google.cloud.dialogflow.v2beta1.IntentInputOrBuilder>
        getIntentInputFieldBuilder() {
      if (intentInputBuilder_ == null) {
        if (!(inputCase_ == 13)) {
          input_ = com.google.cloud.dialogflow.v2beta1.IntentInput.getDefaultInstance();
        }
        intentInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.IntentInput,
                com.google.cloud.dialogflow.v2beta1.IntentInput.Builder,
                com.google.cloud.dialogflow.v2beta1.IntentInputOrBuilder>(
                (com.google.cloud.dialogflow.v2beta1.IntentInput) input_,
                getParentForChildren(),
                isClean());
        input_ = null;
      }
      inputCase_ = 13;
      onChanged();
      return intentInputBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.OutputAudioConfig replyAudioConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>
        replyAudioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 5;</code>
     *
     * @return Whether the replyAudioConfig field is set.
     */
    public boolean hasReplyAudioConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 5;</code>
     *
     * @return The replyAudioConfig.
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig getReplyAudioConfig() {
      if (replyAudioConfigBuilder_ == null) {
        return replyAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
            : replyAudioConfig_;
      } else {
        return replyAudioConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 5;</code>
     */
    public Builder setReplyAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig value) {
      if (replyAudioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        replyAudioConfig_ = value;
      } else {
        replyAudioConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 5;</code>
     */
    public Builder setReplyAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder builderForValue) {
      if (replyAudioConfigBuilder_ == null) {
        replyAudioConfig_ = builderForValue.build();
      } else {
        replyAudioConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 5;</code>
     */
    public Builder mergeReplyAudioConfig(
        com.google.cloud.dialogflow.v2beta1.OutputAudioConfig value) {
      if (replyAudioConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && replyAudioConfig_ != null
            && replyAudioConfig_
                != com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()) {
          getReplyAudioConfigBuilder().mergeFrom(value);
        } else {
          replyAudioConfig_ = value;
        }
      } else {
        replyAudioConfigBuilder_.mergeFrom(value);
      }
      if (replyAudioConfig_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 5;</code>
     */
    public Builder clearReplyAudioConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      replyAudioConfig_ = null;
      if (replyAudioConfigBuilder_ != null) {
        replyAudioConfigBuilder_.dispose();
        replyAudioConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder
        getReplyAudioConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getReplyAudioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder
        getReplyAudioConfigOrBuilder() {
      if (replyAudioConfigBuilder_ != null) {
        return replyAudioConfigBuilder_.getMessageOrBuilder();
      } else {
        return replyAudioConfig_ == null
            ? com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.getDefaultInstance()
            : replyAudioConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Speech synthesis configuration.
     * The speech synthesis settings for a virtual agent that may be configured
     * for the associated conversation profile are not used when calling
     * AnalyzeContent. If this configuration is not supplied, speech synthesis
     * is disabled.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.OutputAudioConfig reply_audio_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
            com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>
        getReplyAudioConfigFieldBuilder() {
      if (replyAudioConfigBuilder_ == null) {
        replyAudioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfig,
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfig.Builder,
                com.google.cloud.dialogflow.v2beta1.OutputAudioConfigOrBuilder>(
                getReplyAudioConfig(), getParentForChildren(), isClean());
        replyAudioConfig_ = null;
      }
      return replyAudioConfigBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.QueryParameters queryParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryParameters,
            com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder>
        queryParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 9;</code>
     *
     * @return Whether the queryParams field is set.
     */
    public boolean hasQueryParams() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 9;</code>
     *
     * @return The queryParams.
     */
    public com.google.cloud.dialogflow.v2beta1.QueryParameters getQueryParams() {
      if (queryParamsBuilder_ == null) {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.v2beta1.QueryParameters.getDefaultInstance()
            : queryParams_;
      } else {
        return queryParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 9;</code>
     */
    public Builder setQueryParams(com.google.cloud.dialogflow.v2beta1.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryParams_ = value;
      } else {
        queryParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 9;</code>
     */
    public Builder setQueryParams(
        com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder builderForValue) {
      if (queryParamsBuilder_ == null) {
        queryParams_ = builderForValue.build();
      } else {
        queryParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 9;</code>
     */
    public Builder mergeQueryParams(com.google.cloud.dialogflow.v2beta1.QueryParameters value) {
      if (queryParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && queryParams_ != null
            && queryParams_
                != com.google.cloud.dialogflow.v2beta1.QueryParameters.getDefaultInstance()) {
          getQueryParamsBuilder().mergeFrom(value);
        } else {
          queryParams_ = value;
        }
      } else {
        queryParamsBuilder_.mergeFrom(value);
      }
      if (queryParams_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 9;</code>
     */
    public Builder clearQueryParams() {
      bitField0_ = (bitField0_ & ~0x00000080);
      queryParams_ = null;
      if (queryParamsBuilder_ != null) {
        queryParamsBuilder_.dispose();
        queryParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 9;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder getQueryParamsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getQueryParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 9;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder getQueryParamsOrBuilder() {
      if (queryParamsBuilder_ != null) {
        return queryParamsBuilder_.getMessageOrBuilder();
      } else {
        return queryParams_ == null
            ? com.google.cloud.dialogflow.v2beta1.QueryParameters.getDefaultInstance()
            : queryParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for a Dialogflow virtual-agent query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.QueryParameters query_params = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.QueryParameters,
            com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder,
            com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder>
        getQueryParamsFieldBuilder() {
      if (queryParamsBuilder_ == null) {
        queryParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.QueryParameters,
                com.google.cloud.dialogflow.v2beta1.QueryParameters.Builder,
                com.google.cloud.dialogflow.v2beta1.QueryParametersOrBuilder>(
                getQueryParams(), getParentForChildren(), isClean());
        queryParams_ = null;
      }
      return queryParamsBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.AssistQueryParameters assistQueryParams_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.AssistQueryParameters,
            com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.Builder,
            com.google.cloud.dialogflow.v2beta1.AssistQueryParametersOrBuilder>
        assistQueryParamsBuilder_;
    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 14;</code>
     *
     * @return Whether the assistQueryParams field is set.
     */
    public boolean hasAssistQueryParams() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 14;</code>
     *
     * @return The assistQueryParams.
     */
    public com.google.cloud.dialogflow.v2beta1.AssistQueryParameters getAssistQueryParams() {
      if (assistQueryParamsBuilder_ == null) {
        return assistQueryParams_ == null
            ? com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.getDefaultInstance()
            : assistQueryParams_;
      } else {
        return assistQueryParamsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 14;</code>
     */
    public Builder setAssistQueryParams(
        com.google.cloud.dialogflow.v2beta1.AssistQueryParameters value) {
      if (assistQueryParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        assistQueryParams_ = value;
      } else {
        assistQueryParamsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 14;</code>
     */
    public Builder setAssistQueryParams(
        com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.Builder builderForValue) {
      if (assistQueryParamsBuilder_ == null) {
        assistQueryParams_ = builderForValue.build();
      } else {
        assistQueryParamsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 14;</code>
     */
    public Builder mergeAssistQueryParams(
        com.google.cloud.dialogflow.v2beta1.AssistQueryParameters value) {
      if (assistQueryParamsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && assistQueryParams_ != null
            && assistQueryParams_
                != com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.getDefaultInstance()) {
          getAssistQueryParamsBuilder().mergeFrom(value);
        } else {
          assistQueryParams_ = value;
        }
      } else {
        assistQueryParamsBuilder_.mergeFrom(value);
      }
      if (assistQueryParams_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 14;</code>
     */
    public Builder clearAssistQueryParams() {
      bitField0_ = (bitField0_ & ~0x00000100);
      assistQueryParams_ = null;
      if (assistQueryParamsBuilder_ != null) {
        assistQueryParamsBuilder_.dispose();
        assistQueryParamsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 14;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.Builder
        getAssistQueryParamsBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getAssistQueryParamsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 14;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.AssistQueryParametersOrBuilder
        getAssistQueryParamsOrBuilder() {
      if (assistQueryParamsBuilder_ != null) {
        return assistQueryParamsBuilder_.getMessageOrBuilder();
      } else {
        return assistQueryParams_ == null
            ? com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.getDefaultInstance()
            : assistQueryParams_;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameters for a human assist query.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.AssistQueryParameters assist_query_params = 14;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.AssistQueryParameters,
            com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.Builder,
            com.google.cloud.dialogflow.v2beta1.AssistQueryParametersOrBuilder>
        getAssistQueryParamsFieldBuilder() {
      if (assistQueryParamsBuilder_ == null) {
        assistQueryParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.AssistQueryParameters,
                com.google.cloud.dialogflow.v2beta1.AssistQueryParameters.Builder,
                com.google.cloud.dialogflow.v2beta1.AssistQueryParametersOrBuilder>(
                getAssistQueryParams(), getParentForChildren(), isClean());
        assistQueryParams_ = null;
      }
      return assistQueryParamsBuilder_;
    }

    private com.google.protobuf.Struct cxParameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        cxParametersBuilder_;
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 18;</code>
     *
     * @return Whether the cxParameters field is set.
     */
    public boolean hasCxParameters() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 18;</code>
     *
     * @return The cxParameters.
     */
    public com.google.protobuf.Struct getCxParameters() {
      if (cxParametersBuilder_ == null) {
        return cxParameters_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : cxParameters_;
      } else {
        return cxParametersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 18;</code>
     */
    public Builder setCxParameters(com.google.protobuf.Struct value) {
      if (cxParametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cxParameters_ = value;
      } else {
        cxParametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 18;</code>
     */
    public Builder setCxParameters(com.google.protobuf.Struct.Builder builderForValue) {
      if (cxParametersBuilder_ == null) {
        cxParameters_ = builderForValue.build();
      } else {
        cxParametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 18;</code>
     */
    public Builder mergeCxParameters(com.google.protobuf.Struct value) {
      if (cxParametersBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && cxParameters_ != null
            && cxParameters_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getCxParametersBuilder().mergeFrom(value);
        } else {
          cxParameters_ = value;
        }
      } else {
        cxParametersBuilder_.mergeFrom(value);
      }
      if (cxParameters_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 18;</code>
     */
    public Builder clearCxParameters() {
      bitField0_ = (bitField0_ & ~0x00000200);
      cxParameters_ = null;
      if (cxParametersBuilder_ != null) {
        cxParametersBuilder_.dispose();
        cxParametersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 18;</code>
     */
    public com.google.protobuf.Struct.Builder getCxParametersBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getCxParametersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 18;</code>
     */
    public com.google.protobuf.StructOrBuilder getCxParametersOrBuilder() {
      if (cxParametersBuilder_ != null) {
        return cxParametersBuilder_.getMessageOrBuilder();
      } else {
        return cxParameters_ == null
            ? com.google.protobuf.Struct.getDefaultInstance()
            : cxParameters_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional parameters to be put into Dialogflow CX session parameters. To
     * remove a parameter from the session, clients should explicitly set the
     * parameter value to null.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>.google.protobuf.Struct cx_parameters = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getCxParametersFieldBuilder() {
      if (cxParametersBuilder_ == null) {
        cxParametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getCxParameters(), getParentForChildren(), isClean());
        cxParameters_ = null;
      }
      return cxParametersBuilder_;
    }

    private java.lang.Object cxCurrentPage_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the CX page to override the `current_page` in the
     * session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     *
     * If `cx_current_page` is specified, the previous state of the session will
     * be ignored by Dialogflow CX, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
     * `cx_parameters` should be configured together to direct a session to a
     * specific state.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>string cx_current_page = 20;</code>
     *
     * @return The cxCurrentPage.
     */
    public java.lang.String getCxCurrentPage() {
      java.lang.Object ref = cxCurrentPage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cxCurrentPage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the CX page to override the `current_page` in the
     * session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     *
     * If `cx_current_page` is specified, the previous state of the session will
     * be ignored by Dialogflow CX, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
     * `cx_parameters` should be configured together to direct a session to a
     * specific state.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>string cx_current_page = 20;</code>
     *
     * @return The bytes for cxCurrentPage.
     */
    public com.google.protobuf.ByteString getCxCurrentPageBytes() {
      java.lang.Object ref = cxCurrentPage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cxCurrentPage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the CX page to override the `current_page` in the
     * session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     *
     * If `cx_current_page` is specified, the previous state of the session will
     * be ignored by Dialogflow CX, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
     * `cx_parameters` should be configured together to direct a session to a
     * specific state.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>string cx_current_page = 20;</code>
     *
     * @param value The cxCurrentPage to set.
     * @return This builder for chaining.
     */
    public Builder setCxCurrentPage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cxCurrentPage_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the CX page to override the `current_page` in the
     * session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     *
     * If `cx_current_page` is specified, the previous state of the session will
     * be ignored by Dialogflow CX, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
     * `cx_parameters` should be configured together to direct a session to a
     * specific state.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>string cx_current_page = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCxCurrentPage() {
      cxCurrentPage_ = getDefaultInstance().getCxCurrentPage();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the CX page to override the `current_page` in the
     * session.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/agents/&lt;Agent
     * ID&gt;/flows/&lt;Flow ID&gt;/pages/&lt;Page ID&gt;`.
     *
     * If `cx_current_page` is specified, the previous state of the session will
     * be ignored by Dialogflow CX, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
     * `cx_parameters` should be configured together to direct a session to a
     * specific state.
     *
     * Note: this field should only be used if you are connecting to a Dialogflow
     * CX agent.
     * </pre>
     *
     * <code>string cx_current_page = 20;</code>
     *
     * @param value The bytes for cxCurrentPage to set.
     * @return This builder for chaining.
     */
    public Builder setCxCurrentPageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cxCurrentPage_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp messageSendTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        messageSendTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The send time of the message from end user or human agent's
     * perspective. It is used for identifying the same message under one
     * participant.
     *
     * Given two messages under the same participant:
     * * If send time are different regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * two distinct messages sent by the participant.
     * * If send time is the same regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * same message, and ignore the message received later.
     *
     * If the value is not provided, a new request will always be regarded as a
     * new message without any de-duplication.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp message_send_time = 10;</code>
     *
     * @return Whether the messageSendTime field is set.
     */
    public boolean hasMessageSendTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The send time of the message from end user or human agent's
     * perspective. It is used for identifying the same message under one
     * participant.
     *
     * Given two messages under the same participant:
     * * If send time are different regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * two distinct messages sent by the participant.
     * * If send time is the same regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * same message, and ignore the message received later.
     *
     * If the value is not provided, a new request will always be regarded as a
     * new message without any de-duplication.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp message_send_time = 10;</code>
     *
     * @return The messageSendTime.
     */
    public com.google.protobuf.Timestamp getMessageSendTime() {
      if (messageSendTimeBuilder_ == null) {
        return messageSendTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : messageSendTime_;
      } else {
        return messageSendTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The send time of the message from end user or human agent's
     * perspective. It is used for identifying the same message under one
     * participant.
     *
     * Given two messages under the same participant:
     * * If send time are different regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * two distinct messages sent by the participant.
     * * If send time is the same regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * same message, and ignore the message received later.
     *
     * If the value is not provided, a new request will always be regarded as a
     * new message without any de-duplication.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp message_send_time = 10;</code>
     */
    public Builder setMessageSendTime(com.google.protobuf.Timestamp value) {
      if (messageSendTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        messageSendTime_ = value;
      } else {
        messageSendTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The send time of the message from end user or human agent's
     * perspective. It is used for identifying the same message under one
     * participant.
     *
     * Given two messages under the same participant:
     * * If send time are different regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * two distinct messages sent by the participant.
     * * If send time is the same regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * same message, and ignore the message received later.
     *
     * If the value is not provided, a new request will always be regarded as a
     * new message without any de-duplication.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp message_send_time = 10;</code>
     */
    public Builder setMessageSendTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (messageSendTimeBuilder_ == null) {
        messageSendTime_ = builderForValue.build();
      } else {
        messageSendTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The send time of the message from end user or human agent's
     * perspective. It is used for identifying the same message under one
     * participant.
     *
     * Given two messages under the same participant:
     * * If send time are different regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * two distinct messages sent by the participant.
     * * If send time is the same regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * same message, and ignore the message received later.
     *
     * If the value is not provided, a new request will always be regarded as a
     * new message without any de-duplication.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp message_send_time = 10;</code>
     */
    public Builder mergeMessageSendTime(com.google.protobuf.Timestamp value) {
      if (messageSendTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && messageSendTime_ != null
            && messageSendTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getMessageSendTimeBuilder().mergeFrom(value);
        } else {
          messageSendTime_ = value;
        }
      } else {
        messageSendTimeBuilder_.mergeFrom(value);
      }
      if (messageSendTime_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The send time of the message from end user or human agent's
     * perspective. It is used for identifying the same message under one
     * participant.
     *
     * Given two messages under the same participant:
     * * If send time are different regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * two distinct messages sent by the participant.
     * * If send time is the same regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * same message, and ignore the message received later.
     *
     * If the value is not provided, a new request will always be regarded as a
     * new message without any de-duplication.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp message_send_time = 10;</code>
     */
    public Builder clearMessageSendTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      messageSendTime_ = null;
      if (messageSendTimeBuilder_ != null) {
        messageSendTimeBuilder_.dispose();
        messageSendTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The send time of the message from end user or human agent's
     * perspective. It is used for identifying the same message under one
     * participant.
     *
     * Given two messages under the same participant:
     * * If send time are different regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * two distinct messages sent by the participant.
     * * If send time is the same regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * same message, and ignore the message received later.
     *
     * If the value is not provided, a new request will always be regarded as a
     * new message without any de-duplication.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp message_send_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getMessageSendTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getMessageSendTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The send time of the message from end user or human agent's
     * perspective. It is used for identifying the same message under one
     * participant.
     *
     * Given two messages under the same participant:
     * * If send time are different regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * two distinct messages sent by the participant.
     * * If send time is the same regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * same message, and ignore the message received later.
     *
     * If the value is not provided, a new request will always be regarded as a
     * new message without any de-duplication.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp message_send_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getMessageSendTimeOrBuilder() {
      if (messageSendTimeBuilder_ != null) {
        return messageSendTimeBuilder_.getMessageOrBuilder();
      } else {
        return messageSendTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : messageSendTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The send time of the message from end user or human agent's
     * perspective. It is used for identifying the same message under one
     * participant.
     *
     * Given two messages under the same participant:
     * * If send time are different regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * two distinct messages sent by the participant.
     * * If send time is the same regardless of whether the content of the
     * messages are exactly the same, the conversation will regard them as
     * same message, and ignore the message received later.
     *
     * If the value is not provided, a new request will always be regarded as a
     * new message without any de-duplication.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp message_send_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getMessageSendTimeFieldBuilder() {
      if (messageSendTimeBuilder_ == null) {
        messageSendTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getMessageSendTime(), getParentForChildren(), isClean());
        messageSendTime_ = null;
      }
      return messageSendTimeBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * A unique identifier for this request. Restricted to 36 ASCII characters.
     * A random UUID is recommended.
     * This request is only idempotent if a `request_id` is provided.
     * </pre>
     *
     * <code>string request_id = 11;</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for this request. Restricted to 36 ASCII characters.
     * A random UUID is recommended.
     * This request is only idempotent if a `request_id` is provided.
     * </pre>
     *
     * <code>string request_id = 11;</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for this request. Restricted to 36 ASCII characters.
     * A random UUID is recommended.
     * This request is only idempotent if a `request_id` is provided.
     * </pre>
     *
     * <code>string request_id = 11;</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for this request. Restricted to 36 ASCII characters.
     * A random UUID is recommended.
     * This request is only idempotent if a `request_id` is provided.
     * </pre>
     *
     * <code>string request_id = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for this request. Restricted to 36 ASCII characters.
     * A random UUID is recommended.
     * This request is only idempotent if a `request_id` is provided.
     * </pre>
     *
     * <code>string request_id = 11;</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.AnalyzeContentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.AnalyzeContentRequest)
  private static final com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest();
  }

  public static com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnalyzeContentRequest> PARSER =
      new com.google.protobuf.AbstractParser<AnalyzeContentRequest>() {
        @java.lang.Override
        public AnalyzeContentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnalyzeContentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnalyzeContentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.AnalyzeContentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
