/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/human_agent_assistant_event.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Output only. Represents a notification sent to Pub/Sub subscribers for
 * agent assistant events in a specific conversation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent}
 */
public final class HumanAgentAssistantEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent)
    HumanAgentAssistantEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HumanAgentAssistantEvent.newBuilder() to construct.
  private HumanAgentAssistantEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HumanAgentAssistantEvent() {
    conversation_ = "";
    participant_ = "";
    suggestionResults_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HumanAgentAssistantEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEventProto
        .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEventProto
        .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent.class,
            com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent.Builder.class);
  }

  public static final int CONVERSATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object conversation_ = "";
  /**
   *
   *
   * <pre>
   * The conversation this notification refers to.
   * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
   * </pre>
   *
   * <code>string conversation = 1;</code>
   *
   * @return The conversation.
   */
  @java.lang.Override
  public java.lang.String getConversation() {
    java.lang.Object ref = conversation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      conversation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The conversation this notification refers to.
   * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
   * </pre>
   *
   * <code>string conversation = 1;</code>
   *
   * @return The bytes for conversation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConversationBytes() {
    java.lang.Object ref = conversation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      conversation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARTICIPANT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object participant_ = "";
  /**
   *
   *
   * <pre>
   * The participant that the suggestion is compiled for. And This field is used
   * to call
   * [Participants.ListSuggestions][google.cloud.dialogflow.v2beta1.Participants.ListSuggestions]
   * API. Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation
   * ID&gt;/participants/&lt;Participant ID&gt;`.
   * It will not be set in legacy workflow.
   * [HumanAgentAssistantConfig.name][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.name]
   * for more information.
   * </pre>
   *
   * <code>string participant = 3;</code>
   *
   * @return The participant.
   */
  @java.lang.Override
  public java.lang.String getParticipant() {
    java.lang.Object ref = participant_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      participant_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The participant that the suggestion is compiled for. And This field is used
   * to call
   * [Participants.ListSuggestions][google.cloud.dialogflow.v2beta1.Participants.ListSuggestions]
   * API. Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation
   * ID&gt;/participants/&lt;Participant ID&gt;`.
   * It will not be set in legacy workflow.
   * [HumanAgentAssistantConfig.name][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.name]
   * for more information.
   * </pre>
   *
   * <code>string participant = 3;</code>
   *
   * @return The bytes for participant.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParticipantBytes() {
    java.lang.Object ref = participant_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      participant_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUGGESTION_RESULTS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.SuggestionResult> suggestionResults_;
  /**
   *
   *
   * <pre>
   * The suggestion results payload that this notification refers to. It will
   * only be set when
   * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
   * sets to true.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.SuggestionResult>
      getSuggestionResultsList() {
    return suggestionResults_;
  }
  /**
   *
   *
   * <pre>
   * The suggestion results payload that this notification refers to. It will
   * only be set when
   * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
   * sets to true.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.SuggestionResultOrBuilder>
      getSuggestionResultsOrBuilderList() {
    return suggestionResults_;
  }
  /**
   *
   *
   * <pre>
   * The suggestion results payload that this notification refers to. It will
   * only be set when
   * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
   * sets to true.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;</code>
   */
  @java.lang.Override
  public int getSuggestionResultsCount() {
    return suggestionResults_.size();
  }
  /**
   *
   *
   * <pre>
   * The suggestion results payload that this notification refers to. It will
   * only be set when
   * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
   * sets to true.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SuggestionResult getSuggestionResults(int index) {
    return suggestionResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The suggestion results payload that this notification refers to. It will
   * only be set when
   * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
   * sets to true.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SuggestionResultOrBuilder
      getSuggestionResultsOrBuilder(int index) {
    return suggestionResults_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, conversation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(participant_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, participant_);
    }
    for (int i = 0; i < suggestionResults_.size(); i++) {
      output.writeMessage(5, suggestionResults_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, conversation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(participant_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, participant_);
    }
    for (int i = 0; i < suggestionResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, suggestionResults_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent other =
        (com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent) obj;

    if (!getConversation().equals(other.getConversation())) return false;
    if (!getParticipant().equals(other.getParticipant())) return false;
    if (!getSuggestionResultsList().equals(other.getSuggestionResultsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONVERSATION_FIELD_NUMBER;
    hash = (53 * hash) + getConversation().hashCode();
    hash = (37 * hash) + PARTICIPANT_FIELD_NUMBER;
    hash = (53 * hash) + getParticipant().hashCode();
    if (getSuggestionResultsCount() > 0) {
      hash = (37 * hash) + SUGGESTION_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getSuggestionResultsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Output only. Represents a notification sent to Pub/Sub subscribers for
   * agent assistant events in a specific conversation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent)
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEventProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEventProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent.class,
              com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      conversation_ = "";
      participant_ = "";
      if (suggestionResultsBuilder_ == null) {
        suggestionResults_ = java.util.Collections.emptyList();
      } else {
        suggestionResults_ = null;
        suggestionResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEventProto
          .internal_static_google_cloud_dialogflow_v2beta1_HumanAgentAssistantEvent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent
        getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent build() {
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent buildPartial() {
      com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent result =
          new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent result) {
      if (suggestionResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          suggestionResults_ = java.util.Collections.unmodifiableList(suggestionResults_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.suggestionResults_ = suggestionResults_;
      } else {
        result.suggestionResults_ = suggestionResultsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.conversation_ = conversation_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.participant_ = participant_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent other) {
      if (other
          == com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent.getDefaultInstance())
        return this;
      if (!other.getConversation().isEmpty()) {
        conversation_ = other.conversation_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getParticipant().isEmpty()) {
        participant_ = other.participant_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (suggestionResultsBuilder_ == null) {
        if (!other.suggestionResults_.isEmpty()) {
          if (suggestionResults_.isEmpty()) {
            suggestionResults_ = other.suggestionResults_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureSuggestionResultsIsMutable();
            suggestionResults_.addAll(other.suggestionResults_);
          }
          onChanged();
        }
      } else {
        if (!other.suggestionResults_.isEmpty()) {
          if (suggestionResultsBuilder_.isEmpty()) {
            suggestionResultsBuilder_.dispose();
            suggestionResultsBuilder_ = null;
            suggestionResults_ = other.suggestionResults_;
            bitField0_ = (bitField0_ & ~0x00000004);
            suggestionResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSuggestionResultsFieldBuilder()
                    : null;
          } else {
            suggestionResultsBuilder_.addAllMessages(other.suggestionResults_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                conversation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                participant_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 42:
              {
                com.google.cloud.dialogflow.v2beta1.SuggestionResult m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.SuggestionResult.parser(),
                        extensionRegistry);
                if (suggestionResultsBuilder_ == null) {
                  ensureSuggestionResultsIsMutable();
                  suggestionResults_.add(m);
                } else {
                  suggestionResultsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object conversation_ = "";
    /**
     *
     *
     * <pre>
     * The conversation this notification refers to.
     * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>string conversation = 1;</code>
     *
     * @return The conversation.
     */
    public java.lang.String getConversation() {
      java.lang.Object ref = conversation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation this notification refers to.
     * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>string conversation = 1;</code>
     *
     * @return The bytes for conversation.
     */
    public com.google.protobuf.ByteString getConversationBytes() {
      java.lang.Object ref = conversation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation this notification refers to.
     * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>string conversation = 1;</code>
     *
     * @param value The conversation to set.
     * @return This builder for chaining.
     */
    public Builder setConversation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      conversation_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation this notification refers to.
     * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>string conversation = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversation() {
      conversation_ = getDefaultInstance().getConversation();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation this notification refers to.
     * Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation ID&gt;`.
     * </pre>
     *
     * <code>string conversation = 1;</code>
     *
     * @param value The bytes for conversation to set.
     * @return This builder for chaining.
     */
    public Builder setConversationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      conversation_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object participant_ = "";
    /**
     *
     *
     * <pre>
     * The participant that the suggestion is compiled for. And This field is used
     * to call
     * [Participants.ListSuggestions][google.cloud.dialogflow.v2beta1.Participants.ListSuggestions]
     * API. Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation
     * ID&gt;/participants/&lt;Participant ID&gt;`.
     * It will not be set in legacy workflow.
     * [HumanAgentAssistantConfig.name][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.name]
     * for more information.
     * </pre>
     *
     * <code>string participant = 3;</code>
     *
     * @return The participant.
     */
    public java.lang.String getParticipant() {
      java.lang.Object ref = participant_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        participant_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The participant that the suggestion is compiled for. And This field is used
     * to call
     * [Participants.ListSuggestions][google.cloud.dialogflow.v2beta1.Participants.ListSuggestions]
     * API. Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation
     * ID&gt;/participants/&lt;Participant ID&gt;`.
     * It will not be set in legacy workflow.
     * [HumanAgentAssistantConfig.name][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.name]
     * for more information.
     * </pre>
     *
     * <code>string participant = 3;</code>
     *
     * @return The bytes for participant.
     */
    public com.google.protobuf.ByteString getParticipantBytes() {
      java.lang.Object ref = participant_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        participant_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The participant that the suggestion is compiled for. And This field is used
     * to call
     * [Participants.ListSuggestions][google.cloud.dialogflow.v2beta1.Participants.ListSuggestions]
     * API. Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation
     * ID&gt;/participants/&lt;Participant ID&gt;`.
     * It will not be set in legacy workflow.
     * [HumanAgentAssistantConfig.name][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.name]
     * for more information.
     * </pre>
     *
     * <code>string participant = 3;</code>
     *
     * @param value The participant to set.
     * @return This builder for chaining.
     */
    public Builder setParticipant(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      participant_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The participant that the suggestion is compiled for. And This field is used
     * to call
     * [Participants.ListSuggestions][google.cloud.dialogflow.v2beta1.Participants.ListSuggestions]
     * API. Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation
     * ID&gt;/participants/&lt;Participant ID&gt;`.
     * It will not be set in legacy workflow.
     * [HumanAgentAssistantConfig.name][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.name]
     * for more information.
     * </pre>
     *
     * <code>string participant = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParticipant() {
      participant_ = getDefaultInstance().getParticipant();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The participant that the suggestion is compiled for. And This field is used
     * to call
     * [Participants.ListSuggestions][google.cloud.dialogflow.v2beta1.Participants.ListSuggestions]
     * API. Format: `projects/&lt;Project ID&gt;/conversations/&lt;Conversation
     * ID&gt;/participants/&lt;Participant ID&gt;`.
     * It will not be set in legacy workflow.
     * [HumanAgentAssistantConfig.name][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.name]
     * for more information.
     * </pre>
     *
     * <code>string participant = 3;</code>
     *
     * @param value The bytes for participant to set.
     * @return This builder for chaining.
     */
    public Builder setParticipantBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      participant_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.SuggestionResult>
        suggestionResults_ = java.util.Collections.emptyList();

    private void ensureSuggestionResultsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        suggestionResults_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.SuggestionResult>(
                suggestionResults_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SuggestionResult,
            com.google.cloud.dialogflow.v2beta1.SuggestionResult.Builder,
            com.google.cloud.dialogflow.v2beta1.SuggestionResultOrBuilder>
        suggestionResultsBuilder_;

    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.SuggestionResult>
        getSuggestionResultsList() {
      if (suggestionResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(suggestionResults_);
      } else {
        return suggestionResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public int getSuggestionResultsCount() {
      if (suggestionResultsBuilder_ == null) {
        return suggestionResults_.size();
      } else {
        return suggestionResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SuggestionResult getSuggestionResults(int index) {
      if (suggestionResultsBuilder_ == null) {
        return suggestionResults_.get(index);
      } else {
        return suggestionResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public Builder setSuggestionResults(
        int index, com.google.cloud.dialogflow.v2beta1.SuggestionResult value) {
      if (suggestionResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSuggestionResultsIsMutable();
        suggestionResults_.set(index, value);
        onChanged();
      } else {
        suggestionResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public Builder setSuggestionResults(
        int index, com.google.cloud.dialogflow.v2beta1.SuggestionResult.Builder builderForValue) {
      if (suggestionResultsBuilder_ == null) {
        ensureSuggestionResultsIsMutable();
        suggestionResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        suggestionResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public Builder addSuggestionResults(
        com.google.cloud.dialogflow.v2beta1.SuggestionResult value) {
      if (suggestionResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSuggestionResultsIsMutable();
        suggestionResults_.add(value);
        onChanged();
      } else {
        suggestionResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public Builder addSuggestionResults(
        int index, com.google.cloud.dialogflow.v2beta1.SuggestionResult value) {
      if (suggestionResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSuggestionResultsIsMutable();
        suggestionResults_.add(index, value);
        onChanged();
      } else {
        suggestionResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public Builder addSuggestionResults(
        com.google.cloud.dialogflow.v2beta1.SuggestionResult.Builder builderForValue) {
      if (suggestionResultsBuilder_ == null) {
        ensureSuggestionResultsIsMutable();
        suggestionResults_.add(builderForValue.build());
        onChanged();
      } else {
        suggestionResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public Builder addSuggestionResults(
        int index, com.google.cloud.dialogflow.v2beta1.SuggestionResult.Builder builderForValue) {
      if (suggestionResultsBuilder_ == null) {
        ensureSuggestionResultsIsMutable();
        suggestionResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        suggestionResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public Builder addAllSuggestionResults(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.SuggestionResult> values) {
      if (suggestionResultsBuilder_ == null) {
        ensureSuggestionResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, suggestionResults_);
        onChanged();
      } else {
        suggestionResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public Builder clearSuggestionResults() {
      if (suggestionResultsBuilder_ == null) {
        suggestionResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        suggestionResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public Builder removeSuggestionResults(int index) {
      if (suggestionResultsBuilder_ == null) {
        ensureSuggestionResultsIsMutable();
        suggestionResults_.remove(index);
        onChanged();
      } else {
        suggestionResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SuggestionResult.Builder getSuggestionResultsBuilder(
        int index) {
      return getSuggestionResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SuggestionResultOrBuilder
        getSuggestionResultsOrBuilder(int index) {
      if (suggestionResultsBuilder_ == null) {
        return suggestionResults_.get(index);
      } else {
        return suggestionResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.SuggestionResultOrBuilder>
        getSuggestionResultsOrBuilderList() {
      if (suggestionResultsBuilder_ != null) {
        return suggestionResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(suggestionResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SuggestionResult.Builder
        addSuggestionResultsBuilder() {
      return getSuggestionResultsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2beta1.SuggestionResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SuggestionResult.Builder addSuggestionResultsBuilder(
        int index) {
      return getSuggestionResultsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.v2beta1.SuggestionResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The suggestion results payload that this notification refers to. It will
     * only be set when
     * [HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.group_suggestion_responses]
     * sets to true.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SuggestionResult suggestion_results = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.SuggestionResult.Builder>
        getSuggestionResultsBuilderList() {
      return getSuggestionResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SuggestionResult,
            com.google.cloud.dialogflow.v2beta1.SuggestionResult.Builder,
            com.google.cloud.dialogflow.v2beta1.SuggestionResultOrBuilder>
        getSuggestionResultsFieldBuilder() {
      if (suggestionResultsBuilder_ == null) {
        suggestionResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.SuggestionResult,
                com.google.cloud.dialogflow.v2beta1.SuggestionResult.Builder,
                com.google.cloud.dialogflow.v2beta1.SuggestionResultOrBuilder>(
                suggestionResults_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        suggestionResults_ = null;
      }
      return suggestionResultsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent)
  private static final com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent();
  }

  public static com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HumanAgentAssistantEvent> PARSER =
      new com.google.protobuf.AbstractParser<HumanAgentAssistantEvent>() {
        @java.lang.Override
        public HumanAgentAssistantEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HumanAgentAssistantEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HumanAgentAssistantEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
