/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/audio_config.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

public interface SpeechToTextConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.SpeechToTextConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The speech model used in speech to text.
   * `SPEECH_MODEL_VARIANT_UNSPECIFIED`, `USE_BEST_AVAILABLE` will be treated as
   * `USE_ENHANCED`. It can be overridden in
   * [AnalyzeContentRequest][google.cloud.dialogflow.v2beta1.AnalyzeContentRequest]
   * and
   * [StreamingAnalyzeContentRequest][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest]
   * request. If enhanced model variant is specified and an enhanced version of
   * the specified model for the language does not exist, then it would emit an
   * error.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SpeechModelVariant speech_model_variant = 1;</code>
   *
   * @return The enum numeric value on the wire for speechModelVariant.
   */
  int getSpeechModelVariantValue();
  /**
   *
   *
   * <pre>
   * The speech model used in speech to text.
   * `SPEECH_MODEL_VARIANT_UNSPECIFIED`, `USE_BEST_AVAILABLE` will be treated as
   * `USE_ENHANCED`. It can be overridden in
   * [AnalyzeContentRequest][google.cloud.dialogflow.v2beta1.AnalyzeContentRequest]
   * and
   * [StreamingAnalyzeContentRequest][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest]
   * request. If enhanced model variant is specified and an enhanced version of
   * the specified model for the language does not exist, then it would emit an
   * error.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SpeechModelVariant speech_model_variant = 1;</code>
   *
   * @return The speechModelVariant.
   */
  com.google.cloud.dialogflow.v2beta1.SpeechModelVariant getSpeechModelVariant();

  /**
   *
   *
   * <pre>
   * Which Speech model to select. Select the
   * model best suited to your domain to get best results. If a model is not
   * explicitly specified, then Dialogflow auto-selects a model based on other
   * parameters in the SpeechToTextConfig and Agent settings.
   * If enhanced speech model is enabled for the agent and an enhanced
   * version of the specified model for the language does not exist, then the
   * speech is recognized using the standard version of the specified model.
   * Refer to
   * [Cloud Speech API
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
   * for more details.
   * If you specify a model, the following models typically have the best
   * performance:
   *
   * - phone_call (best for Agent Assist and telephony)
   * - latest_short (best for Dialogflow non-telephony)
   * - command_and_search
   *
   * Leave this field unspecified to use
   * [Agent Speech
   * settings](https://cloud.google.com/dialogflow/cx/docs/concept/agent#settings-speech)
   * for model selection.
   * </pre>
   *
   * <code>string model = 2;</code>
   *
   * @return The model.
   */
  java.lang.String getModel();
  /**
   *
   *
   * <pre>
   * Which Speech model to select. Select the
   * model best suited to your domain to get best results. If a model is not
   * explicitly specified, then Dialogflow auto-selects a model based on other
   * parameters in the SpeechToTextConfig and Agent settings.
   * If enhanced speech model is enabled for the agent and an enhanced
   * version of the specified model for the language does not exist, then the
   * speech is recognized using the standard version of the specified model.
   * Refer to
   * [Cloud Speech API
   * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
   * for more details.
   * If you specify a model, the following models typically have the best
   * performance:
   *
   * - phone_call (best for Agent Assist and telephony)
   * - latest_short (best for Dialogflow non-telephony)
   * - command_and_search
   *
   * Leave this field unspecified to use
   * [Agent Speech
   * settings](https://cloud.google.com/dialogflow/cx/docs/concept/agent#settings-speech)
   * for model selection.
   * </pre>
   *
   * <code>string model = 2;</code>
   *
   * @return The bytes for model.
   */
  com.google.protobuf.ByteString getModelBytes();

  /**
   *
   *
   * <pre>
   * List of names of Cloud Speech phrase sets that are used for transcription.
   * </pre>
   *
   * <code>repeated string phrase_sets = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the phraseSets.
   */
  java.util.List<java.lang.String> getPhraseSetsList();
  /**
   *
   *
   * <pre>
   * List of names of Cloud Speech phrase sets that are used for transcription.
   * </pre>
   *
   * <code>repeated string phrase_sets = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of phraseSets.
   */
  int getPhraseSetsCount();
  /**
   *
   *
   * <pre>
   * List of names of Cloud Speech phrase sets that are used for transcription.
   * </pre>
   *
   * <code>repeated string phrase_sets = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The phraseSets at the given index.
   */
  java.lang.String getPhraseSets(int index);
  /**
   *
   *
   * <pre>
   * List of names of Cloud Speech phrase sets that are used for transcription.
   * </pre>
   *
   * <code>repeated string phrase_sets = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the phraseSets at the given index.
   */
  com.google.protobuf.ByteString getPhraseSetsBytes(int index);

  /**
   *
   *
   * <pre>
   * Audio encoding of the audio content to process.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AudioEncoding audio_encoding = 6;</code>
   *
   * @return The enum numeric value on the wire for audioEncoding.
   */
  int getAudioEncodingValue();
  /**
   *
   *
   * <pre>
   * Audio encoding of the audio content to process.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.AudioEncoding audio_encoding = 6;</code>
   *
   * @return The audioEncoding.
   */
  com.google.cloud.dialogflow.v2beta1.AudioEncoding getAudioEncoding();

  /**
   *
   *
   * <pre>
   * Sample rate (in Hertz) of the audio content sent in the query.
   * Refer to
   * [Cloud Speech API
   * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
   * more details.
   * </pre>
   *
   * <code>int32 sample_rate_hertz = 7;</code>
   *
   * @return The sampleRateHertz.
   */
  int getSampleRateHertz();

  /**
   *
   *
   * <pre>
   * The language of the supplied audio. Dialogflow does not do  translations.
   * See [Language
   * Support](https://cloud.google.com/dialogflow/docs/reference/language)
   * for a list of the currently supported language codes. Note that queries in
   * the same session do not necessarily need to specify the same language.
   * </pre>
   *
   * <code>string language_code = 8;</code>
   *
   * @return The languageCode.
   */
  java.lang.String getLanguageCode();
  /**
   *
   *
   * <pre>
   * The language of the supplied audio. Dialogflow does not do  translations.
   * See [Language
   * Support](https://cloud.google.com/dialogflow/docs/reference/language)
   * for a list of the currently supported language codes. Note that queries in
   * the same session do not necessarily need to specify the same language.
   * </pre>
   *
   * <code>string language_code = 8;</code>
   *
   * @return The bytes for languageCode.
   */
  com.google.protobuf.ByteString getLanguageCodeBytes();

  /**
   *
   *
   * <pre>
   * If `true`, Dialogflow returns
   * [SpeechWordInfo][google.cloud.dialogflow.v2beta1.SpeechWordInfo] in
   * [StreamingRecognitionResult][google.cloud.dialogflow.v2beta1.StreamingRecognitionResult]
   * with information about the recognized speech words, e.g. start and end time
   * offsets. If false or unspecified, Speech doesn't return any word-level
   * information.
   * </pre>
   *
   * <code>bool enable_word_info = 9;</code>
   *
   * @return The enableWordInfo.
   */
  boolean getEnableWordInfo();

  /**
   *
   *
   * <pre>
   * Use timeout based endpointing, interpreting endpointer sensitivy as
   * seconds of timeout value.
   * </pre>
   *
   * <code>bool use_timeout_based_endpointing = 11;</code>
   *
   * @return The useTimeoutBasedEndpointing.
   */
  boolean getUseTimeoutBasedEndpointing();
}
