/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/webhook.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * The response message for a webhook call.
 *
 * This response is validated by the Dialogflow server. If validation fails,
 * an error will be returned in the
 * [QueryResult.diagnostic_info][google.cloud.dialogflow.v2beta1.QueryResult.diagnostic_info]
 * field. Setting JSON fields to an empty value with the wrong type is a common
 * error. To avoid this error:
 *
 * - Use `""` for empty strings
 * - Use `{}` or `null` for empty objects
 * - Use `[]` or `null` for empty arrays
 *
 * For more information, see the
 * [Protocol Buffers Language
 * Guide](https://developers.google.com/protocol-buffers/docs/proto3#json).
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.WebhookResponse}
 */
public final class WebhookResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.WebhookResponse)
    WebhookResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WebhookResponse.newBuilder() to construct.
  private WebhookResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WebhookResponse() {
    fulfillmentText_ = "";
    fulfillmentMessages_ = java.util.Collections.emptyList();
    source_ = "";
    outputContexts_ = java.util.Collections.emptyList();
    sessionEntityTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WebhookResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.WebhookProto
        .internal_static_google_cloud_dialogflow_v2beta1_WebhookResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.WebhookProto
        .internal_static_google_cloud_dialogflow_v2beta1_WebhookResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.WebhookResponse.class,
            com.google.cloud.dialogflow.v2beta1.WebhookResponse.Builder.class);
  }

  private int bitField0_;
  public static final int FULFILLMENT_TEXT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fulfillmentText_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The text response message intended for the end-user.
   * It is recommended to use `fulfillment_messages.text.text[0]` instead.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.fulfillment_text][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_text]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>string fulfillment_text = 1;</code>
   *
   * @return The fulfillmentText.
   */
  @java.lang.Override
  public java.lang.String getFulfillmentText() {
    java.lang.Object ref = fulfillmentText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fulfillmentText_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The text response message intended for the end-user.
   * It is recommended to use `fulfillment_messages.text.text[0]` instead.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.fulfillment_text][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_text]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>string fulfillment_text = 1;</code>
   *
   * @return The bytes for fulfillmentText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFulfillmentTextBytes() {
    java.lang.Object ref = fulfillmentText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fulfillmentText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FULFILLMENT_MESSAGES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.Intent.Message> fulfillmentMessages_;
  /**
   *
   *
   * <pre>
   * Optional. The rich response messages intended for the end-user.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.Intent.Message>
      getFulfillmentMessagesList() {
    return fulfillmentMessages_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The rich response messages intended for the end-user.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder>
      getFulfillmentMessagesOrBuilderList() {
    return fulfillmentMessages_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The rich response messages intended for the end-user.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;</code>
   */
  @java.lang.Override
  public int getFulfillmentMessagesCount() {
    return fulfillmentMessages_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The rich response messages intended for the end-user.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Intent.Message getFulfillmentMessages(int index) {
    return fulfillmentMessages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The rich response messages intended for the end-user.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder
      getFulfillmentMessagesOrBuilder(int index) {
    return fulfillmentMessages_.get(index);
  }

  public static final int SOURCE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object source_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A custom field used to identify the webhook source.
   * Arbitrary strings are supported.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.webhook_source][google.cloud.dialogflow.v2beta1.QueryResult.webhook_source]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>string source = 3;</code>
   *
   * @return The source.
   */
  @java.lang.Override
  public java.lang.String getSource() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      source_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A custom field used to identify the webhook source.
   * Arbitrary strings are supported.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.webhook_source][google.cloud.dialogflow.v2beta1.QueryResult.webhook_source]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>string source = 3;</code>
   *
   * @return The bytes for source.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceBytes() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      source_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAYLOAD_FIELD_NUMBER = 4;
  private com.google.protobuf.Struct payload_;
  /**
   *
   *
   * <pre>
   * Optional. This field can be used to pass custom data from your webhook to
   * the integration or API caller. Arbitrary JSON objects are supported. When
   * provided, Dialogflow uses this field to populate
   * [QueryResult.webhook_payload][google.cloud.dialogflow.v2beta1.QueryResult.webhook_payload]
   * sent to the integration or API caller. This field is also used by the
   * [Google Assistant
   * integration](https://cloud.google.com/dialogflow/docs/integrations/aog)
   * for rich response messages.
   * See the format definition at [Google Assistant Dialogflow webhook
   * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 4;</code>
   *
   * @return Whether the payload field is set.
   */
  @java.lang.Override
  public boolean hasPayload() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. This field can be used to pass custom data from your webhook to
   * the integration or API caller. Arbitrary JSON objects are supported. When
   * provided, Dialogflow uses this field to populate
   * [QueryResult.webhook_payload][google.cloud.dialogflow.v2beta1.QueryResult.webhook_payload]
   * sent to the integration or API caller. This field is also used by the
   * [Google Assistant
   * integration](https://cloud.google.com/dialogflow/docs/integrations/aog)
   * for rich response messages.
   * See the format definition at [Google Assistant Dialogflow webhook
   * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 4;</code>
   *
   * @return The payload.
   */
  @java.lang.Override
  public com.google.protobuf.Struct getPayload() {
    return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
  }
  /**
   *
   *
   * <pre>
   * Optional. This field can be used to pass custom data from your webhook to
   * the integration or API caller. Arbitrary JSON objects are supported. When
   * provided, Dialogflow uses this field to populate
   * [QueryResult.webhook_payload][google.cloud.dialogflow.v2beta1.QueryResult.webhook_payload]
   * sent to the integration or API caller. This field is also used by the
   * [Google Assistant
   * integration](https://cloud.google.com/dialogflow/docs/integrations/aog)
   * for rich response messages.
   * See the format definition at [Google Assistant Dialogflow webhook
   * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
   * </pre>
   *
   * <code>.google.protobuf.Struct payload = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getPayloadOrBuilder() {
    return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
  }

  public static final int OUTPUT_CONTEXTS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.Context> outputContexts_;
  /**
   *
   *
   * <pre>
   * Optional. The collection of output contexts that will overwrite currently
   * active contexts for the session and reset their lifespans.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.Context> getOutputContextsList() {
    return outputContexts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The collection of output contexts that will overwrite currently
   * active contexts for the session and reset their lifespans.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.ContextOrBuilder>
      getOutputContextsOrBuilderList() {
    return outputContexts_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The collection of output contexts that will overwrite currently
   * active contexts for the session and reset their lifespans.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
   */
  @java.lang.Override
  public int getOutputContextsCount() {
    return outputContexts_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The collection of output contexts that will overwrite currently
   * active contexts for the session and reset their lifespans.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Context getOutputContexts(int index) {
    return outputContexts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The collection of output contexts that will overwrite currently
   * active contexts for the session and reset their lifespans.
   * When provided, Dialogflow uses this field to populate
   * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
   * sent to the integration or API caller.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.ContextOrBuilder getOutputContextsOrBuilder(
      int index) {
    return outputContexts_.get(index);
  }

  public static final int FOLLOWUP_EVENT_INPUT_FIELD_NUMBER = 6;
  private com.google.cloud.dialogflow.v2beta1.EventInput followupEventInput_;
  /**
   *
   *
   * <pre>
   * Optional. Invokes the supplied events.
   * When this field is set, Dialogflow ignores the `fulfillment_text`,
   * `fulfillment_messages`, and `payload` fields.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.EventInput followup_event_input = 6;</code>
   *
   * @return Whether the followupEventInput field is set.
   */
  @java.lang.Override
  public boolean hasFollowupEventInput() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Invokes the supplied events.
   * When this field is set, Dialogflow ignores the `fulfillment_text`,
   * `fulfillment_messages`, and `payload` fields.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.EventInput followup_event_input = 6;</code>
   *
   * @return The followupEventInput.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.EventInput getFollowupEventInput() {
    return followupEventInput_ == null
        ? com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance()
        : followupEventInput_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Invokes the supplied events.
   * When this field is set, Dialogflow ignores the `fulfillment_text`,
   * `fulfillment_messages`, and `payload` fields.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.EventInput followup_event_input = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder getFollowupEventInputOrBuilder() {
    return followupEventInput_ == null
        ? com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance()
        : followupEventInput_;
  }

  public static final int LIVE_AGENT_HANDOFF_FIELD_NUMBER = 7;
  private boolean liveAgentHandoff_ = false;
  /**
   *
   *
   * <pre>
   * Indicates that a live agent should be brought in to handle the
   * interaction with the user. In most cases, when you set this flag to true,
   * you would also want to set end_interaction to true as well. Default is
   * false.
   * </pre>
   *
   * <code>bool live_agent_handoff = 7;</code>
   *
   * @return The liveAgentHandoff.
   */
  @java.lang.Override
  public boolean getLiveAgentHandoff() {
    return liveAgentHandoff_;
  }

  public static final int END_INTERACTION_FIELD_NUMBER = 8;
  private boolean endInteraction_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Indicates that this intent ends an interaction. Some integrations
   * (e.g., Actions on Google or Dialogflow phone gateway) use this information
   * to close interaction with an end user. Default is false.
   * </pre>
   *
   * <code>bool end_interaction = 8;</code>
   *
   * @return The endInteraction.
   */
  @java.lang.Override
  public boolean getEndInteraction() {
    return endInteraction_;
  }

  public static final int SESSION_ENTITY_TYPES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.SessionEntityType> sessionEntityTypes_;
  /**
   *
   *
   * <pre>
   * Optional. Additional session entity types to replace or extend developer
   * entity types with. The entity synonyms apply to all languages and persist
   * for the session. Setting this data from a webhook overwrites
   * the session entity types that have been set using `detectIntent`,
   * `streamingDetectIntent` or
   * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
   * management methods.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.SessionEntityType>
      getSessionEntityTypesList() {
    return sessionEntityTypes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional session entity types to replace or extend developer
   * entity types with. The entity synonyms apply to all languages and persist
   * for the session. Setting this data from a webhook overwrites
   * the session entity types that have been set using `detectIntent`,
   * `streamingDetectIntent` or
   * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
   * management methods.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.SessionEntityTypeOrBuilder>
      getSessionEntityTypesOrBuilderList() {
    return sessionEntityTypes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional session entity types to replace or extend developer
   * entity types with. The entity synonyms apply to all languages and persist
   * for the session. Setting this data from a webhook overwrites
   * the session entity types that have been set using `detectIntent`,
   * `streamingDetectIntent` or
   * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
   * management methods.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
   * </code>
   */
  @java.lang.Override
  public int getSessionEntityTypesCount() {
    return sessionEntityTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional session entity types to replace or extend developer
   * entity types with. The entity synonyms apply to all languages and persist
   * for the session. Setting this data from a webhook overwrites
   * the session entity types that have been set using `detectIntent`,
   * `streamingDetectIntent` or
   * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
   * management methods.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SessionEntityType getSessionEntityTypes(int index) {
    return sessionEntityTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Additional session entity types to replace or extend developer
   * entity types with. The entity synonyms apply to all languages and persist
   * for the session. Setting this data from a webhook overwrites
   * the session entity types that have been set using `detectIntent`,
   * `streamingDetectIntent` or
   * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
   * management methods.
   * </pre>
   *
   * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SessionEntityTypeOrBuilder
      getSessionEntityTypesOrBuilder(int index) {
    return sessionEntityTypes_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fulfillmentText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, fulfillmentText_);
    }
    for (int i = 0; i < fulfillmentMessages_.size(); i++) {
      output.writeMessage(2, fulfillmentMessages_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getPayload());
    }
    for (int i = 0; i < outputContexts_.size(); i++) {
      output.writeMessage(5, outputContexts_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getFollowupEventInput());
    }
    if (liveAgentHandoff_ != false) {
      output.writeBool(7, liveAgentHandoff_);
    }
    if (endInteraction_ != false) {
      output.writeBool(8, endInteraction_);
    }
    for (int i = 0; i < sessionEntityTypes_.size(); i++) {
      output.writeMessage(10, sessionEntityTypes_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fulfillmentText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, fulfillmentText_);
    }
    for (int i = 0; i < fulfillmentMessages_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, fulfillmentMessages_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, source_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPayload());
    }
    for (int i = 0; i < outputContexts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, outputContexts_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getFollowupEventInput());
    }
    if (liveAgentHandoff_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, liveAgentHandoff_);
    }
    if (endInteraction_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, endInteraction_);
    }
    for (int i = 0; i < sessionEntityTypes_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(10, sessionEntityTypes_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.WebhookResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.WebhookResponse other =
        (com.google.cloud.dialogflow.v2beta1.WebhookResponse) obj;

    if (!getFulfillmentText().equals(other.getFulfillmentText())) return false;
    if (!getFulfillmentMessagesList().equals(other.getFulfillmentMessagesList())) return false;
    if (!getSource().equals(other.getSource())) return false;
    if (hasPayload() != other.hasPayload()) return false;
    if (hasPayload()) {
      if (!getPayload().equals(other.getPayload())) return false;
    }
    if (!getOutputContextsList().equals(other.getOutputContextsList())) return false;
    if (hasFollowupEventInput() != other.hasFollowupEventInput()) return false;
    if (hasFollowupEventInput()) {
      if (!getFollowupEventInput().equals(other.getFollowupEventInput())) return false;
    }
    if (getLiveAgentHandoff() != other.getLiveAgentHandoff()) return false;
    if (getEndInteraction() != other.getEndInteraction()) return false;
    if (!getSessionEntityTypesList().equals(other.getSessionEntityTypesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FULFILLMENT_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getFulfillmentText().hashCode();
    if (getFulfillmentMessagesCount() > 0) {
      hash = (37 * hash) + FULFILLMENT_MESSAGES_FIELD_NUMBER;
      hash = (53 * hash) + getFulfillmentMessagesList().hashCode();
    }
    hash = (37 * hash) + SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getSource().hashCode();
    if (hasPayload()) {
      hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
      hash = (53 * hash) + getPayload().hashCode();
    }
    if (getOutputContextsCount() > 0) {
      hash = (37 * hash) + OUTPUT_CONTEXTS_FIELD_NUMBER;
      hash = (53 * hash) + getOutputContextsList().hashCode();
    }
    if (hasFollowupEventInput()) {
      hash = (37 * hash) + FOLLOWUP_EVENT_INPUT_FIELD_NUMBER;
      hash = (53 * hash) + getFollowupEventInput().hashCode();
    }
    hash = (37 * hash) + LIVE_AGENT_HANDOFF_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getLiveAgentHandoff());
    hash = (37 * hash) + END_INTERACTION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEndInteraction());
    if (getSessionEntityTypesCount() > 0) {
      hash = (37 * hash) + SESSION_ENTITY_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getSessionEntityTypesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.WebhookResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.WebhookResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.WebhookResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.WebhookResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.WebhookResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.WebhookResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.WebhookResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.WebhookResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.WebhookResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.WebhookResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.WebhookResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.WebhookResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.WebhookResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response message for a webhook call.
   *
   * This response is validated by the Dialogflow server. If validation fails,
   * an error will be returned in the
   * [QueryResult.diagnostic_info][google.cloud.dialogflow.v2beta1.QueryResult.diagnostic_info]
   * field. Setting JSON fields to an empty value with the wrong type is a common
   * error. To avoid this error:
   *
   * - Use `""` for empty strings
   * - Use `{}` or `null` for empty objects
   * - Use `[]` or `null` for empty arrays
   *
   * For more information, see the
   * [Protocol Buffers Language
   * Guide](https://developers.google.com/protocol-buffers/docs/proto3#json).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.WebhookResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.WebhookResponse)
      com.google.cloud.dialogflow.v2beta1.WebhookResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.WebhookProto
          .internal_static_google_cloud_dialogflow_v2beta1_WebhookResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.WebhookProto
          .internal_static_google_cloud_dialogflow_v2beta1_WebhookResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.WebhookResponse.class,
              com.google.cloud.dialogflow.v2beta1.WebhookResponse.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.WebhookResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFulfillmentMessagesFieldBuilder();
        getPayloadFieldBuilder();
        getOutputContextsFieldBuilder();
        getFollowupEventInputFieldBuilder();
        getSessionEntityTypesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      fulfillmentText_ = "";
      if (fulfillmentMessagesBuilder_ == null) {
        fulfillmentMessages_ = java.util.Collections.emptyList();
      } else {
        fulfillmentMessages_ = null;
        fulfillmentMessagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      source_ = "";
      payload_ = null;
      if (payloadBuilder_ != null) {
        payloadBuilder_.dispose();
        payloadBuilder_ = null;
      }
      if (outputContextsBuilder_ == null) {
        outputContexts_ = java.util.Collections.emptyList();
      } else {
        outputContexts_ = null;
        outputContextsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      followupEventInput_ = null;
      if (followupEventInputBuilder_ != null) {
        followupEventInputBuilder_.dispose();
        followupEventInputBuilder_ = null;
      }
      liveAgentHandoff_ = false;
      endInteraction_ = false;
      if (sessionEntityTypesBuilder_ == null) {
        sessionEntityTypes_ = java.util.Collections.emptyList();
      } else {
        sessionEntityTypes_ = null;
        sessionEntityTypesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.WebhookProto
          .internal_static_google_cloud_dialogflow_v2beta1_WebhookResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.WebhookResponse getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.WebhookResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.WebhookResponse build() {
      com.google.cloud.dialogflow.v2beta1.WebhookResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.WebhookResponse buildPartial() {
      com.google.cloud.dialogflow.v2beta1.WebhookResponse result =
          new com.google.cloud.dialogflow.v2beta1.WebhookResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2beta1.WebhookResponse result) {
      if (fulfillmentMessagesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          fulfillmentMessages_ = java.util.Collections.unmodifiableList(fulfillmentMessages_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.fulfillmentMessages_ = fulfillmentMessages_;
      } else {
        result.fulfillmentMessages_ = fulfillmentMessagesBuilder_.build();
      }
      if (outputContextsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          outputContexts_ = java.util.Collections.unmodifiableList(outputContexts_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.outputContexts_ = outputContexts_;
      } else {
        result.outputContexts_ = outputContextsBuilder_.build();
      }
      if (sessionEntityTypesBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          sessionEntityTypes_ = java.util.Collections.unmodifiableList(sessionEntityTypes_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.sessionEntityTypes_ = sessionEntityTypes_;
      } else {
        result.sessionEntityTypes_ = sessionEntityTypesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.WebhookResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.fulfillmentText_ = fulfillmentText_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.source_ = source_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.payload_ = payloadBuilder_ == null ? payload_ : payloadBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.followupEventInput_ =
            followupEventInputBuilder_ == null
                ? followupEventInput_
                : followupEventInputBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.liveAgentHandoff_ = liveAgentHandoff_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.endInteraction_ = endInteraction_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.WebhookResponse) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.WebhookResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.WebhookResponse other) {
      if (other == com.google.cloud.dialogflow.v2beta1.WebhookResponse.getDefaultInstance())
        return this;
      if (!other.getFulfillmentText().isEmpty()) {
        fulfillmentText_ = other.fulfillmentText_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (fulfillmentMessagesBuilder_ == null) {
        if (!other.fulfillmentMessages_.isEmpty()) {
          if (fulfillmentMessages_.isEmpty()) {
            fulfillmentMessages_ = other.fulfillmentMessages_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureFulfillmentMessagesIsMutable();
            fulfillmentMessages_.addAll(other.fulfillmentMessages_);
          }
          onChanged();
        }
      } else {
        if (!other.fulfillmentMessages_.isEmpty()) {
          if (fulfillmentMessagesBuilder_.isEmpty()) {
            fulfillmentMessagesBuilder_.dispose();
            fulfillmentMessagesBuilder_ = null;
            fulfillmentMessages_ = other.fulfillmentMessages_;
            bitField0_ = (bitField0_ & ~0x00000002);
            fulfillmentMessagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFulfillmentMessagesFieldBuilder()
                    : null;
          } else {
            fulfillmentMessagesBuilder_.addAllMessages(other.fulfillmentMessages_);
          }
        }
      }
      if (!other.getSource().isEmpty()) {
        source_ = other.source_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasPayload()) {
        mergePayload(other.getPayload());
      }
      if (outputContextsBuilder_ == null) {
        if (!other.outputContexts_.isEmpty()) {
          if (outputContexts_.isEmpty()) {
            outputContexts_ = other.outputContexts_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureOutputContextsIsMutable();
            outputContexts_.addAll(other.outputContexts_);
          }
          onChanged();
        }
      } else {
        if (!other.outputContexts_.isEmpty()) {
          if (outputContextsBuilder_.isEmpty()) {
            outputContextsBuilder_.dispose();
            outputContextsBuilder_ = null;
            outputContexts_ = other.outputContexts_;
            bitField0_ = (bitField0_ & ~0x00000010);
            outputContextsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOutputContextsFieldBuilder()
                    : null;
          } else {
            outputContextsBuilder_.addAllMessages(other.outputContexts_);
          }
        }
      }
      if (other.hasFollowupEventInput()) {
        mergeFollowupEventInput(other.getFollowupEventInput());
      }
      if (other.getLiveAgentHandoff() != false) {
        setLiveAgentHandoff(other.getLiveAgentHandoff());
      }
      if (other.getEndInteraction() != false) {
        setEndInteraction(other.getEndInteraction());
      }
      if (sessionEntityTypesBuilder_ == null) {
        if (!other.sessionEntityTypes_.isEmpty()) {
          if (sessionEntityTypes_.isEmpty()) {
            sessionEntityTypes_ = other.sessionEntityTypes_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureSessionEntityTypesIsMutable();
            sessionEntityTypes_.addAll(other.sessionEntityTypes_);
          }
          onChanged();
        }
      } else {
        if (!other.sessionEntityTypes_.isEmpty()) {
          if (sessionEntityTypesBuilder_.isEmpty()) {
            sessionEntityTypesBuilder_.dispose();
            sessionEntityTypesBuilder_ = null;
            sessionEntityTypes_ = other.sessionEntityTypes_;
            bitField0_ = (bitField0_ & ~0x00000100);
            sessionEntityTypesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSessionEntityTypesFieldBuilder()
                    : null;
          } else {
            sessionEntityTypesBuilder_.addAllMessages(other.sessionEntityTypes_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                fulfillmentText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.dialogflow.v2beta1.Intent.Message m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.Intent.Message.parser(),
                        extensionRegistry);
                if (fulfillmentMessagesBuilder_ == null) {
                  ensureFulfillmentMessagesIsMutable();
                  fulfillmentMessages_.add(m);
                } else {
                  fulfillmentMessagesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                source_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getPayloadFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.dialogflow.v2beta1.Context m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.Context.parser(), extensionRegistry);
                if (outputContextsBuilder_ == null) {
                  ensureOutputContextsIsMutable();
                  outputContexts_.add(m);
                } else {
                  outputContextsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getFollowupEventInputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                liveAgentHandoff_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                endInteraction_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 82:
              {
                com.google.cloud.dialogflow.v2beta1.SessionEntityType m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.SessionEntityType.parser(),
                        extensionRegistry);
                if (sessionEntityTypesBuilder_ == null) {
                  ensureSessionEntityTypesIsMutable();
                  sessionEntityTypes_.add(m);
                } else {
                  sessionEntityTypesBuilder_.addMessage(m);
                }
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object fulfillmentText_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The text response message intended for the end-user.
     * It is recommended to use `fulfillment_messages.text.text[0]` instead.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_text][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_text]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>string fulfillment_text = 1;</code>
     *
     * @return The fulfillmentText.
     */
    public java.lang.String getFulfillmentText() {
      java.lang.Object ref = fulfillmentText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fulfillmentText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The text response message intended for the end-user.
     * It is recommended to use `fulfillment_messages.text.text[0]` instead.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_text][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_text]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>string fulfillment_text = 1;</code>
     *
     * @return The bytes for fulfillmentText.
     */
    public com.google.protobuf.ByteString getFulfillmentTextBytes() {
      java.lang.Object ref = fulfillmentText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fulfillmentText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The text response message intended for the end-user.
     * It is recommended to use `fulfillment_messages.text.text[0]` instead.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_text][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_text]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>string fulfillment_text = 1;</code>
     *
     * @param value The fulfillmentText to set.
     * @return This builder for chaining.
     */
    public Builder setFulfillmentText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fulfillmentText_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The text response message intended for the end-user.
     * It is recommended to use `fulfillment_messages.text.text[0]` instead.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_text][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_text]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>string fulfillment_text = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFulfillmentText() {
      fulfillmentText_ = getDefaultInstance().getFulfillmentText();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The text response message intended for the end-user.
     * It is recommended to use `fulfillment_messages.text.text[0]` instead.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_text][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_text]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>string fulfillment_text = 1;</code>
     *
     * @param value The bytes for fulfillmentText to set.
     * @return This builder for chaining.
     */
    public Builder setFulfillmentTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fulfillmentText_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.Intent.Message>
        fulfillmentMessages_ = java.util.Collections.emptyList();

    private void ensureFulfillmentMessagesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        fulfillmentMessages_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.Intent.Message>(
                fulfillmentMessages_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Intent.Message,
            com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder,
            com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder>
        fulfillmentMessagesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Intent.Message>
        getFulfillmentMessagesList() {
      if (fulfillmentMessagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fulfillmentMessages_);
      } else {
        return fulfillmentMessagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public int getFulfillmentMessagesCount() {
      if (fulfillmentMessagesBuilder_ == null) {
        return fulfillmentMessages_.size();
      } else {
        return fulfillmentMessagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Intent.Message getFulfillmentMessages(int index) {
      if (fulfillmentMessagesBuilder_ == null) {
        return fulfillmentMessages_.get(index);
      } else {
        return fulfillmentMessagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public Builder setFulfillmentMessages(
        int index, com.google.cloud.dialogflow.v2beta1.Intent.Message value) {
      if (fulfillmentMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.set(index, value);
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public Builder setFulfillmentMessages(
        int index, com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder builderForValue) {
      if (fulfillmentMessagesBuilder_ == null) {
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.set(index, builderForValue.build());
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public Builder addFulfillmentMessages(
        com.google.cloud.dialogflow.v2beta1.Intent.Message value) {
      if (fulfillmentMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.add(value);
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public Builder addFulfillmentMessages(
        int index, com.google.cloud.dialogflow.v2beta1.Intent.Message value) {
      if (fulfillmentMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.add(index, value);
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public Builder addFulfillmentMessages(
        com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder builderForValue) {
      if (fulfillmentMessagesBuilder_ == null) {
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.add(builderForValue.build());
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public Builder addFulfillmentMessages(
        int index, com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder builderForValue) {
      if (fulfillmentMessagesBuilder_ == null) {
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.add(index, builderForValue.build());
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public Builder addAllFulfillmentMessages(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.Intent.Message> values) {
      if (fulfillmentMessagesBuilder_ == null) {
        ensureFulfillmentMessagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fulfillmentMessages_);
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public Builder clearFulfillmentMessages() {
      if (fulfillmentMessagesBuilder_ == null) {
        fulfillmentMessages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public Builder removeFulfillmentMessages(int index) {
      if (fulfillmentMessagesBuilder_ == null) {
        ensureFulfillmentMessagesIsMutable();
        fulfillmentMessages_.remove(index);
        onChanged();
      } else {
        fulfillmentMessagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder getFulfillmentMessagesBuilder(
        int index) {
      return getFulfillmentMessagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder
        getFulfillmentMessagesOrBuilder(int index) {
      if (fulfillmentMessagesBuilder_ == null) {
        return fulfillmentMessages_.get(index);
      } else {
        return fulfillmentMessagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder>
        getFulfillmentMessagesOrBuilderList() {
      if (fulfillmentMessagesBuilder_ != null) {
        return fulfillmentMessagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fulfillmentMessages_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder
        addFulfillmentMessagesBuilder() {
      return getFulfillmentMessagesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2beta1.Intent.Message.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder addFulfillmentMessagesBuilder(
        int index) {
      return getFulfillmentMessagesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.v2beta1.Intent.Message.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The rich response messages intended for the end-user.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.fulfillment_messages][google.cloud.dialogflow.v2beta1.QueryResult.fulfillment_messages]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Intent.Message fulfillment_messages = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder>
        getFulfillmentMessagesBuilderList() {
      return getFulfillmentMessagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Intent.Message,
            com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder,
            com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder>
        getFulfillmentMessagesFieldBuilder() {
      if (fulfillmentMessagesBuilder_ == null) {
        fulfillmentMessagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.Intent.Message,
                com.google.cloud.dialogflow.v2beta1.Intent.Message.Builder,
                com.google.cloud.dialogflow.v2beta1.Intent.MessageOrBuilder>(
                fulfillmentMessages_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        fulfillmentMessages_ = null;
      }
      return fulfillmentMessagesBuilder_;
    }

    private java.lang.Object source_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A custom field used to identify the webhook source.
     * Arbitrary strings are supported.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_source][google.cloud.dialogflow.v2beta1.QueryResult.webhook_source]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>string source = 3;</code>
     *
     * @return The source.
     */
    public java.lang.String getSource() {
      java.lang.Object ref = source_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        source_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A custom field used to identify the webhook source.
     * Arbitrary strings are supported.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_source][google.cloud.dialogflow.v2beta1.QueryResult.webhook_source]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>string source = 3;</code>
     *
     * @return The bytes for source.
     */
    public com.google.protobuf.ByteString getSourceBytes() {
      java.lang.Object ref = source_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        source_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A custom field used to identify the webhook source.
     * Arbitrary strings are supported.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_source][google.cloud.dialogflow.v2beta1.QueryResult.webhook_source]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>string source = 3;</code>
     *
     * @param value The source to set.
     * @return This builder for chaining.
     */
    public Builder setSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      source_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A custom field used to identify the webhook source.
     * Arbitrary strings are supported.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_source][google.cloud.dialogflow.v2beta1.QueryResult.webhook_source]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>string source = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSource() {
      source_ = getDefaultInstance().getSource();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A custom field used to identify the webhook source.
     * Arbitrary strings are supported.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_source][google.cloud.dialogflow.v2beta1.QueryResult.webhook_source]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>string source = 3;</code>
     *
     * @param value The bytes for source to set.
     * @return This builder for chaining.
     */
    public Builder setSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      source_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Struct payload_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        payloadBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. This field can be used to pass custom data from your webhook to
     * the integration or API caller. Arbitrary JSON objects are supported. When
     * provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_payload][google.cloud.dialogflow.v2beta1.QueryResult.webhook_payload]
     * sent to the integration or API caller. This field is also used by the
     * [Google Assistant
     * integration](https://cloud.google.com/dialogflow/docs/integrations/aog)
     * for rich response messages.
     * See the format definition at [Google Assistant Dialogflow webhook
     * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     *
     * @return Whether the payload field is set.
     */
    public boolean hasPayload() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. This field can be used to pass custom data from your webhook to
     * the integration or API caller. Arbitrary JSON objects are supported. When
     * provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_payload][google.cloud.dialogflow.v2beta1.QueryResult.webhook_payload]
     * sent to the integration or API caller. This field is also used by the
     * [Google Assistant
     * integration](https://cloud.google.com/dialogflow/docs/integrations/aog)
     * for rich response messages.
     * See the format definition at [Google Assistant Dialogflow webhook
     * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     *
     * @return The payload.
     */
    public com.google.protobuf.Struct getPayload() {
      if (payloadBuilder_ == null) {
        return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
      } else {
        return payloadBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field can be used to pass custom data from your webhook to
     * the integration or API caller. Arbitrary JSON objects are supported. When
     * provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_payload][google.cloud.dialogflow.v2beta1.QueryResult.webhook_payload]
     * sent to the integration or API caller. This field is also used by the
     * [Google Assistant
     * integration](https://cloud.google.com/dialogflow/docs/integrations/aog)
     * for rich response messages.
     * See the format definition at [Google Assistant Dialogflow webhook
     * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    public Builder setPayload(com.google.protobuf.Struct value) {
      if (payloadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
      } else {
        payloadBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field can be used to pass custom data from your webhook to
     * the integration or API caller. Arbitrary JSON objects are supported. When
     * provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_payload][google.cloud.dialogflow.v2beta1.QueryResult.webhook_payload]
     * sent to the integration or API caller. This field is also used by the
     * [Google Assistant
     * integration](https://cloud.google.com/dialogflow/docs/integrations/aog)
     * for rich response messages.
     * See the format definition at [Google Assistant Dialogflow webhook
     * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    public Builder setPayload(com.google.protobuf.Struct.Builder builderForValue) {
      if (payloadBuilder_ == null) {
        payload_ = builderForValue.build();
      } else {
        payloadBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field can be used to pass custom data from your webhook to
     * the integration or API caller. Arbitrary JSON objects are supported. When
     * provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_payload][google.cloud.dialogflow.v2beta1.QueryResult.webhook_payload]
     * sent to the integration or API caller. This field is also used by the
     * [Google Assistant
     * integration](https://cloud.google.com/dialogflow/docs/integrations/aog)
     * for rich response messages.
     * See the format definition at [Google Assistant Dialogflow webhook
     * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    public Builder mergePayload(com.google.protobuf.Struct value) {
      if (payloadBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && payload_ != null
            && payload_ != com.google.protobuf.Struct.getDefaultInstance()) {
          getPayloadBuilder().mergeFrom(value);
        } else {
          payload_ = value;
        }
      } else {
        payloadBuilder_.mergeFrom(value);
      }
      if (payload_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field can be used to pass custom data from your webhook to
     * the integration or API caller. Arbitrary JSON objects are supported. When
     * provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_payload][google.cloud.dialogflow.v2beta1.QueryResult.webhook_payload]
     * sent to the integration or API caller. This field is also used by the
     * [Google Assistant
     * integration](https://cloud.google.com/dialogflow/docs/integrations/aog)
     * for rich response messages.
     * See the format definition at [Google Assistant Dialogflow webhook
     * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    public Builder clearPayload() {
      bitField0_ = (bitField0_ & ~0x00000008);
      payload_ = null;
      if (payloadBuilder_ != null) {
        payloadBuilder_.dispose();
        payloadBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This field can be used to pass custom data from your webhook to
     * the integration or API caller. Arbitrary JSON objects are supported. When
     * provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_payload][google.cloud.dialogflow.v2beta1.QueryResult.webhook_payload]
     * sent to the integration or API caller. This field is also used by the
     * [Google Assistant
     * integration](https://cloud.google.com/dialogflow/docs/integrations/aog)
     * for rich response messages.
     * See the format definition at [Google Assistant Dialogflow webhook
     * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    public com.google.protobuf.Struct.Builder getPayloadBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getPayloadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. This field can be used to pass custom data from your webhook to
     * the integration or API caller. Arbitrary JSON objects are supported. When
     * provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_payload][google.cloud.dialogflow.v2beta1.QueryResult.webhook_payload]
     * sent to the integration or API caller. This field is also used by the
     * [Google Assistant
     * integration](https://cloud.google.com/dialogflow/docs/integrations/aog)
     * for rich response messages.
     * See the format definition at [Google Assistant Dialogflow webhook
     * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    public com.google.protobuf.StructOrBuilder getPayloadOrBuilder() {
      if (payloadBuilder_ != null) {
        return payloadBuilder_.getMessageOrBuilder();
      } else {
        return payload_ == null ? com.google.protobuf.Struct.getDefaultInstance() : payload_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This field can be used to pass custom data from your webhook to
     * the integration or API caller. Arbitrary JSON objects are supported. When
     * provided, Dialogflow uses this field to populate
     * [QueryResult.webhook_payload][google.cloud.dialogflow.v2beta1.QueryResult.webhook_payload]
     * sent to the integration or API caller. This field is also used by the
     * [Google Assistant
     * integration](https://cloud.google.com/dialogflow/docs/integrations/aog)
     * for rich response messages.
     * See the format definition at [Google Assistant Dialogflow webhook
     * format](https://developers.google.com/assistant/actions/build/json/dialogflow-webhook-json)
     * </pre>
     *
     * <code>.google.protobuf.Struct payload = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getPayloadFieldBuilder() {
      if (payloadBuilder_ == null) {
        payloadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                getPayload(), getParentForChildren(), isClean());
        payload_ = null;
      }
      return payloadBuilder_;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.Context> outputContexts_ =
        java.util.Collections.emptyList();

    private void ensureOutputContextsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        outputContexts_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.Context>(outputContexts_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Context,
            com.google.cloud.dialogflow.v2beta1.Context.Builder,
            com.google.cloud.dialogflow.v2beta1.ContextOrBuilder>
        outputContextsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Context> getOutputContextsList() {
      if (outputContextsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(outputContexts_);
      } else {
        return outputContextsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public int getOutputContextsCount() {
      if (outputContextsBuilder_ == null) {
        return outputContexts_.size();
      } else {
        return outputContextsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Context getOutputContexts(int index) {
      if (outputContextsBuilder_ == null) {
        return outputContexts_.get(index);
      } else {
        return outputContextsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public Builder setOutputContexts(int index, com.google.cloud.dialogflow.v2beta1.Context value) {
      if (outputContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputContextsIsMutable();
        outputContexts_.set(index, value);
        onChanged();
      } else {
        outputContextsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public Builder setOutputContexts(
        int index, com.google.cloud.dialogflow.v2beta1.Context.Builder builderForValue) {
      if (outputContextsBuilder_ == null) {
        ensureOutputContextsIsMutable();
        outputContexts_.set(index, builderForValue.build());
        onChanged();
      } else {
        outputContextsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public Builder addOutputContexts(com.google.cloud.dialogflow.v2beta1.Context value) {
      if (outputContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputContextsIsMutable();
        outputContexts_.add(value);
        onChanged();
      } else {
        outputContextsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public Builder addOutputContexts(int index, com.google.cloud.dialogflow.v2beta1.Context value) {
      if (outputContextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOutputContextsIsMutable();
        outputContexts_.add(index, value);
        onChanged();
      } else {
        outputContextsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public Builder addOutputContexts(
        com.google.cloud.dialogflow.v2beta1.Context.Builder builderForValue) {
      if (outputContextsBuilder_ == null) {
        ensureOutputContextsIsMutable();
        outputContexts_.add(builderForValue.build());
        onChanged();
      } else {
        outputContextsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public Builder addOutputContexts(
        int index, com.google.cloud.dialogflow.v2beta1.Context.Builder builderForValue) {
      if (outputContextsBuilder_ == null) {
        ensureOutputContextsIsMutable();
        outputContexts_.add(index, builderForValue.build());
        onChanged();
      } else {
        outputContextsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public Builder addAllOutputContexts(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.Context> values) {
      if (outputContextsBuilder_ == null) {
        ensureOutputContextsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, outputContexts_);
        onChanged();
      } else {
        outputContextsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public Builder clearOutputContexts() {
      if (outputContextsBuilder_ == null) {
        outputContexts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        outputContextsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public Builder removeOutputContexts(int index) {
      if (outputContextsBuilder_ == null) {
        ensureOutputContextsIsMutable();
        outputContexts_.remove(index);
        onChanged();
      } else {
        outputContextsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Context.Builder getOutputContextsBuilder(int index) {
      return getOutputContextsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.ContextOrBuilder getOutputContextsOrBuilder(
        int index) {
      if (outputContextsBuilder_ == null) {
        return outputContexts_.get(index);
      } else {
        return outputContextsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.ContextOrBuilder>
        getOutputContextsOrBuilderList() {
      if (outputContextsBuilder_ != null) {
        return outputContextsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(outputContexts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Context.Builder addOutputContextsBuilder() {
      return getOutputContextsFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2beta1.Context.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.Context.Builder addOutputContextsBuilder(int index) {
      return getOutputContextsFieldBuilder()
          .addBuilder(index, com.google.cloud.dialogflow.v2beta1.Context.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The collection of output contexts that will overwrite currently
     * active contexts for the session and reset their lifespans.
     * When provided, Dialogflow uses this field to populate
     * [QueryResult.output_contexts][google.cloud.dialogflow.v2beta1.QueryResult.output_contexts]
     * sent to the integration or API caller.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.Context output_contexts = 5;</code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.Context.Builder>
        getOutputContextsBuilderList() {
      return getOutputContextsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.Context,
            com.google.cloud.dialogflow.v2beta1.Context.Builder,
            com.google.cloud.dialogflow.v2beta1.ContextOrBuilder>
        getOutputContextsFieldBuilder() {
      if (outputContextsBuilder_ == null) {
        outputContextsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.Context,
                com.google.cloud.dialogflow.v2beta1.Context.Builder,
                com.google.cloud.dialogflow.v2beta1.ContextOrBuilder>(
                outputContexts_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        outputContexts_ = null;
      }
      return outputContextsBuilder_;
    }

    private com.google.cloud.dialogflow.v2beta1.EventInput followupEventInput_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.EventInput,
            com.google.cloud.dialogflow.v2beta1.EventInput.Builder,
            com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder>
        followupEventInputBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Invokes the supplied events.
     * When this field is set, Dialogflow ignores the `fulfillment_text`,
     * `fulfillment_messages`, and `payload` fields.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput followup_event_input = 6;</code>
     *
     * @return Whether the followupEventInput field is set.
     */
    public boolean hasFollowupEventInput() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Invokes the supplied events.
     * When this field is set, Dialogflow ignores the `fulfillment_text`,
     * `fulfillment_messages`, and `payload` fields.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput followup_event_input = 6;</code>
     *
     * @return The followupEventInput.
     */
    public com.google.cloud.dialogflow.v2beta1.EventInput getFollowupEventInput() {
      if (followupEventInputBuilder_ == null) {
        return followupEventInput_ == null
            ? com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance()
            : followupEventInput_;
      } else {
        return followupEventInputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Invokes the supplied events.
     * When this field is set, Dialogflow ignores the `fulfillment_text`,
     * `fulfillment_messages`, and `payload` fields.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput followup_event_input = 6;</code>
     */
    public Builder setFollowupEventInput(com.google.cloud.dialogflow.v2beta1.EventInput value) {
      if (followupEventInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        followupEventInput_ = value;
      } else {
        followupEventInputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Invokes the supplied events.
     * When this field is set, Dialogflow ignores the `fulfillment_text`,
     * `fulfillment_messages`, and `payload` fields.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput followup_event_input = 6;</code>
     */
    public Builder setFollowupEventInput(
        com.google.cloud.dialogflow.v2beta1.EventInput.Builder builderForValue) {
      if (followupEventInputBuilder_ == null) {
        followupEventInput_ = builderForValue.build();
      } else {
        followupEventInputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Invokes the supplied events.
     * When this field is set, Dialogflow ignores the `fulfillment_text`,
     * `fulfillment_messages`, and `payload` fields.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput followup_event_input = 6;</code>
     */
    public Builder mergeFollowupEventInput(com.google.cloud.dialogflow.v2beta1.EventInput value) {
      if (followupEventInputBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && followupEventInput_ != null
            && followupEventInput_
                != com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance()) {
          getFollowupEventInputBuilder().mergeFrom(value);
        } else {
          followupEventInput_ = value;
        }
      } else {
        followupEventInputBuilder_.mergeFrom(value);
      }
      if (followupEventInput_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Invokes the supplied events.
     * When this field is set, Dialogflow ignores the `fulfillment_text`,
     * `fulfillment_messages`, and `payload` fields.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput followup_event_input = 6;</code>
     */
    public Builder clearFollowupEventInput() {
      bitField0_ = (bitField0_ & ~0x00000020);
      followupEventInput_ = null;
      if (followupEventInputBuilder_ != null) {
        followupEventInputBuilder_.dispose();
        followupEventInputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Invokes the supplied events.
     * When this field is set, Dialogflow ignores the `fulfillment_text`,
     * `fulfillment_messages`, and `payload` fields.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput followup_event_input = 6;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.EventInput.Builder getFollowupEventInputBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getFollowupEventInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Invokes the supplied events.
     * When this field is set, Dialogflow ignores the `fulfillment_text`,
     * `fulfillment_messages`, and `payload` fields.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput followup_event_input = 6;</code>
     */
    public com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder
        getFollowupEventInputOrBuilder() {
      if (followupEventInputBuilder_ != null) {
        return followupEventInputBuilder_.getMessageOrBuilder();
      } else {
        return followupEventInput_ == null
            ? com.google.cloud.dialogflow.v2beta1.EventInput.getDefaultInstance()
            : followupEventInput_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Invokes the supplied events.
     * When this field is set, Dialogflow ignores the `fulfillment_text`,
     * `fulfillment_messages`, and `payload` fields.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.EventInput followup_event_input = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.EventInput,
            com.google.cloud.dialogflow.v2beta1.EventInput.Builder,
            com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder>
        getFollowupEventInputFieldBuilder() {
      if (followupEventInputBuilder_ == null) {
        followupEventInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.EventInput,
                com.google.cloud.dialogflow.v2beta1.EventInput.Builder,
                com.google.cloud.dialogflow.v2beta1.EventInputOrBuilder>(
                getFollowupEventInput(), getParentForChildren(), isClean());
        followupEventInput_ = null;
      }
      return followupEventInputBuilder_;
    }

    private boolean liveAgentHandoff_;
    /**
     *
     *
     * <pre>
     * Indicates that a live agent should be brought in to handle the
     * interaction with the user. In most cases, when you set this flag to true,
     * you would also want to set end_interaction to true as well. Default is
     * false.
     * </pre>
     *
     * <code>bool live_agent_handoff = 7;</code>
     *
     * @return The liveAgentHandoff.
     */
    @java.lang.Override
    public boolean getLiveAgentHandoff() {
      return liveAgentHandoff_;
    }
    /**
     *
     *
     * <pre>
     * Indicates that a live agent should be brought in to handle the
     * interaction with the user. In most cases, when you set this flag to true,
     * you would also want to set end_interaction to true as well. Default is
     * false.
     * </pre>
     *
     * <code>bool live_agent_handoff = 7;</code>
     *
     * @param value The liveAgentHandoff to set.
     * @return This builder for chaining.
     */
    public Builder setLiveAgentHandoff(boolean value) {

      liveAgentHandoff_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates that a live agent should be brought in to handle the
     * interaction with the user. In most cases, when you set this flag to true,
     * you would also want to set end_interaction to true as well. Default is
     * false.
     * </pre>
     *
     * <code>bool live_agent_handoff = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLiveAgentHandoff() {
      bitField0_ = (bitField0_ & ~0x00000040);
      liveAgentHandoff_ = false;
      onChanged();
      return this;
    }

    private boolean endInteraction_;
    /**
     *
     *
     * <pre>
     * Optional. Indicates that this intent ends an interaction. Some integrations
     * (e.g., Actions on Google or Dialogflow phone gateway) use this information
     * to close interaction with an end user. Default is false.
     * </pre>
     *
     * <code>bool end_interaction = 8;</code>
     *
     * @return The endInteraction.
     */
    @java.lang.Override
    public boolean getEndInteraction() {
      return endInteraction_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates that this intent ends an interaction. Some integrations
     * (e.g., Actions on Google or Dialogflow phone gateway) use this information
     * to close interaction with an end user. Default is false.
     * </pre>
     *
     * <code>bool end_interaction = 8;</code>
     *
     * @param value The endInteraction to set.
     * @return This builder for chaining.
     */
    public Builder setEndInteraction(boolean value) {

      endInteraction_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Indicates that this intent ends an interaction. Some integrations
     * (e.g., Actions on Google or Dialogflow phone gateway) use this information
     * to close interaction with an end user. Default is false.
     * </pre>
     *
     * <code>bool end_interaction = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndInteraction() {
      bitField0_ = (bitField0_ & ~0x00000080);
      endInteraction_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.SessionEntityType>
        sessionEntityTypes_ = java.util.Collections.emptyList();

    private void ensureSessionEntityTypesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        sessionEntityTypes_ =
            new java.util.ArrayList<com.google.cloud.dialogflow.v2beta1.SessionEntityType>(
                sessionEntityTypes_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SessionEntityType,
            com.google.cloud.dialogflow.v2beta1.SessionEntityType.Builder,
            com.google.cloud.dialogflow.v2beta1.SessionEntityTypeOrBuilder>
        sessionEntityTypesBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.SessionEntityType>
        getSessionEntityTypesList() {
      if (sessionEntityTypesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sessionEntityTypes_);
      } else {
        return sessionEntityTypesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public int getSessionEntityTypesCount() {
      if (sessionEntityTypesBuilder_ == null) {
        return sessionEntityTypes_.size();
      } else {
        return sessionEntityTypesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SessionEntityType getSessionEntityTypes(int index) {
      if (sessionEntityTypesBuilder_ == null) {
        return sessionEntityTypes_.get(index);
      } else {
        return sessionEntityTypesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public Builder setSessionEntityTypes(
        int index, com.google.cloud.dialogflow.v2beta1.SessionEntityType value) {
      if (sessionEntityTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.set(index, value);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public Builder setSessionEntityTypes(
        int index, com.google.cloud.dialogflow.v2beta1.SessionEntityType.Builder builderForValue) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.set(index, builderForValue.build());
        onChanged();
      } else {
        sessionEntityTypesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public Builder addSessionEntityTypes(
        com.google.cloud.dialogflow.v2beta1.SessionEntityType value) {
      if (sessionEntityTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.add(value);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public Builder addSessionEntityTypes(
        int index, com.google.cloud.dialogflow.v2beta1.SessionEntityType value) {
      if (sessionEntityTypesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.add(index, value);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public Builder addSessionEntityTypes(
        com.google.cloud.dialogflow.v2beta1.SessionEntityType.Builder builderForValue) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.add(builderForValue.build());
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public Builder addSessionEntityTypes(
        int index, com.google.cloud.dialogflow.v2beta1.SessionEntityType.Builder builderForValue) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.add(index, builderForValue.build());
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public Builder addAllSessionEntityTypes(
        java.lang.Iterable<? extends com.google.cloud.dialogflow.v2beta1.SessionEntityType>
            values) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sessionEntityTypes_);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public Builder clearSessionEntityTypes() {
      if (sessionEntityTypesBuilder_ == null) {
        sessionEntityTypes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public Builder removeSessionEntityTypes(int index) {
      if (sessionEntityTypesBuilder_ == null) {
        ensureSessionEntityTypesIsMutable();
        sessionEntityTypes_.remove(index);
        onChanged();
      } else {
        sessionEntityTypesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SessionEntityType.Builder
        getSessionEntityTypesBuilder(int index) {
      return getSessionEntityTypesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SessionEntityTypeOrBuilder
        getSessionEntityTypesOrBuilder(int index) {
      if (sessionEntityTypesBuilder_ == null) {
        return sessionEntityTypes_.get(index);
      } else {
        return sessionEntityTypesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dialogflow.v2beta1.SessionEntityTypeOrBuilder>
        getSessionEntityTypesOrBuilderList() {
      if (sessionEntityTypesBuilder_ != null) {
        return sessionEntityTypesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sessionEntityTypes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SessionEntityType.Builder
        addSessionEntityTypesBuilder() {
      return getSessionEntityTypesFieldBuilder()
          .addBuilder(com.google.cloud.dialogflow.v2beta1.SessionEntityType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SessionEntityType.Builder
        addSessionEntityTypesBuilder(int index) {
      return getSessionEntityTypesFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dialogflow.v2beta1.SessionEntityType.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Additional session entity types to replace or extend developer
     * entity types with. The entity synonyms apply to all languages and persist
     * for the session. Setting this data from a webhook overwrites
     * the session entity types that have been set using `detectIntent`,
     * `streamingDetectIntent` or
     * [SessionEntityType][google.cloud.dialogflow.v2beta1.SessionEntityType]
     * management methods.
     * </pre>
     *
     * <code>repeated .google.cloud.dialogflow.v2beta1.SessionEntityType session_entity_types = 10;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.SessionEntityType.Builder>
        getSessionEntityTypesBuilderList() {
      return getSessionEntityTypesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SessionEntityType,
            com.google.cloud.dialogflow.v2beta1.SessionEntityType.Builder,
            com.google.cloud.dialogflow.v2beta1.SessionEntityTypeOrBuilder>
        getSessionEntityTypesFieldBuilder() {
      if (sessionEntityTypesBuilder_ == null) {
        sessionEntityTypesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.SessionEntityType,
                com.google.cloud.dialogflow.v2beta1.SessionEntityType.Builder,
                com.google.cloud.dialogflow.v2beta1.SessionEntityTypeOrBuilder>(
                sessionEntityTypes_,
                ((bitField0_ & 0x00000100) != 0),
                getParentForChildren(),
                isClean());
        sessionEntityTypes_ = null;
      }
      return sessionEntityTypesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.WebhookResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.WebhookResponse)
  private static final com.google.cloud.dialogflow.v2beta1.WebhookResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.WebhookResponse();
  }

  public static com.google.cloud.dialogflow.v2beta1.WebhookResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WebhookResponse> PARSER =
      new com.google.protobuf.AbstractParser<WebhookResponse>() {
        @java.lang.Override
        public WebhookResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WebhookResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WebhookResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.WebhookResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
