/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/agent.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * A Dialogflow agent is a virtual agent that handles conversations with your
 * end-users. It is a natural language understanding module that understands the
 * nuances of human language. Dialogflow translates end-user text or audio
 * during a conversation to structured data that your apps and services can
 * understand. You design and build a Dialogflow agent to handle the types of
 * conversations required for your system.
 *
 * For more information about agents, see the
 * [Agent guide](https://cloud.google.com/dialogflow/docs/agents-overview).
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.Agent}
 */
public final class Agent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.Agent)
    AgentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Agent.newBuilder() to construct.
  private Agent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Agent() {
    parent_ = "";
    displayName_ = "";
    defaultLanguageCode_ = "";
    supportedLanguageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    timeZone_ = "";
    description_ = "";
    avatarUri_ = "";
    matchMode_ = 0;
    apiVersion_ = 0;
    tier_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Agent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.AgentProto
        .internal_static_google_cloud_dialogflow_v2beta1_Agent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.AgentProto
        .internal_static_google_cloud_dialogflow_v2beta1_Agent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.Agent.class,
            com.google.cloud.dialogflow.v2beta1.Agent.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Match mode determines how intents are detected from user queries.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2beta1.Agent.MatchMode}
   */
  public enum MatchMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>MATCH_MODE_UNSPECIFIED = 0;</code>
     */
    MATCH_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Best for agents with a small number of examples in intents and/or wide
     * use of templates syntax and composite entities.
     * </pre>
     *
     * <code>MATCH_MODE_HYBRID = 1;</code>
     */
    MATCH_MODE_HYBRID(1),
    /**
     *
     *
     * <pre>
     * Can be used for agents with a large number of examples in intents,
     * especially the ones using &#64;sys.any or very large custom entities.
     * </pre>
     *
     * <code>MATCH_MODE_ML_ONLY = 2;</code>
     */
    MATCH_MODE_ML_ONLY(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>MATCH_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int MATCH_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Best for agents with a small number of examples in intents and/or wide
     * use of templates syntax and composite entities.
     * </pre>
     *
     * <code>MATCH_MODE_HYBRID = 1;</code>
     */
    public static final int MATCH_MODE_HYBRID_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Can be used for agents with a large number of examples in intents,
     * especially the ones using &#64;sys.any or very large custom entities.
     * </pre>
     *
     * <code>MATCH_MODE_ML_ONLY = 2;</code>
     */
    public static final int MATCH_MODE_ML_ONLY_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MatchMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MatchMode forNumber(int value) {
      switch (value) {
        case 0:
          return MATCH_MODE_UNSPECIFIED;
        case 1:
          return MATCH_MODE_HYBRID;
        case 2:
          return MATCH_MODE_ML_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MatchMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MatchMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MatchMode>() {
          public MatchMode findValueByNumber(int number) {
            return MatchMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.Agent.getDescriptor().getEnumTypes().get(0);
    }

    private static final MatchMode[] VALUES = values();

    public static MatchMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MatchMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.Agent.MatchMode)
  }

  /**
   *
   *
   * <pre>
   * API version for the agent.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2beta1.Agent.ApiVersion}
   */
  public enum ApiVersion implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>API_VERSION_UNSPECIFIED = 0;</code>
     */
    API_VERSION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Legacy V1 API.
     * </pre>
     *
     * <code>API_VERSION_V1 = 1;</code>
     */
    API_VERSION_V1(1),
    /**
     *
     *
     * <pre>
     * V2 API.
     * </pre>
     *
     * <code>API_VERSION_V2 = 2;</code>
     */
    API_VERSION_V2(2),
    /**
     *
     *
     * <pre>
     * V2beta1 API.
     * </pre>
     *
     * <code>API_VERSION_V2_BETA_1 = 3;</code>
     */
    API_VERSION_V2_BETA_1(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>API_VERSION_UNSPECIFIED = 0;</code>
     */
    public static final int API_VERSION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Legacy V1 API.
     * </pre>
     *
     * <code>API_VERSION_V1 = 1;</code>
     */
    public static final int API_VERSION_V1_VALUE = 1;
    /**
     *
     *
     * <pre>
     * V2 API.
     * </pre>
     *
     * <code>API_VERSION_V2 = 2;</code>
     */
    public static final int API_VERSION_V2_VALUE = 2;
    /**
     *
     *
     * <pre>
     * V2beta1 API.
     * </pre>
     *
     * <code>API_VERSION_V2_BETA_1 = 3;</code>
     */
    public static final int API_VERSION_V2_BETA_1_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ApiVersion valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ApiVersion forNumber(int value) {
      switch (value) {
        case 0:
          return API_VERSION_UNSPECIFIED;
        case 1:
          return API_VERSION_V1;
        case 2:
          return API_VERSION_V2;
        case 3:
          return API_VERSION_V2_BETA_1;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ApiVersion> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ApiVersion> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ApiVersion>() {
          public ApiVersion findValueByNumber(int number) {
            return ApiVersion.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.Agent.getDescriptor().getEnumTypes().get(1);
    }

    private static final ApiVersion[] VALUES = values();

    public static ApiVersion valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ApiVersion(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.Agent.ApiVersion)
  }

  /**
   *
   *
   * <pre>
   * Represents the agent tier.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2beta1.Agent.Tier}
   */
  public enum Tier implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. This value should never be used.
     * </pre>
     *
     * <code>TIER_UNSPECIFIED = 0;</code>
     */
    TIER_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Trial Edition, previously known as Standard Edition.
     * </pre>
     *
     * <code>TIER_STANDARD = 1;</code>
     */
    TIER_STANDARD(1),
    /**
     *
     *
     * <pre>
     * Essentials Edition, previously known as Enterprise Essential Edition.
     * </pre>
     *
     * <code>TIER_ENTERPRISE = 2;</code>
     */
    TIER_ENTERPRISE(2),
    /**
     *
     *
     * <pre>
     * Essentials Edition (same as TIER_ENTERPRISE), previously known as
     * Enterprise Plus Edition.
     * </pre>
     *
     * <code>TIER_ENTERPRISE_PLUS = 3 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    TIER_ENTERPRISE_PLUS(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. This value should never be used.
     * </pre>
     *
     * <code>TIER_UNSPECIFIED = 0;</code>
     */
    public static final int TIER_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Trial Edition, previously known as Standard Edition.
     * </pre>
     *
     * <code>TIER_STANDARD = 1;</code>
     */
    public static final int TIER_STANDARD_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Essentials Edition, previously known as Enterprise Essential Edition.
     * </pre>
     *
     * <code>TIER_ENTERPRISE = 2;</code>
     */
    public static final int TIER_ENTERPRISE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Essentials Edition (same as TIER_ENTERPRISE), previously known as
     * Enterprise Plus Edition.
     * </pre>
     *
     * <code>TIER_ENTERPRISE_PLUS = 3 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int TIER_ENTERPRISE_PLUS_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Tier valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Tier forNumber(int value) {
      switch (value) {
        case 0:
          return TIER_UNSPECIFIED;
        case 1:
          return TIER_STANDARD;
        case 2:
          return TIER_ENTERPRISE;
        case 3:
          return TIER_ENTERPRISE_PLUS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Tier> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Tier> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Tier>() {
          public Tier findValueByNumber(int number) {
            return Tier.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.Agent.getDescriptor().getEnumTypes().get(2);
    }

    private static final Tier[] VALUES = values();

    public static Tier valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Tier(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.Agent.Tier)
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The project of this agent.
   * Format: `projects/&lt;Project ID&gt;` or
   *         `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The project of this agent.
   * Format: `projects/&lt;Project ID&gt;` or
   *         `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of this agent.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of this agent.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_LANGUAGE_CODE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultLanguageCode_ = "";
  /**
   *
   *
   * <pre>
   * Required. The default language of the agent as a language tag. See
   * [Language
   * Support](https://cloud.google.com/dialogflow/docs/reference/language)
   * for a list of the currently supported language codes. This field cannot be
   * set by the `Update` method.
   * </pre>
   *
   * <code>string default_language_code = 3;</code>
   *
   * @return The defaultLanguageCode.
   */
  @java.lang.Override
  public java.lang.String getDefaultLanguageCode() {
    java.lang.Object ref = defaultLanguageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultLanguageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The default language of the agent as a language tag. See
   * [Language
   * Support](https://cloud.google.com/dialogflow/docs/reference/language)
   * for a list of the currently supported language codes. This field cannot be
   * set by the `Update` method.
   * </pre>
   *
   * <code>string default_language_code = 3;</code>
   *
   * @return The bytes for defaultLanguageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultLanguageCodeBytes() {
    java.lang.Object ref = defaultLanguageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultLanguageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUPPORTED_LANGUAGE_CODES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList supportedLanguageCodes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The list of all languages supported by this agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4;</code>
   *
   * @return A list containing the supportedLanguageCodes.
   */
  public com.google.protobuf.ProtocolStringList getSupportedLanguageCodesList() {
    return supportedLanguageCodes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of all languages supported by this agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4;</code>
   *
   * @return The count of supportedLanguageCodes.
   */
  public int getSupportedLanguageCodesCount() {
    return supportedLanguageCodes_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of all languages supported by this agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The supportedLanguageCodes at the given index.
   */
  public java.lang.String getSupportedLanguageCodes(int index) {
    return supportedLanguageCodes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The list of all languages supported by this agent (except for the
   * `default_language_code`).
   * </pre>
   *
   * <code>repeated string supported_language_codes = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the supportedLanguageCodes at the given index.
   */
  public com.google.protobuf.ByteString getSupportedLanguageCodesBytes(int index) {
    return supportedLanguageCodes_.getByteString(index);
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object timeZone_ = "";
  /**
   *
   *
   * <pre>
   * Required. The time zone of this agent from the
   * [time zone database](https://www.iana.org/time-zones), e.g.,
   * America/New_York, Europe/Paris.
   * </pre>
   *
   * <code>string time_zone = 5;</code>
   *
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The time zone of this agent from the
   * [time zone database](https://www.iana.org/time-zones), e.g.,
   * America/New_York, Europe/Paris.
   * </pre>
   *
   * <code>string time_zone = 5;</code>
   *
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The description of this agent.
   * The maximum length is 500 characters. If exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The description of this agent.
   * The maximum length is 500 characters. If exceeded, the request is rejected.
   * </pre>
   *
   * <code>string description = 6;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AVATAR_URI_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object avatarUri_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The URI of the agent's avatar.
   * Avatars are used throughout the Dialogflow console and in the self-hosted
   * [Web
   * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
   * integration.
   * </pre>
   *
   * <code>string avatar_uri = 7;</code>
   *
   * @return The avatarUri.
   */
  @java.lang.Override
  public java.lang.String getAvatarUri() {
    java.lang.Object ref = avatarUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      avatarUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The URI of the agent's avatar.
   * Avatars are used throughout the Dialogflow console and in the self-hosted
   * [Web
   * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
   * integration.
   * </pre>
   *
   * <code>string avatar_uri = 7;</code>
   *
   * @return The bytes for avatarUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAvatarUriBytes() {
    java.lang.Object ref = avatarUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      avatarUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_LOGGING_FIELD_NUMBER = 8;
  private boolean enableLogging_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Determines whether this agent should log conversation queries.
   * </pre>
   *
   * <code>bool enable_logging = 8;</code>
   *
   * @return The enableLogging.
   */
  @java.lang.Override
  public boolean getEnableLogging() {
    return enableLogging_;
  }

  public static final int MATCH_MODE_FIELD_NUMBER = 9;
  private int matchMode_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Determines how intents are detected from user queries.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.Agent.MatchMode match_mode = 9 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.dialogflow.v2beta1.Agent.match_mode is deprecated. See
   *     google/cloud/dialogflow/v2beta1/agent.proto;l=355
   * @return The enum numeric value on the wire for matchMode.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getMatchModeValue() {
    return matchMode_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Determines how intents are detected from user queries.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.Agent.MatchMode match_mode = 9 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.dialogflow.v2beta1.Agent.match_mode is deprecated. See
   *     google/cloud/dialogflow/v2beta1/agent.proto;l=355
   * @return The matchMode.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.dialogflow.v2beta1.Agent.MatchMode getMatchMode() {
    com.google.cloud.dialogflow.v2beta1.Agent.MatchMode result =
        com.google.cloud.dialogflow.v2beta1.Agent.MatchMode.forNumber(matchMode_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.Agent.MatchMode.UNRECOGNIZED
        : result;
  }

  public static final int CLASSIFICATION_THRESHOLD_FIELD_NUMBER = 10;
  private float classificationThreshold_ = 0F;
  /**
   *
   *
   * <pre>
   * Optional. To filter out false positive results and still get variety in
   * matched natural language inputs for your agent, you can tune the machine
   * learning classification threshold. If the returned score value is less than
   * the threshold value, then a fallback intent will be triggered or, if there
   * are no fallback intents defined, no intent will be triggered. The score
   * values range from 0.0 (completely uncertain) to 1.0 (completely certain).
   * If set to 0.0, the default of 0.3 is used.
   * </pre>
   *
   * <code>float classification_threshold = 10;</code>
   *
   * @return The classificationThreshold.
   */
  @java.lang.Override
  public float getClassificationThreshold() {
    return classificationThreshold_;
  }

  public static final int API_VERSION_FIELD_NUMBER = 14;
  private int apiVersion_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. API version displayed in Dialogflow console. If not specified,
   * V2 API is assumed. Clients are free to query different service endpoints
   * for different API versions. However, bots connectors and webhook calls will
   * follow the specified API version.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.Agent.ApiVersion api_version = 14;</code>
   *
   * @return The enum numeric value on the wire for apiVersion.
   */
  @java.lang.Override
  public int getApiVersionValue() {
    return apiVersion_;
  }
  /**
   *
   *
   * <pre>
   * Optional. API version displayed in Dialogflow console. If not specified,
   * V2 API is assumed. Clients are free to query different service endpoints
   * for different API versions. However, bots connectors and webhook calls will
   * follow the specified API version.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.Agent.ApiVersion api_version = 14;</code>
   *
   * @return The apiVersion.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Agent.ApiVersion getApiVersion() {
    com.google.cloud.dialogflow.v2beta1.Agent.ApiVersion result =
        com.google.cloud.dialogflow.v2beta1.Agent.ApiVersion.forNumber(apiVersion_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.Agent.ApiVersion.UNRECOGNIZED
        : result;
  }

  public static final int TIER_FIELD_NUMBER = 15;
  private int tier_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.Agent.Tier tier = 15;</code>
   *
   * @return The enum numeric value on the wire for tier.
   */
  @java.lang.Override
  public int getTierValue() {
    return tier_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.Agent.Tier tier = 15;</code>
   *
   * @return The tier.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Agent.Tier getTier() {
    com.google.cloud.dialogflow.v2beta1.Agent.Tier result =
        com.google.cloud.dialogflow.v2beta1.Agent.Tier.forNumber(tier_);
    return result == null ? com.google.cloud.dialogflow.v2beta1.Agent.Tier.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLanguageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, defaultLanguageCode_);
    }
    for (int i = 0; i < supportedLanguageCodes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 4, supportedLanguageCodes_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, timeZone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(avatarUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, avatarUri_);
    }
    if (enableLogging_ != false) {
      output.writeBool(8, enableLogging_);
    }
    if (matchMode_
        != com.google.cloud.dialogflow.v2beta1.Agent.MatchMode.MATCH_MODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, matchMode_);
    }
    if (java.lang.Float.floatToRawIntBits(classificationThreshold_) != 0) {
      output.writeFloat(10, classificationThreshold_);
    }
    if (apiVersion_
        != com.google.cloud.dialogflow.v2beta1.Agent.ApiVersion.API_VERSION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(14, apiVersion_);
    }
    if (tier_ != com.google.cloud.dialogflow.v2beta1.Agent.Tier.TIER_UNSPECIFIED.getNumber()) {
      output.writeEnum(15, tier_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultLanguageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, defaultLanguageCode_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < supportedLanguageCodes_.size(); i++) {
        dataSize += computeStringSizeNoTag(supportedLanguageCodes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSupportedLanguageCodesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(timeZone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, timeZone_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(avatarUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, avatarUri_);
    }
    if (enableLogging_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, enableLogging_);
    }
    if (matchMode_
        != com.google.cloud.dialogflow.v2beta1.Agent.MatchMode.MATCH_MODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, matchMode_);
    }
    if (java.lang.Float.floatToRawIntBits(classificationThreshold_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(10, classificationThreshold_);
    }
    if (apiVersion_
        != com.google.cloud.dialogflow.v2beta1.Agent.ApiVersion.API_VERSION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(14, apiVersion_);
    }
    if (tier_ != com.google.cloud.dialogflow.v2beta1.Agent.Tier.TIER_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(15, tier_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.Agent)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.Agent other =
        (com.google.cloud.dialogflow.v2beta1.Agent) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDefaultLanguageCode().equals(other.getDefaultLanguageCode())) return false;
    if (!getSupportedLanguageCodesList().equals(other.getSupportedLanguageCodesList()))
      return false;
    if (!getTimeZone().equals(other.getTimeZone())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getAvatarUri().equals(other.getAvatarUri())) return false;
    if (getEnableLogging() != other.getEnableLogging()) return false;
    if (matchMode_ != other.matchMode_) return false;
    if (java.lang.Float.floatToIntBits(getClassificationThreshold())
        != java.lang.Float.floatToIntBits(other.getClassificationThreshold())) return false;
    if (apiVersion_ != other.apiVersion_) return false;
    if (tier_ != other.tier_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DEFAULT_LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultLanguageCode().hashCode();
    if (getSupportedLanguageCodesCount() > 0) {
      hash = (37 * hash) + SUPPORTED_LANGUAGE_CODES_FIELD_NUMBER;
      hash = (53 * hash) + getSupportedLanguageCodesList().hashCode();
    }
    hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getTimeZone().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + AVATAR_URI_FIELD_NUMBER;
    hash = (53 * hash) + getAvatarUri().hashCode();
    hash = (37 * hash) + ENABLE_LOGGING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableLogging());
    hash = (37 * hash) + MATCH_MODE_FIELD_NUMBER;
    hash = (53 * hash) + matchMode_;
    hash = (37 * hash) + CLASSIFICATION_THRESHOLD_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getClassificationThreshold());
    hash = (37 * hash) + API_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + apiVersion_;
    hash = (37 * hash) + TIER_FIELD_NUMBER;
    hash = (53 * hash) + tier_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.Agent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Agent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Agent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Agent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Agent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.Agent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Agent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Agent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Agent parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Agent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.Agent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.Agent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dialogflow.v2beta1.Agent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Dialogflow agent is a virtual agent that handles conversations with your
   * end-users. It is a natural language understanding module that understands the
   * nuances of human language. Dialogflow translates end-user text or audio
   * during a conversation to structured data that your apps and services can
   * understand. You design and build a Dialogflow agent to handle the types of
   * conversations required for your system.
   *
   * For more information about agents, see the
   * [Agent guide](https://cloud.google.com/dialogflow/docs/agents-overview).
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.Agent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.Agent)
      com.google.cloud.dialogflow.v2beta1.AgentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.AgentProto
          .internal_static_google_cloud_dialogflow_v2beta1_Agent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.AgentProto
          .internal_static_google_cloud_dialogflow_v2beta1_Agent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.Agent.class,
              com.google.cloud.dialogflow.v2beta1.Agent.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.Agent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      displayName_ = "";
      defaultLanguageCode_ = "";
      supportedLanguageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      timeZone_ = "";
      description_ = "";
      avatarUri_ = "";
      enableLogging_ = false;
      matchMode_ = 0;
      classificationThreshold_ = 0F;
      apiVersion_ = 0;
      tier_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.AgentProto
          .internal_static_google_cloud_dialogflow_v2beta1_Agent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Agent getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.Agent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Agent build() {
      com.google.cloud.dialogflow.v2beta1.Agent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Agent buildPartial() {
      com.google.cloud.dialogflow.v2beta1.Agent result =
          new com.google.cloud.dialogflow.v2beta1.Agent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.Agent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.defaultLanguageCode_ = defaultLanguageCode_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        supportedLanguageCodes_.makeImmutable();
        result.supportedLanguageCodes_ = supportedLanguageCodes_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.timeZone_ = timeZone_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.avatarUri_ = avatarUri_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.enableLogging_ = enableLogging_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.matchMode_ = matchMode_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.classificationThreshold_ = classificationThreshold_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.apiVersion_ = apiVersion_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.tier_ = tier_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.Agent) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.Agent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.Agent other) {
      if (other == com.google.cloud.dialogflow.v2beta1.Agent.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDefaultLanguageCode().isEmpty()) {
        defaultLanguageCode_ = other.defaultLanguageCode_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.supportedLanguageCodes_.isEmpty()) {
        if (supportedLanguageCodes_.isEmpty()) {
          supportedLanguageCodes_ = other.supportedLanguageCodes_;
          bitField0_ |= 0x00000008;
        } else {
          ensureSupportedLanguageCodesIsMutable();
          supportedLanguageCodes_.addAll(other.supportedLanguageCodes_);
        }
        onChanged();
      }
      if (!other.getTimeZone().isEmpty()) {
        timeZone_ = other.timeZone_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getAvatarUri().isEmpty()) {
        avatarUri_ = other.avatarUri_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.getEnableLogging() != false) {
        setEnableLogging(other.getEnableLogging());
      }
      if (other.matchMode_ != 0) {
        setMatchModeValue(other.getMatchModeValue());
      }
      if (other.getClassificationThreshold() != 0F) {
        setClassificationThreshold(other.getClassificationThreshold());
      }
      if (other.apiVersion_ != 0) {
        setApiVersionValue(other.getApiVersionValue());
      }
      if (other.tier_ != 0) {
        setTierValue(other.getTierValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                defaultLanguageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSupportedLanguageCodesIsMutable();
                supportedLanguageCodes_.add(s);
                break;
              } // case 34
            case 42:
              {
                timeZone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                avatarUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                enableLogging_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                matchMode_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 85:
              {
                classificationThreshold_ = input.readFloat();
                bitField0_ |= 0x00000200;
                break;
              } // case 85
            case 112:
              {
                apiVersion_ = input.readEnum();
                bitField0_ |= 0x00000400;
                break;
              } // case 112
            case 120:
              {
                tier_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 120
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The project of this agent.
     * Format: `projects/&lt;Project ID&gt;` or
     *         `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The project of this agent.
     * Format: `projects/&lt;Project ID&gt;` or
     *         `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The project of this agent.
     * Format: `projects/&lt;Project ID&gt;` or
     *         `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The project of this agent.
     * Format: `projects/&lt;Project ID&gt;` or
     *         `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The project of this agent.
     * Format: `projects/&lt;Project ID&gt;` or
     *         `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of this agent.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of this agent.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of this agent.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of this agent.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of this agent.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object defaultLanguageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. The default language of the agent as a language tag. See
     * [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be
     * set by the `Update` method.
     * </pre>
     *
     * <code>string default_language_code = 3;</code>
     *
     * @return The defaultLanguageCode.
     */
    public java.lang.String getDefaultLanguageCode() {
      java.lang.Object ref = defaultLanguageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultLanguageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The default language of the agent as a language tag. See
     * [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be
     * set by the `Update` method.
     * </pre>
     *
     * <code>string default_language_code = 3;</code>
     *
     * @return The bytes for defaultLanguageCode.
     */
    public com.google.protobuf.ByteString getDefaultLanguageCodeBytes() {
      java.lang.Object ref = defaultLanguageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The default language of the agent as a language tag. See
     * [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be
     * set by the `Update` method.
     * </pre>
     *
     * <code>string default_language_code = 3;</code>
     *
     * @param value The defaultLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultLanguageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The default language of the agent as a language tag. See
     * [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be
     * set by the `Update` method.
     * </pre>
     *
     * <code>string default_language_code = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultLanguageCode() {
      defaultLanguageCode_ = getDefaultInstance().getDefaultLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The default language of the agent as a language tag. See
     * [Language
     * Support](https://cloud.google.com/dialogflow/docs/reference/language)
     * for a list of the currently supported language codes. This field cannot be
     * set by the `Update` method.
     * </pre>
     *
     * <code>string default_language_code = 3;</code>
     *
     * @param value The bytes for defaultLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultLanguageCode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList supportedLanguageCodes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSupportedLanguageCodesIsMutable() {
      if (!supportedLanguageCodes_.isModifiable()) {
        supportedLanguageCodes_ =
            new com.google.protobuf.LazyStringArrayList(supportedLanguageCodes_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @return A list containing the supportedLanguageCodes.
     */
    public com.google.protobuf.ProtocolStringList getSupportedLanguageCodesList() {
      supportedLanguageCodes_.makeImmutable();
      return supportedLanguageCodes_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @return The count of supportedLanguageCodes.
     */
    public int getSupportedLanguageCodesCount() {
      return supportedLanguageCodes_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The supportedLanguageCodes at the given index.
     */
    public java.lang.String getSupportedLanguageCodes(int index) {
      return supportedLanguageCodes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the supportedLanguageCodes at the given index.
     */
    public com.google.protobuf.ByteString getSupportedLanguageCodesBytes(int index) {
      return supportedLanguageCodes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The supportedLanguageCodes to set.
     * @return This builder for chaining.
     */
    public Builder setSupportedLanguageCodes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedLanguageCodesIsMutable();
      supportedLanguageCodes_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param value The supportedLanguageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedLanguageCodes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSupportedLanguageCodesIsMutable();
      supportedLanguageCodes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param values The supportedLanguageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addAllSupportedLanguageCodes(java.lang.Iterable<java.lang.String> values) {
      ensureSupportedLanguageCodesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, supportedLanguageCodes_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSupportedLanguageCodes() {
      supportedLanguageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The list of all languages supported by this agent (except for the
     * `default_language_code`).
     * </pre>
     *
     * <code>repeated string supported_language_codes = 4;</code>
     *
     * @param value The bytes of the supportedLanguageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addSupportedLanguageCodesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSupportedLanguageCodesIsMutable();
      supportedLanguageCodes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object timeZone_ = "";
    /**
     *
     *
     * <pre>
     * Required. The time zone of this agent from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5;</code>
     *
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of this agent from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5;</code>
     *
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of this agent from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5;</code>
     *
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      timeZone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of this agent from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {
      timeZone_ = getDefaultInstance().getTimeZone();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The time zone of this agent from the
     * [time zone database](https://www.iana.org/time-zones), e.g.,
     * America/New_York, Europe/Paris.
     * </pre>
     *
     * <code>string time_zone = 5;</code>
     *
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      timeZone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The description of this agent.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of this agent.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of this agent.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of this agent.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The description of this agent.
     * The maximum length is 500 characters. If exceeded, the request is rejected.
     * </pre>
     *
     * <code>string description = 6;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object avatarUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The URI of the agent's avatar.
     * Avatars are used throughout the Dialogflow console and in the self-hosted
     * [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @return The avatarUri.
     */
    public java.lang.String getAvatarUri() {
      java.lang.Object ref = avatarUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        avatarUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The URI of the agent's avatar.
     * Avatars are used throughout the Dialogflow console and in the self-hosted
     * [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @return The bytes for avatarUri.
     */
    public com.google.protobuf.ByteString getAvatarUriBytes() {
      java.lang.Object ref = avatarUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        avatarUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The URI of the agent's avatar.
     * Avatars are used throughout the Dialogflow console and in the self-hosted
     * [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @param value The avatarUri to set.
     * @return This builder for chaining.
     */
    public Builder setAvatarUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      avatarUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The URI of the agent's avatar.
     * Avatars are used throughout the Dialogflow console and in the self-hosted
     * [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvatarUri() {
      avatarUri_ = getDefaultInstance().getAvatarUri();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The URI of the agent's avatar.
     * Avatars are used throughout the Dialogflow console and in the self-hosted
     * [Web
     * Demo](https://cloud.google.com/dialogflow/docs/integrations/web-demo)
     * integration.
     * </pre>
     *
     * <code>string avatar_uri = 7;</code>
     *
     * @param value The bytes for avatarUri to set.
     * @return This builder for chaining.
     */
    public Builder setAvatarUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      avatarUri_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private boolean enableLogging_;
    /**
     *
     *
     * <pre>
     * Optional. Determines whether this agent should log conversation queries.
     * </pre>
     *
     * <code>bool enable_logging = 8;</code>
     *
     * @return The enableLogging.
     */
    @java.lang.Override
    public boolean getEnableLogging() {
      return enableLogging_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines whether this agent should log conversation queries.
     * </pre>
     *
     * <code>bool enable_logging = 8;</code>
     *
     * @param value The enableLogging to set.
     * @return This builder for chaining.
     */
    public Builder setEnableLogging(boolean value) {

      enableLogging_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines whether this agent should log conversation queries.
     * </pre>
     *
     * <code>bool enable_logging = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableLogging() {
      bitField0_ = (bitField0_ & ~0x00000080);
      enableLogging_ = false;
      onChanged();
      return this;
    }

    private int matchMode_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Determines how intents are detected from user queries.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.MatchMode match_mode = 9 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.Agent.match_mode is deprecated. See
     *     google/cloud/dialogflow/v2beta1/agent.proto;l=355
     * @return The enum numeric value on the wire for matchMode.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getMatchModeValue() {
      return matchMode_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines how intents are detected from user queries.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.MatchMode match_mode = 9 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.Agent.match_mode is deprecated. See
     *     google/cloud/dialogflow/v2beta1/agent.proto;l=355
     * @param value The enum numeric value on the wire for matchMode to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setMatchModeValue(int value) {
      matchMode_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines how intents are detected from user queries.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.MatchMode match_mode = 9 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.Agent.match_mode is deprecated. See
     *     google/cloud/dialogflow/v2beta1/agent.proto;l=355
     * @return The matchMode.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.dialogflow.v2beta1.Agent.MatchMode getMatchMode() {
      com.google.cloud.dialogflow.v2beta1.Agent.MatchMode result =
          com.google.cloud.dialogflow.v2beta1.Agent.MatchMode.forNumber(matchMode_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.Agent.MatchMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines how intents are detected from user queries.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.MatchMode match_mode = 9 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.Agent.match_mode is deprecated. See
     *     google/cloud/dialogflow/v2beta1/agent.proto;l=355
     * @param value The matchMode to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setMatchMode(com.google.cloud.dialogflow.v2beta1.Agent.MatchMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      matchMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Determines how intents are detected from user queries.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.MatchMode match_mode = 9 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.dialogflow.v2beta1.Agent.match_mode is deprecated. See
     *     google/cloud/dialogflow/v2beta1/agent.proto;l=355
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearMatchMode() {
      bitField0_ = (bitField0_ & ~0x00000100);
      matchMode_ = 0;
      onChanged();
      return this;
    }

    private float classificationThreshold_;
    /**
     *
     *
     * <pre>
     * Optional. To filter out false positive results and still get variety in
     * matched natural language inputs for your agent, you can tune the machine
     * learning classification threshold. If the returned score value is less than
     * the threshold value, then a fallback intent will be triggered or, if there
     * are no fallback intents defined, no intent will be triggered. The score
     * values range from 0.0 (completely uncertain) to 1.0 (completely certain).
     * If set to 0.0, the default of 0.3 is used.
     * </pre>
     *
     * <code>float classification_threshold = 10;</code>
     *
     * @return The classificationThreshold.
     */
    @java.lang.Override
    public float getClassificationThreshold() {
      return classificationThreshold_;
    }
    /**
     *
     *
     * <pre>
     * Optional. To filter out false positive results and still get variety in
     * matched natural language inputs for your agent, you can tune the machine
     * learning classification threshold. If the returned score value is less than
     * the threshold value, then a fallback intent will be triggered or, if there
     * are no fallback intents defined, no intent will be triggered. The score
     * values range from 0.0 (completely uncertain) to 1.0 (completely certain).
     * If set to 0.0, the default of 0.3 is used.
     * </pre>
     *
     * <code>float classification_threshold = 10;</code>
     *
     * @param value The classificationThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setClassificationThreshold(float value) {

      classificationThreshold_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. To filter out false positive results and still get variety in
     * matched natural language inputs for your agent, you can tune the machine
     * learning classification threshold. If the returned score value is less than
     * the threshold value, then a fallback intent will be triggered or, if there
     * are no fallback intents defined, no intent will be triggered. The score
     * values range from 0.0 (completely uncertain) to 1.0 (completely certain).
     * If set to 0.0, the default of 0.3 is used.
     * </pre>
     *
     * <code>float classification_threshold = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClassificationThreshold() {
      bitField0_ = (bitField0_ & ~0x00000200);
      classificationThreshold_ = 0F;
      onChanged();
      return this;
    }

    private int apiVersion_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. API version displayed in Dialogflow console. If not specified,
     * V2 API is assumed. Clients are free to query different service endpoints
     * for different API versions. However, bots connectors and webhook calls will
     * follow the specified API version.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.ApiVersion api_version = 14;</code>
     *
     * @return The enum numeric value on the wire for apiVersion.
     */
    @java.lang.Override
    public int getApiVersionValue() {
      return apiVersion_;
    }
    /**
     *
     *
     * <pre>
     * Optional. API version displayed in Dialogflow console. If not specified,
     * V2 API is assumed. Clients are free to query different service endpoints
     * for different API versions. However, bots connectors and webhook calls will
     * follow the specified API version.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.ApiVersion api_version = 14;</code>
     *
     * @param value The enum numeric value on the wire for apiVersion to set.
     * @return This builder for chaining.
     */
    public Builder setApiVersionValue(int value) {
      apiVersion_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. API version displayed in Dialogflow console. If not specified,
     * V2 API is assumed. Clients are free to query different service endpoints
     * for different API versions. However, bots connectors and webhook calls will
     * follow the specified API version.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.ApiVersion api_version = 14;</code>
     *
     * @return The apiVersion.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Agent.ApiVersion getApiVersion() {
      com.google.cloud.dialogflow.v2beta1.Agent.ApiVersion result =
          com.google.cloud.dialogflow.v2beta1.Agent.ApiVersion.forNumber(apiVersion_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.Agent.ApiVersion.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. API version displayed in Dialogflow console. If not specified,
     * V2 API is assumed. Clients are free to query different service endpoints
     * for different API versions. However, bots connectors and webhook calls will
     * follow the specified API version.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.ApiVersion api_version = 14;</code>
     *
     * @param value The apiVersion to set.
     * @return This builder for chaining.
     */
    public Builder setApiVersion(com.google.cloud.dialogflow.v2beta1.Agent.ApiVersion value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000400;
      apiVersion_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. API version displayed in Dialogflow console. If not specified,
     * V2 API is assumed. Clients are free to query different service endpoints
     * for different API versions. However, bots connectors and webhook calls will
     * follow the specified API version.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.ApiVersion api_version = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApiVersion() {
      bitField0_ = (bitField0_ & ~0x00000400);
      apiVersion_ = 0;
      onChanged();
      return this;
    }

    private int tier_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.Tier tier = 15;</code>
     *
     * @return The enum numeric value on the wire for tier.
     */
    @java.lang.Override
    public int getTierValue() {
      return tier_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.Tier tier = 15;</code>
     *
     * @param value The enum numeric value on the wire for tier to set.
     * @return This builder for chaining.
     */
    public Builder setTierValue(int value) {
      tier_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.Tier tier = 15;</code>
     *
     * @return The tier.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.Agent.Tier getTier() {
      com.google.cloud.dialogflow.v2beta1.Agent.Tier result =
          com.google.cloud.dialogflow.v2beta1.Agent.Tier.forNumber(tier_);
      return result == null ? com.google.cloud.dialogflow.v2beta1.Agent.Tier.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.Tier tier = 15;</code>
     *
     * @param value The tier to set.
     * @return This builder for chaining.
     */
    public Builder setTier(com.google.cloud.dialogflow.v2beta1.Agent.Tier value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      tier_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The agent tier. If not specified, TIER_STANDARD is assumed.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.Agent.Tier tier = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTier() {
      bitField0_ = (bitField0_ & ~0x00000800);
      tier_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.Agent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.Agent)
  private static final com.google.cloud.dialogflow.v2beta1.Agent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.Agent();
  }

  public static com.google.cloud.dialogflow.v2beta1.Agent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Agent> PARSER =
      new com.google.protobuf.AbstractParser<Agent>() {
        @java.lang.Override
        public Agent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Agent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Agent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.Agent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
