/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dialogflow/v2beta1/conversation.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dialogflow.v2beta1;

/**
 *
 *
 * <pre>
 * Represents a SearchKnowledge answer.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer}
 */
public final class SearchKnowledgeAnswer extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer)
    SearchKnowledgeAnswerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchKnowledgeAnswer.newBuilder() to construct.
  private SearchKnowledgeAnswer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchKnowledgeAnswer() {
    answer_ = "";
    answerType_ = 0;
    answerSources_ = java.util.Collections.emptyList();
    answerRecord_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchKnowledgeAnswer();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dialogflow.v2beta1.ConversationProto
        .internal_static_google_cloud_dialogflow_v2beta1_SearchKnowledgeAnswer_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dialogflow.v2beta1.ConversationProto
        .internal_static_google_cloud_dialogflow_v2beta1_SearchKnowledgeAnswer_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.class,
            com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of the answer.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType}
   */
  public enum AnswerType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The answer has a unspecified type.
     * </pre>
     *
     * <code>ANSWER_TYPE_UNSPECIFIED = 0;</code>
     */
    ANSWER_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The answer is from FAQ documents.
     * </pre>
     *
     * <code>FAQ = 1;</code>
     */
    FAQ(1),
    /**
     *
     *
     * <pre>
     * The answer is from generative model.
     * </pre>
     *
     * <code>GENERATIVE = 2;</code>
     */
    GENERATIVE(2),
    /**
     *
     *
     * <pre>
     * The answer is from intent matching.
     * </pre>
     *
     * <code>INTENT = 3;</code>
     */
    INTENT(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The answer has a unspecified type.
     * </pre>
     *
     * <code>ANSWER_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int ANSWER_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The answer is from FAQ documents.
     * </pre>
     *
     * <code>FAQ = 1;</code>
     */
    public static final int FAQ_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The answer is from generative model.
     * </pre>
     *
     * <code>GENERATIVE = 2;</code>
     */
    public static final int GENERATIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The answer is from intent matching.
     * </pre>
     *
     * <code>INTENT = 3;</code>
     */
    public static final int INTENT_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AnswerType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AnswerType forNumber(int value) {
      switch (value) {
        case 0:
          return ANSWER_TYPE_UNSPECIFIED;
        case 1:
          return FAQ;
        case 2:
          return GENERATIVE;
        case 3:
          return INTENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AnswerType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AnswerType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<AnswerType>() {
          public AnswerType findValueByNumber(int number) {
            return AnswerType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final AnswerType[] VALUES = values();

    public static AnswerType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AnswerType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType)
  }

  public interface AnswerSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The title of the article.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The title.
     */
    java.lang.String getTitle();
    /**
     *
     *
     * <pre>
     * The title of the article.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The bytes for title.
     */
    com.google.protobuf.ByteString getTitleBytes();

    /**
     *
     *
     * <pre>
     * The URI of the article.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The uri.
     */
    java.lang.String getUri();
    /**
     *
     *
     * <pre>
     * The URI of the article.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The bytes for uri.
     */
    com.google.protobuf.ByteString getUriBytes();

    /**
     *
     *
     * <pre>
     * The relevant snippet of the article.
     * </pre>
     *
     * <code>string snippet = 3;</code>
     *
     * @return The snippet.
     */
    java.lang.String getSnippet();
    /**
     *
     *
     * <pre>
     * The relevant snippet of the article.
     * </pre>
     *
     * <code>string snippet = 3;</code>
     *
     * @return The bytes for snippet.
     */
    com.google.protobuf.ByteString getSnippetBytes();

    /**
     *
     *
     * <pre>
     * Metadata associated with the article.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 5;</code>
     *
     * @return Whether the metadata field is set.
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Metadata associated with the article.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 5;</code>
     *
     * @return The metadata.
     */
    com.google.protobuf.Struct getMetadata();
    /**
     *
     *
     * <pre>
     * Metadata associated with the article.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 5;</code>
     */
    com.google.protobuf.StructOrBuilder getMetadataOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The sources of the answers.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource}
   */
  public static final class AnswerSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource)
      AnswerSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnswerSource.newBuilder() to construct.
    private AnswerSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnswerSource() {
      title_ = "";
      uri_ = "";
      snippet_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnswerSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_SearchKnowledgeAnswer_AnswerSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_SearchKnowledgeAnswer_AnswerSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.class,
              com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.Builder.class);
    }

    private int bitField0_;
    public static final int TITLE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object title_ = "";
    /**
     *
     *
     * <pre>
     * The title of the article.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The title.
     */
    @java.lang.Override
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The title of the article.
     * </pre>
     *
     * <code>string title = 1;</code>
     *
     * @return The bytes for title.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int URI_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * The URI of the article.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The uri.
     */
    @java.lang.Override
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the article.
     * </pre>
     *
     * <code>string uri = 2;</code>
     *
     * @return The bytes for uri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SNIPPET_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object snippet_ = "";
    /**
     *
     *
     * <pre>
     * The relevant snippet of the article.
     * </pre>
     *
     * <code>string snippet = 3;</code>
     *
     * @return The snippet.
     */
    @java.lang.Override
    public java.lang.String getSnippet() {
      java.lang.Object ref = snippet_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        snippet_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The relevant snippet of the article.
     * </pre>
     *
     * <code>string snippet = 3;</code>
     *
     * @return The bytes for snippet.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSnippetBytes() {
      java.lang.Object ref = snippet_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        snippet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int METADATA_FIELD_NUMBER = 5;
    private com.google.protobuf.Struct metadata_;
    /**
     *
     *
     * <pre>
     * Metadata associated with the article.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 5;</code>
     *
     * @return Whether the metadata field is set.
     */
    @java.lang.Override
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metadata associated with the article.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 5;</code>
     *
     * @return The metadata.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getMetadata() {
      return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Metadata associated with the article.
     * </pre>
     *
     * <code>.google.protobuf.Struct metadata = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getMetadataOrBuilder() {
      return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, title_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(snippet_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, snippet_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(5, getMetadata());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, title_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(snippet_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, snippet_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMetadata());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource)) {
        return super.equals(obj);
      }
      com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource other =
          (com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource) obj;

      if (!getTitle().equals(other.getTitle())) return false;
      if (!getUri().equals(other.getUri())) return false;
      if (!getSnippet().equals(other.getSnippet())) return false;
      if (hasMetadata() != other.hasMetadata()) return false;
      if (hasMetadata()) {
        if (!getMetadata().equals(other.getMetadata())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getTitle().hashCode();
      hash = (37 * hash) + URI_FIELD_NUMBER;
      hash = (53 * hash) + getUri().hashCode();
      hash = (37 * hash) + SNIPPET_FIELD_NUMBER;
      hash = (53 * hash) + getSnippet().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The sources of the answers.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource)
        com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProto
            .internal_static_google_cloud_dialogflow_v2beta1_SearchKnowledgeAnswer_AnswerSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProto
            .internal_static_google_cloud_dialogflow_v2beta1_SearchKnowledgeAnswer_AnswerSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.class,
                com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        title_ = "";
        uri_ = "";
        snippet_ = "";
        metadata_ = null;
        if (metadataBuilder_ != null) {
          metadataBuilder_.dispose();
          metadataBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dialogflow.v2beta1.ConversationProto
            .internal_static_google_cloud_dialogflow_v2beta1_SearchKnowledgeAnswer_AnswerSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource
          getDefaultInstanceForType() {
        return com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource build() {
        com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource buildPartial() {
        com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource result =
            new com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.title_ = title_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.uri_ = uri_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.snippet_ = snippet_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource) {
          return mergeFrom(
              (com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource other) {
        if (other
            == com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource
                .getDefaultInstance()) return this;
        if (!other.getTitle().isEmpty()) {
          title_ = other.title_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getUri().isEmpty()) {
          uri_ = other.uri_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getSnippet().isEmpty()) {
          snippet_ = other.snippet_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  title_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  uri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  snippet_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 42:
                {
                  input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object title_ = "";
      /**
       *
       *
       * <pre>
       * The title of the article.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The title.
       */
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The title of the article.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return The bytes for title.
       */
      public com.google.protobuf.ByteString getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The title of the article.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @param value The title to set.
       * @return This builder for chaining.
       */
      public Builder setTitle(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        title_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The title of the article.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTitle() {
        title_ = getDefaultInstance().getTitle();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The title of the article.
       * </pre>
       *
       * <code>string title = 1;</code>
       *
       * @param value The bytes for title to set.
       * @return This builder for chaining.
       */
      public Builder setTitleBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        title_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object uri_ = "";
      /**
       *
       *
       * <pre>
       * The URI of the article.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return The uri.
       */
      public java.lang.String getUri() {
        java.lang.Object ref = uri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URI of the article.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return The bytes for uri.
       */
      public com.google.protobuf.ByteString getUriBytes() {
        java.lang.Object ref = uri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          uri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URI of the article.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @param value The uri to set.
       * @return This builder for chaining.
       */
      public Builder setUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        uri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URI of the article.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUri() {
        uri_ = getDefaultInstance().getUri();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URI of the article.
       * </pre>
       *
       * <code>string uri = 2;</code>
       *
       * @param value The bytes for uri to set.
       * @return This builder for chaining.
       */
      public Builder setUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        uri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object snippet_ = "";
      /**
       *
       *
       * <pre>
       * The relevant snippet of the article.
       * </pre>
       *
       * <code>string snippet = 3;</code>
       *
       * @return The snippet.
       */
      public java.lang.String getSnippet() {
        java.lang.Object ref = snippet_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          snippet_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The relevant snippet of the article.
       * </pre>
       *
       * <code>string snippet = 3;</code>
       *
       * @return The bytes for snippet.
       */
      public com.google.protobuf.ByteString getSnippetBytes() {
        java.lang.Object ref = snippet_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          snippet_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The relevant snippet of the article.
       * </pre>
       *
       * <code>string snippet = 3;</code>
       *
       * @param value The snippet to set.
       * @return This builder for chaining.
       */
      public Builder setSnippet(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        snippet_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The relevant snippet of the article.
       * </pre>
       *
       * <code>string snippet = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSnippet() {
        snippet_ = getDefaultInstance().getSnippet();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The relevant snippet of the article.
       * </pre>
       *
       * <code>string snippet = 3;</code>
       *
       * @param value The bytes for snippet to set.
       * @return This builder for chaining.
       */
      public Builder setSnippetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        snippet_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.Struct metadata_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Metadata associated with the article.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 5;</code>
       *
       * @return Whether the metadata field is set.
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Metadata associated with the article.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 5;</code>
       *
       * @return The metadata.
       */
      public com.google.protobuf.Struct getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Metadata associated with the article.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 5;</code>
       */
      public Builder setMetadata(com.google.protobuf.Struct value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata associated with the article.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 5;</code>
       */
      public Builder setMetadata(com.google.protobuf.Struct.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata associated with the article.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 5;</code>
       */
      public Builder mergeMetadata(com.google.protobuf.Struct value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && metadata_ != null
              && metadata_ != com.google.protobuf.Struct.getDefaultInstance()) {
            getMetadataBuilder().mergeFrom(value);
          } else {
            metadata_ = value;
          }
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        if (metadata_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata associated with the article.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 5;</code>
       */
      public Builder clearMetadata() {
        bitField0_ = (bitField0_ & ~0x00000008);
        metadata_ = null;
        if (metadataBuilder_ != null) {
          metadataBuilder_.dispose();
          metadataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata associated with the article.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 5;</code>
       */
      public com.google.protobuf.Struct.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Metadata associated with the article.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 5;</code>
       */
      public com.google.protobuf.StructOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null ? com.google.protobuf.Struct.getDefaultInstance() : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Metadata associated with the article.
       * </pre>
       *
       * <code>.google.protobuf.Struct metadata = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource)
    private static final com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource();
    }

    public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnswerSource> PARSER =
        new com.google.protobuf.AbstractParser<AnswerSource>() {
          @java.lang.Override
          public AnswerSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AnswerSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnswerSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ANSWER_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object answer_ = "";
  /**
   *
   *
   * <pre>
   * The piece of text from the knowledge base documents that answers
   * the search query
   * </pre>
   *
   * <code>string answer = 1;</code>
   *
   * @return The answer.
   */
  @java.lang.Override
  public java.lang.String getAnswer() {
    java.lang.Object ref = answer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      answer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The piece of text from the knowledge base documents that answers
   * the search query
   * </pre>
   *
   * <code>string answer = 1;</code>
   *
   * @return The bytes for answer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnswerBytes() {
    java.lang.Object ref = answer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      answer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANSWER_TYPE_FIELD_NUMBER = 2;
  private int answerType_ = 0;
  /**
   *
   *
   * <pre>
   * The type of the answer.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType answer_type = 2;</code>
   *
   * @return The enum numeric value on the wire for answerType.
   */
  @java.lang.Override
  public int getAnswerTypeValue() {
    return answerType_;
  }
  /**
   *
   *
   * <pre>
   * The type of the answer.
   * </pre>
   *
   * <code>.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType answer_type = 2;</code>
   *
   * @return The answerType.
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType getAnswerType() {
    com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType result =
        com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType.forNumber(answerType_);
    return result == null
        ? com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType.UNRECOGNIZED
        : result;
  }

  public static final int ANSWER_SOURCES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource>
      answerSources_;
  /**
   *
   *
   * <pre>
   * All sources used to generate the answer.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource>
      getAnswerSourcesList() {
    return answerSources_;
  }
  /**
   *
   *
   * <pre>
   * All sources used to generate the answer.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSourceOrBuilder>
      getAnswerSourcesOrBuilderList() {
    return answerSources_;
  }
  /**
   *
   *
   * <pre>
   * All sources used to generate the answer.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
   * </code>
   */
  @java.lang.Override
  public int getAnswerSourcesCount() {
    return answerSources_.size();
  }
  /**
   *
   *
   * <pre>
   * All sources used to generate the answer.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource getAnswerSources(
      int index) {
    return answerSources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All sources used to generate the answer.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSourceOrBuilder
      getAnswerSourcesOrBuilder(int index) {
    return answerSources_.get(index);
  }

  public static final int ANSWER_RECORD_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object answerRecord_ = "";
  /**
   *
   *
   * <pre>
   * The name of the answer record.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;location ID&gt;/answer
   * Records/&lt;Answer Record ID&gt;`
   * </pre>
   *
   * <code>string answer_record = 5;</code>
   *
   * @return The answerRecord.
   */
  @java.lang.Override
  public java.lang.String getAnswerRecord() {
    java.lang.Object ref = answerRecord_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      answerRecord_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the answer record.
   * Format: `projects/&lt;Project ID&gt;/locations/&lt;location ID&gt;/answer
   * Records/&lt;Answer Record ID&gt;`
   * </pre>
   *
   * <code>string answer_record = 5;</code>
   *
   * @return The bytes for answerRecord.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnswerRecordBytes() {
    java.lang.Object ref = answerRecord_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      answerRecord_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, answer_);
    }
    if (answerType_
        != com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType
            .ANSWER_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, answerType_);
    }
    for (int i = 0; i < answerSources_.size(); i++) {
      output.writeMessage(3, answerSources_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerRecord_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, answerRecord_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, answer_);
    }
    if (answerType_
        != com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType
            .ANSWER_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, answerType_);
    }
    for (int i = 0; i < answerSources_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, answerSources_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerRecord_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, answerRecord_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer)) {
      return super.equals(obj);
    }
    com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer other =
        (com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer) obj;

    if (!getAnswer().equals(other.getAnswer())) return false;
    if (answerType_ != other.answerType_) return false;
    if (!getAnswerSourcesList().equals(other.getAnswerSourcesList())) return false;
    if (!getAnswerRecord().equals(other.getAnswerRecord())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ANSWER_FIELD_NUMBER;
    hash = (53 * hash) + getAnswer().hashCode();
    hash = (37 * hash) + ANSWER_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + answerType_;
    if (getAnswerSourcesCount() > 0) {
      hash = (37 * hash) + ANSWER_SOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerSourcesList().hashCode();
    }
    hash = (37 * hash) + ANSWER_RECORD_FIELD_NUMBER;
    hash = (53 * hash) + getAnswerRecord().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a SearchKnowledge answer.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer)
      com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_SearchKnowledgeAnswer_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_SearchKnowledgeAnswer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.class,
              com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.Builder.class);
    }

    // Construct using com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      answer_ = "";
      answerType_ = 0;
      if (answerSourcesBuilder_ == null) {
        answerSources_ = java.util.Collections.emptyList();
      } else {
        answerSources_ = null;
        answerSourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      answerRecord_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dialogflow.v2beta1.ConversationProto
          .internal_static_google_cloud_dialogflow_v2beta1_SearchKnowledgeAnswer_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer getDefaultInstanceForType() {
      return com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer build() {
      com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer buildPartial() {
      com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer result =
          new com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer result) {
      if (answerSourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          answerSources_ = java.util.Collections.unmodifiableList(answerSources_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.answerSources_ = answerSources_;
      } else {
        result.answerSources_ = answerSourcesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.answer_ = answer_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.answerType_ = answerType_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.answerRecord_ = answerRecord_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer) {
        return mergeFrom((com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer other) {
      if (other == com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.getDefaultInstance())
        return this;
      if (!other.getAnswer().isEmpty()) {
        answer_ = other.answer_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.answerType_ != 0) {
        setAnswerTypeValue(other.getAnswerTypeValue());
      }
      if (answerSourcesBuilder_ == null) {
        if (!other.answerSources_.isEmpty()) {
          if (answerSources_.isEmpty()) {
            answerSources_ = other.answerSources_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureAnswerSourcesIsMutable();
            answerSources_.addAll(other.answerSources_);
          }
          onChanged();
        }
      } else {
        if (!other.answerSources_.isEmpty()) {
          if (answerSourcesBuilder_.isEmpty()) {
            answerSourcesBuilder_.dispose();
            answerSourcesBuilder_ = null;
            answerSources_ = other.answerSources_;
            bitField0_ = (bitField0_ & ~0x00000004);
            answerSourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAnswerSourcesFieldBuilder()
                    : null;
          } else {
            answerSourcesBuilder_.addAllMessages(other.answerSources_);
          }
        }
      }
      if (!other.getAnswerRecord().isEmpty()) {
        answerRecord_ = other.answerRecord_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                answer_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                answerType_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource m =
                    input.readMessage(
                        com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource
                            .parser(),
                        extensionRegistry);
                if (answerSourcesBuilder_ == null) {
                  ensureAnswerSourcesIsMutable();
                  answerSources_.add(m);
                } else {
                  answerSourcesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 42:
              {
                answerRecord_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object answer_ = "";
    /**
     *
     *
     * <pre>
     * The piece of text from the knowledge base documents that answers
     * the search query
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @return The answer.
     */
    public java.lang.String getAnswer() {
      java.lang.Object ref = answer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The piece of text from the knowledge base documents that answers
     * the search query
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @return The bytes for answer.
     */
    public com.google.protobuf.ByteString getAnswerBytes() {
      java.lang.Object ref = answer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The piece of text from the knowledge base documents that answers
     * the search query
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @param value The answer to set.
     * @return This builder for chaining.
     */
    public Builder setAnswer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      answer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The piece of text from the knowledge base documents that answers
     * the search query
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnswer() {
      answer_ = getDefaultInstance().getAnswer();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The piece of text from the knowledge base documents that answers
     * the search query
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @param value The bytes for answer to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      answer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int answerType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType answer_type = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for answerType.
     */
    @java.lang.Override
    public int getAnswerTypeValue() {
      return answerType_;
    }
    /**
     *
     *
     * <pre>
     * The type of the answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType answer_type = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for answerType to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerTypeValue(int value) {
      answerType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType answer_type = 2;
     * </code>
     *
     * @return The answerType.
     */
    @java.lang.Override
    public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType getAnswerType() {
      com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType result =
          com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType.forNumber(
              answerType_);
      return result == null
          ? com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType answer_type = 2;
     * </code>
     *
     * @param value The answerType to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerType(
        com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      answerType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the answer.
     * </pre>
     *
     * <code>.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerType answer_type = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnswerType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      answerType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource>
        answerSources_ = java.util.Collections.emptyList();

    private void ensureAnswerSourcesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        answerSources_ =
            new java.util.ArrayList<
                com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource>(
                answerSources_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource,
            com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.Builder,
            com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSourceOrBuilder>
        answerSourcesBuilder_;

    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource>
        getAnswerSourcesList() {
      if (answerSourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(answerSources_);
      } else {
        return answerSourcesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public int getAnswerSourcesCount() {
      if (answerSourcesBuilder_ == null) {
        return answerSources_.size();
      } else {
        return answerSourcesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource getAnswerSources(
        int index) {
      if (answerSourcesBuilder_ == null) {
        return answerSources_.get(index);
      } else {
        return answerSourcesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public Builder setAnswerSources(
        int index, com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource value) {
      if (answerSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswerSourcesIsMutable();
        answerSources_.set(index, value);
        onChanged();
      } else {
        answerSourcesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public Builder setAnswerSources(
        int index,
        com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.Builder
            builderForValue) {
      if (answerSourcesBuilder_ == null) {
        ensureAnswerSourcesIsMutable();
        answerSources_.set(index, builderForValue.build());
        onChanged();
      } else {
        answerSourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public Builder addAnswerSources(
        com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource value) {
      if (answerSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswerSourcesIsMutable();
        answerSources_.add(value);
        onChanged();
      } else {
        answerSourcesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public Builder addAnswerSources(
        int index, com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource value) {
      if (answerSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswerSourcesIsMutable();
        answerSources_.add(index, value);
        onChanged();
      } else {
        answerSourcesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public Builder addAnswerSources(
        com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.Builder
            builderForValue) {
      if (answerSourcesBuilder_ == null) {
        ensureAnswerSourcesIsMutable();
        answerSources_.add(builderForValue.build());
        onChanged();
      } else {
        answerSourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public Builder addAnswerSources(
        int index,
        com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.Builder
            builderForValue) {
      if (answerSourcesBuilder_ == null) {
        ensureAnswerSourcesIsMutable();
        answerSources_.add(index, builderForValue.build());
        onChanged();
      } else {
        answerSourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public Builder addAllAnswerSources(
        java.lang.Iterable<
                ? extends com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource>
            values) {
      if (answerSourcesBuilder_ == null) {
        ensureAnswerSourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, answerSources_);
        onChanged();
      } else {
        answerSourcesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public Builder clearAnswerSources() {
      if (answerSourcesBuilder_ == null) {
        answerSources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        answerSourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public Builder removeAnswerSources(int index) {
      if (answerSourcesBuilder_ == null) {
        ensureAnswerSourcesIsMutable();
        answerSources_.remove(index);
        onChanged();
      } else {
        answerSourcesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.Builder
        getAnswerSourcesBuilder(int index) {
      return getAnswerSourcesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSourceOrBuilder
        getAnswerSourcesOrBuilder(int index) {
      if (answerSourcesBuilder_ == null) {
        return answerSources_.get(index);
      } else {
        return answerSourcesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSourceOrBuilder>
        getAnswerSourcesOrBuilderList() {
      if (answerSourcesBuilder_ != null) {
        return answerSourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(answerSources_);
      }
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.Builder
        addAnswerSourcesBuilder() {
      return getAnswerSourcesFieldBuilder()
          .addBuilder(
              com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.Builder
        addAnswerSourcesBuilder(int index) {
      return getAnswerSourcesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * All sources used to generate the answer.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource answer_sources = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.Builder>
        getAnswerSourcesBuilderList() {
      return getAnswerSourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource,
            com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.Builder,
            com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSourceOrBuilder>
        getAnswerSourcesFieldBuilder() {
      if (answerSourcesBuilder_ == null) {
        answerSourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource,
                com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSource.Builder,
                com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer.AnswerSourceOrBuilder>(
                answerSources_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        answerSources_ = null;
      }
      return answerSourcesBuilder_;
    }

    private java.lang.Object answerRecord_ = "";
    /**
     *
     *
     * <pre>
     * The name of the answer record.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;location ID&gt;/answer
     * Records/&lt;Answer Record ID&gt;`
     * </pre>
     *
     * <code>string answer_record = 5;</code>
     *
     * @return The answerRecord.
     */
    public java.lang.String getAnswerRecord() {
      java.lang.Object ref = answerRecord_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answerRecord_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the answer record.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;location ID&gt;/answer
     * Records/&lt;Answer Record ID&gt;`
     * </pre>
     *
     * <code>string answer_record = 5;</code>
     *
     * @return The bytes for answerRecord.
     */
    public com.google.protobuf.ByteString getAnswerRecordBytes() {
      java.lang.Object ref = answerRecord_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answerRecord_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the answer record.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;location ID&gt;/answer
     * Records/&lt;Answer Record ID&gt;`
     * </pre>
     *
     * <code>string answer_record = 5;</code>
     *
     * @param value The answerRecord to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerRecord(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      answerRecord_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the answer record.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;location ID&gt;/answer
     * Records/&lt;Answer Record ID&gt;`
     * </pre>
     *
     * <code>string answer_record = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnswerRecord() {
      answerRecord_ = getDefaultInstance().getAnswerRecord();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the answer record.
     * Format: `projects/&lt;Project ID&gt;/locations/&lt;location ID&gt;/answer
     * Records/&lt;Answer Record ID&gt;`
     * </pre>
     *
     * <code>string answer_record = 5;</code>
     *
     * @param value The bytes for answerRecord to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerRecordBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      answerRecord_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer)
  private static final com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer();
  }

  public static com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchKnowledgeAnswer> PARSER =
      new com.google.protobuf.AbstractParser<SearchKnowledgeAnswer>() {
        @java.lang.Override
        public SearchKnowledgeAnswer parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchKnowledgeAnswer> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchKnowledgeAnswer> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dialogflow.v2beta1.SearchKnowledgeAnswer getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
